#!/bin/sh
#
# Copyright 2015-2016 RnD Center "ELVEES", JSC
# SPDX-License-Identifier: BSD-2-Clause
#
# Author: Vasiliy Zasukhin <vzasukhin@elvees.com>
#
# Script set new core voltage for regulator FAN53555UC04. Regulator is used in boards:
# * MC802
# * MC805
# * SBCDBG
# * SBCVM
# * Salute-D1
# * Salute-D2
# * VIP1-Eva
# * VIP1-3D

if [ $# -lt 1 -o "$1" == "--help" ]; then
    echo "Usage: mcom-set-core-voltage.sh <voltage> [I2CBUS]"
    echo "voltage - new voltage"
    echo "I2CBUS  - number of i2c bus where connected regulator (default: 0)"
    echo "Example: mcom-set-core-voltage.sh 1.1"
    exit 1
fi


V=$1
I2CBUS=${2:-0}

# Voltage step and offset for regulator FAN53555UC04
STEP=0.012826
OFFSET=0.603

# Formula for converting voltage to register value: VALUE = (V - 0.603) / 0.012826
VALUE=`echo $V $OFFSET $STEP | awk 'END { printf "%.0f\n", ($1 - $2) / $3 }'`

if [ $VALUE -gt 46 ]; then
    echo "Voltage is too high"
    exit 1
fi

if [ $VALUE -lt 1 ]; then
    echo "Voltage is too low"
    exit 1
fi

# Formula for converting register value to voltage: V = VALUE * 0.012826 + 0.603
V=`echo $VALUE $STEP $OFFSET | awk 'END { printf "%.3f\n", $1 * $2 + $3 }'`

# Save high bits (BUCK_EN and MODE) unchanged
OLD_VALUE=`i2cget -y $I2CBUS 0x60 0`
RESULT=$?
if [ $RESULT != 0 ]; then
    echo "fail"
    exit 1
fi
VALUE=`echo $((OLD_VALUE)) $VALUE | awk 'END { printf "%#x\n", or(and($1, 0xc0), $2) }'`

echo "Setting core voltage $V V"

i2cset -y $I2CBUS 0x60 0 $VALUE
RESULT=$?
if [ $RESULT == 0 ]; then
    echo "done"
else
    echo "fail"
    exit 1
fi
