// Copyright 2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл со вспомогательными функциями
 */

#ifndef COMMON_H
#define COMMON_H

/// Генерация входного сигнала типа float
void create_spectrum(float *dst,            ///< [out] выходные данные
                     const int size,        ///< [in] размер сигнала в комплексных элементах
                     const int freq,        ///< [in] частота сигнала
                     const float amplitude  ///< [in] амплитуда сигнала
);
/// Сравнение векторов типа float
/// @return максимум-норма
float maximum_norm(const float *dsp_res,  ///< [in] входные данные
                   const float *ref_res,  ///< [in] входные данные
                   const int size         ///< [in] размер входных данных в комплексных элементах
);
/// Сравнение векторов типа float в тесте двумерной свертки
/// @return максимум-норма
float maximum_norm_conv2d(const float *dsp_res,  ///< [in] входные данные
                          const float *ref_res,  ///< [in] входные данные
                          const int rows,        ///< [in] количество строк входных данных
                          const int cols         ///< [in] количество комплексных элементов в строке входных данных
);
/// Печать вектора типа float
void print_vector(float *src,     ///< [in] входные данные
                  const int size  ///< [in] размер входных данных в комплексных элементах
);
/// Печать вектора типа float в файл
void print_vector_to_file(float *src,      ///< [in] входные данные
                          const int size,  ///< [in] размер входных данных в комплексных элементах
                          char path[]      ///< [in] путь для печати вектора
);
/// Генерация двумерного входного сигнала
void create_spectrum_2d(float *dst,          ///< [out] выходные данные
                        const int height,    ///< [in] количество строк входных данных
                        const int length,    ///< [in] количество комплексных элементов в строке входных данных
                        const int freq1,     ///< [in] частота по высоте
                        const int freq2,     ///< [in] частота по ширине
                        const int data_type  ///< [in] тип данных преобразования
);

#endif
