// Copyright 2025 RnD Center "ELVEES", JSC

#include "helper_for_cpp_tests.hpp"

void print_table_header() {
  std::cout << "| func name              ";
  std::cout << "| element count  ";
  std::cout << "| ref tic    ";
#ifdef PRINT_INSTR
  std::cout << "| ref instr  ";
#endif
  std::cout << "| opt tic    ";
#ifdef PRINT_INSTR
  std::cout << "| opt instr  ";
#endif

  std::cout << "| TI tic     ";
  std::cout << "| byte/tic opt ";
  std::cout << "| byte/tic TI  ";
  std::cout << "| status |\n";
  std::cout
      << "-------------------------------------------------------------------------------------------------------"
         "------------------\n";
}

void print_performance(uint32_t* ref_tic_count, uint32_t* ref_instruction_count, uint32_t* tic_count,
                       uint32_t* instruction_count, int32_t input_bytes, int32_t ti_tics) {
  std::cout << std::setw(11) << ref_tic_count[1] - ref_tic_count[0] << " |";
#ifdef PRINT_INSTR
  std::cout << std::setw(11) << ref_instruction_count[1] - ref_instruction_count[0] << " |";
#endif
  std::cout << std::setw(11) << tic_count[1] - tic_count[0] << " |";
#ifdef PRINT_INSTR
  std::cout << std::setw(11) << instruction_count[1] - instruction_count[0] << " |";
#endif
  if (ti_tics)
    std::cout << std::setw(11) << ti_tics << " |";
  else
    std::cout << "          - |";

  std::cout.precision(5);

  std::cout << std::setw(13) << 1.0 * input_bytes / (tic_count[1] - tic_count[0]) << " |";

  if (ti_tics)
    std::cout << std::setw(13) << 1.0 * input_bytes / ti_tics << " |";
  else
    std::cout << "            - |";
}
