// Copyright 2024-2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл c функциями задания размера тайлов
 *  \author Фролов Андрей
 */

#ifndef TILE_LENGTH_SETTERS
#define TILE_LENGTH_SETTERS

#include "elcore50-dsplib/tile_segmentation.hpp"

/*!
 *  \fn void SetAddTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetAddTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 7168;
}

/*!
 *  \fn void SetAddTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetAddTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 7168;
}

/*!
 *  \fn void SetAddTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetAddTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 6144;
}

/*!
 *  \fn void SetAddTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetAddTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 9216;
}

/*!
 *  \fn void SetNegTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetNegTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 7168;
}

/*!
 *  \fn void SetNegTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetNegTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetNegTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetNegTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetNegTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetNegTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 1024;
}

/*!
 *  \fn void SetMinValTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMinValTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetMinValTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMinValTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetMinValTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMinValTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetMinValTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMinValTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetMaxValTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMaxValTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetMaxValTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMaxValTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetMaxValTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMaxValTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetMaxValTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetMaxValTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetDotprodTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetDotprodTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetDotprodTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetDotprodTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetVecSumSqTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetVecSumSqTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetVecSumSqTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetVecSumSqTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetVecSumSqTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetVecSumSqTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetVecSumSqTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetVecSumSqTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetWVecTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                      TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetWVecTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetWVecTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetWVecTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetWVecTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetWVecTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetWVecTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetWVecTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetDotprodSqrTileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodSqrTileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 8192;
}

/*!
 *  \fn void SetDotprodSqrTileLength(
                 const int32_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodSqrTileLength(const int32_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetDotprodSqrTileLength(
                 const float& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodSqrTileLength(const float& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 4096;
}

/*!
 *  \fn void SetDotprodSqrTileLength(
                 const double& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetDotprodSqrTileLength(const double& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 2048;
}

/*!
 *  \fn void SetRecip16TileLength(
                 const int16_t& first_element, size_t manual_tile_len,
                 TileSegConfig* config)
 *  \brief Установка оптимального размера тайла, либо заданного пользователем
 *  \param[in] first_element входной элемент для определения функции
 *  \param[in] manual_tile_len пользовательский размер тайла
 *  \param[out] config указатель на структуру цепочки
 */
void SetRecip16TileLength(const int16_t& first_element, size_t manual_tile_len, TileSegConfig* config) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 7168;
}

/// Установка оптимального размера тайла, либо заданного пользователем
void SetMul16I16FTileLength(const int32_t& first_element,  ///< [in]  входной элемент для определения функции
                            size_t manual_tile_len,        ///< [in]  пользовательский размер тайла
                            TileSegConfig* config          ///< [out] указатель на структуру цепочки
) {
  if (manual_tile_len)
    config->tile_length = manual_tile_len;
  else
    config->tile_length = 3072;
}

#endif
