#!/usr/bin/env bash
#
# Copyright 2025 RnD Center "ELVEES", JSC
# SPDX-License-Identifier: BSD-2-Clause
#
# This test is used while searching for maximum frequencies of VPU
#

set -eu

set_default() {
    OUTPUT0="/tmp/01.h264"
    OUTPUT1="/tmp/11.h264"
    INPUT="/tmp/01.raw"
    MD5SUM=""
    REPEATS=1
}

set_default

help() {
    cat << EOF
mcom03-vpu-max-freq-test - parallel encoding of 2 sessions with validation
Usage: mcom03-vpu-max-freq-test [options]
Options:
    -h          Show help
    -i          Input raw file 3840x2160 YUV 4:2:0 planar (default: $INPUT)
    -v          MD5SUM for result validation (default: no validation)
    -r          Repeat count (default: $REPEATS)
EOF
}

while getopts "hi:v:r:" arg; do
    case $arg in
        h) set_default; help; exit 0;;
        i) INPUT=$OPTARG;;
        v) MD5SUM=$OPTARG;;
        r) REPEATS=$OPTARG;;
        ?) exit 1;;
    esac
done

for ((i = 0; i < REPEATS; i++)); do
    selfie --component:op=encode:fmt=h264:yuvfmt=420planar:in=$INPUT:out=$OUTPUT0:width=3840:height=2160:qp=46 \
           --component:op=encode:fmt=h264:yuvfmt=420planar:in=$INPUT:out=$OUTPUT1:width=3840:height=2160:qp=46

    if [ -n "$MD5SUM" ]; then
        if [ "$(md5sum $OUTPUT0 | cut -d ' ' -f 1)" != "$MD5SUM" ]; then
            exit 1
        fi

        if [ "$(md5sum $OUTPUT1 | cut -d ' ' -f 1)" != "$MD5SUM" ]; then
            exit 1
        fi
    fi
done
