// Copyright 2025 RnD Center "ELVEES", JSC

#include "tests_tile_segmentation.hpp"

template <typename Type, class create_func, class ref_func, class run_calc_ptr, class cmp_func>
bool test_max_val(Type* src, create_func create_vector, ref_func reference, run_calc_ptr run_calc, cmp_func comparator,
                  int size, int* localmem) {
  create_vector(src, size, 0);

  FLUSH_ALL_CACHES();
  uint32_t tic_count[2], instruction_count[2];
  count_tics(tic_count, instruction_count);
  Type ref_res = reference(src, size);
  count_tics(&tic_count[1], &instruction_count[1]);

  std::cout << "Ref func result (size = " << size << "): tic = " << tic_count[1] - tic_count[0]
            << " instr = " << instruction_count[1] - instruction_count[0] << std::endl;

  TileSegConfig config;
  CreateTileSegConfigMaxVal(src, size, &config, localmem);
  FLUSH_ALL_CACHES();

  count_tics(tic_count, instruction_count);
  Type opt_res = run_calc(&config);
  count_tics(&tic_count[1], &instruction_count[1]);

  std::cout << "Opt func result (size = " << size << "): tic = " << tic_count[1] - tic_count[0]
            << " instr = " << instruction_count[1] - instruction_count[0] << std::endl;

  int ret = comparator(&ref_res, &opt_res, 1);
  return ret;
}

int main() {
  disable_l2_cache();

  void* src = memalign(64, SIZE * sizeof(int64_t));

  int ret = 0;
  int test_status = 0;

  for (int i = 1; i <= SIZE; i *= 2) {
    std::cout << "maxval_s16" << std::endl;
#ifdef USE_REF_VER
    ret = test_max_val(static_cast<int16_t*>(src), create_vector_s16, ref_maxval, RunCalculationMaxVal16, compare_s16,
                       i, &__local_mem);
#else
    ret = test_max_val(static_cast<int16_t*>(src), create_vector_s16, maxval, RunCalculationMaxVal16, compare_s16, i,
                       &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "maxval16 error!\n";

    std::cout << "maxval_s32" << std::endl;
#ifdef USE_REF_VER
    ret = test_max_val(static_cast<int32_t*>(src), create_vector_s32, ref_maxval32, RunCalculationMaxVal32,
                       compare_s32, i, &__local_mem);
#else
    ret = test_max_val(static_cast<int32_t*>(src), create_vector_s32, maxval32, RunCalculationMaxVal32, compare_s32, i,
                       &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "maxval32 error!\n";

    std::cout << "maxval_fl" << std::endl;
#ifdef USE_REF_VER
    ret = test_max_val(static_cast<float*>(src), create_vector_float, ref_maxval_fl, RunCalculationMaxValFl,
                       compare_float, i, &__local_mem);
#else
    ret = test_max_val(static_cast<float*>(src), create_vector_float, maxval_fl, RunCalculationMaxValFl, compare_float,
                       i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "maxval_fl error!\n";

    std::cout << "maxval_db" << std::endl;
#ifdef USE_REF_VER
    ret = test_max_val(static_cast<double*>(src), create_vector_double, ref_maxval_db, RunCalculationMaxValDb,
                       compare_double, i, &__local_mem);
#else
    ret = test_max_val(static_cast<double*>(src), create_vector_double, maxval_db, RunCalculationMaxValDb,
                       compare_double, i, &__local_mem);
#endif

    test_status |= ret;
    if (ret) std::cout << "maxval_db error!\n";

    if (!test_status)
      std::cout << "Test passed" << std::endl;
    else
      std::cout << "Test failed" << std::endl;
  }

  free(src);

  enable_l2_cache(L2_CACHE_SIZE);

  return test_status;
}
