# Copyright 2024-2025 RnD Center "ELVEES", JSC

import os
import pytest
import subprocess


@pytest.mark.parametrize(
    "test_name",
    [
        pytest.param("test_convolution_fl16"),
        pytest.param("test_mat_mul_fl16"),
        pytest.param("test_mat_mul_fl32"),
        pytest.param("test_winograd_fl16"),
        pytest.param("test_winograd_vs_conv_fl16"),
        pytest.param("test_matmul"),
        pytest.param("test_matmul_perf_f16"),
    ],
)
def test_matrix_lib(test_name):
    binary_path = os.path.join(os.path.dirname(__file__) + "/elf/", test_name + ".elf")
    subprocess.run(
        ["elcorecl-run", "-e", binary_path],
        check=True,
        timeout=100,
    )
