// Copyright 2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл с функциями тестирования библиотеки
 */

#ifndef TEST_H
#define TEST_H

#include <elcore50-signal-lib/fft.h>
#include <elcore50-signal-lib/reference.h>
#include <elcore50-signal-lib/types_converter.h>

#include "common.h"

/// Тестирование функции вычисления прямого БПФ для типа float
/// @return количество ошибок
int test_fft_float_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                      const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления прямого БПФ для типа float16
/// @return количество ошибок
int test_fft_hfloat_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления прямого БПФ для типа fractional16
/// @return количество ошибок
int test_fft_fract_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                      const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);

/// Тестирование функции вычисления обратного БПФ для типа float
/// @return количество ошибок
int test_ifft_float_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления обратного БПФ для типа float16
/// @return количество ошибок
int test_ifft_hfloat_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                        const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления обратного БПФ для типа fractional16
/// @return количество ошибок
int test_ifft_fract_1d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления прямого двумерного БПФ для типа float
/// @return количество ошибок
int test_fft_float_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                      const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления прямого двумерного БПФ для типа float16
/// @return количество ошибок
int test_fft_hfloat_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления прямого двумерного БПФ для типа fractional16
/// @return количество ошибок
int test_fft_fract_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                      const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления обратного двумерного БПФ для типа float
/// @return количество ошибок
int test_ifft_float_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления обратного двумерного БПФ для типа float16
/// @return количество ошибок
int test_ifft_hfloat_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                        const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);
/// Тестирование функции вычисления обратного двумерного БПФ для типа fractional16
/// @return количество ошибок
int test_ifft_fract_2d(const int fft_min_size,  ///< [in] минимальный размер преобразования в комплексных элементах
                       const int fft_max_size   ///< [in] максимальный размер преобразования в комплексных элементах
);

#endif
