// Copyright 2025 RnD Center "ELVEES", JSC

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>

#include "argparser.h"

void argparser_print_usage()
{
    printf("\t-i    Names of input files divided by space\n");
    printf("\t-o    Names of files with expected results divided by space\n");
}

int8_t argparser(int argc, char* argv[], char *infiles[], char *outfiles[])
{
    int8_t i = 0;
    int8_t infiles_len = 0;
    int8_t outfiles_len = 0;
    while (i < argc) {
        char *key = argv[i++];
        if (!strcmp(key, "-i")) {
            while (strncmp(argv[i], "-", 1) && (i < argc)) {
                infiles[infiles_len++] = argv[i++];
            }
            --i;
        } else if (!strcmp(key, "-o")) {
            while (strncmp(argv[i], "-", 1) && (i < argc)) {
                outfiles[outfiles_len++] = argv[i++];
            }
            --i;
        }
        if (infiles_len && outfiles_len)
            break;
    }
    return infiles_len + outfiles_len;
}

#define KByte 1024
#define BUFFER_SIZE 32 * KByte

int8_t read_data_from_file(float *src, const int32_t size, const char *filename)
{
    char* buffer = (char*)calloc(BUFFER_SIZE, sizeof(char));
    FILE *file = fopen(filename, "rb");
    if (file == NULL) {
        printf("Error: Can not open file %s!\n", filename);
        free(buffer);
        return 1;
    }
    setvbuf(file, buffer, _IOFBF, BUFFER_SIZE);
    fread(src, sizeof(float), size, file);
    fclose(file);
    free(buffer);
    return 0;
}
