# Copyright 2025 RnD Center "ELVEES", JSC

import os
import pytest


def pytest_addoption(parser):
    parser.addoption(
        "--artifacts-path",
        default=os.path.join(os.path.dirname(__file__), "artifacts"),
        help="path to store tests artifacts",
    )


@pytest.fixture(scope="session", autouse=True)
def create_artifacts_dir(request):
    os.makedirs(request.config.getoption("--artifacts-path"), exist_ok=True)
