// Copyright 2025 RnD Center "ELVEES", JSC

/*! \file
 *  \brief Заголовочный файл с референсными функциями библиотеки
 */

#ifndef REFERENCE_H
#define REFERENCE_H

#include <malloc.h>
#include <math.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/// БПФ для типа float
void fft_mod2(const float *x,    ///< [in] входные данные
              float *y,          ///< [out] выходные данные
              const int N,       ///< [in] размер преобразования
              const bool direct  ///< [in] флаг для обратного преобразования
);
/// Изменение порядка бит в номере элемента массива
/// @return новый номер элемента
int reverse_b(int val,        ///< [in] индекс элемента массива
              const int logN  ///< [in] log2 от размера массива
);
/// Преобразование Фурье для типа float
void dft(float *x,    ///< [in] входные данные
         float *y,    ///< [out] выходные данные
         const int N  ///< [in] размер преобразования
);
/// Вычисление циклической свертки
void circle_conv(const float *src0,  ///< [in] первый входной массив
                 const float *src1,  ///< [in] второй входной массив
                 float *dst,         ///< [out] выходные данные
                 const int32_t size  ///< [in] размер свертки
);
/// Вычисление циклической свертки через БПФ
void circle_conv_opt(const float *src0,  ///< [in] первый входной массив
                     const float *src1,  ///< [in] второй входной массив
                     float *dst,         ///< [out] выходные данные
                     const int32_t size  ///< [in] размер свертки
);

#endif
