// Copyright 2024-2025 RnD Center "ELVEES", JSC

#ifndef _CPP_TESTS_H
#define _CPP_TESTS_H

/*! \file
 *  \brief Заголовочный файл c функциями тестирования библиотеки
 *  \author Фролов Андрей
 */

#include "helper_for_cpp_tests.hpp"

extern "C" {
#include <elcore50-dsplib/asm_func.h>
#include <elcore50-dsplib/elcore50.h>
#include <elcore50-dsplib/reference.h>
}

extern int __local_mem;
extern uint32_t xyram_data;

#define LOCAL_MEM
// Количество тестов для каждой из функций. Максимальное количество равно пяти
#define TEST_COUNT 5

#define DISABLE_NEG_TEST_DATA
#define DISABLE_POS_TEST_DATA

/// Тестирование функций c mul
/// @return количество ошибок
template <class T, class ref_func_ptr, class opt_func_ptr>
int test_mul(ref_func_ptr ref_func,  ///< [in]  указатель на референсную функцию
             opt_func_ptr opt_func,  ///< [in]  указатель на оптимизированную функцию
             T* src0,                ///< [in]  указатель на входной массив
             T* src1,                ///< [in]  указатель на входной массив
             T* dst_ref,             ///< [in]  указатель на выходной массив для референсной функции
             T* dst_opt,             ///< [in]  указатель на выходной массив для оптимизированной функции
             int size,               ///< [in]  количество элементов входных массивов
             int32_t input_bytes,    ///< [in]  количество обрабатываемых байтов
             std::string message     ///< [in]  название функции для лога
);

#endif
