# Copyright 2024 RnD Center "ELVEES", JSC

import os
import pytest
import subprocess


@pytest.mark.parametrize(
    "test_name",
    [
        pytest.param("test_add"),
        pytest.param("test_add_tile_seg"),
        pytest.param("test_cplx_func"),
        pytest.param("test_dotprod"),
        pytest.param("test_dotp_sqr"),
        pytest.param("test_dotprod_sqr_tile_seg"),
        pytest.param("test_dotprod_tile_seg"),
        pytest.param("test_mat_mul"),
        pytest.param("test_mat_mul_cplx"),
        pytest.param("test_mat_trans_scalar"),
        pytest.param("test_maxval"),
        pytest.param("test_maxval_tile_seg"),
        pytest.param("test_minval"),
        pytest.param("test_minval_tile_seg"),
        pytest.param("test_mul"),
        pytest.param("test_mul16i16f"),
        pytest.param("test_mul16i16f_tile_seg"),
        pytest.param("test_neg"),
        pytest.param("test_neg_tile_seg"),
        pytest.param("test_recip16"),
        pytest.param("test_recip_tile_seg"),
        pytest.param("test_vecsumsq"),
        pytest.param("test_vecsumsq_tile_seg"),
        pytest.param("test_w_vec"),
        pytest.param("test_w_vec_tile_seg"),
    ],
)
def test_dsplib(test_name):
    binary_path = os.path.join(os.path.dirname(__file__) + "/elf/", test_name + ".elf")
    subprocess.run(
        ["elcorecl-run", "-e", binary_path],
        check=True,
        timeout=20,
    )
