// Copyright 2025 RnD Center "ELVEES", JSC

#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <cmath>
#include <elcore50-matrix-lib/convolution_fl16.hpp>

#define COEF 1

#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#define MAX(a, b) (((a) > (b)) ? (a) : (b))

extern "C" void float16_to_float32(uint16_t* src, float* dst, int size);
extern "C" void float32_to_float16(float* src, uint16_t* dst, int size);

void set_data_tensor(Tensor_fl32* tensor);
void set_data_weight_dyxc(Weight_fl32* weight);
void weight_dyxc_to_yxcd(const Weight_fl32* input, Weight_fl32* output);
void print_tensor(Tensor_fl32* tensor);
int comparator_fl32(float* src0, float* src1, int size, float eps);

extern "C" void float16_to_float32(uint16_t* src, float* dst, int size);
extern "C" void float32_to_float16(float* src, uint16_t* dst, int size);

void tensor_data_copy(Tensor_fl32* src, Tensor_fl32* dst);
void weight_data_copy(Weight_fl32* src, Weight_fl32* dst);
