#!/bin/sh
#
# Copyright 2015-2016 RnD Center "ELVEES", JSC
# SPDX-License-Identifier: BSD-2-Clause
#
# Author: Vasiliy Zasukhin <vzasukhin@elvees.com>
#
# Script reads core voltage from regulator FAN53555UC04. Regulator is used in boards:
# * MC802
# * MC805
# * SBCDBG
# * SBCVM
# * Salute-D1
# * Salute-D2
# * VIP1-Eva
# * VIP1-3D
#

I2CBUS=${1:-0}

if [ "$I2CBUS" == "--help" ]; then
    echo "Usage: mcom-get-core-voltage.sh [I2CBUS]"
    echo "I2CBUS - number of i2c bus where connected regulator (default: 0)"
    exit 1
fi

VALUE=`i2cget -y $I2CBUS 0x60 0`
RESULT=$?
if [ $RESULT != 0 ]; then
    echo "fail"
    exit 1
fi

# Voltage step and offset for regulator FAN53555UC04
STEP=0.012826
OFFSET=0.603

# V = (VALUE & 0x3F) * 0.012826 + 0.603
V=`echo $((VALUE)) $STEP $OFFSET | awk 'END { printf "%.3f\n", and($1, 0x3f) * $2 + $3 }'`

echo "Core voltage is $V V"
