# Первичный загрузчик OTP NOR Flash

Загрузчик программы cpu0 ядра из внешней Flash-памяти

## Описание работы

Программа загрузчика расположена в OTP-памяти по адресу `0x1E000000`.
После сброса cpu0 по умолчанию стартует с этого адреса.
Загрузчик считывает по адресу основного раздела внешней flash `0x18000000` два значения:

```bash
0x18000000 - указатель на стек
0x18000004 - стартовый адрес программы
```
Далее идёт проверка стартового адреса загружаемой программы. Так как предполагается, что внешняя память является NOR Flash, то стартовый адрес программы не должен быть равен `0xffffffff`. При обнаружении такого значения загрузчик переходит в бесконечный цикл ожидания

## Скрипты загрузки и сборки

- **build.sh** - сборка первичного загрузчика, результат сборки помещает в папку `build/`
- **load_bl_to_otp.sh** - сборка первичного загрузчика, прошивка загрузчика и настройка платы на загрузку с **OTP-памяти**

Скрипты принимают два аргумента
- Частота для QSPI XIP. Стоит учитывать, что загрузчик настраивает частоту **FCLK** на **144 МГц**. Соответственно, рекомендуется выбирать значения кратные этой частоте, например **48 МГц**, **36 МГц** и др.
- Режим сборки (**Debug** или **Release**). В случае режима **Debug** программа собирается с флагом оптимизации **-O0**, а сама программа будет загружаться по secure-адресам внутренней **flash-памяти** процессора. При режиме **Release** программа собирается с флагом оптимизации **-Os**, а программа будет загружаться по secure-адресам OTP-памяти

Если не выставлять ни один из параметров, то частота на QSPI будет установлена **48000000 Гц**, а режим сборки - **Release**. Рекомендуемая частота для отладочной платы ELIoT1 BuB - 36 МГц, ELIoT1 MO - 48 МГц.

## Примеры запуска скриптов

Прошивка загрузчика в OTP с QSPI CLK = 48 МГц

```bash
bash load_bl_to_otp.sh
```

Прошивка загрузчика в OTP с QSPI CLK = 36 МГц

```bash
bash load_bl_to_otp.sh 36000000
```

Сборка загрузчика по адресам внутренней Flash с QSPI CLK = 36 МГц

```bash
bash build.sh 36000000 Debug
```

## Настройка необходимого окружения

1. Прописать в переменную PATH путь до папки /bin инструментов сборки
   ARM GCC 10.3.1 версии и выше, чтобы инструменты вызывались из командной
   строки без использования полного пути:

   ```bash
   arm-none-eabi-gdb-py
   arm-none-eabi-gcc
   ```

2. Запустить Openocd в соотвествующей конфигурации для вашей платы, чтобы у отладчика GDB был необходимый доступ.

    ```bash
    openocd -f interface/cmsis-dap.cfg -c 'gdb_port 3333' -f board/eliot1_bub.cfg
    ```

3. Загружаемая программа должна собираться только в начало основного раздела
   OTP по адресам

   ```bash
   0x0E000000 - Non-secure OTP адрес
   0x1E000000 - Secure OTP адрес
   ```
   Первое слово загружаемой программы должно содержать значение указателя стека,
   второе - адрес входа в программу.

4. Если программа собиралась для внутренней Flash-памяти

    ```bash
   0x00000000 - Non-secure flash адрес
   0x10000000 - Secure flash адрес
   ```
