/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @defgroup sdmmc_spec SD и MMC стандарты
 *
 * @brief Описание стандартов SD и MMC карт
 *
 * Описание команд и регистров карты стандартов:
 * MMC - JESD84-B451
 * SD  - SD Specifications Version 4.10
 */

/*!
 * @addtogroup sdmmc_spec
 * @{
 */

/*!
 * @file hal_sdmmc_spec.h
 */

#ifndef HAL_SDMMC_SPEC_H
#define HAL_SDMMC_SPEC_H

#ifdef  __cplusplus
extern "C" {
#endif

/*!
 * @name Базовые команды SD/MMC карт
 * @{
 */
#define SDMMC_GO_IDLE_STATE               0
#define SDMMC_MMC_SEND_OP_COND            1
#define SDMMC_ALL_SEND_CID                2
#define SDMMC_SET_RELATIVE_ADDR           3
#define SDMMC_SET_DSR                     4
#define SDMMC_MMC_SLEEP_AWAKE             5
#define SDMMC_SWITCH                      6
#define SDMMC_SELECT_CARD                 7
#define SDMMC_MMC_SEND_EXT_CSD            8
#define SDMMC_SD_SEND_IF_COND             8
#define SDMMC_SEND_CSD                    9
#define SDMMC_SEND_CID                    10
#define SDMMC_MMC_READ_DAT_UNTIL_STOP     11
#define SDMMC_SD_VOLTAGE_SWITCH           11
#define SDMMC_STOP_TRANSMISSION           12
#define SDMMC_SEND_STATUS                 13
#define SDMMC_MMC_BUS_TEST_R              14
#define SDMMC_GO_INACTIVE_STATE           15
#define SDMMC_SET_BLOCKLEN                16
#define SDMMC_READ_SINGLE_BLOCK           17
#define SDMMC_READ_MULTIPLE_BLOCK         18
#define SDMMC_SEND_TUNING_BLOCK           19
#define SDMMC_MMC_WRITE_DAT_UNTIL_STOP    20
#define SDMMC_SD_SPEED_CLASS_CONTROL      20
#define SDMMC_MMC_SEND_TUNING_BLOCK_HS200 21
#define SDMMC_SET_BLOCK_COUNT             23
#define SDMMC_WRITE_BLOCK                 24
#define SDMMC_WRITE_MULTIPLE_BLOCK        25
#define SDMMC_MMC_PROGRAM_CID             26
#define SDMMC_PROGRAM_CSD                 27
#define SDMMC_SET_WRITE_PROT              28
#define SDMMC_CLR_WRITE_PROT              29
#define SDMMC_SEND_WRITE_PROT             30
#define SDMMC_SD_ERASE_WR_BLK_START       32
#define SDMMC_SD_ERASE_WR_BLK_END         33
#define SDMMC_MMC_ERASE_GROUP_START       35
#define SDMMC_MMC_ERASE_GROUP_END         36
#define SDMMC_ERASE                       38
#define SDMMC_MMC_FAST_IO                 39
#define SDMMC_MMC_GO_IRQ_STATE            40
#define SDMMC_LOCK_UNLOCK                 42
#define SDMMC_MMC_QUE_TASK_PARAMS         44
#define SDMMC_MMC_QUE_TASK_ADDR           45
#define SDMMC_MMC_EXECUTE_READ_TASK       46
#define SDMMC_MMC_EXECUTE_WRITE_TASK      47
#define SDMMC_MMC_CMDQ_TASK_MGMT          48
#define SDMMC_APP_CMD                     55
#define SDMMC_GEN_CMD                     56
#define SDMMC_SPI_READ_OCR                58
#define SDMMC_SPI_CRC_ON_OFF              59
/*!
 * @}
 */

/*!
 * @name Application-specific команды SD/MMC карт
 * @{
 */
#define SDMMC_ACMD_SET_BUS_WIDTH          6
#define SDMMC_ACMD_SD_STATUS              13
#define SDMMC_ACMD_SET_NUM_WR_BLOCKS      22
#define SDMMC_ACMD_SET_WR_BLK_ERASE_COUNT 23
#define SDMMC_ACMD_SD_SEND_OP_COND        41
#define SDMMC_ACMD_SET_CLR_CARD_DETECT    42
#define SDMMC_ACMD_SEND_SCR               51
/*!
 * @}
 */

/*!
 * @name Статусы SD/MMC карт R1 ответов
 * @{
 */
#define SDMMC_R1_OUT_OF_RANGE       (1 << 31)
#define SDMMC_R1_ADDRESS_ERROR      (1 << 30)
#define SDMMC_R1_BLOCK_LEN_ERROR    (1 << 29)
#define SDMMC_R1_ERASE_SEQ_ERROR    (1 << 28)
#define SDMMC_R1_ERASE_PARAM        (1 << 27)
#define SDMMC_R1_WP_VIOLATION       (1 << 26)
#define SDMMC_R1_CARD_IS_LOCKED     (1 << 25)
#define SDMMC_R1_LOCK_UNLOCK_FAILED (1 << 24)
#define SDMMC_R1_COM_CRC_ERROR      (1 << 23)
#define SDMMC_R1_ILLEGAL_COMMAND    (1 << 22)
#define SDMMC_R1_CARD_ECC_FAILED    (1 << 21)
#define SDMMC_R1_CC_ERROR           (1 << 20)
#define SDMMC_R1_ERROR              (1 << 19)
#define SDMMC_R1_UNDERRUN           (1 << 18)
#define SDMMC_R1_OVERRUN            (1 << 17)
#define SDMMC_R1_CID_CSD_OVERWRITE  (1 << 16)
#define SDMMC_R1_WP_ERASE_SKIP      (1 << 15)
#define SDMMC_R1_CARD_ECC_DISABLED  (1 << 14)
#define SDMMC_R1_ERASE_RESET        (1 << 13)
#define SDMMC_R1_STATUS(x)          (x & 0xFFF9A000)
#define SDMMC_R1_CURRENT_STATE(x)   ((x & 0x00001E00) >> 9)
#define SDMMC_R1_READY_FOR_DATA     (1 << 8)
#define SDMMC_R1_SWITCH_ERROR       (1 << 7)
#define SDMMC_R1_EXCEPTION_EVENT    (1 << 6)
#define SDMMC_R1_APP_CMD            (1 << 5)
/*!
 * @}
 */

/*!
 * @name Состояния SD/MMC карт R1 ответов
 * @{
 */
#define SDMMC_R1_STATE_IDLE  0
#define SDMMC_R1_STATE_READY 1
#define SDMMC_R1_STATE_IDENT 2
#define SDMMC_R1_STATE_STBY  3
#define SDMMC_R1_STATE_TRAN  4
#define SDMMC_R1_STATE_DATA  5
#define SDMMC_R1_STATE_RCV   6
#define SDMMC_R1_STATE_PRG   7
#define SDMMC_R1_STATE_DIS   8
/*!
 * @}
 */

/*!
 * @name Режимы доступа к регистрам MMC группы EXT_CSD
 * @{
 */
#define SDMMC_MMC_ACCESS_MODE_BYTE   0
#define SDMMC_MMC_ACCESS_MODE_SECTOR 2
/*!
 * @}
 */

/*!
 * @name Регистры MMC группы EXT_CSD
 * @{
 */
#define SDMMC_EXT_CSD_ACCESS_CMD_SET              0
#define SDMMC_EXT_CSD_ACCESS_SET_BITS             1
#define SDMMC_EXT_CSD_ACCESS_CLR_BITS             2
#define SDMMC_EXT_CSD_ACCESS_WRITE_BYTE           3
#define SDMMC_EXT_CSD_DATA_WIDTH_OFFSET           183
#define SDMMC_EXT_CSD_DATA_WIDTH_1BIT             0
#define SDMMC_EXT_CSD_DATA_WIDTH_4BIT             1
#define SDMMC_EXT_CSD_DATA_WIDTH_8BIT             2
#define SDMMC_EXT_CSD_DATA_WIDTH_DDR_EN           4
#define SDMMC_EXT_CSD_HS_TIMING_OFFSET            185
#define SDMMC_EXT_CSD_HS_TIMING_EN                1
#define SDMMC_EXT_CSD_CARD_TYPE_OFFSET            196
#define SDMMC_EXT_CSD_CARD_TYPE_HS_MASK           0xF
#define SDMMC_EXT_CSD_CARD_TYPE_HS_MMC_26         (1 << 0)
#define SDMMC_EXT_CSD_CARD_TYPE_HS_MMC_52         (1 << 1)
#define SDMMC_EXT_CSD_CARD_TYPE_HS_DDR_MMC_52     (1 << 2)
#define SDMMC_EXT_CSD_CARD_TYPE_HS_DDR_MMC_52_1V2 (1 << 3)
#define SDMMC_EXT_CSD_SEC_COUNT_OFFSET            212
/*!
 * @}
 */

/*!
 * @name Аргумент для команды установки ширины шины SD карты
 * @{
 */
#define SDMMC_SD_ACMD_SET_BUS_WIDTH_1BIT 0
#define SDMMC_SD_ACMD_SET_BUS_WIDTH_4BIT 2
/*!
 * @}
 */

/*!
 * @brief Регистр CID карты MMC
 */
typedef union {
    uint32_t    val[4];     /*!< Register 128 bit value */
    struct {
        /*!< Splitted, not used, always “1” [0:0] */
        /*!< Splitted, CRC7 checksum [7:1] */
        uint8_t mdt;        /*!< Manufacturing date [15:8] */
        uint8_t psn[4];     /*!< Product serial number [47:16] */
        uint8_t prv;        /*!< Product revision [55:48] */
        uint8_t pnm[6];     /*!< Product name [103:56] */
        uint8_t oid;        /*!< OEM/Application ID [111:104] */
        uint8_t cbx    : 2; /*!< Device/BGA [113:112] */
        uint8_t reserv : 6; /*!< [119:114] */
        uint8_t mid;        /*!< Manufacturer ID [127:120] */
        uint8_t reserv2;    /*!< Align byte */
    };
} __attribute__((packed)) sdmmc_emmc_cid_reg_t;

/*!
 * @brief Регистр CID карты SD
 */
typedef union {
    uint32_t     val[4];   /*!< Register 128 bit value */
    struct {
        /*!< Splitted, not used, always “1” [0:0] */
        /*!< Splitted, CRC7 checksum [7:1] */
        uint32_t mdt : 12; /*!< Manufacturing date [19:8] */
        uint32_t     : 4;  /*!< Reserved [23:20] */
        uint8_t  psn[4];   /*!< Product serial number [55:24] */
        uint8_t  prv;      /*!< Product revision [63:56] */
        uint8_t  pnm[5];   /*!< Product name [103:64] */
        uint8_t  oid[2];   /*!< OEM/Application ID [119:104] */
        uint8_t  mid;      /*!< Manufacturer ID [127:120] */
        uint8_t  reserv;   /*!< Align byte */
    };
} __attribute__((packed)) sdmmc_sd_cid_reg_t;

/*!
 * @brief Регистр CSD карты MMC
 */
typedef union {
    uint32_t      val[4];                  /*!< Register 128 bit value */
    struct {
        /*!< Splitted, not used, always’1’ [0:0] */
        /*!< Splitted, CRC7 checksum [7:1] */
        uint32_t  ecc                 :  2; /*!< ECC code [9:8] */
        uint32_t  file_format         :  2; /*!< File format [11:10] */
        uint32_t  tmp_write_protect   :  1; /*!< Temporary write protection [12:12] */
        uint32_t  perm_write_protect  :  1; /*!< Permanent write protection [13:13] */
        uint32_t  copy                :  1; /*!< Copy flag (OTP) [14:14] */
        uint32_t  file_format_grp     :  1; /*!< File format group [15:15] */
        uint32_t  content_prot_app    :  1; /*!< Content protection application [16:16] */
        uint32_t  reserv              :  4; /*!< [20:17] */
        uint32_t  write_bl_partial    :  1; /*!< Partial blocks for write allowed [21:21] */
        uint32_t  write_bl_len        :  4; /*!< Max. write data block length [25:22] */
        uint32_t  r2w_factor          :  3; /*!< Write speed factor [28:26] */
        uint32_t  default_ecc         :  2; /*!< Manufacturer default ECC [30:29] */
        uint32_t  wp_grp_enable       :  1; /*!< Write protect group enable [31:31] */
        uint32_t  wp_grp_size         :  5; /*!< Write protect group size [36:32] */
        uint32_t  erase_grp_mult_low  :  3; /*!< Erase group size multiplier [41:37] */

        uint32_t  erase_grp_mult_high :  2;
        uint32_t  erase_grp_size      :  5; /*!< Erase group size [46:42] */
        uint32_t  c_size_mult         :  3; /*!< Device size multiplier [49:47] */
        uint32_t  vdd_w_curr_max      :  3; /*!< Max. write current @ VDD max [52:50] */
        uint32_t  vdd_w_curr_min      :  3; /*!< Max. write current @ VDD min [55:53] */
        uint32_t  vdd_r_curr_max      :  3; /*!< Max. read current @ VDD max [58:56] */
        uint32_t  vdd_r_curr_min      :  3; /*!< Max. read current @ VDD min [61:59] */
        uint32_t  c_size_low          : 10; /*!< Device size [71:62] */

        uint32_t  c_size_high         :  2; /*!< Device size [73:72] */
        uint32_t  reserv2             :  2; /*!< [75:74] */
        uint32_t  dsr_imp             :  1; /*!< DSR implemented [76:76] */
        uint32_t  read_blk_misalign   :  1; /*!< Read block misalignment [77:77] */
        uint32_t  write_blk_misalign  :  1; /*!< Write block misalignment [78:78] */
        uint32_t  read_bl_partial     :  1; /*!< Partial blocks for read allowed [79:79] */
        uint32_t  read_bl_len         :  4; /*!< Max. read data block length [80:83] */
        uint32_t  ccc                 : 12; /*!< Device command classes [95:84] */
        uint32_t  tran_speed          :  8; /*!< Max. bus clock frequency [103:96] */

        uint8_t   nsac;                     /*!< Data read access-time 2 in CLK cycles (NSAC*100) [111:104] */
        uint8_t   taac;                     /*!< Data read access-time [119:112] */
        uint8_t   reserv3             :  2; /*!< [121:120] */
        uint8_t   spec_vers           :  4; /*!< System specification version [125:122] */
        uint8_t   csd_structure       :  2; /*!< CSD structure [127:126] */
        uint8_t   reserv4;                  /*!< Align byte */
    };
} __attribute__((packed)) sdmmc_emmc_csd_reg_t;

/*!
 * @brief Регистр CSD карты SD версии 1.0
 */
typedef union {
    uint32_t      val[4];                      /*!< Register 128 bit value */
    struct {
        /*!< Splitted, not used, always’1’ [0:0] */
        /*!< Splitted, CRC7 checksum [7:1] */
        uint32_t                         :  2; /*!< Reserved [9:8] */
        uint32_t  file_format            :  2; /*!< File format [11:10] */
        uint32_t  tmp_write_protect      :  1; /*!< Temporary write protection [12:12] */
        uint32_t  perm_write_protect     :  1; /*!< Permanent write protection [13:13] */
        uint32_t  copy                   :  1; /*!< Copy flag (OTP) [14:14] */
        uint32_t  file_format_grp        :  1; /*!< File format group [15:15] */
        uint32_t                         :  5; /*!< Reserved [20:16] */
        uint32_t  write_bl_partial       :  1; /*!< Partial blocks for write allowed [21:21] */
        uint32_t  write_bl_len           :  4; /*!< Max. write data block length [25:22] */
        uint32_t  r2w_factor             :  3; /*!< Write speed factor [28:26] */
        uint32_t                         :  2; /*!< Reserved [30:29] */
        uint32_t  wp_grp_enable          :  1; /*!< Write protect group enable [31:31] */
        uint32_t  wp_grp_size            :  7; /*!< Write protect group size [38:32] */
        uint32_t  erase_sector_size_low  :  1; /*!< Erase sector size [39:39] */

        uint32_t  erase_sector_size_high :  6; /*!< Erase sector size [45:40] */
        uint32_t  erase_blk_en           :  1; /*!< Erase single block enable [46:46] */
        uint32_t  c_size_mult            :  3; /*!< Device size multiplier [49:47] */
        uint32_t  vdd_w_curr_max         :  3; /*!< Max. write current @ VDD max [52:50] */
        uint32_t  vdd_w_curr_min         :  3; /*!< Max. write current @ VDD min [55:53] */
        uint32_t  vdd_r_curr_max         :  3; /*!< Max. read current @ VDD max [58:56] */
        uint32_t  vdd_r_curr_min         :  3; /*!< Max. read current @ VDD min [61:59] */
        uint32_t  c_size_low             : 10; /*!< Device size [71:62] */

        uint32_t  c_size_high            :  2; /*!< Device size [73:72] */
        uint32_t                         :  2; /*!< Reserved [75:74] */
        uint32_t  dsr_imp                :  1; /*!< DSR implemented [76:76] */
        uint32_t  read_blk_misalign      :  1; /*!< Read block misalignment [77:77] */
        uint32_t  write_blk_misalign     :  1; /*!< Write block misalignment [78:78] */
        uint32_t  read_bl_partial        :  1; /*!< Partial blocks for read allowed [79:79] */
        uint32_t  read_bl_len            :  4; /*!< Max. read data block length [80:83] */
        uint32_t  ccc                    : 12; /*!< Device command classes [95:84] */
        uint32_t  tran_speed             :  8; /*!< Max. bus clock frequency [103:96] */

        uint8_t   nsac;                        /*!< Data read access-time 2 in CLK cycles (NSAC*100) [111:104] */
        uint8_t   taac;                        /*!< Data read access-time [119:112] */
        uint8_t                          :  6; /*!< Reserved [125:120] */
        uint8_t   csd_structure          :  2; /*!< CSD structure [127:126] */
        uint8_t   reserved;                    /*!< Align byte */
    };
} __attribute__((packed)) sdmmc_sd_csd_reg_v1_t;

/*!
 * @brief Регистр CSD карты SD версии 2.0 и выше
 */
typedef union {
    uint32_t      val[4];                      /*!< Register 128 bit value */
    struct {
        /*!< Splitted, not used, always’1’ [0:0] */
        /*!< Splitted, CRC7 checksum [7:1] */
        uint32_t                         :  2; /*!< Reserved [9:8] */
        uint32_t  file_format            :  2; /*!< File format [11:10] */
        uint32_t  tmp_write_protect      :  1; /*!< Temporary write protection [12:12] */
        uint32_t  perm_write_protect     :  1; /*!< Permanent write protection [13:13] */
        uint32_t  copy                   :  1; /*!< Copy flag (OTP) [14:14] */
        uint32_t  file_format_grp        :  1; /*!< File format group [15:15] */
        uint32_t                         :  5; /*!< Reserved [20:16] */
        uint32_t  write_bl_partial       :  1; /*!< Partial blocks for write allowed [21:21] */
        uint32_t  write_bl_len           :  4; /*!< Max. write data block length [25:22] */
        uint32_t  r2w_factor             :  3; /*!< Write speed factor [28:26] */
        uint32_t                         :  2; /*!< Reserved [30:29] */
        uint32_t  wp_grp_enable          :  1; /*!< Write protect group enable [31:31] */
        uint32_t  wp_grp_size            :  7; /*!< Write protect group size [38:32] */
        uint32_t  erase_sector_size_low  :  1; /*!< Erase sector size [39:39] */

        uint32_t  erase_sector_size_high :  6; /*!< Erase sector size [45:40] */
        uint32_t  erase_blk_en           :  1; /*!< Erase single block enable [46:46] */
        uint32_t                         :  1; /*!< Reserved [47:47] */
        uint32_t  c_size                 : 22; /*!< Device size [69:48] */
        uint32_t                         :  2; /*!< Reserved [71:70] */

        uint32_t                         :  4; /*!< Reserved [75:72] */
        uint32_t  dsr_imp                :  1; /*!< DSR implemented [76:76] */
        uint32_t  read_blk_misalign      :  1; /*!< Read block misalignment [77:77] */
        uint32_t  write_blk_misalign     :  1; /*!< Write block misalignment [78:78] */
        uint32_t  read_bl_partial        :  1; /*!< Partial blocks for read allowed [79:79] */
        uint32_t  read_bl_len            :  4; /*!< Max. read data block length [80:83] */
        uint32_t  ccc                    : 12; /*!< Device command classes [95:84] */
        uint32_t  tran_speed             :  8; /*!< Max. bus clock frequency [103:96] */

        uint8_t   nsac                   :  8; /*!< Data read access-time 2 in CLK cycles (NSAC*100) [111:104] */
        uint8_t   taac                   :  8; /*!< Data read access-time [119:112] */
        uint8_t                          :  6; /*!< Reserved [125:120] */
        uint8_t   csd_structure          :  2; /*!< CSD structure [127:126] */
        uint8_t   reserved;                    /*!< Align byte */
    };
} __attribute__((packed)) sdmmc_sd_csd_reg_v2_t;

/*!
 * @brief Аргумент команды SEND_EXT_CSD карты MMC
 */
typedef union {
    uint32_t     arg;
    struct {
        uint32_t cmd    : 3;
        uint32_t        : 5;
        uint32_t value  : 8;
        uint32_t index  : 8;
        uint32_t access : 2;
        uint32_t        : 6;
    };
} sdmmc_mmc_ext_csd_arg_t;

/*!
 * @name Режимы доступа команды SWITCH карты SD
 * @{
 */
#define SDMMC_SD_ACCESS_MODE_CHECK_FUNCTION 0
#define SDMMC_SD_ACCESS_MODE_SET_FUNCTION   1
/*!
 * @}
 */

/*!
 * @brief Аргумент команды SWITCH
 */
typedef union {
    uint32_t     value;
    struct {
        uint32_t access_mode  :  4;
        uint32_t cmd_system   :  4;
        uint32_t drv_strength :  4;
        uint32_t power_limit  :  4;
        uint32_t              : 15;
        uint32_t mode         :  1;
    };
} sdmmc_sd_switch_cmd_t;

/*!
 * @brief Аргумент команды ACMD41 карты SD
 */
typedef union {
    uint32_t     arg;
    struct {
        uint32_t      :  8;
        uint32_t ocr  : 16;
        uint32_t s18r :  1;
        uint32_t      :  3;
        uint32_t xpc  :  1;
        uint32_t fb   :  1;
        uint32_t hcs  :  1;
        uint32_t busy :  1;
    };
} sdmmc_sd_acmd41_arg_t;

/*!
 * @brief Ответ команды ACMD41 карты SD
 */
typedef union {
    uint32_t     value;
    struct {
        uint32_t        :  8;
        uint32_t ocr    : 16;
        uint32_t s18r   :  1;
        uint32_t        :  4;
        uint32_t uhs_ii :  1;
        uint32_t ccs    :  1;
        uint32_t busy   :  1;
    };
} sdmmc_sd_acmd41_resp_t;

/*!
 * @brief OCR регистр карты MMC
 */
typedef union {
    uint32_t     value;
    struct {
        uint32_t              : 7;
        uint32_t vol_1v7_1v95 : 1;
        uint32_t vol_2v0_2v6  : 7;
        uint32_t vol_2v7_3v6  : 9;
        uint32_t              : 5;
        uint32_t access_mode  : 2;
        uint32_t busy         : 1;
    };
} sdmmc_mmc_ocr_reg_t;

/*!
 * @brief Задержки команд
 */
enum {
    SDMMC_Timeout_Min  = 100,  /*!< Минимальная задержка */
    SDMMC_Timeout_Rst  = 5000, /*!< Задержка по сбросу карты */
    SDMMC_Timeout_Pwr  = 8000, /*!< Задержка по переключению питания */
    SDMMC_Timeout_Vol1 = 8000, /*!< Первая задержка при переключении на 1,8 В */
    SDMMC_Timeout_Vol2 = 2000, /*!< Вторая задержка при переключении на 1,8 В */
    SDMMC_Timeout_1ms  = 1000  /*!< Задержка 1 милисекунда */
};

#ifdef  __cplusplus
}
#endif

#endif  /* HAL_SDMMC_SPEC_H */
