/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*
                                                   
        Copyright (c) 2019-2022, RnD Center "ELVEES", JSC\n
        All rights reserved.\n
        Contacts: https://elvees.ru, support@elvees.com\n
        \n
        Project: ELIOT1 H\n
        \n
        SPDX-License-Identifier: BSD-3-Clause\n
        \n
        Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде,
        с изменениями или без, при соблюдении следующих условий:\n
        \n
        1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве,
        этот список условий и последующий отказ от гарантий.\n
        2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
        этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
        распространении.\n
        3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
        продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.\n
        ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ "КАК ОНА ЕСТЬ" 
        БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
        ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
        НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
        РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
        СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
        (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
        ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
        ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.\n
        \n
        Redistribution and use in source and binary forms, with or without modification, are permitted provided 
        that the following conditions are met:\n
        \n
        1. Redistributions of source code must retain the above copyright notice, this list of conditions 
        and the following disclaimer.\n
        2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
        and the following disclaimer in the documentation and/or other materials provided with the distribution.\n
        3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
        or promote products derived from this software without specific prior written permission.\n
        THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
        INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
        ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
        INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
        SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
        AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
        ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
      
 *
 * @brief     ELIOT1 HEADER 
 * @version  1.2.1
 * @note     Generated by svdConverter (Converter of SVD-format to C-header) 2.2.1 on 2025-07-15 12:45:32
 *           from file '/home/nto3buildbot/jenkins/workspace/OT01-1041-disable-gms-in-headers/_eliot1m/result/eliot1m.svd'
 */

/** @addtogroup ELVEES.
  * @{
  */

/** @addtogroup ELIOT1
  * @{
  */

#ifndef ELIOT1M_CM33_CORE1_H
#define ELIOT1M_CM33_CORE1_H

#include <stdint.h>


#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/* =========================================================================================================================== */
/* =============================================== Interrupt Number Definition =============================================== */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
Reset_IRQn                = -15,     /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
NonMaskableInt_IRQn       = -14,     /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
HardFault_IRQn            = -13,     /*!< -13  Hard Fault, all classes of Fault                                     */
MemoryManagement_IRQn     = -12,     /*!< -12  Memory Management, MPU mismatch, including Access Violation and No Match */
BusFault_IRQn             = -11,     /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory related Fault */
UsageFault_IRQn           = -10,     /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
SecureFault_IRQn          =  -9,     /*!< -9 Secure Fault Handler                                                   */
SVCall_IRQn               =  -5,     /*!< -5 System Service Call via SVC instruction                                */
DebugMonitor_IRQn         =  -4,     /*!< -4 Debug Monitor                                                          */
PendSV_IRQn               =  -2,     /*!< -2 Pendable request for system service                                    */
SysTick_IRQn              =  -1,     /*!< -1 System Tick Timer                                                      */
/* ===========================================  ELIOT1 Specific Interrupt Numbers  =========================================== */
NS_WATCHDOG_RESET_IRQn    = 0,       /*!<  Non-Secure Watchdog Reset Request Interrupt                              */
NS_WATCHDOG_IRQn          = 1,       /*!<  Non-Secure Watchdog Interrupt                                            */
LP_TIMER_IRQn             = 2,       /*!<  LP Timer Interrupt                                                       */
TIMER0_IRQn               = 3,       /*!<  CMSDK Timer 0 Interrupt                                                  */
TIMER1_IRQn               = 4,       /*!<  CMSDK Timer 1 Interrupt                                                  */
DUALTIMER_IRQn            = 5,       /*!<  CMSDK Dual Timer Interrupt                                               */
MHU0_IRQn                 = 6,       /*!<  Message Handling Unit 0 Interrupt                                        */
MHU1_IRQn                 = 7,       /*!<  Message Handling Unit 1 Interrupt                                        */
CRYPTOCELL_IRQn           = 8,       /*!<  CryptoCell-312 Interrupt                                                 */
S_MPC_COMBINED_IRQn       = 9,       /*!<  Secure Combined MPC Interrupt                                            */
S_PPC_COMBINED_IRQn       = 10,      /*!<  Secure Combined PPC Interrupt                                            */
S_MSC_COMBINED_IRQn       = 11,      /*!<  Secure Combined MSC Interrupt                                            */
S_BRIDGE_ERR_IRQn         = 12,      /*!<  Secure Bridge Error Combined Interrupt                                   */
I_CACHE_INV_ERR_IRQn      = 13,      /*!<  Instruction Cache Invalidation Interrupt                                 */
/* Reserved               = 14,            Reserved                                                                 */
SYS_PPU_IRQn              = 15,      /*!<  System PPU Interrupt                                                     */
CPU0_PPU_IRQn             = 16,      /*!<  CPU0 PPU Interrupt                                                       */
CPU1_PPU_IRQn             = 17,      /*!<  CPU1 PPU Interrupt                                                       */
/* Reserved               = 18,            Reserved                                                                 */
/* Reserved               = 19,            Reserved                                                                 */
CRYPTOCELL_PPU_IRQn       = 20,      /*!<  CryptoCell PPU Interrupt                                                 */
/* Reserved               = 21,            Reserved                                                                 */
RAM0_PPU_IRQn             = 22,      /*!<  RAM 0 PPU Interrupt                                                      */
RAM1_PPU_IRQn             = 23,      /*!<  RAM 1 PPU Interrupt                                                      */
RAM2_PPU_IRQn             = 24,      /*!<  RAM 2 PPU Interrupt                                                      */
RAM3_PPU_IRQn             = 25,      /*!<  RAM 3 PPU Interrupt                                                      */
DEBUG_PPU_IRQn            = 26,      /*!<  Debug PPU Interrupt                                                      */
/* Reserved               = 27,            Reserved                                                                 */
CPU_CTI_IRQn_0            = 28,      /*!<  CPU CTI Interrupt 0                                                      */
CPU_CTI_IRQn_1            = 29,      /*!<  CPU CTI Interrupt 1                                                      */
/* Reserved               = 30,            Reserved                                                                 */
/* Reserved               = 31,            Reserved                                                                 */
/* ================================== ELIOT1 Specific Expansion Interrupt Numbers  ================================== */
/* None                   = 32,            Not used. Tied to 0                                                      */
UART0_IRQn                = 32,      /*!<  UART0 Interrupt                                                          */
UART1_IRQn                = 33,      /*!<  UART1 Interrupt                                                          */
UART2_IRQn                = 34,      /*!<  UART2 Interrupt                                                          */
UART3_IRQn                = 35,      /*!<  UART3 Interrupt                                                          */
SPI0_IRQn                 = 36,      /*!<  SPI0 Interrupt                                                           */
SPI1_IRQn                 = 37,      /*!<  SPI1 Interrupt                                                           */
SPI2_IRQn                 = 38,      /*!<  SPI2 Interrupt                                                           */
I2C0_IRQn                 = 39,      /*!<  I2C0 Interrupt                                                           */
I2C1_IRQn                 = 40,      /*!<  I2C1 Interrupt                                                           */
I2S_IRQn                  = 41,      /*!<  I2S Interrupt                                                            */
GPIO_0_IRQn               = 42,      /*!<  GPIO 0 Interrupt                                                         */
GPIO_1_IRQn               = 43,      /*!<  GPIO 1 Interrupt                                                         */
GPIO_2_IRQn               = 44,      /*!<  GPIO 2 Interrupt                                                         */
GPIO_3_IRQn               = 45,      /*!<  GPIO 3 Interrupt                                                         */
CAN_IRQn                  = 46,      /*!<  CAN Interrupt                                                            */
PWM_IRQn                  = 47,      /*!<  PWM Interrupt                                                            */
VTU0_IRQn                 = 48,      /*!<  VTU0 Interrupt                                                           */
VTU1_IRQn                 = 49,      /*!<  VTU1 Interrupt                                                           */
FCACHE_IRQn               = 50,      /*!<  FCACHE Interrupt                                                         */
FCTR_IRQn                 = 51,      /*!<  FCTR Interrupt                                                           */
QSPI_IRQn                 = 52,      /*!<  QSPI Interrupt                                                           */
/* Reserved               = 53,            Reserved                                                                 */
GNSS_IRQn                 = 54,      /*!<  GNSS Interrupt                                                           */
DMA0_IRQn                 = 55,      /*!<  DMA0 Interrupt                                                           */
DMA1_IRQn                 = 56,      /*!<  DMA0 Interrupt                                                           */
SDMMC_IRQn                = 57,      /*!<  SDMMC Interrupt                                                          */
USB_IRQn                  = 58,      /*!<  USB Interrupt                                                            */
JTM_IRQn                  = 59,      /*!<  JTM Interrupt                                                            */
GMS_URB_IRQn              = 60,      /*!<  GMS URB Interrupt                                                        */
GMS_DMA_IRQn              = 61,      /*!<  GMS DMA Interrupt                                                        */
GMS_PPU_IRQn              = 62,      /*!<  GMS PPU Interrupt                                                        */
GNSS_PPU_IRQn             = 63,      /*!<  GNSS PPU Interrupt                                                       */
RWC_WKUP_IRQn             = 64,      /*!<  RWC Wakeup Interrupt                                                     */
RWC_TICK_IRQn             = 65,      /*!<  RWC Tick Interrupt                                                       */
RWC_ALARM_IRQn            = 66,      /*!<  RWC Alarm Interrupt                                                      */
DMA0_CH0_IRQn             = 67,      /*!<  DMA0 Channel 0 Interrupt                                                 */
DMA0_CH1_IRQn             = 68,      /*!<  DMA0 Channel 1 Interrupt                                                 */
DMA0_CH2_IRQn             = 69,      /*!<  DMA0 Channel 2 Interrupt                                                 */
DMA0_CH3_IRQn             = 70,      /*!<  DMA0 Channel 3 Interrupt                                                 */
DMA0_CH4_IRQn             = 71,      /*!<  DMA0 Channel 4 Interrupt                                                 */
DMA0_CH5_IRQn             = 72,      /*!<  DMA0 Channel 5 Interrupt                                                 */
DMA0_CH6_IRQn             = 73,      /*!<  DMA0 Channel 6 Interrupt                                                 */
DMA0_CH7_IRQn             = 74,      /*!<  DMA0 Channel 7 Interrupt                                                 */
DMA1_CH0_IRQn             = 75,      /*!<  DMA1 Channel 0 Interrupt                                                 */
DMA1_CH1_IRQn             = 76,      /*!<  DMA1 Channel 1 Interrupt                                                 */
DMA1_CH2_IRQn             = 77,      /*!<  DMA1 Channel 2 Interrupt                                                 */
DMA1_CH3_IRQn             = 78,      /*!<  DMA1 Channel 3 Interrupt                                                 */
DMA1_CH4_IRQn             = 79,      /*!<  DMA1 Channel 4 Interrupt                                                 */
DMA1_CH5_IRQn             = 80,      /*!<  DMA1 Channel 5 Interrupt                                                 */
DMA1_CH6_IRQn             = 81,      /*!<  DMA1 Channel 6 Interrupt                                                 */
DMA1_CH7_IRQn             = 82,      /*!<  DMA1 Channel 7 Interrupt                                                 */
VMON_IRQn                 = 83,      /*!<  Voltage Monitor Interrupt                                                */
SDMMC_WKUP_IRQn           = 84,      /*!<  SDMMC Wakeup Interrupt                                                   */
GPIO_0_NS_IRQn            = 85,      /*!<  GPIO 0 Non-secure Interrupt                                              */
GPIO_1_NS_IRQn            = 86,      /*!<  GPIO 1 Non-secure Interrupt                                              */
GPIO_2_NS_IRQn            = 87,      /*!<  GPIO 2 Non-secure Interrupt                                              */
GPIO_3_NS_IRQn            = 88,      /*!<  GPIO 3 Non-secure Interrupt                                              */
GPIO_0_ACC_IRQn           = 89,      /*!<  GPIO 0 Access Interrupt                                                  */
GPIO_1_ACC_IRQn           = 90,      /*!<  GPIO 1 Access Interrupt                                                  */
GPIO_2_ACC_IRQn           = 91,      /*!<  GPIO 2 Access Interrupt                                                  */
GPIO_3_ACC_IRQn           = 92,      /*!<  GPIO 3 Access Interrupt                                                  */

} IRQn_Type;



/* =========================================================================================================================== */
/* ========================================== Processor and Core Peripheral Section ========================================== */
/* =========================================================================================================================== */

/* ================================= Configuration of the CM33 Processor and Core Peripherals ================================ */
#define __CM33_REV  0x0001U  /*!< CM33 Core Revision */
#define __NVIC_PRIO_BITS         4        /*!< Number of Bits used for Priority Levels                         */
#define __Vendor_SysTickConfig   0        /*!< Set to 1 if different SysTick Config is used                    */
#define __VTOR_PRESENT           1        /*!< Set to 1 if CPU supports Vector Table Offset Register           */
#define __MPU_PRESENT            1        /*!< MPU present                                                     */
#define __FPU_PRESENT            1        /*!< FPU present                                                     */
#define __FPU_DP                 0        /*!< unused, Device has no FPU                                       */
#define __SAUREGION_PRESENT      1        /*!< SAU region present                                              */
#define __DSP_PRESENT            1        /*!< DSP present                                                     */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm33.h" /*!< CM33 processor and core peripherals */
#include "system_ELIOT1.h" /*!< ELIOT1 System */

#ifdef __cplusplus
  #define   __I     volatile             /*!< Defines 'read only' permissions */
#else
  #define   __I     volatile const       /*!< Defines 'read only' permissions */
#endif
#define     __O     volatile             /*!< Defines 'write only' permissions */
#define     __IO    volatile             /*!< Defines 'read / write' permissions */

#ifndef __IM                             /*!< Fallback for older versions */
  #define __IM   __I
#endif
#ifndef __OM                             /*!< Fallback for older versions */
  #define __OM   __O
#endif
#ifndef __IOM                            /*!< Fallback for older versions */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif



/* =========================================================================================================================== */
/* ============================================= Device Specific Cluster Section ============================================= */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_clusters
  * @{
  */


/* =========================================================================================================================== */
/* ================================================= Type of peripheral: TIM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DTIM ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MHU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: ICACHE =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_SECCTRL ============================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_IDENTITY ============================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: SYSINFO =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SYSCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PPU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: WDT ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: IOCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: CLKCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: PWRCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: OTPCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: NSPCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SPCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MPC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: UART ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SPI ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2C ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2S ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GPIO ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: CAN ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PWM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: VTU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: USB ================================================= */
/* =========================================================================================================================== */
/**
  * @brief USB_INEndpoint_Type Auto-generated based on 7 repeated subsets of peripheral with 8 members each
  */
typedef struct {
  __IOM  uint32_t  DIEPCTL;  /*!< (@ 0x00000920) register DIEPCTL1 
Device Control IN Endpoint 1 Control Register

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPINT;  /*!< (@ 0x00000928) register DIEPINT1 
Device IN Endpoint 1 Interrupt Register

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPTSIZ;  /*!< (@ 0x00000930) register DIEPTSIZ1 
Device IN Endpoint 1 Transfer Size Register

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

  __IOM  uint32_t  DIEPDMA;  /*!< (@ 0x00000934) register DIEPDMA1 
Device IN Endpoint 1 DMA Address Register

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

   __IM  uint32_t  DTXFSTS;  /*!< (@ 0x00000938) register DTXFSTS1 
Device IN Endpoint Transmit FIFO Status Register 1

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

   __IM  uint32_t  DIEPDMAB;  /*!< (@ 0x0000093c) register DIEPDMAB1 
Device IN Endpoint 1 Buffer Address Register

Note: This register exists for an endpoint i if the OTG_EP_DIR_i parameter is 0 or 1 for that endpoint. */

} USB_INEndpoint_Type;      /*!< Size = 32 (0x20) */


/**
  * @brief USB_OUTEndpoint_Type Auto-generated based on 7 repeated subsets of peripheral with 8 members each
  */
typedef struct {
  __IOM  uint32_t  DOEPCTL;  /*!< (@ 0x00000b20) register DOEPCTL1 
Device Control OUT Endpoint 1 Control Register */

   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint32_t  DOEPINT;  /*!< (@ 0x00000b28) register DOEPINT1 
Device OUT Endpoint 1 Interrupt Register */

   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  DOEPTSIZ;  /*!< (@ 0x00000b30) register DOEPTSIZ1 
Device OUT Endpoint 1 Transfer Size Register */

  __IOM  uint32_t  DOEPDMA;  /*!< (@ 0x00000b34) register DOEPDMA1 
Device OUT Endpoint 1 DMA Address Register */

   __IM  uint32_t  RESERVED3;  /*!< not covered by register fields! */
   __IM  uint32_t  DOEPDMAB;  /*!< (@ 0x00000b3c) register DOEPDMAB1 
Device OUT Endpoint 1 Buffer Address Register */

} USB_OUTEndpoint_Type;      /*!< Size = 32 (0x20) */


/**
  * @brief USB_DIEPTXF_Type Auto-generated based on 7 repeated subsets of peripheral with 1 members each
  */
typedef struct {
  __IOM  uint32_t  DIEPTXF;  /*!< (@ 0x00000104) register DIEPTXF1 
Device IN Endpoint Transmit FIFO Size Register $i
This register is valid only in dedicated FIFO mode (OTG_EN_DED_TX_FIFO=1). It holds the size and memory start address of IN endpoint TxFIFOs implemented in Device mode. Each FIFO holds the data for one IN endpoint. This register is repeated for instantiated IN endpoint FIFOs 1 to 15. For IN endpoint FIFO 0, use GNPTXFSIZ register for programming the size and memory start address. */

} USB_DIEPTXF_Type;      /*!< Size = 4 (0x4) */


/**
  * @brief USB_HostChan_Type Auto-generated based on 16 repeated subsets of peripheral with 8 members each
  */
typedef struct {
  __IOM  uint32_t  HCCHAR;  /*!< (@ 0x00000500) register HCCHAR0 
Host Channel 0 Characteristics Register */

  __IOM  uint32_t  HCSPLT;  /*!< (@ 0x00000504) register HCSPLT0 
Host Channel 0 Split Control Register */

  __IOM  uint32_t  HCINT;  /*!< (@ 0x00000508) register HCINT0 
"Host Channel $i Interrupt Register"

This register indicates the status of a channel with respect to USB- and AHB-related events. It is shown in the "Interrupt Hierarchy" figure in the databook. The application must read this register when the Host Channels Interrupt bit of the Core Interrupt register (GINTSTS.HChInt) is set. Before the application can read this register, it must first read the Host All Channels Interrupt (HAINT) register to get the exact channel number for the Host Channel-n Interrupt register. The application must clear the appropriate bit in this register to clear the corresponding bits in the HAINT and GINTSTS registers. */

  __IOM  uint32_t  HCINTMSK;  /*!< (@ 0x0000050c) register HCINTMSK0 
"Host Channel $i Interrupt Mask Register"

This register reflects the mask for each channel status described in the previous section. */

  __IOM  uint32_t  HCTSIZ;  /*!< (@ 0x00000510) register HCTSIZ0 
Host Channel 0 Transfer Size Register */

  __IOM  uint32_t  HCDMA;  /*!< (@ 0x00000514) register HCDMA0 
"Host Channel $i DMA Address Register"

This register is used by the OTG host in the internal DMA mode to maintain the current buffer pointer for IN/OUT transactions. The starting DMA address must be DWORD-aligned. */

   __IM  uint32_t  RESERVED;  /*!< not covered by register fields! */
   __IM  uint32_t  HCDMAB;  /*!< (@ 0x0000051c) register HCDMAB0 
"Host Channel $i DMA Buffer Address Register"

This register is present only in case of Scatter/Gather DMA. It is implemented in RAM instead of flop-based implementation. This register holds the current buffer address. */

} USB_HostChan_Type;      /*!< Size = 32 (0x20) */





/* =========================================================================================================================== */
/* =============================================== Type of peripheral: USB_URB =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: QSPI ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GNSS ================================================ */
/* =========================================================================================================================== */
/**
  * @brief GNSS_ADC_Type cluster 'ADC'
  */
typedef struct {
   __IM  uint32_t  SIG1_I;  /*!< (@ 0x00000000) register SIG1_I */
   __IM  uint32_t  SIG1_Q;  /*!< (@ 0x00000004) register SIG1_Q */
   __IM  uint32_t  SIG2_I;  /*!< (@ 0x00000008) register SIG2_I */
   __IM  uint32_t  SIG2_Q;  /*!< (@ 0x0000000c) register SIG2_Q */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000010) register CTRL */
} GNSS_ADC_Type;      /*!< Size = 20 (0x14) */


/**
  * @brief GNSS_CA5__Type cluster 'CA5_%s' (element of array[20])
  */
typedef struct {
  __IOM  uint32_t  PCHIP;  /*!< (@ 0x00000000) register PCHIP */
  __IOM  uint32_t  FHET;  /*!< (@ 0x00000004) register FHET */
  __IOM  uint32_t  CFG1;  /*!< (@ 0x00000008) register CFG1 */
  __IOM  uint32_t  CFG2;  /*!< (@ 0x0000000c) register CFG2 */
} GNSS_CA5__Type;      /*!< Size = 16 (0x10) */


/**
  * @brief GNSS_COL_CA5_Type cluster 'COL_CA5'
  */
typedef struct {
  __IOM  uint32_t  CFG;  /*!< (@ 0x00000000) register CFG */
   __IM  uint32_t  DATA;  /*!< (@ 0x00000004) register DATA */
} GNSS_COL_CA5_Type;      /*!< Size = 8 (0x8) */


/**
  * @brief GNSS_FCHIP_Type cluster 'FCHIP'
  */
typedef struct {
  __IOM  uint32_t  CA5_GPS;  /*!< (@ 0x00000000) register CA5_GPS */
  __IOM  uint32_t  CA5_GLO;  /*!< (@ 0x00000004) register CA5_GLO */
} GNSS_FCHIP_Type;      /*!< Size = 8 (0x8) */


/**
  * @brief GNSS_FSE_Type cluster 'FSE'
  */
typedef struct {
  __IOM  uint32_t  FHET;  /*!< (@ 0x00000000) register FHET */
  __IOM  uint32_t  CFG;  /*!< (@ 0x00000004) register CFG */
  __IOM  uint32_t  ACC;  /*!< (@ 0x00000008) register ACC */
   __OM  uint32_t  PRSIN;  /*!< (@ 0x0000000c) register PRSIN */
   __IM  uint32_t  MAX;  /*!< (@ 0x00000010) register MAX */
   __IM  uint32_t  NCA_RES;  /*!< (@ 0x00000014) register NCA_RES */
  __IOM  uint32_t  FCHIP;  /*!< (@ 0x00000018) register FCHIP */
} GNSS_FSE_Type;      /*!< Size = 28 (0x1c) */


/**
  * @brief GNSS_IMIT_Type cluster 'IMIT'
  */
typedef struct {
  __IOM  uint32_t  PCHIP;  /*!< (@ 0x00000000) register PCHIP */
  __IOM  uint32_t  FDOP;  /*!< (@ 0x00000004) register FDOP */
  __IOM  uint32_t  G1G2;  /*!< (@ 0x00000008) register G1G2 */
  __IOM  uint32_t  CFG;  /*!< (@ 0x0000000c) register CFG */
  __IOM  uint32_t  NPF;  /*!< (@ 0x00000010) register NPF */
} GNSS_IMIT_Type;      /*!< Size = 20 (0x14) */


/**
  * @brief GNSS_IRQ_Type cluster 'IRQ'
  */
typedef struct {
  __IOM  uint32_t  CFG;  /*!< (@ 0x00000000) register CFG */
  __IOM  uint32_t  STAT;  /*!< (@ 0x00000004) register STAT */
   __OM  uint32_t  ACK;  /*!< (@ 0x00000008) register ACK */
} GNSS_IRQ_Type;      /*!< Size = 12 (0xc) */


/**
  * @brief GNSS_ISG_Type cluster 'ISG'
  */
typedef struct {
  __IOM  uint32_t  CHIP;  /*!< (@ 0x00000000) register CHIP */
   __IM  uint32_t  GPS;  /*!< (@ 0x00000004) register GPS */
   __IM  uint32_t  GLO;  /*!< (@ 0x00000008) register GLO */
} GNSS_ISG_Type;      /*!< Size = 12 (0xc) */


/**
  * @brief GNSS_MCC_Type cluster 'MCC'
  */
typedef struct {
   __IM  uint32_t  VERSION;  /*!< (@ 0x00000000) register VERSION */
  __IOM  uint32_t  TEST_RW;  /*!< (@ 0x00000004) register TEST_RW */
} GNSS_MCC_Type;      /*!< Size = 8 (0x8) */


/**
  * @brief GNSS_PPS_Type cluster 'PPS'
  */
typedef struct {
  __IOM  uint32_t  MS;  /*!< (@ 0x00000000) register MS */
  __IOM  uint32_t  OFS;  /*!< (@ 0x00000004) register OFS */
} GNSS_PPS_Type;      /*!< Size = 8 (0x8) */


/**
  * @brief GNSS_TB_Type cluster 'TB'
  */
typedef struct {
  __IOM  uint32_t  ECNT;  /*!< (@ 0x00000000) register ECNT */
  __IOM  uint32_t  MS_CODE;  /*!< (@ 0x00000004) register MS_CODE */
} GNSS_TB_Type;      /*!< Size = 8 (0x8) */





/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SMC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SDMMC ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DMA ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: FCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: FCACHE =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: RWC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: JTM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */


/** @} */ /* End of group Device_Peripheral_clusters */


/* =========================================================================================================================== */
/* ============================================ Device Specific Peripheral Section =========================================== */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripherals
  * @{
  */

/* =========================================================================================================================== */
/* ================================================= Type of peripheral: TIM ================================================= */
/* =========================================================================================================================== */

/**
  * @brief TIM_Type peripheral TIM
  */
typedef struct {    /*!< (@ 0x40000000) TIM Structure */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000000) register CTRL 
Control register */

  __IOM  uint32_t  VALUE;  /*!< (@ 0x00000004) register VALUE 
Current value register */

  __IOM  uint32_t  RELOAD;  /*!< (@ 0x00000008) register RELOAD 
A write to this register sets the current value */


union {
  __IOM  uint32_t  INTCLEAR;  /*!< (@ 0x0000000c) register INTCLEAR 
A write to this register clears the interrupt request. */

   __IM  uint32_t  INTSTATUS;  /*!< (@ 0x0000000c) register INTSTATUS 
Interrupt status register */

};
   __IM  uint32_t  RESERVED0[1008];  /*!< not covered by register fields! */
   __IM  uint32_t  PID4;  /*!< (@ 0x00000fd0) register PID4 
Peripheral identification register 4 */

   __IM  uint32_t  PID5;  /*!< (@ 0x00000fd4) register PID5 
Peripheral identification register 5 */

   __IM  uint32_t  PID6;  /*!< (@ 0x00000fd8) register PID6 
Peripheral identification register 6 */

   __IM  uint32_t  PID7;  /*!< (@ 0x00000fdc) register PID7 
Peripheral identification register 7 */

   __IM  uint32_t  PID0;  /*!< (@ 0x00000fe0) register PID0 
Peripheral identification register 0 */

   __IM  uint32_t  PID1;  /*!< (@ 0x00000fe4) register PID1 
Peripheral identification register 1 */

   __IM  uint32_t  PID2;  /*!< (@ 0x00000fe8) register PID2 
Peripheral identification register 2 */

   __IM  uint32_t  PID3;  /*!< (@ 0x00000fec) register PID3 
Peripheral identification register 3 */

   __IM  uint32_t  CID0;  /*!< (@ 0x00000ff0) register CID0 
Component identification register 0 */

   __IM  uint32_t  CID1;  /*!< (@ 0x00000ff4) register CID1 
Component identification register 1 */

   __IM  uint32_t  CID2;  /*!< (@ 0x00000ff8) register CID2 
Component identification register 2 */

   __IM  uint32_t  CID3;  /*!< (@ 0x00000ffc) register CID3 
Component identification register 3 */

} TIM_Type;     /*!< Size = 4096 (0x1000) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DTIM ================================================ */
/* =========================================================================================================================== */

/**
  * @brief DTIM_Type peripheral DTIM
  */
typedef struct {    /*!< (@ 0x40002000) DTIM Structure */
  __IOM  uint32_t  TIMER1LOAD;  /*!< (@ 0x00000000) register TIMER1LOAD 
Contains the value from which the Timer 1 counter is to decrement. This is the value used to reload the counter when Periodic mode is enabled, and the current count reaches 0. When this register is written to directly, the current count is immediately reset to the new value. */

   __IM  uint32_t  TIMER1VALUE;  /*!< (@ 0x00000004) register TIMER1VALUE 
This register provides the current value of the Timer 1 decrementing counter. */

  __IOM  uint32_t  TIMER1CONTROL;  /*!< (@ 0x00000008) register TIMER1CONTROL 
This is a read or write register */

  __IOM  uint32_t  TIMER1INTCLR;  /*!< (@ 0x0000000c) register TIMER1INTCLR 
A write to the this register clears the interrupt output from Timer 1 counter */

   __IM  uint32_t  TIMER1RIS;  /*!< (@ 0x00000010) register TIMER1RIS 
This register indicates the raw interrupt status from Timer 1 counter. This value is ANDed with the Interrupt enable bit from Timer 1 Control Register to create the masked interrupt, that is passed to the Timer 1 Interrupt output pin.  */

   __IM  uint32_t  TIMER1MIS;  /*!< (@ 0x00000014) register TIMER1MIS 
This register indicates the masked interrupt status from Timer 1 counter. This value is the logical AND of the Raw interrupt status with the Timer interrupt enable bit from Timer 1 Timer Control Register, and is the same value that is passed to the Timer 1 Interrupt output pin. */

  __IOM  uint32_t  TIMER1BGLOAD;  /*!< (@ 0x00000018) register TIMER1BGLOAD 
This register contains the value from which Timer 1 counter is to decrement. This is the value used to reload the Timer 1 counter when Periodic mode is enabled, and the current count reaches 0. This register provides an alternative method of accessing Timer 1 Load value register. The difference is that writes to this register do not cause Timer 1 counter to immediately restart from the new value. Reading from this register returns the same value returned from Timer 1 Load value. */

   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  TIMER2LOAD;  /*!< (@ 0x00000020) register TIMER2LOAD 
Contains the value from which the Timer 2 counter is to decrement. This is the value used to reload the counter when Periodic mode is enabled, and the current count reaches 0. When this register is written to directly, the current count is immediately reset to the new value. */

   __IM  uint32_t  TIMER2VALUE;  /*!< (@ 0x00000024) register TIMER2VALUE 
This register provides the current value of the Timer 2 decrementing counter. */

  __IOM  uint32_t  TIMER2CONTROL;  /*!< (@ 0x00000028) register TIMER2CONTROL 
This is a read or write register */

  __IOM  uint32_t  TIMER2INTCLR;  /*!< (@ 0x0000002c) register TIMER2INTCLR 
A write to the this register clears the interrupt output from Timer 2 counter */

   __IM  uint32_t  TIMER2RIS;  /*!< (@ 0x00000030) register TIMER2RIS 
This register indicates the raw interrupt status from Timer 2 counter. This value is ANDed with the Interrupt enable bit from Timer 2 Control Register to create the masked interrupt, that is passed to the Timer 2 Interrupt output pin.  */

   __IM  uint32_t  TIMER2MIS;  /*!< (@ 0x00000034) register TIMER2MIS 
This register indicates the masked interrupt status from Timer 2 counter. This value is the logical AND of the Raw interrupt status with the Timer interrupt enable bit from Timer 2 Timer Control Register, and is the same value that is passed to the Timer 2 Interrupt output pin. */

  __IOM  uint32_t  TIMER2BGLOAD;  /*!< (@ 0x00000038) register TIMER2BGLOAD 
This register contains the value from which Timer 2 counter is to decrement. This is the value used to reload the Timer 2 counter when Periodic mode is enabled, and the current count reaches 0. This register provides an alternative method of accessing Timer 2 Load value register. The difference is that writes to this register do not cause Timer 2 counter to immediately restart from the new value. Reading from this register returns the same value returned from Timer 2 Load value. */

   __IM  uint32_t  RESERVED1[945];  /*!< not covered by register fields! */
  __IOM  uint32_t  TIMERITCR;  /*!< (@ 0x00000f00) register TIMERITCR 
This register enables Integration test mode. When in this mode, the Integration test output set register directly controls the masked interrupt outputs. The combined interrupt output of Timer 1 and Timer 2 then becomes the logical OR of the interrupt values set in the Integration test output set register. */

  __IOM  uint32_t  TIMERITOP;  /*!< (@ 0x00000f04) register TIMERITOP 
When in Integration test mode, the values in this write-only register directly drive the enabled interrupt outputs of Timer 1 and Timer 2. */

   __IM  uint32_t  RESERVED2[50];  /*!< not covered by register fields! */
   __IM  uint32_t  TIMERPERIPHID4;  /*!< (@ 0x00000fd0) register TIMERPERIPHID4 
Peripheral identification register 4 */

   __IM  uint32_t  TIMERPERIPHID5;  /*!< (@ 0x00000fd4) register TIMERPERIPHID5 
Peripheral identification register 5 (unused) */

   __IM  uint32_t  TIMERPERIPHID6;  /*!< (@ 0x00000fd8) register TIMERPERIPHID6 
Peripheral identification register 6 (unused) */

   __IM  uint32_t  TIMERPERIPHID7;  /*!< (@ 0x00000fdc) register TIMERPERIPHID7 
Peripheral identification register 7 (unused) */

   __IM  uint32_t  TIMERPERIPHID0;  /*!< (@ 0x00000fe0) register TIMERPERIPHID0 
Peripheral identification register 0 */

   __IM  uint32_t  TIMERPERIPHID1;  /*!< (@ 0x00000fe4) register TIMERPERIPHID1 
Peripheral identification register 1 */

   __IM  uint32_t  TIMERPERIPHID2;  /*!< (@ 0x00000fe8) register TIMERPERIPHID2 
Peripheral identification register 2 */

   __IM  uint32_t  TIMERPERIPHID3;  /*!< (@ 0x00000fec) register TIMERPERIPHID3 
Peripheral identification register 3 */

   __IM  uint32_t  TIMERPCELLID0;  /*!< (@ 0x00000ff0) register TIMERPCELLID0 
Component identification register 0 */

   __IM  uint32_t  TIMERPCELLID1;  /*!< (@ 0x00000ff4) register TIMERPCELLID1 
Component identification register 1 */

   __IM  uint32_t  TIMERPCELLID2;  /*!< (@ 0x00000ff8) register TIMERPCELLID2 
Component identification register 2 */

   __IM  uint32_t  TIMERPCELLID3;  /*!< (@ 0x00000ffc) register TIMERPCELLID3 
Component identification register 3 */

} DTIM_Type;     /*!< Size = 4096 (0x1000) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MHU ================================================= */
/* =========================================================================================================================== */

/**
  * @brief MHU_Type peripheral MHU
  */
typedef struct {    /*!< (@ 0x40003000) MHU Structure */
  __IOM  uint32_t  CPU0INTR_STAT;  /*!< (@ 0x00000000) register CPU0INTR_STAT */
  __IOM  uint32_t  CPU0INTR_SET;  /*!< (@ 0x00000004) register CPU0INTR_SET */
  __IOM  uint32_t  CPU0INTR_CLR;  /*!< (@ 0x00000008) register CPU0INTR_CLR */
   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  CPU1INTR_STAT;  /*!< (@ 0x00000010) register CPU1INTR_STAT */
  __IOM  uint32_t  CPU1INTR_SET;  /*!< (@ 0x00000014) register CPU1INTR_SET */
  __IOM  uint32_t  CPU1INTR_CLR;  /*!< (@ 0x00000018) register CPU1INTR_CLR */
} MHU_Type;     /*!< Size = 28 (0x1c) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: ICACHE =============================================== */
/* =========================================================================================================================== */

/**
  * @brief ICACHE_Type peripheral ICACHE
  */
typedef struct {    /*!< (@ 0x50010000) ICACHE Structure */
  __IOM  uint32_t  HWPARAMS;  /*!< (@ 0x00000000) register HWPARAMS */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000004) register CTRL */
   __IM  uint32_t  RESERVED0[62];  /*!< not covered by register fields! */
  __IOM  uint32_t  IRQSTAT;  /*!< (@ 0x00000100) register IRQSTAT */
  __IOM  uint32_t  IRQCLR;  /*!< (@ 0x00000104) register IRQCLR */
  __IOM  uint32_t  IRQEN;  /*!< (@ 0x00000108) register IRQEN */
  __IOM  uint32_t  DBGFILLERR;  /*!< (@ 0x0000010c) register DBGFILLERR */
   __IM  uint32_t  RESERVED1[124];  /*!< not covered by register fields! */
  __IOM  uint32_t  SH;  /*!< (@ 0x00000300) register SH */
  __IOM  uint32_t  SM;  /*!< (@ 0x00000304) register SM */
  __IOM  uint32_t  SUC;  /*!< (@ 0x00000308) register SUC */
} ICACHE_Type;     /*!< Size = 780 (0x30c) */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_SECCTRL ============================================= */
/* =========================================================================================================================== */

/**
  * @brief CPU_SECCTRL_Type peripheral CPU_SECCTRL
  */
typedef struct {    /*!< (@ 0x50011000) CPU_SECCTRL Structure */
  __IOM  uint32_t  CPUSECCFG;  /*!< (@ 0x00000000) register CPUSECCFG */
} CPU_SECCTRL_Type;     /*!< Size = 4 (0x4) */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_IDENTITY ============================================ */
/* =========================================================================================================================== */

/**
  * @brief CPU_IDENTITY_Type peripheral CPU_IDENTITY
  */
typedef struct {    /*!< (@ 0x4001F000) CPU_IDENTITY Structure */
  __IOM  uint32_t  CPUID;  /*!< (@ 0x00000000) register CPUID */
} CPU_IDENTITY_Type;     /*!< Size = 4 (0x4) */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: SYSINFO =============================================== */
/* =========================================================================================================================== */

/**
  * @brief SYSINFO_Type peripheral SYSINFO
  */
typedef struct {    /*!< (@ 0x40020000) SYSINFO Structure */
  __IOM  uint32_t  SYS_VERSION;  /*!< (@ 0x00000000) register SYS_VERSION */
   __IM  uint32_t  RESERVED0[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  UID0;  /*!< (@ 0x00000010) register UID0 */
  __IOM  uint32_t  UID1;  /*!< (@ 0x00000014) register UID1 */
  __IOM  uint32_t  UID2;  /*!< (@ 0x00000018) register UID2 */
  __IOM  uint32_t  UID3;  /*!< (@ 0x0000001c) register UID3 */
} SYSINFO_Type;     /*!< Size = 32 (0x20) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SYSCTR =============================================== */
/* =========================================================================================================================== */

/**
  * @brief SYSCTR_Type peripheral SYSCTR
  */
typedef struct {    /*!< (@ 0x50021000) SYSCTR Structure */
   __IM  uint32_t  SECDBGSTAT;  /*!< (@ 0x00000000) register SECDBGSTAT */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  SCSECCTRL;  /*!< (@ 0x0000000c) register SCSECCTRL */
   __IM  uint32_t  RESERVED1[60];  /*!< not covered by register fields! */
  __IOM  uint32_t  RESET_SYNDROME;  /*!< (@ 0x00000100) register RESET_SYNDROME */
  __IOM  uint32_t  RESET_MASK;  /*!< (@ 0x00000104) register RESET_MASK */
  __IOM  uint32_t  SWRESET;  /*!< (@ 0x00000108) register SWRESET */
  __IOM  uint32_t  GRETREG;  /*!< (@ 0x0000010c) register GRETREG */
  __IOM  uint32_t  INITSVTOR0;  /*!< (@ 0x00000110) register INITSVTOR0 */
  __IOM  uint32_t  INITSVTOR1;  /*!< (@ 0x00000114) register INITSVTOR1 */
  __IOM  uint32_t  CPUWAIT;  /*!< (@ 0x00000118) register CPUWAIT */
  __IOM  uint32_t  NMI_ENABLE;  /*!< (@ 0x0000011c) register NMI_ENABLE */
  __IOM  uint32_t  WICCTRL;  /*!< (@ 0x00000120) register WICCTRL */
  __IOM  uint32_t  EWCCTRL;  /*!< (@ 0x00000124) register EWCCTRL */
   __IM  uint32_t  RESERVED2[54];  /*!< not covered by register fields! */
  __IOM  uint32_t  PDCM_SYS_SENSE;  /*!< (@ 0x00000200) register PDCM_SYS_SENSE */
   __IM  uint32_t  RESERVED3[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  PDCM_SRAM0_SENSE;  /*!< (@ 0x0000020c) register PDCM_SRAM0_SENSE */
  __IOM  uint32_t  PDCM_SRAM1_SENSE;  /*!< (@ 0x00000210) register PDCM_SRAM1_SENSE */
  __IOM  uint32_t  PDCM_SRAM2_SENSE;  /*!< (@ 0x00000214) register PDCM_SRAM2_SENSE */
  __IOM  uint32_t  PDCM_SRAM3_SENSE;  /*!< (@ 0x00000218) register PDCM_SRAM3_SENSE */
   __IM  uint32_t  RESERVED4[877];  /*!< not covered by register fields! */
  __IOM  uint32_t  PIDR4;  /*!< (@ 0x00000fd0) register PIDR4 */
  __IOM  uint32_t  PIDR5;  /*!< (@ 0x00000fd4) register PIDR5 */
  __IOM  uint32_t  PIDR6;  /*!< (@ 0x00000fd8) register PIDR6 */
  __IOM  uint32_t  PIDR7;  /*!< (@ 0x00000fdc) register PIDR7 */
  __IOM  uint32_t  PIDR0;  /*!< (@ 0x00000fe0) register PIDR0 */
  __IOM  uint32_t  PIDR1;  /*!< (@ 0x00000fe4) register PIDR1 */
  __IOM  uint32_t  PIDR2;  /*!< (@ 0x00000fe8) register PIDR2 */
  __IOM  uint32_t  PIDR3;  /*!< (@ 0x00000fec) register PIDR3 */
  __IOM  uint32_t  CIDR0;  /*!< (@ 0x00000ff0) register CIDR0 */
  __IOM  uint32_t  CIDR1;  /*!< (@ 0x00000ff4) register CIDR1 */
  __IOM  uint32_t  CIDR2;  /*!< (@ 0x00000ff8) register CIDR2 */
  __IOM  uint32_t  CIDR3;  /*!< (@ 0x00000ffc) register CIDR3 */
} SYSCTR_Type;     /*!< Size = 4096 (0x1000) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PPU ================================================= */
/* =========================================================================================================================== */

/**
  * @brief PPU_Type peripheral PPU
  */
typedef struct {    /*!< (@ 0x50022000) PPU Structure */
  __IOM  uint32_t  PWPR;  /*!< (@ 0x00000000) register PWPR 
This register enables software to program both power and operating mode policy. It also contains 
related settings including the enable for dynamic transitions and the lock enable. 
This register does not reflect the current power mode value. The current power mode of the 
domain is reflected in the Power Status Register (PPU_PWSR).  */

   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
   __IM  uint32_t  PWSR;  /*!< (@ 0x00000008) register PWSR 
This read-only register contains status information for the power mode, operating mode, dynamic 
transitions, and lock feature.  */

   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
   __IM  uint32_t  DISR;  /*!< (@ 0x00000010) register DISR 
This read-only register contains status reflecting the values of the device interface inputs.  */

   __IM  uint32_t  MISR;  /*!< (@ 0x00000014) register MISR 
This read-only register contains status reflecting the values of miscellaneous inputs.  */

   __IM  uint32_t  STSR;  /*!< (@ 0x00000018) register STSR 
This read-only register contains status information about the DEVDENY inputs that were set 
HIGH during the last transition. 
This register updates when a transition completes. Therefore, it contains the status of the last 
transition. This allows software to determine the components that have denied a device interface 
request after the transition. */

   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  PWCR;  /*!< (@ 0x00000020) register PWCR 
This register controls enabling and disabling of hardware control inputs to the PPU. The PWR_DEVACTIVEEN and OP_DEVACTIVEEN fields in this register control the ability of the DEVACTIVE inputs to initiate power mode transitions, but not the ability to generate input edge interrupt events. 
Bits for unused channels are the MSB’s and are reserved.  */

   __IM  uint32_t  RESERVED3[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  IMR;  /*!< (@ 0x00000030) register IMR 
This register controls the events that assert the interrupt output. Additional event masking controls 
are in the Additional Interrupt Mask Register (PPU_AIMR), Input Edge Sensitivity Register 
(PPU_IESR), and the Operating Mode Active Edge Sensitivity Register (PPU_OPSR). 
When an interrupt event is masked an occurrence of the event does not set the corresponding bit in 
the interrupt status register. 
For each bit:  
• 0b0 – Event enabled. 
• 0b1 – Event masked.  */

  __IOM  uint32_t  AIMR;  /*!< (@ 0x00000034) register AIMR 
This register controls the events that assert the interrupt output. Additional event masking controls 
are in the Interrupt Mask Register (PPU_IMR), Input Edge Sensitivity Register (PPU_IESR), and 
the Operating Mode Active Edge Sensitivity Register (PPU_OPSR). 
When an interrupt event is masked an occurrence of the event does not set the corresponding bit in 
the interrupt status register. 
For each bit:  
• 0b0 – Event enabled. 
• 0b1 – Event masked.  */

  __IOM  uint32_t  ISR;  /*!< (@ 0x00000038) register ISR 
This register contains information about events causing the assertion of the interrupt output. It is 
also used to clear interrupt events.  
A bit set to 0b1 indicates the event asserted the interrupt output. Multiple events can be active at 
the same time. When an interrupt event is masked an occurrence of that event does not set the 
status bit. 
A write of 0b1 to an event bit clears that event. A write of 0b0 to a bit has no effect. The interrupt 
output stays HIGH until all status bits in the Interrupt Status Register (PPU_ISR) and the 
Additional Interrupt Status Register (PPU_AISR) are 0b0. 
When the OTHER_IRQ bit is set, this indicates an event from the Additional Interrupt Status 
Register (PPU_AISR) has caused the interrupt output to be asserted. This bit cannot be cleared by 
writing to this register. It must be cleared by writing to the active event in the Additional Interrupt 
Status Register (PPU_AISR).
Bits for unused channels are the MSBs and are reserved.  */

  __IOM  uint32_t  AISR;  /*!< (@ 0x0000003c) register AISR 
This register contains information about events causing the assertion of the interrupt output. It is 
also used to clear interrupt events.  
A bit set to 0b1 indicates the event asserted the interrupt output. Multiple events can be active at 
the same time. When an interrupt event is masked an occurrence of that event does not set the 
status bit. 
A write of 0b1 to an event bit clears that event. A write of 0b0 has no effect. The interrupt output 
stays HIGH until all status bits in the Interrupt Status Register (PPU_ISR) and the Additional 
Interrupt Status Register (PPU_AISR) are set to 0b0. 
When an interrupt status is set to 0b1 in this register it sets the OTHER_IRQ bit in the Interrupt 
Status Register (PPU_ISR). Status bits in this register are only cleared by writing to this register. */

  __IOM  uint32_t  IESR;  /*!< (@ 0x00000040) register IESR 
This register configures the transitions on the power mode DEVACTIVE inputs that generate an 
Input Edge interrupt event. For each input, there are two registers bits with the following encoding: 
• 0b00 – Event masked. 
• 0b01 – Event on rising edge. 
• 0b10 – Event on falling edge. 
• 0b11 – Event on both edges. 
When an event is masked an occurrence of the event does not set the corresponding bit in the 
interrupt status register. 
Fields for power mode DEVACTIVE inputs that are not supported are reserved.  */

   __IM  uint32_t  RESERVED4[75];  /*!< not covered by register fields! */
  __IOM  uint32_t  DCDR0;  /*!< (@ 0x00000170) register DCDR0 
This register is used to program device control delay parameters.  */

  __IOM  uint32_t  DCDR1;  /*!< (@ 0x00000174) register DCDR1 
This register is used to program device control delay parameters.  */

   __IM  uint32_t  RESERVED5[910];  /*!< not covered by register fields! */
   __IM  uint32_t  IDR0;  /*!< (@ 0x00000fb0) register IDR0 
This read-only register contains information on the type and number of channels on the device 
interface and power and operating modes supported.  
For each *_SPT bit: 
• 0b0: Feature not supported. 
• 0b1: Feature supported. 
The default values for the fields of this register are dependent on PPU configuration options. */

   __IM  uint32_t  IDR1;  /*!< (@ 0x00000fb4) register IDR1 
This read-only register contains information on the optional features and configurations that are 
supported by this PPU.
For each *_SPT bit: 
• 0b0: Feature not supported. 
• 0b1: Feature supported. 
The default values for the fields of this register are dependent on PPU configuration options */

   __IM  uint32_t  RESERVED6[4];  /*!< not covered by register fields! */
   __IM  uint32_t  IIDR;  /*!< (@ 0x00000fc8) register IIDR 
This register provides information about the implementer and implementation of the PPU.  */

   __IM  uint32_t  AIDR;  /*!< (@ 0x00000fcc) register AIDR 
This register identifies the PPU architecture revision. 
[7:0] – 0x11: Indicates PPU architecture revision 1.1.  */

} PPU_Type;     /*!< Size = 4048 (0xfd0) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: WDT ================================================= */
/* =========================================================================================================================== */

/**
  * @brief WDT_Type peripheral WDT
  */
typedef struct {    /*!< (@ 0x5002E000) WDT Structure */
  __IOM  uint32_t  WDOGLOAD;  /*!< (@ 0x00000000) register WDOGLOAD 
Watchdog Load value register contains the value from which the counter is to decrement. When this register is written to the count is immediately restarted from the new value. The minimum valid value for WDOGLOAD is 1. */

   __IM  uint32_t  WDOGVALUE;  /*!< (@ 0x00000004) register WDOGVALUE 
Watchdog Current value register gives the current value of the decrementing counter */

  __IOM  uint32_t  WDOGCONTROL;  /*!< (@ 0x00000008) register WDOGCONTROL 
Watchdog Control register enables the software to control the watchdog unit */

  __IOM  uint32_t  WDOGINTCLR;  /*!< (@ 0x0000000c) register WDOGINTCLR 
A write to this register clears the watchdog interrupt and reloads the counter from the value in WDOGLOAD */

   __IM  uint32_t  WDOGRIS;  /*!< (@ 0x00000010) register WDOGRIS 
Watchdog Raw interrupt status register indicates the raw interrupt status from the counter. This value is ANDed with the interrupt enable bit from the control register to create the masked interrupt that is passed to the interrupt output pin. */

   __IM  uint32_t  WDOGMIS;  /*!< (@ 0x00000014) register WDOGMIS 
Watchdog Interrupt status register indicates the masked interrupt status from the counter. This value is the logical AND of the Raw interrupt status with the Interrupt enable bit from the Control register, and is the same value that is passed to the interrupt output pin. */

   __IM  uint32_t  RESERVED0[762];  /*!< not covered by register fields! */
  __IOM  uint32_t  WDOGLOCK;  /*!< (@ 0x00000c00) register WDOGLOCK 
Watchdog Lock register disables write accesses to all other registers to prevent rogue software from disabling the watchdog functionality. A read from this register returns only the bottom bit. */

   __IM  uint32_t  RESERVED1[191];  /*!< not covered by register fields! */
  __IOM  uint32_t  WDOGITCR;  /*!< (@ 0x00000f00) register WDOGITCR 
Watchdog Integration test control register enables integration test mode. When in this mode the test output register directly controls the masked interrupt output WDOGINT and reset output WDOGRES. */

  __IOM  uint32_t  WDOGITOP;  /*!< (@ 0x00000f04) register WDOGITOP 
Watchdog Integration test output set register values directly drive the enabled interrupt output and reset output when in Integration test mode. */

   __IM  uint32_t  RESERVED2[50];  /*!< not covered by register fields! */
   __IM  uint32_t  WDOGPERIPHID4;  /*!< (@ 0x00000fd0) register WDOGPERIPHID4 
Peripheral identification register 4 */

   __IM  uint32_t  WDOGPERIPHID5;  /*!< (@ 0x00000fd4) register WDOGPERIPHID5 
Peripheral identification register 5 (unused) */

   __IM  uint32_t  WDOGPERIPHID6;  /*!< (@ 0x00000fd8) register WDOGPERIPHID6 
Peripheral identification register 6 (unused) */

   __IM  uint32_t  WDOGPERIPHID7;  /*!< (@ 0x00000fdc) register WDOGPERIPHID7 
Peripheral identification register 7 (unused) */

   __IM  uint32_t  WDOGPERIPHID0;  /*!< (@ 0x00000fe0) register WDOGPERIPHID0 
Peripheral identification register 0 */

   __IM  uint32_t  WDOGPERIPHID1;  /*!< (@ 0x00000fe4) register WDOGPERIPHID1 
Peripheral identification register 1 */

   __IM  uint32_t  WDOGPERIPHID2;  /*!< (@ 0x00000fe8) register WDOGPERIPHID2 
Peripheral identification register 2 */

   __IM  uint32_t  WDOGPERIPHID3;  /*!< (@ 0x00000fec) register WDOGPERIPHID3 
Peripheral identification register 3 */

   __IM  uint32_t  WDOGPCELLID0;  /*!< (@ 0x00000ff0) register WDOGPCELLID0 
Watchdog Component identification register 0 */

   __IM  uint32_t  WDOGPCELLID1;  /*!< (@ 0x00000ff4) register WDOGPCELLID1 
Watchdog Component identification register 1 */

   __IM  uint32_t  WDOGPCELLID2;  /*!< (@ 0x00000ff8) register WDOGPCELLID2 
Watchdog Component identification register 2 */

   __IM  uint32_t  WDOGPCELLID3;  /*!< (@ 0x00000ffc) register WDOGPCELLID3 
Watchdog Component identification register 3 */

} WDT_Type;     /*!< Size = 4096 (0x1000) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: IOCTR ================================================ */
/* =========================================================================================================================== */

/**
  * @brief IOCTR_Type peripheral IOCTR
  */
typedef struct {    /*!< (@ 0x40030000) IOCTR Structure */
  __IOM  uint32_t  PA_MODE;  /*!< (@ 0x00000000) register PA_MODE */
  __IOM  uint32_t  PA_AFL;  /*!< (@ 0x00000004) register PA_AFL */
  __IOM  uint32_t  PA_AFH;  /*!< (@ 0x00000008) register PA_AFH */
  __IOM  uint32_t  PA_PUPD;  /*!< (@ 0x0000000c) register PA_PUPD */
  __IOM  uint32_t  PA_DS;  /*!< (@ 0x00000010) register PA_DS */
  __IOM  uint32_t  PA_SR;  /*!< (@ 0x00000014) register PA_SR */
  __IOM  uint32_t  PA_OTYPE;  /*!< (@ 0x00000018) register PA_OTYPE */
  __IOM  uint32_t  PA_ITYPE;  /*!< (@ 0x0000001c) register PA_ITYPE */
  __IOM  uint32_t  PA_I2CMODE;  /*!< (@ 0x00000020) register PA_I2CMODE */
   __IM  uint32_t  RESERVED0[55];  /*!< not covered by register fields! */
  __IOM  uint32_t  PB_MODE;  /*!< (@ 0x00000100) register PB_MODE */
  __IOM  uint32_t  PB_AFL;  /*!< (@ 0x00000104) register PB_AFL */
  __IOM  uint32_t  PB_AFH;  /*!< (@ 0x00000108) register PB_AFH */
  __IOM  uint32_t  PB_PUPD;  /*!< (@ 0x0000010c) register PB_PUPD */
  __IOM  uint32_t  PB_DS;  /*!< (@ 0x00000110) register PB_DS */
  __IOM  uint32_t  PB_SR;  /*!< (@ 0x00000114) register PB_SR */
  __IOM  uint32_t  PB_OTYPE;  /*!< (@ 0x00000118) register PB_OTYPE */
  __IOM  uint32_t  PB_ITYPE;  /*!< (@ 0x0000011c) register PB_ITYPE */
  __IOM  uint32_t  PB_I2CMODE;  /*!< (@ 0x00000120) register PB_I2CMODE */
   __IM  uint32_t  RESERVED1[55];  /*!< not covered by register fields! */
  __IOM  uint32_t  PC_MODE;  /*!< (@ 0x00000200) register PC_MODE */
  __IOM  uint32_t  PC_AFL;  /*!< (@ 0x00000204) register PC_AFL */
  __IOM  uint32_t  PC_AFH;  /*!< (@ 0x00000208) register PC_AFH */
  __IOM  uint32_t  PC_PUPD;  /*!< (@ 0x0000020c) register PC_PUPD */
  __IOM  uint32_t  PC_DS;  /*!< (@ 0x00000210) register PC_DS */
  __IOM  uint32_t  PC_SR;  /*!< (@ 0x00000214) register PC_SR */
  __IOM  uint32_t  PC_OTYPE;  /*!< (@ 0x00000218) register PC_OTYPE */
  __IOM  uint32_t  PC_ITYPE;  /*!< (@ 0x0000021c) register PC_ITYPE */
   __IM  uint32_t  RESERVED2[56];  /*!< not covered by register fields! */
  __IOM  uint32_t  PD_MODE;  /*!< (@ 0x00000300) register PD_MODE */
  __IOM  uint32_t  PD_AFL;  /*!< (@ 0x00000304) register PD_AFL */
  __IOM  uint32_t  PD_AFH;  /*!< (@ 0x00000308) register PD_AFH */
  __IOM  uint32_t  PD_PUPD;  /*!< (@ 0x0000030c) register PD_PUPD */
  __IOM  uint32_t  PD_DS;  /*!< (@ 0x00000310) register PD_DS */
  __IOM  uint32_t  PD_SR;  /*!< (@ 0x00000314) register PD_SR */
  __IOM  uint32_t  PD_OTYPE;  /*!< (@ 0x00000318) register PD_OTYPE */
  __IOM  uint32_t  PD_ITYPE;  /*!< (@ 0x0000031c) register PD_ITYPE */
} IOCTR_Type;     /*!< Size = 800 (0x320) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: CLKCTR =============================================== */
/* =========================================================================================================================== */

/**
  * @brief CLKCTR_Type peripheral CLKCTR
  */
typedef struct {    /*!< (@ 0x40031000) CLKCTR Structure */
  __IOM  uint32_t  PLLCFG;  /*!< (@ 0x00000000) register PLLCFG */
  __IOM  uint32_t  PLLDIAG;  /*!< (@ 0x00000004) register PLLDIAG */
  __IOM  uint32_t  CFG;  /*!< (@ 0x00000008) register CFG */
  __IOM  uint32_t  CLKFORCE;  /*!< (@ 0x0000000c) register CLKFORCE */
  __IOM  uint32_t  FCLKDIV;  /*!< (@ 0x00000010) register FCLKDIV */
  __IOM  uint32_t  SYSCLKDIV;  /*!< (@ 0x00000014) register SYSCLKDIV */
  __IOM  uint32_t  QSPICLKDIV;  /*!< (@ 0x00000018) register QSPICLKDIV */
  __IOM  uint32_t  I2SCLKDIV;  /*!< (@ 0x0000001c) register I2SCLKDIV */
  __IOM  uint32_t  MCODIV;  /*!< (@ 0x00000020) register MCODIV */
  __IOM  uint32_t  GNSSCLKDIV;  /*!< (@ 0x00000024) register GNSSCLKDIV */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  HFITRIM;  /*!< (@ 0x00000030) register HFITRIM */
} CLKCTR_Type;     /*!< Size = 52 (0x34) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: PWRCTR =============================================== */
/* =========================================================================================================================== */

/**
  * @brief PWRCTR_Type peripheral PWRCTR
  */
typedef struct {    /*!< (@ 0x40032000) PWRCTR Structure */
  __IOM  uint32_t  CFG;  /*!< (@ 0x00000000) register CFG */
  __IOM  uint32_t  STAT;  /*!< (@ 0x00000004) register STAT */
  __IOM  uint32_t  RUNCFG;  /*!< (@ 0x00000008) register RUNCFG */
  __IOM  uint32_t  STDBYCFG;  /*!< (@ 0x0000000c) register STDBYCFG */
  __IOM  uint32_t  VLEVEL;  /*!< (@ 0x00000010) register VLEVEL */
  __IOM  uint32_t  TRIM;  /*!< (@ 0x00000014) register TRIM */
  __IOM  uint32_t  TEST;  /*!< (@ 0x00000018) register TEST */
} PWRCTR_Type;     /*!< Size = 28 (0x1c) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: OTPCTR =============================================== */
/* =========================================================================================================================== */

/**
  * @brief OTPCTR_Type peripheral OTPCTR
  */
typedef struct {    /*!< (@ 0x50033000) OTPCTR Structure */
  __IOM  uint32_t  DAP_DR;  /*!< (@ 0x00000000) register DAP_DR */
   __IM  uint32_t  RESERVED0[7];  /*!< not covered by register fields! */
  __IOM  uint32_t  DAP_ER;  /*!< (@ 0x00000020) register DAP_ER */
   __IM  uint32_t  RESERVED1[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  DAP_RQ0;  /*!< (@ 0x00000030) register DAP_RQ0 */
  __IOM  uint32_t  DAP_RQ1;  /*!< (@ 0x00000034) register DAP_RQ1 */
  __IOM  uint32_t  DAP_RQ2;  /*!< (@ 0x00000038) register DAP_RQ2 */
  __IOM  uint32_t  DAP_CQCTRL;  /*!< (@ 0x0000003c) register DAP_CQCTRL */
   __IM  uint32_t  RESERVED2[28];  /*!< not covered by register fields! */
  __IOM  uint32_t  PMC_RQ0;  /*!< (@ 0x000000b0) register PMC_RQ0 */
  __IOM  uint32_t  PMC_RQ1;  /*!< (@ 0x000000b4) register PMC_RQ1 */
  __IOM  uint32_t  PMC_RQ2;  /*!< (@ 0x000000b8) register PMC_RQ2 */
  __IOM  uint32_t  PMC_CQCTRL;  /*!< (@ 0x000000bc) register PMC_CQCTRL */
   __IM  uint32_t  RESERVED3[16];  /*!< not covered by register fields! */
  __IOM  uint32_t  DAP_CMD;  /*!< (@ 0x00000100) register DAP_CMD */
   __IM  uint32_t  RESERVED4[31];  /*!< not covered by register fields! */
  __IOM  uint32_t  PMC_CMD;  /*!< (@ 0x00000180) register PMC_CMD */
} OTPCTR_Type;     /*!< Size = 388 (0x184) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: NSPCTR =============================================== */
/* =========================================================================================================================== */

/**
  * @brief NSPCTR_Type peripheral NSPCTR
  */
typedef struct {    /*!< (@ 0x40080000) NSPCTR Structure */
   __IM  uint32_t  RESERVED0[40];  /*!< not covered by register fields! */
  __IOM  uint32_t  AHBPPC0_NSP;  /*!< (@ 0x000000a0) register AHBPPC0_NSP */
   __IM  uint32_t  RESERVED1[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC4_NSP;  /*!< (@ 0x000000b0) register APBPPC4_NSP */
  __IOM  uint32_t  APBPPC5_NSP;  /*!< (@ 0x000000b4) register APBPPC5_NSP */
   __IM  uint32_t  RESERVED2[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC0_NSP;  /*!< (@ 0x000000c0) register APBPPC0_NSP */
  __IOM  uint32_t  APBPPC1_NSP;  /*!< (@ 0x000000c4) register APBPPC1_NSP */
  __IOM  uint32_t  APBPPC2_NSP;  /*!< (@ 0x000000c8) register APBPPC2_NSP */
  __IOM  uint32_t  APBPPC3_NSP;  /*!< (@ 0x000000cc) register APBPPC3_NSP */
} NSPCTR_Type;     /*!< Size = 208 (0xd0) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SPCTR ================================================ */
/* =========================================================================================================================== */

/**
  * @brief SPCTR_Type peripheral SPCTR
  */
typedef struct {    /*!< (@ 0x50080000) SPCTR Structure */
  __IOM  uint32_t  SPCSECCTRL;  /*!< (@ 0x00000000) register SPCSECCTRL */
  __IOM  uint32_t  BUSWAIT;  /*!< (@ 0x00000004) register BUSWAIT */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  SECRESPCFG;  /*!< (@ 0x00000010) register SECRESPCFG */
  __IOM  uint32_t  NSCCFG;  /*!< (@ 0x00000014) register NSCCFG */
   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint32_t  MPCINTSTAT;  /*!< (@ 0x0000001c) register MPCINTSTAT */
  __IOM  uint32_t  PPCINTSTAT;  /*!< (@ 0x00000020) register PPCINTSTAT */
  __IOM  uint32_t  PPCINTCLR;  /*!< (@ 0x00000024) register PPCINTCLR */
  __IOM  uint32_t  PPCINTEN;  /*!< (@ 0x00000028) register PPCINTEN */
   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  MSCINTSTAT;  /*!< (@ 0x00000030) register MSCINTSTAT */
  __IOM  uint32_t  MSCINTCLR;  /*!< (@ 0x00000034) register MSCINTCLR */
  __IOM  uint32_t  MSCINTEN;  /*!< (@ 0x00000038) register MSCINTEN */
   __IM  uint32_t  RESERVED3;  /*!< not covered by register fields! */
  __IOM  uint32_t  BRGINTSTAT;  /*!< (@ 0x00000040) register BRGINTSTAT */
  __IOM  uint32_t  BRGINTCLR;  /*!< (@ 0x00000044) register BRGINTCLR */
  __IOM  uint32_t  BRGINTEN;  /*!< (@ 0x00000048) register BRGINTEN */
   __IM  uint32_t  RESERVED4[5];  /*!< not covered by register fields! */
  __IOM  uint32_t  AHBPPC0_NS;  /*!< (@ 0x00000060) register AHBPPC0_NS */
   __IM  uint32_t  RESERVED5[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC4_NS;  /*!< (@ 0x00000070) register APBPPC4_NS */
  __IOM  uint32_t  APBPPC5_NS;  /*!< (@ 0x00000074) register APBPPC5_NS */
   __IM  uint32_t  RESERVED6[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC0_NS;  /*!< (@ 0x00000080) register APBPPC0_NS */
  __IOM  uint32_t  APBPPC1_NS;  /*!< (@ 0x00000084) register APBPPC1_NS */
  __IOM  uint32_t  APBPPC2_NS;  /*!< (@ 0x00000088) register APBPPC2_NS */
  __IOM  uint32_t  APBPPC3_NS;  /*!< (@ 0x0000008c) register APBPPC3_NS */
   __IM  uint32_t  RESERVED7[4];  /*!< not covered by register fields! */
  __IOM  uint32_t  AHBPPC0_SP;  /*!< (@ 0x000000a0) register AHBPPC0_SP */
   __IM  uint32_t  RESERVED8[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC4_SP;  /*!< (@ 0x000000b0) register APBPPC4_SP */
  __IOM  uint32_t  APBPPC5_SP;  /*!< (@ 0x000000b4) register APBPPC5_SP */
   __IM  uint32_t  RESERVED9[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  APBPPC0_SP;  /*!< (@ 0x000000c0) register APBPPC0_SP */
  __IOM  uint32_t  APBPPC1_SP;  /*!< (@ 0x000000c4) register APBPPC1_SP */
  __IOM  uint32_t  APBPPC2_SP;  /*!< (@ 0x000000c8) register APBPPC2_SP */
  __IOM  uint32_t  APBPPC3_SP;  /*!< (@ 0x000000cc) register APBPPC3_SP */
  __IOM  uint32_t  MSC_NS;  /*!< (@ 0x000000d0) register MSC_NS */
} SPCTR_Type;     /*!< Size = 212 (0xd4) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MPC ================================================= */
/* =========================================================================================================================== */

/**
  * @brief MPC_Type peripheral MPC
  */
typedef struct {    /*!< (@ 0x50083000) MPC Structure */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000000) register CTRL */
   __IM  uint32_t  RESERVED0[3];  /*!< not covered by register fields! */
  __IOM  uint32_t  BLK_MAX;  /*!< (@ 0x00000010) register BLK_MAX */
  __IOM  uint32_t  BLK_CFG;  /*!< (@ 0x00000014) register BLK_CFG */
  __IOM  uint32_t  BLK_IDX;  /*!< (@ 0x00000018) register BLK_IDX */
  __IOM  uint32_t  BLK_LUT;  /*!< (@ 0x0000001c) register BLK_LUT */
  __IOM  uint32_t  INT_STAT;  /*!< (@ 0x00000020) register INT_STAT */
  __IOM  uint32_t  INT_CLEAR;  /*!< (@ 0x00000024) register INT_CLEAR */
  __IOM  uint32_t  INT_EN;  /*!< (@ 0x00000028) register INT_EN */
  __IOM  uint32_t  INT_INFO1;  /*!< (@ 0x0000002c) register INT_INFO1 */
  __IOM  uint32_t  INT_INFO2;  /*!< (@ 0x00000030) register INT_INFO2 */
  __IOM  uint32_t  INT_SET;  /*!< (@ 0x00000034) register INT_SET */
} MPC_Type;     /*!< Size = 56 (0x38) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: UART ================================================ */
/* =========================================================================================================================== */

/**
  * @brief UART_Type peripheral UART
  */
typedef struct {    /*!< (@ 0x40100000) UART Structure */

union {
  __IOM  uint32_t  DLL;  /*!< (@ 0x00000000) register DLL */
   __IM  uint32_t  RBR;  /*!< (@ 0x00000000) register RBR 
Receive Buffer Register.
Reset Value: 0x0 
 This register can be accessed only when the DLAB bit (LCR[7]) is cleared. */

  __IOM  uint32_t  THR;  /*!< (@ 0x00000000) register THR */
};

union {
  __IOM  uint32_t  DLH;  /*!< (@ 0x00000004) register DLH */
  __IOM  uint32_t  IER;  /*!< (@ 0x00000004) register IER 
Interrupt Enable Register. 
Reset Value: 0x0.
 This register can be accessed only when the DLAB bit (LCR[7]) is cleared. */

};

union {
  __IOM  uint32_t  FCR;  /*!< (@ 0x00000008) register FCR */
   __IM  uint32_t  IIR;  /*!< (@ 0x00000008) register IIR 
Interrupt Identification Register
Reset Value: 0x1 */

};
  __IOM  uint32_t  LCR;  /*!< (@ 0x0000000c) register LCR 
Line Control Register
Reset Value: 0x0 */

  __IOM  uint32_t  MCR;  /*!< (@ 0x00000010) register MCR 
Modem Control Register
Reset Value: 0x0 */

   __IM  uint32_t  LSR;  /*!< (@ 0x00000014) register LSR 
Line Status Register
Reset Value: 0x60 */

   __IM  uint32_t  MSR;  /*!< (@ 0x00000018) register MSR 
Whenever bits 0, 1, 2 or 3 is set to logic one, to indicate
a change on the modem control inputs, a modem status interrupt will be generated
if enabled via the IER regardless of when the change occurred. The bits
(bits 0, 1, 3) can be set after a reset-even tthough their respective modem signals are
inactive-because the synchronized version of the modem signals have a reset value of 0 and change to value 1 after reset. To
prevent unwanted interrupts due to this change, a read of the MSR register can be performed after reset.
Reset Value: 0x0 */

  __IOM  uint32_t  SCR;  /*!< (@ 0x0000001c) register SCR 
Scratchpad Register
Reset Value: 0x0 */

   __IM  uint32_t  RESERVED0[4];  /*!< not covered by register fields! */

union {
   __IM  uint32_t  SRBR0;  /*!< (@ 0x00000030) register SRBR0 
This register is valid only when the DW_apb_uart is configured to have additional shadow registers
implemented (SHADOW = YES). If shadow registers are not implemented, this register does not exist and
reading from this register address returns 0.

This register can be accessed only when the DLAB bit (LCR[7]) is cleared.
Reset Value: 0x0 */

  __IOM  uint32_t  STHR0;  /*!< (@ 0x00000030) register STHR0 */
};

union {
   __IM  uint32_t  SRBR1;  /*!< (@ 0x00000034) register SRBR1 
Shadow Receive Buffer Register 1 */

  __IOM  uint32_t  STHR1;  /*!< (@ 0x00000034) register STHR1 */
};

union {
   __IM  uint32_t  SRBR2;  /*!< (@ 0x00000038) register SRBR2 
Shadow Receive Buffer Register 2 */

  __IOM  uint32_t  STHR2;  /*!< (@ 0x00000038) register STHR2 */
};

union {
   __IM  uint32_t  SRBR3;  /*!< (@ 0x0000003c) register SRBR3 
Shadow Receive Buffer Register 3 */

  __IOM  uint32_t  STHR3;  /*!< (@ 0x0000003c) register STHR3 */
};

union {
   __IM  uint32_t  SRBR4;  /*!< (@ 0x00000040) register SRBR4 
Shadow Receive Buffer Register 4 */

  __IOM  uint32_t  STHR4;  /*!< (@ 0x00000040) register STHR4 */
};

union {
   __IM  uint32_t  SRBR5;  /*!< (@ 0x00000044) register SRBR5 
Shadow Receive Buffer Register 5 */

  __IOM  uint32_t  STHR5;  /*!< (@ 0x00000044) register STHR5 */
};

union {
   __IM  uint32_t  SRBR6;  /*!< (@ 0x00000048) register SRBR6 
Shadow Receive Buffer Register 6 */

  __IOM  uint32_t  STHR6;  /*!< (@ 0x00000048) register STHR6 */
};

union {
   __IM  uint32_t  SRBR7;  /*!< (@ 0x0000004c) register SRBR7 
Shadow Receive Buffer Register 7 */

  __IOM  uint32_t  STHR7;  /*!< (@ 0x0000004c) register STHR7 */
};

union {
   __IM  uint32_t  SRBR8;  /*!< (@ 0x00000050) register SRBR8 
Shadow Receive Buffer Register 8 */

  __IOM  uint32_t  STHR8;  /*!< (@ 0x00000050) register STHR8 */
};

union {
   __IM  uint32_t  SRBR9;  /*!< (@ 0x00000054) register SRBR9 
Shadow Receive Buffer Register 9 */

  __IOM  uint32_t  STHR9;  /*!< (@ 0x00000054) register STHR9 */
};

union {
   __IM  uint32_t  SRBR10;  /*!< (@ 0x00000058) register SRBR10 
Shadow Receive Buffer Register 10 */

  __IOM  uint32_t  STHR10;  /*!< (@ 0x00000058) register STHR10 */
};

union {
   __IM  uint32_t  SRBR11;  /*!< (@ 0x0000005c) register SRBR11 
Shadow Receive Buffer Register 11 */

  __IOM  uint32_t  STHR11;  /*!< (@ 0x0000005c) register STHR11 */
};

union {
   __IM  uint32_t  SRBR12;  /*!< (@ 0x00000060) register SRBR12 
Shadow Receive Buffer Register 12 */

  __IOM  uint32_t  STHR12;  /*!< (@ 0x00000060) register STHR12 */
};

union {
   __IM  uint32_t  SRBR13;  /*!< (@ 0x00000064) register SRBR13 
Shadow Receive Buffer Register 13 */

  __IOM  uint32_t  STHR13;  /*!< (@ 0x00000064) register STHR13 */
};

union {
   __IM  uint32_t  SRBR14;  /*!< (@ 0x00000068) register SRBR14 
Shadow Receive Buffer Register 14 */

  __IOM  uint32_t  STHR14;  /*!< (@ 0x00000068) register STHR14 */
};

union {
   __IM  uint32_t  SRBR15;  /*!< (@ 0x0000006c) register SRBR15 
Shadow Receive Buffer Register 15 */

  __IOM  uint32_t  STHR15;  /*!< (@ 0x0000006c) register STHR15 */
};
   __IM  uint32_t  FAR;  /*!< (@ 0x00000070) register FAR 
FIFO Access Register */

   __IM  uint32_t  RESERVED1[2];  /*!< not covered by register fields! */
   __IM  uint32_t  USR;  /*!< (@ 0x0000007c) register USR 
UART Status register.
Reset Value: 0x6 */

   __IM  uint32_t  TFL;  /*!< (@ 0x00000080) register TFL 
TFL register is valid only when the DW_apb_uart is configured to have additional FIFO status registers
implemented (FIFO_STAT = YES). If status registers are not implemented, this register does not exist and
reading from this register address returns 0.
Reset Value: 0x0 */

   __IM  uint32_t  RFL;  /*!< (@ 0x00000084) register RFL 
RFL register is valid only when the DW_apb_uart is configured to have additional FIFO status registers
implemented (FIFO_STAT = YES). If status registers are not implemented, this register does not exist and
reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SRR;  /*!< (@ 0x00000088) register SRR 
This register is valid only when the DW_apb_uart is configured to have additional shadow registers
implemented (SHADOW = YES). If shadow registers are not implemented, this register does not exist and
reading from this register address returns 0.

For more information on the amount of time that serial clock modules need in order to see new register
values and reset their respective state machines, refer to the 'Clock Support' subsection in the data book.
Reset Value: 0x0 */

  __IOM  uint32_t  SRTS;  /*!< (@ 0x0000008c) register SRTS 
SRTS register is valid only when the DW_apb_uart is configured to have additional shadow registers
implemented (SHADOW = YES). If shadow registers are not implemented, this register does not exist and
reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SBCR;  /*!< (@ 0x00000090) register SBCR 
SBCR register is valid only when the DW_apb_uart is configured to have additional shadow registers
implemented (SHADOW = YES). If shadow registers are not implemented, this register does not exist and
reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SDMAM;  /*!< (@ 0x00000094) register SDMAM 
This register is valid only when the DW_apb_uart is configured to have additional FIFO registers implemented (FIFO_MODE != None) and additional shadow registers implemented (SHADOW = YES). If these registers are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SFE;  /*!< (@ 0x00000098) register SFE 
SFE register is valid only when the DW_apb_uart is configured to have additional FIFO registers
implemented (FIFO_MODE != None) and additional shadow registers implemented (SHADOW = YES). If these registers are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SRT;  /*!< (@ 0x0000009c) register SRT 
SRT register is valid only when the DW_apb_uart is configured to have additional FIFO registers
implemented (FIFO_MODE != None) and additional shadow registers implemented (SHADOW = YES). If these registers are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  STET;  /*!< (@ 0x000000a0) register STET 
This register is valid only when the DW_apb_uart is configured to have FIFOs implemented
(FIFO_MODE != NONE) and THRE interrupt support implemented (THRE_MODE_USER = Enabled) and
additional shadow registers implemented (SHADOW = YES). If FIFOs are not implemented or THRE interrupt support is not implemented or shadow registers are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: 0x0 */

  __IOM  uint32_t  HTX;  /*!< (@ 0x000000a4) register HTX 
Halt TX
Reset Value: 0x0 */

  __IOM  uint32_t  DMASA;  /*!< (@ 0x000000a8) register DMASA 
DMA Software Acknowledge Register
Reset Value: 0x0 */

  __IOM  uint32_t  TCR;  /*!< (@ 0x000000ac) register TCR 
This register is used to enable or disable RS485 mode and also control the polarity values for Driven enable
(de) and Receiver Enable (re) signals.

This register is only valid when the DW_apb_uart is configured to have RS485 interface implemented
(UART_RS485_INTERFACE_EN = ENABLED). If RS485 interface is not implemented, this register does not
exist and reading from this register address returns zero.
Reset Value: 0x6 */

  __IOM  uint32_t  DE_EN;  /*!< (@ 0x000000b0) register DE_EN 
The Driver Output Enable Register (DE_EN) is used to control the assertion and de-assertion of the DE
signal.

This register is only valid when the DW_apb_uart is configured to have RS485 interface implemented
(UART_RS485_INTERFACE_EN = ENABLED). If RS485 interface is not implemented, this register does not
exist and reading from this register address will return zero.
Reset Value: 0x0 */

  __IOM  uint32_t  RE_EN;  /*!< (@ 0x000000b4) register RE_EN 
The Receiver Output Enable Register (RE_EN) is used to control the assertion and de-assertion of the RE signal.

This register is only valid when the DW_apb_uart is configured to have RS485 interface implemented
(UART_RS485_INTERFACE_EN = ENABLED). If the RS485 interface is not implemented, this register does
not exist and reading from this register address will return zero.
Reset Value: 0x0 */

  __IOM  uint32_t  DET;  /*!< (@ 0x000000b8) register DET 
The Driver Output Enable Timing Register (DET) is used to control the DE assertion and de-assertion timings of 'de' signal.
 This register is only valid when the DW_apb_uart is configured to have RS485 interface implemented (UART_RS485_INTERFACE = ENABLED). If RS485 interface is not implemented, this register does not exist and reading from this register address will return zero.
Reset Value: 0x0 */

  __IOM  uint32_t  TAT;  /*!< (@ 0x000000bc) register TAT 
The TurnAround Timing Register (TAT) is used to hold the turnaround time between switching of 're' and
'de' signals.

This register is only valid when the DW_apb_uart is configured to have the RS485 interface implemented
(UART_RS485_INTERFACE_EN = ENABLED). If RS485 interface is not implemented, this register does not
exist and reading from this register address will return zero. */

  __IOM  uint32_t  DLF;  /*!< (@ 0x000000c0) register DLF 
This register is only valid when the DW_apb_uart is configured to have Fractional Baud rate Divisor implemented (FRACTIONAL_BAUD_DIVISOR_EN = ENABLED). If Fractional Baud rate divisor is not implemented, this register does not exist and reading from this register address will return zero.
Reset Value: 0x0 */

  __IOM  uint32_t  RAR;  /*!< (@ 0x000000c4) register RAR 
Receive Address Register
Reset Value: 0x0 */

  __IOM  uint32_t  TAR;  /*!< (@ 0x000000c8) register TAR 
Transmit Address Register
Reset Value: 0x0 */

  __IOM  uint32_t  LCR_EXT;  /*!< (@ 0x000000cc) register LCR_EXT 
Line Extended Control Register 
Reset Value: 0x0 */

   __IM  uint32_t  RESERVED2[9];  /*!< not covered by register fields! */
   __IM  uint32_t  CPR;  /*!< (@ 0x000000f4) register CPR 
Component Parameter Register.This register is valid only when UART_ADD_ENCODED_PARAMS = 1. If the UART_ADD_ENCODED_PARAMS parameter is not set, this register does not exist and reading from this register address returns 0.
Reset Value: Configuration-dependent */

   __IM  uint32_t  UCV;  /*!< (@ 0x000000f8) register UCV 
This register is valid only when the DW_apb_uart is configured to have additional features implemented (ADDITIONAL_FEATURES = YES). If additional features are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: See the releases table in the AMBA 2 release notes. */

   __IM  uint32_t  CTR;  /*!< (@ 0x000000fc) register CTR 
This register is valid only when the DW_apb_uart is configured to have additional features implemented (ADDITIONAL_FEATURES = YES). If additional features are not implemented, this register does not exist and reading from this register address returns 0.
Reset Value: 0x44570110 */

} UART_Type;     /*!< Size = 256 (0x100) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SPI ================================================= */
/* =========================================================================================================================== */

/**
  * @brief SPI_Type peripheral SPI
  */
typedef struct {    /*!< (@ 0x40104000) SPI Structure */
  __IOM  uint32_t  CTRLR0;  /*!< (@ 0x00000000) register CTRLR0 
This register controls the serial data transfer. It is impossible to
write to this register when the DW_apb_ssi is enabled. The DW_apb_ssi
is enabled and disabled by writing to the SSIENR register.
Reset Value: SSI_CTRLR0_RST */

  __IOM  uint32_t  CTRLR1;  /*!< (@ 0x00000004) register CTRLR1 
This register exists only when the DW_apb_ssi is configured as a
master device. When the DW_apb_ssi is configured as a serial slave,
writing to this location has no effect; reading from this location
returns 0. Control register 1 controls the end of serial transfers
when in receive-only mode. It is impossible to write to this
register when the DW_apb_ssi is enabled. The DW_apb_ssi is enabled
and disabled by writing to the SSIENR register.
Reset Value: 0x0 */

  __IOM  uint32_t  SSIENR;  /*!< (@ 0x00000008) register SSIENR 
This register enables and disables the DW_apb_ssi.
Reset Value: 0x0 */

  __IOM  uint32_t  MWCR;  /*!< (@ 0x0000000c) register MWCR 
This register controls the direction of the data word for the half-duplex
Microwire serial protocol. It is impossible to write to this register
when the DW_apb_ssi is enabled. The DW_apb_ssi is enabled and disabled by
writing to the SSIENR register.
Reset Value: 0x0 */

  __IOM  uint32_t  SER;  /*!< (@ 0x00000010) register SER 
This register is valid only when the DW_apb_ssi is configured as a master
device. When the DW_apb_ssi is configured as a serial slave, writing to
this location has no effect; reading from this location returns 0. The
register enables the individual slave select output lines from the
DW_apb_ssi master. Up to 16 slave-select output pins are available on the
DW_apb_ssi master. Register bits can be set or cleared when SSI_EN=0. 

If SSI_EN=1, then register bits can be set (to delay the slave select assertion while TX FIFO is getting filled) but cannot be cleared.
Reset Value: 0x0 */

  __IOM  uint32_t  BAUDR;  /*!< (@ 0x00000014) register BAUDR 
This register is valid only when the DW_apb_ssi is configured as a master
device. When the DW_apb_ssi is configured as a serial slave, writing to
this location has no effect; reading from this location returns 0. The
register derives the frequency of the serial clock that regulates the data
transfer. The 16-bit field in this register defines the ssi_clk divider
value. It is impossible to write to this register when the DW_apb_ssi is
enabled. The DW_apb_ssi is enabled and disabled by writing to the SSIENR
register.
Reset Value: 0x0 */

  __IOM  uint32_t  TXFTLR;  /*!< (@ 0x00000018) register TXFTLR 
This register controls the threshold value for the transmit FIFO memory.
The DW_apb_ssi is enabled and disabled by writing to the SSIENR register.
Reset Value: 0x0 */

  __IOM  uint32_t  RXFTLR;  /*!< (@ 0x0000001c) register RXFTLR 
This register controls the threshold value for the receive FIFO memory.
The DW_apb_ssi is enabled and disabled by writing to the SSIENR register.
Reset Value: 0x0 */

   __IM  uint32_t  TXFLR;  /*!< (@ 0x00000020) register TXFLR 
This register contains the number of valid data entries in the transmit FIFO memory.
Reset Value: 0x0 */

   __IM  uint32_t  RXFLR;  /*!< (@ 0x00000024) register RXFLR 
This register contains the number of valid data entries in the receive FIFO memory.  This register can be ready at any time.
Reset Value: 0x0 */

   __IM  uint32_t  SR;  /*!< (@ 0x00000028) register SR 
This is a read-only register used to indicate the current transfer status,
FIFO status, and any transmission/reception errors that may have occurred.
The status register may be read at any time. None of the bits in this
register request an interrupt.
Reset Value: 0x6 */

  __IOM  uint32_t  IMR;  /*!< (@ 0x0000002c) register IMR 
This read/write reigster masks or enables all interrupts generated by the DW_apb_ssi.
When the DW_apb_ssi is configured as a slave device, the MSTIM bit field is not present. 
This changes the reset value from 0x3F for serial-master configurations to 0x1F for serial-slave
configurations.
Reset Value: (SSI_IS_MASTER == 1) ? 0x3F : 0x1F */

   __IM  uint32_t  ISR;  /*!< (@ 0x00000030) register ISR 
This register reports the status of the DW_apb_ssi interrupts after they have been masked.
Reset Value: 0x0 */

   __IM  uint32_t  RISR;  /*!< (@ 0x00000034) register RISR 
This read-only register reports the status of the DW_apb_ssi interrupts prior to masking.
Reset Value: 0x0 */

   __IM  uint32_t  TXOICR;  /*!< (@ 0x00000038) register TXOICR 
Transmit FIFO Overflow Interrupt Clear Register.
Reset Value: 0x0 */

   __IM  uint32_t  RXOICR;  /*!< (@ 0x0000003c) register RXOICR 
Receive FIFO Overflow Interrupt Clear Register.
Reset Value: 0x0 */

   __IM  uint32_t  RXUICR;  /*!< (@ 0x00000040) register RXUICR 
Receive FIFO Underflow Interrupt Clear Register.
Reset Value: 0x0 */

   __IM  uint32_t  MSTICR;  /*!< (@ 0x00000044) register MSTICR 
Multi-Master Interrupt Clear Register.
Reset Value: 0x0 */

   __IM  uint32_t  ICR;  /*!< (@ 0x00000048) register ICR 
Interrupt Clear Register.
Reset Value: 0x0 */

  __IOM  uint32_t  DMACR;  /*!< (@ 0x0000004c) register DMACR 
This register is only valid when DW_apb_ssi is configured with a set of
DMA Controller interface signals (SSI_HAS_DMA = 1). When DW_apb_ssi is
not configured for DMA operation, this register will not exist and writing
to the register's address will have no effect; reading from this register
address will return zero. The register is used to enable the DMA
Controller interface operation.
Reset Value: 0x0 */

  __IOM  uint32_t  DMATDLR;  /*!< (@ 0x00000050) register DMATDLR 
This register is only valid when the DW_apb_ssi is configured with a set
of DMA interface signals (SSI_HAS_DMA = 1). When DW_apb_ssi is not
configured for DMA operation, this register will not exist and writing
to its address will have no effect; reading from its address will
return zero.
Reset Value: 0x0 */

  __IOM  uint32_t  DMARDLR;  /*!< (@ 0x00000054) register DMARDLR 
This register is only valid when DW_apb_ssi is configured with a set of
DMA interface signals (SSI_HAS_DMA = 1). When DW_apb_ssi is not configured
for DMA operation, this register will not exist and writing to its address
will have no effect; reading from its address will return zero.
Reset Value: 0x0 */

   __IM  uint32_t  IDR;  /*!< (@ 0x00000058) register IDR 
This register contains the peripherals identification code, which is
written into the register at configuration time using coreConsultant.
Reset Value: SSI_ID */

   __IM  uint32_t  SSI_VERSION_ID;  /*!< (@ 0x0000005c) register SSI_VERSION_ID 
This read-only register stores the specific DW_apb_ssi component version.
Reset Value: SSI_VERSION_ID */

  __IOM  uint32_t  DR0;  /*!< (@ 0x00000060) register DR0 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR1;  /*!< (@ 0x00000064) register DR1 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR2;  /*!< (@ 0x00000068) register DR2 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR3;  /*!< (@ 0x0000006c) register DR3 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR4;  /*!< (@ 0x00000070) register DR4 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR5;  /*!< (@ 0x00000074) register DR5 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR6;  /*!< (@ 0x00000078) register DR6 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR7;  /*!< (@ 0x0000007c) register DR7 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR8;  /*!< (@ 0x00000080) register DR8 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR9;  /*!< (@ 0x00000084) register DR9 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR10;  /*!< (@ 0x00000088) register DR10 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR11;  /*!< (@ 0x0000008c) register DR11 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR12;  /*!< (@ 0x00000090) register DR12 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR13;  /*!< (@ 0x00000094) register DR13 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR14;  /*!< (@ 0x00000098) register DR14 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR15;  /*!< (@ 0x0000009c) register DR15 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR16;  /*!< (@ 0x000000a0) register DR16 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR17;  /*!< (@ 0x000000a4) register DR17 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR18;  /*!< (@ 0x000000a8) register DR18 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR19;  /*!< (@ 0x000000ac) register DR19 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR20;  /*!< (@ 0x000000b0) register DR20 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR21;  /*!< (@ 0x000000b4) register DR21 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR22;  /*!< (@ 0x000000b8) register DR22 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR23;  /*!< (@ 0x000000bc) register DR23 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR24;  /*!< (@ 0x000000c0) register DR24 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR25;  /*!< (@ 0x000000c4) register DR25 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR26;  /*!< (@ 0x000000c8) register DR26 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR27;  /*!< (@ 0x000000cc) register DR27 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR28;  /*!< (@ 0x000000d0) register DR28 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR29;  /*!< (@ 0x000000d4) register DR29 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR30;  /*!< (@ 0x000000d8) register DR30 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR31;  /*!< (@ 0x000000dc) register DR31 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR32;  /*!< (@ 0x000000e0) register DR32 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR33;  /*!< (@ 0x000000e4) register DR33 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR34;  /*!< (@ 0x000000e8) register DR34 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  DR35;  /*!< (@ 0x000000ec) register DR35 
The DW_apb_ssi data register is a 16/32-bit (depending on SSI_MAX_XFER_SIZE) read/write buffer for
the transmit/receive FIFOs. If the configuration parameter SSI_MAX_XFER_SIZE is set to 32, then all 32 bits
are valid, otherwise, only 16 bits ([15:0]) of the register are valid. When the register is read, data in the
receive FIFO buffer is accessed. When it is written to, data are moved into the transmit FIFO buffer; a write
can occur only when SSI_EN = 1. FIFOs are reset when SSI_EN = 0.
NOTE: The DR register in the DW_apb_ssi occupies thirty-six 32-bit address locations of the memory
map to facilitate AHB burst transfers. Writing to any of these address locations has the same
effect as pushing the data from the pwdata bus into the transmit FIFO. Reading from any of
these locations has the same effect as popping data from the receive FIFO onto the prdata
bus. The FIFO buffers on the DW_apb_ssi are not addressable.
Reset Value: 0x0 */

  __IOM  uint32_t  RX_SAMPLE_DLY;  /*!< (@ 0x000000f0) register RX_SAMPLE_DLY 
This register is only valid when the DW_apb_ssi is configured with rxd
sample delay logic (SSI_HAS_RX_SAMPLE_DELAY==1). When the DW_apb_ssi is
not configured with rxd sample delay logic, this register will not exist
and writing to its address location will have no effect; reading from
its address will return zero. 
This register control the number of ssi_clk
cycles that are delayed (from the default sample time) before the actual
sample of the rxd input occurs. It is impossible to write to this
register when the DW_apb_ssi is enabled. The DW_apb_ssi is enabled and
disabled by writing to the SSIENR register.
Reset Value: 0x0 */

   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
   __IM  uint32_t  RSVD;  /*!< (@ 0x000000fc) register RSVD 
RSVD - Reserved address location. */

} SPI_Type;     /*!< Size = 256 (0x100) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2C ================================================= */
/* =========================================================================================================================== */

/**
  * @brief I2C_Type peripheral I2C
  */
typedef struct {    /*!< (@ 0x40107000) I2C Structure */
  __IOM  uint32_t  IC_CON;  /*!< (@ 0x00000000) register IC_CON 
I2C Control Register.
This register can be written only when the DW_apb_i2c
is disabled, which corresponds to the IC_ENABLE[0] register
being set to 0. Writes at other times have no effect.

Read/Write Access: 
  - If configuration parameter I2C_DYNAMIC_TAR_UPDATE=1, bit 4 is read only.
  - If configuration parameter IC_RX_FULL_HLD_BUS_EN =0, bit 9 is read only.
  - If configuration parameter IC_STOP_DET_IF_MASTER_ACTIVE =0, bit 10 is read only.
  - If configuration parameter IC_BUS_CLEAR_FEATURE=0, bit 11 is read only
  - If configuration parameter IC_OPTIONAL_SAR=0, bit 16 is read only
  - If configuration parameter IC_SMBUS=0, bit 17 is read only
  - If configuration parameter IC_SMBUS_ARP=0, bits 18 and 19 are read only.
 */

  __IOM  uint32_t  IC_TAR;  /*!< (@ 0x00000004) register IC_TAR 
I2C Target Address Register

If the configuration parameter I2C_DYNAMIC_TAR_UPDATE is set to 'No' (0),
this register is 12 bits wide, and bits 31:12 are reserved. This register
can be written to only when IC_ENABLE[0] is set to 0.

However, if I2C_DYNAMIC_TAR_UPDATE = 1, then the register becomes 13 bits wide.
In this case, writes to IC_TAR succeed when one of the following conditions are true:
 - DW_apb_i2c is NOT enabled (IC_ENABLE[0] is set to 0); or
 - DW_apb_i2c is enabled (IC_ENABLE[0]=1); AND DW_apb_i2c is NOT engaged in any Master (tx, rx) operation (IC_STATUS[5]=0); AND DW_apb_i2c is enabled to operate in Master mode (IC_CON[0]=1); AND there are NO entries in the TX FIFO (IC_STATUS[2]=1)
You can change the TAR address dynamically without losing the bus, only if the following conditions are met.
 - DW_apb_i2c is enabled (IC_ENABLE[0]=1); AND IC_EMPTYFIFO_HOLD_MASTER_EN configuration parameter is set to 1; AND DW_apb_i2c is enabled to operate in Master mode (IC_CON[0]=1); AND there are NO entries in the Tx FIFO and the master is in HOLD state (IC_INTR_STAT[13]=1).
 Note: If the software or application is aware that the DW_apb_i2c is not using the TAR address for the pending commands in the
    Tx FIFO, then it is possible to update the TAR address even while the Tx FIFO has entries (IC_STATUS[2]= 0).
  - It is not necessary to perform any write to this register if DW_apb_i2c is enabled as an I2C slave only.
 */

  __IOM  uint32_t  IC_SAR;  /*!< (@ 0x00000008) register IC_SAR 
I2C Slave Address Register */

  __IOM  uint32_t  IC_HS_MADDR;  /*!< (@ 0x0000000c) register IC_HS_MADDR 
I2C High Speed Master Mode Code Address Register */

  __IOM  uint32_t  IC_DATA_CMD;  /*!< (@ 0x00000010) register IC_DATA_CMD 
I2C Rx/Tx Data Buffer and Command Register; this is the register the CPU writes to when filling the TX FIFO and the CPU reads from when retrieving bytes from RX FIFO.

The size of the register changes as follows:

Write:
 - 11 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=1
 - 9 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=0
Read:
 - 12 bits when IC_FIRST_DATA_BYTE_STATUS = 1
 - 8 bits when IC_FIRST_DATA_BYTE_STATUS = 0
Note: In order for the DW_apb_i2c to continue acknowledging reads, a read command should be
written for every byte that is to be received; otherwise the DW_apb_i2c will stop
acknowledging. */

  __IOM  uint32_t  IC_SS_SCL_HCNT;  /*!< (@ 0x00000014) register IC_SS_SCL_HCNT 
Standard Speed I2C Clock SCL High Count Register */

  __IOM  uint32_t  IC_SS_SCL_LCNT;  /*!< (@ 0x00000018) register IC_SS_SCL_LCNT 
Standard Speed I2C Clock SCL Low Count Register */

  __IOM  uint32_t  IC_FS_SCL_HCNT;  /*!< (@ 0x0000001c) register IC_FS_SCL_HCNT 
Fast Mode or Fast Mode Plus I2C Clock SCL High Count Register */

  __IOM  uint32_t  IC_FS_SCL_LCNT;  /*!< (@ 0x00000020) register IC_FS_SCL_LCNT 
Fast Mode or Fast Mode Plus I2C Clock SCL Low Count Register */

  __IOM  uint32_t  IC_HS_SCL_HCNT;  /*!< (@ 0x00000024) register IC_HS_SCL_HCNT 
High Speed I2C Clock SCL High Count Register */

  __IOM  uint32_t  IC_HS_SCL_LCNT;  /*!< (@ 0x00000028) register IC_HS_SCL_LCNT 
High Speed I2C Clock SCL Low Count Register */

   __IM  uint32_t  IC_INTR_STAT;  /*!< (@ 0x0000002c) register IC_INTR_STAT 
I2C Interrupt Status Register

Each bit in this register has a corresponding mask bit
in the IC_INTR_MASK register. These bits are cleared by reading the matching
interrupt clear register. The unmasked raw versions of these bits are
available in the IC_RAW_INTR_STAT register. */

  __IOM  uint32_t  IC_INTR_MASK;  /*!< (@ 0x00000030) register IC_INTR_MASK 
I2C Interrupt Mask Register.

These bits mask their corresponding interrupt status bits. This register is active low; 
a value of 0 masks the interrupt, whereas a value of 1 unmasks the interrupt.
 */

   __IM  uint32_t  IC_RAW_INTR_STAT;  /*!< (@ 0x00000034) register IC_RAW_INTR_STAT 
I2C Raw Interrupt Status Register

Unlike the IC_INTR_STAT register, these bits are not masked so they
always show the true status of the DW_apb_i2c. */

  __IOM  uint32_t  IC_RX_TL;  /*!< (@ 0x00000038) register IC_RX_TL 
I2C Receive FIFO Threshold Register */

  __IOM  uint32_t  IC_TX_TL;  /*!< (@ 0x0000003c) register IC_TX_TL 
I2C Transmit FIFO Threshold Register */

   __IM  uint32_t  IC_CLR_INTR;  /*!< (@ 0x00000040) register IC_CLR_INTR 
Clear Combined and Individual Interrupt Register */

   __IM  uint32_t  IC_CLR_RX_UNDER;  /*!< (@ 0x00000044) register IC_CLR_RX_UNDER 
Clear RX_UNDER Interrupt Register */

   __IM  uint32_t  IC_CLR_RX_OVER;  /*!< (@ 0x00000048) register IC_CLR_RX_OVER 
Clear RX_OVER Interrupt Register */

   __IM  uint32_t  IC_CLR_TX_OVER;  /*!< (@ 0x0000004c) register IC_CLR_TX_OVER 
Clear TX_OVER Interrupt Register */

   __IM  uint32_t  IC_CLR_RD_REQ;  /*!< (@ 0x00000050) register IC_CLR_RD_REQ 
Clear RD_REQ Interrupt Register */

   __IM  uint32_t  IC_CLR_TX_ABRT;  /*!< (@ 0x00000054) register IC_CLR_TX_ABRT 
Clear TX_ABRT Interrupt Register */

   __IM  uint32_t  IC_CLR_RX_DONE;  /*!< (@ 0x00000058) register IC_CLR_RX_DONE 
Clear RX_DONE Interrupt Register */

   __IM  uint32_t  IC_CLR_ACTIVITY;  /*!< (@ 0x0000005c) register IC_CLR_ACTIVITY 
Clear ACTIVITY Interrupt Register */

   __IM  uint32_t  IC_CLR_STOP_DET;  /*!< (@ 0x00000060) register IC_CLR_STOP_DET 
Clear STOP_DET Interrupt Register */

   __IM  uint32_t  IC_CLR_START_DET;  /*!< (@ 0x00000064) register IC_CLR_START_DET 
Clear START_DET Interrupt Register */

   __IM  uint32_t  IC_CLR_GEN_CALL;  /*!< (@ 0x00000068) register IC_CLR_GEN_CALL 
Clear GEN_CALL Interrupt Register */

  __IOM  uint32_t  IC_ENABLE;  /*!< (@ 0x0000006c) register IC_ENABLE 
I2C Enable Register */

   __IM  uint32_t  IC_STATUS;  /*!< (@ 0x00000070) register IC_STATUS 
I2C Status Register 

This is a read-only register used to indicate the current
transfer status and FIFO status. The status register may be
read at any time. None of the bits in this register request
an interrupt.

When the I2C is disabled by writing 0 in bit 0 of the IC_ENABLE register:
 - Bits 1 and 2 are set to 1
 - Bits 3 and 10 are set to 0
When the master or slave state machines goes to idle and ic_en=0:
 - Bits 5 and 6 are set to 0 */

   __IM  uint32_t  IC_TXFLR;  /*!< (@ 0x00000074) register IC_TXFLR 
I2C Transmit FIFO Level Register
This register contains the number of valid data entries in the transmit FIFO buffer. It is cleared whenever:
 - The I2C is disabled
 - There is a transmit abort - that is, TX_ABRT bit is set in the IC_RAW_INTR_STAT register
 - The slave bulk transmit mode is aborted
The register increments whenever data is placed into the transmit FIFO and decrements when data is taken from the transmit FIFO. */

   __IM  uint32_t  IC_RXFLR;  /*!< (@ 0x00000078) register IC_RXFLR 
I2C Receive FIFO Level Register
This register contains the number of valid data entries in the receive FIFO buffer. It is cleared whenever:
 - The I2C is disabled
 - Whenever there is a transmit abort caused by any of the events tracked in IC_TX_ABRT_SOURCE
The register increments whenever data is placed into the receive FIFO and decrements when data is taken from the receive FIFO. */

  __IOM  uint32_t  IC_SDA_HOLD;  /*!< (@ 0x0000007c) register IC_SDA_HOLD 
I2C SDA Hold Time Length Register

The bits [15:0] of this register are used to control the hold time of SDA during
transmit in both slave and master mode (after SCL goes from HIGH to LOW).

The bits [23:16] of this register are used to extend the SDA transition (if any) 
whenever SCL is HIGH in the receiver in either master or slave mode.

Writes to this register succeed only when IC_ENABLE[0]=0.

The values in this register are in units of ic_clk period. The value programmed 
in IC_SDA_TX_HOLD must be greater than the minimum hold time in each mode one 
cycle in master mode, seven cycles in slave mode for the value to be implemented.

The programmed SDA hold time during transmit (IC_SDA_TX_HOLD) cannot exceed at any 
time the duration of the low part of scl. Therefore the programmed value cannot be 
larger than N_SCL_LOW-2, where N_SCL_LOW is the duration of the low part of the scl 
period measured in ic_clk cycles.

 */

   __IM  uint32_t  IC_TX_ABRT_SOURCE;  /*!< (@ 0x00000080) register IC_TX_ABRT_SOURCE 
I2C Transmit Abort Source Register

This register has 32 bits that indicate the source
of the TX_ABRT bit. Except for Bit 9, this register is
cleared whenever the IC_CLR_TX_ABRT register or the
IC_CLR_INTR register is read. To clear Bit 9, the source
of the ABRT_SBYTE_NORSTRT must be fixed first; RESTART must
be enabled (IC_CON[5]=1), the SPECIAL bit must be cleared
(IC_TAR[11]), or the GC_OR_START bit must be cleared (IC_TAR[10]).

Once the source of the ABRT_SBYTE_NORSTRT is fixed, then this
bit can be cleared in the same manner as other bits in this
register. If the source of the ABRT_SBYTE_NORSTRT is not fixed
before attempting to clear this bit, Bit 9 clears for one cycle
and is then re-asserted. */

   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  IC_DMA_CR;  /*!< (@ 0x00000088) register IC_DMA_CR 
DMA Control Register

This register is only valid when DW_apb_i2c is configured
with a set of DMA Controller interface signals (IC_HAS_DMA = 1).
When DW_apb_i2c is not configured for DMA operation, this register
does not exist and writing to the register's address has no
effect and reading from this register address will return zero.
The register is used to enable the DMA Controller interface operation.
There is a separate bit for transmit and receive. This can be programmed
regardless of the state of IC_ENABLE. */

  __IOM  uint32_t  IC_DMA_TDLR;  /*!< (@ 0x0000008c) register IC_DMA_TDLR 
DMA Transmit Data Level Register

This register is only valid when the DW_apb_i2c
is configured with a set of DMA interface signals
(IC_HAS_DMA = 1). When DW_apb_i2c is not configured
for DMA operation, this register does not exist;
writing to its address has no effect; reading from
its address returns zero. */

  __IOM  uint32_t  IC_DMA_RDLR;  /*!< (@ 0x00000090) register IC_DMA_RDLR 
I2C Receive Data Level Register

This register is only valid when DW_apb_i2c
is configured with a set of DMA interface signals
(IC_HAS_DMA = 1). When DW_apb_i2c is not configured
for DMA operation, this register does not exist;
writing to its address has no effect; reading from
its address returns zero. */

  __IOM  uint32_t  IC_SDA_SETUP;  /*!< (@ 0x00000094) register IC_SDA_SETUP 
I2C SDA Setup Register

This register controls the amount of time delay
(in terms of number of ic_clk clock periods) introduced
in the rising edge of SCL - relative to SDA changing - when
DW_apb_i2c services a read request in a slave-transmitter operation.
The relevant I2C requirement is tSU:DAT (note 4) as detailed in the
I2C Bus Specification.
This register must be programmed with a value equal to or greater than 2. 

Writes to this register succeed only when IC_ENABLE[0] = 0.

Note: The length of setup time is calculated using [(IC_SDA_SETUP - 1) * (ic_clk_period)], so if the
user requires 10 ic_clk periods of setup time, they should program a value of 11.
The IC_SDA_SETUP register is only used by the DW_apb_i2c when operating as a slave
transmitter.
 */

  __IOM  uint32_t  IC_ACK_GENERAL_CALL;  /*!< (@ 0x00000098) register IC_ACK_GENERAL_CALL 
I2C ACK General Call Register

The register controls whether DW_apb_i2c responds
with a ACK or NACK when it receives an I2C
General Call address.

This register is applicable only when the DW_apb_i2c is in slave mode.
 */

   __IM  uint32_t  IC_ENABLE_STATUS;  /*!< (@ 0x0000009c) register IC_ENABLE_STATUS 
I2C Enable Status Register

The register is used to report the DW_apb_i2c hardware
status when the IC_ENABLE[0] register is set from 1 to 0;
that is, when DW_apb_i2c is disabled.

If IC_ENABLE[0] has been set to 1, bits 2:1 are forced to 0,
and bit 0 is forced to 1.

If IC_ENABLE[0] has been set to 0, bits 2:1 is only be valid
as soon as bit 0 is read as '0'.

Note: 
When IC_ENABLE[0] has been set to 0, a delay occurs for bit 0 to be read as 0 because
disabling the DW_apb_i2c depends on I2C bus activities.
 */

  __IOM  uint32_t  IC_FS_SPKLEN;  /*!< (@ 0x000000a0) register IC_FS_SPKLEN 
I2C SS, FS or FM+  spike suppression limit

This register is used to store the duration, measured in ic_clk cycles,
of the longest spike that is filtered out by the spike suppression logic w
hen the component is operating in SS, FS or FM+ modes. 
The relevant I2C requirement is tSP (table 4) as detailed in the 
I2C Bus Specification. This register must be programmed with a minimum value of 1.
 */

  __IOM  uint32_t  IC_HS_SPKLEN;  /*!< (@ 0x000000a4) register IC_HS_SPKLEN 
I2C HS spike suppression limit register

This register is used to store the duration, measured in ic_clk cycles,
of the longest spike that is filtered out by the spike suppression logic when the component is operating in HS modes. 
The relevant I2C requirement is tSP (table 6) as detailed in the 
I2C Bus Specification. This register must be programmed with a minimum value of 1 and is implemented only
if the component is configured to support HS mode; that is, if the IC_MAX_SPEED_MODE parameter is set to 3.
 */

   __IM  uint32_t  RESERVED1[19];  /*!< not covered by register fields! */
   __IM  uint32_t  IC_COMP_PARAM_1;  /*!< (@ 0x000000f4) register IC_COMP_PARAM_1 
Component Parameter Register 1

Note
This is a constant read-only register that contains
encoded information about the component's parameter settings.
The reset value depends on coreConsultant parameter(s). */

   __IM  uint32_t  IC_COMP_VERSION;  /*!< (@ 0x000000f8) register IC_COMP_VERSION 
I2C Component Version Register */

   __IM  uint32_t  IC_COMP_TYPE;  /*!< (@ 0x000000fc) register IC_COMP_TYPE 
I2C Component Type Register */

} I2C_Type;     /*!< Size = 256 (0x100) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2S ================================================= */
/* =========================================================================================================================== */

/**
  * @brief I2S_Type peripheral I2S
  */
typedef struct {    /*!< (@ 0x40109000) I2S Structure */
  __IOM  uint32_t  IER;  /*!< (@ 0x00000000) register IER 
This register acts as a global enable/disable for DW_apb_i2s. */

   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  ITER;  /*!< (@ 0x00000008) register ITER 
This register acts as an enable/disable for the DW_apb_i2s Transmitter block. */

  __IOM  uint32_t  CER;  /*!< (@ 0x0000000c) register CER 
This register acts as an enable/disable for the DW_apb_i2s Clock Generation block, which is only relevant in master mode (I2S_MODE_EN = 1). When this block is enabled, the clock signals sclk_en, ws_out, and sclk_gate appear on the interface. */

  __IOM  uint32_t  CCR;  /*!< (@ 0x00000010) register CCR 
This register configures the ws_out and sclk_gate signals when DW_apb_i2s is a master. */

   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
   __OM  uint32_t  TXFFR;  /*!< (@ 0x00000018) register TXFFR 
This register specifies the Transmitter Block FIFO Reset Register.
 */

   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
   __OM  uint32_t  LTHR0;  /*!< (@ 0x00000020) register LTHR0 
Left Transmit Holding Register 0 */

   __OM  uint32_t  RTHR0;  /*!< (@ 0x00000024) register RTHR0 
Right Transmit Holding Register 0 */

   __IM  uint32_t  RESERVED3;  /*!< not covered by register fields! */
  __IOM  uint32_t  TER0;  /*!< (@ 0x0000002c) register TER0 
This specifies the Transmit Enable Register.
 */

   __IM  uint32_t  RESERVED4;  /*!< not covered by register fields! */
  __IOM  uint32_t  TCR0;  /*!< (@ 0x00000034) register TCR0 
This specifies the Transmit Configuration Register.
 */

   __IM  uint32_t  ISR0;  /*!< (@ 0x00000038) register ISR0 
This specifies the Interrupt Status Register.
 */

  __IOM  uint32_t  IMR0;  /*!< (@ 0x0000003c) register IMR0 
This specifies the Interrupt Mask Register.
 */

   __IM  uint32_t  RESERVED5;  /*!< not covered by register fields! */
   __IM  uint32_t  TOR0;  /*!< (@ 0x00000044) register TOR0 
This specifies the Transmit Overrun Register.
 */

   __IM  uint32_t  RESERVED6;  /*!< not covered by register fields! */
  __IOM  uint32_t  TFCR0;  /*!< (@ 0x0000004c) register TFCR0 
This specifies the Transmit FIFO Configuration Register.
 */

   __IM  uint32_t  RESERVED7;  /*!< not covered by register fields! */
   __OM  uint32_t  TFF0;  /*!< (@ 0x00000054) register TFF0 
This specifies the Transmit FIFO Flush Register.
 */

   __IM  uint32_t  RESERVED8[92];  /*!< not covered by register fields! */
   __OM  uint32_t  TXDMA;  /*!< (@ 0x000001c8) register TXDMA 

The TXDMA register functions similar to the RXDMA register and allows write accesses to all of the enabled
Transmit channels via a single point rather than through the LTHRx and RTHRx registers.

Note: There is no write coherency logic, the APB_DATA_WIDTH
must be greater than or equal to the largest Transmit channel
word size to ensure all half data pairs can be written using
a single write.

Channels can be enabled or disabled during the write cycles;
however, DW_apb_i2s does not support disabling a channel in
the middle of a stereo pair. */

   __IM  uint32_t  RESERVED9[9];  /*!< not covered by register fields! */
   __IM  uint32_t  I2S_COMP_PARAM_2;  /*!< (@ 0x000001f0) register I2S_COMP_PARAM_2 
This specifies bits for Component Parameter Register 2.

Note: This is a constant read-only register that contains encoded information about the component's
parameter settings. The reset value depends on coreConsultant parameter(s).
 */

   __IM  uint32_t  I2S_COMP_PARAM_1;  /*!< (@ 0x000001f4) register I2S_COMP_PARAM_1 
This specifies bits for Component Parameter Register 1.

Note: This is a constant read-only register that contains encoded information about the component's
parameter settings. The reset value depends on coreConsultant parameter(s).
 */

   __IM  uint32_t  I2S_COMP_VERSION;  /*!< (@ 0x000001f8) register I2S_COMP_VERSION 
This register specifies the I2S Component Version.
 */

   __IM  uint32_t  I2S_COMP_TYPE;  /*!< (@ 0x000001fc) register I2S_COMP_TYPE 
This register specifies the I2S Component Type.
 */

} I2S_Type;     /*!< Size = 512 (0x200) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GPIO ================================================ */
/* =========================================================================================================================== */

/**
  * @brief GPIO_Type peripheral GPIO
  */
typedef struct {    /*!< (@ 0x4010A000) GPIO Structure */
  __IOM  uint32_t  DATA_IN;  /*!< (@ 0x00000000) register DATA_IN */
  __IOM  uint32_t  DATA_OUT;  /*!< (@ 0x00000004) register DATA_OUT */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  OUT_EN_SET;  /*!< (@ 0x00000010) register OUT_EN_SET */
  __IOM  uint32_t  OUT_EN_CLR;  /*!< (@ 0x00000014) register OUT_EN_CLR */
   __IM  uint32_t  RESERVED1[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  INT_EN_SET;  /*!< (@ 0x00000020) register INT_EN_SET */
  __IOM  uint32_t  INT_EN_CLR;  /*!< (@ 0x00000024) register INT_EN_CLR */
  __IOM  uint32_t  INT_TYPE_SET;  /*!< (@ 0x00000028) register INT_TYPE_SET */
  __IOM  uint32_t  INT_TYPE_CLR;  /*!< (@ 0x0000002c) register INT_TYPE_CLR */
  __IOM  uint32_t  INT_POL_SET;  /*!< (@ 0x00000030) register INT_POL_SET */
  __IOM  uint32_t  INT_POL_CLR;  /*!< (@ 0x00000034) register INT_POL_CLR */
  __IOM  uint32_t  INT_STATUS;  /*!< (@ 0x00000038) register INT_STATUS */
   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
   __IM  uint32_t  SEC_INT_STAT;  /*!< (@ 0x00000040) register SEC_INT_STAT */
   __OM  uint32_t  SEC_INT_CLR;  /*!< (@ 0x00000044) register SEC_INT_CLR */
  __IOM  uint32_t  SEC_INT_MASK;  /*!< (@ 0x00000048) register SEC_INT_MASK */
   __IM  uint32_t  SEC_INT_INFO1;  /*!< (@ 0x0000004c) register SEC_INT_INFO1 */
   __IM  uint32_t  SEC_INT_INFO2;  /*!< (@ 0x00000050) register SEC_INT_INFO2 */
   __OM  uint32_t  SEC_INT_SET;  /*!< (@ 0x00000054) register SEC_INT_SET */
  __IOM  uint32_t  PORT_NONSEC_MASK;  /*!< (@ 0x00000058) register PORT_NONSEC_MASK */
   __IM  uint32_t  RESERVED3[233];  /*!< not covered by register fields! */
  __IOM  uint32_t  MASK_LOW_BYTE0;  /*!< (@ 0x00000400) DIM-register 'MASK_LOW_BYTE%s', element 0 */
  __IOM  uint32_t  MASK_LOW_BYTE1;  /*!< (@ 0x00000404) DIM-register 'MASK_LOW_BYTE%s', element 1 */
  __IOM  uint32_t  MASK_LOW_BYTE2;  /*!< (@ 0x00000408) DIM-register 'MASK_LOW_BYTE%s', element 2 */
  __IOM  uint32_t  MASK_LOW_BYTE3;  /*!< (@ 0x0000040c) DIM-register 'MASK_LOW_BYTE%s', element 3 */
  __IOM  uint32_t  MASK_LOW_BYTE4;  /*!< (@ 0x00000410) DIM-register 'MASK_LOW_BYTE%s', element 4 */
  __IOM  uint32_t  MASK_LOW_BYTE5;  /*!< (@ 0x00000414) DIM-register 'MASK_LOW_BYTE%s', element 5 */
  __IOM  uint32_t  MASK_LOW_BYTE6;  /*!< (@ 0x00000418) DIM-register 'MASK_LOW_BYTE%s', element 6 */
  __IOM  uint32_t  MASK_LOW_BYTE7;  /*!< (@ 0x0000041c) DIM-register 'MASK_LOW_BYTE%s', element 7 */
  __IOM  uint32_t  MASK_LOW_BYTE8;  /*!< (@ 0x00000420) DIM-register 'MASK_LOW_BYTE%s', element 8 */
  __IOM  uint32_t  MASK_LOW_BYTE9;  /*!< (@ 0x00000424) DIM-register 'MASK_LOW_BYTE%s', element 9 */
  __IOM  uint32_t  MASK_LOW_BYTE10;  /*!< (@ 0x00000428) DIM-register 'MASK_LOW_BYTE%s', element 10 */
  __IOM  uint32_t  MASK_LOW_BYTE11;  /*!< (@ 0x0000042c) DIM-register 'MASK_LOW_BYTE%s', element 11 */
  __IOM  uint32_t  MASK_LOW_BYTE12;  /*!< (@ 0x00000430) DIM-register 'MASK_LOW_BYTE%s', element 12 */
  __IOM  uint32_t  MASK_LOW_BYTE13;  /*!< (@ 0x00000434) DIM-register 'MASK_LOW_BYTE%s', element 13 */
  __IOM  uint32_t  MASK_LOW_BYTE14;  /*!< (@ 0x00000438) DIM-register 'MASK_LOW_BYTE%s', element 14 */
  __IOM  uint32_t  MASK_LOW_BYTE15;  /*!< (@ 0x0000043c) DIM-register 'MASK_LOW_BYTE%s', element 15 */
  __IOM  uint32_t  MASK_LOW_BYTE16;  /*!< (@ 0x00000440) DIM-register 'MASK_LOW_BYTE%s', element 16 */
  __IOM  uint32_t  MASK_LOW_BYTE17;  /*!< (@ 0x00000444) DIM-register 'MASK_LOW_BYTE%s', element 17 */
  __IOM  uint32_t  MASK_LOW_BYTE18;  /*!< (@ 0x00000448) DIM-register 'MASK_LOW_BYTE%s', element 18 */
  __IOM  uint32_t  MASK_LOW_BYTE19;  /*!< (@ 0x0000044c) DIM-register 'MASK_LOW_BYTE%s', element 19 */
  __IOM  uint32_t  MASK_LOW_BYTE20;  /*!< (@ 0x00000450) DIM-register 'MASK_LOW_BYTE%s', element 20 */
  __IOM  uint32_t  MASK_LOW_BYTE21;  /*!< (@ 0x00000454) DIM-register 'MASK_LOW_BYTE%s', element 21 */
  __IOM  uint32_t  MASK_LOW_BYTE22;  /*!< (@ 0x00000458) DIM-register 'MASK_LOW_BYTE%s', element 22 */
  __IOM  uint32_t  MASK_LOW_BYTE23;  /*!< (@ 0x0000045c) DIM-register 'MASK_LOW_BYTE%s', element 23 */
  __IOM  uint32_t  MASK_LOW_BYTE24;  /*!< (@ 0x00000460) DIM-register 'MASK_LOW_BYTE%s', element 24 */
  __IOM  uint32_t  MASK_LOW_BYTE25;  /*!< (@ 0x00000464) DIM-register 'MASK_LOW_BYTE%s', element 25 */
  __IOM  uint32_t  MASK_LOW_BYTE26;  /*!< (@ 0x00000468) DIM-register 'MASK_LOW_BYTE%s', element 26 */
  __IOM  uint32_t  MASK_LOW_BYTE27;  /*!< (@ 0x0000046c) DIM-register 'MASK_LOW_BYTE%s', element 27 */
  __IOM  uint32_t  MASK_LOW_BYTE28;  /*!< (@ 0x00000470) DIM-register 'MASK_LOW_BYTE%s', element 28 */
  __IOM  uint32_t  MASK_LOW_BYTE29;  /*!< (@ 0x00000474) DIM-register 'MASK_LOW_BYTE%s', element 29 */
  __IOM  uint32_t  MASK_LOW_BYTE30;  /*!< (@ 0x00000478) DIM-register 'MASK_LOW_BYTE%s', element 30 */
  __IOM  uint32_t  MASK_LOW_BYTE31;  /*!< (@ 0x0000047c) DIM-register 'MASK_LOW_BYTE%s', element 31 */
  __IOM  uint32_t  MASK_LOW_BYTE32;  /*!< (@ 0x00000480) DIM-register 'MASK_LOW_BYTE%s', element 32 */
  __IOM  uint32_t  MASK_LOW_BYTE33;  /*!< (@ 0x00000484) DIM-register 'MASK_LOW_BYTE%s', element 33 */
  __IOM  uint32_t  MASK_LOW_BYTE34;  /*!< (@ 0x00000488) DIM-register 'MASK_LOW_BYTE%s', element 34 */
  __IOM  uint32_t  MASK_LOW_BYTE35;  /*!< (@ 0x0000048c) DIM-register 'MASK_LOW_BYTE%s', element 35 */
  __IOM  uint32_t  MASK_LOW_BYTE36;  /*!< (@ 0x00000490) DIM-register 'MASK_LOW_BYTE%s', element 36 */
  __IOM  uint32_t  MASK_LOW_BYTE37;  /*!< (@ 0x00000494) DIM-register 'MASK_LOW_BYTE%s', element 37 */
  __IOM  uint32_t  MASK_LOW_BYTE38;  /*!< (@ 0x00000498) DIM-register 'MASK_LOW_BYTE%s', element 38 */
  __IOM  uint32_t  MASK_LOW_BYTE39;  /*!< (@ 0x0000049c) DIM-register 'MASK_LOW_BYTE%s', element 39 */
  __IOM  uint32_t  MASK_LOW_BYTE40;  /*!< (@ 0x000004a0) DIM-register 'MASK_LOW_BYTE%s', element 40 */
  __IOM  uint32_t  MASK_LOW_BYTE41;  /*!< (@ 0x000004a4) DIM-register 'MASK_LOW_BYTE%s', element 41 */
  __IOM  uint32_t  MASK_LOW_BYTE42;  /*!< (@ 0x000004a8) DIM-register 'MASK_LOW_BYTE%s', element 42 */
  __IOM  uint32_t  MASK_LOW_BYTE43;  /*!< (@ 0x000004ac) DIM-register 'MASK_LOW_BYTE%s', element 43 */
  __IOM  uint32_t  MASK_LOW_BYTE44;  /*!< (@ 0x000004b0) DIM-register 'MASK_LOW_BYTE%s', element 44 */
  __IOM  uint32_t  MASK_LOW_BYTE45;  /*!< (@ 0x000004b4) DIM-register 'MASK_LOW_BYTE%s', element 45 */
  __IOM  uint32_t  MASK_LOW_BYTE46;  /*!< (@ 0x000004b8) DIM-register 'MASK_LOW_BYTE%s', element 46 */
  __IOM  uint32_t  MASK_LOW_BYTE47;  /*!< (@ 0x000004bc) DIM-register 'MASK_LOW_BYTE%s', element 47 */
  __IOM  uint32_t  MASK_LOW_BYTE48;  /*!< (@ 0x000004c0) DIM-register 'MASK_LOW_BYTE%s', element 48 */
  __IOM  uint32_t  MASK_LOW_BYTE49;  /*!< (@ 0x000004c4) DIM-register 'MASK_LOW_BYTE%s', element 49 */
  __IOM  uint32_t  MASK_LOW_BYTE50;  /*!< (@ 0x000004c8) DIM-register 'MASK_LOW_BYTE%s', element 50 */
  __IOM  uint32_t  MASK_LOW_BYTE51;  /*!< (@ 0x000004cc) DIM-register 'MASK_LOW_BYTE%s', element 51 */
  __IOM  uint32_t  MASK_LOW_BYTE52;  /*!< (@ 0x000004d0) DIM-register 'MASK_LOW_BYTE%s', element 52 */
  __IOM  uint32_t  MASK_LOW_BYTE53;  /*!< (@ 0x000004d4) DIM-register 'MASK_LOW_BYTE%s', element 53 */
  __IOM  uint32_t  MASK_LOW_BYTE54;  /*!< (@ 0x000004d8) DIM-register 'MASK_LOW_BYTE%s', element 54 */
  __IOM  uint32_t  MASK_LOW_BYTE55;  /*!< (@ 0x000004dc) DIM-register 'MASK_LOW_BYTE%s', element 55 */
  __IOM  uint32_t  MASK_LOW_BYTE56;  /*!< (@ 0x000004e0) DIM-register 'MASK_LOW_BYTE%s', element 56 */
  __IOM  uint32_t  MASK_LOW_BYTE57;  /*!< (@ 0x000004e4) DIM-register 'MASK_LOW_BYTE%s', element 57 */
  __IOM  uint32_t  MASK_LOW_BYTE58;  /*!< (@ 0x000004e8) DIM-register 'MASK_LOW_BYTE%s', element 58 */
  __IOM  uint32_t  MASK_LOW_BYTE59;  /*!< (@ 0x000004ec) DIM-register 'MASK_LOW_BYTE%s', element 59 */
  __IOM  uint32_t  MASK_LOW_BYTE60;  /*!< (@ 0x000004f0) DIM-register 'MASK_LOW_BYTE%s', element 60 */
  __IOM  uint32_t  MASK_LOW_BYTE61;  /*!< (@ 0x000004f4) DIM-register 'MASK_LOW_BYTE%s', element 61 */
  __IOM  uint32_t  MASK_LOW_BYTE62;  /*!< (@ 0x000004f8) DIM-register 'MASK_LOW_BYTE%s', element 62 */
  __IOM  uint32_t  MASK_LOW_BYTE63;  /*!< (@ 0x000004fc) DIM-register 'MASK_LOW_BYTE%s', element 63 */
   __IM  uint32_t  RESERVED4[192];  /*!< not covered by register fields! */
  __IOM  uint32_t  MASK_HIGH_BYTE0;  /*!< (@ 0x00000800) DIM-register 'MASK_HIGH_BYTE%s', element 0 */
  __IOM  uint32_t  MASK_HIGH_BYTE1;  /*!< (@ 0x00000804) DIM-register 'MASK_HIGH_BYTE%s', element 1 */
  __IOM  uint32_t  MASK_HIGH_BYTE2;  /*!< (@ 0x00000808) DIM-register 'MASK_HIGH_BYTE%s', element 2 */
  __IOM  uint32_t  MASK_HIGH_BYTE3;  /*!< (@ 0x0000080c) DIM-register 'MASK_HIGH_BYTE%s', element 3 */
  __IOM  uint32_t  MASK_HIGH_BYTE4;  /*!< (@ 0x00000810) DIM-register 'MASK_HIGH_BYTE%s', element 4 */
  __IOM  uint32_t  MASK_HIGH_BYTE5;  /*!< (@ 0x00000814) DIM-register 'MASK_HIGH_BYTE%s', element 5 */
  __IOM  uint32_t  MASK_HIGH_BYTE6;  /*!< (@ 0x00000818) DIM-register 'MASK_HIGH_BYTE%s', element 6 */
  __IOM  uint32_t  MASK_HIGH_BYTE7;  /*!< (@ 0x0000081c) DIM-register 'MASK_HIGH_BYTE%s', element 7 */
  __IOM  uint32_t  MASK_HIGH_BYTE8;  /*!< (@ 0x00000820) DIM-register 'MASK_HIGH_BYTE%s', element 8 */
  __IOM  uint32_t  MASK_HIGH_BYTE9;  /*!< (@ 0x00000824) DIM-register 'MASK_HIGH_BYTE%s', element 9 */
  __IOM  uint32_t  MASK_HIGH_BYTE10;  /*!< (@ 0x00000828) DIM-register 'MASK_HIGH_BYTE%s', element 10 */
  __IOM  uint32_t  MASK_HIGH_BYTE11;  /*!< (@ 0x0000082c) DIM-register 'MASK_HIGH_BYTE%s', element 11 */
  __IOM  uint32_t  MASK_HIGH_BYTE12;  /*!< (@ 0x00000830) DIM-register 'MASK_HIGH_BYTE%s', element 12 */
  __IOM  uint32_t  MASK_HIGH_BYTE13;  /*!< (@ 0x00000834) DIM-register 'MASK_HIGH_BYTE%s', element 13 */
  __IOM  uint32_t  MASK_HIGH_BYTE14;  /*!< (@ 0x00000838) DIM-register 'MASK_HIGH_BYTE%s', element 14 */
  __IOM  uint32_t  MASK_HIGH_BYTE15;  /*!< (@ 0x0000083c) DIM-register 'MASK_HIGH_BYTE%s', element 15 */
  __IOM  uint32_t  MASK_HIGH_BYTE16;  /*!< (@ 0x00000840) DIM-register 'MASK_HIGH_BYTE%s', element 16 */
  __IOM  uint32_t  MASK_HIGH_BYTE17;  /*!< (@ 0x00000844) DIM-register 'MASK_HIGH_BYTE%s', element 17 */
  __IOM  uint32_t  MASK_HIGH_BYTE18;  /*!< (@ 0x00000848) DIM-register 'MASK_HIGH_BYTE%s', element 18 */
  __IOM  uint32_t  MASK_HIGH_BYTE19;  /*!< (@ 0x0000084c) DIM-register 'MASK_HIGH_BYTE%s', element 19 */
  __IOM  uint32_t  MASK_HIGH_BYTE20;  /*!< (@ 0x00000850) DIM-register 'MASK_HIGH_BYTE%s', element 20 */
  __IOM  uint32_t  MASK_HIGH_BYTE21;  /*!< (@ 0x00000854) DIM-register 'MASK_HIGH_BYTE%s', element 21 */
  __IOM  uint32_t  MASK_HIGH_BYTE22;  /*!< (@ 0x00000858) DIM-register 'MASK_HIGH_BYTE%s', element 22 */
  __IOM  uint32_t  MASK_HIGH_BYTE23;  /*!< (@ 0x0000085c) DIM-register 'MASK_HIGH_BYTE%s', element 23 */
  __IOM  uint32_t  MASK_HIGH_BYTE24;  /*!< (@ 0x00000860) DIM-register 'MASK_HIGH_BYTE%s', element 24 */
  __IOM  uint32_t  MASK_HIGH_BYTE25;  /*!< (@ 0x00000864) DIM-register 'MASK_HIGH_BYTE%s', element 25 */
  __IOM  uint32_t  MASK_HIGH_BYTE26;  /*!< (@ 0x00000868) DIM-register 'MASK_HIGH_BYTE%s', element 26 */
  __IOM  uint32_t  MASK_HIGH_BYTE27;  /*!< (@ 0x0000086c) DIM-register 'MASK_HIGH_BYTE%s', element 27 */
  __IOM  uint32_t  MASK_HIGH_BYTE28;  /*!< (@ 0x00000870) DIM-register 'MASK_HIGH_BYTE%s', element 28 */
  __IOM  uint32_t  MASK_HIGH_BYTE29;  /*!< (@ 0x00000874) DIM-register 'MASK_HIGH_BYTE%s', element 29 */
  __IOM  uint32_t  MASK_HIGH_BYTE30;  /*!< (@ 0x00000878) DIM-register 'MASK_HIGH_BYTE%s', element 30 */
  __IOM  uint32_t  MASK_HIGH_BYTE31;  /*!< (@ 0x0000087c) DIM-register 'MASK_HIGH_BYTE%s', element 31 */
  __IOM  uint32_t  MASK_HIGH_BYTE32;  /*!< (@ 0x00000880) DIM-register 'MASK_HIGH_BYTE%s', element 32 */
  __IOM  uint32_t  MASK_HIGH_BYTE33;  /*!< (@ 0x00000884) DIM-register 'MASK_HIGH_BYTE%s', element 33 */
  __IOM  uint32_t  MASK_HIGH_BYTE34;  /*!< (@ 0x00000888) DIM-register 'MASK_HIGH_BYTE%s', element 34 */
  __IOM  uint32_t  MASK_HIGH_BYTE35;  /*!< (@ 0x0000088c) DIM-register 'MASK_HIGH_BYTE%s', element 35 */
  __IOM  uint32_t  MASK_HIGH_BYTE36;  /*!< (@ 0x00000890) DIM-register 'MASK_HIGH_BYTE%s', element 36 */
  __IOM  uint32_t  MASK_HIGH_BYTE37;  /*!< (@ 0x00000894) DIM-register 'MASK_HIGH_BYTE%s', element 37 */
  __IOM  uint32_t  MASK_HIGH_BYTE38;  /*!< (@ 0x00000898) DIM-register 'MASK_HIGH_BYTE%s', element 38 */
  __IOM  uint32_t  MASK_HIGH_BYTE39;  /*!< (@ 0x0000089c) DIM-register 'MASK_HIGH_BYTE%s', element 39 */
  __IOM  uint32_t  MASK_HIGH_BYTE40;  /*!< (@ 0x000008a0) DIM-register 'MASK_HIGH_BYTE%s', element 40 */
  __IOM  uint32_t  MASK_HIGH_BYTE41;  /*!< (@ 0x000008a4) DIM-register 'MASK_HIGH_BYTE%s', element 41 */
  __IOM  uint32_t  MASK_HIGH_BYTE42;  /*!< (@ 0x000008a8) DIM-register 'MASK_HIGH_BYTE%s', element 42 */
  __IOM  uint32_t  MASK_HIGH_BYTE43;  /*!< (@ 0x000008ac) DIM-register 'MASK_HIGH_BYTE%s', element 43 */
  __IOM  uint32_t  MASK_HIGH_BYTE44;  /*!< (@ 0x000008b0) DIM-register 'MASK_HIGH_BYTE%s', element 44 */
  __IOM  uint32_t  MASK_HIGH_BYTE45;  /*!< (@ 0x000008b4) DIM-register 'MASK_HIGH_BYTE%s', element 45 */
  __IOM  uint32_t  MASK_HIGH_BYTE46;  /*!< (@ 0x000008b8) DIM-register 'MASK_HIGH_BYTE%s', element 46 */
  __IOM  uint32_t  MASK_HIGH_BYTE47;  /*!< (@ 0x000008bc) DIM-register 'MASK_HIGH_BYTE%s', element 47 */
  __IOM  uint32_t  MASK_HIGH_BYTE48;  /*!< (@ 0x000008c0) DIM-register 'MASK_HIGH_BYTE%s', element 48 */
  __IOM  uint32_t  MASK_HIGH_BYTE49;  /*!< (@ 0x000008c4) DIM-register 'MASK_HIGH_BYTE%s', element 49 */
  __IOM  uint32_t  MASK_HIGH_BYTE50;  /*!< (@ 0x000008c8) DIM-register 'MASK_HIGH_BYTE%s', element 50 */
  __IOM  uint32_t  MASK_HIGH_BYTE51;  /*!< (@ 0x000008cc) DIM-register 'MASK_HIGH_BYTE%s', element 51 */
  __IOM  uint32_t  MASK_HIGH_BYTE52;  /*!< (@ 0x000008d0) DIM-register 'MASK_HIGH_BYTE%s', element 52 */
  __IOM  uint32_t  MASK_HIGH_BYTE53;  /*!< (@ 0x000008d4) DIM-register 'MASK_HIGH_BYTE%s', element 53 */
  __IOM  uint32_t  MASK_HIGH_BYTE54;  /*!< (@ 0x000008d8) DIM-register 'MASK_HIGH_BYTE%s', element 54 */
  __IOM  uint32_t  MASK_HIGH_BYTE55;  /*!< (@ 0x000008dc) DIM-register 'MASK_HIGH_BYTE%s', element 55 */
  __IOM  uint32_t  MASK_HIGH_BYTE56;  /*!< (@ 0x000008e0) DIM-register 'MASK_HIGH_BYTE%s', element 56 */
  __IOM  uint32_t  MASK_HIGH_BYTE57;  /*!< (@ 0x000008e4) DIM-register 'MASK_HIGH_BYTE%s', element 57 */
  __IOM  uint32_t  MASK_HIGH_BYTE58;  /*!< (@ 0x000008e8) DIM-register 'MASK_HIGH_BYTE%s', element 58 */
  __IOM  uint32_t  MASK_HIGH_BYTE59;  /*!< (@ 0x000008ec) DIM-register 'MASK_HIGH_BYTE%s', element 59 */
  __IOM  uint32_t  MASK_HIGH_BYTE60;  /*!< (@ 0x000008f0) DIM-register 'MASK_HIGH_BYTE%s', element 60 */
  __IOM  uint32_t  MASK_HIGH_BYTE61;  /*!< (@ 0x000008f4) DIM-register 'MASK_HIGH_BYTE%s', element 61 */
  __IOM  uint32_t  MASK_HIGH_BYTE62;  /*!< (@ 0x000008f8) DIM-register 'MASK_HIGH_BYTE%s', element 62 */
  __IOM  uint32_t  MASK_HIGH_BYTE63;  /*!< (@ 0x000008fc) DIM-register 'MASK_HIGH_BYTE%s', element 63 */
   __IM  uint32_t  RESERVED5[436];  /*!< not covered by register fields! */
   __IM  uint32_t  PID4;  /*!< (@ 0x00000fd0) register PID4 */
   __IM  uint32_t  PID5;  /*!< (@ 0x00000fd4) register PID5 
Peripheral ID Register 5 */

   __IM  uint32_t  PID6;  /*!< (@ 0x00000fd8) register PID6 */
   __IM  uint32_t  PID7;  /*!< (@ 0x00000fdc) register PID7 */
   __IM  uint32_t  PID0;  /*!< (@ 0x00000fe0) register PID0 */
   __IM  uint32_t  PID1;  /*!< (@ 0x00000fe4) register PID1 
Peripheral ID 1 */

   __IM  uint32_t  PID2;  /*!< (@ 0x00000fe8) register PID2 */
   __IM  uint32_t  PID3;  /*!< (@ 0x00000fec) register PID3 */
   __IM  uint32_t  CID0;  /*!< (@ 0x00000ff0) register CID0 */
   __IM  uint32_t  CID1;  /*!< (@ 0x00000ff4) register CID1 */
   __IM  uint32_t  CID2;  /*!< (@ 0x00000ff8) register CID2 */
   __IM  uint32_t  CID3;  /*!< (@ 0x00000ffc) register CID3 */
} GPIO_Type;     /*!< Size = 4096 (0x1000) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: CAN ================================================= */
/* =========================================================================================================================== */

/**
  * @brief CAN_Type peripheral CAN
  */
typedef struct {    /*!< (@ 0x40110000) CAN Structure */
  __IOM  uint32_t  RBUF0;  /*!< (@ 0x00000000) DIM-register 'RBUF%s', element 0 */
  __IOM  uint32_t  RBUF1;  /*!< (@ 0x00000004) DIM-register 'RBUF%s', element 1 */
  __IOM  uint32_t  RBUF2;  /*!< (@ 0x00000008) DIM-register 'RBUF%s', element 2 */
  __IOM  uint32_t  RBUF3;  /*!< (@ 0x0000000c) DIM-register 'RBUF%s', element 3 */
  __IOM  uint32_t  RBUF4;  /*!< (@ 0x00000010) DIM-register 'RBUF%s', element 4 */
  __IOM  uint32_t  RBUF5;  /*!< (@ 0x00000014) DIM-register 'RBUF%s', element 5 */
  __IOM  uint32_t  RBUF6;  /*!< (@ 0x00000018) DIM-register 'RBUF%s', element 6 */
  __IOM  uint32_t  RBUF7;  /*!< (@ 0x0000001c) DIM-register 'RBUF%s', element 7 */
  __IOM  uint32_t  RBUF8;  /*!< (@ 0x00000020) DIM-register 'RBUF%s', element 8 */
  __IOM  uint32_t  RBUF9;  /*!< (@ 0x00000024) DIM-register 'RBUF%s', element 9 */
  __IOM  uint32_t  RBUF10;  /*!< (@ 0x00000028) DIM-register 'RBUF%s', element 10 */
  __IOM  uint32_t  RBUF11;  /*!< (@ 0x0000002c) DIM-register 'RBUF%s', element 11 */
  __IOM  uint32_t  RBUF12;  /*!< (@ 0x00000030) DIM-register 'RBUF%s', element 12 */
  __IOM  uint32_t  RBUF13;  /*!< (@ 0x00000034) DIM-register 'RBUF%s', element 13 */
  __IOM  uint32_t  RBUF14;  /*!< (@ 0x00000038) DIM-register 'RBUF%s', element 14 */
  __IOM  uint32_t  RBUF15;  /*!< (@ 0x0000003c) DIM-register 'RBUF%s', element 15 */
  __IOM  uint32_t  RBUF16;  /*!< (@ 0x00000040) DIM-register 'RBUF%s', element 16 */
  __IOM  uint32_t  RBUF17;  /*!< (@ 0x00000044) DIM-register 'RBUF%s', element 17 */
  __IOM  uint32_t  RBUF18;  /*!< (@ 0x00000048) DIM-register 'RBUF%s', element 18 */
  __IOM  uint32_t  RBUF19;  /*!< (@ 0x0000004c) DIM-register 'RBUF%s', element 19 */
  __IOM  uint32_t  TBUF0;  /*!< (@ 0x00000050) DIM-register 'TBUF%s', element 0 */
  __IOM  uint32_t  TBUF1;  /*!< (@ 0x00000054) DIM-register 'TBUF%s', element 1 */
  __IOM  uint32_t  TBUF2;  /*!< (@ 0x00000058) DIM-register 'TBUF%s', element 2 */
  __IOM  uint32_t  TBUF3;  /*!< (@ 0x0000005c) DIM-register 'TBUF%s', element 3 */
  __IOM  uint32_t  TBUF4;  /*!< (@ 0x00000060) DIM-register 'TBUF%s', element 4 */
  __IOM  uint32_t  TBUF5;  /*!< (@ 0x00000064) DIM-register 'TBUF%s', element 5 */
  __IOM  uint32_t  TBUF6;  /*!< (@ 0x00000068) DIM-register 'TBUF%s', element 6 */
  __IOM  uint32_t  TBUF7;  /*!< (@ 0x0000006c) DIM-register 'TBUF%s', element 7 */
  __IOM  uint32_t  TBUF8;  /*!< (@ 0x00000070) DIM-register 'TBUF%s', element 8 */
  __IOM  uint32_t  TBUF9;  /*!< (@ 0x00000074) DIM-register 'TBUF%s', element 9 */
  __IOM  uint32_t  TBUF10;  /*!< (@ 0x00000078) DIM-register 'TBUF%s', element 10 */
  __IOM  uint32_t  TBUF11;  /*!< (@ 0x0000007c) DIM-register 'TBUF%s', element 11 */
  __IOM  uint32_t  TBUF12;  /*!< (@ 0x00000080) DIM-register 'TBUF%s', element 12 */
  __IOM  uint32_t  TBUF13;  /*!< (@ 0x00000084) DIM-register 'TBUF%s', element 13 */
  __IOM  uint32_t  TBUF14;  /*!< (@ 0x00000088) DIM-register 'TBUF%s', element 14 */
  __IOM  uint32_t  TBUF15;  /*!< (@ 0x0000008c) DIM-register 'TBUF%s', element 15 */
  __IOM  uint32_t  TBUF16;  /*!< (@ 0x00000090) DIM-register 'TBUF%s', element 16 */
  __IOM  uint32_t  TBUF17;  /*!< (@ 0x00000094) DIM-register 'TBUF%s', element 17 */
  __IOM  uint32_t  TTS0;  /*!< (@ 0x00000098) DIM-register 'TTS%s', element 0 */
  __IOM  uint32_t  TTS1;  /*!< (@ 0x0000009c) DIM-register 'TTS%s', element 1 */
  __IOM   uint8_t  CFG_STAT;  /*!< (@ 0x000000a0) register CFG_STAT 
TODO */

  __IOM   uint8_t  TCMD;  /*!< (@ 0x000000a1) register TCMD 
TODO */

  __IOM   uint8_t  TCTRL;  /*!< (@ 0x000000a2) register TCTRL 
TODO */

  __IOM   uint8_t  RCTRL;  /*!< (@ 0x000000a3) register RCTRL 
TODO */

  __IOM   uint8_t  RTIE;  /*!< (@ 0x000000a4) register RTIE 
TODO */

  __IOM   uint8_t  RTIF;  /*!< (@ 0x000000a5) register RTIF 
TODO */

  __IOM   uint8_t  ERRINT;  /*!< (@ 0x000000a6) register ERRINT 
TODO */

  __IOM   uint8_t  LIMIT;  /*!< (@ 0x000000a7) register LIMIT 
TODO */

  __IOM   uint8_t  S_SEG_1;  /*!< (@ 0x000000a8) register S_SEG_1 
TODO */

  __IOM   uint8_t  S_SEG_2;  /*!< (@ 0x000000a9) register S_SEG_2 
TODO */

  __IOM   uint8_t  S_SJW;  /*!< (@ 0x000000aa) register S_SJW 
TODO */

  __IOM   uint8_t  S_PRESC;  /*!< (@ 0x000000ab) register S_PRESC 
TODO */

  __IOM   uint8_t  F_SEG_1;  /*!< (@ 0x000000ac) register F_SEG_1 
TODO */

  __IOM   uint8_t  F_SEG_2;  /*!< (@ 0x000000ad) register F_SEG_2 
TODO */

  __IOM   uint8_t  F_SJW;  /*!< (@ 0x000000ae) register F_SJW 
TODO */

  __IOM   uint8_t  F_PRESC;  /*!< (@ 0x000000af) register F_PRESC 
TODO */

  __IOM   uint8_t  EALCAP;  /*!< (@ 0x000000b0) register EALCAP 
TODO */

  __IOM   uint8_t  TDC;  /*!< (@ 0x000000b1) register TDC 
TODO */

  __IOM   uint8_t  RECNT;  /*!< (@ 0x000000b2) register RECNT 
TODO */

  __IOM   uint8_t  TECNT;  /*!< (@ 0x000000b3) register TECNT 
TODO */

  __IOM   uint8_t  ACFCTRL;  /*!< (@ 0x000000b4) register ACFCTRL 
TODO */

  __IOM   uint8_t  TIMECFG;  /*!< (@ 0x000000b5) register TIMECFG 
TODO */

  __IOM  uint16_t  ACF_EN;  /*!< (@ 0x000000b6) register ACF_EN 
TODO */

  __IOM  uint32_t  ACF;  /*!< (@ 0x000000b8) register ACF 
TODO */

  __IOM  uint16_t  VER;  /*!< (@ 0x000000bc) register VER 
TODO */

  __IOM   uint8_t  TBSLOT;  /*!< (@ 0x000000be) register TBSLOT 
TODO */

  __IOM   uint8_t  TTCFG;  /*!< (@ 0x000000bf) register TTCFG 
TODO */

  __IOM  uint32_t  REF_MSG;  /*!< (@ 0x000000c0) register REF_MSG 
TODO */

  __IOM  uint16_t  TRIG_CFG;  /*!< (@ 0x000000c4) register TRIG_CFG 
TODO */

  __IOM  uint16_t  TT_TRIG;  /*!< (@ 0x000000c6) register TT_TRIG 
TODO */

  __IOM  uint16_t  TT_WTRIG;  /*!< (@ 0x000000c8) register TT_WTRIG 
TODO */

  __IOM   uint8_t  MEM_PROT;  /*!< (@ 0x000000ca) register MEM_PROT 
TODO */

  __IOM   uint8_t  MEM_STAT;  /*!< (@ 0x000000cb) register MEM_STAT 
TODO */

  __IOM  uint32_t  MEM_ES;  /*!< (@ 0x000000cc) register MEM_ES 
TODO */

  __IOM   uint8_t  SRCFG;  /*!< (@ 0x000000d0) register SRCFG 
TODO */

   __IM   uint8_t  RESERVED0;  /*!< not covered by register fields! */
   __IM  uint16_t  RESERVED1;  /*!< not covered by register fields! */
   __IM  uint32_t  RESERVED2[11];  /*!< not covered by register fields! */
  __IOM  uint32_t  TSCCR;  /*!< (@ 0x00000100) register TSCCR */
   __OM  uint32_t  TSCSR;  /*!< (@ 0x00000104) register TSCSR */
   __IM  uint32_t  TSCDR;  /*!< (@ 0x00000108) register TSCDR */
} CAN_Type;     /*!< Size = 268 (0x10c) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PWM ================================================= */
/* =========================================================================================================================== */

/**
  * @brief PWM_Type peripheral PWM
  */
typedef struct {    /*!< (@ 0x40111000) PWM Structure */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  CLKCTL;  /*!< (@ 0x00000008) register CLKCTL */
  __IOM  uint32_t  CTRPHS;  /*!< (@ 0x0000000c) register CTRPHS */
  __IOM  uint32_t  CTRPRD;  /*!< (@ 0x00000010) register CTRPRD */
  __IOM  uint32_t  CTRCNT;  /*!< (@ 0x00000014) register CTRCNT */
   __IM  uint32_t  RESERVED1[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  CMPCTL;  /*!< (@ 0x00000020) register CMPCTL */
  __IOM  uint32_t  CMPA;  /*!< (@ 0x00000024) register CMPA */
  __IOM  uint32_t  CMPB;  /*!< (@ 0x00000028) register CMPB */
  __IOM  uint32_t  EMCTLA;  /*!< (@ 0x0000002c) register EMCTLA */
  __IOM  uint32_t  EMCTLB;  /*!< (@ 0x00000030) register EMCTLB */
  __IOM  uint32_t  EMSWFR;  /*!< (@ 0x00000034) register EMSWFR */
  __IOM  uint32_t  EMCSWFR;  /*!< (@ 0x00000038) register EMCSWFR */
   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  DZCTL;  /*!< (@ 0x00000040) register DZCTL */
  __IOM  uint32_t  DZRPER;  /*!< (@ 0x00000044) register DZRPER */
  __IOM  uint32_t  DZFPER;  /*!< (@ 0x00000048) register DZFPER */
  __IOM  uint32_t  CHCTL;  /*!< (@ 0x0000004c) register CHCTL */
  __IOM  uint32_t  TUSEL;  /*!< (@ 0x00000050) register TUSEL */
  __IOM  uint32_t  TUCTL;  /*!< (@ 0x00000054) register TUCTL */
  __IOM  uint32_t  TUINTM;  /*!< (@ 0x00000058) register TUINTM */
   __IM  uint32_t  TUSTS;  /*!< (@ 0x0000005c) register TUSTS */
  __IOM  uint32_t  TUCLR;  /*!< (@ 0x00000060) register TUCLR */
  __IOM  uint32_t  TUFRC;  /*!< (@ 0x00000064) register TUFRC */
  __IOM  uint32_t  ICSEL;  /*!< (@ 0x00000068) register ICSEL */
  __IOM  uint32_t  ICCTL;  /*!< (@ 0x0000006c) register ICCTL */
   __IM  uint32_t  ICSTS;  /*!< (@ 0x00000070) register ICSTS */
  __IOM  uint32_t  ICCLR;  /*!< (@ 0x00000074) register ICCLR */
  __IOM  uint32_t  ICFRC;  /*!< (@ 0x00000078) register ICFRC */
   __IM  uint32_t  RESERVED3;  /*!< not covered by register fields! */
  __IOM  uint32_t  CTRRUN;  /*!< (@ 0x00000080) register CTRRUN */
  __IOM  uint32_t  CTRSTS;  /*!< (@ 0x00000084) register CTRSTS */
} PWM_Type;     /*!< Size = 136 (0x88) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: VTU ================================================= */
/* =========================================================================================================================== */

/**
  * @brief VTU_Type peripheral VTU
  */
typedef struct {    /*!< (@ 0x40112000) VTU Structure */
  __IOM  uint16_t  MODE;  /*!< (@ 0x00000000) register MODE */
   __IM  uint16_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint16_t  IO1CTL;  /*!< (@ 0x00000004) register IO1CTL */
   __IM  uint16_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint16_t  IO2CTL;  /*!< (@ 0x00000008) register IO2CTL */
   __IM  uint16_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint16_t  INTCTL;  /*!< (@ 0x0000000c) register INTCTL */
   __IM  uint16_t  RESERVED3;  /*!< not covered by register fields! */
  __IOM  uint16_t  INTPND;  /*!< (@ 0x00000010) register INTPND */
   __IM  uint16_t  RESERVED4;  /*!< not covered by register fields! */
  __IOM  uint16_t  CLK1PS;  /*!< (@ 0x00000014) register CLK1PS */
   __IM  uint16_t  RESERVED5;  /*!< not covered by register fields! */
  __IOM  uint16_t  COUNT1;  /*!< (@ 0x00000018) register COUNT1 */
   __IM  uint16_t  RESERVED6;  /*!< not covered by register fields! */
  __IOM  uint16_t  PERCAP1;  /*!< (@ 0x0000001c) register PERCAP1 */
   __IM  uint16_t  RESERVED7;  /*!< not covered by register fields! */
  __IOM  uint16_t  DTYCAP1;  /*!< (@ 0x00000020) register DTYCAP1 */
   __IM  uint16_t  RESERVED8;  /*!< not covered by register fields! */
  __IOM  uint16_t  COUNT2;  /*!< (@ 0x00000024) register COUNT2 */
   __IM  uint16_t  RESERVED9;  /*!< not covered by register fields! */
  __IOM  uint16_t  PERCAP2;  /*!< (@ 0x00000028) register PERCAP2 */
   __IM  uint16_t  RESERVED10;  /*!< not covered by register fields! */
  __IOM  uint16_t  DTYCAP2;  /*!< (@ 0x0000002c) register DTYCAP2 */
   __IM  uint16_t  RESERVED11;  /*!< not covered by register fields! */
  __IOM  uint16_t  CLK2PS;  /*!< (@ 0x00000030) register CLK2PS */
   __IM  uint16_t  RESERVED12;  /*!< not covered by register fields! */
  __IOM  uint16_t  COUNT3;  /*!< (@ 0x00000034) register COUNT3 */
   __IM  uint16_t  RESERVED13;  /*!< not covered by register fields! */
  __IOM  uint16_t  PERCAP3;  /*!< (@ 0x00000038) register PERCAP3 */
   __IM  uint16_t  RESERVED14;  /*!< not covered by register fields! */
  __IOM  uint16_t  DTYCAP3;  /*!< (@ 0x0000003c) register DTYCAP3 */
   __IM  uint16_t  RESERVED15;  /*!< not covered by register fields! */
  __IOM  uint16_t  COUNT4;  /*!< (@ 0x00000040) register COUNT4 */
   __IM  uint16_t  RESERVED16;  /*!< not covered by register fields! */
  __IOM  uint16_t  PERCAP4;  /*!< (@ 0x00000044) register PERCAP4 */
   __IM  uint16_t  RESERVED17;  /*!< not covered by register fields! */
  __IOM  uint16_t  DTYCAP4;  /*!< (@ 0x00000048) register DTYCAP4 */
} VTU_Type;     /*!< Size = 74 (0x4a) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: USB ================================================= */
/* =========================================================================================================================== */

/**
  * @brief USB_Type peripheral USB
  */
typedef struct {    /*!< (@ 0x40200000) USB Structure */
  __IOM  uint32_t  GOTGCTL;  /*!< (@ 0x00000000) register GOTGCTL 
OTG Control and Status Register
The OTG Control and Status register controls the behavior and reflects the status of the OTG function of the controller. */

  __IOM  uint32_t  GOTGINT;  /*!< (@ 0x00000004) register GOTGINT 
OTG Interrupt Register
The application reads this register whenever there is an OTG interrupt and clears the bits in this register to clear the OTG interrupt. */

  __IOM  uint32_t  GAHBCFG;  /*!< (@ 0x00000008) register GAHBCFG 
AHB Configuration Register
This register can be used to configure the core after power-on or a change in mode. This register mainly contains AHB system-related configuration parameters. Do not change this register after the initial programming. The application must program this register before starting any transactions on either the AHB or the USB. */

  __IOM  uint32_t  GUSBCFG;  /*!< (@ 0x0000000c) register GUSBCFG 
USB Configuration Register
This register can be used to configure the core after power-on or when changing to Host mode or Device mode. It contains USB and USB-PHY related configuration parameters. The application must program this register before starting any transactions on either the AHB or the USB. If you are using the HSIC interface, HSIC PHY must be in reset while programming this register. Do not make changes to this register after the initial programming. */

  __IOM  uint32_t  GRSTCTL;  /*!< (@ 0x00000010) register GRSTCTL 
Reset Register
The application uses this register to reset various hardware features inside the controller. */

  __IOM  uint32_t  GINTSTS;  /*!< (@ 0x00000014) register GINTSTS 
Interrupt Register

This register interrupts the application for system-level events in the current mode (Device mode or Host mode).
Some of the bits in this register are valid only in Host mode, while others are valid in Device mode only. This register also indicates the current mode. To clear the interrupt status bits of type R_SS_WC, the application must write 1'b1 to the bit.
The FIFO status interrupts are read only; once software reads from or writes to the FIFO while servicing these interrupts, FIFO interrupt conditions are cleared automatically.
The application must clear the GINTSTS register at initialization before unmasking the interrupt bit to avoid any interrupts generated prior to initialization.

Note: Read the reset value of GINTSTS.CurMod only after the following conditions:
 - If IDDIG_FILTER is disabled, read only after PHY clock is stable.
 - If IDDIG_FILTER is enabled, read only after the filter timer expires. */

  __IOM  uint32_t  GINTMSK;  /*!< (@ 0x00000018) register GINTMSK 
Interrupt Mask Register
This register works with the Interrupt Register (GINTSTS) to interrupt the application. When an interrupt bit is masked, the interrupt associated with that bit is not generated. However, the GINTSTS register bit corresponding to that interrupt is still set.

Note: The fields of this register change depending on host or device mode. */

   __IM  uint32_t  GRXSTSR;  /*!< (@ 0x0000001c) register GRXSTSR 
Receive Status Debug Read Register
A read to the Receive Status Debug Read register returns the contents of the top of the Receive FIFO.

The receive status contents must be interpreted differently in Host and Device modes. The core ignores the receive status read when the receive FIFO is empty and returns a value of 32'h0000_0000.

Note:
 - Use of these fields vary based on whether the core is functioning as a host or a device.
 - Do not read this register's reset value before configuring the core because the read value is 'X' in the simulation. */

   __IM  uint32_t  GRXSTSP;  /*!< (@ 0x00000020) register GRXSTSP 
Receive Status Read/Pop Register
A read to the Receive Status Read and Pop register returns the contents of the top of the Receive FIFO and additionally pops the top data entry out of the RxFIFO.
The receive status contents must be interpreted differently in Host and Device modes. The core ignores the receive status pop/read when the receive FIFO is empty and returns a value of 32'h0000_0000. The application must only pop the Receive Status FIFO when the Receive FIFO Non-Empty bit of the Core Interrupt register (GINTSTS.RxFLvl) is asserted.

Note:
 - Use of these fields vary based on whether the core is functioning as a host or a device.
 - Do not read this register's reset value before configuring the core because the read value is 'X' in the simulation. */

  __IOM  uint32_t  GRXFSIZ;  /*!< (@ 0x00000024) register GRXFSIZ 
Receive FIFO Size Register
The application can program the RAM size that must be allocated to the RxFIFO. */

  __IOM  uint32_t  GNPTXFSIZ;  /*!< (@ 0x00000028) register GNPTXFSIZ 
Non-periodic Transmit FIFO Size Register
The application can program the RAM size and the memory start address for the Non-periodic TxFIFO

Note: The fields of this register change depending on host or device mode. */

   __IM  uint32_t  GNPTXSTS;  /*!< (@ 0x0000002c) register GNPTXSTS 
Non-periodic Transmit FIFO/Queue Status Register
In Device mode, this register is valid only in Shared FIFO operation.
This read-only register contains the free space information for the Non-periodic TxFIFO and the Non-periodic Transmit Request Queue. */

   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  GPVNDCTL;  /*!< (@ 0x00000034) register GPVNDCTL 
PHY Vendor Control Register

The application can use this register to access PHY registers. It is implemented only if Enable PHY Vendor Control Interface was selected during coreConsultant configuration (parameter OTG_VENDOR_CTL_INTERFACE = 1). For a UTMI+ PHY, the DWC_otg core uses the UTMI+ Vendor Control interface for PHY register access. For a ULPI PHY, the core uses the ULPI interface for PHY register access. The application sets Vendor Control register for PHY register access and times the PHY register access. The application polls the VStatus Done bit in this register for the completion of the PHY register access. */

  __IOM  uint32_t  GGPIO;  /*!< (@ 0x00000038) register GGPIO 
General Purpose Input/Output Register

The application can use this register for general purpose input/output ports or for debugging. */

  __IOM  uint32_t  GUID;  /*!< (@ 0x0000003c) register GUID 
User ID Register

This is a read/write register containing the User ID. It is implemented only if Remove Optional Features? was deselected during coreConsultant configuration (parameter OTG_RM_OPT_FEATURES = 0). The power-on value for this register is specified as the Power-on Value of User ID Register User Identification Register during coreConsultant configuration (parameter OTG_USERID). This register can be used in the following ways:
 - To store the version or revision of your system
 - To store hardware configurations that are outside the DWC_otg core 
 - As a scratch register */

   __IM  uint32_t  GSNPSID;  /*!< (@ 0x00000040) register GSNPSID 
Synopsys ID Register

This read-only register contains the release number of the core being used. */

   __IM  uint32_t  GHWCFG1;  /*!< (@ 0x00000044) register GHWCFG1 
User Hardware Configuration 1 Register

This register contains the logical endpoint direction(s) selected using coreConsultant. */

   __IM  uint32_t  GHWCFG2;  /*!< (@ 0x00000048) register GHWCFG2 
User Hardware Configuration 2 Register

This register contains configuration options selected using coreConsultant. */

   __IM  uint32_t  GHWCFG3;  /*!< (@ 0x0000004c) register GHWCFG3 
User Hardware Configuration 3 Register */

   __IM  uint32_t  GHWCFG4;  /*!< (@ 0x00000050) register GHWCFG4 
User Hardware Configuration 4 Register

Note: Bit [31] is available only when Scatter/Gather DMA mode is enabled. When Scatter/Gather DMA mode is disabled, this field is reserved. */

   __IM  uint32_t  RESERVED1[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  GDFIFOCFG;  /*!< (@ 0x0000005c) register GDFIFOCFG 
Global DFIFO Configuration Register */

   __IM  uint32_t  RESERVED2[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  GINTMSK2;  /*!< (@ 0x00000068) register GINTMSK2 
Interrupt Mask Register 2
This register works with the Interrupt Register (GINTSTS2) to interrupt the application. When an interrupt bit is masked, the interrupt associated with that bit is not generated. However, the GINTSTS2 register bit corresponding to that interrupt is still set.

Note: The fields of this register change depending on host or device mode. */

  __IOM  uint32_t  GINTSTS2;  /*!< (@ 0x0000006c) register GINTSTS2 
Interrupt Register 2

This register interrupts the application for system-level events in the current mode (Device mode or Host mode).
Some of the bits in this register are valid only in Host mode, while others are valid in Device mode only. This register also indicates the current mode. To clear the interrupt status bits of type R_SS_WC, the application must write 1'b1 to the bit.
The application must clear the GINTSTS2 register at initialization before unmasking the interrupt bit to avoid any interrupts generated prior to initialization. */

   __IM  uint32_t  RESERVED3[36];  /*!< not covered by register fields! */
  __IOM  uint32_t  HPTXFSIZ;  /*!< (@ 0x00000100) register HPTXFSIZ 
Host Periodic Transmit FIFO Size Register

This register holds the size and the memory start address of the Periodic TxFIFO.

Note: Read the reset value of this register only after the following conditions:
 - If IDDIG_FILTER is disabled, read only after PHY clock is stable.
 - If IDDIG_FILTER is enabled, read only after the filter timer expires.
 */

  __IOM  USB_DIEPTXF_Type  DIEPTXF[7];  /*!< artificially generated from 7 groups of repeated members */
   __IM  uint32_t  RESERVED4[184];  /*!< not covered by register fields! */
  __IOM  uint32_t  HCFG;  /*!< (@ 0x00000400) register HCFG 
Host Configuration Register */

  __IOM  uint32_t  HFIR;  /*!< (@ 0x00000404) register HFIR 
Host Frame Interval Register */

   __IM  uint32_t  HFNUM;  /*!< (@ 0x00000408) register HFNUM 
Host Frame Number/Frame Time Remaining Register

This register indicates the current frame number. It also indicates the time remaining (in terms of the number of PHY clocks) in the current (micro)frame.

Note: Read the reset value of this register only after the following conditions:
 - If IDDIG_FILTER is disabled, read only when the PHY clock is stable.
 - If IDDIG_FILTER is enabled, read only after the filter timer expires.
 */

   __IM  uint32_t  RESERVED5;  /*!< not covered by register fields! */
   __IM  uint32_t  HPTXSTS;  /*!< (@ 0x00000410) register HPTXSTS 
Host Periodic Transmit FIFO/Queue Status Register */

   __IM  uint32_t  HAINT;  /*!< (@ 0x00000414) register HAINT 
Host All Channels Interrupt Register

When a significant event occurs on a channel, the Host All Channels Interrupt register interrupts the application using the Host Channels Interrupt bit of the Core Interrupt register (GINTSTS.HChInt). This is shown in the "Interrupt Hierarchy" figure in the databook. There is one interrupt bit per channel, up to a maximum of 16 bits. Bits in this register are set and cleared when the application sets and clears bits in the corresponding Host Channel-n Interrupt register. */

  __IOM  uint32_t  HAINTMSK;  /*!< (@ 0x00000418) register HAINTMSK 
Host All Channels Interrupt Mask Register

The Host All Channel Interrupt Mask register works with the Host All Channel Interrupt register to interrupt the application when an event occurs on a channel. There is one interrupt mask bit per channel, up to a maximum of 16 bits. */

  __IOM  uint32_t  HFLBADDR;  /*!< (@ 0x0000041c) register HFLBADDR 
Host Frame List Base Address Register

This register is present only in case of Scatter/Gather DMA. It is implemented as flops. This register holds the starting address of the Frame list information. */

   __IM  uint32_t  RESERVED6[8];  /*!< not covered by register fields! */
  __IOM  uint32_t  HPRT;  /*!< (@ 0x00000440) register HPRT 
Host Port Control and Status Register

This register is available only in Host mode. Currently, the OTG Host supports only one port. A single register holds USB port-related information such as USB reset, enable, suspend, resume, connect status, and test mode for each port. It is shown in the "Interrupt Hierarchy" figure in the databook. The R_SS_WC bits in this register can trigger an interrupt to the application through the Host Port Interrupt bit of the Core Interrupt register (GINTSTS.PrtInt). On a Port Interrupt, the application must read this register and clear the bit that caused the interrupt. For the R_SS_WC bits, the application must write a 1 to the bit to clear the interrupt. */

   __IM  uint32_t  RESERVED7[47];  /*!< not covered by register fields! */
  __IOM  USB_HostChan_Type  HostChan[16];  /*!< artificially generated from 16 groups of repeated members */
   __IM  uint32_t  RESERVED24[64];  /*!< not covered by register fields! */
  __IOM  uint32_t  DCFG;  /*!< (@ 0x00000800) register DCFG 
Device Configuration Register

This register configures the core in Device mode after power-on or after certain control commands or enumeration. Do not make changes to this register after initial programming. */

  __IOM  uint32_t  DCTL;  /*!< (@ 0x00000804) register DCTL 
Device Control Register */

   __IM  uint32_t  DSTS;  /*!< (@ 0x00000808) register DSTS 
Device Status Register

This register indicates the status of the core with respect to USB-related events. It must be read on interrupts from Device All Interrupts (DAINT) register. */

   __IM  uint32_t  RESERVED25;  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPMSK;  /*!< (@ 0x00000810) register DIEPMSK 
Device IN Endpoint Common Interrupt Mask Register

This register works with each of the Device IN Endpoint Interrupt (DIEPINTn) registers for all endpoints to generate an interrupt per IN endpoint. The IN endpoint interrupt for a specific status in the DIEPINTn register can be masked by writing to the corresponding bit in this register. Status bits are masked by default. */

  __IOM  uint32_t  DOEPMSK;  /*!< (@ 0x00000814) register DOEPMSK 
Device OUT Endpoint Common Interrupt Mask Register

This register works with each of the Device OUT Endpoint Interrupt (DOEPINTn) registers for all endpoints to generate an interrupt per OUT endpoint. The OUT endpoint interrupt for a specific status in the DOEPINTn register can be masked by writing into the corresponding bit in this register. Status bits are masked by default. */

   __IM  uint32_t  DAINT;  /*!< (@ 0x00000818) register DAINT 
Device All Endpoints Interrupt Register

When a significant event occurs on an endpoint, a Device All Endpoints Interrupt register interrupts the
application using the Device OUT Endpoints Interrupt bit or Device IN Endpoints Interrupt bit of the Core
Interrupt register (GINTSTS.OEPInt or GINTSTS.IEPInt, respectively). This is shown in Figure 5-2. There is
one interrupt bit per endpoint, up to a maximum of 16 bits for OUT endpoints and 16 bits for IN endpoints.
For a bidirectional endpoint, the corresponding IN and OUT interrupt bits are used. Bits in this register are
set and cleared when the application sets and clears bits in the corresponding Device Endpoint-n Interrupt
register (DIEPINTn/DOEPINTn). */

  __IOM  uint32_t  DAINTMSK;  /*!< (@ 0x0000081c) register DAINTMSK 
Device All Endpoints Interrupt Mask Register 

 The Device Endpoint Interrupt Mask register works with the Device Endpoint Interrupt register to interrupt the application when an event occurs on a device endpoint. However, the Device All Endpoints Interrupt (DAINT) register bit corresponding to that interrupt is still set. */

   __IM  uint32_t  RESERVED26[2];  /*!< not covered by register fields! */
  __IOM  uint32_t  DVBUSDIS;  /*!< (@ 0x00000828) register DVBUSDIS 
Device VBUS Discharge Time Register

 This register specifies the VBUS discharge time after VBUS pulsing during SRP. */

  __IOM  uint32_t  DVBUSPULSE;  /*!< (@ 0x0000082c) register DVBUSPULSE 
Device VBUS Pulsing Time Register */

  __IOM  uint32_t  DTHRCTL;  /*!< (@ 0x00000830) register DTHRCTL 
Device Threshold Control Register */

  __IOM  uint32_t  DIEPEMPMSK;  /*!< (@ 0x00000834) register DIEPEMPMSK 
Device IN Endpoint FIFO Empty Interrupt Mask Register
This register is valid only in Dedicated FIFO operation (OTG_EN_DED_TX_FIFO = 1). This register is used to control the IN endpoint FIFO empty interrupt generation (DIEPINTn.TxfEmp). */

   __IM  uint32_t  RESERVED27[50];  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPCTL0;  /*!< (@ 0x00000900) register DIEPCTL0 
Device Control IN Endpoint 0 Control Register */

   __IM  uint32_t  RESERVED28;  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPINT0;  /*!< (@ 0x00000908) register DIEPINT0 
Device IN Endpoint 0 Interrupt Register

 This register indicates the status of an endpoint with respect to USB- and AHB-related events. It is shown in the "Interrupt Hierarchy" figure in the databook. The application must read this register when the OUT Endpoints Interrupt bit or IN Endpoints Interrupt bit of the Core Interrupt register (GINTSTS.OEPInt or GINTSTS.IEPInt, respectively) is set. Before the application can read this register, it must first read the Device All Endpoints Interrupt (DAINT) register to get the exact endpoint number for the Device Endpoint-n Interrupt register. The application must clear the appropriate bit in this register to clear the corresponding bits in the DAINT and GINTSTS registers */

   __IM  uint32_t  RESERVED29;  /*!< not covered by register fields! */
  __IOM  uint32_t  DIEPTSIZ0;  /*!< (@ 0x00000910) register DIEPTSIZ0 
Device IN Endpoint 0 Transfer Size Register


The application must modify this register before enabling endpoint 0. Once endpoint 0 is enabled using Endpoint Enable bit of the Device Control Endpoint 0 Control registers (DIEPCTL0.EPEna/DOEPCTL0.EPEna), the core modifies this register. The application can only read this register once the core has cleared the Endpoint Enable bit. Nonzero endpoints use the registers for endpoints 115. When Scatter/Gather DMA mode is enabled, this register must not be programmed by the application. If the application reads this register when Scatter/Gather DMA mode is enabled, the core returns all zeros. */

  __IOM  uint32_t  DIEPDMA0;  /*!< (@ 0x00000914) register DIEPDMA0 
Device IN Endpoint 0 DMA Address Register */

   __IM  uint32_t  DTXFSTS0;  /*!< (@ 0x00000918) register DTXFSTS0 
Device IN Endpoint Transmit FIFO Status Register 0 */

   __IM  uint32_t  DIEPDMAB0;  /*!< (@ 0x0000091c) register DIEPDMAB0 
Device IN Endpoint 16 Buffer Address Register */

  __IOM  USB_INEndpoint_Type  INEndpoint[7];  /*!< artificially generated from 7 groups of repeated members */
   __IM  uint32_t  RESERVED44[64];  /*!< not covered by register fields! */
  __IOM  uint32_t  DOEPCTL0;  /*!< (@ 0x00000b00) register DOEPCTL0 
Device Control OUT Endpoint 0 Control Register */

   __IM  uint32_t  RESERVED45;  /*!< not covered by register fields! */
  __IOM  uint32_t  DOEPINT0;  /*!< (@ 0x00000b08) register DOEPINT0 
Device OUT Endpoint 0 Interrupt Register */

   __IM  uint32_t  RESERVED46;  /*!< not covered by register fields! */
  __IOM  uint32_t  DOEPTSIZ0;  /*!< (@ 0x00000b10) register DOEPTSIZ0 
Device OUT Endpoint 0 Transfer Size Register */

  __IOM  uint32_t  DOEPDMA0;  /*!< (@ 0x00000b14) register DOEPDMA0 
Device OUT Endpoint 0 DMA Address Register */

   __IM  uint32_t  RESERVED47;  /*!< not covered by register fields! */
   __IM  uint32_t  DOEPDMAB0;  /*!< (@ 0x00000b1c) register DOEPDMAB0 
Device OUT Endpoint 16 Buffer Address Register */

  __IOM  USB_OUTEndpoint_Type  OUTEndpoint[7];  /*!< artificially generated from 7 groups of repeated members */
   __IM  uint32_t  RESERVED69[128];  /*!< not covered by register fields! */
  __IOM  uint32_t  PCGCCTL;  /*!< (@ 0x00000e00) register PCGCCTL 
Power and Clock Gating Control Register */

} USB_Type;     /*!< Size = 3588 (0xe04) */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: USB_URB =============================================== */
/* =========================================================================================================================== */

/**
  * @brief USB_URB_Type peripheral USB_URB
  */
typedef struct {    /*!< (@ 0x40240000) USB_URB Structure */
  __IOM  uint32_t  USBSYSRESETN;  /*!< (@ 0x00000000) register USBSYSRESETN 
USB system reset (resets PHY and CNTR). This is multi-field register */

  __IOM  uint32_t  USBPHYREFFREQSEL;  /*!< (@ 0x00000004) register USBPHYREFFREQSEL 
PHY reference frequency selector (frequency matching). This is multi-field register */

  __IOM  uint32_t  USBPHYLOOPBACKTEST;  /*!< (@ 0x00000008) register USBPHYLOOPBACKTEST 
PHY test – loopback debug mode. This is multi-field register */

  __IOM  uint32_t  USBCNTRSIMSCALEDOWN;  /*!< (@ 0x0000000c) register USBCNTRSIMSCALEDOWN 
Timing scale-down mode (simulations auxilary option). This is single-field register */

  __IOM  uint32_t  USBCNTRFILTERBYPASS;  /*!< (@ 0x00000010) register USBCNTRFILTERBYPASS 
Debounce filters bypass (OTG-signals). This is single-field register */

  __IOM  uint32_t  USBGENPARAMETERS;  /*!< (@ 0x00000014) register USBGENPARAMETERS 
General PHY parameters (silicon-dependent). This is multi-field register */

  __IOM  uint32_t  USBTXPARAMETERS;  /*!< (@ 0x00000018) register USBTXPARAMETERS 
PHY TXTUNE parameters (silicon-dependent). This is multi-field register */

  __IOM  uint32_t  USBCONFIGCHANNEL;  /*!< (@ 0x0000001c) register USBCONFIGCHANNEL 
ConfigurationChannel(CC) settings/monitoring. This is multi-field register */

  __IOM  uint32_t  USBPHYSLEEPN;  /*!< (@ 0x00000020) register USBPHYSLEEPN 
Sleep mode for PHY generated by application (active-low). This is multi-field register */

  __IOM  uint32_t  USBOTGCONTROL;  /*!< (@ 0x00000024) register USBOTGCONTROL */
  __IOM  uint32_t  USBUTMICONTROL;  /*!< (@ 0x00000028) register USBUTMICONTROL */
  __IOM  uint32_t  USBTESTANDDEBUG;  /*!< (@ 0x0000002c) register USBTESTANDDEBUG */
  __IOM  uint32_t  USBCCIRQCONTROL;  /*!< (@ 0x00000030) register USBCCIRQCONTROL */
} USB_URB_Type;     /*!< Size = 52 (0x34) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: QSPI ================================================ */
/* =========================================================================================================================== */

/**
  * @brief QSPI_Type peripheral QSPI
  */
typedef struct {    /*!< (@ 0x40280000) QSPI Structure */
   __OM  uint32_t  TX_DATA;  /*!< (@ 0x00000000) register TX_DATA */
   __IM  uint32_t  RX_DATA;  /*!< (@ 0x00000004) register RX_DATA */
   __IM  uint32_t  RESERVED0;  /*!< not covered by register fields! */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x0000000c) register CTRL */
  __IOM  uint32_t  CTRL_AUX;  /*!< (@ 0x00000010) register CTRL_AUX */
   __IM  uint32_t  STAT;  /*!< (@ 0x00000014) register STAT */
  __IOM  uint32_t  SS;  /*!< (@ 0x00000018) register SS */
  __IOM  uint32_t  SS_POL;  /*!< (@ 0x0000001c) register SS_POL */
  __IOM  uint32_t  INTR_EN;  /*!< (@ 0x00000020) register INTR_EN */
   __IM  uint32_t  INTR_STAT;  /*!< (@ 0x00000024) register INTR_STAT */
  __IOM  uint32_t  INTR_CLR;  /*!< (@ 0x00000028) register INTR_CLR */
   __IM  uint32_t  TX_FIFO_LVL;  /*!< (@ 0x0000002c) register TX_FIFO_LVL */
   __IM  uint32_t  RX_FIFO_LVL;  /*!< (@ 0x00000030) register RX_FIFO_LVL */
   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint32_t  TRANS_DELAY;  /*!< (@ 0x00000038) register TRANS_DELAY */
  __IOM  uint32_t  ENABLE;  /*!< (@ 0x0000003c) register ENABLE */
   __IM  uint32_t  RESERVED2[16];  /*!< not covered by register fields! */
  __IOM  uint32_t  XIPCFG;  /*!< (@ 0x00000080) register XIPCFG */
} QSPI_Type;     /*!< Size = 132 (0x84) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GNSS ================================================ */
/* =========================================================================================================================== */

/**
  * @brief GNSS_Type peripheral GNSS
  */
typedef struct {    /*!< (@ 0x40281000) GNSS Structure */
  __IOM  GNSS_MCC_Type  MCC;  /*!< (@ 0x00000000) type derived from cluster 'MCC' */
  __IOM  GNSS_TB_Type  TB;  /*!< (@ 0x00000008) type derived from cluster 'TB' */
  __IOM  GNSS_FCHIP_Type  FCHIP;  /*!< (@ 0x00000010) type derived from cluster 'FCHIP' */
  __IOM  GNSS_PPS_Type  PPS;  /*!< (@ 0x00000018) type derived from cluster 'PPS' */
  __IOM  GNSS_ADC_Type  ADC;  /*!< (@ 0x00000020) type derived from cluster 'ADC' */
  __IOM  GNSS_IMIT_Type  IMIT;  /*!< (@ 0x00000034) type derived from cluster 'IMIT' */
   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
  __IOM  GNSS_ISG_Type  ISG;  /*!< (@ 0x00000050) type derived from cluster 'ISG' */
   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  GNSS_IRQ_Type  IRQ;  /*!< (@ 0x00000060) type derived from cluster 'IRQ' */
   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  GNSS_COL_CA5_Type  COL_CA5;  /*!< (@ 0x00000070) type derived from cluster 'COL_CA5' */
   __IM  uint32_t  RESERVED3[34];  /*!< not covered by register fields! */
  __IOM  GNSS_FSE_Type  FSE;  /*!< (@ 0x00000100) type derived from cluster 'FSE' */
   __IM  uint32_t  RESERVED4[57];  /*!< not covered by register fields! */
  __IOM  GNSS_CA5__Type  CA5_0;  /*!< (@ 0x00000200) DIM-cluster 'CA5_%s', element 0 */
  __IOM  GNSS_CA5__Type  CA5_1;  /*!< (@ 0x00000210) DIM-cluster 'CA5_%s', element 1 */
  __IOM  GNSS_CA5__Type  CA5_2;  /*!< (@ 0x00000220) DIM-cluster 'CA5_%s', element 2 */
  __IOM  GNSS_CA5__Type  CA5_3;  /*!< (@ 0x00000230) DIM-cluster 'CA5_%s', element 3 */
  __IOM  GNSS_CA5__Type  CA5_4;  /*!< (@ 0x00000240) DIM-cluster 'CA5_%s', element 4 */
  __IOM  GNSS_CA5__Type  CA5_5;  /*!< (@ 0x00000250) DIM-cluster 'CA5_%s', element 5 */
  __IOM  GNSS_CA5__Type  CA5_6;  /*!< (@ 0x00000260) DIM-cluster 'CA5_%s', element 6 */
  __IOM  GNSS_CA5__Type  CA5_7;  /*!< (@ 0x00000270) DIM-cluster 'CA5_%s', element 7 */
  __IOM  GNSS_CA5__Type  CA5_8;  /*!< (@ 0x00000280) DIM-cluster 'CA5_%s', element 8 */
  __IOM  GNSS_CA5__Type  CA5_9;  /*!< (@ 0x00000290) DIM-cluster 'CA5_%s', element 9 */
  __IOM  GNSS_CA5__Type  CA5_10;  /*!< (@ 0x000002a0) DIM-cluster 'CA5_%s', element 10 */
  __IOM  GNSS_CA5__Type  CA5_11;  /*!< (@ 0x000002b0) DIM-cluster 'CA5_%s', element 11 */
  __IOM  GNSS_CA5__Type  CA5_12;  /*!< (@ 0x000002c0) DIM-cluster 'CA5_%s', element 12 */
  __IOM  GNSS_CA5__Type  CA5_13;  /*!< (@ 0x000002d0) DIM-cluster 'CA5_%s', element 13 */
  __IOM  GNSS_CA5__Type  CA5_14;  /*!< (@ 0x000002e0) DIM-cluster 'CA5_%s', element 14 */
  __IOM  GNSS_CA5__Type  CA5_15;  /*!< (@ 0x000002f0) DIM-cluster 'CA5_%s', element 15 */
  __IOM  GNSS_CA5__Type  CA5_16;  /*!< (@ 0x00000300) DIM-cluster 'CA5_%s', element 16 */
  __IOM  GNSS_CA5__Type  CA5_17;  /*!< (@ 0x00000310) DIM-cluster 'CA5_%s', element 17 */
  __IOM  GNSS_CA5__Type  CA5_18;  /*!< (@ 0x00000320) DIM-cluster 'CA5_%s', element 18 */
  __IOM  GNSS_CA5__Type  CA5_19;  /*!< (@ 0x00000330) DIM-cluster 'CA5_%s', element 19 */
} GNSS_Type;     /*!< Size = 832 (0x340) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SMC ================================================= */
/* =========================================================================================================================== */

/**
  * @brief SMC_Type peripheral SMC
  */
typedef struct {    /*!< (@ 0x40282000) SMC Structure */
   __IM  uint32_t  RESERVED0[1024];  /*!< not covered by register fields! */
  __IOM  uint32_t  MEMC_STATUS;  /*!< (@ 0x00001000) register MEMC_STATUS */
  __IOM  uint32_t  MEMIF_CFG;  /*!< (@ 0x00001004) register MEMIF_CFG */
  __IOM  uint32_t  MEMC_CFG_SET;  /*!< (@ 0x00001008) register MEMC_CFG_SET */
  __IOM  uint32_t  MEMC_CFG_CLR;  /*!< (@ 0x0000100c) register MEMC_CFG_CLR */
  __IOM  uint32_t  DIRECT_CMD;  /*!< (@ 0x00001010) register DIRECT_CMD */
  __IOM  uint32_t  SET_CYCLES;  /*!< (@ 0x00001014) register SET_CYCLES */
  __IOM  uint32_t  SET_OPMODE;  /*!< (@ 0x00001018) register SET_OPMODE */
   __IM  uint32_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint32_t  REFRESH_PERIOD;  /*!< (@ 0x00001020) register REFRESH_PERIOD */
   __IM  uint32_t  RESERVED2[55];  /*!< not covered by register fields! */
  __IOM  uint32_t  CYCLES0;  /*!< (@ 0x00001100) register CYCLES0 */
  __IOM  uint32_t  OPMODE0;  /*!< (@ 0x00001104) register OPMODE0 */
   __IM  uint32_t  RESERVED3[6];  /*!< not covered by register fields! */
  __IOM  uint32_t  CYCLES1;  /*!< (@ 0x00001120) register CYCLES1 */
  __IOM  uint32_t  OPMODE1;  /*!< (@ 0x00001124) register OPMODE1 */
   __IM  uint32_t  RESERVED4[55];  /*!< not covered by register fields! */
  __IOM  uint32_t  USER_CONFIG;  /*!< (@ 0x00001204) register USER_CONFIG */
} SMC_Type;     /*!< Size = 4616 (0x1208) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SDMMC ================================================ */
/* =========================================================================================================================== */

/**
  * @brief SDMMC_Type peripheral SDMMC
  */
typedef struct {    /*!< (@ 0x40284000) SDMMC Structure */
  __IOM  uint16_t  SDMASYSADDRLO;  /*!< (@ 0x00000000) register SDMASYSADDRLO 

					This register contains the Lower 16-bit of physical system memory address used for DMA transfers or the second argument for the Auto CMD23.
					 */

  __IOM  uint16_t  SDMASYSADDRHI;  /*!< (@ 0x00000002) register SDMASYSADDRHI 

					This register contains the Higher 16-bits of physical system memory address used for DMA transfers or the second argument for the Auto CMD23.
					 */

  __IOM  uint16_t  BLOCKSIZE;  /*!< (@ 0x00000004) register BLOCKSIZE 
This register is used to configure the number of bytes in a data block */

  __IOM  uint16_t  BLOCKCOUNT;  /*!< (@ 0x00000006) register BLOCKCOUNT 
This register is used to configure the number of data blocks */

  __IOM  uint16_t  ARGUMENT1LO;  /*!< (@ 0x00000008) register ARGUMENT1LO 
This register contains Lower bits of SD Command Argument */

  __IOM  uint16_t  ARGUMENT1HI;  /*!< (@ 0x0000000a) register ARGUMENT1HI 
This register contains higher bits of SD Command Argument */

  __IOM  uint16_t  TRANSFERMODE;  /*!< (@ 0x0000000c) register TRANSFERMODE 
This register is used to control the operations of data transfers */

  __IOM  uint16_t  COMMAND;  /*!< (@ 0x0000000e) register COMMAND 
This register is used to program the Command for host controller */

   __IM  uint16_t  RESPONSE0;  /*!< (@ 0x00000010) register RESPONSE0 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE1;  /*!< (@ 0x00000012) register RESPONSE1 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE2;  /*!< (@ 0x00000014) register RESPONSE2 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE3;  /*!< (@ 0x00000016) register RESPONSE3 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE4;  /*!< (@ 0x00000018) register RESPONSE4 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE5;  /*!< (@ 0x0000001a) register RESPONSE5 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE6;  /*!< (@ 0x0000001c) register RESPONSE6 
This register is used to store responses from SD Cards */

   __IM  uint16_t  RESPONSE7;  /*!< (@ 0x0000001e) register RESPONSE7 
This register is used to store responses from SD Cards */

  __IOM  uint32_t  DATAPORT;  /*!< (@ 0x00000020) register DATAPORT 
This register is used to access internal buffer */

   __IM  uint32_t  PRESENTSTATE;  /*!< (@ 0x00000024) register PRESENTSTATE 
The Host Driver can get status of the Host Controller from this 32-bit read-only register */

  __IOM   uint8_t  HOSTCONTROL1;  /*!< (@ 0x00000028) register HOSTCONTROL1 
This register is used to program DMA modes, LED Control, Data Transfer Width, High Speed Enable, Card detect test level and signal selection */

  __IOM   uint8_t  POWERCONTROL;  /*!< (@ 0x00000029) register POWERCONTROL 
This register is used to program the SD Bus power and voltage level */

  __IOM   uint8_t  BLOCKGAPCONTROL;  /*!< (@ 0x0000002a) register BLOCKGAPCONTROL 
This register is used to program the block gap request, read wait control and interrupt at block gap */

  __IOM   uint8_t  WAKEUPCONTROL;  /*!< (@ 0x0000002b) register WAKEUPCONTROL 
This register is used to program the wakeup functionality */

  __IOM  uint16_t  CLOCKCONTROL;  /*!< (@ 0x0000002c) register CLOCKCONTROL 
This register is used to program the Clock frequency select, generator select, Clock enable, Internal Clock state fields */

  __IOM   uint8_t  TIMEOUTCONTROL;  /*!< (@ 0x0000002e) register TIMEOUTCONTROL 
The register sets the Data Timeout counter value */

  __IOM   uint8_t  SOFTWARERESET;  /*!< (@ 0x0000002f) register SOFTWARERESET 
This register is used to program the software reset for data, command and for all */

  __IOM  uint16_t  NORMALINTRSTS;  /*!< (@ 0x00000030) register NORMALINTRSTS 
This register gives the status of all the interrupts */

  __IOM  uint16_t  ERRORINTRSTS;  /*!< (@ 0x00000032) register ERRORINTRSTS 
This register gives the status of the error interrupts */

  __IOM  uint16_t  NORMALINTRSTSENA;  /*!< (@ 0x00000034) register NORMALINTRSTSENA 
This register is used to enable the normal interrupt status register fields */

  __IOM  uint16_t  ERRORINTRSTSENA;  /*!< (@ 0x00000036) register ERRORINTRSTSENA 
This register is used to enable the Error Interrupt Status register fields */

  __IOM  uint16_t  NORMALINTRSIGENA;  /*!< (@ 0x00000038) register NORMALINTRSIGENA 
This register is used to enable the Normal Interrupt Signal register */

  __IOM  uint16_t  ERRORINTRSIGENA;  /*!< (@ 0x0000003a) register ERRORINTRSIGENA 
This register is used to enable Error Interrupt Signal register */

   __IM  uint16_t  AUTOCMDERRSTS;  /*!< (@ 0x0000003c) register AUTOCMDERRSTS 

					This register is used to indicate CMD12 response error of Auto CMD12 and CMD23 response error of Auto CMD 23
					 */

  __IOM  uint16_t  HOSTCONTROL2;  /*!< (@ 0x0000003e) register HOSTCONTROL2 
This register is used to program UHS Select Mode,UHS Select Mode,Driver Strength Select,Execute Tuning,Sampling Clock Select,Asynchronous Interrupt Enable and Preset value enable
					 */

   __IM  uint32_t  CAPABILITIES_LO;  /*!< (@ 0x00000040) register CAPABILITIES_LO 

					This register provides the host driver with information specific to the host controller implementation
					 */

   __IM  uint32_t  CAPABILITIES_HI;  /*!< (@ 0x00000044) register CAPABILITIES_HI 

					This register provides the host driver with information specific to the host controller implementation
					 */

   __IM  uint32_t  MAXCURRENTCAP_LO;  /*!< (@ 0x00000048) register MAXCURRENTCAP_LO 
This register indicates maximum current capability for each voltage */

   __IM  uint32_t  MAXCURRENTCAP_HI;  /*!< (@ 0x0000004c) register MAXCURRENTCAP_HI 
This register indicates maximum current capability for each voltage */

   __OM  uint16_t  FORCEEVENTFORAUTOCMDERRORSTATUS;  /*!< (@ 0x00000050) register FORCEEVENTFORAUTOCMDERRORSTATUS 
This register is not physically implemented, rather it is an address where Auto CMD Error Status register can be written. */

   __OM  uint16_t  FORCEEVENTFORERRINTSTS;  /*!< (@ 0x00000052) register FORCEEVENTFORERRINTSTS 
This register is not physically implemented, rather it is an address where Error Interrupt Status register can be written. */

   __IM   uint8_t  ADMAERRSTS;  /*!< (@ 0x00000054) register ADMAERRSTS 
When the ADMA Error interrupt occur, this register holds the ADMA State in ADMA Error States field and ADMA System Address holds address around the error descriptor */

   __IM   uint8_t  RESERVED0;  /*!< not covered by register fields! */
   __IM  uint16_t  RESERVED1;  /*!< not covered by register fields! */
  __IOM  uint16_t  ADMASYSADDR0;  /*!< (@ 0x00000058) register ADMASYSADDR0 
This register contains the physical address used for ADMA data transfer */

  __IOM  uint16_t  ADMASYSADDR1;  /*!< (@ 0x0000005a) register ADMASYSADDR1 
This register contains the physical address used for ADMA data transfer */

  __IOM  uint16_t  ADMASYSADDR2;  /*!< (@ 0x0000005c) register ADMASYSADDR2 
This register contains the physical address used for ADMA data transfer */

  __IOM  uint16_t  ADMASYSADDR3;  /*!< (@ 0x0000005e) register ADMASYSADDR3 
This register contains the physical address used for ADMA data transfer */

   __IM  uint16_t  PRESETVALUE0;  /*!< (@ 0x00000060) register PRESETVALUE0 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value
					 */

   __IM  uint16_t  PRESETVALUE1;  /*!< (@ 0x00000062) register PRESETVALUE1 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for Default Speed
					 */

   __IM  uint16_t  PRESETVALUE2;  /*!< (@ 0x00000064) register PRESETVALUE2 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for High Speed
					 */

   __IM  uint16_t  PRESETVALUE3;  /*!< (@ 0x00000066) register PRESETVALUE3 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for SDR12
					 */

   __IM  uint16_t  PRESETVALUE4;  /*!< (@ 0x00000068) register PRESETVALUE4 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value SDR25
					 */

   __IM  uint16_t  PRESETVALUE5;  /*!< (@ 0x0000006a) register PRESETVALUE5 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for SDR50
					 */

   __IM  uint16_t  PRESETVALUE6;  /*!< (@ 0x0000006c) register PRESETVALUE6 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for SDR 104
					 */

   __IM  uint16_t  PRESETVALUE7;  /*!< (@ 0x0000006e) register PRESETVALUE7 

					This register is used to read the SDCLK Frequency Select Value,Clock Generator Select Value,Driver Strength Select Value for DDR50
					 */

  __IOM  uint32_t  BOOTTIMEOUTCNT;  /*!< (@ 0x00000070) register BOOTTIMEOUTCNT 
This is used to program the boot timeout value counter */

   __IM  uint32_t  RESERVED2;  /*!< not covered by register fields! */
  __IOM  uint32_t  VENDORREGISTER;  /*!< (@ 0x00000078) register VENDORREGISTER 
This is used to program the boot timeout value counter */

   __IM  uint32_t  RESERVED3[32];  /*!< not covered by register fields! */
   __IM  uint16_t  SLOTINTRSTS;  /*!< (@ 0x000000fc) register SLOTINTRSTS 
This register is used to read the interrupt signal for each slot. */

   __IM  uint16_t  HOSTCONTROLLERVER;  /*!< (@ 0x000000fe) register HOSTCONTROLLERVER 
This register is used to read the vendor version number and specification version number
					 */

  __IOM  uint32_t  ITAPCTR;  /*!< (@ 0x00000100) register ITAPCTR 
Input tap delay control register */

  __IOM  uint32_t  OTAPCTR;  /*!< (@ 0x00000104) register OTAPCTR 
Output tap delay control register */

  __IOM  uint32_t  CORECFG0;  /*!< (@ 0x00000108) register CORECFG0 
Core configuration register 0 */

  __IOM  uint32_t  CORECFG1;  /*!< (@ 0x0000010c) register CORECFG1 
Core configuration register 1 */

  __IOM  uint32_t  CORECFG2;  /*!< (@ 0x00000110) register CORECFG2 
Core configuration register 2 */

  __IOM  uint32_t  CORECFG3;  /*!< (@ 0x00000114) register CORECFG3 
Core configuration register 3 */

  __IOM  uint32_t  CORECFG4;  /*!< (@ 0x00000118) register CORECFG4 
Core configuration register 4 */

  __IOM  uint32_t  CORECFG5;  /*!< (@ 0x0000011c) register CORECFG5 
Core configuration register 5 */

} SDMMC_Type;     /*!< Size = 288 (0x120) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DMA ================================================= */
/* =========================================================================================================================== */

/**
  * @brief DMA_Type peripheral DMA
  */
typedef struct {    /*!< (@ 0x40285000) DMA Structure */
  __IOM  uint32_t  SAR0_LO;  /*!< (@ 0x00000000) register SAR0_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR0_HI;  /*!< (@ 0x00000004) register SAR0_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR0_LO;  /*!< (@ 0x00000008) register DAR0_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR0_HI;  /*!< (@ 0x0000000c) register DAR0_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP0_LO;  /*!< (@ 0x00000010) register LLP0_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP0_HI;  /*!< (@ 0x00000014) register LLP0_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL0_LO;  /*!< (@ 0x00000018) register CTL0_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL0_HI;  /*!< (@ 0x0000001c) register CTL0_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT0_LO;  /*!< (@ 0x00000020) register SSTAT0_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT0_HI;  /*!< (@ 0x00000024) register SSTAT0_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT0_LO;  /*!< (@ 0x00000028) register DSTAT0_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT0_HI;  /*!< (@ 0x0000002c) register DSTAT0_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR0_LO;  /*!< (@ 0x00000030) register SSTATAR0_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR0_HI;  /*!< (@ 0x00000034) register SSTATAR0_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR0_LO;  /*!< (@ 0x00000038) register DSTATAR0_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR0_HI;  /*!< (@ 0x0000003c) register DSTATAR0_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG0_LO;  /*!< (@ 0x00000040) register CFG0_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG0_HI;  /*!< (@ 0x00000044) register CFG0_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR0_LO;  /*!< (@ 0x00000048) register SGR0_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR0_HI;  /*!< (@ 0x0000004c) register SGR0_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR0_LO;  /*!< (@ 0x00000050) register DSR0_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR0_HI;  /*!< (@ 0x00000054) register DSR0_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR1_LO;  /*!< (@ 0x00000058) register SAR1_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR1_HI;  /*!< (@ 0x0000005c) register SAR1_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR1_LO;  /*!< (@ 0x00000060) register DAR1_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR1_HI;  /*!< (@ 0x00000064) register DAR1_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP1_LO;  /*!< (@ 0x00000068) register LLP1_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP1_HI;  /*!< (@ 0x0000006c) register LLP1_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL1_LO;  /*!< (@ 0x00000070) register CTL1_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL1_HI;  /*!< (@ 0x00000074) register CTL1_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT1_LO;  /*!< (@ 0x00000078) register SSTAT1_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT1_HI;  /*!< (@ 0x0000007c) register SSTAT1_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT1_LO;  /*!< (@ 0x00000080) register DSTAT1_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT1_HI;  /*!< (@ 0x00000084) register DSTAT1_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR1_LO;  /*!< (@ 0x00000088) register SSTATAR1_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR1_HI;  /*!< (@ 0x0000008c) register SSTATAR1_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR1_LO;  /*!< (@ 0x00000090) register DSTATAR1_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR1_HI;  /*!< (@ 0x00000094) register DSTATAR1_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG1_LO;  /*!< (@ 0x00000098) register CFG1_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG1_HI;  /*!< (@ 0x0000009c) register CFG1_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR1_LO;  /*!< (@ 0x000000a0) register SGR1_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR1_HI;  /*!< (@ 0x000000a4) register SGR1_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR1_LO;  /*!< (@ 0x000000a8) register DSR1_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR1_HI;  /*!< (@ 0x000000ac) register DSR1_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR2_LO;  /*!< (@ 0x000000b0) register SAR2_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR2_HI;  /*!< (@ 0x000000b4) register SAR2_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR2_LO;  /*!< (@ 0x000000b8) register DAR2_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR2_HI;  /*!< (@ 0x000000bc) register DAR2_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP2_LO;  /*!< (@ 0x000000c0) register LLP2_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP2_HI;  /*!< (@ 0x000000c4) register LLP2_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL2_LO;  /*!< (@ 0x000000c8) register CTL2_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL2_HI;  /*!< (@ 0x000000cc) register CTL2_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT2_LO;  /*!< (@ 0x000000d0) register SSTAT2_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT2_HI;  /*!< (@ 0x000000d4) register SSTAT2_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT2_LO;  /*!< (@ 0x000000d8) register DSTAT2_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT2_HI;  /*!< (@ 0x000000dc) register DSTAT2_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR2_LO;  /*!< (@ 0x000000e0) register SSTATAR2_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR2_HI;  /*!< (@ 0x000000e4) register SSTATAR2_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR2_LO;  /*!< (@ 0x000000e8) register DSTATAR2_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR2_HI;  /*!< (@ 0x000000ec) register DSTATAR2_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG2_LO;  /*!< (@ 0x000000f0) register CFG2_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG2_HI;  /*!< (@ 0x000000f4) register CFG2_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR2_LO;  /*!< (@ 0x000000f8) register SGR2_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR2_HI;  /*!< (@ 0x000000fc) register SGR2_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR2_LO;  /*!< (@ 0x00000100) register DSR2_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR2_HI;  /*!< (@ 0x00000104) register DSR2_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR3_LO;  /*!< (@ 0x00000108) register SAR3_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR3_HI;  /*!< (@ 0x0000010c) register SAR3_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR3_LO;  /*!< (@ 0x00000110) register DAR3_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR3_HI;  /*!< (@ 0x00000114) register DAR3_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP3_LO;  /*!< (@ 0x00000118) register LLP3_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP3_HI;  /*!< (@ 0x0000011c) register LLP3_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL3_LO;  /*!< (@ 0x00000120) register CTL3_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL3_HI;  /*!< (@ 0x00000124) register CTL3_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT3_LO;  /*!< (@ 0x00000128) register SSTAT3_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT3_HI;  /*!< (@ 0x0000012c) register SSTAT3_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT3_LO;  /*!< (@ 0x00000130) register DSTAT3_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT3_HI;  /*!< (@ 0x00000134) register DSTAT3_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR3_LO;  /*!< (@ 0x00000138) register SSTATAR3_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR3_HI;  /*!< (@ 0x0000013c) register SSTATAR3_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR3_LO;  /*!< (@ 0x00000140) register DSTATAR3_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR3_HI;  /*!< (@ 0x00000144) register DSTATAR3_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG3_LO;  /*!< (@ 0x00000148) register CFG3_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG3_HI;  /*!< (@ 0x0000014c) register CFG3_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR3_LO;  /*!< (@ 0x00000150) register SGR3_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR3_HI;  /*!< (@ 0x00000154) register SGR3_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR3_LO;  /*!< (@ 0x00000158) register DSR3_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR3_HI;  /*!< (@ 0x0000015c) register DSR3_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR4_LO;  /*!< (@ 0x00000160) register SAR4_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR4_HI;  /*!< (@ 0x00000164) register SAR4_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR4_LO;  /*!< (@ 0x00000168) register DAR4_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR4_HI;  /*!< (@ 0x0000016c) register DAR4_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP4_LO;  /*!< (@ 0x00000170) register LLP4_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP4_HI;  /*!< (@ 0x00000174) register LLP4_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL4_LO;  /*!< (@ 0x00000178) register CTL4_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL4_HI;  /*!< (@ 0x0000017c) register CTL4_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT4_LO;  /*!< (@ 0x00000180) register SSTAT4_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT4_HI;  /*!< (@ 0x00000184) register SSTAT4_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT4_LO;  /*!< (@ 0x00000188) register DSTAT4_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT4_HI;  /*!< (@ 0x0000018c) register DSTAT4_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR4_LO;  /*!< (@ 0x00000190) register SSTATAR4_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR4_HI;  /*!< (@ 0x00000194) register SSTATAR4_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR4_LO;  /*!< (@ 0x00000198) register DSTATAR4_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR4_HI;  /*!< (@ 0x0000019c) register DSTATAR4_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG4_LO;  /*!< (@ 0x000001a0) register CFG4_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG4_HI;  /*!< (@ 0x000001a4) register CFG4_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR4_LO;  /*!< (@ 0x000001a8) register SGR4_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR4_HI;  /*!< (@ 0x000001ac) register SGR4_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR4_LO;  /*!< (@ 0x000001b0) register DSR4_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR4_HI;  /*!< (@ 0x000001b4) register DSR4_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR5_LO;  /*!< (@ 0x000001b8) register SAR5_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR5_HI;  /*!< (@ 0x000001bc) register SAR5_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR5_LO;  /*!< (@ 0x000001c0) register DAR5_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR5_HI;  /*!< (@ 0x000001c4) register DAR5_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP5_LO;  /*!< (@ 0x000001c8) register LLP5_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP5_HI;  /*!< (@ 0x000001cc) register LLP5_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL5_LO;  /*!< (@ 0x000001d0) register CTL5_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL5_HI;  /*!< (@ 0x000001d4) register CTL5_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT5_LO;  /*!< (@ 0x000001d8) register SSTAT5_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT5_HI;  /*!< (@ 0x000001dc) register SSTAT5_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT5_LO;  /*!< (@ 0x000001e0) register DSTAT5_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT5_HI;  /*!< (@ 0x000001e4) register DSTAT5_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR5_LO;  /*!< (@ 0x000001e8) register SSTATAR5_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR5_HI;  /*!< (@ 0x000001ec) register SSTATAR5_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR5_LO;  /*!< (@ 0x000001f0) register DSTATAR5_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR5_HI;  /*!< (@ 0x000001f4) register DSTATAR5_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG5_LO;  /*!< (@ 0x000001f8) register CFG5_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG5_HI;  /*!< (@ 0x000001fc) register CFG5_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR5_LO;  /*!< (@ 0x00000200) register SGR5_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR5_HI;  /*!< (@ 0x00000204) register SGR5_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR5_LO;  /*!< (@ 0x00000208) register DSR5_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR5_HI;  /*!< (@ 0x0000020c) register DSR5_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR6_LO;  /*!< (@ 0x00000210) register SAR6_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR6_HI;  /*!< (@ 0x00000214) register SAR6_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR6_LO;  /*!< (@ 0x00000218) register DAR6_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR6_HI;  /*!< (@ 0x0000021c) register DAR6_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP6_LO;  /*!< (@ 0x00000220) register LLP6_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP6_HI;  /*!< (@ 0x00000224) register LLP6_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL6_LO;  /*!< (@ 0x00000228) register CTL6_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL6_HI;  /*!< (@ 0x0000022c) register CTL6_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT6_LO;  /*!< (@ 0x00000230) register SSTAT6_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT6_HI;  /*!< (@ 0x00000234) register SSTAT6_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT6_LO;  /*!< (@ 0x00000238) register DSTAT6_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT6_HI;  /*!< (@ 0x0000023c) register DSTAT6_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR6_LO;  /*!< (@ 0x00000240) register SSTATAR6_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR6_HI;  /*!< (@ 0x00000244) register SSTATAR6_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR6_LO;  /*!< (@ 0x00000248) register DSTATAR6_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR6_HI;  /*!< (@ 0x0000024c) register DSTATAR6_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG6_LO;  /*!< (@ 0x00000250) register CFG6_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG6_HI;  /*!< (@ 0x00000254) register CFG6_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR6_LO;  /*!< (@ 0x00000258) register SGR6_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR6_HI;  /*!< (@ 0x0000025c) register SGR6_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR6_LO;  /*!< (@ 0x00000260) register DSR6_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR6_HI;  /*!< (@ 0x00000264) register DSR6_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR7_LO;  /*!< (@ 0x00000268) register SAR7_LO 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  SAR7_HI;  /*!< (@ 0x0000026c) register SAR7_HI 
The starting source address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the source address of the current AHB transfer.
Note:You must program the SAR address to be aligned to CTLx.SRC_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR7_LO;  /*!< (@ 0x00000270) register DAR7_LO 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  DAR7_HI;  /*!< (@ 0x00000274) register DAR7_HI 
The starting destination address is programmed by software before the DMA channel is enabled, or by an LLI update before the start of the DMA transfer. While the DMA transfer is in progress, this register is updated to reflect the destination address of the current AHB transfer.
Note: You must program the DAR to be aligned to CTLx.DST_TR_WIDTH.
For information on how the DARx is updated at the start of each DMA block for multi-block transfers, refer "Programming Examples".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP7_LO;  /*!< (@ 0x00000278) register LLP7_LO 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  LLP7_HI;  /*!< (@ 0x0000027c) register LLP7_HI 
This register does not exist if the DMAH_CHx_HC_LLP configuration parameter is set to True
The LLP register has two
functions:
 - The logical result of the equation LLP.LOC !=0 is used to set up the type of DMA transfer - single or multi-block.  The Table "Programming of Transfer Types and Channel Register
Update Method" shows how the method of updating the channel registers is a function of LLP.LOC != 0. If LLP.LOC is set to 0x0, then transfers using linked lists are not enabled. This register must be
programmed prior to enabling the channel in order to set up the transfer type.
 - LLP.LOC != 0 contains the pointer to the next LLI for block chaining using linked lists; refer to "Block Chaining
Using Linked Lists". The LLPx register can also point to the address where write-back of the control and source/destination status information occur after block completion.
Note:You need to program this register to point to the first Linked List Item (LLI) in memory prior to enabling the channel if block chaining is enabled. If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  CTL7_LO;  /*!< (@ 0x00000280) register CTL7_LO 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  CTL7_HI;  /*!< (@ 0x00000284) register CTL7_HI 
This register contains fields that control the DMA transfer.
The CTLx register is part of the block descriptor (linked list item - LLI) when block chaining is enabled. It can be varied on a block-by-block basis within a DMA transfer when block chaining is enabled. For information about the behavior of this register between blocks, refer to "Multi-Block Transfers".
If status write-back is enabled, the upper word of the control register, CTLx[63:32], is written to the control register location of the LLI in system memory at the end of the block transfer.
Note:You need to program this register prior to enabling the channel.
Reset Value: DMAH_CTLx_RST */

  __IOM  uint32_t  SSTAT7_LO;  /*!< (@ 0x00000288) register SSTAT7_LO 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTAT7_HI;  /*!< (@ 0x0000028c) register SSTAT7_HI 
After each block transfer completes, hardware can retrieve the source status information from the address pointed to by the contents of the SSTATARx register. This status information is then stored in the SSTATx register and written out to the SSTATx register location of the LLI before the start of the next block. For conditions under which the source status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Note: This register is a temporary placeholder for the source status information on its way to the SSTATx register location of the LLI. The source status information should be retrieved by software from the SSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT7_LO;  /*!< (@ 0x00000290) register DSTAT7_LO 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  DSTAT7_HI;  /*!< (@ 0x00000294) register DSTAT7_HI 
After each block transfer completes, hardware can retrieve the destination status information from the address pointed to by the contents of the DSTATARx register. This status information is then stored in the DSTATx register and written out to the DSTATx register location of the LLI before the start of the next block. For conditions under which the destination status information is fetched, refer to "Multi-Block Transfers". This register does not exist if DMAH_CHx_STAT_DST is set to False; in this case, the read-back value is always 0.
Note:This register is a temporary placeholder for the destination status information on its way to the DSTATx register location of the LLI. The destination status information should be retrieved by software from the DSTATx register location of the LLI, and not by a read of this register over the DW_ahb_dmac slave interface.
If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR7_LO;  /*!< (@ 0x00000298) register SSTATAR7_LO 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  SSTATAR7_HI;  /*!< (@ 0x0000029c) register SSTATAR7_HI 
After completion of each block transfer, hardware can retrieve the source status information from the user-defined address to which the contents of the SSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the source transfer. For example, if the DW_apb_ssi is the source peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in SSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.RXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx_STAT_SRC is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR7_LO;  /*!< (@ 0x000002a0) register DSTATAR7_LO 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  DSTATAR7_HI;  /*!< (@ 0x000002a4) register DSTATAR7_HI 
After completion of each block transfer, hardware can retrieve the destination status information from the user-defined address to which the contents of the DSTATARx register point. The user can select any location in system memory that would provide a 32-bit value to indicate the status of the destination transfer. For example, if the DW_apb_ssi is the destination peripheral for the DMA transfer, the user can use one of the SSI registers to indicate the status of the transfer. Thus the address programmed in DSTATARx could be the address of the SSI.CTRL register or the SSI.ISR register, or it could be the address of the SSI.TXFLR register.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
This register does not exist if the configuration parameter DMAH_CHx-STAT_DST is set to False; in this case, the read-back value is always 0.
Reset Value: 0x0 */

  __IOM  uint32_t  CFG7_LO;  /*!< (@ 0x000002a8) register CFG7_LO 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  CFG7_HI;  /*!< (@ 0x000002ac) register CFG7_HI 
This register contains fields that configure the DMA transfer. The channel configuration register remains fixed for all blocks of a multi-block transfer.
Note: You need to program this register prior to enabling the channel.
Reset Value:  0x0000000400000e00 + (x*0x20) */

  __IOM  uint32_t  SGR7_LO;  /*!< (@ 0x000002b0) register SGR7_LO 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  SGR7_HI;  /*!< (@ 0x000002b4) register SGR7_HI 
The Source Gather register contains two fields:
      - Source gather count field (SGRx.SGC)  Specifies the number of contiguous source transfers of CTLx.SRC_TR_WIDTH between successive gather intervals. This is defined as a gather boundary.
      - Source gather interval field (SGRx.SGI)  Specifies the source address increment/decrement in multiples of CTLx.SRC_TR_WIDTH on a gather boundary when gather mode is enabled for the source transfer.
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.SINC field controls whether the address increments or decrements. When the CTLx.SINC field indicates a fixed-address control, then the address remains constant throughout the transfer and the SGRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_SRC_GAT_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR7_LO;  /*!< (@ 0x000002b8) register DSR7_LO 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  DSR7_HI;  /*!< (@ 0x000002bc) register DSR7_HI 
The Destination Scatter register contains two fields: 
    - Destination scatter count field (DSRx.DSC)  Specifies the number of contiguous destination transfers of CTLx.DST_TR_WIDTH between successive scatter boundaries.
    - Destination scatter interval field (DSRx.DSI)  Specifies the destination address increment/decrement in multiples of CTLx.DST_TR_WIDTH on a scatter boundary when scatter mode is enabled for the destination transfer.
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
The CTLx.DINC field controls whether the address increments or decrements. When the CTLx.DINC field indicates a fixed address control, then the address remains constant throughout the transfer and the DSRx register is ignored. This register does not exist if the configuration parameter DMAH_CHx_DST_SCA_EN is set to False. For more information, see "Scatter/Gather".
Reset Value: 0x0 */

  __IOM  uint32_t  RAWTFR_LO;  /*!< (@ 0x000002c0) register RAWTFR_LO 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawTfr[2] is the Channel 2 raw transfer complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearTfr register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWTFR_HI;  /*!< (@ 0x000002c4) register RAWTFR_HI 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawTfr[2] is the Channel 2 raw transfer complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearTfr register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWBLOCK_LO;  /*!< (@ 0x000002c8) register RAWBLOCK_LO 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawBlock[2] is the Channel 2 raw block complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearBlock register.
Note:Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWBLOCK_HI;  /*!< (@ 0x000002cc) register RAWBLOCK_HI 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawBlock[2] is the Channel 2 raw block complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearBlock register.
Note:Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWSRCTRAN_LO;  /*!< (@ 0x000002d0) register RAWSRCTRAN_LO 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawSrcTran[2] is the Channel 2 raw source transaction complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearSrcTran register.
Note:Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWSRCTRAN_HI;  /*!< (@ 0x000002d4) register RAWSRCTRAN_HI 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawSrcTran[2] is the Channel 2 raw source transaction complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearSrcTran register.
Note:Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWDSTTRAN_LO;  /*!< (@ 0x000002d8) register RAWDSTTRAN_LO 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawDstTran[2] is the Channel 2 raw destination transaction complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearDstTran register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWDSTTRAN_HI;  /*!< (@ 0x000002dc) register RAWDSTTRAN_HI 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawDstTran[2] is the Channel 2 raw destination transaction complete interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearDstTran register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWERR_LO;  /*!< (@ 0x000002e0) register RAWERR_LO 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawErr[2] is the Channel 2 raw error interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearErr register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

  __IOM  uint32_t  RAWERR_HI;  /*!< (@ 0x000002e4) register RAWERR_HI 
Interrupt events are stored in this Raw Interrupt Status register before masking. This register has a bit allocated per channel; for example, RawErr[2] is the Channel 2 raw error interrupt.
Each bit in this register is cleared by writing a 1 to the corresponding location in the ClearErr register.
Note: Write access is available to this register or software testing purposes only. Under normal operation, writes to this register are not recommended.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSTFR_LO;  /*!< (@ 0x000002e8) register STATUSTFR_LO 
Channel DMA Transfer complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusTfr[2] is the Channel 2 source DMA transfer complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSTFR_HI;  /*!< (@ 0x000002ec) register STATUSTFR_HI 
Channel DMA Transfer complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusTfr[2] is the Channel 2 source DMA transfer complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSBLOCK_LO;  /*!< (@ 0x000002f0) register STATUSBLOCK_LO 
Channel Block complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusBlock[2] is the Channel 2 block complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSBLOCK_HI;  /*!< (@ 0x000002f4) register STATUSBLOCK_HI 
Channel Block complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusBlock[2] is the Channel 2 block complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSSRCTRAN_LO;  /*!< (@ 0x000002f8) register STATUSSRCTRAN_LO 
Channel Source Transaction complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusSrcTran[2] is the Channel 2 source transaction complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSSRCTRAN_HI;  /*!< (@ 0x000002fc) register STATUSSRCTRAN_HI 
Channel Source Transaction complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusSrcTran[2] is the Channel 2 source transaction complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSDSTTRAN_LO;  /*!< (@ 0x00000300) register STATUSDSTTRAN_LO 
Channel destination transaction complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusDstTran[2] is the Channel 2 status destination transaction complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSDSTTRAN_HI;  /*!< (@ 0x00000304) register STATUSDSTTRAN_HI 
Channel destination transaction complete interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusDstTran[2] is the Channel 2 status destination transaction complete interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSERR_LO;  /*!< (@ 0x00000308) register STATUSERR_LO 
Channel Error interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusErr[2] is the Channel 2 status Error interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSERR_HI;  /*!< (@ 0x0000030c) register STATUSERR_HI 
Channel Error interrupt event from all channels is stored in this Interrupt Status register after masking. This register has a bit allocated per channel; for example, StatusErr[2] is the Channel 2 status Error interrupt. The contents of this register are used to generate the interrupt signals (int or int_n bus, depending on interrupt polarity) leaving the DW_ahb_dmac.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKTFR_LO;  /*!< (@ 0x00000310) register MASKTFR_LO 
The contents of the Raw Status register RawTfr is masked with the contents of the Mask register MaskTfr. Each bit of register is allocated per channel; for example, MaskTfr[2] is the mask bit for the Channel 2 transfer complete interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskTfr register writes a 1 into MaskTfr[0], while MaskTfr[7:1] remains unchanged. Writing hex 00xx leaves MaskTfr[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKTFR_HI;  /*!< (@ 0x00000314) register MASKTFR_HI 
The contents of the Raw Status register RawTfr is masked with the contents of the Mask register MaskTfr. Each bit of register is allocated per channel; for example, MaskTfr[2] is the mask bit for the Channel 2 transfer complete interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskTfr register writes a 1 into MaskTfr[0], while MaskTfr[7:1] remains unchanged. Writing hex 00xx leaves MaskTfr[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKBLOCK_LO;  /*!< (@ 0x00000318) register MASKBLOCK_LO 
The contents of the Raw Status register RawBlock is masked with the contents of the Mask register MaskBlock. Each bit of register is allocated per channel; for example, MaskBlock[2] is the mask bit for the Channel 2 block complete interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskBlock register writes a 1 into MaskBlock[0], while MaskBlock[7:1] remains unchanged. Writing hex 00xx leaves MaskBlock[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKBLOCK_HI;  /*!< (@ 0x0000031c) register MASKBLOCK_HI 
The contents of the Raw Status register RawBlock is masked with the contents of the Mask register MaskBlock. Each bit of register is allocated per channel; for example, MaskBlock[2] is the mask bit for the Channel 2 block complete interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskBlock register writes a 1 into MaskBlock[0], while MaskBlock[7:1] remains unchanged. Writing hex 00xx leaves MaskBlock[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKSRCTRAN_LO;  /*!< (@ 0x00000320) register MASKSRCTRAN_LO 
The contents of the Raw Status register RawSrcTran is masked with the contents of the Mask register MaskSrcTran. Each bit of register is allocated per channel; for example, MaskSrcTran[2] is the mask bit for the Channel 2 source transaction complete interrupt.
When the source peripheral of DMA channel i is memory, then the source transaction complete interrupt, MaskSrcTran[i], must be masked to prevent an erroneous triggering of an interrupt on the int_combined signal.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskSrcTran register writes a 1 into MaskSrcTran[0], while MaskSrcTran[7:1] remains unchanged. Writing hex 00xx leaves MaskSrcTran[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKSRCTRAN_HI;  /*!< (@ 0x00000324) register MASKSRCTRAN_HI 
The contents of the Raw Status register RawSrcTran is masked with the contents of the Mask register MaskSrcTran. Each bit of register is allocated per channel; for example, MaskSrcTran[2] is the mask bit for the Channel 2 source transaction complete interrupt.
When the source peripheral of DMA channel i is memory, then the source transaction complete interrupt, MaskSrcTran[i], must be masked to prevent an erroneous triggering of an interrupt on the int_combined signal.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskSrcTran register writes a 1 into MaskSrcTran[0], while MaskSrcTran[7:1] remains unchanged. Writing hex 00xx leaves MaskSrcTran[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKDSTTRAN_LO;  /*!< (@ 0x00000328) register MASKDSTTRAN_LO 
The contents of the Raw Status register RawDstTran is masked with the contents of the Mask register MaskDstTran. Each bit of register is allocated per channel; for example, MaskDstTran[2] is the mask bit for the Channel 2 destination transaction complete interrupt.
When the destination peripheral of DMA channel i is memory, then the destination transaction complete interrupt, MaskDstTran[i], must be masked to prevent an erroneous triggering of an interrupt on the int_combined(_n) signal.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskDstTran register writes a 1 into MaskDstTran[0], while MaskDstTran[7:1] remains unchanged. Writing hex 00xx leaves MaskDstTran[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKDSTTRAN_HI;  /*!< (@ 0x0000032c) register MASKDSTTRAN_HI 
The contents of the Raw Status register RawDstTran is masked with the contents of the Mask register MaskDstTran. Each bit of register is allocated per channel; for example, MaskDstTran[2] is the mask bit for the Channel 2 destination transaction complete interrupt.
When the destination peripheral of DMA channel i is memory, then the destination transaction complete interrupt, MaskDstTran[i], must be masked to prevent an erroneous triggering of an interrupt on the int_combined(_n) signal.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskDstTran register writes a 1 into MaskDstTran[0], while MaskDstTran[7:1] remains unchanged. Writing hex 00xx leaves MaskDstTran[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKERR_LO;  /*!< (@ 0x00000330) register MASKERR_LO 
The contents of the Raw Status register RawErr is masked with the contents of the Mask register MaskErr. Each bit of register is allocated per channel; for example, MaskErr[2] is the mask bit for the Channel 2 error interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskErr register writes a 1 into MaskErr[0], while MaskErr[7:1] remains unchanged. Writing hex 00xx leaves MaskErr[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

  __IOM  uint32_t  MASKERR_HI;  /*!< (@ 0x00000334) register MASKERR_HI 
The contents of the Raw Status register RawErr is masked with the contents of the Mask register MaskErr. Each bit of register is allocated per channel; for example, MaskErr[2] is the mask bit for the Channel 2 error interrupt.
A channel INT_MASK bit will be written only if the corresponding mask write enable bit in the INT_MASK_WE field is asserted on the same AHB write transfer. This allows software to set a mask bit without performing a read-modified write operation. For example, writing hex 01x1 to the MaskErr register writes a 1 into MaskErr[0], while MaskErr[7:1] remains unchanged. Writing hex 00xx leaves MaskErr[7:0] unchanged.
Writing a 1 to any bit in this register unmasks the corresponding interrupt, thus allowing the DW_ahb_dmac to set the appropriate bit in the Status registers and int_* port signals.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARTFR_LO;  /*!< (@ 0x00000338) register CLEARTFR_LO 
Each bit in the RawTfr and StatusTfr is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearTfr[2] is the clear bit for the Channel 2 transfer done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARTFR_HI;  /*!< (@ 0x0000033c) register CLEARTFR_HI 
Each bit in the RawTfr and StatusTfr is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearTfr[2] is the clear bit for the Channel 2 transfer done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARBLOCK_LO;  /*!< (@ 0x00000340) register CLEARBLOCK_LO 
Each bit in the RawBlock and StatusBlock is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearBlock[2] is the clear bit for the Channel 2 block done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARBLOCK_HI;  /*!< (@ 0x00000344) register CLEARBLOCK_HI 
Each bit in the RawBlock and StatusBlock is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearBlock[2] is the clear bit for the Channel 2 block done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARSRCTRAN_LO;  /*!< (@ 0x00000348) register CLEARSRCTRAN_LO 
Each bit in the RawSrcTran and StatusSrcTran is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearSrcTran[2] is the clear bit for the Channel 2 source transaction done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARSRCTRAN_HI;  /*!< (@ 0x0000034c) register CLEARSRCTRAN_HI 
Each bit in the RawSrcTran and StatusSrcTran is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearSrcTran[2] is the clear bit for the Channel 2 source transaction done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARDSTTRAN_LO;  /*!< (@ 0x00000350) register CLEARDSTTRAN_LO 
Each bit in the RawDstTran and StatusDstTran is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearDstTran[2] is the clear bit for the Channel 2 destination transaction done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARDSTTRAN_HI;  /*!< (@ 0x00000354) register CLEARDSTTRAN_HI 
Each bit in the RawDstTran and StatusDstTran is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearDstTran[2] is the clear bit for the Channel 2 destination transaction done interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARERR_LO;  /*!< (@ 0x00000358) register CLEARERR_LO 
Each bit in the RawErr and StatusErr is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearErr[2] is the clear bit for the Channel 2 error interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __OM  uint32_t  CLEARERR_HI;  /*!< (@ 0x0000035c) register CLEARERR_HI 
Each bit in the RawErr and StatusErr is cleared on the same cycle by writing a 1 to the corresponding location in the this registers. Each bit is allocated per channel; for example, ClearErr[2] is the clear bit for the Channel 2 error interrupt. Writing a 0 has no effect. This registers are not readable.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSINT_LO;  /*!< (@ 0x00000360) register STATUSINT_LO 
The contents of each of the five Status registers  StatusTfr, StatusBlock, StatusSrcTran, StatusDstTran, StatusErr  is ORed to produce a single bit for each interrupt type in the Combined Status register (StatusInt). This register is read-only.
Reset Value: 0x0 */

   __IM  uint32_t  STATUSINT_HI;  /*!< (@ 0x00000364) register STATUSINT_HI 
The contents of each of the five Status registers  StatusTfr, StatusBlock, StatusSrcTran, StatusDstTran, StatusErr  is ORed to produce a single bit for each interrupt type in the Combined Status register (StatusInt). This register is read-only.
Reset Value: 0x0 */

  __IOM  uint32_t  REQSRCREG_LO;  /*!< (@ 0x00000368) register REQSRCREG_LO 
A bit is assigned for each channel in this register. ReqSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel SRC_REQ bit is written only if the corresponding channel write enable bit in the SRC_REQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register. For example, writing hex 0101 writes a 1 into ReqSrcReg[0], while ReqSrcReg[7:1] remains unchanged. Writing hex 00xx leaves ReqSrcReg[7:0] unchanged. This allows software to set a bit in the ReqSrcReg register without performing a read-modified write operation.
The functionality of this register depends on whether the source is a flow control peripheral or not. For a description of when the source is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the source is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  REQSRCREG_HI;  /*!< (@ 0x0000036c) register REQSRCREG_HI 
A bit is assigned for each channel in this register. ReqSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel SRC_REQ bit is written only if the corresponding channel write enable bit in the SRC_REQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register. For example, writing hex 0101 writes a 1 into ReqSrcReg[0], while ReqSrcReg[7:1] remains unchanged. Writing hex 00xx leaves ReqSrcReg[7:0] unchanged. This allows software to set a bit in the ReqSrcReg register without performing a read-modified write operation.
The functionality of this register depends on whether the source is a flow control peripheral or not. For a description of when the source is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the source is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  REQDSTREG_LO;  /*!< (@ 0x00000370) register REQDSTREG_LO 
A bit is assigned for each channel in this register. ReqDstReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel DST_REQ bit is written only if the corresponding channel write enable bit in the DST_REQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the destination is a flow control peripheral or not. For a description of when the destination is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the destination is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  REQDSTREG_HI;  /*!< (@ 0x00000374) register REQDSTREG_HI 
A bit is assigned for each channel in this register. ReqDstReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel DST_REQ bit is written only if the corresponding channel write enable bit in the DST_REQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the destination is a flow control peripheral or not. For a description of when the destination is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the destination is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  SGLRQSRCREG_LO;  /*!< (@ 0x00000378) register SGLRQSRCREG_LO 
A bit is assigned for each channel in this register. SglReqSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel SRC_SGLREQ bit is written only if the corresponding channel write enable bit in the SRC_SGLREQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the source is a flow control peripheral or not. For a description of when the source is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the source is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  SGLRQSRCREG_HI;  /*!< (@ 0x0000037c) register SGLRQSRCREG_HI 
A bit is assigned for each channel in this register. SglReqSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n.
A channel SRC_SGLREQ bit is written only if the corresponding channel write enable bit in the SRC_SGLREQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the source is a flow control peripheral or not. For a description of when the source is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the source is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  SGLRQDSTREG_LO;  /*!< (@ 0x00000380) register SGLRQDSTREG_LO 
A bit is assigned for each channel in this register. SglReqDstReg[n] is ignored when software handshaking is not enabled for the destination of channel n.
A channel DST_SGLREQ bit is written only if the corresponding channel write enable bit in the DST_SGLREQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the destination is a flow control peripheral or not. For a description of when the destination is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the destination is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  SGLRQDSTREG_HI;  /*!< (@ 0x00000384) register SGLRQDSTREG_HI 
A bit is assigned for each channel in this register. SglReqDstReg[n] is ignored when software handshaking is not enabled for the destination of channel n.
A channel DST_SGLREQ bit is written only if the corresponding channel write enable bit in the DST_SGLREQ_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
The functionality of this register depends on whether the destination is a flow control peripheral or not. For a description of when the destination is not a flow controller, refer to "Software Handshaking  Peripheral Is Not Flow Controller". For a description of when the destination is a flow controller, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  LSTSRCREG_LO;  /*!< (@ 0x00000388) register LSTSRCREG_LO 
A bit is assigned for each channel in this register. LstSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n, or when the source of channel n is not a flow controller.
A channel LSTSRC bit is written only if the corresponding channel write enable bit in the LSTSRC_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
For a description of this register, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  LSTSRCREG_HI;  /*!< (@ 0x0000038c) register LSTSRCREG_HI 
A bit is assigned for each channel in this register. LstSrcReg[n] is ignored when software handshaking is not enabled for the source of channel n, or when the source of channel n is not a flow controller.
A channel LSTSRC bit is written only if the corresponding channel write enable bit in the LSTSRC_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
For a description of this register, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  LSTDSTREG_LO;  /*!< (@ 0x00000390) register LSTDSTREG_LO 
A bit is assigned for each channel in this register. LstDstReg[n] is ignored when software handshaking is not enabled for the destination of channel n or when the destination of channel n is not a flow controller.
A channel LSTDST bit is written only if the corresponding channel write enable bit in the LSTDST_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
For a description of this register, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  LSTDSTREG_HI;  /*!< (@ 0x00000394) register LSTDSTREG_HI 
A bit is assigned for each channel in this register. LstDstReg[n] is ignored when software handshaking is not enabled for the destination of channel n or when the destination of channel n is not a flow controller.
A channel LSTDST bit is written only if the corresponding channel write enable bit in the LSTDST_WE field is asserted on the same AHB write transfer, and if the channel is enabled in the ChEnReg register.
For a description of this register, refer to "Software Handshaking  Peripheral Is Flow Controller".
Reset Value: 0x0 */

  __IOM  uint32_t  DMACFGREG_LO;  /*!< (@ 0x00000398) register DMACFGREG_LO 
This register is used to enable the DW_ahb_dmac, which must be done before any channel activity can begin.
If the global channel enable bit is cleared while any channel is still active, then DmaCfgReg.DMA_EN still returns 1 to indicate that there are channels still active until hardware has terminated all activity on all channels, at which point the DmaCfgReg.DMA_EN bit returns 0. For more information, refer to "Abnormal Transfer Termination".
Reset Value: 0x0 */

  __IOM  uint32_t  DMACFGREG_HI;  /*!< (@ 0x0000039c) register DMACFGREG_HI 
This register is used to enable the DW_ahb_dmac, which must be done before any channel activity can begin.
If the global channel enable bit is cleared while any channel is still active, then DmaCfgReg.DMA_EN still returns 1 to indicate that there are channels still active until hardware has terminated all activity on all channels, at which point the DmaCfgReg.DMA_EN bit returns 0. For more information, refer to "Abnormal Transfer Termination".
Reset Value: 0x0 */

  __IOM  uint32_t  CHENREG_LO;  /*!< (@ 0x000003a0) register CHENREG_LO 
This is the DW_ahb_dmac Channel Enable Register. If software needs to set up a new channel, then it can read this register in order to find out which channels are currently inactive; it can then enable an inactive channel with the required priority.
All bits of this register are cleared to 0 when the global DW_ahb_dmac channel enable bit, DmaCfgReg[0], is 0. When the global channel enable bit is 0, then a write to the ChEnReg register is ignored and a read will always read back 0.
The channel enable bit, ChEnReg.CH_EN, is written only if the corresponding channel write enable bit, ChEnReg.CH_EN_WE, is asserted on the same AHB write transfer. For example, writing hex 01x1 writes a 1 into ChEnReg[0], while ChEnReg[7:1] remains unchanged. Writing hex 00xx leaves ChEnReg[7:0] unchanged. Note that a read-modified write is not required.
For information on software disabling a channel by writing 0 to ChEnReg.CH_EN, refer to "Disabling a Channel Prior to Transfer Completion".
Reset Value: 0x0 */

  __IOM  uint32_t  CHENREG_HI;  /*!< (@ 0x000003a4) register CHENREG_HI 
This is the DW_ahb_dmac Channel Enable Register. If software needs to set up a new channel, then it can read this register in order to find out which channels are currently inactive; it can then enable an inactive channel with the required priority.
All bits of this register are cleared to 0 when the global DW_ahb_dmac channel enable bit, DmaCfgReg[0], is 0. When the global channel enable bit is 0, then a write to the ChEnReg register is ignored and a read will always read back 0.
The channel enable bit, ChEnReg.CH_EN, is written only if the corresponding channel write enable bit, ChEnReg.CH_EN_WE, is asserted on the same AHB write transfer. For example, writing hex 01x1 writes a 1 into ChEnReg[0], while ChEnReg[7:1] remains unchanged. Writing hex 00xx leaves ChEnReg[7:0] unchanged. Note that a read-modified write is not required.
For information on software disabling a channel by writing 0 to ChEnReg.CH_EN, refer to "Disabling a Channel Prior to Transfer Completion".
Reset Value: 0x0 */

   __IM  uint32_t  DMAIDREG_LO;  /*!< (@ 0x000003a8) register DMAIDREG_LO 
This is the DW_ahb_dmac ID register, which is a read-only register that reads back the coreConsultant-configured hardcoded ID number, DMAH_ID_NUM.
Reset Value: DMAH_ID_NUM */

   __IM  uint32_t  DMAIDREG_HI;  /*!< (@ 0x000003ac) register DMAIDREG_HI 
This is the DW_ahb_dmac ID register, which is a read-only register that reads back the coreConsultant-configured hardcoded ID number, DMAH_ID_NUM.
Reset Value: DMAH_ID_NUM */

  __IOM  uint32_t  DMATESTREG_LO;  /*!< (@ 0x000003b0) register DMATESTREG_LO 
This register is used to put the AHB slave interface into test mode, during which the readback value of the writable registers match the value written, assuming the DW_ahb_dmac configuration has not optimized the same registers. In normal operation, the readback value of some registers is a function of the DW_ahb_dmac state and does not match the value written.
Reset Value: 0x0 */

  __IOM  uint32_t  DMATESTREG_HI;  /*!< (@ 0x000003b4) register DMATESTREG_HI 
This register is used to put the AHB slave interface into test mode, during which the readback value of the writable registers match the value written, assuming the DW_ahb_dmac configuration has not optimized the same registers. In normal operation, the readback value of some registers is a function of the DW_ahb_dmac state and does not match the value written.
Reset Value: 0x0 */

  __IOM  uint32_t  DMALPTIMEOUTREG_LO;  /*!< (@ 0x000003b8) register DMALPTIMEOUTREG_LO 
This register holds the timeout value of Low Power Counter.  The reset value of the register is DMAH_LP_TIMEOUT_VALUE.  The default reset value can be further modified if DMAH_HC_LP_TIMEOUT_VALUE = 0. The final programmed value (or the default reset value if not programmed) determines what is the timeout value the of low power counter.
Reset Value: DMAH_LP_TIMEOUT_VALUE */

  __IOM  uint32_t  DMALPTIMEOUTREG_HI;  /*!< (@ 0x000003bc) register DMALPTIMEOUTREG_HI 
This register holds the timeout value of Low Power Counter.  The reset value of the register is DMAH_LP_TIMEOUT_VALUE.  The default reset value can be further modified if DMAH_HC_LP_TIMEOUT_VALUE = 0. The final programmed value (or the default reset value if not programmed) determines what is the timeout value the of low power counter.
Reset Value: DMAH_LP_TIMEOUT_VALUE */

   __IM  uint32_t  RESERVED0[2];  /*!< not covered by register fields! */
   __IM  uint32_t  DMA_COMP_PARAMS_6_LO;  /*!< (@ 0x000003c8) register DMA_COMP_PARAMS_6_LO 
DMA_COMP_PARAMS_6 is a constant read-only register that contains encoded information about the component parameter settings for Channel 7. The reset value depends on coreConsultant parameter(s).
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_6_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_6_HI;  /*!< (@ 0x000003cc) register DMA_COMP_PARAMS_6_HI 
DMA_COMP_PARAMS_6 is a constant read-only register that contains encoded information about the component parameter settings for Channel 7. The reset value depends on coreConsultant parameter(s).
Note: If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_6_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_5_LO;  /*!< (@ 0x000003d0) register DMA_COMP_PARAMS_5_LO 
DMA_COMP_PARAMS_5 is a constant read-only register that contains encoded information about the component parameter settings for Channel 5 and Channel 6. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_5_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_5_HI;  /*!< (@ 0x000003d4) register DMA_COMP_PARAMS_5_HI 
DMA_COMP_PARAMS_5 is a constant read-only register that contains encoded information about the component parameter settings for Channel 5 and Channel 6. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_5_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_4_LO;  /*!< (@ 0x000003d8) register DMA_COMP_PARAMS_4_LO 
DMA_COMP_PARAMS_4 is a constant read-only register that contains encoded information about the component parameter settings for Channel 3 and Channel 4. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_4_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_4_HI;  /*!< (@ 0x000003dc) register DMA_COMP_PARAMS_4_HI 
DMA_COMP_PARAMS_4 is a constant read-only register that contains encoded information about the component parameter settings for Channel 3 and Channel 4. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_4_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_3_LO;  /*!< (@ 0x000003e0) register DMA_COMP_PARAMS_3_LO 
DMA_COMP_PARAMS_3 is a constant read-only register that contains encoded information about the component parameter settings for Channel 1 and Channel 2. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_3_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_3_HI;  /*!< (@ 0x000003e4) register DMA_COMP_PARAMS_3_HI 
DMA_COMP_PARAMS_3 is a constant read-only register that contains encoded information about the component parameter settings for Channel 1 and Channel 2. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_3_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_2_LO;  /*!< (@ 0x000003e8) register DMA_COMP_PARAMS_2_LO 
DMA_COMP_PARAMS_2 is a constant read-only register that contains encoded information about the component parameter settings. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_2_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_2_HI;  /*!< (@ 0x000003ec) register DMA_COMP_PARAMS_2_HI 
DMA_COMP_PARAMS_2 is a constant read-only register that contains encoded information about the component parameter settings. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_2_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_1_LO;  /*!< (@ 0x000003f0) register DMA_COMP_PARAMS_1_LO 
DMA_COMP_PARAMS_1 is a constant read-only register that contains encoded information about the component parameter settings. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_1_RST */

   __IM  uint32_t  DMA_COMP_PARAMS_1_HI;  /*!< (@ 0x000003f4) register DMA_COMP_PARAMS_1_HI 
DMA_COMP_PARAMS_1 is a constant read-only register that contains encoded information about the component parameter settings. The reset value depends on coreConsultant parameter(s).
Note:If DMAH_RETURN_ERR_RESP is set to True, the DW_ahb_dmac returns an ERROR response to an illegal register access, which includes accessing registers that have been removed during DW_ahb_dmac configuration. If DMAH_RETURN_ERR_RESP is set to False, DW_ahb_dmac always returns an OK response. For more information, refer to "Illegal Register Access".
Reset Value: DMAH_DMA_COMP_PARAMS_1_RST */

   __IM  uint32_t  DMACOMPSID_LO;  /*!< (@ 0x000003f8) register DMACOMPSID_LO 
This is the DW_ahb_dmac Component Version register, which is a read-only register that specifies the version of the packaged component in the upper 32 bits and the component type in the lower 32 bits.
Reset Value: DMAH_COMPS_ID_RST */

   __IM  uint32_t  DMACOMPSID_HI;  /*!< (@ 0x000003fc) register DMACOMPSID_HI 
This is the DW_ahb_dmac Component Version register, which is a read-only register that specifies the version of the packaged component in the upper 32 bits and the component type in the lower 32 bits.
Reset Value: DMAH_COMPS_ID_RST */

} DMA_Type;     /*!< Size = 1024 (0x400) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: FCTR ================================================ */
/* =========================================================================================================================== */

/**
  * @brief FCTR_Type peripheral FCTR
  */
typedef struct {    /*!< (@ 0x50400000) FCTR Structure */
  __IOM  uint32_t  IRQ_ENABLE_SET;  /*!< (@ 0x00000000) register IRQ_ENABLE_SET */
  __IOM  uint32_t  IRQ_ENABLE_CLR;  /*!< (@ 0x00000004) register IRQ_ENABLE_CLR */
  __IOM  uint32_t  IRQ_STATUS_SET;  /*!< (@ 0x00000008) register IRQ_STATUS_SET */
  __IOM  uint32_t  IRQ_STATUS_CLR;  /*!< (@ 0x0000000c) register IRQ_STATUS_CLR */
   __IM  uint32_t  IRQ_MASKED_STATUS;  /*!< (@ 0x00000010) register IRQ_MASKED_STATUS */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000014) register CTRL */
   __IM  uint32_t  STATUS;  /*!< (@ 0x00000018) register STATUS */
  __IOM  uint32_t  ADDR;  /*!< (@ 0x0000001c) register ADDR */
  __IOM  uint32_t  DATA0;  /*!< (@ 0x00000020) register DATA0 */
   __IM  uint32_t  DATA1;  /*!< (@ 0x00000024) register DATA1 */
   __IM  uint32_t  DATA2;  /*!< (@ 0x00000028) register DATA2 */
   __IM  uint32_t  DATA3;  /*!< (@ 0x0000002c) register DATA3 */
   __IM  uint32_t  RESERVED0[1012];  /*!< not covered by register fields! */
  __IOM  uint32_t  PSP_CTRL;  /*!< (@ 0x00001000) register PSP_CTRL */
  __IOM  uint32_t  TM1;  /*!< (@ 0x00001004) register TM1 */
  __IOM  uint32_t  TM2;  /*!< (@ 0x00001008) register TM2 */
   __IM  uint32_t  PSP_STATUS;  /*!< (@ 0x0000100c) register PSP_STATUS */
   __IM  uint32_t  REPAIR_INFO;  /*!< (@ 0x00001010) register REPAIR_INFO */
} FCTR_Type;     /*!< Size = 4116 (0x1014) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: FCACHE =============================================== */
/* =========================================================================================================================== */

/**
  * @brief FCACHE_Type peripheral FCACHE
  */
typedef struct {    /*!< (@ 0x50402000) FCACHE Structure */
  __IOM  uint32_t  CCR;  /*!< (@ 0x00000000) register CCR */
   __IM  uint32_t  SR;  /*!< (@ 0x00000004) register SR */
  __IOM  uint32_t  IRQMASK;  /*!< (@ 0x00000008) register IRQMASK */
  __IOM  uint32_t  IRQSTAT;  /*!< (@ 0x0000000c) register IRQSTAT */
   __IM  uint32_t  HWPARAMS;  /*!< (@ 0x00000010) register HWPARAMS */
  __IOM  uint32_t  CSHR;  /*!< (@ 0x00000014) register CSHR */
  __IOM  uint32_t  CSMR;  /*!< (@ 0x00000018) register CSMR */
} FCACHE_Type;     /*!< Size = 28 (0x1c) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: RWC ================================================= */
/* =========================================================================================================================== */

/**
  * @brief RWC_Type peripheral RWC
  */
typedef struct {    /*!< (@ 0x40403000) RWC Structure */
  __IOM  uint32_t  STR;  /*!< (@ 0x00000000) register STR */
  __IOM  uint32_t  RWDATA;  /*!< (@ 0x00000004) register RWDATA */
  __IOM  uint32_t  CTRL;  /*!< (@ 0x00000008) register CTRL */
  __IOM  uint32_t  INTCLR;  /*!< (@ 0x0000000c) register INTCLR */
  __IOM  uint32_t  INTEN;  /*!< (@ 0x00000010) register INTEN */
  __IOM  uint32_t  INTSTAT;  /*!< (@ 0x00000014) register INTSTAT */
} RWC_Type;     /*!< Size = 24 (0x18) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: JTM ================================================= */
/* =========================================================================================================================== */

/**
  * @brief JTM_Type peripheral JTM
  */
typedef struct {    /*!< (@ 0x40404000) JTM Structure */
  __IOM  uint32_t  CFG0;  /*!< (@ 0x00000000) register CFG0 */
  __IOM  uint32_t  CFG1;  /*!< (@ 0x00000004) register CFG1 */
  __IOM  uint32_t  CTR;  /*!< (@ 0x00000008) register CTR */
  __IOM  uint32_t  STAT;  /*!< (@ 0x0000000c) register STAT */
  __IOM  uint32_t  INTEN;  /*!< (@ 0x00000010) register INTEN */
  __IOM  uint32_t  INTSTAT;  /*!< (@ 0x00000014) register INTSTAT */
  __IOM  uint32_t  INTCLR;  /*!< (@ 0x00000018) register INTCLR */
} JTM_Type;     /*!< Size = 28 (0x1c) */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ========================================== Device Specific Peripheral Address Map ========================================= */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */
#define TIM_BASE 0x40000000UL /* peripheral TIM */
#define TIM0_BASE 0x40000000UL /* peripheral TIM0 */
#define TIM0_Secure_BASE 0x50000000UL /* peripheral TIM0_Secure */
#define TIM1_BASE 0x40001000UL /* peripheral TIM1 */
#define TIM1_Secure_BASE 0x50001000UL /* peripheral TIM1_Secure */
#define LPTIM_BASE 0x4002F000UL /* peripheral LPTIM */
#define LPTIM_Secure_BASE 0x5002F000UL /* peripheral LPTIM_Secure */
#define DTIM_BASE 0x40002000UL /* peripheral DTIM */
#define DTIM_Secure_BASE 0x50002000UL /* peripheral DTIM_Secure */
#define MHU_BASE 0x40003000UL /* peripheral MHU */
#define MHU0_BASE 0x40003000UL /* peripheral MHU0 */
#define MHU0_Secure_BASE 0x50003000UL /* peripheral MHU0_Secure */
#define MHU1_BASE 0x40004000UL /* peripheral MHU1 */
#define MHU1_Secure_BASE 0x50004000UL /* peripheral MHU1_Secure */
#define ICACHE_BASE 0x50010000UL /* peripheral ICACHE */
#define ICACHE_Secure_BASE 0x50010000UL /* peripheral ICACHE_Secure */
#define CPU_SECCTRL_BASE 0x50011000UL /* peripheral CPU_SECCTRL */
#define CPU_SECCTRL_Secure_BASE 0x50011000UL /* peripheral CPU_SECCTRL_Secure */
#define CPU_IDENTITY_BASE 0x4001F000UL /* peripheral CPU_IDENTITY */
#define CPU_IDENTITY_Secure_BASE 0x5001F000UL /* peripheral CPU_IDENTITY_Secure */
#define SYSINFO_BASE 0x40020000UL /* peripheral SYSINFO */
#define SYSINFO_Secure_BASE 0x50020000UL /* peripheral SYSINFO_Secure */
#define SYSCTR_BASE 0x50021000UL /* peripheral SYSCTR */
#define SYSCTR_Secure_BASE 0x50021000UL /* peripheral SYSCTR_Secure */
#define PPU_BASE 0x50022000UL /* peripheral PPU */
#define SYS_PPU_Secure_BASE 0x50022000UL /* peripheral SYS_PPU_Secure */
#define CPU0_PPU_Secure_BASE 0x50023000UL /* peripheral CPU0_PPU_Secure */
#define CPU1_PPU_Secure_BASE 0x50025000UL /* peripheral CPU1_PPU_Secure */
#define CRYPTO_PPU_Secure_BASE 0x50027000UL /* peripheral CRYPTO_PPU_Secure */
#define DEBUG_PPU_Secure_BASE 0x50029000UL /* peripheral DEBUG_PPU_Secure */
#define SRAM0_PPU_Secure_BASE 0x5002A000UL /* peripheral SRAM0_PPU_Secure */
#define SRAM1_PPU_Secure_BASE 0x5002B000UL /* peripheral SRAM1_PPU_Secure */
#define SRAM2_PPU_Secure_BASE 0x5002C000UL /* peripheral SRAM2_PPU_Secure */
#define SRAM3_PPU_Secure_BASE 0x5002D000UL /* peripheral SRAM3_PPU_Secure */
#define GMS_PPU_Secure_BASE 0x50034000UL /* peripheral GMS_PPU_Secure */
#define GNSS_PPU_Secure_BASE 0x50035000UL /* peripheral GNSS_PPU_Secure */
#define WDT_BASE 0x5002E000UL /* peripheral WDT */
#define LPWDT_Secure_BASE 0x5002E000UL /* peripheral LPWDT_Secure */
#define NSWDT_BASE 0x40081000UL /* peripheral NSWDT */
#define SWDT_Secure_BASE 0x50081000UL /* peripheral SWDT_Secure */
#define IOCTR_BASE 0x40030000UL /* peripheral IOCTR */
#define IOCTR_Secure_BASE 0x50030000UL /* peripheral IOCTR_Secure */
#define CLKCTR_BASE 0x40031000UL /* peripheral CLKCTR */
#define CLKCTR_Secure_BASE 0x50031000UL /* peripheral CLKCTR_Secure */
#define PWRCTR_BASE 0x40032000UL /* peripheral PWRCTR */
#define PWRCTR_Secure_BASE 0x50032000UL /* peripheral PWRCTR_Secure */
#define OTPCTR_BASE 0x50033000UL /* peripheral OTPCTR */
#define OTPCTR_Secure_BASE 0x50033000UL /* peripheral OTPCTR_Secure */
#define NSPCTR_BASE 0x40080000UL /* peripheral NSPCTR */
#define SPCTR_BASE 0x50080000UL /* peripheral SPCTR */
#define SPCTR_Secure_BASE 0x50080000UL /* peripheral SPCTR_Secure */
#define MPC_BASE 0x50083000UL /* peripheral MPC */
#define SRAM0_MPC_Secure_BASE 0x50083000UL /* peripheral SRAM0_MPC_Secure */
#define SRAM1_MPC_Secure_BASE 0x50084000UL /* peripheral SRAM1_MPC_Secure */
#define SRAM2_MPC_Secure_BASE 0x50085000UL /* peripheral SRAM2_MPC_Secure */
#define SRAM3_MPC_Secure_BASE 0x50086000UL /* peripheral SRAM3_MPC_Secure */
#define FLASH_MPC_Secure_BASE 0x5040C000UL /* peripheral FLASH_MPC_Secure */
#define QSPI_MPC_Secure_BASE 0x5040D000UL /* peripheral QSPI_MPC_Secure */
#define SMC_MPC_Secure_BASE 0x5040E000UL /* peripheral SMC_MPC_Secure */
#define BKP_MPC_Secure_BASE 0x5040F000UL /* peripheral BKP_MPC_Secure */
#define UART_BASE 0x40100000UL /* peripheral UART */
#define UART0_BASE 0x40100000UL /* peripheral UART0 */
#define UART0_Secure_BASE 0x50100000UL /* peripheral UART0_Secure */
#define UART1_BASE 0x40101000UL /* peripheral UART1 */
#define UART1_Secure_BASE 0x50101000UL /* peripheral UART1_Secure */
#define UART2_BASE 0x40102000UL /* peripheral UART2 */
#define UART2_Secure_BASE 0x50102000UL /* peripheral UART2_Secure */
#define UART3_BASE 0x40103000UL /* peripheral UART3 */
#define UART3_Secure_BASE 0x50103000UL /* peripheral UART3_Secure */
#define SPI_BASE 0x40104000UL /* peripheral SPI */
#define SPI0_BASE 0x40104000UL /* peripheral SPI0 */
#define SPI0_Secure_BASE 0x50104000UL /* peripheral SPI0_Secure */
#define SPI1_BASE 0x40105000UL /* peripheral SPI1 */
#define SPI1_Secure_BASE 0x50105000UL /* peripheral SPI1_Secure */
#define SPI2_BASE 0x40106000UL /* peripheral SPI2 */
#define SPI2_Secure_BASE 0x50106000UL /* peripheral SPI2_Secure */
#define I2C_BASE 0x40107000UL /* peripheral I2C */
#define I2C0_BASE 0x40107000UL /* peripheral I2C0 */
#define I2C0_Secure_BASE 0x50107000UL /* peripheral I2C0_Secure */
#define I2C1_BASE 0x40108000UL /* peripheral I2C1 */
#define I2C1_Secure_BASE 0x50108000UL /* peripheral I2C1_Secure */
#define I2S_BASE 0x40109000UL /* peripheral I2S */
#define I2S_Secure_BASE 0x50109000UL /* peripheral I2S_Secure */
#define GPIO_BASE 0x4010A000UL /* peripheral GPIO */
#define GPIO0_BASE 0x4010A000UL /* peripheral GPIO0 */
#define GPIO0_Secure_BASE 0x5010A000UL /* peripheral GPIO0_Secure */
#define GPIO1_BASE 0x4010B000UL /* peripheral GPIO1 */
#define GPIO1_Secure_BASE 0x5010B000UL /* peripheral GPIO1_Secure */
#define GPIO2_BASE 0x4010C000UL /* peripheral GPIO2 */
#define GPIO2_Secure_BASE 0x5010C000UL /* peripheral GPIO2_Secure */
#define GPIO3_BASE 0x4010D000UL /* peripheral GPIO3 */
#define GPIO3_Secure_BASE 0x5010D000UL /* peripheral GPIO3_Secure */
#define CAN_BASE 0x40110000UL /* peripheral CAN */
#define CAN_Secure_BASE 0x50110000UL /* peripheral CAN_Secure */
#define PWM_BASE 0x40111000UL /* peripheral PWM */
#define PWM_Secure_BASE 0x50111000UL /* peripheral PWM_Secure */
#define VTU_BASE 0x40112000UL /* peripheral VTU */
#define VTU0_BASE 0x40112000UL /* peripheral VTU0 */
#define VTU0_Secure_BASE 0x50112000UL /* peripheral VTU0_Secure */
#define VTU1_BASE 0x40113000UL /* peripheral VTU1 */
#define VTU1_Secure_BASE 0x50113000UL /* peripheral VTU1_Secure */
#define USB_BASE 0x40200000UL /* peripheral USB */
#define USB_Secure_BASE 0x50200000UL /* peripheral USB_Secure */
#define USB_URB_BASE 0x40240000UL /* peripheral USB_URB */
#define USB_URB_Secure_BASE 0x50240000UL /* peripheral USB_URB_Secure */
#define QSPI_BASE 0x40280000UL /* peripheral QSPI */
#define QSPI_Secure_BASE 0x50280000UL /* peripheral QSPI_Secure */
#define GNSS_BASE 0x40281000UL /* peripheral GNSS */
#define GNSS_Secure_BASE 0x50281000UL /* peripheral GNSS_Secure */
#define SMC_BASE 0x40282000UL /* peripheral SMC */
#define SMC_Secure_BASE 0x50282000UL /* peripheral SMC_Secure */
#define SDMMC_BASE 0x40284000UL /* peripheral SDMMC */
#define SDMMC_Secure_BASE 0x50284000UL /* peripheral SDMMC_Secure */
#define DMA_BASE 0x40285000UL /* peripheral DMA */
#define DMA0_BASE 0x40285000UL /* peripheral DMA0 */
#define DMA0_Secure_BASE 0x50285000UL /* peripheral DMA0_Secure */
#define DMA1_BASE 0x40286000UL /* peripheral DMA1 */
#define DMA1_Secure_BASE 0x50286000UL /* peripheral DMA1_Secure */
#define FCTR_BASE 0x50400000UL /* peripheral FCTR */
#define FCTR_Secure_BASE 0x50400000UL /* peripheral FCTR_Secure */
#define FCACHE_BASE 0x50402000UL /* peripheral FCACHE */
#define FCACHE_Secure_BASE 0x50402000UL /* peripheral FCACHE_Secure */
#define RWC_BASE 0x40403000UL /* peripheral RWC */
#define RWC_Secure_BASE 0x50403000UL /* peripheral RWC_Secure */
#define JTM_BASE 0x40404000UL /* peripheral JTM */
#define JTM_Secure_BASE 0x50404000UL /* peripheral JTM_Secure */
/** @} */ /* End of group Device_Peripheral_peripheralAddr */

/** @addtogroup Device_Peripheral_peripheralAddrArrays
  * @{
  */
#define DMA_BASE_ADDRS { DMA0_BASE, DMA1_BASE } 
#define DMA_BASE_ADDRS_COUNT 2 
#define DMA_SECURE_BASE_ADDRS { DMA0_Secure_BASE, DMA1_Secure_BASE } 
#define DMA_SECURE_BASE_ADDRS_COUNT 2 
#define GPIO_BASE_ADDRS { GPIO0_BASE, GPIO1_BASE, GPIO2_BASE, GPIO3_BASE } 
#define GPIO_BASE_ADDRS_COUNT 4 
#define GPIO_SECURE_BASE_ADDRS { GPIO0_Secure_BASE, GPIO1_Secure_BASE, GPIO2_Secure_BASE, GPIO3_Secure_BASE } 
#define GPIO_SECURE_BASE_ADDRS_COUNT 4 
#define I2C_BASE_ADDRS { I2C0_BASE, I2C1_BASE } 
#define I2C_BASE_ADDRS_COUNT 2 
#define I2C_SECURE_BASE_ADDRS { I2C0_Secure_BASE, I2C1_Secure_BASE } 
#define I2C_SECURE_BASE_ADDRS_COUNT 2 
#define MHU_BASE_ADDRS { MHU0_BASE, MHU1_BASE } 
#define MHU_BASE_ADDRS_COUNT 2 
#define MHU_SECURE_BASE_ADDRS { MHU0_Secure_BASE, MHU1_Secure_BASE } 
#define MHU_SECURE_BASE_ADDRS_COUNT 2 
#define SPI_BASE_ADDRS { SPI0_BASE, SPI1_BASE, SPI2_BASE } 
#define SPI_BASE_ADDRS_COUNT 3 
#define SPI_SECURE_BASE_ADDRS { SPI0_Secure_BASE, SPI1_Secure_BASE, SPI2_Secure_BASE } 
#define SPI_SECURE_BASE_ADDRS_COUNT 3 
#define TIM_BASE_ADDRS { TIM0_BASE, TIM1_BASE } 
#define TIM_BASE_ADDRS_COUNT 2 
#define TIM_SECURE_BASE_ADDRS { TIM0_Secure_BASE, TIM1_Secure_BASE } 
#define TIM_SECURE_BASE_ADDRS_COUNT 2 
#define UART_BASE_ADDRS { UART0_BASE, UART1_BASE, UART2_BASE, UART3_BASE } 
#define UART_BASE_ADDRS_COUNT 4 
#define UART_SECURE_BASE_ADDRS { UART0_Secure_BASE, UART1_Secure_BASE, UART2_Secure_BASE, UART3_Secure_BASE } 
#define UART_SECURE_BASE_ADDRS_COUNT 4 
#define VTU_BASE_ADDRS { VTU0_BASE, VTU1_BASE } 
#define VTU_BASE_ADDRS_COUNT 2 
#define VTU_SECURE_BASE_ADDRS { VTU0_Secure_BASE, VTU1_Secure_BASE } 
#define VTU_SECURE_BASE_ADDRS_COUNT 2 
/** @} */ /* End of group Device_Peripheral_peripheralAddrArrays */


/* =========================================================================================================================== */
/* ================================================== Peripheral declaration ================================================= */
/* =========================================================================================================================== */

/** @addtogroup Device_Peripheral_declaration
  * @{
  */
#define TIM ((TIM_Type*)TIM_BASE) /* peripheral TIM */
#define TIM0 ((TIM_Type*)TIM0_BASE) /* peripheral TIM0 */
#define TIM0_Secure ((TIM_Type*)TIM0_Secure_BASE) /* peripheral TIM0_Secure */
#define TIM1 ((TIM_Type*)TIM1_BASE) /* peripheral TIM1 */
#define TIM1_Secure ((TIM_Type*)TIM1_Secure_BASE) /* peripheral TIM1_Secure */
#define LPTIM ((TIM_Type*)LPTIM_BASE) /* peripheral LPTIM */
#define LPTIM_Secure ((TIM_Type*)LPTIM_Secure_BASE) /* peripheral LPTIM_Secure */
#define DTIM ((DTIM_Type*)DTIM_BASE) /* peripheral DTIM */
#define DTIM_Secure ((DTIM_Type*)DTIM_Secure_BASE) /* peripheral DTIM_Secure */
#define MHU ((MHU_Type*)MHU_BASE) /* peripheral MHU */
#define MHU0 ((MHU_Type*)MHU0_BASE) /* peripheral MHU0 */
#define MHU0_Secure ((MHU_Type*)MHU0_Secure_BASE) /* peripheral MHU0_Secure */
#define MHU1 ((MHU_Type*)MHU1_BASE) /* peripheral MHU1 */
#define MHU1_Secure ((MHU_Type*)MHU1_Secure_BASE) /* peripheral MHU1_Secure */
#define ICACHE ((ICACHE_Type*)ICACHE_BASE) /* peripheral ICACHE */
#define ICACHE_Secure ((ICACHE_Type*)ICACHE_Secure_BASE) /* peripheral ICACHE_Secure */
#define CPU_SECCTRL ((CPU_SECCTRL_Type*)CPU_SECCTRL_BASE) /* peripheral CPU_SECCTRL */
#define CPU_SECCTRL_Secure ((CPU_SECCTRL_Type*)CPU_SECCTRL_Secure_BASE) /* peripheral CPU_SECCTRL_Secure */
#define CPU_IDENTITY ((CPU_IDENTITY_Type*)CPU_IDENTITY_BASE) /* peripheral CPU_IDENTITY */
#define CPU_IDENTITY_Secure ((CPU_IDENTITY_Type*)CPU_IDENTITY_Secure_BASE) /* peripheral CPU_IDENTITY_Secure */
#define SYSINFO ((SYSINFO_Type*)SYSINFO_BASE) /* peripheral SYSINFO */
#define SYSINFO_Secure ((SYSINFO_Type*)SYSINFO_Secure_BASE) /* peripheral SYSINFO_Secure */
#define SYSCTR ((SYSCTR_Type*)SYSCTR_BASE) /* peripheral SYSCTR */
#define SYSCTR_Secure ((SYSCTR_Type*)SYSCTR_Secure_BASE) /* peripheral SYSCTR_Secure */
#define PPU ((PPU_Type*)PPU_BASE) /* peripheral PPU */
#define SYS_PPU_Secure ((PPU_Type*)SYS_PPU_Secure_BASE) /* peripheral SYS_PPU_Secure */
#define CPU0_PPU_Secure ((PPU_Type*)CPU0_PPU_Secure_BASE) /* peripheral CPU0_PPU_Secure */
#define CPU1_PPU_Secure ((PPU_Type*)CPU1_PPU_Secure_BASE) /* peripheral CPU1_PPU_Secure */
#define CRYPTO_PPU_Secure ((PPU_Type*)CRYPTO_PPU_Secure_BASE) /* peripheral CRYPTO_PPU_Secure */
#define DEBUG_PPU_Secure ((PPU_Type*)DEBUG_PPU_Secure_BASE) /* peripheral DEBUG_PPU_Secure */
#define SRAM0_PPU_Secure ((PPU_Type*)SRAM0_PPU_Secure_BASE) /* peripheral SRAM0_PPU_Secure */
#define SRAM1_PPU_Secure ((PPU_Type*)SRAM1_PPU_Secure_BASE) /* peripheral SRAM1_PPU_Secure */
#define SRAM2_PPU_Secure ((PPU_Type*)SRAM2_PPU_Secure_BASE) /* peripheral SRAM2_PPU_Secure */
#define SRAM3_PPU_Secure ((PPU_Type*)SRAM3_PPU_Secure_BASE) /* peripheral SRAM3_PPU_Secure */
#define GMS_PPU_Secure ((PPU_Type*)GMS_PPU_Secure_BASE) /* peripheral GMS_PPU_Secure */
#define GNSS_PPU_Secure ((PPU_Type*)GNSS_PPU_Secure_BASE) /* peripheral GNSS_PPU_Secure */
#define WDT ((WDT_Type*)WDT_BASE) /* peripheral WDT */
#define LPWDT_Secure ((WDT_Type*)LPWDT_Secure_BASE) /* peripheral LPWDT_Secure */
#define NSWDT ((WDT_Type*)NSWDT_BASE) /* peripheral NSWDT */
#define SWDT_Secure ((WDT_Type*)SWDT_Secure_BASE) /* peripheral SWDT_Secure */
#define IOCTR ((IOCTR_Type*)IOCTR_BASE) /* peripheral IOCTR */
#define IOCTR_Secure ((IOCTR_Type*)IOCTR_Secure_BASE) /* peripheral IOCTR_Secure */
#define CLKCTR ((CLKCTR_Type*)CLKCTR_BASE) /* peripheral CLKCTR */
#define CLKCTR_Secure ((CLKCTR_Type*)CLKCTR_Secure_BASE) /* peripheral CLKCTR_Secure */
#define PWRCTR ((PWRCTR_Type*)PWRCTR_BASE) /* peripheral PWRCTR */
#define PWRCTR_Secure ((PWRCTR_Type*)PWRCTR_Secure_BASE) /* peripheral PWRCTR_Secure */
#define OTPCTR ((OTPCTR_Type*)OTPCTR_BASE) /* peripheral OTPCTR */
#define OTPCTR_Secure ((OTPCTR_Type*)OTPCTR_Secure_BASE) /* peripheral OTPCTR_Secure */
#define NSPCTR ((NSPCTR_Type*)NSPCTR_BASE) /* peripheral NSPCTR */
#define SPCTR ((SPCTR_Type*)SPCTR_BASE) /* peripheral SPCTR */
#define SPCTR_Secure ((SPCTR_Type*)SPCTR_Secure_BASE) /* peripheral SPCTR_Secure */
#define MPC ((MPC_Type*)MPC_BASE) /* peripheral MPC */
#define SRAM0_MPC_Secure ((MPC_Type*)SRAM0_MPC_Secure_BASE) /* peripheral SRAM0_MPC_Secure */
#define SRAM1_MPC_Secure ((MPC_Type*)SRAM1_MPC_Secure_BASE) /* peripheral SRAM1_MPC_Secure */
#define SRAM2_MPC_Secure ((MPC_Type*)SRAM2_MPC_Secure_BASE) /* peripheral SRAM2_MPC_Secure */
#define SRAM3_MPC_Secure ((MPC_Type*)SRAM3_MPC_Secure_BASE) /* peripheral SRAM3_MPC_Secure */
#define FLASH_MPC_Secure ((MPC_Type*)FLASH_MPC_Secure_BASE) /* peripheral FLASH_MPC_Secure */
#define QSPI_MPC_Secure ((MPC_Type*)QSPI_MPC_Secure_BASE) /* peripheral QSPI_MPC_Secure */
#define SMC_MPC_Secure ((MPC_Type*)SMC_MPC_Secure_BASE) /* peripheral SMC_MPC_Secure */
#define BKP_MPC_Secure ((MPC_Type*)BKP_MPC_Secure_BASE) /* peripheral BKP_MPC_Secure */
#define UART ((UART_Type*)UART_BASE) /* peripheral UART */
#define UART0 ((UART_Type*)UART0_BASE) /* peripheral UART0 */
#define UART0_Secure ((UART_Type*)UART0_Secure_BASE) /* peripheral UART0_Secure */
#define UART1 ((UART_Type*)UART1_BASE) /* peripheral UART1 */
#define UART1_Secure ((UART_Type*)UART1_Secure_BASE) /* peripheral UART1_Secure */
#define UART2 ((UART_Type*)UART2_BASE) /* peripheral UART2 */
#define UART2_Secure ((UART_Type*)UART2_Secure_BASE) /* peripheral UART2_Secure */
#define UART3 ((UART_Type*)UART3_BASE) /* peripheral UART3 */
#define UART3_Secure ((UART_Type*)UART3_Secure_BASE) /* peripheral UART3_Secure */
#define SPI ((SPI_Type*)SPI_BASE) /* peripheral SPI */
#define SPI0 ((SPI_Type*)SPI0_BASE) /* peripheral SPI0 */
#define SPI0_Secure ((SPI_Type*)SPI0_Secure_BASE) /* peripheral SPI0_Secure */
#define SPI1 ((SPI_Type*)SPI1_BASE) /* peripheral SPI1 */
#define SPI1_Secure ((SPI_Type*)SPI1_Secure_BASE) /* peripheral SPI1_Secure */
#define SPI2 ((SPI_Type*)SPI2_BASE) /* peripheral SPI2 */
#define SPI2_Secure ((SPI_Type*)SPI2_Secure_BASE) /* peripheral SPI2_Secure */
#define I2C ((I2C_Type*)I2C_BASE) /* peripheral I2C */
#define I2C0 ((I2C_Type*)I2C0_BASE) /* peripheral I2C0 */
#define I2C0_Secure ((I2C_Type*)I2C0_Secure_BASE) /* peripheral I2C0_Secure */
#define I2C1 ((I2C_Type*)I2C1_BASE) /* peripheral I2C1 */
#define I2C1_Secure ((I2C_Type*)I2C1_Secure_BASE) /* peripheral I2C1_Secure */
#define I2S ((I2S_Type*)I2S_BASE) /* peripheral I2S */
#define I2S_Secure ((I2S_Type*)I2S_Secure_BASE) /* peripheral I2S_Secure */
#define GPIO ((GPIO_Type*)GPIO_BASE) /* peripheral GPIO */
#define GPIO0 ((GPIO_Type*)GPIO0_BASE) /* peripheral GPIO0 */
#define GPIO0_Secure ((GPIO_Type*)GPIO0_Secure_BASE) /* peripheral GPIO0_Secure */
#define GPIO1 ((GPIO_Type*)GPIO1_BASE) /* peripheral GPIO1 */
#define GPIO1_Secure ((GPIO_Type*)GPIO1_Secure_BASE) /* peripheral GPIO1_Secure */
#define GPIO2 ((GPIO_Type*)GPIO2_BASE) /* peripheral GPIO2 */
#define GPIO2_Secure ((GPIO_Type*)GPIO2_Secure_BASE) /* peripheral GPIO2_Secure */
#define GPIO3 ((GPIO_Type*)GPIO3_BASE) /* peripheral GPIO3 */
#define GPIO3_Secure ((GPIO_Type*)GPIO3_Secure_BASE) /* peripheral GPIO3_Secure */
#define CAN ((CAN_Type*)CAN_BASE) /* peripheral CAN */
#define CAN_Secure ((CAN_Type*)CAN_Secure_BASE) /* peripheral CAN_Secure */
#define PWM ((PWM_Type*)PWM_BASE) /* peripheral PWM */
#define PWM_Secure ((PWM_Type*)PWM_Secure_BASE) /* peripheral PWM_Secure */
#define VTU ((VTU_Type*)VTU_BASE) /* peripheral VTU */
#define VTU0 ((VTU_Type*)VTU0_BASE) /* peripheral VTU0 */
#define VTU0_Secure ((VTU_Type*)VTU0_Secure_BASE) /* peripheral VTU0_Secure */
#define VTU1 ((VTU_Type*)VTU1_BASE) /* peripheral VTU1 */
#define VTU1_Secure ((VTU_Type*)VTU1_Secure_BASE) /* peripheral VTU1_Secure */
#define USB ((USB_Type*)USB_BASE) /* peripheral USB */
#define USB_Secure ((USB_Type*)USB_Secure_BASE) /* peripheral USB_Secure */
#define USB_URB ((USB_URB_Type*)USB_URB_BASE) /* peripheral USB_URB */
#define USB_URB_Secure ((USB_URB_Type*)USB_URB_Secure_BASE) /* peripheral USB_URB_Secure */
#define QSPI ((QSPI_Type*)QSPI_BASE) /* peripheral QSPI */
#define QSPI_Secure ((QSPI_Type*)QSPI_Secure_BASE) /* peripheral QSPI_Secure */
#define GNSS ((GNSS_Type*)GNSS_BASE) /* peripheral GNSS */
#define GNSS_Secure ((GNSS_Type*)GNSS_Secure_BASE) /* peripheral GNSS_Secure */
#define SMC ((SMC_Type*)SMC_BASE) /* peripheral SMC */
#define SMC_Secure ((SMC_Type*)SMC_Secure_BASE) /* peripheral SMC_Secure */
#define SDMMC ((SDMMC_Type*)SDMMC_BASE) /* peripheral SDMMC */
#define SDMMC_Secure ((SDMMC_Type*)SDMMC_Secure_BASE) /* peripheral SDMMC_Secure */
#define DMA ((DMA_Type*)DMA_BASE) /* peripheral DMA */
#define DMA0 ((DMA_Type*)DMA0_BASE) /* peripheral DMA0 */
#define DMA0_Secure ((DMA_Type*)DMA0_Secure_BASE) /* peripheral DMA0_Secure */
#define DMA1 ((DMA_Type*)DMA1_BASE) /* peripheral DMA1 */
#define DMA1_Secure ((DMA_Type*)DMA1_Secure_BASE) /* peripheral DMA1_Secure */
#define FCTR ((FCTR_Type*)FCTR_BASE) /* peripheral FCTR */
#define FCTR_Secure ((FCTR_Type*)FCTR_Secure_BASE) /* peripheral FCTR_Secure */
#define FCACHE ((FCACHE_Type*)FCACHE_BASE) /* peripheral FCACHE */
#define FCACHE_Secure ((FCACHE_Type*)FCACHE_Secure_BASE) /* peripheral FCACHE_Secure */
#define RWC ((RWC_Type*)RWC_BASE) /* peripheral RWC */
#define RWC_Secure ((RWC_Type*)RWC_Secure_BASE) /* peripheral RWC_Secure */
#define JTM ((JTM_Type*)JTM_BASE) /* peripheral JTM */
#define JTM_Secure ((JTM_Type*)JTM_Secure_BASE) /* peripheral JTM_Secure */
/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif



/* =========================================================================================================================== */
/* ================================================= Pos/Mask Cluster Section ================================================ */
/* =========================================================================================================================== */

/** @addtogroup PosMask_clusters
  * @{
  */

/* =========================================================================================================================== */
/* ================================================= Type of peripheral: TIM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DTIM ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MHU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: ICACHE =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_SECCTRL ============================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_IDENTITY ============================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: SYSINFO =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SYSCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PPU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: WDT ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: IOCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: CLKCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: PWRCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: OTPCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: NSPCTR =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SPCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MPC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: UART ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SPI ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2C ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2S ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GPIO ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: CAN ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PWM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: VTU ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: USB ================================================= */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ================ USB_INEndpoint_Type: cluster is artificially generated from registers of peripheral 'USB' ================ */
/* =========================================================================================================================== */

/* ==================================================== Register DIEPCTL1 ==================================================== */
#define USB_INENDPOINT_DIEPCTL_MPS_Pos (0UL) /*!< field MPS (bitOffset 0, bitWidth 11) */
#define USB_INENDPOINT_DIEPCTL_MPS_Msk (0x000007ffUL) /*!< field MPS (Bitfield-Mask: 0x000007ff) */
#define USB_INENDPOINT_DIEPCTL_USBACTEP_Pos (15UL) /*!< field USBACTEP (bitOffset 15, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_USBACTEP_Msk (0x00008000UL) /*!< field USBACTEP (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_DPID_Pos (16UL) /*!< field DPID (bitOffset 16, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_DPID_Msk (0x00010000UL) /*!< field DPID (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_NAKSTS_Pos (17UL) /*!< field NAKSTS (bitOffset 17, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_NAKSTS_Msk (0x00020000UL) /*!< field NAKSTS (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_EPTYPE_Pos (18UL) /*!< field EPTYPE (bitOffset 18, bitWidth 2) */
#define USB_INENDPOINT_DIEPCTL_EPTYPE_Msk (0x000c0000UL) /*!< field EPTYPE (Bitfield-Mask: 0x00000003) */
#define USB_INENDPOINT_DIEPCTL_STALL_Pos (21UL) /*!< field STALL (bitOffset 21, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_STALL_Msk (0x00200000UL) /*!< field STALL (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_TXFNUM_Pos (22UL) /*!< field TXFNUM (bitOffset 22, bitWidth 4) */
#define USB_INENDPOINT_DIEPCTL_TXFNUM_Msk (0x03c00000UL) /*!< field TXFNUM (Bitfield-Mask: 0x0000000f) */
#define USB_INENDPOINT_DIEPCTL_CNAK_Pos (26UL) /*!< field CNAK (bitOffset 26, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_CNAK_Msk (0x04000000UL) /*!< field CNAK (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_SNAK_Pos (27UL) /*!< field SNAK (bitOffset 27, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_SNAK_Msk (0x08000000UL) /*!< field SNAK (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_SETD0PID_Pos (28UL) /*!< field SETD0PID (bitOffset 28, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_SETD0PID_Msk (0x10000000UL) /*!< field SETD0PID (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_SETD1PID_Pos (29UL) /*!< field SETD1PID (bitOffset 29, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_SETD1PID_Msk (0x20000000UL) /*!< field SETD1PID (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_EPDIS_Pos (30UL) /*!< field EPDIS (bitOffset 30, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_EPDIS_Msk (0x40000000UL) /*!< field EPDIS (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPCTL_EPENA_Pos (31UL) /*!< field EPENA (bitOffset 31, bitWidth 1) */
#define USB_INENDPOINT_DIEPCTL_EPENA_Msk (0x80000000UL) /*!< field EPENA (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register DIEPINT1 ==================================================== */
#define USB_INENDPOINT_DIEPINT_XFERCOMPL_Pos (0UL) /*!< field XFERCOMPL (bitOffset 0, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_XFERCOMPL_Msk (0x00000001UL) /*!< field XFERCOMPL (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_EPDISBLD_Pos (1UL) /*!< field EPDISBLD (bitOffset 1, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_EPDISBLD_Msk (0x00000002UL) /*!< field EPDISBLD (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_AHBERR_Pos (2UL) /*!< field AHBERR (bitOffset 2, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_AHBERR_Msk (0x00000004UL) /*!< field AHBERR (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_TIMEOUT_Pos (3UL) /*!< field TIMEOUT (bitOffset 3, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_TIMEOUT_Msk (0x00000008UL) /*!< field TIMEOUT (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_INTKNTXFEMP_Pos (4UL) /*!< field INTKNTXFEMP (bitOffset 4, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_INTKNTXFEMP_Msk (0x00000010UL) /*!< field INTKNTXFEMP (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_INTKNEPMIS_Pos (5UL) /*!< field INTKNEPMIS (bitOffset 5, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_INTKNEPMIS_Msk (0x00000020UL) /*!< field INTKNEPMIS (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_INEPNAKEFF_Pos (6UL) /*!< field INEPNAKEFF (bitOffset 6, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_INEPNAKEFF_Msk (0x00000040UL) /*!< field INEPNAKEFF (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_TXFEMP_Pos (7UL) /*!< field TXFEMP (bitOffset 7, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_TXFEMP_Msk (0x00000080UL) /*!< field TXFEMP (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_TXFIFOUNDRN_Pos (8UL) /*!< field TXFIFOUNDRN (bitOffset 8, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_TXFIFOUNDRN_Msk (0x00000100UL) /*!< field TXFIFOUNDRN (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_BNAINTR_Pos (9UL) /*!< field BNAINTR (bitOffset 9, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_BNAINTR_Msk (0x00000200UL) /*!< field BNAINTR (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_PKTDRPSTS_Pos (11UL) /*!< field PKTDRPSTS (bitOffset 11, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_PKTDRPSTS_Msk (0x00000800UL) /*!< field PKTDRPSTS (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_BBLEERR_Pos (12UL) /*!< field BBLEERR (bitOffset 12, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_BBLEERR_Msk (0x00001000UL) /*!< field BBLEERR (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_NAKINTRPT_Pos (13UL) /*!< field NAKINTRPT (bitOffset 13, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_NAKINTRPT_Msk (0x00002000UL) /*!< field NAKINTRPT (Bitfield-Mask: 0x00000001) */
#define USB_INENDPOINT_DIEPINT_NYETINTRPT_Pos (14UL) /*!< field NYETINTRPT (bitOffset 14, bitWidth 1) */
#define USB_INENDPOINT_DIEPINT_NYETINTRPT_Msk (0x00004000UL) /*!< field NYETINTRPT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register DIEPTSIZ1 =================================================== */
#define USB_INENDPOINT_DIEPTSIZ_XFERSIZE_Pos (0UL) /*!< field XFERSIZE (bitOffset 0, bitWidth 19) */
#define USB_INENDPOINT_DIEPTSIZ_XFERSIZE_Msk (0x0007ffffUL) /*!< field XFERSIZE (Bitfield-Mask: 0x0007ffff) */
#define USB_INENDPOINT_DIEPTSIZ_PKTCNT_Pos (19UL) /*!< field PKTCNT (bitOffset 19, bitWidth 10) */
#define USB_INENDPOINT_DIEPTSIZ_PKTCNT_Msk (0x1ff80000UL) /*!< field PKTCNT (Bitfield-Mask: 0x000003ff) */
#define USB_INENDPOINT_DIEPTSIZ_MC_Pos (29UL) /*!< field MC (bitOffset 29, bitWidth 2) */
#define USB_INENDPOINT_DIEPTSIZ_MC_Msk (0x60000000UL) /*!< field MC (Bitfield-Mask: 0x00000003) */

/* ==================================================== Register DIEPDMA1 ==================================================== */
#define USB_INENDPOINT_DIEPDMA_DMAADDR_Pos (0UL) /*!< field DMAADDR (bitOffset 0, bitWidth 32) */
#define USB_INENDPOINT_DIEPDMA_DMAADDR_Msk (0xffffffffUL) /*!< field DMAADDR (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register DTXFSTS1 ==================================================== */
#define USB_INENDPOINT_DTXFSTS_INEPTXFSPCAVAIL_Pos (0UL) /*!< field INEPTXFSPCAVAIL (bitOffset 0, bitWidth 16) */
#define USB_INENDPOINT_DTXFSTS_INEPTXFSPCAVAIL_Msk (0x0000ffffUL) /*!< field INEPTXFSPCAVAIL (Bitfield-Mask: 0x0000ffff) */

/* ==================================================== Register DIEPDMAB1 =================================================== */
#define USB_INENDPOINT_DIEPDMAB_DMABUFFERADDR_Pos (0UL) /*!< field DMABUFFERADDR (bitOffset 0, bitWidth 32) */
#define USB_INENDPOINT_DIEPDMAB_DMABUFFERADDR_Msk (0xffffffffUL) /*!< field DMABUFFERADDR (Bitfield-Mask: 0xffffffff) */

/* =========================================================================================================================== */
/* ================ USB_OUTEndpoint_Type: cluster is artificially generated from registers of peripheral 'USB' =============== */
/* =========================================================================================================================== */

/* ==================================================== Register DOEPCTL1 ==================================================== */
#define USB_OUTENDPOINT_DOEPCTL_MPS_Pos (0UL) /*!< field MPS (bitOffset 0, bitWidth 11) */
#define USB_OUTENDPOINT_DOEPCTL_MPS_Msk (0x000007ffUL) /*!< field MPS (Bitfield-Mask: 0x000007ff) */
#define USB_OUTENDPOINT_DOEPCTL_USBACTEP_Pos (15UL) /*!< field USBACTEP (bitOffset 15, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_USBACTEP_Msk (0x00008000UL) /*!< field USBACTEP (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_DPID_Pos (16UL) /*!< field DPID (bitOffset 16, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_DPID_Msk (0x00010000UL) /*!< field DPID (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_NAKSTS_Pos (17UL) /*!< field NAKSTS (bitOffset 17, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_NAKSTS_Msk (0x00020000UL) /*!< field NAKSTS (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_EPTYPE_Pos (18UL) /*!< field EPTYPE (bitOffset 18, bitWidth 2) */
#define USB_OUTENDPOINT_DOEPCTL_EPTYPE_Msk (0x000c0000UL) /*!< field EPTYPE (Bitfield-Mask: 0x00000003) */
#define USB_OUTENDPOINT_DOEPCTL_SNP_Pos (20UL) /*!< field SNP (bitOffset 20, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_SNP_Msk (0x00100000UL) /*!< field SNP (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_STALL_Pos (21UL) /*!< field STALL (bitOffset 21, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_STALL_Msk (0x00200000UL) /*!< field STALL (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_CNAK_Pos (26UL) /*!< field CNAK (bitOffset 26, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_CNAK_Msk (0x04000000UL) /*!< field CNAK (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_SNAK_Pos (27UL) /*!< field SNAK (bitOffset 27, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_SNAK_Msk (0x08000000UL) /*!< field SNAK (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_SETD0PID_Pos (28UL) /*!< field SETD0PID (bitOffset 28, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_SETD0PID_Msk (0x10000000UL) /*!< field SETD0PID (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_SETD1PID_Pos (29UL) /*!< field SETD1PID (bitOffset 29, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_SETD1PID_Msk (0x20000000UL) /*!< field SETD1PID (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_EPDIS_Pos (30UL) /*!< field EPDIS (bitOffset 30, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_EPDIS_Msk (0x40000000UL) /*!< field EPDIS (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPCTL_EPENA_Pos (31UL) /*!< field EPENA (bitOffset 31, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPCTL_EPENA_Msk (0x80000000UL) /*!< field EPENA (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register DOEPINT1 ==================================================== */
#define USB_OUTENDPOINT_DOEPINT_XFERCOMPL_Pos (0UL) /*!< field XFERCOMPL (bitOffset 0, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_XFERCOMPL_Msk (0x00000001UL) /*!< field XFERCOMPL (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_EPDISBLD_Pos (1UL) /*!< field EPDISBLD (bitOffset 1, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_EPDISBLD_Msk (0x00000002UL) /*!< field EPDISBLD (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_AHBERR_Pos (2UL) /*!< field AHBERR (bitOffset 2, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_AHBERR_Msk (0x00000004UL) /*!< field AHBERR (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_SETUP_Pos (3UL) /*!< field SETUP (bitOffset 3, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_SETUP_Msk (0x00000008UL) /*!< field SETUP (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_OUTTKNEPDIS_Pos (4UL) /*!< field OUTTKNEPDIS (bitOffset 4, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_OUTTKNEPDIS_Msk (0x00000010UL) /*!< field OUTTKNEPDIS (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_STSPHSERCVD_Pos (5UL) /*!< field STSPHSERCVD (bitOffset 5, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_STSPHSERCVD_Msk (0x00000020UL) /*!< field STSPHSERCVD (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_BACK2BACKSETUP_Pos (6UL) /*!< field BACK2BACKSETUP (bitOffset 6, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_BACK2BACKSETUP_Msk (0x00000040UL) /*!< field BACK2BACKSETUP (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_OUTPKTERR_Pos (8UL) /*!< field OUTPKTERR (bitOffset 8, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_OUTPKTERR_Msk (0x00000100UL) /*!< field OUTPKTERR (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_BNAINTR_Pos (9UL) /*!< field BNAINTR (bitOffset 9, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_BNAINTR_Msk (0x00000200UL) /*!< field BNAINTR (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_PKTDRPSTS_Pos (11UL) /*!< field PKTDRPSTS (bitOffset 11, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_PKTDRPSTS_Msk (0x00000800UL) /*!< field PKTDRPSTS (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_BBLEERR_Pos (12UL) /*!< field BBLEERR (bitOffset 12, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_BBLEERR_Msk (0x00001000UL) /*!< field BBLEERR (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_NAKINTRPT_Pos (13UL) /*!< field NAKINTRPT (bitOffset 13, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_NAKINTRPT_Msk (0x00002000UL) /*!< field NAKINTRPT (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_NYETINTRPT_Pos (14UL) /*!< field NYETINTRPT (bitOffset 14, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_NYETINTRPT_Msk (0x00004000UL) /*!< field NYETINTRPT (Bitfield-Mask: 0x00000001) */
#define USB_OUTENDPOINT_DOEPINT_STUPPKTRCVD_Pos (15UL) /*!< field STUPPKTRCVD (bitOffset 15, bitWidth 1) */
#define USB_OUTENDPOINT_DOEPINT_STUPPKTRCVD_Msk (0x00008000UL) /*!< field STUPPKTRCVD (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register DOEPTSIZ1 =================================================== */
#define USB_OUTENDPOINT_DOEPTSIZ_XFERSIZE_Pos (0UL) /*!< field XFERSIZE (bitOffset 0, bitWidth 19) */
#define USB_OUTENDPOINT_DOEPTSIZ_XFERSIZE_Msk (0x0007ffffUL) /*!< field XFERSIZE (Bitfield-Mask: 0x0007ffff) */
#define USB_OUTENDPOINT_DOEPTSIZ_PKTCNT_Pos (19UL) /*!< field PKTCNT (bitOffset 19, bitWidth 10) */
#define USB_OUTENDPOINT_DOEPTSIZ_PKTCNT_Msk (0x1ff80000UL) /*!< field PKTCNT (Bitfield-Mask: 0x000003ff) */
#define USB_OUTENDPOINT_DOEPTSIZ_RXDPID_Pos (29UL) /*!< field RXDPID (bitOffset 29, bitWidth 2) */
#define USB_OUTENDPOINT_DOEPTSIZ_RXDPID_Msk (0x60000000UL) /*!< field RXDPID (Bitfield-Mask: 0x00000003) */

/* ==================================================== Register DOEPDMA1 ==================================================== */
#define USB_OUTENDPOINT_DOEPDMA_DMAADDR_Pos (0UL) /*!< field DMAADDR (bitOffset 0, bitWidth 32) */
#define USB_OUTENDPOINT_DOEPDMA_DMAADDR_Msk (0xffffffffUL) /*!< field DMAADDR (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register DOEPDMAB1 =================================================== */
#define USB_OUTENDPOINT_DOEPDMAB_DMABUFFERADDR_Pos (0UL) /*!< field DMABUFFERADDR (bitOffset 0, bitWidth 32) */
#define USB_OUTENDPOINT_DOEPDMAB_DMABUFFERADDR_Msk (0xffffffffUL) /*!< field DMABUFFERADDR (Bitfield-Mask: 0xffffffff) */

/* =========================================================================================================================== */
/* ================== USB_DIEPTXF_Type: cluster is artificially generated from registers of peripheral 'USB' ================= */
/* =========================================================================================================================== */

/* ==================================================== Register DIEPTXF1 ==================================================== */
#define USB_DIEPTXF_DIEPTXF_INEPNTXFSTADDR_Pos (0UL) /*!< field INEPNTXFSTADDR (bitOffset 0, bitWidth 10) */
#define USB_DIEPTXF_DIEPTXF_INEPNTXFSTADDR_Msk (0x000003ffUL) /*!< field INEPNTXFSTADDR (Bitfield-Mask: 0x000003ff) */
#define USB_DIEPTXF_DIEPTXF_INEPNTXFDEP_Pos (16UL) /*!< field INEPNTXFDEP (bitOffset 16, bitWidth 9) */
#define USB_DIEPTXF_DIEPTXF_INEPNTXFDEP_Msk (0x01ff0000UL) /*!< field INEPNTXFDEP (Bitfield-Mask: 0x000001ff) */

/* =========================================================================================================================== */
/* ================= USB_HostChan_Type: cluster is artificially generated from registers of peripheral 'USB' ================= */
/* =========================================================================================================================== */

/* ===================================================== Register HCCHAR0 ==================================================== */
#define USB_HOSTCHAN_HCCHAR_MPS_Pos (0UL) /*!< field MPS (bitOffset 0, bitWidth 11) */
#define USB_HOSTCHAN_HCCHAR_MPS_Msk (0x000007ffUL) /*!< field MPS (Bitfield-Mask: 0x000007ff) */
#define USB_HOSTCHAN_HCCHAR_EPNUM_Pos (11UL) /*!< field EPNUM (bitOffset 11, bitWidth 4) */
#define USB_HOSTCHAN_HCCHAR_EPNUM_Msk (0x00007800UL) /*!< field EPNUM (Bitfield-Mask: 0x0000000f) */
#define USB_HOSTCHAN_HCCHAR_EPDIR_Pos (15UL) /*!< field EPDIR (bitOffset 15, bitWidth 1) */
#define USB_HOSTCHAN_HCCHAR_EPDIR_Msk (0x00008000UL) /*!< field EPDIR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCCHAR_LSPDDEV_Pos (17UL) /*!< field LSPDDEV (bitOffset 17, bitWidth 1) */
#define USB_HOSTCHAN_HCCHAR_LSPDDEV_Msk (0x00020000UL) /*!< field LSPDDEV (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCCHAR_EPTYPE_Pos (18UL) /*!< field EPTYPE (bitOffset 18, bitWidth 2) */
#define USB_HOSTCHAN_HCCHAR_EPTYPE_Msk (0x000c0000UL) /*!< field EPTYPE (Bitfield-Mask: 0x00000003) */
#define USB_HOSTCHAN_HCCHAR_EC_Pos (20UL) /*!< field EC (bitOffset 20, bitWidth 2) */
#define USB_HOSTCHAN_HCCHAR_EC_Msk (0x00300000UL) /*!< field EC (Bitfield-Mask: 0x00000003) */
#define USB_HOSTCHAN_HCCHAR_DEVADDR_Pos (22UL) /*!< field DEVADDR (bitOffset 22, bitWidth 7) */
#define USB_HOSTCHAN_HCCHAR_DEVADDR_Msk (0x1fc00000UL) /*!< field DEVADDR (Bitfield-Mask: 0x0000007f) */
#define USB_HOSTCHAN_HCCHAR_ODDFRM_Pos (29UL) /*!< field ODDFRM (bitOffset 29, bitWidth 1) */
#define USB_HOSTCHAN_HCCHAR_ODDFRM_Msk (0x20000000UL) /*!< field ODDFRM (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCCHAR_CHDIS_Pos (30UL) /*!< field CHDIS (bitOffset 30, bitWidth 1) */
#define USB_HOSTCHAN_HCCHAR_CHDIS_Msk (0x40000000UL) /*!< field CHDIS (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCCHAR_CHENA_Pos (31UL) /*!< field CHENA (bitOffset 31, bitWidth 1) */
#define USB_HOSTCHAN_HCCHAR_CHENA_Msk (0x80000000UL) /*!< field CHENA (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register HCSPLT0 ==================================================== */
#define USB_HOSTCHAN_HCSPLT_PRTADDR_Pos (0UL) /*!< field PRTADDR (bitOffset 0, bitWidth 7) */
#define USB_HOSTCHAN_HCSPLT_PRTADDR_Msk (0x0000007fUL) /*!< field PRTADDR (Bitfield-Mask: 0x0000007f) */
#define USB_HOSTCHAN_HCSPLT_HUBADDR_Pos (7UL) /*!< field HUBADDR (bitOffset 7, bitWidth 7) */
#define USB_HOSTCHAN_HCSPLT_HUBADDR_Msk (0x00003f80UL) /*!< field HUBADDR (Bitfield-Mask: 0x0000007f) */
#define USB_HOSTCHAN_HCSPLT_XACTPOS_Pos (14UL) /*!< field XACTPOS (bitOffset 14, bitWidth 2) */
#define USB_HOSTCHAN_HCSPLT_XACTPOS_Msk (0x0000c000UL) /*!< field XACTPOS (Bitfield-Mask: 0x00000003) */
#define USB_HOSTCHAN_HCSPLT_COMPSPLT_Pos (16UL) /*!< field COMPSPLT (bitOffset 16, bitWidth 1) */
#define USB_HOSTCHAN_HCSPLT_COMPSPLT_Msk (0x00010000UL) /*!< field COMPSPLT (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCSPLT_SPLTENA_Pos (31UL) /*!< field SPLTENA (bitOffset 31, bitWidth 1) */
#define USB_HOSTCHAN_HCSPLT_SPLTENA_Msk (0x80000000UL) /*!< field SPLTENA (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register HCINT0 ===================================================== */
#define USB_HOSTCHAN_HCINT_XFERCOMPL_Pos (0UL) /*!< field XFERCOMPL (bitOffset 0, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_XFERCOMPL_Msk (0x00000001UL) /*!< field XFERCOMPL (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_CHHLTD_Pos (1UL) /*!< field CHHLTD (bitOffset 1, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_CHHLTD_Msk (0x00000002UL) /*!< field CHHLTD (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_AHBERR_Pos (2UL) /*!< field AHBERR (bitOffset 2, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_AHBERR_Msk (0x00000004UL) /*!< field AHBERR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_STALL_Pos (3UL) /*!< field STALL (bitOffset 3, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_STALL_Msk (0x00000008UL) /*!< field STALL (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_NAK_Pos (4UL) /*!< field NAK (bitOffset 4, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_NAK_Msk (0x00000010UL) /*!< field NAK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_ACK_Pos (5UL) /*!< field ACK (bitOffset 5, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_ACK_Msk (0x00000020UL) /*!< field ACK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_NYET_Pos (6UL) /*!< field NYET (bitOffset 6, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_NYET_Msk (0x00000040UL) /*!< field NYET (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_XACTERR_Pos (7UL) /*!< field XACTERR (bitOffset 7, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_XACTERR_Msk (0x00000080UL) /*!< field XACTERR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_BBLERR_Pos (8UL) /*!< field BBLERR (bitOffset 8, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_BBLERR_Msk (0x00000100UL) /*!< field BBLERR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_FRMOVRUN_Pos (9UL) /*!< field FRMOVRUN (bitOffset 9, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_FRMOVRUN_Msk (0x00000200UL) /*!< field FRMOVRUN (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_DATATGLERR_Pos (10UL) /*!< field DATATGLERR (bitOffset 10, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_DATATGLERR_Msk (0x00000400UL) /*!< field DATATGLERR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_BNAINTR_Pos (11UL) /*!< field BNAINTR (bitOffset 11, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_BNAINTR_Msk (0x00000800UL) /*!< field BNAINTR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_XCS_XACT_ERR_Pos (12UL) /*!< field XCS_XACT_ERR (bitOffset 12, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_XCS_XACT_ERR_Msk (0x00001000UL) /*!< field XCS_XACT_ERR (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINT_DESC_LST_ROLLINTR_Pos (13UL) /*!< field DESC_LST_ROLLINTR (bitOffset 13, bitWidth 1) */
#define USB_HOSTCHAN_HCINT_DESC_LST_ROLLINTR_Msk (0x00002000UL) /*!< field DESC_LST_ROLLINTR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register HCINTMSK0 =================================================== */
#define USB_HOSTCHAN_HCINTMSK_XFERCOMPLMSK_Pos (0UL) /*!< field XFERCOMPLMSK (bitOffset 0, bitWidth 1) */
#define USB_HOSTCHAN_HCINTMSK_XFERCOMPLMSK_Msk (0x00000001UL) /*!< field XFERCOMPLMSK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINTMSK_CHHLTDMSK_Pos (1UL) /*!< field CHHLTDMSK (bitOffset 1, bitWidth 1) */
#define USB_HOSTCHAN_HCINTMSK_CHHLTDMSK_Msk (0x00000002UL) /*!< field CHHLTDMSK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINTMSK_AHBERRMSK_Pos (2UL) /*!< field AHBERRMSK (bitOffset 2, bitWidth 1) */
#define USB_HOSTCHAN_HCINTMSK_AHBERRMSK_Msk (0x00000004UL) /*!< field AHBERRMSK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINTMSK_BNAINTRMSK_Pos (11UL) /*!< field BNAINTRMSK (bitOffset 11, bitWidth 1) */
#define USB_HOSTCHAN_HCINTMSK_BNAINTRMSK_Msk (0x00000800UL) /*!< field BNAINTRMSK (Bitfield-Mask: 0x00000001) */
#define USB_HOSTCHAN_HCINTMSK_DESC_LST_ROLLINTRMSK_Pos (13UL) /*!< field DESC_LST_ROLLINTRMSK (bitOffset 13, bitWidth 1) */
#define USB_HOSTCHAN_HCINTMSK_DESC_LST_ROLLINTRMSK_Msk (0x00002000UL) /*!< field DESC_LST_ROLLINTRMSK (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register HCTSIZ0 ==================================================== */
#define USB_HOSTCHAN_HCTSIZ_XFERSIZE_Pos (0UL) /*!< field XFERSIZE (bitOffset 0, bitWidth 19) */
#define USB_HOSTCHAN_HCTSIZ_XFERSIZE_Msk (0x0007ffffUL) /*!< field XFERSIZE (Bitfield-Mask: 0x0007ffff) */
#define USB_HOSTCHAN_HCTSIZ_PKTCNT_Pos (19UL) /*!< field PKTCNT (bitOffset 19, bitWidth 10) */
#define USB_HOSTCHAN_HCTSIZ_PKTCNT_Msk (0x1ff80000UL) /*!< field PKTCNT (Bitfield-Mask: 0x000003ff) */
#define USB_HOSTCHAN_HCTSIZ_PID_Pos (29UL) /*!< field PID (bitOffset 29, bitWidth 2) */
#define USB_HOSTCHAN_HCTSIZ_PID_Msk (0x60000000UL) /*!< field PID (Bitfield-Mask: 0x00000003) */
#define USB_HOSTCHAN_HCTSIZ_DOPNG_Pos (31UL) /*!< field DOPNG (bitOffset 31, bitWidth 1) */
#define USB_HOSTCHAN_HCTSIZ_DOPNG_Msk (0x80000000UL) /*!< field DOPNG (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register HCDMA0 ===================================================== */
#define USB_HOSTCHAN_HCDMA_DMAADDR_Pos (0UL) /*!< field DMAADDR (bitOffset 0, bitWidth 32) */
#define USB_HOSTCHAN_HCDMA_DMAADDR_Msk (0xffffffffUL) /*!< field DMAADDR (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register HCDMAB0 ==================================================== */
#define USB_HOSTCHAN_HCDMAB_HCDMAB_Pos (0UL) /*!< field HCDMAB (bitOffset 0, bitWidth 32) */
#define USB_HOSTCHAN_HCDMAB_HCDMAB_Msk (0xffffffffUL) /*!< field HCDMAB (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: USB_URB =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: QSPI ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GNSS ================================================ */
/* =========================================================================================================================== */

/* =========================================================================================================================== */
/* ======================================================= Cluster: ADC ====================================================== */
/* =========================================================================================================================== */

/* ===================================================== Register SIG1_I ===================================================== */
#define GNSS_ADC_SIG1_I_ADC_SIG1_I_0_Pos (0UL) /*!< field ADC_SIG1_I_0 (bitOffset 0, bitWidth 16) */
#define GNSS_ADC_SIG1_I_ADC_SIG1_I_0_Msk (0x0000ffffUL) /*!< field ADC_SIG1_I_0 (Bitfield-Mask: 0x0000ffff) */
#define GNSS_ADC_SIG1_I_ADC_SIG1_I_1_Pos (16UL) /*!< field ADC_SIG1_I_1 (bitOffset 16, bitWidth 16) */
#define GNSS_ADC_SIG1_I_ADC_SIG1_I_1_Msk (0xffff0000UL) /*!< field ADC_SIG1_I_1 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register SIG1_Q ===================================================== */
#define GNSS_ADC_SIG1_Q_ADC_SIG1_Q_0_Pos (0UL) /*!< field ADC_SIG1_Q_0 (bitOffset 0, bitWidth 16) */
#define GNSS_ADC_SIG1_Q_ADC_SIG1_Q_0_Msk (0x0000ffffUL) /*!< field ADC_SIG1_Q_0 (Bitfield-Mask: 0x0000ffff) */
#define GNSS_ADC_SIG1_Q_ADC_SIG1_Q_1_Pos (16UL) /*!< field ADC_SIG1_Q_1 (bitOffset 16, bitWidth 16) */
#define GNSS_ADC_SIG1_Q_ADC_SIG1_Q_1_Msk (0xffff0000UL) /*!< field ADC_SIG1_Q_1 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register SIG2_I ===================================================== */
#define GNSS_ADC_SIG2_I_ADC_SIG2_I_0_Pos (0UL) /*!< field ADC_SIG2_I_0 (bitOffset 0, bitWidth 16) */
#define GNSS_ADC_SIG2_I_ADC_SIG2_I_0_Msk (0x0000ffffUL) /*!< field ADC_SIG2_I_0 (Bitfield-Mask: 0x0000ffff) */
#define GNSS_ADC_SIG2_I_ADC_SIG2_I_1_Pos (16UL) /*!< field ADC_SIG2_I_1 (bitOffset 16, bitWidth 16) */
#define GNSS_ADC_SIG2_I_ADC_SIG2_I_1_Msk (0xffff0000UL) /*!< field ADC_SIG2_I_1 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register SIG2_Q ===================================================== */
#define GNSS_ADC_SIG2_Q_ADC_SIG2_Q_0_Pos (0UL) /*!< field ADC_SIG2_Q_0 (bitOffset 0, bitWidth 16) */
#define GNSS_ADC_SIG2_Q_ADC_SIG2_Q_0_Msk (0x0000ffffUL) /*!< field ADC_SIG2_Q_0 (Bitfield-Mask: 0x0000ffff) */
#define GNSS_ADC_SIG2_Q_ADC_SIG2_Q_1_Pos (16UL) /*!< field ADC_SIG2_Q_1 (bitOffset 16, bitWidth 16) */
#define GNSS_ADC_SIG2_Q_ADC_SIG2_Q_1_Msk (0xffff0000UL) /*!< field ADC_SIG2_Q_1 (Bitfield-Mask: 0x0000ffff) */

/* ====================================================== Register CTRL ====================================================== */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG1_EDGE_Pos (0UL) /*!< field ADC_CTRL_SIG1_EDGE (bitOffset 0, bitWidth 1) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG1_EDGE_Msk (0x00000001UL) /*!< field ADC_CTRL_SIG1_EDGE (Bitfield-Mask: 0x00000001) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG2_EDGE_Pos (1UL) /*!< field ADC_CTRL_SIG2_EDGE (bitOffset 1, bitWidth 1) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG2_EDGE_Msk (0x00000002UL) /*!< field ADC_CTRL_SIG2_EDGE (Bitfield-Mask: 0x00000001) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG1_ENC_Pos (3UL) /*!< field ADC_CTRL_SIG1_ENC (bitOffset 3, bitWidth 2) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG1_ENC_Msk (0x00000018UL) /*!< field ADC_CTRL_SIG1_ENC (Bitfield-Mask: 0x00000003) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG2_ENC_Pos (5UL) /*!< field ADC_CTRL_SIG2_ENC (bitOffset 5, bitWidth 2) */
#define GNSS_ADC_CTRL_ADC_CTRL_SIG2_ENC_Msk (0x00000060UL) /*!< field ADC_CTRL_SIG2_ENC (Bitfield-Mask: 0x00000003) */
#define GNSS_ADC_CTRL_ADC_CTRL_IQ_SWAP_Pos (7UL) /*!< field ADC_CTRL_IQ_SWAP (bitOffset 7, bitWidth 1) */
#define GNSS_ADC_CTRL_ADC_CTRL_IQ_SWAP_Msk (0x00000080UL) /*!< field ADC_CTRL_IQ_SWAP (Bitfield-Mask: 0x00000001) */
#define GNSS_ADC_CTRL_ADC_CTRL_GNSS_SWAP_Pos (8UL) /*!< field ADC_CTRL_GNSS_SWAP (bitOffset 8, bitWidth 1) */
#define GNSS_ADC_CTRL_ADC_CTRL_GNSS_SWAP_Msk (0x00000100UL) /*!< field ADC_CTRL_GNSS_SWAP (Bitfield-Mask: 0x00000001) */

/* =========================================================================================================================== */
/* ===================================================== Cluster: CA5_%s ===================================================== */
/* =========================================================================================================================== */

/* ====================================================== Register PCHIP ===================================================== */
#define GNSS_CA5__PCHIP_PCHIP_Pos (0UL) /*!< field PCHIP (bitOffset 0, bitWidth 31) */
#define GNSS_CA5__PCHIP_PCHIP_Msk (0x7fffffffUL) /*!< field PCHIP (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register FHET ====================================================== */
#define GNSS_CA5__FHET_FHET_Pos (0UL) /*!< field FHET (bitOffset 0, bitWidth 32) */
#define GNSS_CA5__FHET_FHET_Msk (0xffffffffUL) /*!< field FHET (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register CFG1 ====================================================== */
#define GNSS_CA5__CFG1_CA5_CFG1_G1_Pos (0UL) /*!< field CA5_CFG1_G1 (bitOffset 0, bitWidth 10) */
#define GNSS_CA5__CFG1_CA5_CFG1_G1_Msk (0x000003ffUL) /*!< field CA5_CFG1_G1 (Bitfield-Mask: 0x000003ff) */
#define GNSS_CA5__CFG1_CA5_CFG1_SINGLE_Pos (10UL) /*!< field CA5_CFG1_SINGLE (bitOffset 10, bitWidth 1) */
#define GNSS_CA5__CFG1_CA5_CFG1_SINGLE_Msk (0x00000400UL) /*!< field CA5_CFG1_SINGLE (Bitfield-Mask: 0x00000001) */
#define GNSS_CA5__CFG1_CA5_CFG1_START_Pos (11UL) /*!< field CA5_CFG1_START (bitOffset 11, bitWidth 1) */
#define GNSS_CA5__CFG1_CA5_CFG1_START_Msk (0x00000800UL) /*!< field CA5_CFG1_START (Bitfield-Mask: 0x00000001) */
#define GNSS_CA5__CFG1_CA5_CFG1_GPGL_Pos (12UL) /*!< field CA5_CFG1_GPGL (bitOffset 12, bitWidth 1) */
#define GNSS_CA5__CFG1_CA5_CFG1_GPGL_Msk (0x00001000UL) /*!< field CA5_CFG1_GPGL (Bitfield-Mask: 0x00000001) */
#define GNSS_CA5__CFG1_CA5_CFG1_G2_Pos (16UL) /*!< field CA5_CFG1_G2 (bitOffset 16, bitWidth 10) */
#define GNSS_CA5__CFG1_CA5_CFG1_G2_Msk (0x03ff0000UL) /*!< field CA5_CFG1_G2 (Bitfield-Mask: 0x000003ff) */
#define GNSS_CA5__CFG1_CA5_CFG1_BITSEL_Pos (29UL) /*!< field CA5_CFG1_BITSEL (bitOffset 29, bitWidth 3) */
#define GNSS_CA5__CFG1_CA5_CFG1_BITSEL_Msk (0xe0000000UL) /*!< field CA5_CFG1_BITSEL (Bitfield-Mask: 0x00000007) */

/* ====================================================== Register CFG2 ====================================================== */
#define GNSS_CA5__CFG2_CA5_CFG2_ACCTIME_Pos (0UL) /*!< field CA5_CFG2_ACCTIME (bitOffset 0, bitWidth 4) */
#define GNSS_CA5__CFG2_CA5_CFG2_ACCTIME_Msk (0x0000000fUL) /*!< field CA5_CFG2_ACCTIME (Bitfield-Mask: 0x0000000f) */
#define GNSS_CA5__CFG2_CA5_CFG2_ESTART_Pos (8UL) /*!< field CA5_CFG2_ESTART (bitOffset 8, bitWidth 8) */
#define GNSS_CA5__CFG2_CA5_CFG2_ESTART_Msk (0x0000ff00UL) /*!< field CA5_CFG2_ESTART (Bitfield-Mask: 0x000000ff) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC1_Pos (16UL) /*!< field CA5_CFG2_SPC1 (bitOffset 16, bitWidth 4) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC1_Msk (0x000f0000UL) /*!< field CA5_CFG2_SPC1 (Bitfield-Mask: 0x0000000f) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC2_Pos (20UL) /*!< field CA5_CFG2_SPC2 (bitOffset 20, bitWidth 4) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC2_Msk (0x00f00000UL) /*!< field CA5_CFG2_SPC2 (Bitfield-Mask: 0x0000000f) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC3_Pos (24UL) /*!< field CA5_CFG2_SPC3 (bitOffset 24, bitWidth 4) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC3_Msk (0x0f000000UL) /*!< field CA5_CFG2_SPC3 (Bitfield-Mask: 0x0000000f) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC4_Pos (28UL) /*!< field CA5_CFG2_SPC4 (bitOffset 28, bitWidth 4) */
#define GNSS_CA5__CFG2_CA5_CFG2_SPC4_Msk (0xf0000000UL) /*!< field CA5_CFG2_SPC4 (Bitfield-Mask: 0x0000000f) */

/* =========================================================================================================================== */
/* ===================================================== Cluster: COL_CA5 ==================================================== */
/* =========================================================================================================================== */

/* ======================================================= Register CFG ====================================================== */
#define GNSS_COL_CA5_CFG_COL_ENABLE_Pos (0UL) /*!< field COL_ENABLE (bitOffset 0, bitWidth 1) */
#define GNSS_COL_CA5_CFG_COL_ENABLE_Msk (0x00000001UL) /*!< field COL_ENABLE (Bitfield-Mask: 0x00000001) */
#define GNSS_COL_CA5_CFG_COL_FCLEAR_Pos (1UL) /*!< field COL_FCLEAR (bitOffset 1, bitWidth 1) */
#define GNSS_COL_CA5_CFG_COL_FCLEAR_Msk (0x00000002UL) /*!< field COL_FCLEAR (Bitfield-Mask: 0x00000001) */
#define GNSS_COL_CA5_CFG_COL_FEMPTY_Pos (2UL) /*!< field COL_FEMPTY (bitOffset 2, bitWidth 1) */
#define GNSS_COL_CA5_CFG_COL_FEMPTY_Msk (0x00000004UL) /*!< field COL_FEMPTY (Bitfield-Mask: 0x00000001) */
#define GNSS_COL_CA5_CFG_COL_FFULL_Pos (3UL) /*!< field COL_FFULL (bitOffset 3, bitWidth 1) */
#define GNSS_COL_CA5_CFG_COL_FFULL_Msk (0x00000008UL) /*!< field COL_FFULL (Bitfield-Mask: 0x00000001) */
#define GNSS_COL_CA5_CFG_COL_AFULL_Pos (6UL) /*!< field COL_AFULL (bitOffset 6, bitWidth 1) */
#define GNSS_COL_CA5_CFG_COL_AFULL_Msk (0x00000040UL) /*!< field COL_AFULL (Bitfield-Mask: 0x00000001) */
#define GNSS_COL_CA5_CFG_COL_THR_Pos (14UL) /*!< field COL_THR (bitOffset 14, bitWidth 3) */
#define GNSS_COL_CA5_CFG_COL_THR_Msk (0x0001c000UL) /*!< field COL_THR (Bitfield-Mask: 0x00000007) */

/* ====================================================== Register DATA ====================================================== */
#define GNSS_COL_CA5_DATA_COL_CA5_DATA_Pos (0UL) /*!< field COL_CA5_DATA (bitOffset 0, bitWidth 32) */
#define GNSS_COL_CA5_DATA_COL_CA5_DATA_Msk (0xffffffffUL) /*!< field COL_CA5_DATA (Bitfield-Mask: 0xffffffff) */

/* =========================================================================================================================== */
/* ====================================================== Cluster: FCHIP ===================================================== */
/* =========================================================================================================================== */

/* ===================================================== Register CA5_GPS ==================================================== */
#define GNSS_FCHIP_CA5_GPS_FCHIP_CA5_GPS_Pos (0UL) /*!< field FCHIP_CA5_GPS (bitOffset 0, bitWidth 31) */
#define GNSS_FCHIP_CA5_GPS_FCHIP_CA5_GPS_Msk (0x7fffffffUL) /*!< field FCHIP_CA5_GPS (Bitfield-Mask: 0x7fffffff) */

/* ===================================================== Register CA5_GLO ==================================================== */
#define GNSS_FCHIP_CA5_GLO_FCHIP_CA5_GLO_Pos (0UL) /*!< field FCHIP_CA5_GLO (bitOffset 0, bitWidth 31) */
#define GNSS_FCHIP_CA5_GLO_FCHIP_CA5_GLO_Msk (0x7fffffffUL) /*!< field FCHIP_CA5_GLO (Bitfield-Mask: 0x7fffffff) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: FSE ====================================================== */
/* =========================================================================================================================== */

/* ====================================================== Register FHET ====================================================== */
#define GNSS_FSE_FHET_FHET_Pos (0UL) /*!< field FHET (bitOffset 0, bitWidth 32) */
#define GNSS_FSE_FHET_FHET_Msk (0xffffffffUL) /*!< field FHET (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register CFG ====================================================== */
#define GNSS_FSE_CFG_FSE_CFG_STOPTHR_Pos (0UL) /*!< field FSE_CFG_STOPTHR (bitOffset 0, bitWidth 16) */
#define GNSS_FSE_CFG_FSE_CFG_STOPTHR_Msk (0x0000ffffUL) /*!< field FSE_CFG_STOPTHR (Bitfield-Mask: 0x0000ffff) */
#define GNSS_FSE_CFG_FSE_CFG_BITSEL_CA_Pos (16UL) /*!< field FSE_CFG_BITSEL_CA (bitOffset 16, bitWidth 3) */
#define GNSS_FSE_CFG_FSE_CFG_BITSEL_CA_Msk (0x00070000UL) /*!< field FSE_CFG_BITSEL_CA (Bitfield-Mask: 0x00000007) */
#define GNSS_FSE_CFG_FSE_CFG_GPGL_Pos (19UL) /*!< field FSE_CFG_GPGL (bitOffset 19, bitWidth 1) */
#define GNSS_FSE_CFG_FSE_CFG_GPGL_Msk (0x00080000UL) /*!< field FSE_CFG_GPGL (Bitfield-Mask: 0x00000001) */
#define GNSS_FSE_CFG_FSE_CFG_BITSEL_NCA_Pos (20UL) /*!< field FSE_CFG_BITSEL_NCA (bitOffset 20, bitWidth 3) */
#define GNSS_FSE_CFG_FSE_CFG_BITSEL_NCA_Msk (0x00700000UL) /*!< field FSE_CFG_BITSEL_NCA (Bitfield-Mask: 0x00000007) */
#define GNSS_FSE_CFG_FSE_CFG_ACC1THR_Pos (23UL) /*!< field FSE_CFG_ACC1THR (bitOffset 23, bitWidth 4) */
#define GNSS_FSE_CFG_FSE_CFG_ACC1THR_Msk (0x07800000UL) /*!< field FSE_CFG_ACC1THR (Bitfield-Mask: 0x0000000f) */
#define GNSS_FSE_CFG_FSE_CFG_NCA_RES_CLR_Pos (29UL) /*!< field FSE_CFG_NCA_RES_CLR (bitOffset 29, bitWidth 1) */
#define GNSS_FSE_CFG_FSE_CFG_NCA_RES_CLR_Msk (0x20000000UL) /*!< field FSE_CFG_NCA_RES_CLR (Bitfield-Mask: 0x00000001) */
#define GNSS_FSE_CFG_FSE_CFG_PRS_CLR_Pos (30UL) /*!< field FSE_CFG_PRS_CLR (bitOffset 30, bitWidth 1) */
#define GNSS_FSE_CFG_FSE_CFG_PRS_CLR_Msk (0x40000000UL) /*!< field FSE_CFG_PRS_CLR (Bitfield-Mask: 0x00000001) */
#define GNSS_FSE_CFG_FSE_CFG_RDY_Pos (31UL) /*!< field FSE_CFG_RDY (bitOffset 31, bitWidth 1) */
#define GNSS_FSE_CFG_FSE_CFG_RDY_Msk (0x80000000UL) /*!< field FSE_CFG_RDY (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register ACC ====================================================== */
#define GNSS_FSE_ACC_FSE_ACC_CA_Pos (0UL) /*!< field FSE_ACC_CA (bitOffset 0, bitWidth 4) */
#define GNSS_FSE_ACC_FSE_ACC_CA_Msk (0x0000000fUL) /*!< field FSE_ACC_CA (Bitfield-Mask: 0x0000000f) */
#define GNSS_FSE_ACC_FSE_ACC_NCA_Pos (4UL) /*!< field FSE_ACC_NCA (bitOffset 4, bitWidth 10) */
#define GNSS_FSE_ACC_FSE_ACC_NCA_Msk (0x00003ff0UL) /*!< field FSE_ACC_NCA (Bitfield-Mask: 0x000003ff) */

/* ====================================================== Register PRSIN ===================================================== */
#define GNSS_FSE_PRSIN_FSE_PRSIN_Pos (0UL) /*!< field FSE_PRSIN (bitOffset 0, bitWidth 32) */
#define GNSS_FSE_PRSIN_FSE_PRSIN_Msk (0xffffffffUL) /*!< field FSE_PRSIN (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register MAX ====================================================== */
#define GNSS_FSE_MAX_FSE_MAX_ZMAX_Pos (0UL) /*!< field FSE_MAX_ZMAX (bitOffset 0, bitWidth 16) */
#define GNSS_FSE_MAX_FSE_MAX_ZMAX_Msk (0x0000ffffUL) /*!< field FSE_MAX_ZMAX (Bitfield-Mask: 0x0000ffff) */
#define GNSS_FSE_MAX_FSE_MAX_TMAX_Pos (16UL) /*!< field FSE_MAX_TMAX (bitOffset 16, bitWidth 11) */
#define GNSS_FSE_MAX_FSE_MAX_TMAX_Msk (0x07ff0000UL) /*!< field FSE_MAX_TMAX (Bitfield-Mask: 0x000007ff) */
#define GNSS_FSE_MAX_FSE_MAX_OVF_Pos (31UL) /*!< field FSE_MAX_OVF (bitOffset 31, bitWidth 1) */
#define GNSS_FSE_MAX_FSE_MAX_OVF_Msk (0x80000000UL) /*!< field FSE_MAX_OVF (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register NCA_RES ==================================================== */
#define GNSS_FSE_NCA_RES_FSE_NCA_RES_Pos (0UL) /*!< field FSE_NCA_RES (bitOffset 0, bitWidth 16) */
#define GNSS_FSE_NCA_RES_FSE_NCA_RES_Msk (0x0000ffffUL) /*!< field FSE_NCA_RES (Bitfield-Mask: 0x0000ffff) */

/* ====================================================== Register FCHIP ===================================================== */
#define GNSS_FSE_FCHIP_FSE_FCHIP_Pos (0UL) /*!< field FSE_FCHIP (bitOffset 0, bitWidth 31) */
#define GNSS_FSE_FCHIP_FSE_FCHIP_Msk (0x7fffffffUL) /*!< field FSE_FCHIP (Bitfield-Mask: 0x7fffffff) */

/* =========================================================================================================================== */
/* ====================================================== Cluster: IMIT ====================================================== */
/* =========================================================================================================================== */

/* ====================================================== Register PCHIP ===================================================== */
#define GNSS_IMIT_PCHIP_IMIT_PCHIP_Pos (0UL) /*!< field IMIT_PCHIP (bitOffset 0, bitWidth 32) */
#define GNSS_IMIT_PCHIP_IMIT_PCHIP_Msk (0xffffffffUL) /*!< field IMIT_PCHIP (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register FDOP ====================================================== */
#define GNSS_IMIT_FDOP_IMIT_FDOP_Pos (0UL) /*!< field IMIT_FDOP (bitOffset 0, bitWidth 32) */
#define GNSS_IMIT_FDOP_IMIT_FDOP_Msk (0xffffffffUL) /*!< field IMIT_FDOP (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register G1G2 ====================================================== */
#define GNSS_IMIT_G1G2_IMIT_GG_G1_Pos (0UL) /*!< field IMIT_GG_G1 (bitOffset 0, bitWidth 10) */
#define GNSS_IMIT_G1G2_IMIT_GG_G1_Msk (0x000003ffUL) /*!< field IMIT_GG_G1 (Bitfield-Mask: 0x000003ff) */
#define GNSS_IMIT_G1G2_IMIT_GG_G2_Pos (16UL) /*!< field IMIT_GG_G2 (bitOffset 16, bitWidth 10) */
#define GNSS_IMIT_G1G2_IMIT_GG_G2_Msk (0x03ff0000UL) /*!< field IMIT_GG_G2 (Bitfield-Mask: 0x000003ff) */

/* ======================================================= Register CFG ====================================================== */
#define GNSS_IMIT_CFG_IMIT_EN_Pos (0UL) /*!< field IMIT_EN (bitOffset 0, bitWidth 1) */
#define GNSS_IMIT_CFG_IMIT_EN_Msk (0x00000001UL) /*!< field IMIT_EN (Bitfield-Mask: 0x00000001) */
#define GNSS_IMIT_CFG_IMIT_ESYNC_Pos (3UL) /*!< field IMIT_ESYNC (bitOffset 3, bitWidth 1) */
#define GNSS_IMIT_CFG_IMIT_ESYNC_Msk (0x00000008UL) /*!< field IMIT_ESYNC (Bitfield-Mask: 0x00000001) */
#define GNSS_IMIT_CFG_IMIT_MOD_Pos (4UL) /*!< field IMIT_MOD (bitOffset 4, bitWidth 1) */
#define GNSS_IMIT_CFG_IMIT_MOD_Msk (0x00000010UL) /*!< field IMIT_MOD (Bitfield-Mask: 0x00000001) */
#define GNSS_IMIT_CFG_IMIT_GPGL_Pos (5UL) /*!< field IMIT_GPGL (bitOffset 5, bitWidth 1) */
#define GNSS_IMIT_CFG_IMIT_GPGL_Msk (0x00000020UL) /*!< field IMIT_GPGL (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register NPF ====================================================== */
#define GNSS_IMIT_NPF_IMIT_NPF_Pos (0UL) /*!< field IMIT_NPF (bitOffset 0, bitWidth 8) */
#define GNSS_IMIT_NPF_IMIT_NPF_Msk (0x000000ffUL) /*!< field IMIT_NPF (Bitfield-Mask: 0x000000ff) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: IRQ ====================================================== */
/* =========================================================================================================================== */

/* ======================================================= Register CFG ====================================================== */
#define GNSS_IRQ_CFG_IRQ_CFG_EPOCH_DEC_Pos (0UL) /*!< field IRQ_CFG_EPOCH_DEC (bitOffset 0, bitWidth 6) */
#define GNSS_IRQ_CFG_IRQ_CFG_EPOCH_DEC_Msk (0x0000003fUL) /*!< field IRQ_CFG_EPOCH_DEC (Bitfield-Mask: 0x0000003f) */
#define GNSS_IRQ_CFG_IRQ_CFG_COL_CA5_Pos (27UL) /*!< field IRQ_CFG_COL_CA5 (bitOffset 27, bitWidth 1) */
#define GNSS_IRQ_CFG_IRQ_CFG_COL_CA5_Msk (0x08000000UL) /*!< field IRQ_CFG_COL_CA5 (Bitfield-Mask: 0x00000001) */
#define GNSS_IRQ_CFG_IRQ_CFG_EPOCH_Pos (28UL) /*!< field IRQ_CFG_EPOCH (bitOffset 28, bitWidth 1) */
#define GNSS_IRQ_CFG_IRQ_CFG_EPOCH_Msk (0x10000000UL) /*!< field IRQ_CFG_EPOCH (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register STAT ====================================================== */
#define GNSS_IRQ_STAT_IRQ_STATUS_COL_CA5_Pos (27UL) /*!< field IRQ_STATUS_COL_CA5 (bitOffset 27, bitWidth 1) */
#define GNSS_IRQ_STAT_IRQ_STATUS_COL_CA5_Msk (0x08000000UL) /*!< field IRQ_STATUS_COL_CA5 (Bitfield-Mask: 0x00000001) */
#define GNSS_IRQ_STAT_IRQ_STATUS_EPOCH_Pos (28UL) /*!< field IRQ_STATUS_EPOCH (bitOffset 28, bitWidth 1) */
#define GNSS_IRQ_STAT_IRQ_STATUS_EPOCH_Msk (0x10000000UL) /*!< field IRQ_STATUS_EPOCH (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register ACK ====================================================== */
#define GNSS_IRQ_ACK_IRQ_ACK_COL_CA5_Pos (27UL) /*!< field IRQ_ACK_COL_CA5 (bitOffset 27, bitWidth 1) */
#define GNSS_IRQ_ACK_IRQ_ACK_COL_CA5_Msk (0x08000000UL) /*!< field IRQ_ACK_COL_CA5 (Bitfield-Mask: 0x00000001) */
#define GNSS_IRQ_ACK_IRQ_ACK_EPOCH_Pos (28UL) /*!< field IRQ_ACK_EPOCH (bitOffset 28, bitWidth 1) */
#define GNSS_IRQ_ACK_IRQ_ACK_EPOCH_Msk (0x10000000UL) /*!< field IRQ_ACK_EPOCH (Bitfield-Mask: 0x00000001) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: ISG ====================================================== */
/* =========================================================================================================================== */

/* ====================================================== Register CHIP ====================================================== */
#define GNSS_ISG_CHIP_ISG_CHIP_G1_Pos (0UL) /*!< field ISG_CHIP_G1 (bitOffset 0, bitWidth 10) */
#define GNSS_ISG_CHIP_ISG_CHIP_G1_Msk (0x000003ffUL) /*!< field ISG_CHIP_G1 (Bitfield-Mask: 0x000003ff) */
#define GNSS_ISG_CHIP_ISG_CHIP_G2_Pos (16UL) /*!< field ISG_CHIP_G2 (bitOffset 16, bitWidth 10) */
#define GNSS_ISG_CHIP_ISG_CHIP_G2_Msk (0x03ff0000UL) /*!< field ISG_CHIP_G2 (Bitfield-Mask: 0x000003ff) */
#define GNSS_ISG_CHIP_ISG_READY_Pos (31UL) /*!< field ISG_READY (bitOffset 31, bitWidth 1) */
#define GNSS_ISG_CHIP_ISG_READY_Msk (0x80000000UL) /*!< field ISG_READY (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register GPS ====================================================== */
#define GNSS_ISG_GPS_ISG_GPS_G1_Pos (0UL) /*!< field ISG_GPS_G1 (bitOffset 0, bitWidth 10) */
#define GNSS_ISG_GPS_ISG_GPS_G1_Msk (0x000003ffUL) /*!< field ISG_GPS_G1 (Bitfield-Mask: 0x000003ff) */
#define GNSS_ISG_GPS_ISG_GPS_G2_Pos (16UL) /*!< field ISG_GPS_G2 (bitOffset 16, bitWidth 10) */
#define GNSS_ISG_GPS_ISG_GPS_G2_Msk (0x03ff0000UL) /*!< field ISG_GPS_G2 (Bitfield-Mask: 0x000003ff) */

/* ======================================================= Register GLO ====================================================== */
#define GNSS_ISG_GLO_ISG_GLO_G_Pos (0UL) /*!< field ISG_GLO_G (bitOffset 0, bitWidth 9) */
#define GNSS_ISG_GLO_ISG_GLO_G_Msk (0x000001ffUL) /*!< field ISG_GLO_G (Bitfield-Mask: 0x000001ff) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: MCC ====================================================== */
/* =========================================================================================================================== */

/* ===================================================== Register VERSION ==================================================== */
#define GNSS_MCC_VERSION_VERSION_Pos (0UL) /*!< field VERSION (bitOffset 0, bitWidth 32) */
#define GNSS_MCC_VERSION_VERSION_Msk (0xffffffffUL) /*!< field VERSION (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register TEST_RW ==================================================== */
#define GNSS_MCC_TEST_RW_TEST_RW_Pos (0UL) /*!< field TEST_RW (bitOffset 0, bitWidth 32) */
#define GNSS_MCC_TEST_RW_TEST_RW_Msk (0xffffffffUL) /*!< field TEST_RW (Bitfield-Mask: 0xffffffff) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: PPS ====================================================== */
/* =========================================================================================================================== */

/* ======================================================= Register MS ======================================================= */
#define GNSS_PPS_MS_PPS_MS_CODE_Pos (0UL) /*!< field PPS_MS_CODE (bitOffset 0, bitWidth 16) */
#define GNSS_PPS_MS_PPS_MS_CODE_Msk (0x0000ffffUL) /*!< field PPS_MS_CODE (Bitfield-Mask: 0x0000ffff) */
#define GNSS_PPS_MS_PPS_MS_LEN_Pos (16UL) /*!< field PPS_MS_LEN (bitOffset 16, bitWidth 16) */
#define GNSS_PPS_MS_PPS_MS_LEN_Msk (0xffff0000UL) /*!< field PPS_MS_LEN (Bitfield-Mask: 0x0000ffff) */

/* ======================================================= Register OFS ====================================================== */
#define GNSS_PPS_OFS_PPS_OFS_CLK_INIT_Pos (0UL) /*!< field PPS_OFS_CLK_INIT (bitOffset 0, bitWidth 16) */
#define GNSS_PPS_OFS_PPS_OFS_CLK_INIT_Msk (0x0000ffffUL) /*!< field PPS_OFS_CLK_INIT (Bitfield-Mask: 0x0000ffff) */
#define GNSS_PPS_OFS_PPS_OFS_MS_INIT_Pos (16UL) /*!< field PPS_OFS_MS_INIT (bitOffset 16, bitWidth 16) */
#define GNSS_PPS_OFS_PPS_OFS_MS_INIT_Msk (0xffff0000UL) /*!< field PPS_OFS_MS_INIT (Bitfield-Mask: 0x0000ffff) */

/* =========================================================================================================================== */
/* ======================================================= Cluster: TB ======================================================= */
/* =========================================================================================================================== */

/* ====================================================== Register ECNT ====================================================== */
#define GNSS_TB_ECNT_TB_ECNT_Pos (0UL) /*!< field TB_ECNT (bitOffset 0, bitWidth 32) */
#define GNSS_TB_ECNT_TB_ECNT_Msk (0xffffffffUL) /*!< field TB_ECNT (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register MS_CODE ==================================================== */
#define GNSS_TB_MS_CODE_TB_MS_CODE_Pos (0UL) /*!< field TB_MS_CODE (bitOffset 0, bitWidth 16) */
#define GNSS_TB_MS_CODE_TB_MS_CODE_Msk (0x0000ffffUL) /*!< field TB_MS_CODE (Bitfield-Mask: 0x0000ffff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SMC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SDMMC ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DMA ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: FCTR ================================================ */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: FCACHE =============================================== */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: RWC ================================================= */
/* =========================================================================================================================== */
   /* no clusters */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: JTM ================================================= */
/* =========================================================================================================================== */
   /* no clusters */


/** @} */ /* End of group PosMask_clusters */


/* =========================================================================================================================== */
/* =============================================== Pos/Mask Peripheral Section =============================================== */
/* =========================================================================================================================== */

/** @addtogroup PosMask_peripherals
  * @{
  */

/* =========================================================================================================================== */
/* ================================================= Type of peripheral: TIM ================================================= */
/* =========================================================================================================================== */

/* ====================================================== Register CTRL ====================================================== */
#define TIM_CTRL_ENABLE_Pos (0UL) /*!< field ENABLE (bitOffset 0, bitWidth 1) */
#define TIM_CTRL_ENABLE_Msk (0x00000001UL) /*!< field ENABLE (Bitfield-Mask: 0x00000001) */
#define TIM_CTRL_SELECTEXTEN_Pos (1UL) /*!< field SELECTEXTEN (bitOffset 1, bitWidth 1) */
#define TIM_CTRL_SELECTEXTEN_Msk (0x00000002UL) /*!< field SELECTEXTEN (Bitfield-Mask: 0x00000001) */
#define TIM_CTRL_SELECTEXTCLK_Pos (2UL) /*!< field SELECTEXTCLK (bitOffset 2, bitWidth 1) */
#define TIM_CTRL_SELECTEXTCLK_Msk (0x00000004UL) /*!< field SELECTEXTCLK (Bitfield-Mask: 0x00000001) */
#define TIM_CTRL_TIMERINTEN_Pos (3UL) /*!< field TIMERINTEN (bitOffset 3, bitWidth 1) */
#define TIM_CTRL_TIMERINTEN_Msk (0x00000008UL) /*!< field TIMERINTEN (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register VALUE ===================================================== */
#define TIM_VALUE_VALUE_Pos (0UL) /*!< field VALUE (bitOffset 0, bitWidth 32) */
#define TIM_VALUE_VALUE_Msk (0xffffffffUL) /*!< field VALUE (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register RELOAD ===================================================== */
#define TIM_RELOAD_RELOAD_Pos (0UL) /*!< field RELOAD (bitOffset 0, bitWidth 32) */
#define TIM_RELOAD_RELOAD_Msk (0xffffffffUL) /*!< field RELOAD (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register INTCLEAR ==================================================== */
#define TIM_INTCLEAR_INTCLEAR_Pos (0UL) /*!< field INTCLEAR (bitOffset 0, bitWidth 1) */
#define TIM_INTCLEAR_INTCLEAR_Msk (0x00000001UL) /*!< field INTCLEAR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register INTSTATUS =================================================== */
#define TIM_INTSTATUS_INTSTATUS_Pos (0UL) /*!< field INTSTATUS (bitOffset 0, bitWidth 1) */
#define TIM_INTSTATUS_INTSTATUS_Msk (0x00000001UL) /*!< field INTSTATUS (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register PID4 ====================================================== */
#define TIM_PID4_JEP106_C_CODE_Pos (0UL) /*!< field JEP106_C_CODE (bitOffset 0, bitWidth 4) */
#define TIM_PID4_JEP106_C_CODE_Msk (0x0000000fUL) /*!< field JEP106_C_CODE (Bitfield-Mask: 0x0000000f) */
#define TIM_PID4_BLOCK_COUNT_Pos (4UL) /*!< field BLOCK_COUNT (bitOffset 4, bitWidth 4) */
#define TIM_PID4_BLOCK_COUNT_Msk (0x000000f0UL) /*!< field BLOCK_COUNT (Bitfield-Mask: 0x0000000f) */

/* ====================================================== Register PID5 ====================================================== */
#define TIM_PID5_PID5_Pos (0UL) /*!< field PID5 (bitOffset 0, bitWidth 8) */
#define TIM_PID5_PID5_Msk (0x000000ffUL) /*!< field PID5 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PID6 ====================================================== */
#define TIM_PID6_PID6_Pos (0UL) /*!< field PID6 (bitOffset 0, bitWidth 8) */
#define TIM_PID6_PID6_Msk (0x000000ffUL) /*!< field PID6 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PID7 ====================================================== */
#define TIM_PID7_PID7_Pos (0UL) /*!< field PID7 (bitOffset 0, bitWidth 8) */
#define TIM_PID7_PID7_Msk (0x000000ffUL) /*!< field PID7 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PID0 ====================================================== */
#define TIM_PID0_PID0_Pos (0UL) /*!< field PID0 (bitOffset 0, bitWidth 8) */
#define TIM_PID0_PID0_Msk (0x000000ffUL) /*!< field PID0 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PID1 ====================================================== */
#define TIM_PID1_PART_NUMBER_11_8_Pos (0UL) /*!< field PART_NUMBER_11_8 (bitOffset 0, bitWidth 4) */
#define TIM_PID1_PART_NUMBER_11_8_Msk (0x0000000fUL) /*!< field PART_NUMBER_11_8 (Bitfield-Mask: 0x0000000f) */
#define TIM_PID1_JEP106_ID_3_0_Pos (4UL) /*!< field JEP106_ID_3_0 (bitOffset 4, bitWidth 4) */
#define TIM_PID1_JEP106_ID_3_0_Msk (0x000000f0UL) /*!< field JEP106_ID_3_0 (Bitfield-Mask: 0x0000000f) */

/* ====================================================== Register PID2 ====================================================== */
#define TIM_PID2_JEP106_ID_6_4_Pos (0UL) /*!< field JEP106_ID_6_4 (bitOffset 0, bitWidth 3) */
#define TIM_PID2_JEP106_ID_6_4_Msk (0x00000007UL) /*!< field JEP106_ID_6_4 (Bitfield-Mask: 0x00000007) */
#define TIM_PID2_JEDEC_USED_Pos (3UL) /*!< field JEDEC_USED (bitOffset 3, bitWidth 1) */
#define TIM_PID2_JEDEC_USED_Msk (0x00000008UL) /*!< field JEDEC_USED (Bitfield-Mask: 0x00000001) */
#define TIM_PID2_REVISION_Pos (4UL) /*!< field REVISION (bitOffset 4, bitWidth 4) */
#define TIM_PID2_REVISION_Msk (0x000000f0UL) /*!< field REVISION (Bitfield-Mask: 0x0000000f) */

/* ====================================================== Register PID3 ====================================================== */
#define TIM_PID3_CUST_MOD_NUM_Pos (0UL) /*!< field CUST_MOD_NUM (bitOffset 0, bitWidth 4) */
#define TIM_PID3_CUST_MOD_NUM_Msk (0x0000000fUL) /*!< field CUST_MOD_NUM (Bitfield-Mask: 0x0000000f) */
#define TIM_PID3_ECO_REV_NUM_Pos (4UL) /*!< field ECO_REV_NUM (bitOffset 4, bitWidth 4) */
#define TIM_PID3_ECO_REV_NUM_Msk (0x000000f0UL) /*!< field ECO_REV_NUM (Bitfield-Mask: 0x0000000f) */

/* ====================================================== Register CID0 ====================================================== */
#define TIM_CID0_CID0_Pos (0UL) /*!< field CID0 (bitOffset 0, bitWidth 8) */
#define TIM_CID0_CID0_Msk (0x000000ffUL) /*!< field CID0 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CID1 ====================================================== */
#define TIM_CID1_CID1_Pos (0UL) /*!< field CID1 (bitOffset 0, bitWidth 8) */
#define TIM_CID1_CID1_Msk (0x000000ffUL) /*!< field CID1 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CID2 ====================================================== */
#define TIM_CID2_CID2_Pos (0UL) /*!< field CID2 (bitOffset 0, bitWidth 8) */
#define TIM_CID2_CID2_Msk (0x000000ffUL) /*!< field CID2 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CID3 ====================================================== */
#define TIM_CID3_CID3_Pos (0UL) /*!< field CID3 (bitOffset 0, bitWidth 8) */
#define TIM_CID3_CID3_Msk (0x000000ffUL) /*!< field CID3 (Bitfield-Mask: 0x000000ff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: DTIM ================================================ */
/* =========================================================================================================================== */

/* =================================================== Register TIMER1LOAD =================================================== */
#define DTIM_TIMER1LOAD_TIMER1LOAD_Pos (0UL) /*!< field TIMER1LOAD (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER1LOAD_TIMER1LOAD_Msk (0xffffffffUL) /*!< field TIMER1LOAD (Bitfield-Mask: 0xffffffff) */

/* =================================================== Register TIMER1VALUE ================================================== */
#define DTIM_TIMER1VALUE_VALUE_Pos (0UL) /*!< field VALUE (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER1VALUE_VALUE_Msk (0xffffffffUL) /*!< field VALUE (Bitfield-Mask: 0xffffffff) */

/* ================================================== Register TIMER1CONTROL ================================================= */
#define DTIM_TIMER1CONTROL_ONESHOTCOUNT_Pos (0UL) /*!< field ONESHOTCOUNT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER1CONTROL_ONESHOTCOUNT_Msk (0x00000001UL) /*!< field ONESHOTCOUNT (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER1CONTROL_TIMERSIZE_Pos (1UL) /*!< field TIMERSIZE (bitOffset 1, bitWidth 1) */
#define DTIM_TIMER1CONTROL_TIMERSIZE_Msk (0x00000002UL) /*!< field TIMERSIZE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER1CONTROL_TIMERPRE_Pos (2UL) /*!< field TIMERPRE (bitOffset 2, bitWidth 2) */
#define DTIM_TIMER1CONTROL_TIMERPRE_Msk (0x0000000cUL) /*!< field TIMERPRE (Bitfield-Mask: 0x00000003) */
#define DTIM_TIMER1CONTROL_INTERRUPTENABLE_Pos (5UL) /*!< field INTERRUPTENABLE (bitOffset 5, bitWidth 1) */
#define DTIM_TIMER1CONTROL_INTERRUPTENABLE_Msk (0x00000020UL) /*!< field INTERRUPTENABLE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER1CONTROL_TIMERMODE_Pos (6UL) /*!< field TIMERMODE (bitOffset 6, bitWidth 1) */
#define DTIM_TIMER1CONTROL_TIMERMODE_Msk (0x00000040UL) /*!< field TIMERMODE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER1CONTROL_TIMERENABLE_Pos (7UL) /*!< field TIMERENABLE (bitOffset 7, bitWidth 1) */
#define DTIM_TIMER1CONTROL_TIMERENABLE_Msk (0x00000080UL) /*!< field TIMERENABLE (Bitfield-Mask: 0x00000001) */

/* ================================================== Register TIMER1INTCLR ================================================== */
#define DTIM_TIMER1INTCLR_TIMER1INTCLR_Pos (0UL) /*!< field TIMER1INTCLR (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER1INTCLR_TIMER1INTCLR_Msk (0x00000001UL) /*!< field TIMER1INTCLR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register TIMER1RIS =================================================== */
#define DTIM_TIMER1RIS_RAWTIMERINTERRUPT_Pos (0UL) /*!< field RAWTIMERINTERRUPT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER1RIS_RAWTIMERINTERRUPT_Msk (0x00000001UL) /*!< field RAWTIMERINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register TIMER1MIS =================================================== */
#define DTIM_TIMER1MIS_TIMERINTERRUPT_Pos (0UL) /*!< field TIMERINTERRUPT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER1MIS_TIMERINTERRUPT_Msk (0x00000001UL) /*!< field TIMERINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ================================================== Register TIMER1BGLOAD ================================================== */
#define DTIM_TIMER1BGLOAD_TIMER1BGLOAD_Pos (0UL) /*!< field TIMER1BGLOAD (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER1BGLOAD_TIMER1BGLOAD_Msk (0xffffffffUL) /*!< field TIMER1BGLOAD (Bitfield-Mask: 0xffffffff) */

/* =================================================== Register TIMER2LOAD =================================================== */
#define DTIM_TIMER2LOAD_TIMER2LOAD_Pos (0UL) /*!< field TIMER2LOAD (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER2LOAD_TIMER2LOAD_Msk (0xffffffffUL) /*!< field TIMER2LOAD (Bitfield-Mask: 0xffffffff) */

/* =================================================== Register TIMER2VALUE ================================================== */
#define DTIM_TIMER2VALUE_VALUE_Pos (0UL) /*!< field VALUE (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER2VALUE_VALUE_Msk (0xffffffffUL) /*!< field VALUE (Bitfield-Mask: 0xffffffff) */

/* ================================================== Register TIMER2CONTROL ================================================= */
#define DTIM_TIMER2CONTROL_ONESHOTCOUNT_Pos (0UL) /*!< field ONESHOTCOUNT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER2CONTROL_ONESHOTCOUNT_Msk (0x00000001UL) /*!< field ONESHOTCOUNT (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER2CONTROL_TIMERSIZE_Pos (1UL) /*!< field TIMERSIZE (bitOffset 1, bitWidth 1) */
#define DTIM_TIMER2CONTROL_TIMERSIZE_Msk (0x00000002UL) /*!< field TIMERSIZE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER2CONTROL_TIMERPRE_Pos (2UL) /*!< field TIMERPRE (bitOffset 2, bitWidth 2) */
#define DTIM_TIMER2CONTROL_TIMERPRE_Msk (0x0000000cUL) /*!< field TIMERPRE (Bitfield-Mask: 0x00000003) */
#define DTIM_TIMER2CONTROL_INTERRUPTENABLE_Pos (5UL) /*!< field INTERRUPTENABLE (bitOffset 5, bitWidth 1) */
#define DTIM_TIMER2CONTROL_INTERRUPTENABLE_Msk (0x00000020UL) /*!< field INTERRUPTENABLE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER2CONTROL_TIMERMODE_Pos (6UL) /*!< field TIMERMODE (bitOffset 6, bitWidth 1) */
#define DTIM_TIMER2CONTROL_TIMERMODE_Msk (0x00000040UL) /*!< field TIMERMODE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMER2CONTROL_TIMERENABLE_Pos (7UL) /*!< field TIMERENABLE (bitOffset 7, bitWidth 1) */
#define DTIM_TIMER2CONTROL_TIMERENABLE_Msk (0x00000080UL) /*!< field TIMERENABLE (Bitfield-Mask: 0x00000001) */

/* ================================================== Register TIMER2INTCLR ================================================== */
#define DTIM_TIMER2INTCLR_TIMER2INTCLR_Pos (0UL) /*!< field TIMER2INTCLR (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER2INTCLR_TIMER2INTCLR_Msk (0x00000001UL) /*!< field TIMER2INTCLR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register TIMER2RIS =================================================== */
#define DTIM_TIMER2RIS_RAWTIMERINTERRUPT_Pos (0UL) /*!< field RAWTIMERINTERRUPT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER2RIS_RAWTIMERINTERRUPT_Msk (0x00000001UL) /*!< field RAWTIMERINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register TIMER2MIS =================================================== */
#define DTIM_TIMER2MIS_TIMERINTERRUPT_Pos (0UL) /*!< field TIMERINTERRUPT (bitOffset 0, bitWidth 1) */
#define DTIM_TIMER2MIS_TIMERINTERRUPT_Msk (0x00000001UL) /*!< field TIMERINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ================================================== Register TIMER2BGLOAD ================================================== */
#define DTIM_TIMER2BGLOAD_TIMER2BGLOAD_Pos (0UL) /*!< field TIMER2BGLOAD (bitOffset 0, bitWidth 32) */
#define DTIM_TIMER2BGLOAD_TIMER2BGLOAD_Msk (0xffffffffUL) /*!< field TIMER2BGLOAD (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register TIMERITCR =================================================== */
#define DTIM_TIMERITCR_INTEGRATIONTESTMODEENABLE_Pos (0UL) /*!< field INTEGRATIONTESTMODEENABLE (bitOffset 0, bitWidth 1) */
#define DTIM_TIMERITCR_INTEGRATIONTESTMODEENABLE_Msk (0x00000001UL) /*!< field INTEGRATIONTESTMODEENABLE (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register TIMERITOP =================================================== */
#define DTIM_TIMERITOP_INTEGRATIONTESTTIMINT1VALUE_Pos (0UL) /*!< field INTEGRATIONTESTTIMINT1VALUE (bitOffset 0, bitWidth 1) */
#define DTIM_TIMERITOP_INTEGRATIONTESTTIMINT1VALUE_Msk (0x00000001UL) /*!< field INTEGRATIONTESTTIMINT1VALUE (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMERITOP_INTEGRATIONTESTTIMINT2VALUE_Pos (1UL) /*!< field INTEGRATIONTESTTIMINT2VALUE (bitOffset 1, bitWidth 1) */
#define DTIM_TIMERITOP_INTEGRATIONTESTTIMINT2VALUE_Msk (0x00000002UL) /*!< field INTEGRATIONTESTTIMINT2VALUE (Bitfield-Mask: 0x00000001) */

/* ================================================= Register TIMERPERIPHID4 ================================================= */
#define DTIM_TIMERPERIPHID4_JEP106_C_CODE_Pos (0UL) /*!< field JEP106_C_CODE (bitOffset 0, bitWidth 4) */
#define DTIM_TIMERPERIPHID4_JEP106_C_CODE_Msk (0x0000000fUL) /*!< field JEP106_C_CODE (Bitfield-Mask: 0x0000000f) */
#define DTIM_TIMERPERIPHID4_BLOCK_COUNT_Pos (4UL) /*!< field BLOCK_COUNT (bitOffset 4, bitWidth 4) */
#define DTIM_TIMERPERIPHID4_BLOCK_COUNT_Msk (0x000000f0UL) /*!< field BLOCK_COUNT (Bitfield-Mask: 0x0000000f) */

/* ================================================= Register TIMERPERIPHID5 ================================================= */
#define DTIM_TIMERPERIPHID5_TIMERPERIPHID5_Pos (0UL) /*!< field TIMERPERIPHID5 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPERIPHID5_TIMERPERIPHID5_Msk (0x000000ffUL) /*!< field TIMERPERIPHID5 (Bitfield-Mask: 0x000000ff) */

/* ================================================= Register TIMERPERIPHID6 ================================================= */
#define DTIM_TIMERPERIPHID6_TIMERPERIPHID6_Pos (0UL) /*!< field TIMERPERIPHID6 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPERIPHID6_TIMERPERIPHID6_Msk (0x000000ffUL) /*!< field TIMERPERIPHID6 (Bitfield-Mask: 0x000000ff) */

/* ================================================= Register TIMERPERIPHID7 ================================================= */
#define DTIM_TIMERPERIPHID7_TIMERPERIPHID7_Pos (0UL) /*!< field TIMERPERIPHID7 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPERIPHID7_TIMERPERIPHID7_Msk (0x000000ffUL) /*!< field TIMERPERIPHID7 (Bitfield-Mask: 0x000000ff) */

/* ================================================= Register TIMERPERIPHID0 ================================================= */
#define DTIM_TIMERPERIPHID0_TIMERPERIPHID0_Pos (0UL) /*!< field TIMERPERIPHID0 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPERIPHID0_TIMERPERIPHID0_Msk (0x000000ffUL) /*!< field TIMERPERIPHID0 (Bitfield-Mask: 0x000000ff) */

/* ================================================= Register TIMERPERIPHID1 ================================================= */
#define DTIM_TIMERPERIPHID1_PART_NUMBER_11_8_Pos (0UL) /*!< field PART_NUMBER_11_8 (bitOffset 0, bitWidth 4) */
#define DTIM_TIMERPERIPHID1_PART_NUMBER_11_8_Msk (0x0000000fUL) /*!< field PART_NUMBER_11_8 (Bitfield-Mask: 0x0000000f) */
#define DTIM_TIMERPERIPHID1_JEP106_ID_3_0_Pos (4UL) /*!< field JEP106_ID_3_0 (bitOffset 4, bitWidth 4) */
#define DTIM_TIMERPERIPHID1_JEP106_ID_3_0_Msk (0x000000f0UL) /*!< field JEP106_ID_3_0 (Bitfield-Mask: 0x0000000f) */

/* ================================================= Register TIMERPERIPHID2 ================================================= */
#define DTIM_TIMERPERIPHID2_JEP106_ID_6_4_Pos (0UL) /*!< field JEP106_ID_6_4 (bitOffset 0, bitWidth 3) */
#define DTIM_TIMERPERIPHID2_JEP106_ID_6_4_Msk (0x00000007UL) /*!< field JEP106_ID_6_4 (Bitfield-Mask: 0x00000007) */
#define DTIM_TIMERPERIPHID2_JEDEC_USED_Pos (3UL) /*!< field JEDEC_USED (bitOffset 3, bitWidth 1) */
#define DTIM_TIMERPERIPHID2_JEDEC_USED_Msk (0x00000008UL) /*!< field JEDEC_USED (Bitfield-Mask: 0x00000001) */
#define DTIM_TIMERPERIPHID2_REVISION_Pos (4UL) /*!< field REVISION (bitOffset 4, bitWidth 4) */
#define DTIM_TIMERPERIPHID2_REVISION_Msk (0x000000f0UL) /*!< field REVISION (Bitfield-Mask: 0x0000000f) */

/* ================================================= Register TIMERPERIPHID3 ================================================= */
#define DTIM_TIMERPERIPHID3_CUST_MOD_NUM_Pos (0UL) /*!< field CUST_MOD_NUM (bitOffset 0, bitWidth 4) */
#define DTIM_TIMERPERIPHID3_CUST_MOD_NUM_Msk (0x0000000fUL) /*!< field CUST_MOD_NUM (Bitfield-Mask: 0x0000000f) */
#define DTIM_TIMERPERIPHID3_ECO_REV_NUM_Pos (4UL) /*!< field ECO_REV_NUM (bitOffset 4, bitWidth 4) */
#define DTIM_TIMERPERIPHID3_ECO_REV_NUM_Msk (0x000000f0UL) /*!< field ECO_REV_NUM (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register TIMERPCELLID0 ================================================= */
#define DTIM_TIMERPCELLID0_TIMERPCELLID0_Pos (0UL) /*!< field TIMERPCELLID0 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPCELLID0_TIMERPCELLID0_Msk (0x000000ffUL) /*!< field TIMERPCELLID0 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register TIMERPCELLID1 ================================================= */
#define DTIM_TIMERPCELLID1_TIMERPCELLID1_Pos (0UL) /*!< field TIMERPCELLID1 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPCELLID1_TIMERPCELLID1_Msk (0x000000ffUL) /*!< field TIMERPCELLID1 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register TIMERPCELLID2 ================================================= */
#define DTIM_TIMERPCELLID2_TIMERPCELLID2_Pos (0UL) /*!< field TIMERPCELLID2 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPCELLID2_TIMERPCELLID2_Msk (0x000000ffUL) /*!< field TIMERPCELLID2 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register TIMERPCELLID3 ================================================= */
#define DTIM_TIMERPCELLID3_TIMERPCELLID3_Pos (0UL) /*!< field TIMERPCELLID3 (bitOffset 0, bitWidth 8) */
#define DTIM_TIMERPCELLID3_TIMERPCELLID3_Msk (0x000000ffUL) /*!< field TIMERPCELLID3 (Bitfield-Mask: 0x000000ff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MHU ================================================= */
/* =========================================================================================================================== */

/* ================================================== Register CPU0INTR_STAT ================================================= */
#define MHU_CPU0INTR_STAT_CPU0INTR_STAT_Pos (0UL) /*!< field CPU0INTR_STAT (bitOffset 0, bitWidth 4) */
#define MHU_CPU0INTR_STAT_CPU0INTR_STAT_Msk (0x0000000fUL) /*!< field CPU0INTR_STAT (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register CPU0INTR_SET ================================================== */
#define MHU_CPU0INTR_SET_CPU0INTR_SET_Pos (0UL) /*!< field CPU0INTR_SET (bitOffset 0, bitWidth 4) */
#define MHU_CPU0INTR_SET_CPU0INTR_SET_Msk (0x0000000fUL) /*!< field CPU0INTR_SET (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register CPU0INTR_CLR ================================================== */
#define MHU_CPU0INTR_CLR_CPU0INTR_CLR_Pos (0UL) /*!< field CPU0INTR_CLR (bitOffset 0, bitWidth 4) */
#define MHU_CPU0INTR_CLR_CPU0INTR_CLR_Msk (0x0000000fUL) /*!< field CPU0INTR_CLR (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register CPU1INTR_STAT ================================================= */
#define MHU_CPU1INTR_STAT_CPU1INTR_STAT_Pos (0UL) /*!< field CPU1INTR_STAT (bitOffset 0, bitWidth 4) */
#define MHU_CPU1INTR_STAT_CPU1INTR_STAT_Msk (0x0000000fUL) /*!< field CPU1INTR_STAT (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register CPU1INTR_SET ================================================== */
#define MHU_CPU1INTR_SET_CPU1INTR_SET_Pos (0UL) /*!< field CPU1INTR_SET (bitOffset 0, bitWidth 4) */
#define MHU_CPU1INTR_SET_CPU1INTR_SET_Msk (0x0000000fUL) /*!< field CPU1INTR_SET (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register CPU1INTR_CLR ================================================== */
#define MHU_CPU1INTR_CLR_CPU1INTR_CLR_Pos (0UL) /*!< field CPU1INTR_CLR (bitOffset 0, bitWidth 4) */
#define MHU_CPU1INTR_CLR_CPU1INTR_CLR_Msk (0x0000000fUL) /*!< field CPU1INTR_CLR (Bitfield-Mask: 0x0000000f) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: ICACHE =============================================== */
/* =========================================================================================================================== */

/* ==================================================== Register HWPARAMS ==================================================== */
#define ICACHE_HWPARAMS_CSIZE_Pos (0UL) /*!< field CSIZE (bitOffset 0, bitWidth 4) */
#define ICACHE_HWPARAMS_CSIZE_Msk (0x0000000fUL) /*!< field CSIZE (Bitfield-Mask: 0x0000000f) */
#define ICACHE_HWPARAMS_STATS_Pos (4UL) /*!< field STATS (bitOffset 4, bitWidth 1) */
#define ICACHE_HWPARAMS_STATS_Msk (0x00000010UL) /*!< field STATS (Bitfield-Mask: 0x00000001) */
#define ICACHE_HWPARAMS_DMA_Pos (5UL) /*!< field DMA (bitOffset 5, bitWidth 1) */
#define ICACHE_HWPARAMS_DMA_Msk (0x00000020UL) /*!< field DMA (Bitfield-Mask: 0x00000001) */
#define ICACHE_HWPARAMS_INVMAT_Pos (6UL) /*!< field INVMAT (bitOffset 6, bitWidth 1) */
#define ICACHE_HWPARAMS_INVMAT_Msk (0x00000040UL) /*!< field INVMAT (Bitfield-Mask: 0x00000001) */
#define ICACHE_HWPARAMS_COFFSIZE_Pos (12UL) /*!< field COFFSIZE (bitOffset 12, bitWidth 4) */
#define ICACHE_HWPARAMS_COFFSIZE_Msk (0x0000f000UL) /*!< field COFFSIZE (Bitfield-Mask: 0x0000000f) */
#define ICACHE_HWPARAMS_COFFSET_Pos (16UL) /*!< field COFFSET (bitOffset 16, bitWidth 16) */
#define ICACHE_HWPARAMS_COFFSET_Msk (0xffff0000UL) /*!< field COFFSET (Bitfield-Mask: 0x0000ffff) */

/* ====================================================== Register CTRL ====================================================== */
#define ICACHE_CTRL_CACHEEN_Pos (0UL) /*!< field CACHEEN (bitOffset 0, bitWidth 1) */
#define ICACHE_CTRL_CACHEEN_Msk (0x00000001UL) /*!< field CACHEEN (Bitfield-Mask: 0x00000001) */
#define ICACHE_CTRL_FINV_Pos (2UL) /*!< field FINV (bitOffset 2, bitWidth 1) */
#define ICACHE_CTRL_FINV_Msk (0x00000004UL) /*!< field FINV (Bitfield-Mask: 0x00000001) */
#define ICACHE_CTRL_STATEN_Pos (3UL) /*!< field STATEN (bitOffset 3, bitWidth 1) */
#define ICACHE_CTRL_STATEN_Msk (0x00000008UL) /*!< field STATEN (Bitfield-Mask: 0x00000001) */
#define ICACHE_CTRL_STATC_Pos (4UL) /*!< field STATC (bitOffset 4, bitWidth 1) */
#define ICACHE_CTRL_STATC_Msk (0x00000010UL) /*!< field STATC (Bitfield-Mask: 0x00000001) */
#define ICACHE_CTRL_HALLOC_Pos (5UL) /*!< field HALLOC (bitOffset 5, bitWidth 1) */
#define ICACHE_CTRL_HALLOC_Msk (0x00000020UL) /*!< field HALLOC (Bitfield-Mask: 0x00000001) */
#define ICACHE_CTRL_POINV_SMP_Pos (6UL) /*!< field POINV_SMP (bitOffset 6, bitWidth 1) */
#define ICACHE_CTRL_POINV_SMP_Msk (0x00000040UL) /*!< field POINV_SMP (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register IRQSTAT ==================================================== */
#define ICACHE_IRQSTAT_IC_Pos (0UL) /*!< field IC (bitOffset 0, bitWidth 1) */
#define ICACHE_IRQSTAT_IC_Msk (0x00000001UL) /*!< field IC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQSTAT_CDC_Pos (1UL) /*!< field CDC (bitOffset 1, bitWidth 1) */
#define ICACHE_IRQSTAT_CDC_Msk (0x00000002UL) /*!< field CDC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQSTAT_CEC_Pos (2UL) /*!< field CEC (bitOffset 2, bitWidth 1) */
#define ICACHE_IRQSTAT_CEC_Msk (0x00000004UL) /*!< field CEC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQSTAT_CFE_Pos (3UL) /*!< field CFE (bitOffset 3, bitWidth 1) */
#define ICACHE_IRQSTAT_CFE_Msk (0x00000008UL) /*!< field CFE (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQSTAT_SV_Pos (4UL) /*!< field SV (bitOffset 4, bitWidth 1) */
#define ICACHE_IRQSTAT_SV_Msk (0x00000010UL) /*!< field SV (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQSTAT_SS_Pos (5UL) /*!< field SS (bitOffset 5, bitWidth 1) */
#define ICACHE_IRQSTAT_SS_Msk (0x00000020UL) /*!< field SS (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register IRQCLR ===================================================== */
#define ICACHE_IRQCLR_IC_Pos (0UL) /*!< field IC (bitOffset 0, bitWidth 1) */
#define ICACHE_IRQCLR_IC_Msk (0x00000001UL) /*!< field IC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQCLR_CDC_Pos (1UL) /*!< field CDC (bitOffset 1, bitWidth 1) */
#define ICACHE_IRQCLR_CDC_Msk (0x00000002UL) /*!< field CDC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQCLR_CEC_Pos (2UL) /*!< field CEC (bitOffset 2, bitWidth 1) */
#define ICACHE_IRQCLR_CEC_Msk (0x00000004UL) /*!< field CEC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQCLR_CFE_Pos (3UL) /*!< field CFE (bitOffset 3, bitWidth 1) */
#define ICACHE_IRQCLR_CFE_Msk (0x00000008UL) /*!< field CFE (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQCLR_SV_Pos (4UL) /*!< field SV (bitOffset 4, bitWidth 1) */
#define ICACHE_IRQCLR_SV_Msk (0x00000010UL) /*!< field SV (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQCLR_SS_Pos (5UL) /*!< field SS (bitOffset 5, bitWidth 1) */
#define ICACHE_IRQCLR_SS_Msk (0x00000020UL) /*!< field SS (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register IRQEN ===================================================== */
#define ICACHE_IRQEN_IC_Pos (0UL) /*!< field IC (bitOffset 0, bitWidth 1) */
#define ICACHE_IRQEN_IC_Msk (0x00000001UL) /*!< field IC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQEN_CDC_Pos (1UL) /*!< field CDC (bitOffset 1, bitWidth 1) */
#define ICACHE_IRQEN_CDC_Msk (0x00000002UL) /*!< field CDC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQEN_CEC_Pos (2UL) /*!< field CEC (bitOffset 2, bitWidth 1) */
#define ICACHE_IRQEN_CEC_Msk (0x00000004UL) /*!< field CEC (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQEN_CFE_Pos (3UL) /*!< field CFE (bitOffset 3, bitWidth 1) */
#define ICACHE_IRQEN_CFE_Msk (0x00000008UL) /*!< field CFE (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQEN_SV_Pos (4UL) /*!< field SV (bitOffset 4, bitWidth 1) */
#define ICACHE_IRQEN_SV_Msk (0x00000010UL) /*!< field SV (Bitfield-Mask: 0x00000001) */
#define ICACHE_IRQEN_SS_Pos (5UL) /*!< field SS (bitOffset 5, bitWidth 1) */
#define ICACHE_IRQEN_SS_Msk (0x00000020UL) /*!< field SS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register DBGFILLERR =================================================== */
#define ICACHE_DBGFILLERR_ERRADDR_Pos (0UL) /*!< field ERRADDR (bitOffset 0, bitWidth 32) */
#define ICACHE_DBGFILLERR_ERRADDR_Msk (0xffffffffUL) /*!< field ERRADDR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register SH ======================================================= */
#define ICACHE_SH_CSH_Pos (0UL) /*!< field CSH (bitOffset 0, bitWidth 32) */
#define ICACHE_SH_CSH_Msk (0xffffffffUL) /*!< field CSH (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register SM ======================================================= */
#define ICACHE_SM_CSM_Pos (0UL) /*!< field CSM (bitOffset 0, bitWidth 32) */
#define ICACHE_SM_CSM_Msk (0xffffffffUL) /*!< field CSM (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register SUC ====================================================== */
#define ICACHE_SUC_CSUC_Pos (0UL) /*!< field CSUC (bitOffset 0, bitWidth 32) */
#define ICACHE_SUC_CSUC_Msk (0xffffffffUL) /*!< field CSUC (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_SECCTRL ============================================= */
/* =========================================================================================================================== */

/* ==================================================== Register CPUSECCFG =================================================== */
#define CPU_SECCTRL_CPUSECCFG_LOCKSVTAIRCR_Pos (0UL) /*!< field LOCKSVTAIRCR (bitOffset 0, bitWidth 1) */
#define CPU_SECCTRL_CPUSECCFG_LOCKSVTAIRCR_Msk (0x00000001UL) /*!< field LOCKSVTAIRCR (Bitfield-Mask: 0x00000001) */
#define CPU_SECCTRL_CPUSECCFG_LOCKSAU_Pos (1UL) /*!< field LOCKSAU (bitOffset 1, bitWidth 1) */
#define CPU_SECCTRL_CPUSECCFG_LOCKSAU_Msk (0x00000002UL) /*!< field LOCKSAU (Bitfield-Mask: 0x00000001) */



/* =========================================================================================================================== */
/* ============================================= Type of peripheral: CPU_IDENTITY ============================================ */
/* =========================================================================================================================== */

/* ====================================================== Register CPUID ===================================================== */
#define CPU_IDENTITY_CPUID_CPUID_Pos (0UL) /*!< field CPUID (bitOffset 0, bitWidth 4) */
#define CPU_IDENTITY_CPUID_CPUID_Msk (0x0000000fUL) /*!< field CPUID (Bitfield-Mask: 0x0000000f) */



/* =========================================================================================================================== */
/* =============================================== Type of peripheral: SYSINFO =============================================== */
/* =========================================================================================================================== */

/* =================================================== Register SYS_VERSION ================================================== */
#define SYSINFO_SYS_VERSION_PART_NUMBER_Pos (0UL) /*!< field PART_NUMBER (bitOffset 0, bitWidth 12) */
#define SYSINFO_SYS_VERSION_PART_NUMBER_Msk (0x00000fffUL) /*!< field PART_NUMBER (Bitfield-Mask: 0x00000fff) */
#define SYSINFO_SYS_VERSION_DESIGNER_ID_Pos (12UL) /*!< field DESIGNER_ID (bitOffset 12, bitWidth 8) */
#define SYSINFO_SYS_VERSION_DESIGNER_ID_Msk (0x000ff000UL) /*!< field DESIGNER_ID (Bitfield-Mask: 0x000000ff) */
#define SYSINFO_SYS_VERSION_MINOR_REVISION_Pos (20UL) /*!< field MINOR_REVISION (bitOffset 20, bitWidth 4) */
#define SYSINFO_SYS_VERSION_MINOR_REVISION_Msk (0x00f00000UL) /*!< field MINOR_REVISION (Bitfield-Mask: 0x0000000f) */
#define SYSINFO_SYS_VERSION_MAJOR_REVISION_Pos (24UL) /*!< field MAJOR_REVISION (bitOffset 24, bitWidth 4) */
#define SYSINFO_SYS_VERSION_MAJOR_REVISION_Msk (0x0f000000UL) /*!< field MAJOR_REVISION (Bitfield-Mask: 0x0000000f) */
#define SYSINFO_SYS_VERSION_CONFIGURATION_Pos (28UL) /*!< field CONFIGURATION (bitOffset 28, bitWidth 4) */
#define SYSINFO_SYS_VERSION_CONFIGURATION_Msk (0xf0000000UL) /*!< field CONFIGURATION (Bitfield-Mask: 0x0000000f) */

/* ====================================================== Register UID0 ====================================================== */
#define SYSINFO_UID0_UID0_Pos (0UL) /*!< field UID0 (bitOffset 0, bitWidth 32) */
#define SYSINFO_UID0_UID0_Msk (0xffffffffUL) /*!< field UID0 (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register UID1 ====================================================== */
#define SYSINFO_UID1_UID1_Pos (0UL) /*!< field UID1 (bitOffset 0, bitWidth 32) */
#define SYSINFO_UID1_UID1_Msk (0xffffffffUL) /*!< field UID1 (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register UID2 ====================================================== */
#define SYSINFO_UID2_UID2_Pos (0UL) /*!< field UID2 (bitOffset 0, bitWidth 32) */
#define SYSINFO_UID2_UID2_Msk (0xffffffffUL) /*!< field UID2 (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register UID3 ====================================================== */
#define SYSINFO_UID3_UID3_Pos (0UL) /*!< field UID3 (bitOffset 0, bitWidth 32) */
#define SYSINFO_UID3_UID3_Msk (0xffffffffUL) /*!< field UID3 (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SYSCTR =============================================== */
/* =========================================================================================================================== */

/* =================================================== Register SECDBGSTAT =================================================== */
#define SYSCTR_SECDBGSTAT_DBGEN_STATUS_Pos (0UL) /*!< field DBGEN_STATUS (bitOffset 0, bitWidth 1) */
#define SYSCTR_SECDBGSTAT_DBGEN_STATUS_Msk (0x00000001UL) /*!< field DBGEN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SECDBGSTAT_NIDEN_STATUS_Pos (2UL) /*!< field NIDEN_STATUS (bitOffset 2, bitWidth 1) */
#define SYSCTR_SECDBGSTAT_NIDEN_STATUS_Msk (0x00000004UL) /*!< field NIDEN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SECDBGSTAT_SPIDEN_STATUS_Pos (4UL) /*!< field SPIDEN_STATUS (bitOffset 4, bitWidth 1) */
#define SYSCTR_SECDBGSTAT_SPIDEN_STATUS_Msk (0x00000010UL) /*!< field SPIDEN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SECDBGSTAT_SPNIDEN_STATUS_Pos (6UL) /*!< field SPNIDEN_STATUS (bitOffset 6, bitWidth 1) */
#define SYSCTR_SECDBGSTAT_SPNIDEN_STATUS_Msk (0x00000040UL) /*!< field SPNIDEN_STATUS (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register SCSECCTRL =================================================== */
#define SYSCTR_SCSECCTRL_CERTDISABLE_Pos (0UL) /*!< field CERTDISABLE (bitOffset 0, bitWidth 1) */
#define SYSCTR_SCSECCTRL_CERTDISABLE_Msk (0x00000001UL) /*!< field CERTDISABLE (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SCSECCTRL_CERTREADEN_Pos (1UL) /*!< field CERTREADEN (bitOffset 1, bitWidth 1) */
#define SYSCTR_SCSECCTRL_CERTREADEN_Msk (0x00000002UL) /*!< field CERTREADEN (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SCSECCTRL_SCSECCFGLOCK_Pos (2UL) /*!< field SCSECCFGLOCK (bitOffset 2, bitWidth 1) */
#define SYSCTR_SCSECCTRL_SCSECCFGLOCK_Msk (0x00000004UL) /*!< field SCSECCFGLOCK (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SCSECCTRL_CERTDISABLED_Pos (16UL) /*!< field CERTDISABLED (bitOffset 16, bitWidth 1) */
#define SYSCTR_SCSECCTRL_CERTDISABLED_Msk (0x00010000UL) /*!< field CERTDISABLED (Bitfield-Mask: 0x00000001) */
#define SYSCTR_SCSECCTRL_CERTREADENABLED_Pos (17UL) /*!< field CERTREADENABLED (bitOffset 17, bitWidth 1) */
#define SYSCTR_SCSECCTRL_CERTREADENABLED_Msk (0x00020000UL) /*!< field CERTREADENABLED (Bitfield-Mask: 0x00000001) */

/* ================================================= Register RESET_SYNDROME ================================================= */
#define SYSCTR_RESET_SYNDROME_POR_Pos (0UL) /*!< field POR (bitOffset 0, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_POR_Msk (0x00000001UL) /*!< field POR (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_NSWDT_Pos (1UL) /*!< field NSWDT (bitOffset 1, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_NSWDT_Msk (0x00000002UL) /*!< field NSWDT (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_SWDT_Pos (2UL) /*!< field SWDT (bitOffset 2, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_SWDT_Msk (0x00000004UL) /*!< field SWDT (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_LPWDT_Pos (3UL) /*!< field LPWDT (bitOffset 3, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_LPWDT_Msk (0x00000008UL) /*!< field LPWDT (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_SYSRESETREQ0_Pos (4UL) /*!< field SYSRESETREQ0 (bitOffset 4, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_SYSRESETREQ0_Msk (0x00000010UL) /*!< field SYSRESETREQ0 (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_SYSRESETREQ1_Pos (5UL) /*!< field SYSRESETREQ1 (bitOffset 5, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_SYSRESETREQ1_Msk (0x00000020UL) /*!< field SYSRESETREQ1 (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_LOCKUP0_Pos (6UL) /*!< field LOCKUP0 (bitOffset 6, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_LOCKUP0_Msk (0x00000040UL) /*!< field LOCKUP0 (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_LOCKUP1_Pos (7UL) /*!< field LOCKUP1 (bitOffset 7, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_LOCKUP1_Msk (0x00000080UL) /*!< field LOCKUP1 (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_SYNDROME_SWRESETREQ_Pos (9UL) /*!< field SWRESETREQ (bitOffset 9, bitWidth 1) */
#define SYSCTR_RESET_SYNDROME_SWRESETREQ_Msk (0x00000200UL) /*!< field SWRESETREQ (Bitfield-Mask: 0x00000001) */

/* =================================================== Register RESET_MASK =================================================== */
#define SYSCTR_RESET_MASK_NSWDT_EN_Pos (1UL) /*!< field NSWDT_EN (bitOffset 1, bitWidth 1) */
#define SYSCTR_RESET_MASK_NSWDT_EN_Msk (0x00000002UL) /*!< field NSWDT_EN (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_MASK_SYSRESETREQ0_EN_Pos (4UL) /*!< field SYSRESETREQ0_EN (bitOffset 4, bitWidth 1) */
#define SYSCTR_RESET_MASK_SYSRESETREQ0_EN_Msk (0x00000010UL) /*!< field SYSRESETREQ0_EN (Bitfield-Mask: 0x00000001) */
#define SYSCTR_RESET_MASK_SYSRESETREQ1_EN_Pos (5UL) /*!< field SYSRESETREQ1_EN (bitOffset 5, bitWidth 1) */
#define SYSCTR_RESET_MASK_SYSRESETREQ1_EN_Msk (0x00000020UL) /*!< field SYSRESETREQ1_EN (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register SWRESET ==================================================== */
#define SYSCTR_SWRESET_SWRESETREQ_Pos (9UL) /*!< field SWRESETREQ (bitOffset 9, bitWidth 1) */
#define SYSCTR_SWRESET_SWRESETREQ_Msk (0x00000200UL) /*!< field SWRESETREQ (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register GRETREG ==================================================== */
#define SYSCTR_GRETREG_GRETREG_Pos (0UL) /*!< field GRETREG (bitOffset 0, bitWidth 16) */
#define SYSCTR_GRETREG_GRETREG_Msk (0x0000ffffUL) /*!< field GRETREG (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INITSVTOR0 =================================================== */
#define SYSCTR_INITSVTOR0_INITSVTOR0_Pos (7UL) /*!< field INITSVTOR0 (bitOffset 7, bitWidth 25) */
#define SYSCTR_INITSVTOR0_INITSVTOR0_Msk (0xffffff80UL) /*!< field INITSVTOR0 (Bitfield-Mask: 0x01ffffff) */

/* =================================================== Register INITSVTOR1 =================================================== */
#define SYSCTR_INITSVTOR1_INITSVTOR1_Pos (7UL) /*!< field INITSVTOR1 (bitOffset 7, bitWidth 25) */
#define SYSCTR_INITSVTOR1_INITSVTOR1_Msk (0xffffff80UL) /*!< field INITSVTOR1 (Bitfield-Mask: 0x01ffffff) */

/* ===================================================== Register CPUWAIT ==================================================== */
#define SYSCTR_CPUWAIT_CPU0WAIT_Pos (0UL) /*!< field CPU0WAIT (bitOffset 0, bitWidth 1) */
#define SYSCTR_CPUWAIT_CPU0WAIT_Msk (0x00000001UL) /*!< field CPU0WAIT (Bitfield-Mask: 0x00000001) */
#define SYSCTR_CPUWAIT_CPU1WAIT_Pos (1UL) /*!< field CPU1WAIT (bitOffset 1, bitWidth 1) */
#define SYSCTR_CPUWAIT_CPU1WAIT_Msk (0x00000002UL) /*!< field CPU1WAIT (Bitfield-Mask: 0x00000001) */

/* =================================================== Register NMI_ENABLE =================================================== */
#define SYSCTR_NMI_ENABLE_CPU0_NMI_ENABLE_Pos (0UL) /*!< field CPU0_NMI_ENABLE (bitOffset 0, bitWidth 1) */
#define SYSCTR_NMI_ENABLE_CPU0_NMI_ENABLE_Msk (0x00000001UL) /*!< field CPU0_NMI_ENABLE (Bitfield-Mask: 0x00000001) */
#define SYSCTR_NMI_ENABLE_CPU1_NMI_ENABLE_Pos (1UL) /*!< field CPU1_NMI_ENABLE (bitOffset 1, bitWidth 1) */
#define SYSCTR_NMI_ENABLE_CPU1_NMI_ENABLE_Msk (0x00000002UL) /*!< field CPU1_NMI_ENABLE (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register WICCTRL ==================================================== */
#define SYSCTR_WICCTRL_CPU0WICEN_STATUS_Pos (0UL) /*!< field CPU0WICEN_STATUS (bitOffset 0, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU0WICEN_STATUS_Msk (0x00000001UL) /*!< field CPU0WICEN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU1WICEN_STATUS_Pos (1UL) /*!< field CPU1WICEN_STATUS (bitOffset 1, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU1WICEN_STATUS_Msk (0x00000002UL) /*!< field CPU1WICEN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU0WICEN_SET_Pos (4UL) /*!< field CPU0WICEN_SET (bitOffset 4, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU0WICEN_SET_Msk (0x00000010UL) /*!< field CPU0WICEN_SET (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU1WICEN_SET_Pos (5UL) /*!< field CPU1WICEN_SET (bitOffset 5, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU1WICEN_SET_Msk (0x00000020UL) /*!< field CPU1WICEN_SET (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU0WICEN_CLR_Pos (8UL) /*!< field CPU0WICEN_CLR (bitOffset 8, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU0WICEN_CLR_Msk (0x00000100UL) /*!< field CPU0WICEN_CLR (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU1WICEN_CLR_Pos (9UL) /*!< field CPU1WICEN_CLR (bitOffset 9, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU1WICEN_CLR_Msk (0x00000200UL) /*!< field CPU1WICEN_CLR (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU0WICRDY_Pos (16UL) /*!< field CPU0WICRDY (bitOffset 16, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU0WICRDY_Msk (0x00010000UL) /*!< field CPU0WICRDY (Bitfield-Mask: 0x00000001) */
#define SYSCTR_WICCTRL_CPU1WICRDY_Pos (17UL) /*!< field CPU1WICRDY (bitOffset 17, bitWidth 1) */
#define SYSCTR_WICCTRL_CPU1WICRDY_Msk (0x00020000UL) /*!< field CPU1WICRDY (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register EWCCTRL ==================================================== */
#define SYSCTR_EWCCTRL_EWC0EN_STATUS_Pos (0UL) /*!< field EWC0EN_STATUS (bitOffset 0, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC0EN_STATUS_Msk (0x00000001UL) /*!< field EWC0EN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_EWCCTRL_EWC1EN_STATUS_Pos (1UL) /*!< field EWC1EN_STATUS (bitOffset 1, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC1EN_STATUS_Msk (0x00000002UL) /*!< field EWC1EN_STATUS (Bitfield-Mask: 0x00000001) */
#define SYSCTR_EWCCTRL_EWC0EN_SET_Pos (4UL) /*!< field EWC0EN_SET (bitOffset 4, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC0EN_SET_Msk (0x00000010UL) /*!< field EWC0EN_SET (Bitfield-Mask: 0x00000001) */
#define SYSCTR_EWCCTRL_EWC1EN_SET_Pos (5UL) /*!< field EWC1EN_SET (bitOffset 5, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC1EN_SET_Msk (0x00000020UL) /*!< field EWC1EN_SET (Bitfield-Mask: 0x00000001) */
#define SYSCTR_EWCCTRL_EWC0EN_CLR_Pos (8UL) /*!< field EWC0EN_CLR (bitOffset 8, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC0EN_CLR_Msk (0x00000100UL) /*!< field EWC0EN_CLR (Bitfield-Mask: 0x00000001) */
#define SYSCTR_EWCCTRL_EWC1EN_CLR_Pos (9UL) /*!< field EWC1EN_CLR (bitOffset 9, bitWidth 1) */
#define SYSCTR_EWCCTRL_EWC1EN_CLR_Msk (0x00000200UL) /*!< field EWC1EN_CLR (Bitfield-Mask: 0x00000001) */

/* ================================================= Register PDCM_SYS_SENSE ================================================= */
#define SYSCTR_PDCM_SYS_SENSE_S_PD_SYS_ON_Pos (0UL) /*!< field S_PD_SYS_ON (bitOffset 0, bitWidth 1) */
#define SYSCTR_PDCM_SYS_SENSE_S_PD_SYS_ON_Msk (0x00000001UL) /*!< field S_PD_SYS_ON (Bitfield-Mask: 0x00000001) */

/* ================================================ Register PDCM_SRAM0_SENSE ================================================ */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_SYS_ON_Pos (0UL) /*!< field S_PD_SYS_ON (bitOffset 0, bitWidth 1) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_SYS_ON_Msk (0x00000001UL) /*!< field S_PD_SYS_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_CPU0_ON_Pos (1UL) /*!< field S_PD_CPU0_ON (bitOffset 1, bitWidth 1) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_CPU0_ON_Msk (0x00000002UL) /*!< field S_PD_CPU0_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_CPU1_ON_Pos (2UL) /*!< field S_PD_CPU1_ON (bitOffset 2, bitWidth 1) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_CPU1_ON_Msk (0x00000004UL) /*!< field S_PD_CPU1_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_SRAM0_ON_Pos (3UL) /*!< field S_PD_SRAM0_ON (bitOffset 3, bitWidth 1) */
#define SYSCTR_PDCM_SRAM0_SENSE_S_PD_SRAM0_ON_Msk (0x00000008UL) /*!< field S_PD_SRAM0_ON (Bitfield-Mask: 0x00000001) */

/* ================================================ Register PDCM_SRAM1_SENSE ================================================ */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_SYS_ON_Pos (0UL) /*!< field S_PD_SYS_ON (bitOffset 0, bitWidth 1) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_SYS_ON_Msk (0x00000001UL) /*!< field S_PD_SYS_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_CPU0_ON_Pos (1UL) /*!< field S_PD_CPU0_ON (bitOffset 1, bitWidth 1) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_CPU0_ON_Msk (0x00000002UL) /*!< field S_PD_CPU0_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_CPU1_ON_Pos (2UL) /*!< field S_PD_CPU1_ON (bitOffset 2, bitWidth 1) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_CPU1_ON_Msk (0x00000004UL) /*!< field S_PD_CPU1_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_SRAM1_ON_Pos (4UL) /*!< field S_PD_SRAM1_ON (bitOffset 4, bitWidth 1) */
#define SYSCTR_PDCM_SRAM1_SENSE_S_PD_SRAM1_ON_Msk (0x00000010UL) /*!< field S_PD_SRAM1_ON (Bitfield-Mask: 0x00000001) */

/* ================================================ Register PDCM_SRAM2_SENSE ================================================ */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_SYS_ON_Pos (0UL) /*!< field S_PD_SYS_ON (bitOffset 0, bitWidth 1) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_SYS_ON_Msk (0x00000001UL) /*!< field S_PD_SYS_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_CPU0_ON_Pos (1UL) /*!< field S_PD_CPU0_ON (bitOffset 1, bitWidth 1) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_CPU0_ON_Msk (0x00000002UL) /*!< field S_PD_CPU0_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_CPU1_ON_Pos (2UL) /*!< field S_PD_CPU1_ON (bitOffset 2, bitWidth 1) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_CPU1_ON_Msk (0x00000004UL) /*!< field S_PD_CPU1_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_SRAM2_ON_Pos (5UL) /*!< field S_PD_SRAM2_ON (bitOffset 5, bitWidth 1) */
#define SYSCTR_PDCM_SRAM2_SENSE_S_PD_SRAM2_ON_Msk (0x00000020UL) /*!< field S_PD_SRAM2_ON (Bitfield-Mask: 0x00000001) */

/* ================================================ Register PDCM_SRAM3_SENSE ================================================ */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_SYS_ON_Pos (0UL) /*!< field S_PD_SYS_ON (bitOffset 0, bitWidth 1) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_SYS_ON_Msk (0x00000001UL) /*!< field S_PD_SYS_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_CPU0_ON_Pos (1UL) /*!< field S_PD_CPU0_ON (bitOffset 1, bitWidth 1) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_CPU0_ON_Msk (0x00000002UL) /*!< field S_PD_CPU0_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_CPU1_ON_Pos (2UL) /*!< field S_PD_CPU1_ON (bitOffset 2, bitWidth 1) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_CPU1_ON_Msk (0x00000004UL) /*!< field S_PD_CPU1_ON (Bitfield-Mask: 0x00000001) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_SRAM3_ON_Pos (6UL) /*!< field S_PD_SRAM3_ON (bitOffset 6, bitWidth 1) */
#define SYSCTR_PDCM_SRAM3_SENSE_S_PD_SRAM3_ON_Msk (0x00000040UL) /*!< field S_PD_SRAM3_ON (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register PIDR4 ===================================================== */
#define SYSCTR_PIDR4_PIDR4_Pos (0UL) /*!< field PIDR4 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR4_PIDR4_Msk (0x000000ffUL) /*!< field PIDR4 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR5 ===================================================== */
#define SYSCTR_PIDR5_PIDR5_Pos (0UL) /*!< field PIDR5 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR5_PIDR5_Msk (0x000000ffUL) /*!< field PIDR5 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR6 ===================================================== */
#define SYSCTR_PIDR6_PIDR6_Pos (0UL) /*!< field PIDR6 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR6_PIDR6_Msk (0x000000ffUL) /*!< field PIDR6 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR7 ===================================================== */
#define SYSCTR_PIDR7_PIDR7_Pos (0UL) /*!< field PIDR7 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR7_PIDR7_Msk (0x000000ffUL) /*!< field PIDR7 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR0 ===================================================== */
#define SYSCTR_PIDR0_PIDR0_Pos (0UL) /*!< field PIDR0 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR0_PIDR0_Msk (0x000000ffUL) /*!< field PIDR0 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR1 ===================================================== */
#define SYSCTR_PIDR1_PIDR1_Pos (0UL) /*!< field PIDR1 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR1_PIDR1_Msk (0x000000ffUL) /*!< field PIDR1 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR2 ===================================================== */
#define SYSCTR_PIDR2_PIDR2_Pos (0UL) /*!< field PIDR2 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR2_PIDR2_Msk (0x000000ffUL) /*!< field PIDR2 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PIDR3 ===================================================== */
#define SYSCTR_PIDR3_PIDR3_Pos (0UL) /*!< field PIDR3 (bitOffset 0, bitWidth 8) */
#define SYSCTR_PIDR3_PIDR3_Msk (0x000000ffUL) /*!< field PIDR3 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CIDR0 ===================================================== */
#define SYSCTR_CIDR0_CIDR0_Pos (0UL) /*!< field CIDR0 (bitOffset 0, bitWidth 8) */
#define SYSCTR_CIDR0_CIDR0_Msk (0x000000ffUL) /*!< field CIDR0 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CIDR1 ===================================================== */
#define SYSCTR_CIDR1_CIDR1_Pos (0UL) /*!< field CIDR1 (bitOffset 0, bitWidth 8) */
#define SYSCTR_CIDR1_CIDR1_Msk (0x000000ffUL) /*!< field CIDR1 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CIDR2 ===================================================== */
#define SYSCTR_CIDR2_CIDR2_Pos (0UL) /*!< field CIDR2 (bitOffset 0, bitWidth 8) */
#define SYSCTR_CIDR2_CIDR2_Msk (0x000000ffUL) /*!< field CIDR2 (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register CIDR3 ===================================================== */
#define SYSCTR_CIDR3_CIDR3_Pos (0UL) /*!< field CIDR3 (bitOffset 0, bitWidth 8) */
#define SYSCTR_CIDR3_CIDR3_Msk (0x000000ffUL) /*!< field CIDR3 (Bitfield-Mask: 0x000000ff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: PPU ================================================= */
/* =========================================================================================================================== */

/* ====================================================== Register PWPR ====================================================== */
#define PPU_PWPR_PWR_POLICY_Pos (0UL) /*!< field PWR_POLICY (bitOffset 0, bitWidth 4) */
#define PPU_PWPR_PWR_POLICY_Msk (0x0000000fUL) /*!< field PWR_POLICY (Bitfield-Mask: 0x0000000f) */
#define PPU_PWPR_PWR_DYN_EN_Pos (8UL) /*!< field PWR_DYN_EN (bitOffset 8, bitWidth 1) */
#define PPU_PWPR_PWR_DYN_EN_Msk (0x00000100UL) /*!< field PWR_DYN_EN (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register PWSR ====================================================== */
#define PPU_PWSR_PWR_STATUS_Pos (0UL) /*!< field PWR_STATUS (bitOffset 0, bitWidth 4) */
#define PPU_PWSR_PWR_STATUS_Msk (0x0000000fUL) /*!< field PWR_STATUS (Bitfield-Mask: 0x0000000f) */
#define PPU_PWSR_PWR_DYN_STATUS_Pos (8UL) /*!< field PWR_DYN_STATUS (bitOffset 8, bitWidth 1) */
#define PPU_PWSR_PWR_DYN_STATUS_Msk (0x00000100UL) /*!< field PWR_DYN_STATUS (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register DISR ====================================================== */
#define PPU_DISR_PWR_DEVACTIVE_STATUS_Pos (0UL) /*!< field PWR_DEVACTIVE_STATUS (bitOffset 0, bitWidth 11) */
#define PPU_DISR_PWR_DEVACTIVE_STATUS_Msk (0x000007ffUL) /*!< field PWR_DEVACTIVE_STATUS (Bitfield-Mask: 0x000007ff) */

/* ====================================================== Register MISR ====================================================== */
#define PPU_MISR_PCSMPACCEPT_STATUS_Pos (0UL) /*!< field PCSMPACCEPT_STATUS (bitOffset 0, bitWidth 1) */
#define PPU_MISR_PCSMPACCEPT_STATUS_Msk (0x00000001UL) /*!< field PCSMPACCEPT_STATUS (Bitfield-Mask: 0x00000001) */
#define PPU_MISR_DEVACCEPT_STATUS_Pos (8UL) /*!< field DEVACCEPT_STATUS (bitOffset 8, bitWidth 8) */
#define PPU_MISR_DEVACCEPT_STATUS_Msk (0x0000ff00UL) /*!< field DEVACCEPT_STATUS (Bitfield-Mask: 0x000000ff) */
#define PPU_MISR_DEVDENY_STATUS_Pos (16UL) /*!< field DEVDENY_STATUS (bitOffset 16, bitWidth 8) */
#define PPU_MISR_DEVDENY_STATUS_Msk (0x00ff0000UL) /*!< field DEVDENY_STATUS (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register STSR ====================================================== */
#define PPU_STSR_STORED_DEVDENY_Pos (0UL) /*!< field STORED_DEVDENY (bitOffset 0, bitWidth 8) */
#define PPU_STSR_STORED_DEVDENY_Msk (0x000000ffUL) /*!< field STORED_DEVDENY (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register PWCR ====================================================== */
#define PPU_PWCR_DEVREQEN_Pos (0UL) /*!< field DEVREQEN (bitOffset 0, bitWidth 8) */
#define PPU_PWCR_DEVREQEN_Msk (0x000000ffUL) /*!< field DEVREQEN (Bitfield-Mask: 0x000000ff) */
#define PPU_PWCR_PWR_DEVACTIVEEN_Pos (8UL) /*!< field PWR_DEVACTIVEEN (bitOffset 8, bitWidth 11) */
#define PPU_PWCR_PWR_DEVACTIVEEN_Msk (0x0007ff00UL) /*!< field PWR_DEVACTIVEEN (Bitfield-Mask: 0x000007ff) */

/* ======================================================= Register IMR ====================================================== */
#define PPU_IMR_STA_POLICY_TRN_IRQ_MASK_Pos (0UL) /*!< field STA_POLICY_TRN_IRQ_MASK (bitOffset 0, bitWidth 1) */
#define PPU_IMR_STA_POLICY_TRN_IRQ_MASK_Msk (0x00000001UL) /*!< field STA_POLICY_TRN_IRQ_MASK (Bitfield-Mask: 0x00000001) */
#define PPU_IMR_STA_ACCEPT_IRQ_MASK_Pos (1UL) /*!< field STA_ACCEPT_IRQ_MASK (bitOffset 1, bitWidth 1) */
#define PPU_IMR_STA_ACCEPT_IRQ_MASK_Msk (0x00000002UL) /*!< field STA_ACCEPT_IRQ_MASK (Bitfield-Mask: 0x00000001) */
#define PPU_IMR_STA_DENY_IRQ_MASK_Pos (2UL) /*!< field STA_DENY_IRQ_MASK (bitOffset 2, bitWidth 1) */
#define PPU_IMR_STA_DENY_IRQ_MASK_Msk (0x00000004UL) /*!< field STA_DENY_IRQ_MASK (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register AIMR ====================================================== */
#define PPU_AIMR_UNSPT_POLICY_IRQ_MASK_Pos (0UL) /*!< field UNSPT_POLICY_IRQ_MASK (bitOffset 0, bitWidth 1) */
#define PPU_AIMR_UNSPT_POLICY_IRQ_MASK_Msk (0x00000001UL) /*!< field UNSPT_POLICY_IRQ_MASK (Bitfield-Mask: 0x00000001) */
#define PPU_AIMR_DYN_ACCEPT_IRQ_MASK_Pos (1UL) /*!< field DYN_ACCEPT_IRQ_MASK (bitOffset 1, bitWidth 1) */
#define PPU_AIMR_DYN_ACCEPT_IRQ_MASK_Msk (0x00000002UL) /*!< field DYN_ACCEPT_IRQ_MASK (Bitfield-Mask: 0x00000001) */
#define PPU_AIMR_DYN_DENY_IRQ_MASK_Pos (2UL) /*!< field DYN_DENY_IRQ_MASK (bitOffset 2, bitWidth 1) */
#define PPU_AIMR_DYN_DENY_IRQ_MASK_Msk (0x00000004UL) /*!< field DYN_DENY_IRQ_MASK (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register ISR ====================================================== */
#define PPU_ISR_STA_POLICY_TRN_IRQ_Pos (0UL) /*!< field STA_POLICY_TRN_IRQ (bitOffset 0, bitWidth 1) */
#define PPU_ISR_STA_POLICY_TRN_IRQ_Msk (0x00000001UL) /*!< field STA_POLICY_TRN_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_ISR_STA_ACCEPT_IRQ_Pos (1UL) /*!< field STA_ACCEPT_IRQ (bitOffset 1, bitWidth 1) */
#define PPU_ISR_STA_ACCEPT_IRQ_Msk (0x00000002UL) /*!< field STA_ACCEPT_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_ISR_STA_DENY_IRQ_Pos (2UL) /*!< field STA_DENY_IRQ (bitOffset 2, bitWidth 1) */
#define PPU_ISR_STA_DENY_IRQ_Msk (0x00000004UL) /*!< field STA_DENY_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_ISR_OTHER_IRQ_Pos (7UL) /*!< field OTHER_IRQ (bitOffset 7, bitWidth 1) */
#define PPU_ISR_OTHER_IRQ_Msk (0x00000080UL) /*!< field OTHER_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_ISR_PWR_ACTIVE_EDGE_IRQ_Pos (8UL) /*!< field PWR_ACTIVE_EDGE_IRQ (bitOffset 8, bitWidth 11) */
#define PPU_ISR_PWR_ACTIVE_EDGE_IRQ_Msk (0x0007ff00UL) /*!< field PWR_ACTIVE_EDGE_IRQ (Bitfield-Mask: 0x000007ff) */

/* ====================================================== Register AISR ====================================================== */
#define PPU_AISR_UNSPT_POLICY_IRQ_Pos (0UL) /*!< field UNSPT_POLICY_IRQ (bitOffset 0, bitWidth 1) */
#define PPU_AISR_UNSPT_POLICY_IRQ_Msk (0x00000001UL) /*!< field UNSPT_POLICY_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_AISR_DYN_ACCEPT_IRQ_Pos (1UL) /*!< field DYN_ACCEPT_IRQ (bitOffset 1, bitWidth 1) */
#define PPU_AISR_DYN_ACCEPT_IRQ_Msk (0x00000002UL) /*!< field DYN_ACCEPT_IRQ (Bitfield-Mask: 0x00000001) */
#define PPU_AISR_DYN_DENY_IRQ_Pos (2UL) /*!< field DYN_DENY_IRQ (bitOffset 2, bitWidth 1) */
#define PPU_AISR_DYN_DENY_IRQ_Msk (0x00000004UL) /*!< field DYN_DENY_IRQ (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register IESR ====================================================== */
#define PPU_IESR_DEVACTIVE00_EDGE_Pos (0UL) /*!< field DEVACTIVE00_EDGE (bitOffset 0, bitWidth 2) */
#define PPU_IESR_DEVACTIVE00_EDGE_Msk (0x00000003UL) /*!< field DEVACTIVE00_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE01_EDGE_Pos (2UL) /*!< field DEVACTIVE01_EDGE (bitOffset 2, bitWidth 2) */
#define PPU_IESR_DEVACTIVE01_EDGE_Msk (0x0000000cUL) /*!< field DEVACTIVE01_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE02_EDGE_Pos (4UL) /*!< field DEVACTIVE02_EDGE (bitOffset 4, bitWidth 2) */
#define PPU_IESR_DEVACTIVE02_EDGE_Msk (0x00000030UL) /*!< field DEVACTIVE02_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE03_EDGE_Pos (6UL) /*!< field DEVACTIVE03_EDGE (bitOffset 6, bitWidth 2) */
#define PPU_IESR_DEVACTIVE03_EDGE_Msk (0x000000c0UL) /*!< field DEVACTIVE03_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE04_EDGE_Pos (8UL) /*!< field DEVACTIVE04_EDGE (bitOffset 8, bitWidth 2) */
#define PPU_IESR_DEVACTIVE04_EDGE_Msk (0x00000300UL) /*!< field DEVACTIVE04_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE05_EDGE_Pos (10UL) /*!< field DEVACTIVE05_EDGE (bitOffset 10, bitWidth 2) */
#define PPU_IESR_DEVACTIVE05_EDGE_Msk (0x00000c00UL) /*!< field DEVACTIVE05_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE06_EDGE_Pos (12UL) /*!< field DEVACTIVE06_EDGE (bitOffset 12, bitWidth 2) */
#define PPU_IESR_DEVACTIVE06_EDGE_Msk (0x00003000UL) /*!< field DEVACTIVE06_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE07_EDGE_Pos (14UL) /*!< field DEVACTIVE07_EDGE (bitOffset 14, bitWidth 2) */
#define PPU_IESR_DEVACTIVE07_EDGE_Msk (0x0000c000UL) /*!< field DEVACTIVE07_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE08_EDGE_Pos (16UL) /*!< field DEVACTIVE08_EDGE (bitOffset 16, bitWidth 2) */
#define PPU_IESR_DEVACTIVE08_EDGE_Msk (0x00030000UL) /*!< field DEVACTIVE08_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE09_EDGE_Pos (18UL) /*!< field DEVACTIVE09_EDGE (bitOffset 18, bitWidth 2) */
#define PPU_IESR_DEVACTIVE09_EDGE_Msk (0x000c0000UL) /*!< field DEVACTIVE09_EDGE (Bitfield-Mask: 0x00000003) */
#define PPU_IESR_DEVACTIVE10_EDGE_Pos (20UL) /*!< field DEVACTIVE10_EDGE (bitOffset 20, bitWidth 2) */
#define PPU_IESR_DEVACTIVE10_EDGE_Msk (0x00300000UL) /*!< field DEVACTIVE10_EDGE (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register DCDR0 ===================================================== */
#define PPU_DCDR0_CLKEN_RST_DLY_Pos (0UL) /*!< field CLKEN_RST_DLY (bitOffset 0, bitWidth 8) */
#define PPU_DCDR0_CLKEN_RST_DLY_Msk (0x000000ffUL) /*!< field CLKEN_RST_DLY (Bitfield-Mask: 0x000000ff) */
#define PPU_DCDR0_ISO_CLKEN_DLY_Pos (8UL) /*!< field ISO_CLKEN_DLY (bitOffset 8, bitWidth 8) */
#define PPU_DCDR0_ISO_CLKEN_DLY_Msk (0x0000ff00UL) /*!< field ISO_CLKEN_DLY (Bitfield-Mask: 0x000000ff) */
#define PPU_DCDR0_RST_HWSTAT_DLY_Pos (16UL) /*!< field RST_HWSTAT_DLY (bitOffset 16, bitWidth 8) */
#define PPU_DCDR0_RST_HWSTAT_DLY_Msk (0x00ff0000UL) /*!< field RST_HWSTAT_DLY (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register DCDR1 ===================================================== */
#define PPU_DCDR1_ISO_RST_DLY_Pos (0UL) /*!< field ISO_RST_DLY (bitOffset 0, bitWidth 8) */
#define PPU_DCDR1_ISO_RST_DLY_Msk (0x000000ffUL) /*!< field ISO_RST_DLY (Bitfield-Mask: 0x000000ff) */
#define PPU_DCDR1_CLKEN_ISO_DLY_Pos (8UL) /*!< field CLKEN_ISO_DLY (bitOffset 8, bitWidth 8) */
#define PPU_DCDR1_CLKEN_ISO_DLY_Msk (0x0000ff00UL) /*!< field CLKEN_ISO_DLY (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register IDR0 ====================================================== */
#define PPU_IDR0_DEVCHAN_Pos (0UL) /*!< field DEVCHAN (bitOffset 0, bitWidth 4) */
#define PPU_IDR0_DEVCHAN_Msk (0x0000000fUL) /*!< field DEVCHAN (Bitfield-Mask: 0x0000000f) */
#define PPU_IDR0_NUM_OPMODE_Pos (4UL) /*!< field NUM_OPMODE (bitOffset 4, bitWidth 4) */
#define PPU_IDR0_NUM_OPMODE_Msk (0x000000f0UL) /*!< field NUM_OPMODE (Bitfield-Mask: 0x0000000f) */
#define PPU_IDR0_STA_OFF_SPT_Pos (8UL) /*!< field STA_OFF_SPT (bitOffset 8, bitWidth 1) */
#define PPU_IDR0_STA_OFF_SPT_Msk (0x00000100UL) /*!< field STA_OFF_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_OFF_EMU_SPT_Pos (9UL) /*!< field STA_OFF_EMU_SPT (bitOffset 9, bitWidth 1) */
#define PPU_IDR0_STA_OFF_EMU_SPT_Msk (0x00000200UL) /*!< field STA_OFF_EMU_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_MEM_RET_SPT_Pos (10UL) /*!< field STA_MEM_RET_SPT (bitOffset 10, bitWidth 1) */
#define PPU_IDR0_STA_MEM_RET_SPT_Msk (0x00000400UL) /*!< field STA_MEM_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_MEM_RET_EMU_SPT_Pos (11UL) /*!< field STA_MEM_RET_EMU_SPT (bitOffset 11, bitWidth 1) */
#define PPU_IDR0_STA_MEM_RET_EMU_SPT_Msk (0x00000800UL) /*!< field STA_MEM_RET_EMU_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_LGC_RET_SPT_Pos (12UL) /*!< field STA_LGC_RET_SPT (bitOffset 12, bitWidth 1) */
#define PPU_IDR0_STA_LGC_RET_SPT_Msk (0x00001000UL) /*!< field STA_LGC_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_MEM_OFF_SPT_Pos (13UL) /*!< field STA_MEM_OFF_SPT (bitOffset 13, bitWidth 1) */
#define PPU_IDR0_STA_MEM_OFF_SPT_Msk (0x00002000UL) /*!< field STA_MEM_OFF_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_FULL_RET_SPT_Pos (14UL) /*!< field STA_FULL_RET_SPT (bitOffset 14, bitWidth 1) */
#define PPU_IDR0_STA_FULL_RET_SPT_Msk (0x00004000UL) /*!< field STA_FULL_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_FUNC_RET_SPT_Pos (15UL) /*!< field STA_FUNC_RET_SPT (bitOffset 15, bitWidth 1) */
#define PPU_IDR0_STA_FUNC_RET_SPT_Msk (0x00008000UL) /*!< field STA_FUNC_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_ON_SPT_Pos (16UL) /*!< field STA_ON_SPT (bitOffset 16, bitWidth 1) */
#define PPU_IDR0_STA_ON_SPT_Msk (0x00010000UL) /*!< field STA_ON_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_WRM_RST_SPT_Pos (17UL) /*!< field STA_WRM_RST_SPT (bitOffset 17, bitWidth 1) */
#define PPU_IDR0_STA_WRM_RST_SPT_Msk (0x00020000UL) /*!< field STA_WRM_RST_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_STA_DBG_RECOV_SPT_Pos (18UL) /*!< field STA_DBG_RECOV_SPT (bitOffset 18, bitWidth 1) */
#define PPU_IDR0_STA_DBG_RECOV_SPT_Msk (0x00040000UL) /*!< field STA_DBG_RECOV_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_OFF_SPT_Pos (20UL) /*!< field DYN_OFF_SPT (bitOffset 20, bitWidth 1) */
#define PPU_IDR0_DYN_OFF_SPT_Msk (0x00100000UL) /*!< field DYN_OFF_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_OFF_EMU_SPT_Pos (21UL) /*!< field DYN_OFF_EMU_SPT (bitOffset 21, bitWidth 1) */
#define PPU_IDR0_DYN_OFF_EMU_SPT_Msk (0x00200000UL) /*!< field DYN_OFF_EMU_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_MEM_RET_SPT_Pos (22UL) /*!< field DYN_MEM_RET_SPT (bitOffset 22, bitWidth 1) */
#define PPU_IDR0_DYN_MEM_RET_SPT_Msk (0x00400000UL) /*!< field DYN_MEM_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_MEM_RET_EMU_SPT_Pos (23UL) /*!< field DYN_MEM_RET_EMU_SPT (bitOffset 23, bitWidth 1) */
#define PPU_IDR0_DYN_MEM_RET_EMU_SPT_Msk (0x00800000UL) /*!< field DYN_MEM_RET_EMU_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_LGC_RET_SPT_Pos (24UL) /*!< field DYN_LGC_RET_SPT (bitOffset 24, bitWidth 1) */
#define PPU_IDR0_DYN_LGC_RET_SPT_Msk (0x01000000UL) /*!< field DYN_LGC_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_MEM_OFF_SPT_Pos (25UL) /*!< field DYN_MEM_OFF_SPT (bitOffset 25, bitWidth 1) */
#define PPU_IDR0_DYN_MEM_OFF_SPT_Msk (0x02000000UL) /*!< field DYN_MEM_OFF_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_FULL_RET_SPT_Pos (26UL) /*!< field DYN_FULL_RET_SPT (bitOffset 26, bitWidth 1) */
#define PPU_IDR0_DYN_FULL_RET_SPT_Msk (0x04000000UL) /*!< field DYN_FULL_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_FUNC_RET_SPT_Pos (27UL) /*!< field DYN_FUNC_RET_SPT (bitOffset 27, bitWidth 1) */
#define PPU_IDR0_DYN_FUNC_RET_SPT_Msk (0x08000000UL) /*!< field DYN_FUNC_RET_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_ON_SPT_Pos (28UL) /*!< field DYN_ON_SPT (bitOffset 28, bitWidth 1) */
#define PPU_IDR0_DYN_ON_SPT_Msk (0x10000000UL) /*!< field DYN_ON_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR0_DYN_WRM_RST_SPT_Pos (29UL) /*!< field DYN_WRM_RST_SPT (bitOffset 29, bitWidth 1) */
#define PPU_IDR0_DYN_WRM_RST_SPT_Msk (0x20000000UL) /*!< field DYN_WRM_RST_SPT (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register IDR1 ====================================================== */
#define PPU_IDR1_PWR_MODE_ENTRY_DEL_SPT_Pos (0UL) /*!< field PWR_MODE_ENTRY_DEL_SPT (bitOffset 0, bitWidth 1) */
#define PPU_IDR1_PWR_MODE_ENTRY_DEL_SPT_Msk (0x00000001UL) /*!< field PWR_MODE_ENTRY_DEL_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_SW_DEV_DEL_SPT_Pos (1UL) /*!< field SW_DEV_DEL_SPT (bitOffset 1, bitWidth 1) */
#define PPU_IDR1_SW_DEV_DEL_SPT_Msk (0x00000002UL) /*!< field SW_DEV_DEL_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_LOCK_SPT_Pos (2UL) /*!< field LOCK_SPT (bitOffset 2, bitWidth 1) */
#define PPU_IDR1_LOCK_SPT_Msk (0x00000004UL) /*!< field LOCK_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_MEM_RET_RAM_REG_Pos (4UL) /*!< field MEM_RET_RAM_REG (bitOffset 4, bitWidth 1) */
#define PPU_IDR1_MEM_RET_RAM_REG_Msk (0x00000010UL) /*!< field MEM_RET_RAM_REG (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_FULL_RET_RAM_REG_Pos (5UL) /*!< field FULL_RET_RAM_REG (bitOffset 5, bitWidth 1) */
#define PPU_IDR1_FULL_RET_RAM_REG_Msk (0x00000020UL) /*!< field FULL_RET_RAM_REG (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_FUNC_RET_RAM_REG_Pos (6UL) /*!< field FUNC_RET_RAM_REG (bitOffset 6, bitWidth 1) */
#define PPU_IDR1_FUNC_RET_RAM_REG_Msk (0x00000040UL) /*!< field FUNC_RET_RAM_REG (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_STA_POLICY_PWR_IRQ_SPT_Pos (8UL) /*!< field STA_POLICY_PWR_IRQ_SPT (bitOffset 8, bitWidth 1) */
#define PPU_IDR1_STA_POLICY_PWR_IRQ_SPT_Msk (0x00000100UL) /*!< field STA_POLICY_PWR_IRQ_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_STA_POLICY_OP_IRQ_SPT_Pos (9UL) /*!< field STA_POLICY_OP_IRQ_SPT (bitOffset 9, bitWidth 1) */
#define PPU_IDR1_STA_POLICY_OP_IRQ_SPT_Msk (0x00000200UL) /*!< field STA_POLICY_OP_IRQ_SPT (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_OP_ACTIVE_Pos (10UL) /*!< field OP_ACTIVE (bitOffset 10, bitWidth 1) */
#define PPU_IDR1_OP_ACTIVE_Msk (0x00000400UL) /*!< field OP_ACTIVE (Bitfield-Mask: 0x00000001) */
#define PPU_IDR1_OFF_MEM_RET_TRANS_Pos (12UL) /*!< field OFF_MEM_RET_TRANS (bitOffset 12, bitWidth 1) */
#define PPU_IDR1_OFF_MEM_RET_TRANS_Msk (0x00001000UL) /*!< field OFF_MEM_RET_TRANS (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register IIDR ====================================================== */
#define PPU_IIDR_IMPLEMENTER_Pos (0UL) /*!< field IMPLEMENTER (bitOffset 0, bitWidth 12) */
#define PPU_IIDR_IMPLEMENTER_Msk (0x00000fffUL) /*!< field IMPLEMENTER (Bitfield-Mask: 0x00000fff) */
#define PPU_IIDR_REVISION_Pos (12UL) /*!< field REVISION (bitOffset 12, bitWidth 4) */
#define PPU_IIDR_REVISION_Msk (0x0000f000UL) /*!< field REVISION (Bitfield-Mask: 0x0000000f) */
#define PPU_IIDR_VARIANT_Pos (16UL) /*!< field VARIANT (bitOffset 16, bitWidth 4) */
#define PPU_IIDR_VARIANT_Msk (0x000f0000UL) /*!< field VARIANT (Bitfield-Mask: 0x0000000f) */
#define PPU_IIDR_PRODUCT_ID_Pos (20UL) /*!< field PRODUCT_ID (bitOffset 20, bitWidth 12) */
#define PPU_IIDR_PRODUCT_ID_Msk (0xfff00000UL) /*!< field PRODUCT_ID (Bitfield-Mask: 0x00000fff) */

/* ====================================================== Register AIDR ====================================================== */
#define PPU_AIDR_ARCH_REV_MINOR_Pos (0UL) /*!< field ARCH_REV_MINOR (bitOffset 0, bitWidth 4) */
#define PPU_AIDR_ARCH_REV_MINOR_Msk (0x0000000fUL) /*!< field ARCH_REV_MINOR (Bitfield-Mask: 0x0000000f) */
#define PPU_AIDR_ARCH_REV_MAJOR_Pos (4UL) /*!< field ARCH_REV_MAJOR (bitOffset 4, bitWidth 4) */
#define PPU_AIDR_ARCH_REV_MAJOR_Msk (0x000000f0UL) /*!< field ARCH_REV_MAJOR (Bitfield-Mask: 0x0000000f) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: WDT ================================================= */
/* =========================================================================================================================== */

/* ==================================================== Register WDOGLOAD ==================================================== */
#define WDT_WDOGLOAD_WDOGLOAD_Pos (0UL) /*!< field WDOGLOAD (bitOffset 0, bitWidth 32) */
#define WDT_WDOGLOAD_WDOGLOAD_Msk (0xffffffffUL) /*!< field WDOGLOAD (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register WDOGVALUE =================================================== */
#define WDT_WDOGVALUE_VALUE_Pos (0UL) /*!< field VALUE (bitOffset 0, bitWidth 32) */
#define WDT_WDOGVALUE_VALUE_Msk (0xffffffffUL) /*!< field VALUE (Bitfield-Mask: 0xffffffff) */

/* =================================================== Register WDOGCONTROL ================================================== */
#define WDT_WDOGCONTROL_INTEN_Pos (0UL) /*!< field INTEN (bitOffset 0, bitWidth 1) */
#define WDT_WDOGCONTROL_INTEN_Msk (0x00000001UL) /*!< field INTEN (Bitfield-Mask: 0x00000001) */
#define WDT_WDOGCONTROL_RESEN_Pos (1UL) /*!< field RESEN (bitOffset 1, bitWidth 1) */
#define WDT_WDOGCONTROL_RESEN_Msk (0x00000002UL) /*!< field RESEN (Bitfield-Mask: 0x00000001) */

/* =================================================== Register WDOGINTCLR =================================================== */
#define WDT_WDOGINTCLR_WDOGINTCLR_Pos (0UL) /*!< field WDOGINTCLR (bitOffset 0, bitWidth 1) */
#define WDT_WDOGINTCLR_WDOGINTCLR_Msk (0x00000001UL) /*!< field WDOGINTCLR (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register WDOGRIS ==================================================== */
#define WDT_WDOGRIS_RAWWATCHDOGINTERRUPT_Pos (0UL) /*!< field RAWWATCHDOGINTERRUPT (bitOffset 0, bitWidth 1) */
#define WDT_WDOGRIS_RAWWATCHDOGINTERRUPT_Msk (0x00000001UL) /*!< field RAWWATCHDOGINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register WDOGMIS ==================================================== */
#define WDT_WDOGMIS_WATCHDOGINTERRUPT_Pos (0UL) /*!< field WATCHDOGINTERRUPT (bitOffset 0, bitWidth 1) */
#define WDT_WDOGMIS_WATCHDOGINTERRUPT_Msk (0x00000001UL) /*!< field WATCHDOGINTERRUPT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register WDOGLOCK ==================================================== */
#define WDT_WDOGLOCK_ENABLEREGISTERWRITES_Pos (0UL) /*!< field ENABLEREGISTERWRITES (bitOffset 0, bitWidth 32) */
#define WDT_WDOGLOCK_ENABLEREGISTERWRITES_Msk (0xffffffffUL) /*!< field ENABLEREGISTERWRITES (Bitfield-Mask: 0xffffffff) */
#define WDT_WDOGLOCK_REGISTERWRITEENABLESTATUS_Pos (0UL) /*!< field REGISTERWRITEENABLESTATUS (bitOffset 0, bitWidth 1) */
#define WDT_WDOGLOCK_REGISTERWRITEENABLESTATUS_Msk (0x00000001UL) /*!< field REGISTERWRITEENABLESTATUS (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register WDOGITCR ==================================================== */
#define WDT_WDOGITCR_INTEGRATIONTESTMODEENABLE_Pos (0UL) /*!< field INTEGRATIONTESTMODEENABLE (bitOffset 0, bitWidth 1) */
#define WDT_WDOGITCR_INTEGRATIONTESTMODEENABLE_Msk (0x00000001UL) /*!< field INTEGRATIONTESTMODEENABLE (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register WDOGITOP ==================================================== */
#define WDT_WDOGITOP_INTEGRATIONTESTWGODRESVALUE_Pos (0UL) /*!< field INTEGRATIONTESTWGODRESVALUE (bitOffset 0, bitWidth 1) */
#define WDT_WDOGITOP_INTEGRATIONTESTWGODRESVALUE_Msk (0x00000001UL) /*!< field INTEGRATIONTESTWGODRESVALUE (Bitfield-Mask: 0x00000001) */
#define WDT_WDOGITOP_INTEGRATIONTESTWDOGINTVALUE_Pos (1UL) /*!< field INTEGRATIONTESTWDOGINTVALUE (bitOffset 1, bitWidth 1) */
#define WDT_WDOGITOP_INTEGRATIONTESTWDOGINTVALUE_Msk (0x00000002UL) /*!< field INTEGRATIONTESTWDOGINTVALUE (Bitfield-Mask: 0x00000001) */

/* ================================================== Register WDOGPERIPHID4 ================================================= */
#define WDT_WDOGPERIPHID4_JEP106_C_CODE_Pos (0UL) /*!< field JEP106_C_CODE (bitOffset 0, bitWidth 4) */
#define WDT_WDOGPERIPHID4_JEP106_C_CODE_Msk (0x0000000fUL) /*!< field JEP106_C_CODE (Bitfield-Mask: 0x0000000f) */
#define WDT_WDOGPERIPHID4_BLOCKCOUNT_Pos (4UL) /*!< field BLOCKCOUNT (bitOffset 4, bitWidth 4) */
#define WDT_WDOGPERIPHID4_BLOCKCOUNT_Msk (0x000000f0UL) /*!< field BLOCKCOUNT (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register WDOGPERIPHID5 ================================================= */
#define WDT_WDOGPERIPHID5_WDOGPERIPHID5_Pos (0UL) /*!< field WDOGPERIPHID5 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPERIPHID5_WDOGPERIPHID5_Msk (0x000000ffUL) /*!< field WDOGPERIPHID5 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPERIPHID6 ================================================= */
#define WDT_WDOGPERIPHID6_WDOGPERIPHID6_Pos (0UL) /*!< field WDOGPERIPHID6 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPERIPHID6_WDOGPERIPHID6_Msk (0x000000ffUL) /*!< field WDOGPERIPHID6 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPERIPHID7 ================================================= */
#define WDT_WDOGPERIPHID7_WDOGPERIPHID7_Pos (0UL) /*!< field WDOGPERIPHID7 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPERIPHID7_WDOGPERIPHID7_Msk (0x000000ffUL) /*!< field WDOGPERIPHID7 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPERIPHID0 ================================================= */
#define WDT_WDOGPERIPHID0_WDOGPERIPHID0_Pos (0UL) /*!< field WDOGPERIPHID0 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPERIPHID0_WDOGPERIPHID0_Msk (0x000000ffUL) /*!< field WDOGPERIPHID0 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPERIPHID1 ================================================= */
#define WDT_WDOGPERIPHID1_PART_NUMBER_11_8_Pos (0UL) /*!< field PART_NUMBER_11_8 (bitOffset 0, bitWidth 4) */
#define WDT_WDOGPERIPHID1_PART_NUMBER_11_8_Msk (0x0000000fUL) /*!< field PART_NUMBER_11_8 (Bitfield-Mask: 0x0000000f) */
#define WDT_WDOGPERIPHID1_JEP106_ID_3_0_Pos (4UL) /*!< field JEP106_ID_3_0 (bitOffset 4, bitWidth 4) */
#define WDT_WDOGPERIPHID1_JEP106_ID_3_0_Msk (0x000000f0UL) /*!< field JEP106_ID_3_0 (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register WDOGPERIPHID2 ================================================= */
#define WDT_WDOGPERIPHID2_JEP106_ID_6_4_Pos (0UL) /*!< field JEP106_ID_6_4 (bitOffset 0, bitWidth 3) */
#define WDT_WDOGPERIPHID2_JEP106_ID_6_4_Msk (0x00000007UL) /*!< field JEP106_ID_6_4 (Bitfield-Mask: 0x00000007) */
#define WDT_WDOGPERIPHID2_JEDEC_USED_Pos (3UL) /*!< field JEDEC_USED (bitOffset 3, bitWidth 1) */
#define WDT_WDOGPERIPHID2_JEDEC_USED_Msk (0x00000008UL) /*!< field JEDEC_USED (Bitfield-Mask: 0x00000001) */
#define WDT_WDOGPERIPHID2_REVISION_Pos (4UL) /*!< field REVISION (bitOffset 4, bitWidth 4) */
#define WDT_WDOGPERIPHID2_REVISION_Msk (0x000000f0UL) /*!< field REVISION (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register WDOGPERIPHID3 ================================================= */
#define WDT_WDOGPERIPHID3_CUSTOMERMODIFICATIONNUMBER_Pos (0UL) /*!< field CUSTOMERMODIFICATIONNUMBER (bitOffset 0, bitWidth 4) */
#define WDT_WDOGPERIPHID3_CUSTOMERMODIFICATIONNUMBER_Msk (0x0000000fUL) /*!< field CUSTOMERMODIFICATIONNUMBER (Bitfield-Mask: 0x0000000f) */
#define WDT_WDOGPERIPHID3_ECOREVISIONNUMBER_Pos (4UL) /*!< field ECOREVISIONNUMBER (bitOffset 4, bitWidth 4) */
#define WDT_WDOGPERIPHID3_ECOREVISIONNUMBER_Msk (0x000000f0UL) /*!< field ECOREVISIONNUMBER (Bitfield-Mask: 0x0000000f) */

/* ================================================== Register WDOGPCELLID0 ================================================== */
#define WDT_WDOGPCELLID0_WDOGPCELLID0_Pos (0UL) /*!< field WDOGPCELLID0 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPCELLID0_WDOGPCELLID0_Msk (0x000000ffUL) /*!< field WDOGPCELLID0 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPCELLID1 ================================================== */
#define WDT_WDOGPCELLID1_WDOGPCELLID1_Pos (0UL) /*!< field WDOGPCELLID1 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPCELLID1_WDOGPCELLID1_Msk (0x000000ffUL) /*!< field WDOGPCELLID1 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPCELLID2 ================================================== */
#define WDT_WDOGPCELLID2_WDOGPCELLID2_Pos (0UL) /*!< field WDOGPCELLID2 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPCELLID2_WDOGPCELLID2_Msk (0x000000ffUL) /*!< field WDOGPCELLID2 (Bitfield-Mask: 0x000000ff) */

/* ================================================== Register WDOGPCELLID3 ================================================== */
#define WDT_WDOGPCELLID3_WDOGPCELLID3_Pos (0UL) /*!< field WDOGPCELLID3 (bitOffset 0, bitWidth 8) */
#define WDT_WDOGPCELLID3_WDOGPCELLID3_Msk (0x000000ffUL) /*!< field WDOGPCELLID3 (Bitfield-Mask: 0x000000ff) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: IOCTR ================================================ */
/* =========================================================================================================================== */

/* ===================================================== Register PA_MODE ==================================================== */
#define IOCTR_PA_MODE_MODE0_Pos (0UL) /*!< field MODE0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PA_MODE_MODE0_Msk (0x00000003UL) /*!< field MODE0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE1_Pos (2UL) /*!< field MODE1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PA_MODE_MODE1_Msk (0x0000000cUL) /*!< field MODE1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE2_Pos (4UL) /*!< field MODE2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PA_MODE_MODE2_Msk (0x00000030UL) /*!< field MODE2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE3_Pos (6UL) /*!< field MODE3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PA_MODE_MODE3_Msk (0x000000c0UL) /*!< field MODE3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE4_Pos (8UL) /*!< field MODE4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PA_MODE_MODE4_Msk (0x00000300UL) /*!< field MODE4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE5_Pos (10UL) /*!< field MODE5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PA_MODE_MODE5_Msk (0x00000c00UL) /*!< field MODE5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE6_Pos (12UL) /*!< field MODE6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PA_MODE_MODE6_Msk (0x00003000UL) /*!< field MODE6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE7_Pos (14UL) /*!< field MODE7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PA_MODE_MODE7_Msk (0x0000c000UL) /*!< field MODE7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE8_Pos (16UL) /*!< field MODE8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PA_MODE_MODE8_Msk (0x00030000UL) /*!< field MODE8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE9_Pos (18UL) /*!< field MODE9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PA_MODE_MODE9_Msk (0x000c0000UL) /*!< field MODE9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE10_Pos (20UL) /*!< field MODE10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PA_MODE_MODE10_Msk (0x00300000UL) /*!< field MODE10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE11_Pos (22UL) /*!< field MODE11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PA_MODE_MODE11_Msk (0x00c00000UL) /*!< field MODE11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE12_Pos (24UL) /*!< field MODE12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PA_MODE_MODE12_Msk (0x03000000UL) /*!< field MODE12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE13_Pos (26UL) /*!< field MODE13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PA_MODE_MODE13_Msk (0x0c000000UL) /*!< field MODE13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE14_Pos (28UL) /*!< field MODE14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PA_MODE_MODE14_Msk (0x30000000UL) /*!< field MODE14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_MODE_MODE15_Pos (30UL) /*!< field MODE15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PA_MODE_MODE15_Msk (0xc0000000UL) /*!< field MODE15 (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register PA_AFL ===================================================== */
#define IOCTR_PA_AFL_AFSEL0_Pos (0UL) /*!< field AFSEL0 (bitOffset 0, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL0_Msk (0x00000007UL) /*!< field AFSEL0 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL1_Pos (4UL) /*!< field AFSEL1 (bitOffset 4, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL1_Msk (0x00000070UL) /*!< field AFSEL1 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL2_Pos (8UL) /*!< field AFSEL2 (bitOffset 8, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL2_Msk (0x00000700UL) /*!< field AFSEL2 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL3_Pos (12UL) /*!< field AFSEL3 (bitOffset 12, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL3_Msk (0x00007000UL) /*!< field AFSEL3 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL4_Pos (16UL) /*!< field AFSEL4 (bitOffset 16, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL4_Msk (0x00070000UL) /*!< field AFSEL4 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL5_Pos (20UL) /*!< field AFSEL5 (bitOffset 20, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL5_Msk (0x00700000UL) /*!< field AFSEL5 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL6_Pos (24UL) /*!< field AFSEL6 (bitOffset 24, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL6_Msk (0x07000000UL) /*!< field AFSEL6 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFL_AFSEL7_Pos (28UL) /*!< field AFSEL7 (bitOffset 28, bitWidth 3) */
#define IOCTR_PA_AFL_AFSEL7_Msk (0x70000000UL) /*!< field AFSEL7 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PA_AFH ===================================================== */
#define IOCTR_PA_AFH_AFSEL8_Pos (0UL) /*!< field AFSEL8 (bitOffset 0, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL8_Msk (0x00000007UL) /*!< field AFSEL8 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL9_Pos (4UL) /*!< field AFSEL9 (bitOffset 4, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL9_Msk (0x00000070UL) /*!< field AFSEL9 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL10_Pos (8UL) /*!< field AFSEL10 (bitOffset 8, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL10_Msk (0x00000700UL) /*!< field AFSEL10 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL11_Pos (12UL) /*!< field AFSEL11 (bitOffset 12, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL11_Msk (0x00007000UL) /*!< field AFSEL11 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL12_Pos (16UL) /*!< field AFSEL12 (bitOffset 16, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL12_Msk (0x00070000UL) /*!< field AFSEL12 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL13_Pos (20UL) /*!< field AFSEL13 (bitOffset 20, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL13_Msk (0x00700000UL) /*!< field AFSEL13 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL14_Pos (24UL) /*!< field AFSEL14 (bitOffset 24, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL14_Msk (0x07000000UL) /*!< field AFSEL14 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PA_AFH_AFSEL15_Pos (28UL) /*!< field AFSEL15 (bitOffset 28, bitWidth 3) */
#define IOCTR_PA_AFH_AFSEL15_Msk (0x70000000UL) /*!< field AFSEL15 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PA_PUPD ==================================================== */
#define IOCTR_PA_PUPD_PUPD0_Pos (0UL) /*!< field PUPD0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD0_Msk (0x00000003UL) /*!< field PUPD0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD1_Pos (2UL) /*!< field PUPD1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD1_Msk (0x0000000cUL) /*!< field PUPD1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD2_Pos (4UL) /*!< field PUPD2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD2_Msk (0x00000030UL) /*!< field PUPD2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD3_Pos (6UL) /*!< field PUPD3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD3_Msk (0x000000c0UL) /*!< field PUPD3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD4_Pos (8UL) /*!< field PUPD4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD4_Msk (0x00000300UL) /*!< field PUPD4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD5_Pos (10UL) /*!< field PUPD5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD5_Msk (0x00000c00UL) /*!< field PUPD5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD6_Pos (12UL) /*!< field PUPD6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD6_Msk (0x00003000UL) /*!< field PUPD6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD7_Pos (14UL) /*!< field PUPD7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD7_Msk (0x0000c000UL) /*!< field PUPD7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD8_Pos (16UL) /*!< field PUPD8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD8_Msk (0x00030000UL) /*!< field PUPD8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD9_Pos (18UL) /*!< field PUPD9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD9_Msk (0x000c0000UL) /*!< field PUPD9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD10_Pos (20UL) /*!< field PUPD10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD10_Msk (0x00300000UL) /*!< field PUPD10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD11_Pos (22UL) /*!< field PUPD11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD11_Msk (0x00c00000UL) /*!< field PUPD11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD12_Pos (24UL) /*!< field PUPD12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD12_Msk (0x03000000UL) /*!< field PUPD12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD13_Pos (26UL) /*!< field PUPD13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD13_Msk (0x0c000000UL) /*!< field PUPD13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD14_Pos (28UL) /*!< field PUPD14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD14_Msk (0x30000000UL) /*!< field PUPD14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_PUPD_PUPD15_Pos (30UL) /*!< field PUPD15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PA_PUPD_PUPD15_Msk (0xc0000000UL) /*!< field PUPD15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PA_DS ===================================================== */
#define IOCTR_PA_DS_DS0_Pos (0UL) /*!< field DS0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PA_DS_DS0_Msk (0x00000003UL) /*!< field DS0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS1_Pos (2UL) /*!< field DS1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PA_DS_DS1_Msk (0x0000000cUL) /*!< field DS1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS2_Pos (4UL) /*!< field DS2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PA_DS_DS2_Msk (0x00000030UL) /*!< field DS2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS3_Pos (6UL) /*!< field DS3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PA_DS_DS3_Msk (0x000000c0UL) /*!< field DS3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS4_Pos (8UL) /*!< field DS4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PA_DS_DS4_Msk (0x00000300UL) /*!< field DS4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS5_Pos (10UL) /*!< field DS5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PA_DS_DS5_Msk (0x00000c00UL) /*!< field DS5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS6_Pos (12UL) /*!< field DS6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PA_DS_DS6_Msk (0x00003000UL) /*!< field DS6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS7_Pos (14UL) /*!< field DS7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PA_DS_DS7_Msk (0x0000c000UL) /*!< field DS7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS8_Pos (16UL) /*!< field DS8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PA_DS_DS8_Msk (0x00030000UL) /*!< field DS8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS9_Pos (18UL) /*!< field DS9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PA_DS_DS9_Msk (0x000c0000UL) /*!< field DS9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS10_Pos (20UL) /*!< field DS10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PA_DS_DS10_Msk (0x00300000UL) /*!< field DS10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS11_Pos (22UL) /*!< field DS11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PA_DS_DS11_Msk (0x00c00000UL) /*!< field DS11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS12_Pos (24UL) /*!< field DS12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PA_DS_DS12_Msk (0x03000000UL) /*!< field DS12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS13_Pos (26UL) /*!< field DS13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PA_DS_DS13_Msk (0x0c000000UL) /*!< field DS13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS14_Pos (28UL) /*!< field DS14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PA_DS_DS14_Msk (0x30000000UL) /*!< field DS14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PA_DS_DS15_Pos (30UL) /*!< field DS15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PA_DS_DS15_Msk (0xc0000000UL) /*!< field DS15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PA_SR ===================================================== */
#define IOCTR_PA_SR_SR0_Pos (0UL) /*!< field SR0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PA_SR_SR0_Msk (0x00000001UL) /*!< field SR0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR1_Pos (1UL) /*!< field SR1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PA_SR_SR1_Msk (0x00000002UL) /*!< field SR1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR2_Pos (2UL) /*!< field SR2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PA_SR_SR2_Msk (0x00000004UL) /*!< field SR2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR3_Pos (3UL) /*!< field SR3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PA_SR_SR3_Msk (0x00000008UL) /*!< field SR3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR4_Pos (4UL) /*!< field SR4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PA_SR_SR4_Msk (0x00000010UL) /*!< field SR4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR5_Pos (5UL) /*!< field SR5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PA_SR_SR5_Msk (0x00000020UL) /*!< field SR5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR6_Pos (6UL) /*!< field SR6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PA_SR_SR6_Msk (0x00000040UL) /*!< field SR6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR7_Pos (7UL) /*!< field SR7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PA_SR_SR7_Msk (0x00000080UL) /*!< field SR7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR8_Pos (8UL) /*!< field SR8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PA_SR_SR8_Msk (0x00000100UL) /*!< field SR8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR9_Pos (9UL) /*!< field SR9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PA_SR_SR9_Msk (0x00000200UL) /*!< field SR9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR10_Pos (10UL) /*!< field SR10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PA_SR_SR10_Msk (0x00000400UL) /*!< field SR10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR11_Pos (11UL) /*!< field SR11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PA_SR_SR11_Msk (0x00000800UL) /*!< field SR11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR12_Pos (12UL) /*!< field SR12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PA_SR_SR12_Msk (0x00001000UL) /*!< field SR12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR13_Pos (13UL) /*!< field SR13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PA_SR_SR13_Msk (0x00002000UL) /*!< field SR13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR14_Pos (14UL) /*!< field SR14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PA_SR_SR14_Msk (0x00004000UL) /*!< field SR14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_SR_SR15_Pos (15UL) /*!< field SR15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PA_SR_SR15_Msk (0x00008000UL) /*!< field SR15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PA_OTYPE ==================================================== */
#define IOCTR_PA_OTYPE_OTYPE0_Pos (0UL) /*!< field OTYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE0_Msk (0x00000001UL) /*!< field OTYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE1_Pos (1UL) /*!< field OTYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE1_Msk (0x00000002UL) /*!< field OTYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE2_Pos (2UL) /*!< field OTYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE2_Msk (0x00000004UL) /*!< field OTYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE3_Pos (3UL) /*!< field OTYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE3_Msk (0x00000008UL) /*!< field OTYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE4_Pos (4UL) /*!< field OTYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE4_Msk (0x00000010UL) /*!< field OTYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE5_Pos (5UL) /*!< field OTYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE5_Msk (0x00000020UL) /*!< field OTYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE6_Pos (6UL) /*!< field OTYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE6_Msk (0x00000040UL) /*!< field OTYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE7_Pos (7UL) /*!< field OTYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE7_Msk (0x00000080UL) /*!< field OTYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE8_Pos (8UL) /*!< field OTYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE8_Msk (0x00000100UL) /*!< field OTYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE9_Pos (9UL) /*!< field OTYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE9_Msk (0x00000200UL) /*!< field OTYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE10_Pos (10UL) /*!< field OTYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE10_Msk (0x00000400UL) /*!< field OTYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE11_Pos (11UL) /*!< field OTYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE11_Msk (0x00000800UL) /*!< field OTYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE12_Pos (12UL) /*!< field OTYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE12_Msk (0x00001000UL) /*!< field OTYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE13_Pos (13UL) /*!< field OTYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE13_Msk (0x00002000UL) /*!< field OTYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE14_Pos (14UL) /*!< field OTYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE14_Msk (0x00004000UL) /*!< field OTYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_OTYPE_OTYPE15_Pos (15UL) /*!< field OTYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PA_OTYPE_OTYPE15_Msk (0x00008000UL) /*!< field OTYPE15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PA_ITYPE ==================================================== */
#define IOCTR_PA_ITYPE_ITYPE0_Pos (0UL) /*!< field ITYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE0_Msk (0x00000001UL) /*!< field ITYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE1_Pos (1UL) /*!< field ITYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE1_Msk (0x00000002UL) /*!< field ITYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE2_Pos (2UL) /*!< field ITYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE2_Msk (0x00000004UL) /*!< field ITYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE3_Pos (3UL) /*!< field ITYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE3_Msk (0x00000008UL) /*!< field ITYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE4_Pos (4UL) /*!< field ITYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE4_Msk (0x00000010UL) /*!< field ITYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE5_Pos (5UL) /*!< field ITYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE5_Msk (0x00000020UL) /*!< field ITYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE6_Pos (6UL) /*!< field ITYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE6_Msk (0x00000040UL) /*!< field ITYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE7_Pos (7UL) /*!< field ITYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE7_Msk (0x00000080UL) /*!< field ITYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE8_Pos (8UL) /*!< field ITYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE8_Msk (0x00000100UL) /*!< field ITYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE9_Pos (9UL) /*!< field ITYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE9_Msk (0x00000200UL) /*!< field ITYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE10_Pos (10UL) /*!< field ITYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE10_Msk (0x00000400UL) /*!< field ITYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE11_Pos (11UL) /*!< field ITYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE11_Msk (0x00000800UL) /*!< field ITYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE12_Pos (12UL) /*!< field ITYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE12_Msk (0x00001000UL) /*!< field ITYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE13_Pos (13UL) /*!< field ITYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE13_Msk (0x00002000UL) /*!< field ITYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE14_Pos (14UL) /*!< field ITYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE14_Msk (0x00004000UL) /*!< field ITYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_ITYPE_ITYPE15_Pos (15UL) /*!< field ITYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PA_ITYPE_ITYPE15_Msk (0x00008000UL) /*!< field ITYPE15 (Bitfield-Mask: 0x00000001) */

/* =================================================== Register PA_I2CMODE =================================================== */
#define IOCTR_PA_I2CMODE_I2CMODE6_Pos (6UL) /*!< field I2CMODE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PA_I2CMODE_I2CMODE6_Msk (0x00000040UL) /*!< field I2CMODE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PA_I2CMODE_I2CMODE7_Pos (7UL) /*!< field I2CMODE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PA_I2CMODE_I2CMODE7_Msk (0x00000080UL) /*!< field I2CMODE7 (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register PB_MODE ==================================================== */
#define IOCTR_PB_MODE_MODE0_Pos (0UL) /*!< field MODE0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PB_MODE_MODE0_Msk (0x00000003UL) /*!< field MODE0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE1_Pos (2UL) /*!< field MODE1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PB_MODE_MODE1_Msk (0x0000000cUL) /*!< field MODE1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE2_Pos (4UL) /*!< field MODE2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PB_MODE_MODE2_Msk (0x00000030UL) /*!< field MODE2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE3_Pos (6UL) /*!< field MODE3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PB_MODE_MODE3_Msk (0x000000c0UL) /*!< field MODE3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE4_Pos (8UL) /*!< field MODE4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PB_MODE_MODE4_Msk (0x00000300UL) /*!< field MODE4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE5_Pos (10UL) /*!< field MODE5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PB_MODE_MODE5_Msk (0x00000c00UL) /*!< field MODE5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE6_Pos (12UL) /*!< field MODE6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PB_MODE_MODE6_Msk (0x00003000UL) /*!< field MODE6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE7_Pos (14UL) /*!< field MODE7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PB_MODE_MODE7_Msk (0x0000c000UL) /*!< field MODE7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE8_Pos (16UL) /*!< field MODE8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PB_MODE_MODE8_Msk (0x00030000UL) /*!< field MODE8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE9_Pos (18UL) /*!< field MODE9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PB_MODE_MODE9_Msk (0x000c0000UL) /*!< field MODE9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE10_Pos (20UL) /*!< field MODE10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PB_MODE_MODE10_Msk (0x00300000UL) /*!< field MODE10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE11_Pos (22UL) /*!< field MODE11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PB_MODE_MODE11_Msk (0x00c00000UL) /*!< field MODE11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE12_Pos (24UL) /*!< field MODE12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PB_MODE_MODE12_Msk (0x03000000UL) /*!< field MODE12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE13_Pos (26UL) /*!< field MODE13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PB_MODE_MODE13_Msk (0x0c000000UL) /*!< field MODE13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE14_Pos (28UL) /*!< field MODE14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PB_MODE_MODE14_Msk (0x30000000UL) /*!< field MODE14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_MODE_MODE15_Pos (30UL) /*!< field MODE15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PB_MODE_MODE15_Msk (0xc0000000UL) /*!< field MODE15 (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register PB_AFL ===================================================== */
#define IOCTR_PB_AFL_AFSEL0_Pos (0UL) /*!< field AFSEL0 (bitOffset 0, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL0_Msk (0x00000007UL) /*!< field AFSEL0 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL1_Pos (4UL) /*!< field AFSEL1 (bitOffset 4, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL1_Msk (0x00000070UL) /*!< field AFSEL1 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL2_Pos (8UL) /*!< field AFSEL2 (bitOffset 8, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL2_Msk (0x00000700UL) /*!< field AFSEL2 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL3_Pos (12UL) /*!< field AFSEL3 (bitOffset 12, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL3_Msk (0x00007000UL) /*!< field AFSEL3 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL4_Pos (16UL) /*!< field AFSEL4 (bitOffset 16, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL4_Msk (0x00070000UL) /*!< field AFSEL4 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL5_Pos (20UL) /*!< field AFSEL5 (bitOffset 20, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL5_Msk (0x00700000UL) /*!< field AFSEL5 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL6_Pos (24UL) /*!< field AFSEL6 (bitOffset 24, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL6_Msk (0x07000000UL) /*!< field AFSEL6 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFL_AFSEL7_Pos (28UL) /*!< field AFSEL7 (bitOffset 28, bitWidth 3) */
#define IOCTR_PB_AFL_AFSEL7_Msk (0x70000000UL) /*!< field AFSEL7 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PB_AFH ===================================================== */
#define IOCTR_PB_AFH_AFSEL8_Pos (0UL) /*!< field AFSEL8 (bitOffset 0, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL8_Msk (0x00000007UL) /*!< field AFSEL8 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL9_Pos (4UL) /*!< field AFSEL9 (bitOffset 4, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL9_Msk (0x00000070UL) /*!< field AFSEL9 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL10_Pos (8UL) /*!< field AFSEL10 (bitOffset 8, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL10_Msk (0x00000700UL) /*!< field AFSEL10 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL11_Pos (12UL) /*!< field AFSEL11 (bitOffset 12, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL11_Msk (0x00007000UL) /*!< field AFSEL11 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL12_Pos (16UL) /*!< field AFSEL12 (bitOffset 16, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL12_Msk (0x00070000UL) /*!< field AFSEL12 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL13_Pos (20UL) /*!< field AFSEL13 (bitOffset 20, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL13_Msk (0x00700000UL) /*!< field AFSEL13 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL14_Pos (24UL) /*!< field AFSEL14 (bitOffset 24, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL14_Msk (0x07000000UL) /*!< field AFSEL14 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PB_AFH_AFSEL15_Pos (28UL) /*!< field AFSEL15 (bitOffset 28, bitWidth 3) */
#define IOCTR_PB_AFH_AFSEL15_Msk (0x70000000UL) /*!< field AFSEL15 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PB_PUPD ==================================================== */
#define IOCTR_PB_PUPD_PUPD0_Pos (0UL) /*!< field PUPD0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD0_Msk (0x00000003UL) /*!< field PUPD0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD1_Pos (2UL) /*!< field PUPD1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD1_Msk (0x0000000cUL) /*!< field PUPD1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD2_Pos (4UL) /*!< field PUPD2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD2_Msk (0x00000030UL) /*!< field PUPD2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD3_Pos (6UL) /*!< field PUPD3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD3_Msk (0x000000c0UL) /*!< field PUPD3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD4_Pos (8UL) /*!< field PUPD4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD4_Msk (0x00000300UL) /*!< field PUPD4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD5_Pos (10UL) /*!< field PUPD5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD5_Msk (0x00000c00UL) /*!< field PUPD5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD6_Pos (12UL) /*!< field PUPD6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD6_Msk (0x00003000UL) /*!< field PUPD6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD7_Pos (14UL) /*!< field PUPD7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD7_Msk (0x0000c000UL) /*!< field PUPD7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD8_Pos (16UL) /*!< field PUPD8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD8_Msk (0x00030000UL) /*!< field PUPD8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD9_Pos (18UL) /*!< field PUPD9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD9_Msk (0x000c0000UL) /*!< field PUPD9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD10_Pos (20UL) /*!< field PUPD10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD10_Msk (0x00300000UL) /*!< field PUPD10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD11_Pos (22UL) /*!< field PUPD11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD11_Msk (0x00c00000UL) /*!< field PUPD11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD12_Pos (24UL) /*!< field PUPD12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD12_Msk (0x03000000UL) /*!< field PUPD12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD13_Pos (26UL) /*!< field PUPD13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD13_Msk (0x0c000000UL) /*!< field PUPD13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD14_Pos (28UL) /*!< field PUPD14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD14_Msk (0x30000000UL) /*!< field PUPD14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_PUPD_PUPD15_Pos (30UL) /*!< field PUPD15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PB_PUPD_PUPD15_Msk (0xc0000000UL) /*!< field PUPD15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PB_DS ===================================================== */
#define IOCTR_PB_DS_DS0_Pos (0UL) /*!< field DS0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PB_DS_DS0_Msk (0x00000003UL) /*!< field DS0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS1_Pos (2UL) /*!< field DS1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PB_DS_DS1_Msk (0x0000000cUL) /*!< field DS1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS2_Pos (4UL) /*!< field DS2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PB_DS_DS2_Msk (0x00000030UL) /*!< field DS2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS3_Pos (6UL) /*!< field DS3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PB_DS_DS3_Msk (0x000000c0UL) /*!< field DS3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS4_Pos (8UL) /*!< field DS4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PB_DS_DS4_Msk (0x00000300UL) /*!< field DS4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS5_Pos (10UL) /*!< field DS5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PB_DS_DS5_Msk (0x00000c00UL) /*!< field DS5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS6_Pos (12UL) /*!< field DS6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PB_DS_DS6_Msk (0x00003000UL) /*!< field DS6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS7_Pos (14UL) /*!< field DS7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PB_DS_DS7_Msk (0x0000c000UL) /*!< field DS7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS8_Pos (16UL) /*!< field DS8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PB_DS_DS8_Msk (0x00030000UL) /*!< field DS8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS9_Pos (18UL) /*!< field DS9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PB_DS_DS9_Msk (0x000c0000UL) /*!< field DS9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS10_Pos (20UL) /*!< field DS10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PB_DS_DS10_Msk (0x00300000UL) /*!< field DS10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS11_Pos (22UL) /*!< field DS11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PB_DS_DS11_Msk (0x00c00000UL) /*!< field DS11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS12_Pos (24UL) /*!< field DS12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PB_DS_DS12_Msk (0x03000000UL) /*!< field DS12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS13_Pos (26UL) /*!< field DS13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PB_DS_DS13_Msk (0x0c000000UL) /*!< field DS13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS14_Pos (28UL) /*!< field DS14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PB_DS_DS14_Msk (0x30000000UL) /*!< field DS14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PB_DS_DS15_Pos (30UL) /*!< field DS15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PB_DS_DS15_Msk (0xc0000000UL) /*!< field DS15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PB_SR ===================================================== */
#define IOCTR_PB_SR_SR0_Pos (0UL) /*!< field SR0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PB_SR_SR0_Msk (0x00000001UL) /*!< field SR0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR1_Pos (1UL) /*!< field SR1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PB_SR_SR1_Msk (0x00000002UL) /*!< field SR1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR2_Pos (2UL) /*!< field SR2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PB_SR_SR2_Msk (0x00000004UL) /*!< field SR2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR3_Pos (3UL) /*!< field SR3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PB_SR_SR3_Msk (0x00000008UL) /*!< field SR3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR4_Pos (4UL) /*!< field SR4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PB_SR_SR4_Msk (0x00000010UL) /*!< field SR4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR5_Pos (5UL) /*!< field SR5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PB_SR_SR5_Msk (0x00000020UL) /*!< field SR5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR6_Pos (6UL) /*!< field SR6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PB_SR_SR6_Msk (0x00000040UL) /*!< field SR6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR7_Pos (7UL) /*!< field SR7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PB_SR_SR7_Msk (0x00000080UL) /*!< field SR7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR8_Pos (8UL) /*!< field SR8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PB_SR_SR8_Msk (0x00000100UL) /*!< field SR8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR9_Pos (9UL) /*!< field SR9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PB_SR_SR9_Msk (0x00000200UL) /*!< field SR9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR10_Pos (10UL) /*!< field SR10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PB_SR_SR10_Msk (0x00000400UL) /*!< field SR10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR11_Pos (11UL) /*!< field SR11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PB_SR_SR11_Msk (0x00000800UL) /*!< field SR11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR12_Pos (12UL) /*!< field SR12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PB_SR_SR12_Msk (0x00001000UL) /*!< field SR12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR13_Pos (13UL) /*!< field SR13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PB_SR_SR13_Msk (0x00002000UL) /*!< field SR13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR14_Pos (14UL) /*!< field SR14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PB_SR_SR14_Msk (0x00004000UL) /*!< field SR14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_SR_SR15_Pos (15UL) /*!< field SR15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PB_SR_SR15_Msk (0x00008000UL) /*!< field SR15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PB_OTYPE ==================================================== */
#define IOCTR_PB_OTYPE_OTYPE0_Pos (0UL) /*!< field OTYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE0_Msk (0x00000001UL) /*!< field OTYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE1_Pos (1UL) /*!< field OTYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE1_Msk (0x00000002UL) /*!< field OTYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE2_Pos (2UL) /*!< field OTYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE2_Msk (0x00000004UL) /*!< field OTYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE3_Pos (3UL) /*!< field OTYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE3_Msk (0x00000008UL) /*!< field OTYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE4_Pos (4UL) /*!< field OTYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE4_Msk (0x00000010UL) /*!< field OTYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE5_Pos (5UL) /*!< field OTYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE5_Msk (0x00000020UL) /*!< field OTYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE6_Pos (6UL) /*!< field OTYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE6_Msk (0x00000040UL) /*!< field OTYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE7_Pos (7UL) /*!< field OTYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE7_Msk (0x00000080UL) /*!< field OTYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE8_Pos (8UL) /*!< field OTYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE8_Msk (0x00000100UL) /*!< field OTYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE9_Pos (9UL) /*!< field OTYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE9_Msk (0x00000200UL) /*!< field OTYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE10_Pos (10UL) /*!< field OTYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE10_Msk (0x00000400UL) /*!< field OTYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE11_Pos (11UL) /*!< field OTYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE11_Msk (0x00000800UL) /*!< field OTYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE12_Pos (12UL) /*!< field OTYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE12_Msk (0x00001000UL) /*!< field OTYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE13_Pos (13UL) /*!< field OTYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE13_Msk (0x00002000UL) /*!< field OTYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE14_Pos (14UL) /*!< field OTYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE14_Msk (0x00004000UL) /*!< field OTYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_OTYPE_OTYPE15_Pos (15UL) /*!< field OTYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PB_OTYPE_OTYPE15_Msk (0x00008000UL) /*!< field OTYPE15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PB_ITYPE ==================================================== */
#define IOCTR_PB_ITYPE_ITYPE0_Pos (0UL) /*!< field ITYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE0_Msk (0x00000001UL) /*!< field ITYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE1_Pos (1UL) /*!< field ITYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE1_Msk (0x00000002UL) /*!< field ITYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE2_Pos (2UL) /*!< field ITYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE2_Msk (0x00000004UL) /*!< field ITYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE3_Pos (3UL) /*!< field ITYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE3_Msk (0x00000008UL) /*!< field ITYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE4_Pos (4UL) /*!< field ITYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE4_Msk (0x00000010UL) /*!< field ITYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE5_Pos (5UL) /*!< field ITYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE5_Msk (0x00000020UL) /*!< field ITYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE6_Pos (6UL) /*!< field ITYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE6_Msk (0x00000040UL) /*!< field ITYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE7_Pos (7UL) /*!< field ITYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE7_Msk (0x00000080UL) /*!< field ITYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE8_Pos (8UL) /*!< field ITYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE8_Msk (0x00000100UL) /*!< field ITYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE9_Pos (9UL) /*!< field ITYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE9_Msk (0x00000200UL) /*!< field ITYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE10_Pos (10UL) /*!< field ITYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE10_Msk (0x00000400UL) /*!< field ITYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE11_Pos (11UL) /*!< field ITYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE11_Msk (0x00000800UL) /*!< field ITYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE12_Pos (12UL) /*!< field ITYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE12_Msk (0x00001000UL) /*!< field ITYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE13_Pos (13UL) /*!< field ITYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE13_Msk (0x00002000UL) /*!< field ITYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE14_Pos (14UL) /*!< field ITYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE14_Msk (0x00004000UL) /*!< field ITYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_ITYPE_ITYPE15_Pos (15UL) /*!< field ITYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PB_ITYPE_ITYPE15_Msk (0x00008000UL) /*!< field ITYPE15 (Bitfield-Mask: 0x00000001) */

/* =================================================== Register PB_I2CMODE =================================================== */
#define IOCTR_PB_I2CMODE_I2CMODE9_Pos (9UL) /*!< field I2CMODE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PB_I2CMODE_I2CMODE9_Msk (0x00000200UL) /*!< field I2CMODE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PB_I2CMODE_I2CMODE10_Pos (10UL) /*!< field I2CMODE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PB_I2CMODE_I2CMODE10_Msk (0x00000400UL) /*!< field I2CMODE10 (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register PC_MODE ==================================================== */
#define IOCTR_PC_MODE_MODE0_Pos (0UL) /*!< field MODE0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PC_MODE_MODE0_Msk (0x00000003UL) /*!< field MODE0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE1_Pos (2UL) /*!< field MODE1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PC_MODE_MODE1_Msk (0x0000000cUL) /*!< field MODE1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE2_Pos (4UL) /*!< field MODE2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PC_MODE_MODE2_Msk (0x00000030UL) /*!< field MODE2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE3_Pos (6UL) /*!< field MODE3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PC_MODE_MODE3_Msk (0x000000c0UL) /*!< field MODE3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE4_Pos (8UL) /*!< field MODE4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PC_MODE_MODE4_Msk (0x00000300UL) /*!< field MODE4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE5_Pos (10UL) /*!< field MODE5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PC_MODE_MODE5_Msk (0x00000c00UL) /*!< field MODE5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE6_Pos (12UL) /*!< field MODE6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PC_MODE_MODE6_Msk (0x00003000UL) /*!< field MODE6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE7_Pos (14UL) /*!< field MODE7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PC_MODE_MODE7_Msk (0x0000c000UL) /*!< field MODE7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE8_Pos (16UL) /*!< field MODE8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PC_MODE_MODE8_Msk (0x00030000UL) /*!< field MODE8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE9_Pos (18UL) /*!< field MODE9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PC_MODE_MODE9_Msk (0x000c0000UL) /*!< field MODE9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE10_Pos (20UL) /*!< field MODE10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PC_MODE_MODE10_Msk (0x00300000UL) /*!< field MODE10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE11_Pos (22UL) /*!< field MODE11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PC_MODE_MODE11_Msk (0x00c00000UL) /*!< field MODE11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE12_Pos (24UL) /*!< field MODE12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PC_MODE_MODE12_Msk (0x03000000UL) /*!< field MODE12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE13_Pos (26UL) /*!< field MODE13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PC_MODE_MODE13_Msk (0x0c000000UL) /*!< field MODE13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE14_Pos (28UL) /*!< field MODE14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PC_MODE_MODE14_Msk (0x30000000UL) /*!< field MODE14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_MODE_MODE15_Pos (30UL) /*!< field MODE15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PC_MODE_MODE15_Msk (0xc0000000UL) /*!< field MODE15 (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register PC_AFL ===================================================== */
#define IOCTR_PC_AFL_AFSEL0_Pos (0UL) /*!< field AFSEL0 (bitOffset 0, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL0_Msk (0x00000007UL) /*!< field AFSEL0 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL1_Pos (4UL) /*!< field AFSEL1 (bitOffset 4, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL1_Msk (0x00000070UL) /*!< field AFSEL1 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL2_Pos (8UL) /*!< field AFSEL2 (bitOffset 8, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL2_Msk (0x00000700UL) /*!< field AFSEL2 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL3_Pos (12UL) /*!< field AFSEL3 (bitOffset 12, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL3_Msk (0x00007000UL) /*!< field AFSEL3 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL4_Pos (16UL) /*!< field AFSEL4 (bitOffset 16, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL4_Msk (0x00070000UL) /*!< field AFSEL4 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL5_Pos (20UL) /*!< field AFSEL5 (bitOffset 20, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL5_Msk (0x00700000UL) /*!< field AFSEL5 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL6_Pos (24UL) /*!< field AFSEL6 (bitOffset 24, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL6_Msk (0x07000000UL) /*!< field AFSEL6 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFL_AFSEL7_Pos (28UL) /*!< field AFSEL7 (bitOffset 28, bitWidth 3) */
#define IOCTR_PC_AFL_AFSEL7_Msk (0x70000000UL) /*!< field AFSEL7 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PC_AFH ===================================================== */
#define IOCTR_PC_AFH_AFSEL8_Pos (0UL) /*!< field AFSEL8 (bitOffset 0, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL8_Msk (0x00000007UL) /*!< field AFSEL8 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL9_Pos (4UL) /*!< field AFSEL9 (bitOffset 4, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL9_Msk (0x00000070UL) /*!< field AFSEL9 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL10_Pos (8UL) /*!< field AFSEL10 (bitOffset 8, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL10_Msk (0x00000700UL) /*!< field AFSEL10 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL11_Pos (12UL) /*!< field AFSEL11 (bitOffset 12, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL11_Msk (0x00007000UL) /*!< field AFSEL11 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL12_Pos (16UL) /*!< field AFSEL12 (bitOffset 16, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL12_Msk (0x00070000UL) /*!< field AFSEL12 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL13_Pos (20UL) /*!< field AFSEL13 (bitOffset 20, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL13_Msk (0x00700000UL) /*!< field AFSEL13 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL14_Pos (24UL) /*!< field AFSEL14 (bitOffset 24, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL14_Msk (0x07000000UL) /*!< field AFSEL14 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PC_AFH_AFSEL15_Pos (28UL) /*!< field AFSEL15 (bitOffset 28, bitWidth 3) */
#define IOCTR_PC_AFH_AFSEL15_Msk (0x70000000UL) /*!< field AFSEL15 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PC_PUPD ==================================================== */
#define IOCTR_PC_PUPD_PUPD0_Pos (0UL) /*!< field PUPD0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD0_Msk (0x00000003UL) /*!< field PUPD0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD1_Pos (2UL) /*!< field PUPD1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD1_Msk (0x0000000cUL) /*!< field PUPD1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD2_Pos (4UL) /*!< field PUPD2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD2_Msk (0x00000030UL) /*!< field PUPD2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD3_Pos (6UL) /*!< field PUPD3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD3_Msk (0x000000c0UL) /*!< field PUPD3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD4_Pos (8UL) /*!< field PUPD4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD4_Msk (0x00000300UL) /*!< field PUPD4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD5_Pos (10UL) /*!< field PUPD5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD5_Msk (0x00000c00UL) /*!< field PUPD5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD6_Pos (12UL) /*!< field PUPD6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD6_Msk (0x00003000UL) /*!< field PUPD6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD7_Pos (14UL) /*!< field PUPD7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD7_Msk (0x0000c000UL) /*!< field PUPD7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD8_Pos (16UL) /*!< field PUPD8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD8_Msk (0x00030000UL) /*!< field PUPD8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD9_Pos (18UL) /*!< field PUPD9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD9_Msk (0x000c0000UL) /*!< field PUPD9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD10_Pos (20UL) /*!< field PUPD10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD10_Msk (0x00300000UL) /*!< field PUPD10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD11_Pos (22UL) /*!< field PUPD11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD11_Msk (0x00c00000UL) /*!< field PUPD11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD12_Pos (24UL) /*!< field PUPD12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD12_Msk (0x03000000UL) /*!< field PUPD12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD13_Pos (26UL) /*!< field PUPD13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD13_Msk (0x0c000000UL) /*!< field PUPD13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD14_Pos (28UL) /*!< field PUPD14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD14_Msk (0x30000000UL) /*!< field PUPD14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_PUPD_PUPD15_Pos (30UL) /*!< field PUPD15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PC_PUPD_PUPD15_Msk (0xc0000000UL) /*!< field PUPD15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PC_DS ===================================================== */
#define IOCTR_PC_DS_DS0_Pos (0UL) /*!< field DS0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PC_DS_DS0_Msk (0x00000003UL) /*!< field DS0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS1_Pos (2UL) /*!< field DS1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PC_DS_DS1_Msk (0x0000000cUL) /*!< field DS1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS2_Pos (4UL) /*!< field DS2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PC_DS_DS2_Msk (0x00000030UL) /*!< field DS2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS3_Pos (6UL) /*!< field DS3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PC_DS_DS3_Msk (0x000000c0UL) /*!< field DS3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS4_Pos (8UL) /*!< field DS4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PC_DS_DS4_Msk (0x00000300UL) /*!< field DS4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS5_Pos (10UL) /*!< field DS5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PC_DS_DS5_Msk (0x00000c00UL) /*!< field DS5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS6_Pos (12UL) /*!< field DS6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PC_DS_DS6_Msk (0x00003000UL) /*!< field DS6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS7_Pos (14UL) /*!< field DS7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PC_DS_DS7_Msk (0x0000c000UL) /*!< field DS7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS8_Pos (16UL) /*!< field DS8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PC_DS_DS8_Msk (0x00030000UL) /*!< field DS8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS9_Pos (18UL) /*!< field DS9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PC_DS_DS9_Msk (0x000c0000UL) /*!< field DS9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS10_Pos (20UL) /*!< field DS10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PC_DS_DS10_Msk (0x00300000UL) /*!< field DS10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS11_Pos (22UL) /*!< field DS11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PC_DS_DS11_Msk (0x00c00000UL) /*!< field DS11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS12_Pos (24UL) /*!< field DS12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PC_DS_DS12_Msk (0x03000000UL) /*!< field DS12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS13_Pos (26UL) /*!< field DS13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PC_DS_DS13_Msk (0x0c000000UL) /*!< field DS13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS14_Pos (28UL) /*!< field DS14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PC_DS_DS14_Msk (0x30000000UL) /*!< field DS14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PC_DS_DS15_Pos (30UL) /*!< field DS15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PC_DS_DS15_Msk (0xc0000000UL) /*!< field DS15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PC_SR ===================================================== */
#define IOCTR_PC_SR_SR0_Pos (0UL) /*!< field SR0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PC_SR_SR0_Msk (0x00000001UL) /*!< field SR0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR1_Pos (1UL) /*!< field SR1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PC_SR_SR1_Msk (0x00000002UL) /*!< field SR1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR2_Pos (2UL) /*!< field SR2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PC_SR_SR2_Msk (0x00000004UL) /*!< field SR2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR3_Pos (3UL) /*!< field SR3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PC_SR_SR3_Msk (0x00000008UL) /*!< field SR3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR4_Pos (4UL) /*!< field SR4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PC_SR_SR4_Msk (0x00000010UL) /*!< field SR4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR5_Pos (5UL) /*!< field SR5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PC_SR_SR5_Msk (0x00000020UL) /*!< field SR5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR6_Pos (6UL) /*!< field SR6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PC_SR_SR6_Msk (0x00000040UL) /*!< field SR6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR7_Pos (7UL) /*!< field SR7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PC_SR_SR7_Msk (0x00000080UL) /*!< field SR7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR8_Pos (8UL) /*!< field SR8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PC_SR_SR8_Msk (0x00000100UL) /*!< field SR8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR9_Pos (9UL) /*!< field SR9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PC_SR_SR9_Msk (0x00000200UL) /*!< field SR9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR10_Pos (10UL) /*!< field SR10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PC_SR_SR10_Msk (0x00000400UL) /*!< field SR10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR11_Pos (11UL) /*!< field SR11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PC_SR_SR11_Msk (0x00000800UL) /*!< field SR11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR12_Pos (12UL) /*!< field SR12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PC_SR_SR12_Msk (0x00001000UL) /*!< field SR12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR13_Pos (13UL) /*!< field SR13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PC_SR_SR13_Msk (0x00002000UL) /*!< field SR13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR14_Pos (14UL) /*!< field SR14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PC_SR_SR14_Msk (0x00004000UL) /*!< field SR14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_SR_SR15_Pos (15UL) /*!< field SR15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PC_SR_SR15_Msk (0x00008000UL) /*!< field SR15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PC_OTYPE ==================================================== */
#define IOCTR_PC_OTYPE_OTYPE0_Pos (0UL) /*!< field OTYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE0_Msk (0x00000001UL) /*!< field OTYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE1_Pos (1UL) /*!< field OTYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE1_Msk (0x00000002UL) /*!< field OTYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE2_Pos (2UL) /*!< field OTYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE2_Msk (0x00000004UL) /*!< field OTYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE3_Pos (3UL) /*!< field OTYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE3_Msk (0x00000008UL) /*!< field OTYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE4_Pos (4UL) /*!< field OTYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE4_Msk (0x00000010UL) /*!< field OTYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE5_Pos (5UL) /*!< field OTYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE5_Msk (0x00000020UL) /*!< field OTYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE6_Pos (6UL) /*!< field OTYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE6_Msk (0x00000040UL) /*!< field OTYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE7_Pos (7UL) /*!< field OTYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE7_Msk (0x00000080UL) /*!< field OTYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE8_Pos (8UL) /*!< field OTYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE8_Msk (0x00000100UL) /*!< field OTYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE9_Pos (9UL) /*!< field OTYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE9_Msk (0x00000200UL) /*!< field OTYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE10_Pos (10UL) /*!< field OTYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE10_Msk (0x00000400UL) /*!< field OTYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE11_Pos (11UL) /*!< field OTYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE11_Msk (0x00000800UL) /*!< field OTYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE12_Pos (12UL) /*!< field OTYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE12_Msk (0x00001000UL) /*!< field OTYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE13_Pos (13UL) /*!< field OTYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE13_Msk (0x00002000UL) /*!< field OTYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE14_Pos (14UL) /*!< field OTYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE14_Msk (0x00004000UL) /*!< field OTYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_OTYPE_OTYPE15_Pos (15UL) /*!< field OTYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PC_OTYPE_OTYPE15_Msk (0x00008000UL) /*!< field OTYPE15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PC_ITYPE ==================================================== */
#define IOCTR_PC_ITYPE_ITYPE0_Pos (0UL) /*!< field ITYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE0_Msk (0x00000001UL) /*!< field ITYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE1_Pos (1UL) /*!< field ITYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE1_Msk (0x00000002UL) /*!< field ITYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE2_Pos (2UL) /*!< field ITYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE2_Msk (0x00000004UL) /*!< field ITYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE3_Pos (3UL) /*!< field ITYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE3_Msk (0x00000008UL) /*!< field ITYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE4_Pos (4UL) /*!< field ITYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE4_Msk (0x00000010UL) /*!< field ITYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE5_Pos (5UL) /*!< field ITYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE5_Msk (0x00000020UL) /*!< field ITYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE6_Pos (6UL) /*!< field ITYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE6_Msk (0x00000040UL) /*!< field ITYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE7_Pos (7UL) /*!< field ITYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE7_Msk (0x00000080UL) /*!< field ITYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE8_Pos (8UL) /*!< field ITYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE8_Msk (0x00000100UL) /*!< field ITYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE9_Pos (9UL) /*!< field ITYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE9_Msk (0x00000200UL) /*!< field ITYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE10_Pos (10UL) /*!< field ITYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE10_Msk (0x00000400UL) /*!< field ITYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE11_Pos (11UL) /*!< field ITYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE11_Msk (0x00000800UL) /*!< field ITYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE12_Pos (12UL) /*!< field ITYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE12_Msk (0x00001000UL) /*!< field ITYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE13_Pos (13UL) /*!< field ITYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE13_Msk (0x00002000UL) /*!< field ITYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE14_Pos (14UL) /*!< field ITYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE14_Msk (0x00004000UL) /*!< field ITYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PC_ITYPE_ITYPE15_Pos (15UL) /*!< field ITYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PC_ITYPE_ITYPE15_Msk (0x00008000UL) /*!< field ITYPE15 (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register PD_MODE ==================================================== */
#define IOCTR_PD_MODE_MODE0_Pos (0UL) /*!< field MODE0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PD_MODE_MODE0_Msk (0x00000003UL) /*!< field MODE0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE1_Pos (2UL) /*!< field MODE1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PD_MODE_MODE1_Msk (0x0000000cUL) /*!< field MODE1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE2_Pos (4UL) /*!< field MODE2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PD_MODE_MODE2_Msk (0x00000030UL) /*!< field MODE2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE3_Pos (6UL) /*!< field MODE3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PD_MODE_MODE3_Msk (0x000000c0UL) /*!< field MODE3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE4_Pos (8UL) /*!< field MODE4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PD_MODE_MODE4_Msk (0x00000300UL) /*!< field MODE4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE5_Pos (10UL) /*!< field MODE5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PD_MODE_MODE5_Msk (0x00000c00UL) /*!< field MODE5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE6_Pos (12UL) /*!< field MODE6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PD_MODE_MODE6_Msk (0x00003000UL) /*!< field MODE6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE7_Pos (14UL) /*!< field MODE7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PD_MODE_MODE7_Msk (0x0000c000UL) /*!< field MODE7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE8_Pos (16UL) /*!< field MODE8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PD_MODE_MODE8_Msk (0x00030000UL) /*!< field MODE8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE9_Pos (18UL) /*!< field MODE9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PD_MODE_MODE9_Msk (0x000c0000UL) /*!< field MODE9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE10_Pos (20UL) /*!< field MODE10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PD_MODE_MODE10_Msk (0x00300000UL) /*!< field MODE10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE11_Pos (22UL) /*!< field MODE11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PD_MODE_MODE11_Msk (0x00c00000UL) /*!< field MODE11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE12_Pos (24UL) /*!< field MODE12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PD_MODE_MODE12_Msk (0x03000000UL) /*!< field MODE12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE13_Pos (26UL) /*!< field MODE13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PD_MODE_MODE13_Msk (0x0c000000UL) /*!< field MODE13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE14_Pos (28UL) /*!< field MODE14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PD_MODE_MODE14_Msk (0x30000000UL) /*!< field MODE14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_MODE_MODE15_Pos (30UL) /*!< field MODE15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PD_MODE_MODE15_Msk (0xc0000000UL) /*!< field MODE15 (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register PD_AFL ===================================================== */
#define IOCTR_PD_AFL_AFSEL0_Pos (0UL) /*!< field AFSEL0 (bitOffset 0, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL0_Msk (0x00000007UL) /*!< field AFSEL0 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL1_Pos (4UL) /*!< field AFSEL1 (bitOffset 4, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL1_Msk (0x00000070UL) /*!< field AFSEL1 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL2_Pos (8UL) /*!< field AFSEL2 (bitOffset 8, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL2_Msk (0x00000700UL) /*!< field AFSEL2 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL3_Pos (12UL) /*!< field AFSEL3 (bitOffset 12, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL3_Msk (0x00007000UL) /*!< field AFSEL3 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL4_Pos (16UL) /*!< field AFSEL4 (bitOffset 16, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL4_Msk (0x00070000UL) /*!< field AFSEL4 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL5_Pos (20UL) /*!< field AFSEL5 (bitOffset 20, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL5_Msk (0x00700000UL) /*!< field AFSEL5 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL6_Pos (24UL) /*!< field AFSEL6 (bitOffset 24, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL6_Msk (0x07000000UL) /*!< field AFSEL6 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFL_AFSEL7_Pos (28UL) /*!< field AFSEL7 (bitOffset 28, bitWidth 3) */
#define IOCTR_PD_AFL_AFSEL7_Msk (0x70000000UL) /*!< field AFSEL7 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PD_AFH ===================================================== */
#define IOCTR_PD_AFH_AFSEL8_Pos (0UL) /*!< field AFSEL8 (bitOffset 0, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL8_Msk (0x00000007UL) /*!< field AFSEL8 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL9_Pos (4UL) /*!< field AFSEL9 (bitOffset 4, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL9_Msk (0x00000070UL) /*!< field AFSEL9 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL10_Pos (8UL) /*!< field AFSEL10 (bitOffset 8, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL10_Msk (0x00000700UL) /*!< field AFSEL10 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL11_Pos (12UL) /*!< field AFSEL11 (bitOffset 12, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL11_Msk (0x00007000UL) /*!< field AFSEL11 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL12_Pos (16UL) /*!< field AFSEL12 (bitOffset 16, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL12_Msk (0x00070000UL) /*!< field AFSEL12 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL13_Pos (20UL) /*!< field AFSEL13 (bitOffset 20, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL13_Msk (0x00700000UL) /*!< field AFSEL13 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL14_Pos (24UL) /*!< field AFSEL14 (bitOffset 24, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL14_Msk (0x07000000UL) /*!< field AFSEL14 (Bitfield-Mask: 0x00000007) */
#define IOCTR_PD_AFH_AFSEL15_Pos (28UL) /*!< field AFSEL15 (bitOffset 28, bitWidth 3) */
#define IOCTR_PD_AFH_AFSEL15_Msk (0x70000000UL) /*!< field AFSEL15 (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register PD_PUPD ==================================================== */
#define IOCTR_PD_PUPD_PUPD0_Pos (0UL) /*!< field PUPD0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD0_Msk (0x00000003UL) /*!< field PUPD0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD1_Pos (2UL) /*!< field PUPD1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD1_Msk (0x0000000cUL) /*!< field PUPD1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD2_Pos (4UL) /*!< field PUPD2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD2_Msk (0x00000030UL) /*!< field PUPD2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD3_Pos (6UL) /*!< field PUPD3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD3_Msk (0x000000c0UL) /*!< field PUPD3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD4_Pos (8UL) /*!< field PUPD4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD4_Msk (0x00000300UL) /*!< field PUPD4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD5_Pos (10UL) /*!< field PUPD5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD5_Msk (0x00000c00UL) /*!< field PUPD5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD6_Pos (12UL) /*!< field PUPD6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD6_Msk (0x00003000UL) /*!< field PUPD6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD7_Pos (14UL) /*!< field PUPD7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD7_Msk (0x0000c000UL) /*!< field PUPD7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD8_Pos (16UL) /*!< field PUPD8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD8_Msk (0x00030000UL) /*!< field PUPD8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD9_Pos (18UL) /*!< field PUPD9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD9_Msk (0x000c0000UL) /*!< field PUPD9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD10_Pos (20UL) /*!< field PUPD10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD10_Msk (0x00300000UL) /*!< field PUPD10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD11_Pos (22UL) /*!< field PUPD11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD11_Msk (0x00c00000UL) /*!< field PUPD11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD12_Pos (24UL) /*!< field PUPD12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD12_Msk (0x03000000UL) /*!< field PUPD12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD13_Pos (26UL) /*!< field PUPD13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD13_Msk (0x0c000000UL) /*!< field PUPD13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD14_Pos (28UL) /*!< field PUPD14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD14_Msk (0x30000000UL) /*!< field PUPD14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_PUPD_PUPD15_Pos (30UL) /*!< field PUPD15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PD_PUPD_PUPD15_Msk (0xc0000000UL) /*!< field PUPD15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PD_DS ===================================================== */
#define IOCTR_PD_DS_DS0_Pos (0UL) /*!< field DS0 (bitOffset 0, bitWidth 2) */
#define IOCTR_PD_DS_DS0_Msk (0x00000003UL) /*!< field DS0 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS1_Pos (2UL) /*!< field DS1 (bitOffset 2, bitWidth 2) */
#define IOCTR_PD_DS_DS1_Msk (0x0000000cUL) /*!< field DS1 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS2_Pos (4UL) /*!< field DS2 (bitOffset 4, bitWidth 2) */
#define IOCTR_PD_DS_DS2_Msk (0x00000030UL) /*!< field DS2 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS3_Pos (6UL) /*!< field DS3 (bitOffset 6, bitWidth 2) */
#define IOCTR_PD_DS_DS3_Msk (0x000000c0UL) /*!< field DS3 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS4_Pos (8UL) /*!< field DS4 (bitOffset 8, bitWidth 2) */
#define IOCTR_PD_DS_DS4_Msk (0x00000300UL) /*!< field DS4 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS5_Pos (10UL) /*!< field DS5 (bitOffset 10, bitWidth 2) */
#define IOCTR_PD_DS_DS5_Msk (0x00000c00UL) /*!< field DS5 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS6_Pos (12UL) /*!< field DS6 (bitOffset 12, bitWidth 2) */
#define IOCTR_PD_DS_DS6_Msk (0x00003000UL) /*!< field DS6 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS7_Pos (14UL) /*!< field DS7 (bitOffset 14, bitWidth 2) */
#define IOCTR_PD_DS_DS7_Msk (0x0000c000UL) /*!< field DS7 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS8_Pos (16UL) /*!< field DS8 (bitOffset 16, bitWidth 2) */
#define IOCTR_PD_DS_DS8_Msk (0x00030000UL) /*!< field DS8 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS9_Pos (18UL) /*!< field DS9 (bitOffset 18, bitWidth 2) */
#define IOCTR_PD_DS_DS9_Msk (0x000c0000UL) /*!< field DS9 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS10_Pos (20UL) /*!< field DS10 (bitOffset 20, bitWidth 2) */
#define IOCTR_PD_DS_DS10_Msk (0x00300000UL) /*!< field DS10 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS11_Pos (22UL) /*!< field DS11 (bitOffset 22, bitWidth 2) */
#define IOCTR_PD_DS_DS11_Msk (0x00c00000UL) /*!< field DS11 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS12_Pos (24UL) /*!< field DS12 (bitOffset 24, bitWidth 2) */
#define IOCTR_PD_DS_DS12_Msk (0x03000000UL) /*!< field DS12 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS13_Pos (26UL) /*!< field DS13 (bitOffset 26, bitWidth 2) */
#define IOCTR_PD_DS_DS13_Msk (0x0c000000UL) /*!< field DS13 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS14_Pos (28UL) /*!< field DS14 (bitOffset 28, bitWidth 2) */
#define IOCTR_PD_DS_DS14_Msk (0x30000000UL) /*!< field DS14 (Bitfield-Mask: 0x00000003) */
#define IOCTR_PD_DS_DS15_Pos (30UL) /*!< field DS15 (bitOffset 30, bitWidth 2) */
#define IOCTR_PD_DS_DS15_Msk (0xc0000000UL) /*!< field DS15 (Bitfield-Mask: 0x00000003) */

/* ====================================================== Register PD_SR ===================================================== */
#define IOCTR_PD_SR_SR0_Pos (0UL) /*!< field SR0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PD_SR_SR0_Msk (0x00000001UL) /*!< field SR0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR1_Pos (1UL) /*!< field SR1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PD_SR_SR1_Msk (0x00000002UL) /*!< field SR1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR2_Pos (2UL) /*!< field SR2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PD_SR_SR2_Msk (0x00000004UL) /*!< field SR2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR3_Pos (3UL) /*!< field SR3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PD_SR_SR3_Msk (0x00000008UL) /*!< field SR3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR4_Pos (4UL) /*!< field SR4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PD_SR_SR4_Msk (0x00000010UL) /*!< field SR4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR5_Pos (5UL) /*!< field SR5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PD_SR_SR5_Msk (0x00000020UL) /*!< field SR5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR6_Pos (6UL) /*!< field SR6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PD_SR_SR6_Msk (0x00000040UL) /*!< field SR6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR7_Pos (7UL) /*!< field SR7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PD_SR_SR7_Msk (0x00000080UL) /*!< field SR7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR8_Pos (8UL) /*!< field SR8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PD_SR_SR8_Msk (0x00000100UL) /*!< field SR8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR9_Pos (9UL) /*!< field SR9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PD_SR_SR9_Msk (0x00000200UL) /*!< field SR9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR10_Pos (10UL) /*!< field SR10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PD_SR_SR10_Msk (0x00000400UL) /*!< field SR10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR11_Pos (11UL) /*!< field SR11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PD_SR_SR11_Msk (0x00000800UL) /*!< field SR11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR12_Pos (12UL) /*!< field SR12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PD_SR_SR12_Msk (0x00001000UL) /*!< field SR12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR13_Pos (13UL) /*!< field SR13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PD_SR_SR13_Msk (0x00002000UL) /*!< field SR13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR14_Pos (14UL) /*!< field SR14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PD_SR_SR14_Msk (0x00004000UL) /*!< field SR14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_SR_SR15_Pos (15UL) /*!< field SR15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PD_SR_SR15_Msk (0x00008000UL) /*!< field SR15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PD_OTYPE ==================================================== */
#define IOCTR_PD_OTYPE_OTYPE0_Pos (0UL) /*!< field OTYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE0_Msk (0x00000001UL) /*!< field OTYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE1_Pos (1UL) /*!< field OTYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE1_Msk (0x00000002UL) /*!< field OTYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE2_Pos (2UL) /*!< field OTYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE2_Msk (0x00000004UL) /*!< field OTYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE3_Pos (3UL) /*!< field OTYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE3_Msk (0x00000008UL) /*!< field OTYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE4_Pos (4UL) /*!< field OTYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE4_Msk (0x00000010UL) /*!< field OTYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE5_Pos (5UL) /*!< field OTYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE5_Msk (0x00000020UL) /*!< field OTYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE6_Pos (6UL) /*!< field OTYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE6_Msk (0x00000040UL) /*!< field OTYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE7_Pos (7UL) /*!< field OTYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE7_Msk (0x00000080UL) /*!< field OTYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE8_Pos (8UL) /*!< field OTYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE8_Msk (0x00000100UL) /*!< field OTYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE9_Pos (9UL) /*!< field OTYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE9_Msk (0x00000200UL) /*!< field OTYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE10_Pos (10UL) /*!< field OTYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE10_Msk (0x00000400UL) /*!< field OTYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE11_Pos (11UL) /*!< field OTYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE11_Msk (0x00000800UL) /*!< field OTYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE12_Pos (12UL) /*!< field OTYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE12_Msk (0x00001000UL) /*!< field OTYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE13_Pos (13UL) /*!< field OTYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE13_Msk (0x00002000UL) /*!< field OTYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE14_Pos (14UL) /*!< field OTYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE14_Msk (0x00004000UL) /*!< field OTYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_OTYPE_OTYPE15_Pos (15UL) /*!< field OTYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PD_OTYPE_OTYPE15_Msk (0x00008000UL) /*!< field OTYPE15 (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PD_ITYPE ==================================================== */
#define IOCTR_PD_ITYPE_ITYPE0_Pos (0UL) /*!< field ITYPE0 (bitOffset 0, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE0_Msk (0x00000001UL) /*!< field ITYPE0 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE1_Pos (1UL) /*!< field ITYPE1 (bitOffset 1, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE1_Msk (0x00000002UL) /*!< field ITYPE1 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE2_Pos (2UL) /*!< field ITYPE2 (bitOffset 2, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE2_Msk (0x00000004UL) /*!< field ITYPE2 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE3_Pos (3UL) /*!< field ITYPE3 (bitOffset 3, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE3_Msk (0x00000008UL) /*!< field ITYPE3 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE4_Pos (4UL) /*!< field ITYPE4 (bitOffset 4, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE4_Msk (0x00000010UL) /*!< field ITYPE4 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE5_Pos (5UL) /*!< field ITYPE5 (bitOffset 5, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE5_Msk (0x00000020UL) /*!< field ITYPE5 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE6_Pos (6UL) /*!< field ITYPE6 (bitOffset 6, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE6_Msk (0x00000040UL) /*!< field ITYPE6 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE7_Pos (7UL) /*!< field ITYPE7 (bitOffset 7, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE7_Msk (0x00000080UL) /*!< field ITYPE7 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE8_Pos (8UL) /*!< field ITYPE8 (bitOffset 8, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE8_Msk (0x00000100UL) /*!< field ITYPE8 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE9_Pos (9UL) /*!< field ITYPE9 (bitOffset 9, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE9_Msk (0x00000200UL) /*!< field ITYPE9 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE10_Pos (10UL) /*!< field ITYPE10 (bitOffset 10, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE10_Msk (0x00000400UL) /*!< field ITYPE10 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE11_Pos (11UL) /*!< field ITYPE11 (bitOffset 11, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE11_Msk (0x00000800UL) /*!< field ITYPE11 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE12_Pos (12UL) /*!< field ITYPE12 (bitOffset 12, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE12_Msk (0x00001000UL) /*!< field ITYPE12 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE13_Pos (13UL) /*!< field ITYPE13 (bitOffset 13, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE13_Msk (0x00002000UL) /*!< field ITYPE13 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE14_Pos (14UL) /*!< field ITYPE14 (bitOffset 14, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE14_Msk (0x00004000UL) /*!< field ITYPE14 (Bitfield-Mask: 0x00000001) */
#define IOCTR_PD_ITYPE_ITYPE15_Pos (15UL) /*!< field ITYPE15 (bitOffset 15, bitWidth 1) */
#define IOCTR_PD_ITYPE_ITYPE15_Msk (0x00008000UL) /*!< field ITYPE15 (Bitfield-Mask: 0x00000001) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: CLKCTR =============================================== */
/* =========================================================================================================================== */

/* ===================================================== Register PLLCFG ===================================================== */
#define CLKCTR_PLLCFG_SEL_Pos (0UL) /*!< field SEL (bitOffset 0, bitWidth 9) */
#define CLKCTR_PLLCFG_SEL_Msk (0x000001ffUL) /*!< field SEL (Bitfield-Mask: 0x000001ff) */
#define CLKCTR_PLLCFG_MAN_Pos (9UL) /*!< field MAN (bitOffset 9, bitWidth 1) */
#define CLKCTR_PLLCFG_MAN_Msk (0x00000200UL) /*!< field MAN (Bitfield-Mask: 0x00000001) */
#define CLKCTR_PLLCFG_OD_MAN_Pos (10UL) /*!< field OD_MAN (bitOffset 10, bitWidth 4) */
#define CLKCTR_PLLCFG_OD_MAN_Msk (0x00003c00UL) /*!< field OD_MAN (Bitfield-Mask: 0x0000000f) */
#define CLKCTR_PLLCFG_NF_MAN_Pos (14UL) /*!< field NF_MAN (bitOffset 14, bitWidth 13) */
#define CLKCTR_PLLCFG_NF_MAN_Msk (0x07ffc000UL) /*!< field NF_MAN (Bitfield-Mask: 0x00001fff) */
#define CLKCTR_PLLCFG_NR_MAN_Pos (27UL) /*!< field NR_MAN (bitOffset 27, bitWidth 4) */
#define CLKCTR_PLLCFG_NR_MAN_Msk (0x78000000UL) /*!< field NR_MAN (Bitfield-Mask: 0x0000000f) */
#define CLKCTR_PLLCFG_LOCK_Pos (31UL) /*!< field LOCK (bitOffset 31, bitWidth 1) */
#define CLKCTR_PLLCFG_LOCK_Msk (0x80000000UL) /*!< field LOCK (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register PLLDIAG ==================================================== */
#define CLKCTR_PLLDIAG_TEST_Pos (0UL) /*!< field TEST (bitOffset 0, bitWidth 1) */
#define CLKCTR_PLLDIAG_TEST_Msk (0x00000001UL) /*!< field TEST (Bitfield-Mask: 0x00000001) */
#define CLKCTR_PLLDIAG_ENSAT_Pos (1UL) /*!< field ENSAT (bitOffset 1, bitWidth 1) */
#define CLKCTR_PLLDIAG_ENSAT_Msk (0x00000002UL) /*!< field ENSAT (Bitfield-Mask: 0x00000001) */
#define CLKCTR_PLLDIAG_FASTEN_Pos (2UL) /*!< field FASTEN (bitOffset 2, bitWidth 1) */
#define CLKCTR_PLLDIAG_FASTEN_Msk (0x00000004UL) /*!< field FASTEN (Bitfield-Mask: 0x00000001) */
#define CLKCTR_PLLDIAG_MACRO_LOCK_Pos (4UL) /*!< field MACRO_LOCK (bitOffset 4, bitWidth 1) */
#define CLKCTR_PLLDIAG_MACRO_LOCK_Msk (0x00000010UL) /*!< field MACRO_LOCK (Bitfield-Mask: 0x00000001) */

/* ======================================================= Register CFG ====================================================== */
#define CLKCTR_CFG_FCLK_SCALE_EN_Pos (0UL) /*!< field FCLK_SCALE_EN (bitOffset 0, bitWidth 1) */
#define CLKCTR_CFG_FCLK_SCALE_EN_Msk (0x00000001UL) /*!< field FCLK_SCALE_EN (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CFG_MAINCLK_SEL_Pos (4UL) /*!< field MAINCLK_SEL (bitOffset 4, bitWidth 2) */
#define CLKCTR_CFG_MAINCLK_SEL_Msk (0x00000030UL) /*!< field MAINCLK_SEL (Bitfield-Mask: 0x00000003) */
#define CLKCTR_CFG_PLLREF_SEL_Pos (6UL) /*!< field PLLREF_SEL (bitOffset 6, bitWidth 1) */
#define CLKCTR_CFG_PLLREF_SEL_Msk (0x00000040UL) /*!< field PLLREF_SEL (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CFG_USBCLK_SEL_Pos (7UL) /*!< field USBCLK_SEL (bitOffset 7, bitWidth 1) */
#define CLKCTR_CFG_USBCLK_SEL_Msk (0x00000080UL) /*!< field USBCLK_SEL (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CFG_I2SCLK_SEL_Pos (8UL) /*!< field I2SCLK_SEL (bitOffset 8, bitWidth 1) */
#define CLKCTR_CFG_I2SCLK_SEL_Msk (0x00000100UL) /*!< field I2SCLK_SEL (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CFG_MCO_SEL_Pos (9UL) /*!< field MCO_SEL (bitOffset 9, bitWidth 3) */
#define CLKCTR_CFG_MCO_SEL_Msk (0x00000e00UL) /*!< field MCO_SEL (Bitfield-Mask: 0x00000007) */
#define CLKCTR_CFG_MCO_EN_Pos (13UL) /*!< field MCO_EN (bitOffset 13, bitWidth 1) */
#define CLKCTR_CFG_MCO_EN_Msk (0x00002000UL) /*!< field MCO_EN (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CFG_HFE_MODE_Pos (16UL) /*!< field HFE_MODE (bitOffset 16, bitWidth 2) */
#define CLKCTR_CFG_HFE_MODE_Msk (0x00030000UL) /*!< field HFE_MODE (Bitfield-Mask: 0x00000003) */
#define CLKCTR_CFG_HFE_FREQ_Pos (18UL) /*!< field HFE_FREQ (bitOffset 18, bitWidth 2) */
#define CLKCTR_CFG_HFE_FREQ_Msk (0x000c0000UL) /*!< field HFE_FREQ (Bitfield-Mask: 0x00000003) */

/* ==================================================== Register CLKFORCE ==================================================== */
#define CLKCTR_CLKFORCE_SYS_SYSCLK_FORCE_Pos (1UL) /*!< field SYS_SYSCLK_FORCE (bitOffset 1, bitWidth 1) */
#define CLKCTR_CLKFORCE_SYS_SYSCLK_FORCE_Msk (0x00000002UL) /*!< field SYS_SYSCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_SYS_FCLK_FORCE_Pos (2UL) /*!< field SYS_FCLK_FORCE (bitOffset 2, bitWidth 1) */
#define CLKCTR_CLKFORCE_SYS_FCLK_FORCE_Msk (0x00000004UL) /*!< field SYS_FCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_SRAM_SYSCLK_FORCE_Pos (3UL) /*!< field SRAM_SYSCLK_FORCE (bitOffset 3, bitWidth 1) */
#define CLKCTR_CLKFORCE_SRAM_SYSCLK_FORCE_Msk (0x00000008UL) /*!< field SRAM_SYSCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_SRAM_FCLK_FORCE_Pos (4UL) /*!< field SRAM_FCLK_FORCE (bitOffset 4, bitWidth 1) */
#define CLKCTR_CLKFORCE_SRAM_FCLK_FORCE_Msk (0x00000010UL) /*!< field SRAM_FCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_CPU_SYSCLK_FORCE_Pos (5UL) /*!< field CPU_SYSCLK_FORCE (bitOffset 5, bitWidth 1) */
#define CLKCTR_CLKFORCE_CPU_SYSCLK_FORCE_Msk (0x00000020UL) /*!< field CPU_SYSCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_CPU_FCLK_FORCE_Pos (6UL) /*!< field CPU_FCLK_FORCE (bitOffset 6, bitWidth 1) */
#define CLKCTR_CLKFORCE_CPU_FCLK_FORCE_Msk (0x00000040UL) /*!< field CPU_FCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_CRYPTO_SYSCLK_FORCE_Pos (7UL) /*!< field CRYPTO_SYSCLK_FORCE (bitOffset 7, bitWidth 1) */
#define CLKCTR_CLKFORCE_CRYPTO_SYSCLK_FORCE_Msk (0x00000080UL) /*!< field CRYPTO_SYSCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_CPUDBG_PIKCLK_FORCE_Pos (8UL) /*!< field CPUDBG_PIKCLK_FORCE (bitOffset 8, bitWidth 1) */
#define CLKCTR_CLKFORCE_CPUDBG_PIKCLK_FORCE_Msk (0x00000100UL) /*!< field CPUDBG_PIKCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_BASE_PIKCLK_FORCE_Pos (9UL) /*!< field BASE_PIKCLK_FORCE (bitOffset 9, bitWidth 1) */
#define CLKCTR_CLKFORCE_BASE_PIKCLK_FORCE_Msk (0x00000200UL) /*!< field BASE_PIKCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_SMCCLK_FORCE_Pos (10UL) /*!< field SMCCLK_FORCE (bitOffset 10, bitWidth 1) */
#define CLKCTR_CLKFORCE_SMCCLK_FORCE_Msk (0x00000400UL) /*!< field SMCCLK_FORCE (Bitfield-Mask: 0x00000001) */
#define CLKCTR_CLKFORCE_GMS_SYSCLK_FORCE_Pos (11UL) /*!< field GMS_SYSCLK_FORCE (bitOffset 11, bitWidth 1) */
#define CLKCTR_CLKFORCE_GMS_SYSCLK_FORCE_Msk (0x00000800UL) /*!< field GMS_SYSCLK_FORCE (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register FCLKDIV ==================================================== */
#define CLKCTR_FCLKDIV_FCLKDIV_Pos (0UL) /*!< field FCLKDIV (bitOffset 0, bitWidth 5) */
#define CLKCTR_FCLKDIV_FCLKDIV_Msk (0x0000001fUL) /*!< field FCLKDIV (Bitfield-Mask: 0x0000001f) */
#define CLKCTR_FCLKDIV_FCLKDIV_CUR_Pos (16UL) /*!< field FCLKDIV_CUR (bitOffset 16, bitWidth 5) */
#define CLKCTR_FCLKDIV_FCLKDIV_CUR_Msk (0x001f0000UL) /*!< field FCLKDIV_CUR (Bitfield-Mask: 0x0000001f) */

/* ==================================================== Register SYSCLKDIV =================================================== */
#define CLKCTR_SYSCLKDIV_STSCLKDIV_Pos (0UL) /*!< field STSCLKDIV (bitOffset 0, bitWidth 5) */
#define CLKCTR_SYSCLKDIV_STSCLKDIV_Msk (0x0000001fUL) /*!< field STSCLKDIV (Bitfield-Mask: 0x0000001f) */
#define CLKCTR_SYSCLKDIV_STSCLKDIV_CUR_Pos (16UL) /*!< field STSCLKDIV_CUR (bitOffset 16, bitWidth 5) */
#define CLKCTR_SYSCLKDIV_STSCLKDIV_CUR_Msk (0x001f0000UL) /*!< field STSCLKDIV_CUR (Bitfield-Mask: 0x0000001f) */

/* =================================================== Register QSPICLKDIV =================================================== */
#define CLKCTR_QSPICLKDIV_QSPICLKDIV_Pos (0UL) /*!< field QSPICLKDIV (bitOffset 0, bitWidth 5) */
#define CLKCTR_QSPICLKDIV_QSPICLKDIV_Msk (0x0000001fUL) /*!< field QSPICLKDIV (Bitfield-Mask: 0x0000001f) */
#define CLKCTR_QSPICLKDIV_QSPICLKDIV_CUR_Pos (16UL) /*!< field QSPICLKDIV_CUR (bitOffset 16, bitWidth 5) */
#define CLKCTR_QSPICLKDIV_QSPICLKDIV_CUR_Msk (0x001f0000UL) /*!< field QSPICLKDIV_CUR (Bitfield-Mask: 0x0000001f) */

/* ==================================================== Register I2SCLKDIV =================================================== */
#define CLKCTR_I2SCLKDIV_I2SCLKDIV_Pos (0UL) /*!< field I2SCLKDIV (bitOffset 0, bitWidth 5) */
#define CLKCTR_I2SCLKDIV_I2SCLKDIV_Msk (0x0000001fUL) /*!< field I2SCLKDIV (Bitfield-Mask: 0x0000001f) */
#define CLKCTR_I2SCLKDIV_I2SCLKDIV_CUR_Pos (16UL) /*!< field I2SCLKDIV_CUR (bitOffset 16, bitWidth 5) */
#define CLKCTR_I2SCLKDIV_I2SCLKDIV_CUR_Msk (0x001f0000UL) /*!< field I2SCLKDIV_CUR (Bitfield-Mask: 0x0000001f) */

/* ===================================================== Register MCODIV ===================================================== */
#define CLKCTR_MCODIV_MCODIV_Pos (0UL) /*!< field MCODIV (bitOffset 0, bitWidth 5) */
#define CLKCTR_MCODIV_MCODIV_Msk (0x0000001fUL) /*!< field MCODIV (Bitfield-Mask: 0x0000001f) */
#define CLKCTR_MCODIV_MCODIV_CUR_Pos (16UL) /*!< field MCODIV_CUR (bitOffset 16, bitWidth 5) */
#define CLKCTR_MCODIV_MCODIV_CUR_Msk (0x001f0000UL) /*!< field MCODIV_CUR (Bitfield-Mask: 0x0000001f) */

/* =================================================== Register GNSSCLKDIV =================================================== */
#define CLKCTR_GNSSCLKDIV_GNSSCLKDIV_Pos (0UL) /*!< field GNSSCLKDIV (bitOffset 0, bitWidth 3) */
#define CLKCTR_GNSSCLKDIV_GNSSCLKDIV_Msk (0x00000007UL) /*!< field GNSSCLKDIV (Bitfield-Mask: 0x00000007) */
#define CLKCTR_GNSSCLKDIV_GNSSCLKDIV_CUR_Pos (16UL) /*!< field GNSSCLKDIV_CUR (bitOffset 16, bitWidth 3) */
#define CLKCTR_GNSSCLKDIV_GNSSCLKDIV_CUR_Msk (0x00070000UL) /*!< field GNSSCLKDIV_CUR (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register HFITRIM ==================================================== */
#define CLKCTR_HFITRIM_TRIM_Pos (0UL) /*!< field TRIM (bitOffset 0, bitWidth 5) */
#define CLKCTR_HFITRIM_TRIM_Msk (0x0000001fUL) /*!< field TRIM (Bitfield-Mask: 0x0000001f) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: PWRCTR =============================================== */
/* =========================================================================================================================== */

/* ======================================================= Register CFG ====================================================== */
#define PWRCTR_CFG_LP_MODE_Pos (0UL) /*!< field LP_MODE (bitOffset 0, bitWidth 1) */
#define PWRCTR_CFG_LP_MODE_Msk (0x00000001UL) /*!< field LP_MODE (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_DCDC_DIS_Pos (4UL) /*!< field DCDC_DIS (bitOffset 4, bitWidth 1) */
#define PWRCTR_CFG_DCDC_DIS_Msk (0x00000010UL) /*!< field DCDC_DIS (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_USBPHY_PWRRDY_Pos (6UL) /*!< field USBPHY_PWRRDY (bitOffset 6, bitWidth 1) */
#define PWRCTR_CFG_USBPHY_PWRRDY_Msk (0x00000040UL) /*!< field USBPHY_PWRRDY (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_VMON_RTI_EN_Pos (8UL) /*!< field VMON_RTI_EN (bitOffset 8, bitWidth 1) */
#define PWRCTR_CFG_VMON_RTI_EN_Msk (0x00000100UL) /*!< field VMON_RTI_EN (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_VMON_FTI_EN_Pos (9UL) /*!< field VMON_FTI_EN (bitOffset 9, bitWidth 1) */
#define PWRCTR_CFG_VMON_FTI_EN_Msk (0x00000200UL) /*!< field VMON_FTI_EN (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_VMON_INT_CLR_Pos (10UL) /*!< field VMON_INT_CLR (bitOffset 10, bitWidth 1) */
#define PWRCTR_CFG_VMON_INT_CLR_Msk (0x00000400UL) /*!< field VMON_INT_CLR (Bitfield-Mask: 0x00000001) */
#define PWRCTR_CFG_FLASH_LVE_Pos (12UL) /*!< field FLASH_LVE (bitOffset 12, bitWidth 1) */
#define PWRCTR_CFG_FLASH_LVE_Msk (0x00001000UL) /*!< field FLASH_LVE (Bitfield-Mask: 0x00000001) */

/* ====================================================== Register STAT ====================================================== */
#define PWRCTR_STAT_VMON_STAT_Pos (0UL) /*!< field VMON_STAT (bitOffset 0, bitWidth 1) */
#define PWRCTR_STAT_VMON_STAT_Msk (0x00000001UL) /*!< field VMON_STAT (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STAT_VMON_RTI_STAT_Pos (1UL) /*!< field VMON_RTI_STAT (bitOffset 1, bitWidth 1) */
#define PWRCTR_STAT_VMON_RTI_STAT_Msk (0x00000002UL) /*!< field VMON_RTI_STAT (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STAT_VMON_FTI_STAT_Pos (2UL) /*!< field VMON_FTI_STAT (bitOffset 2, bitWidth 1) */
#define PWRCTR_STAT_VMON_FTI_STAT_Msk (0x00000004UL) /*!< field VMON_FTI_STAT (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STAT_DCDC_PG_Pos (4UL) /*!< field DCDC_PG (bitOffset 4, bitWidth 1) */
#define PWRCTR_STAT_DCDC_PG_Msk (0x00000010UL) /*!< field DCDC_PG (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STAT_FLASH_PWR_STAT_Pos (20UL) /*!< field FLASH_PWR_STAT (bitOffset 20, bitWidth 2) */
#define PWRCTR_STAT_FLASH_PWR_STAT_Msk (0x00300000UL) /*!< field FLASH_PWR_STAT (Bitfield-Mask: 0x00000003) */
#define PWRCTR_STAT_FLASH_LVE_STAT_Pos (22UL) /*!< field FLASH_LVE_STAT (bitOffset 22, bitWidth 1) */
#define PWRCTR_STAT_FLASH_LVE_STAT_Msk (0x00400000UL) /*!< field FLASH_LVE_STAT (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register RUNCFG ===================================================== */
#define PWRCTR_RUNCFG_DCDC_VSEL_Pos (0UL) /*!< field DCDC_VSEL (bitOffset 0, bitWidth 2) */
#define PWRCTR_RUNCFG_DCDC_VSEL_Msk (0x00000003UL) /*!< field DCDC_VSEL (Bitfield-Mask: 0x00000003) */
#define PWRCTR_RUNCFG_DCDC_MODE_Pos (2UL) /*!< field DCDC_MODE (bitOffset 2, bitWidth 2) */
#define PWRCTR_RUNCFG_DCDC_MODE_Msk (0x0000000cUL) /*!< field DCDC_MODE (Bitfield-Mask: 0x00000003) */
#define PWRCTR_RUNCFG_DCDC_SWDRV_Pos (4UL) /*!< field DCDC_SWDRV (bitOffset 4, bitWidth 4) */
#define PWRCTR_RUNCFG_DCDC_SWDRV_Msk (0x000000f0UL) /*!< field DCDC_SWDRV (Bitfield-Mask: 0x0000000f) */
#define PWRCTR_RUNCFG_DCDC_DISSINK_Pos (8UL) /*!< field DCDC_DISSINK (bitOffset 8, bitWidth 1) */
#define PWRCTR_RUNCFG_DCDC_DISSINK_Msk (0x00000100UL) /*!< field DCDC_DISSINK (Bitfield-Mask: 0x00000001) */
#define PWRCTR_RUNCFG_DCDC_ENCCMTRAN_Pos (9UL) /*!< field DCDC_ENCCMTRAN (bitOffset 9, bitWidth 1) */
#define PWRCTR_RUNCFG_DCDC_ENCCMTRAN_Msk (0x00000200UL) /*!< field DCDC_ENCCMTRAN (Bitfield-Mask: 0x00000001) */
#define PWRCTR_RUNCFG_DCDC_ENSTDBY_Pos (10UL) /*!< field DCDC_ENSTDBY (bitOffset 10, bitWidth 1) */
#define PWRCTR_RUNCFG_DCDC_ENSTDBY_Msk (0x00000400UL) /*!< field DCDC_ENSTDBY (Bitfield-Mask: 0x00000001) */
#define PWRCTR_RUNCFG_APC_ECO_Pos (11UL) /*!< field APC_ECO (bitOffset 11, bitWidth 2) */
#define PWRCTR_RUNCFG_APC_ECO_Msk (0x00001800UL) /*!< field APC_ECO (Bitfield-Mask: 0x00000003) */
#define PWRCTR_RUNCFG_APC_ENLPCLK_Pos (13UL) /*!< field APC_ENLPCLK (bitOffset 13, bitWidth 1) */
#define PWRCTR_RUNCFG_APC_ENLPCLK_Msk (0x00002000UL) /*!< field APC_ENLPCLK (Bitfield-Mask: 0x00000001) */
#define PWRCTR_RUNCFG_APC_ECOPROG_Pos (16UL) /*!< field APC_ECOPROG (bitOffset 16, bitWidth 4) */
#define PWRCTR_RUNCFG_APC_ECOPROG_Msk (0x000f0000UL) /*!< field APC_ECOPROG (Bitfield-Mask: 0x0000000f) */
#define PWRCTR_RUNCFG_FLASH_PWR_CTR_Pos (20UL) /*!< field FLASH_PWR_CTR (bitOffset 20, bitWidth 2) */
#define PWRCTR_RUNCFG_FLASH_PWR_CTR_Msk (0x00300000UL) /*!< field FLASH_PWR_CTR (Bitfield-Mask: 0x00000003) */

/* ==================================================== Register STDBYCFG ==================================================== */
#define PWRCTR_STDBYCFG_DCDC_VSEL_Pos (0UL) /*!< field DCDC_VSEL (bitOffset 0, bitWidth 2) */
#define PWRCTR_STDBYCFG_DCDC_VSEL_Msk (0x00000003UL) /*!< field DCDC_VSEL (Bitfield-Mask: 0x00000003) */
#define PWRCTR_STDBYCFG_DCDC_MODE_Pos (2UL) /*!< field DCDC_MODE (bitOffset 2, bitWidth 2) */
#define PWRCTR_STDBYCFG_DCDC_MODE_Msk (0x0000000cUL) /*!< field DCDC_MODE (Bitfield-Mask: 0x00000003) */
#define PWRCTR_STDBYCFG_DCDC_SWDRV_Pos (4UL) /*!< field DCDC_SWDRV (bitOffset 4, bitWidth 4) */
#define PWRCTR_STDBYCFG_DCDC_SWDRV_Msk (0x000000f0UL) /*!< field DCDC_SWDRV (Bitfield-Mask: 0x0000000f) */
#define PWRCTR_STDBYCFG_DCDC_DISSINK_Pos (8UL) /*!< field DCDC_DISSINK (bitOffset 8, bitWidth 1) */
#define PWRCTR_STDBYCFG_DCDC_DISSINK_Msk (0x00000100UL) /*!< field DCDC_DISSINK (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STDBYCFG_DCDC_ENCCMTRAN_Pos (9UL) /*!< field DCDC_ENCCMTRAN (bitOffset 9, bitWidth 1) */
#define PWRCTR_STDBYCFG_DCDC_ENCCMTRAN_Msk (0x00000200UL) /*!< field DCDC_ENCCMTRAN (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STDBYCFG_DCDC_ENSTDBY_Pos (10UL) /*!< field DCDC_ENSTDBY (bitOffset 10, bitWidth 1) */
#define PWRCTR_STDBYCFG_DCDC_ENSTDBY_Msk (0x00000400UL) /*!< field DCDC_ENSTDBY (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STDBYCFG_APC_ECO_Pos (11UL) /*!< field APC_ECO (bitOffset 11, bitWidth 2) */
#define PWRCTR_STDBYCFG_APC_ECO_Msk (0x00001800UL) /*!< field APC_ECO (Bitfield-Mask: 0x00000003) */
#define PWRCTR_STDBYCFG_APC_ENLPCLK_Pos (13UL) /*!< field APC_ENLPCLK (bitOffset 13, bitWidth 1) */
#define PWRCTR_STDBYCFG_APC_ENLPCLK_Msk (0x00002000UL) /*!< field APC_ENLPCLK (Bitfield-Mask: 0x00000001) */
#define PWRCTR_STDBYCFG_APC_ECOPROG_Pos (16UL) /*!< field APC_ECOPROG (bitOffset 16, bitWidth 4) */
#define PWRCTR_STDBYCFG_APC_ECOPROG_Msk (0x000f0000UL) /*!< field APC_ECOPROG (Bitfield-Mask: 0x0000000f) */
#define PWRCTR_STDBYCFG_FLASH_PWR_CTR_Pos (20UL) /*!< field FLASH_PWR_CTR (bitOffset 20, bitWidth 2) */
#define PWRCTR_STDBYCFG_FLASH_PWR_CTR_Msk (0x00300000UL) /*!< field FLASH_PWR_CTR (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register VLEVEL ===================================================== */
#define PWRCTR_VLEVEL_VLEVEL0_Pos (0UL) /*!< field VLEVEL0 (bitOffset 0, bitWidth 5) */
#define PWRCTR_VLEVEL_VLEVEL0_Msk (0x0000001fUL) /*!< field VLEVEL0 (Bitfield-Mask: 0x0000001f) */
#define PWRCTR_VLEVEL_VLEVEL1_Pos (8UL) /*!< field VLEVEL1 (bitOffset 8, bitWidth 5) */
#define PWRCTR_VLEVEL_VLEVEL1_Msk (0x00001f00UL) /*!< field VLEVEL1 (Bitfield-Mask: 0x0000001f) */
#define PWRCTR_VLEVEL_VLEVEL2_Pos (16UL) /*!< field VLEVEL2 (bitOffset 16, bitWidth 5) */
#define PWRCTR_VLEVEL_VLEVEL2_Msk (0x001f0000UL) /*!< field VLEVEL2 (Bitfield-Mask: 0x0000001f) */

/* ====================================================== Register TRIM ====================================================== */
#define PWRCTR_TRIM_APC_VREF_IT_Pos (0UL) /*!< field APC_VREF_IT (bitOffset 0, bitWidth 3) */
#define PWRCTR_TRIM_APC_VREF_IT_Msk (0x00000007UL) /*!< field APC_VREF_IT (Bitfield-Mask: 0x00000007) */
#define PWRCTR_TRIM_APC_VREF_TT_Pos (4UL) /*!< field APC_VREF_TT (bitOffset 4, bitWidth 3) */
#define PWRCTR_TRIM_APC_VREF_TT_Msk (0x00000070UL) /*!< field APC_VREF_TT (Bitfield-Mask: 0x00000007) */
#define PWRCTR_TRIM_APC_VREF_VT_Pos (8UL) /*!< field APC_VREF_VT (bitOffset 8, bitWidth 3) */
#define PWRCTR_TRIM_APC_VREF_VT_Msk (0x00000700UL) /*!< field APC_VREF_VT (Bitfield-Mask: 0x00000007) */
#define PWRCTR_TRIM_APC_FORCETRIM_Pos (13UL) /*!< field APC_FORCETRIM (bitOffset 13, bitWidth 1) */
#define PWRCTR_TRIM_APC_FORCETRIM_Msk (0x00002000UL) /*!< field APC_FORCETRIM (Bitfield-Mask: 0x00000001) */
#define PWRCTR_TRIM_DCDC_IMAX_Pos (16UL) /*!< field DCDC_IMAX (bitOffset 16, bitWidth 3) */
#define PWRCTR_TRIM_DCDC_IMAX_Msk (0x00070000UL) /*!< field DCDC_IMAX (Bitfield-Mask: 0x00000007) */
#define PWRCTR_TRIM_DCDC_IMIN_Pos (20UL) /*!< field DCDC_IMIN (bitOffset 20, bitWidth 3) */
#define PWRCTR_TRIM_DCDC_IMIN_Msk (0x00700000UL) /*!< field DCDC_IMIN (Bitfield-Mask: 0x00000007) */
#define PWRCTR_TRIM_DCDC_TRIMLC_Pos (24UL) /*!< field DCDC_TRIMLC (bitOffset 24, bitWidth 8) */
#define PWRCTR_TRIM_DCDC_TRIMLC_Msk (0xff000000UL) /*!< field DCDC_TRIMLC (Bitfield-Mask: 0x000000ff) */

/* ====================================================== Register TEST ====================================================== */
#define PWRCTR_TEST_APC_TEST_Pos (0UL) /*!< field APC_TEST (bitOffset 0, bitWidth 4) */
#define PWRCTR_TEST_APC_TEST_Msk (0x0000000fUL) /*!< field APC_TEST (Bitfield-Mask: 0x0000000f) */
#define PWRCTR_TEST_DCDC_TEST_Pos (8UL) /*!< field DCDC_TEST (bitOffset 8, bitWidth 5) */
#define PWRCTR_TEST_DCDC_TEST_Msk (0x00001f00UL) /*!< field DCDC_TEST (Bitfield-Mask: 0x0000001f) */
#define PWRCTR_TEST_RWC_TEST_Pos (16UL) /*!< field RWC_TEST (bitOffset 16, bitWidth 5) */
#define PWRCTR_TEST_RWC_TEST_Msk (0x001f0000UL) /*!< field RWC_TEST (Bitfield-Mask: 0x0000001f) */
#define PWRCTR_TEST_JTM_TEST_Pos (24UL) /*!< field JTM_TEST (bitOffset 24, bitWidth 5) */
#define PWRCTR_TEST_JTM_TEST_Msk (0x1f000000UL) /*!< field JTM_TEST (Bitfield-Mask: 0x0000001f) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: OTPCTR =============================================== */
/* =========================================================================================================================== */

/* ===================================================== Register DAP_DR ===================================================== */
#define OTPCTR_DAP_DR_DATA_Pos (0UL) /*!< field DATA (bitOffset 0, bitWidth 32) */
#define OTPCTR_DAP_DR_DATA_Msk (0xffffffffUL) /*!< field DATA (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register DAP_ER ===================================================== */
#define OTPCTR_DAP_ER_ECC_Pos (0UL) /*!< field ECC (bitOffset 0, bitWidth 6) */
#define OTPCTR_DAP_ER_ECC_Msk (0x0000003fUL) /*!< field ECC (Bitfield-Mask: 0x0000003f) */
#define OTPCTR_DAP_ER_BRP_Pos (6UL) /*!< field BRP (bitOffset 6, bitWidth 2) */
#define OTPCTR_DAP_ER_BRP_Msk (0x000000c0UL) /*!< field BRP (Bitfield-Mask: 0x00000003) */

/* ===================================================== Register DAP_RQ0 ==================================================== */
#define OTPCTR_DAP_RQ0_SHF_IREF_Pos (0UL) /*!< field SHF_IREF (bitOffset 0, bitWidth 5) */
#define OTPCTR_DAP_RQ0_SHF_IREF_Msk (0x0000001fUL) /*!< field SHF_IREF (Bitfield-Mask: 0x0000001f) */
#define OTPCTR_DAP_RQ0_SHF_REDUND_Pos (5UL) /*!< field SHF_REDUND (bitOffset 5, bitWidth 1) */
#define OTPCTR_DAP_RQ0_SHF_REDUND_Msk (0x00000020UL) /*!< field SHF_REDUND (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_LD_CP_EN_Pos (7UL) /*!< field IPS_LD_CP_EN (bitOffset 7, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_LD_CP_EN_Msk (0x00000080UL) /*!< field IPS_LD_CP_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_VRR_Pos (8UL) /*!< field IPS_VRR (bitOffset 8, bitWidth 4) */
#define OTPCTR_DAP_RQ0_IPS_VRR_Msk (0x00000f00UL) /*!< field IPS_VRR (Bitfield-Mask: 0x0000000f) */
#define OTPCTR_DAP_RQ0_IPS_VRRTS_Pos (12UL) /*!< field IPS_VRRTS (bitOffset 12, bitWidth 2) */
#define OTPCTR_DAP_RQ0_IPS_VRRTS_Msk (0x00003000UL) /*!< field IPS_VRRTS (Bitfield-Mask: 0x00000003) */
#define OTPCTR_DAP_RQ0_IPS_VRR_EN_Pos (14UL) /*!< field IPS_VRR_EN (bitOffset 14, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_VRR_EN_Msk (0x00004000UL) /*!< field IPS_VRR_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_CP_EN_Pos (15UL) /*!< field IPS_CP_EN (bitOffset 15, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_CP_EN_Msk (0x00008000UL) /*!< field IPS_CP_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_VQQ_Pos (16UL) /*!< field IPS_VQQ (bitOffset 16, bitWidth 3) */
#define OTPCTR_DAP_RQ0_IPS_VQQ_Msk (0x00070000UL) /*!< field IPS_VQQ (Bitfield-Mask: 0x00000007) */
#define OTPCTR_DAP_RQ0_IPS_VPP_Pos (19UL) /*!< field IPS_VPP (bitOffset 19, bitWidth 3) */
#define OTPCTR_DAP_RQ0_IPS_VPP_Msk (0x00380000UL) /*!< field IPS_VPP (Bitfield-Mask: 0x00000007) */
#define OTPCTR_DAP_RQ0_IPS_OSCVPP_Pos (22UL) /*!< field IPS_OSCVPP (bitOffset 22, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_OSCVPP_Msk (0x00400000UL) /*!< field IPS_OSCVPP (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_OSCVQQ_Pos (23UL) /*!< field IPS_OSCVQQ (bitOffset 23, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_OSCVQQ_Msk (0x00800000UL) /*!< field IPS_OSCVQQ (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_VDD_DET_DIS_Pos (24UL) /*!< field IPS_VDD_DET_DIS (bitOffset 24, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_VDD_DET_DIS_Msk (0x01000000UL) /*!< field IPS_VDD_DET_DIS (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_EXT_REF_EN_Pos (25UL) /*!< field IPS_EXT_REF_EN (bitOffset 25, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_EXT_REF_EN_Msk (0x02000000UL) /*!< field IPS_EXT_REF_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_EN_Pos (26UL) /*!< field IPS_EN (bitOffset 26, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_EN_Msk (0x04000000UL) /*!< field IPS_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_OSC_OUT_Pos (27UL) /*!< field IPS_OSC_OUT (bitOffset 27, bitWidth 2) */
#define OTPCTR_DAP_RQ0_IPS_OSC_OUT_Msk (0x18000000UL) /*!< field IPS_OSC_OUT (Bitfield-Mask: 0x00000003) */
#define OTPCTR_DAP_RQ0_IPS_EXT_CK_EN_Pos (29UL) /*!< field IPS_EXT_CK_EN (bitOffset 29, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_EXT_CK_EN_Msk (0x20000000UL) /*!< field IPS_EXT_CK_EN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_REF_BIAS_DIS_Pos (30UL) /*!< field IPS_REF_BIAS_DIS (bitOffset 30, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_REF_BIAS_DIS_Msk (0x40000000UL) /*!< field IPS_REF_BIAS_DIS (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ0_IPS_VRRSWC_Pos (31UL) /*!< field IPS_VRRSWC (bitOffset 31, bitWidth 1) */
#define OTPCTR_DAP_RQ0_IPS_VRRSWC_Msk (0x80000000UL) /*!< field IPS_VRRSWC (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register DAP_RQ1 ==================================================== */
#define OTPCTR_DAP_RQ1_SHF_ROMEN_Pos (8UL) /*!< field SHF_ROMEN (bitOffset 8, bitWidth 1) */
#define OTPCTR_DAP_RQ1_SHF_ROMEN_Msk (0x00000100UL) /*!< field SHF_ROMEN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ1_SHF_AROM_Pos (9UL) /*!< field SHF_AROM (bitOffset 9, bitWidth 2) */
#define OTPCTR_DAP_RQ1_SHF_AROM_Msk (0x00000600UL) /*!< field SHF_AROM (Bitfield-Mask: 0x00000003) */
#define OTPCTR_DAP_RQ1_SHF_OTP_RTST_Pos (11UL) /*!< field SHF_OTP_RTST (bitOffset 11, bitWidth 1) */
#define OTPCTR_DAP_RQ1_SHF_OTP_RTST_Msk (0x00000800UL) /*!< field SHF_OTP_RTST (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ1_SHF_CKDEL_Pos (16UL) /*!< field SHF_CKDEL (bitOffset 16, bitWidth 5) */
#define OTPCTR_DAP_RQ1_SHF_CKDEL_Msk (0x001f0000UL) /*!< field SHF_CKDEL (Bitfield-Mask: 0x0000001f) */
#define OTPCTR_DAP_RQ1_IPS_WE_CK_Pos (24UL) /*!< field IPS_WE_CK (bitOffset 24, bitWidth 1) */
#define OTPCTR_DAP_RQ1_IPS_WE_CK_Msk (0x01000000UL) /*!< field IPS_WE_CK (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ1_IPS_VREFLVL_Pos (25UL) /*!< field IPS_VREFLVL (bitOffset 25, bitWidth 3) */
#define OTPCTR_DAP_RQ1_IPS_VREFLVL_Msk (0x0e000000UL) /*!< field IPS_VREFLVL (Bitfield-Mask: 0x00000007) */
#define OTPCTR_DAP_RQ1_IPS_RESERVED_Pos (28UL) /*!< field IPS_RESERVED (bitOffset 28, bitWidth 3) */
#define OTPCTR_DAP_RQ1_IPS_RESERVED_Msk (0x70000000UL) /*!< field IPS_RESERVED (Bitfield-Mask: 0x00000007) */

/* ===================================================== Register DAP_RQ2 ==================================================== */
#define OTPCTR_DAP_RQ2_SHF_PD_Pos (1UL) /*!< field SHF_PD (bitOffset 1, bitWidth 1) */
#define OTPCTR_DAP_RQ2_SHF_PD_Msk (0x00000002UL) /*!< field SHF_PD (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_SHF_SEL_Pos (3UL) /*!< field SHF_SEL (bitOffset 3, bitWidth 1) */
#define OTPCTR_DAP_RQ2_SHF_SEL_Msk (0x00000008UL) /*!< field SHF_SEL (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_ECCDIS_Pos (16UL) /*!< field DPU_ECCDIS (bitOffset 16, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_ECCDIS_Msk (0x00010000UL) /*!< field DPU_ECCDIS (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_ECCGEN_Pos (17UL) /*!< field DPU_ECCGEN (bitOffset 17, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_ECCGEN_Msk (0x00020000UL) /*!< field DPU_ECCGEN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_ECCTST_Pos (18UL) /*!< field DPU_ECCTST (bitOffset 18, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_ECCTST_Msk (0x00040000UL) /*!< field DPU_ECCTST (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_BRPDIS_Pos (19UL) /*!< field DPU_BRPDIS (bitOffset 19, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_BRPDIS_Msk (0x00080000UL) /*!< field DPU_BRPDIS (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_BRPGEN_Pos (20UL) /*!< field DPU_BRPGEN (bitOffset 20, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_BRPGEN_Msk (0x00100000UL) /*!< field DPU_BRPGEN (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_PASS_Pos (21UL) /*!< field DPU_PASS (bitOffset 21, bitWidth 1) */
#define OTPCTR_DAP_RQ2_DPU_PASS_Msk (0x00200000UL) /*!< field DPU_PASS (Bitfield-Mask: 0x00000001) */
#define OTPCTR_DAP_RQ2_DPU_MUXQ_Pos (22UL) /*!< field DPU_MUXQ (bitOffset 22, bitWidth 2) */
#define OTPCTR_DAP_RQ2_DPU_MUXQ_Msk (0x00c00000UL) /*!< field DPU_MUXQ (Bitfield-Mask: 0x00000003) */
#define OTPCTR_DAP_RQ2_DPU_MBPC_Pos (24UL) /*!< field DPU_MBPC (bitOffset 24, bitWidth 3) */
#define OTPCTR_DAP_RQ2_DPU_MBPC_Msk (0x07000000UL) /*!< field DPU_MBPC (Bitfield-Mask: 0x00000007) */

/* =================================================== Register DAP_CQCTRL =================================================== */
#define OTPCTR_DAP_CQCTRL_DAP_OAR_Pos (0UL) /*!< field DAP_OAR (bitOffset 0, bitWidth 16) */
#define OTPCTR_DAP_CQCTRL_DAP_OAR_Msk (0x0000ffffUL) /*!< field DAP_OAR (Bitfield-Mask: 0x0000ffff) */
#define OTPCTR_DAP_CQCTRL_DAP_FP_Pos (16UL) /*!< field DAP_FP (bitOffset 16, bitWidth 8) */
#define OTPCTR_DAP_CQCTRL_DAP_FP_Msk (0x00ff0000UL) /*!< field DAP_FP (Bitfield-Mask: 0x000000ff) */
#define OTPCTR_DAP_CQCTRL_DAP_DCSR_Pos (24UL) /*!< field DAP_DCSR (bitOffset 24, bitWidth 8) */
#define OTPCTR_DAP_CQCTRL_DAP_DCSR_Msk (0xff000000UL) /*!< field DAP_DCSR (Bitfield-Mask: 0x000000ff) */

/* ===================================================== Register PMC_RQ0 ==================================================== */
#define OTPCTR_PMC_RQ0_PROG_MODE0_Pos (0UL) /*!< field PROG_MODE0 (bitOffset 0, bitWidth 16) */
#define OTPCTR_PMC_RQ0_PROG_MODE0_Msk (0x0000ffffUL) /*!< field PROG_MODE0 (Bitfield-Mask: 0x0000ffff) */
#define OTPCTR_PMC_RQ0_PROG_MODE1_Pos (16UL) /*!< field PROG_MODE1 (bitOffset 16, bitWidth 16) */
#define OTPCTR_PMC_RQ0_PROG_MODE1_Msk (0xffff0000UL) /*!< field PROG_MODE1 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register PMC_RQ1 ==================================================== */
#define OTPCTR_PMC_RQ1_PROG_MODE2_Pos (0UL) /*!< field PROG_MODE2 (bitOffset 0, bitWidth 16) */
#define OTPCTR_PMC_RQ1_PROG_MODE2_Msk (0x0000ffffUL) /*!< field PROG_MODE2 (Bitfield-Mask: 0x0000ffff) */
#define OTPCTR_PMC_RQ1_PROG_MODE3_Pos (16UL) /*!< field PROG_MODE3 (bitOffset 16, bitWidth 16) */
#define OTPCTR_PMC_RQ1_PROG_MODE3_Msk (0xffff0000UL) /*!< field PROG_MODE3 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register PMC_RQ2 ==================================================== */
#define OTPCTR_PMC_RQ2_SHORT_READ_PW_Pos (0UL) /*!< field SHORT_READ_PW (bitOffset 0, bitWidth 4) */
#define OTPCTR_PMC_RQ2_SHORT_READ_PW_Msk (0x0000000fUL) /*!< field SHORT_READ_PW (Bitfield-Mask: 0x0000000f) */
#define OTPCTR_PMC_RQ2_LONG_READ_PW_Pos (4UL) /*!< field LONG_READ_PW (bitOffset 4, bitWidth 4) */
#define OTPCTR_PMC_RQ2_LONG_READ_PW_Msk (0x000000f0UL) /*!< field LONG_READ_PW (Bitfield-Mask: 0x0000000f) */
#define OTPCTR_PMC_RQ2_BRP_CHECK_READ_PW_Pos (8UL) /*!< field BRP_CHECK_READ_PW (bitOffset 8, bitWidth 1) */
#define OTPCTR_PMC_RQ2_BRP_CHECK_READ_PW_Msk (0x00000100UL) /*!< field BRP_CHECK_READ_PW (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_PRE_PROG_READ_PW_Pos (9UL) /*!< field PRE_PROG_READ_PW (bitOffset 9, bitWidth 1) */
#define OTPCTR_PMC_RQ2_PRE_PROG_READ_PW_Msk (0x00000200UL) /*!< field PRE_PROG_READ_PW (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_POST_PROG_READ_PW_Pos (10UL) /*!< field POST_PROG_READ_PW (bitOffset 10, bitWidth 1) */
#define OTPCTR_PMC_RQ2_POST_PROG_READ_PW_Msk (0x00000400UL) /*!< field POST_PROG_READ_PW (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_POST_SOAK_READ_PW_Pos (11UL) /*!< field POST_SOAK_READ_PW (bitOffset 11, bitWidth 1) */
#define OTPCTR_PMC_RQ2_POST_SOAK_READ_PW_Msk (0x00000800UL) /*!< field POST_SOAK_READ_PW (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_COMPARE_READ_PW_Pos (12UL) /*!< field COMPARE_READ_PW (bitOffset 12, bitWidth 1) */
#define OTPCTR_PMC_RQ2_COMPARE_READ_PW_Msk (0x00001000UL) /*!< field COMPARE_READ_PW (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_READ_RECOVERY_Pos (13UL) /*!< field READ_RECOVERY (bitOffset 13, bitWidth 1) */
#define OTPCTR_PMC_RQ2_READ_RECOVERY_Msk (0x00002000UL) /*!< field READ_RECOVERY (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_RQ2_PROG_RECOVERY_Pos (14UL) /*!< field PROG_RECOVERY (bitOffset 14, bitWidth 2) */
#define OTPCTR_PMC_RQ2_PROG_RECOVERY_Msk (0x0000c000UL) /*!< field PROG_RECOVERY (Bitfield-Mask: 0x00000003) */
#define OTPCTR_PMC_RQ2_PROG_PW_Pos (16UL) /*!< field PROG_PW (bitOffset 16, bitWidth 3) */
#define OTPCTR_PMC_RQ2_PROG_PW_Msk (0x00070000UL) /*!< field PROG_PW (Bitfield-Mask: 0x00000007) */
#define OTPCTR_PMC_RQ2_SOAK_PW_Pos (19UL) /*!< field SOAK_PW (bitOffset 19, bitWidth 3) */
#define OTPCTR_PMC_RQ2_SOAK_PW_Msk (0x00380000UL) /*!< field SOAK_PW (Bitfield-Mask: 0x00000007) */
#define OTPCTR_PMC_RQ2_MODE_SETTING_TIME_Pos (22UL) /*!< field MODE_SETTING_TIME (bitOffset 22, bitWidth 2) */
#define OTPCTR_PMC_RQ2_MODE_SETTING_TIME_Msk (0x00c00000UL) /*!< field MODE_SETTING_TIME (Bitfield-Mask: 0x00000003) */
#define OTPCTR_PMC_RQ2_DAP_ADDR_Pos (24UL) /*!< field DAP_ADDR (bitOffset 24, bitWidth 6) */
#define OTPCTR_PMC_RQ2_DAP_ADDR_Msk (0x3f000000UL) /*!< field DAP_ADDR (Bitfield-Mask: 0x0000003f) */

/* =================================================== Register PMC_CQCTRL =================================================== */
#define OTPCTR_PMC_CQCTRL_CQ_ENTRY_Pos (0UL) /*!< field CQ_ENTRY (bitOffset 0, bitWidth 5) */
#define OTPCTR_PMC_CQCTRL_CQ_ENTRY_Msk (0x0000001fUL) /*!< field CQ_ENTRY (Bitfield-Mask: 0x0000001f) */
#define OTPCTR_PMC_CQCTRL_CQ_EXITN_Pos (5UL) /*!< field CQ_EXITN (bitOffset 5, bitWidth 5) */
#define OTPCTR_PMC_CQCTRL_CQ_EXITN_Msk (0x000003e0UL) /*!< field CQ_EXITN (Bitfield-Mask: 0x0000001f) */
#define OTPCTR_PMC_CQCTRL_CQ_LIMITN_Pos (10UL) /*!< field CQ_LIMITN (bitOffset 10, bitWidth 4) */
#define OTPCTR_PMC_CQCTRL_CQ_LIMITN_Msk (0x00003c00UL) /*!< field CQ_LIMITN (Bitfield-Mask: 0x0000000f) */
#define OTPCTR_PMC_CQCTRL_CQ_AINC_Pos (14UL) /*!< field CQ_AINC (bitOffset 14, bitWidth 1) */
#define OTPCTR_PMC_CQCTRL_CQ_AINC_Msk (0x00004000UL) /*!< field CQ_AINC (Bitfield-Mask: 0x00000001) */
#define OTPCTR_PMC_CQCTRL_DFSR_Pos (16UL) /*!< field DFSR (bitOffset 16, bitWidth 8) */
#define OTPCTR_PMC_CQCTRL_DFSR_Msk (0x00ff0000UL) /*!< field DFSR (Bitfield-Mask: 0x000000ff) */
#define OTPCTR_PMC_CQCTRL_CTRL_STATUS_Pos (24UL) /*!< field CTRL_STATUS (bitOffset 24, bitWidth 8) */
#define OTPCTR_PMC_CQCTRL_CTRL_STATUS_Msk (0xff000000UL) /*!< field CTRL_STATUS (Bitfield-Mask: 0x000000ff) */

/* ===================================================== Register DAP_CMD ==================================================== */
#define OTPCTR_DAP_CMD_INSTR_Pos (0UL) /*!< field INSTR (bitOffset 0, bitWidth 7) */
#define OTPCTR_DAP_CMD_INSTR_Msk (0x0000007fUL) /*!< field INSTR (Bitfield-Mask: 0x0000007f) */

/* ===================================================== Register PMC_CMD ==================================================== */
#define OTPCTR_PMC_CMD_INSTR_Pos (0UL) /*!< field INSTR (bitOffset 0, bitWidth 7) */
#define OTPCTR_PMC_CMD_INSTR_Msk (0x0000007fUL) /*!< field INSTR (Bitfield-Mask: 0x0000007f) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: NSPCTR =============================================== */
/* =========================================================================================================================== */

/* =================================================== Register AHBPPC0_NSP ================================================== */
#define NSPCTR_AHBPPC0_NSP_USB_NSP_Pos (0UL) /*!< field USB_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_USB_NSP_Msk (0x00000001UL) /*!< field USB_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_QSPI_NSP_Pos (1UL) /*!< field QSPI_NSP (bitOffset 1, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_QSPI_NSP_Msk (0x00000002UL) /*!< field QSPI_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_GNSS_NSP_Pos (2UL) /*!< field GNSS_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_GNSS_NSP_Msk (0x00000004UL) /*!< field GNSS_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_SMC_NSP_Pos (3UL) /*!< field SMC_NSP (bitOffset 3, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_SMC_NSP_Msk (0x00000008UL) /*!< field SMC_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_SDMMC_NSP_Pos (4UL) /*!< field SDMMC_NSP (bitOffset 4, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_SDMMC_NSP_Msk (0x00000010UL) /*!< field SDMMC_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_DMA0_NSP_Pos (5UL) /*!< field DMA0_NSP (bitOffset 5, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_DMA0_NSP_Msk (0x00000020UL) /*!< field DMA0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_AHBPPC0_NSP_DMA1_NSP_Pos (6UL) /*!< field DMA1_NSP (bitOffset 6, bitWidth 1) */
#define NSPCTR_AHBPPC0_NSP_DMA1_NSP_Msk (0x00000040UL) /*!< field DMA1_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC4_NSP ================================================== */
#define NSPCTR_APBPPC4_NSP_TIM0_NSP_Pos (0UL) /*!< field TIM0_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_APBPPC4_NSP_TIM0_NSP_Msk (0x00000001UL) /*!< field TIM0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC4_NSP_TIM1_NSP_Pos (1UL) /*!< field TIM1_NSP (bitOffset 1, bitWidth 1) */
#define NSPCTR_APBPPC4_NSP_TIM1_NSP_Msk (0x00000002UL) /*!< field TIM1_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC4_NSP_DTIM_NSP_Pos (2UL) /*!< field DTIM_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_APBPPC4_NSP_DTIM_NSP_Msk (0x00000004UL) /*!< field DTIM_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC4_NSP_MHU0_NSP_Pos (3UL) /*!< field MHU0_NSP (bitOffset 3, bitWidth 1) */
#define NSPCTR_APBPPC4_NSP_MHU0_NSP_Msk (0x00000008UL) /*!< field MHU0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC4_NSP_MHU1_NSP_Pos (4UL) /*!< field MHU1_NSP (bitOffset 4, bitWidth 1) */
#define NSPCTR_APBPPC4_NSP_MHU1_NSP_Msk (0x00000010UL) /*!< field MHU1_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC5_NSP ================================================== */
#define NSPCTR_APBPPC5_NSP_LPTIM_NSP_Pos (0UL) /*!< field LPTIM_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_APBPPC5_NSP_LPTIM_NSP_Msk (0x00000001UL) /*!< field LPTIM_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC0_NSP ================================================== */
#define NSPCTR_APBPPC0_NSP_UART0_NSP_Pos (0UL) /*!< field UART0_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_UART0_NSP_Msk (0x00000001UL) /*!< field UART0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_UART1_NSP_Pos (1UL) /*!< field UART1_NSP (bitOffset 1, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_UART1_NSP_Msk (0x00000002UL) /*!< field UART1_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_UART2_NSP_Pos (2UL) /*!< field UART2_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_UART2_NSP_Msk (0x00000004UL) /*!< field UART2_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_UART3_NSP_Pos (3UL) /*!< field UART3_NSP (bitOffset 3, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_UART3_NSP_Msk (0x00000008UL) /*!< field UART3_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_SPI0_NSP_Pos (4UL) /*!< field SPI0_NSP (bitOffset 4, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_SPI0_NSP_Msk (0x00000010UL) /*!< field SPI0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_SPI1_NSP_Pos (5UL) /*!< field SPI1_NSP (bitOffset 5, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_SPI1_NSP_Msk (0x00000020UL) /*!< field SPI1_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_SPI2_NSP_Pos (6UL) /*!< field SPI2_NSP (bitOffset 6, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_SPI2_NSP_Msk (0x00000040UL) /*!< field SPI2_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_I2C0_NSP_Pos (7UL) /*!< field I2C0_NSP (bitOffset 7, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_I2C0_NSP_Msk (0x00000080UL) /*!< field I2C0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_I2C1_NSP_Pos (8UL) /*!< field I2C1_NSP (bitOffset 8, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_I2C1_NSP_Msk (0x00000100UL) /*!< field I2C1_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_I2S_NSP_Pos (9UL) /*!< field I2S_NSP (bitOffset 9, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_I2S_NSP_Msk (0x00000200UL) /*!< field I2S_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_GPIO0_NSP_Pos (10UL) /*!< field GPIO0_NSP (bitOffset 10, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_GPIO0_NSP_Msk (0x00000400UL) /*!< field GPIO0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_GPIO1_NSP_Pos (11UL) /*!< field GPIO1_NSP (bitOffset 11, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_GPIO1_NSP_Msk (0x00000800UL) /*!< field GPIO1_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_GPIO2_NSP_Pos (12UL) /*!< field GPIO2_NSP (bitOffset 12, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_GPIO2_NSP_Msk (0x00001000UL) /*!< field GPIO2_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC0_NSP_GPIO3_NSP_Pos (13UL) /*!< field GPIO3_NSP (bitOffset 13, bitWidth 1) */
#define NSPCTR_APBPPC0_NSP_GPIO3_NSP_Msk (0x00002000UL) /*!< field GPIO3_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC1_NSP ================================================== */
#define NSPCTR_APBPPC1_NSP_CAN_NSP_Pos (0UL) /*!< field CAN_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_APBPPC1_NSP_CAN_NSP_Msk (0x00000001UL) /*!< field CAN_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC1_NSP_PWM_NSP_Pos (1UL) /*!< field PWM_NSP (bitOffset 1, bitWidth 1) */
#define NSPCTR_APBPPC1_NSP_PWM_NSP_Msk (0x00000002UL) /*!< field PWM_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC1_NSP_VTU0_NSP_Pos (2UL) /*!< field VTU0_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_APBPPC1_NSP_VTU0_NSP_Msk (0x00000004UL) /*!< field VTU0_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC1_NSP_VTU1_NSP_Pos (3UL) /*!< field VTU1_NSP (bitOffset 3, bitWidth 1) */
#define NSPCTR_APBPPC1_NSP_VTU1_NSP_Msk (0x00000008UL) /*!< field VTU1_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC2_NSP ================================================== */
#define NSPCTR_APBPPC2_NSP_RWC_NSP_Pos (2UL) /*!< field RWC_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_APBPPC2_NSP_RWC_NSP_Msk (0x00000004UL) /*!< field RWC_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC2_NSP_JTM_NSP_Pos (3UL) /*!< field JTM_NSP (bitOffset 3, bitWidth 1) */
#define NSPCTR_APBPPC2_NSP_JTM_NSP_Msk (0x00000008UL) /*!< field JTM_NSP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC3_NSP ================================================== */
#define NSPCTR_APBPPC3_NSP_IOCTR_NSP_Pos (0UL) /*!< field IOCTR_NSP (bitOffset 0, bitWidth 1) */
#define NSPCTR_APBPPC3_NSP_IOCTR_NSP_Msk (0x00000001UL) /*!< field IOCTR_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC3_NSP_CLKCTR_NSP_Pos (1UL) /*!< field CLKCTR_NSP (bitOffset 1, bitWidth 1) */
#define NSPCTR_APBPPC3_NSP_CLKCTR_NSP_Msk (0x00000002UL) /*!< field CLKCTR_NSP (Bitfield-Mask: 0x00000001) */
#define NSPCTR_APBPPC3_NSP_PWRCTR_NSP_Pos (2UL) /*!< field PWRCTR_NSP (bitOffset 2, bitWidth 1) */
#define NSPCTR_APBPPC3_NSP_PWRCTR_NSP_Msk (0x00000004UL) /*!< field PWRCTR_NSP (Bitfield-Mask: 0x00000001) */



/* =========================================================================================================================== */
/* ================================================ Type of peripheral: SPCTR ================================================ */
/* =========================================================================================================================== */

/* =================================================== Register SPCSECCTRL =================================================== */
#define SPCTR_SPCSECCTRL_CFGLOCK_Pos (0UL) /*!< field CFGLOCK (bitOffset 0, bitWidth 1) */
#define SPCTR_SPCSECCTRL_CFGLOCK_Msk (0x00000001UL) /*!< field CFGLOCK (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register BUSWAIT ==================================================== */
#define SPCTR_BUSWAIT_ACC_WAITN_Pos (0UL) /*!< field ACC_WAITN (bitOffset 0, bitWidth 1) */
#define SPCTR_BUSWAIT_ACC_WAITN_Msk (0x00000001UL) /*!< field ACC_WAITN (Bitfield-Mask: 0x00000001) */
#define SPCTR_BUSWAIT_ACC_WAITN_STAT_Pos (16UL) /*!< field ACC_WAITN_STAT (bitOffset 16, bitWidth 1) */
#define SPCTR_BUSWAIT_ACC_WAITN_STAT_Msk (0x00010000UL) /*!< field ACC_WAITN_STAT (Bitfield-Mask: 0x00000001) */

/* =================================================== Register SECRESPCFG =================================================== */
#define SPCTR_SECRESPCFG_SECRESPCFG_Pos (0UL) /*!< field SECRESPCFG (bitOffset 0, bitWidth 1) */
#define SPCTR_SECRESPCFG_SECRESPCFG_Msk (0x00000001UL) /*!< field SECRESPCFG (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register NSCCFG ===================================================== */
#define SPCTR_NSCCFG_CODENSC_Pos (0UL) /*!< field CODENSC (bitOffset 0, bitWidth 1) */
#define SPCTR_NSCCFG_CODENSC_Msk (0x00000001UL) /*!< field CODENSC (Bitfield-Mask: 0x00000001) */
#define SPCTR_NSCCFG_RAMNSC_Pos (1UL) /*!< field RAMNSC (bitOffset 1, bitWidth 1) */
#define SPCTR_NSCCFG_RAMNSC_Msk (0x00000002UL) /*!< field RAMNSC (Bitfield-Mask: 0x00000001) */

/* =================================================== Register MPCINTSTAT =================================================== */
#define SPCTR_MPCINTSTAT_SRAM0_MPC_INTSTAT_Pos (0UL) /*!< field SRAM0_MPC_INTSTAT (bitOffset 0, bitWidth 1) */
#define SPCTR_MPCINTSTAT_SRAM0_MPC_INTSTAT_Msk (0x00000001UL) /*!< field SRAM0_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_SRAM1_MPC_INTSTAT_Pos (1UL) /*!< field SRAM1_MPC_INTSTAT (bitOffset 1, bitWidth 1) */
#define SPCTR_MPCINTSTAT_SRAM1_MPC_INTSTAT_Msk (0x00000002UL) /*!< field SRAM1_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_SRAM2_MPC_INTSTAT_Pos (2UL) /*!< field SRAM2_MPC_INTSTAT (bitOffset 2, bitWidth 1) */
#define SPCTR_MPCINTSTAT_SRAM2_MPC_INTSTAT_Msk (0x00000004UL) /*!< field SRAM2_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_SRAM3_MPC_INTSTAT_Pos (3UL) /*!< field SRAM3_MPC_INTSTAT (bitOffset 3, bitWidth 1) */
#define SPCTR_MPCINTSTAT_SRAM3_MPC_INTSTAT_Msk (0x00000008UL) /*!< field SRAM3_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_FLASH_MPC_INTSTAT_Pos (16UL) /*!< field FLASH_MPC_INTSTAT (bitOffset 16, bitWidth 1) */
#define SPCTR_MPCINTSTAT_FLASH_MPC_INTSTAT_Msk (0x00010000UL) /*!< field FLASH_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_QSPI_MPC_INTSTAT_Pos (17UL) /*!< field QSPI_MPC_INTSTAT (bitOffset 17, bitWidth 1) */
#define SPCTR_MPCINTSTAT_QSPI_MPC_INTSTAT_Msk (0x00020000UL) /*!< field QSPI_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_SMC_MPC_INTSTAT_Pos (18UL) /*!< field SMC_MPC_INTSTAT (bitOffset 18, bitWidth 1) */
#define SPCTR_MPCINTSTAT_SMC_MPC_INTSTAT_Msk (0x00040000UL) /*!< field SMC_MPC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MPCINTSTAT_BKPSRAM_MPC_STAT_Pos (19UL) /*!< field BKPSRAM_MPC_STAT (bitOffset 19, bitWidth 1) */
#define SPCTR_MPCINTSTAT_BKPSRAM_MPC_STAT_Msk (0x00080000UL) /*!< field BKPSRAM_MPC_STAT (Bitfield-Mask: 0x00000001) */

/* =================================================== Register PPCINTSTAT =================================================== */
#define SPCTR_PPCINTSTAT_APBPPC4_INTSTAT_Pos (0UL) /*!< field APBPPC4_INTSTAT (bitOffset 0, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC4_INTSTAT_Msk (0x00000001UL) /*!< field APBPPC4_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_APBPPC5_INTSTAT_Pos (1UL) /*!< field APBPPC5_INTSTAT (bitOffset 1, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC5_INTSTAT_Msk (0x00000002UL) /*!< field APBPPC5_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_APBPPC0_INTSTAT_Pos (4UL) /*!< field APBPPC0_INTSTAT (bitOffset 4, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC0_INTSTAT_Msk (0x00000010UL) /*!< field APBPPC0_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_APBPPC1_INTSTAT_Pos (5UL) /*!< field APBPPC1_INTSTAT (bitOffset 5, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC1_INTSTAT_Msk (0x00000020UL) /*!< field APBPPC1_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_APBPPC2_INTSTAT_Pos (6UL) /*!< field APBPPC2_INTSTAT (bitOffset 6, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC2_INTSTAT_Msk (0x00000040UL) /*!< field APBPPC2_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_APBPPC3_INTSTAT_Pos (7UL) /*!< field APBPPC3_INTSTAT (bitOffset 7, bitWidth 1) */
#define SPCTR_PPCINTSTAT_APBPPC3_INTSTAT_Msk (0x00000080UL) /*!< field APBPPC3_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTSTAT_AHBPPC0_INTSTAT_Pos (20UL) /*!< field AHBPPC0_INTSTAT (bitOffset 20, bitWidth 1) */
#define SPCTR_PPCINTSTAT_AHBPPC0_INTSTAT_Msk (0x00100000UL) /*!< field AHBPPC0_INTSTAT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PPCINTCLR =================================================== */
#define SPCTR_PPCINTCLR_APBPPC4_INTCLR_Pos (0UL) /*!< field APBPPC4_INTCLR (bitOffset 0, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC4_INTCLR_Msk (0x00000001UL) /*!< field APBPPC4_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_APBPPC5_INTCLR_Pos (1UL) /*!< field APBPPC5_INTCLR (bitOffset 1, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC5_INTCLR_Msk (0x00000002UL) /*!< field APBPPC5_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_APBPPC0_INTCLR_Pos (4UL) /*!< field APBPPC0_INTCLR (bitOffset 4, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC0_INTCLR_Msk (0x00000010UL) /*!< field APBPPC0_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_APBPPC1_INTCLR_Pos (5UL) /*!< field APBPPC1_INTCLR (bitOffset 5, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC1_INTCLR_Msk (0x00000020UL) /*!< field APBPPC1_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_APBPPC2_INTCLR_Pos (6UL) /*!< field APBPPC2_INTCLR (bitOffset 6, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC2_INTCLR_Msk (0x00000040UL) /*!< field APBPPC2_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_APBPPC3_INTCLR_Pos (7UL) /*!< field APBPPC3_INTCLR (bitOffset 7, bitWidth 1) */
#define SPCTR_PPCINTCLR_APBPPC3_INTCLR_Msk (0x00000080UL) /*!< field APBPPC3_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTCLR_AHBPPC0_INTCLR_Pos (20UL) /*!< field AHBPPC0_INTCLR (bitOffset 20, bitWidth 1) */
#define SPCTR_PPCINTCLR_AHBPPC0_INTCLR_Msk (0x00100000UL) /*!< field AHBPPC0_INTCLR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register PPCINTEN ==================================================== */
#define SPCTR_PPCINTEN_APBPPC4_INTEN_Pos (0UL) /*!< field APBPPC4_INTEN (bitOffset 0, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC4_INTEN_Msk (0x00000001UL) /*!< field APBPPC4_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_APBPPC5_INTEN_Pos (1UL) /*!< field APBPPC5_INTEN (bitOffset 1, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC5_INTEN_Msk (0x00000002UL) /*!< field APBPPC5_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_APBPPC0_INTEN_Pos (4UL) /*!< field APBPPC0_INTEN (bitOffset 4, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC0_INTEN_Msk (0x00000010UL) /*!< field APBPPC0_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_APBPPC1_INTEN_Pos (5UL) /*!< field APBPPC1_INTEN (bitOffset 5, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC1_INTEN_Msk (0x00000020UL) /*!< field APBPPC1_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_APBPPC2_INTEN_Pos (6UL) /*!< field APBPPC2_INTEN (bitOffset 6, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC2_INTEN_Msk (0x00000040UL) /*!< field APBPPC2_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_APBPPC3_INTEN_Pos (7UL) /*!< field APBPPC3_INTEN (bitOffset 7, bitWidth 1) */
#define SPCTR_PPCINTEN_APBPPC3_INTEN_Msk (0x00000080UL) /*!< field APBPPC3_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_PPCINTEN_AHBPPC0_INTEN_Pos (20UL) /*!< field AHBPPC0_INTEN (bitOffset 20, bitWidth 1) */
#define SPCTR_PPCINTEN_AHBPPC0_INTEN_Msk (0x00100000UL) /*!< field AHBPPC0_INTEN (Bitfield-Mask: 0x00000001) */

/* =================================================== Register MSCINTSTAT =================================================== */
#define SPCTR_MSCINTSTAT_DMA0_MSC_INTSTAT_Pos (16UL) /*!< field DMA0_MSC_INTSTAT (bitOffset 16, bitWidth 1) */
#define SPCTR_MSCINTSTAT_DMA0_MSC_INTSTAT_Msk (0x00010000UL) /*!< field DMA0_MSC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTSTAT_DMA1_MSC_INTSTAT_Pos (17UL) /*!< field DMA1_MSC_INTSTAT (bitOffset 17, bitWidth 1) */
#define SPCTR_MSCINTSTAT_DMA1_MSC_INTSTAT_Msk (0x00020000UL) /*!< field DMA1_MSC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTSTAT_SDMMC_SMC_INTSTAT_Pos (18UL) /*!< field SDMMC_SMC_INTSTAT (bitOffset 18, bitWidth 1) */
#define SPCTR_MSCINTSTAT_SDMMC_SMC_INTSTAT_Msk (0x00040000UL) /*!< field SDMMC_SMC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTSTAT_USB_MSC_INTSTAT_Pos (19UL) /*!< field USB_MSC_INTSTAT (bitOffset 19, bitWidth 1) */
#define SPCTR_MSCINTSTAT_USB_MSC_INTSTAT_Msk (0x00080000UL) /*!< field USB_MSC_INTSTAT (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTSTAT_GMS_MSC_INTSTAT_Pos (20UL) /*!< field GMS_MSC_INTSTAT (bitOffset 20, bitWidth 1) */
#define SPCTR_MSCINTSTAT_GMS_MSC_INTSTAT_Msk (0x00100000UL) /*!< field GMS_MSC_INTSTAT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register MSCINTCLR =================================================== */
#define SPCTR_MSCINTCLR_DMA0_MSC_INTCLR_Pos (16UL) /*!< field DMA0_MSC_INTCLR (bitOffset 16, bitWidth 1) */
#define SPCTR_MSCINTCLR_DMA0_MSC_INTCLR_Msk (0x00010000UL) /*!< field DMA0_MSC_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTCLR_DMA1_MSC_INTCLR_Pos (17UL) /*!< field DMA1_MSC_INTCLR (bitOffset 17, bitWidth 1) */
#define SPCTR_MSCINTCLR_DMA1_MSC_INTCLR_Msk (0x00020000UL) /*!< field DMA1_MSC_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTCLR_SDMMC_SMC_INTCLR_Pos (18UL) /*!< field SDMMC_SMC_INTCLR (bitOffset 18, bitWidth 1) */
#define SPCTR_MSCINTCLR_SDMMC_SMC_INTCLR_Msk (0x00040000UL) /*!< field SDMMC_SMC_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTCLR_USB_MSC_INTCLR_Pos (19UL) /*!< field USB_MSC_INTCLR (bitOffset 19, bitWidth 1) */
#define SPCTR_MSCINTCLR_USB_MSC_INTCLR_Msk (0x00080000UL) /*!< field USB_MSC_INTCLR (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTCLR_GMS_MSC_INTCLR_Pos (20UL) /*!< field GMS_MSC_INTCLR (bitOffset 20, bitWidth 1) */
#define SPCTR_MSCINTCLR_GMS_MSC_INTCLR_Msk (0x00100000UL) /*!< field GMS_MSC_INTCLR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register MSCINTEN ==================================================== */
#define SPCTR_MSCINTEN_DMA0_MSC_INTEN_Pos (16UL) /*!< field DMA0_MSC_INTEN (bitOffset 16, bitWidth 1) */
#define SPCTR_MSCINTEN_DMA0_MSC_INTEN_Msk (0x00010000UL) /*!< field DMA0_MSC_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTEN_DMA1_MSC_INTEN_Pos (17UL) /*!< field DMA1_MSC_INTEN (bitOffset 17, bitWidth 1) */
#define SPCTR_MSCINTEN_DMA1_MSC_INTEN_Msk (0x00020000UL) /*!< field DMA1_MSC_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTEN_SDMMC_MSC_INTEN_Pos (18UL) /*!< field SDMMC_MSC_INTEN (bitOffset 18, bitWidth 1) */
#define SPCTR_MSCINTEN_SDMMC_MSC_INTEN_Msk (0x00040000UL) /*!< field SDMMC_MSC_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTEN_USB_MSC_INTEN_Pos (19UL) /*!< field USB_MSC_INTEN (bitOffset 19, bitWidth 1) */
#define SPCTR_MSCINTEN_USB_MSC_INTEN_Msk (0x00080000UL) /*!< field USB_MSC_INTEN (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSCINTEN_GMS_MSC_INTEN_Pos (20UL) /*!< field GMS_MSC_INTEN (bitOffset 20, bitWidth 1) */
#define SPCTR_MSCINTEN_GMS_MSC_INTEN_Msk (0x00100000UL) /*!< field GMS_MSC_INTEN (Bitfield-Mask: 0x00000001) */

/* =================================================== Register BRGINTSTAT =================================================== */
#define SPCTR_BRGINTSTAT_BRG_CPU1SYS_INTSTAT_Pos (0UL) /*!< field BRG_CPU1SYS_INTSTAT (bitOffset 0, bitWidth 1) */
#define SPCTR_BRGINTSTAT_BRG_CPU1SYS_INTSTAT_Msk (0x00000001UL) /*!< field BRG_CPU1SYS_INTSTAT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register BRGINTCLR =================================================== */
#define SPCTR_BRGINTCLR_BRG_CPU1SYS_INTCLR_Pos (0UL) /*!< field BRG_CPU1SYS_INTCLR (bitOffset 0, bitWidth 1) */
#define SPCTR_BRGINTCLR_BRG_CPU1SYS_INTCLR_Msk (0x00000001UL) /*!< field BRG_CPU1SYS_INTCLR (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register BRGINTEN ==================================================== */
#define SPCTR_BRGINTEN_BRG_CPU1SYS_INTEN_Pos (0UL) /*!< field BRG_CPU1SYS_INTEN (bitOffset 0, bitWidth 1) */
#define SPCTR_BRGINTEN_BRG_CPU1SYS_INTEN_Msk (0x00000001UL) /*!< field BRG_CPU1SYS_INTEN (Bitfield-Mask: 0x00000001) */

/* =================================================== Register AHBPPC0_NS =================================================== */
#define SPCTR_AHBPPC0_NS_USB_NS_Pos (0UL) /*!< field USB_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_USB_NS_Msk (0x00000001UL) /*!< field USB_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_QSPI_NS_Pos (1UL) /*!< field QSPI_NS (bitOffset 1, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_QSPI_NS_Msk (0x00000002UL) /*!< field QSPI_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_GNSS_NS_Pos (2UL) /*!< field GNSS_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_GNSS_NS_Msk (0x00000004UL) /*!< field GNSS_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_SMC_NS_Pos (3UL) /*!< field SMC_NS (bitOffset 3, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_SMC_NS_Msk (0x00000008UL) /*!< field SMC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_SDMMC_NS_Pos (4UL) /*!< field SDMMC_NS (bitOffset 4, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_SDMMC_NS_Msk (0x00000010UL) /*!< field SDMMC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_DMA0_NS_Pos (5UL) /*!< field DMA0_NS (bitOffset 5, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_DMA0_NS_Msk (0x00000020UL) /*!< field DMA0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_NS_DMA1_NS_Pos (6UL) /*!< field DMA1_NS (bitOffset 6, bitWidth 1) */
#define SPCTR_AHBPPC0_NS_DMA1_NS_Msk (0x00000040UL) /*!< field DMA1_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC4_NS =================================================== */
#define SPCTR_APBPPC4_NS_TIM0_NS_Pos (0UL) /*!< field TIM0_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC4_NS_TIM0_NS_Msk (0x00000001UL) /*!< field TIM0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_NS_TIM1_NS_Pos (1UL) /*!< field TIM1_NS (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC4_NS_TIM1_NS_Msk (0x00000002UL) /*!< field TIM1_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_NS_DTIM_NS_Pos (2UL) /*!< field DTIM_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC4_NS_DTIM_NS_Msk (0x00000004UL) /*!< field DTIM_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_NS_MHU0_NS_Pos (3UL) /*!< field MHU0_NS (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC4_NS_MHU0_NS_Msk (0x00000008UL) /*!< field MHU0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_NS_MHU1_NS_Pos (4UL) /*!< field MHU1_NS (bitOffset 4, bitWidth 1) */
#define SPCTR_APBPPC4_NS_MHU1_NS_Msk (0x00000010UL) /*!< field MHU1_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC5_NS =================================================== */
#define SPCTR_APBPPC5_NS_LPTIM_NS_Pos (0UL) /*!< field LPTIM_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC5_NS_LPTIM_NS_Msk (0x00000001UL) /*!< field LPTIM_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC0_NS =================================================== */
#define SPCTR_APBPPC0_NS_UART0_NS_Pos (0UL) /*!< field UART0_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC0_NS_UART0_NS_Msk (0x00000001UL) /*!< field UART0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_UART1_NS_Pos (1UL) /*!< field UART1_NS (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC0_NS_UART1_NS_Msk (0x00000002UL) /*!< field UART1_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_UART2_NS_Pos (2UL) /*!< field UART2_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC0_NS_UART2_NS_Msk (0x00000004UL) /*!< field UART2_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_UART3_NS_Pos (3UL) /*!< field UART3_NS (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC0_NS_UART3_NS_Msk (0x00000008UL) /*!< field UART3_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_SPI0_NS_Pos (4UL) /*!< field SPI0_NS (bitOffset 4, bitWidth 1) */
#define SPCTR_APBPPC0_NS_SPI0_NS_Msk (0x00000010UL) /*!< field SPI0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_SPI1_NS_Pos (5UL) /*!< field SPI1_NS (bitOffset 5, bitWidth 1) */
#define SPCTR_APBPPC0_NS_SPI1_NS_Msk (0x00000020UL) /*!< field SPI1_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_SPI2_NS_Pos (6UL) /*!< field SPI2_NS (bitOffset 6, bitWidth 1) */
#define SPCTR_APBPPC0_NS_SPI2_NS_Msk (0x00000040UL) /*!< field SPI2_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_I2C0_NS_Pos (7UL) /*!< field I2C0_NS (bitOffset 7, bitWidth 1) */
#define SPCTR_APBPPC0_NS_I2C0_NS_Msk (0x00000080UL) /*!< field I2C0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_I2C1_NS_Pos (8UL) /*!< field I2C1_NS (bitOffset 8, bitWidth 1) */
#define SPCTR_APBPPC0_NS_I2C1_NS_Msk (0x00000100UL) /*!< field I2C1_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_I2S_NS_Pos (9UL) /*!< field I2S_NS (bitOffset 9, bitWidth 1) */
#define SPCTR_APBPPC0_NS_I2S_NS_Msk (0x00000200UL) /*!< field I2S_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_GPIO0_NS_Pos (10UL) /*!< field GPIO0_NS (bitOffset 10, bitWidth 1) */
#define SPCTR_APBPPC0_NS_GPIO0_NS_Msk (0x00000400UL) /*!< field GPIO0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_GPIO1_NS_Pos (11UL) /*!< field GPIO1_NS (bitOffset 11, bitWidth 1) */
#define SPCTR_APBPPC0_NS_GPIO1_NS_Msk (0x00000800UL) /*!< field GPIO1_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_GPIO2_NS_Pos (12UL) /*!< field GPIO2_NS (bitOffset 12, bitWidth 1) */
#define SPCTR_APBPPC0_NS_GPIO2_NS_Msk (0x00001000UL) /*!< field GPIO2_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_NS_GPIO3_NS_Pos (13UL) /*!< field GPIO3_NS (bitOffset 13, bitWidth 1) */
#define SPCTR_APBPPC0_NS_GPIO3_NS_Msk (0x00002000UL) /*!< field GPIO3_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC1_NS =================================================== */
#define SPCTR_APBPPC1_NS_CAN_NS_Pos (0UL) /*!< field CAN_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC1_NS_CAN_NS_Msk (0x00000001UL) /*!< field CAN_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_NS_PWM_NS_Pos (1UL) /*!< field PWM_NS (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC1_NS_PWM_NS_Msk (0x00000002UL) /*!< field PWM_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_NS_VTU0_NS_Pos (2UL) /*!< field VTU0_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC1_NS_VTU0_NS_Msk (0x00000004UL) /*!< field VTU0_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_NS_VTU1_NS_Pos (3UL) /*!< field VTU1_NS (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC1_NS_VTU1_NS_Msk (0x00000008UL) /*!< field VTU1_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC2_NS =================================================== */
#define SPCTR_APBPPC2_NS_RWC_NS_Pos (2UL) /*!< field RWC_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC2_NS_RWC_NS_Msk (0x00000004UL) /*!< field RWC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC2_NS_JTM_NS_Pos (3UL) /*!< field JTM_NS (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC2_NS_JTM_NS_Msk (0x00000008UL) /*!< field JTM_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC3_NS =================================================== */
#define SPCTR_APBPPC3_NS_IOCTR_NS_Pos (0UL) /*!< field IOCTR_NS (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC3_NS_IOCTR_NS_Msk (0x00000001UL) /*!< field IOCTR_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC3_NS_CLKCTR_NS_Pos (1UL) /*!< field CLKCTR_NS (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC3_NS_CLKCTR_NS_Msk (0x00000002UL) /*!< field CLKCTR_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC3_NS_PWRCTR_NS_Pos (2UL) /*!< field PWRCTR_NS (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC3_NS_PWRCTR_NS_Msk (0x00000004UL) /*!< field PWRCTR_NS (Bitfield-Mask: 0x00000001) */

/* =================================================== Register AHBPPC0_SP =================================================== */
#define SPCTR_AHBPPC0_SP_USB_SP_Pos (0UL) /*!< field USB_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_USB_SP_Msk (0x00000001UL) /*!< field USB_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_QSPI_SP_Pos (1UL) /*!< field QSPI_SP (bitOffset 1, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_QSPI_SP_Msk (0x00000002UL) /*!< field QSPI_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_GNSS_SP_Pos (2UL) /*!< field GNSS_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_GNSS_SP_Msk (0x00000004UL) /*!< field GNSS_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_SMC_SP_Pos (3UL) /*!< field SMC_SP (bitOffset 3, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_SMC_SP_Msk (0x00000008UL) /*!< field SMC_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_SDMMC_SP_Pos (4UL) /*!< field SDMMC_SP (bitOffset 4, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_SDMMC_SP_Msk (0x00000010UL) /*!< field SDMMC_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_DMA0_SP_Pos (5UL) /*!< field DMA0_SP (bitOffset 5, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_DMA0_SP_Msk (0x00000020UL) /*!< field DMA0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_AHBPPC0_SP_DMA1_SP_Pos (6UL) /*!< field DMA1_SP (bitOffset 6, bitWidth 1) */
#define SPCTR_AHBPPC0_SP_DMA1_SP_Msk (0x00000040UL) /*!< field DMA1_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC4_SP =================================================== */
#define SPCTR_APBPPC4_SP_TIM0_SP_Pos (0UL) /*!< field TIM0_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC4_SP_TIM0_SP_Msk (0x00000001UL) /*!< field TIM0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_SP_TIM1_SP_Pos (1UL) /*!< field TIM1_SP (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC4_SP_TIM1_SP_Msk (0x00000002UL) /*!< field TIM1_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_SP_DTIM_SP_Pos (2UL) /*!< field DTIM_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC4_SP_DTIM_SP_Msk (0x00000004UL) /*!< field DTIM_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_SP_MHU0_SP_Pos (3UL) /*!< field MHU0_SP (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC4_SP_MHU0_SP_Msk (0x00000008UL) /*!< field MHU0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC4_SP_MHU1_SP_Pos (4UL) /*!< field MHU1_SP (bitOffset 4, bitWidth 1) */
#define SPCTR_APBPPC4_SP_MHU1_SP_Msk (0x00000010UL) /*!< field MHU1_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC5_SP =================================================== */
#define SPCTR_APBPPC5_SP_LPTIM_SP_Pos (0UL) /*!< field LPTIM_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC5_SP_LPTIM_SP_Msk (0x00000001UL) /*!< field LPTIM_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC0_SP =================================================== */
#define SPCTR_APBPPC0_SP_UART0_SP_Pos (0UL) /*!< field UART0_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC0_SP_UART0_SP_Msk (0x00000001UL) /*!< field UART0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_UART1_SP_Pos (1UL) /*!< field UART1_SP (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC0_SP_UART1_SP_Msk (0x00000002UL) /*!< field UART1_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_UART2_SP_Pos (2UL) /*!< field UART2_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC0_SP_UART2_SP_Msk (0x00000004UL) /*!< field UART2_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_UART3_SP_Pos (3UL) /*!< field UART3_SP (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC0_SP_UART3_SP_Msk (0x00000008UL) /*!< field UART3_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_SPI0_SP_Pos (4UL) /*!< field SPI0_SP (bitOffset 4, bitWidth 1) */
#define SPCTR_APBPPC0_SP_SPI0_SP_Msk (0x00000010UL) /*!< field SPI0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_SPI1_SP_Pos (5UL) /*!< field SPI1_SP (bitOffset 5, bitWidth 1) */
#define SPCTR_APBPPC0_SP_SPI1_SP_Msk (0x00000020UL) /*!< field SPI1_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_SPI2_SP_Pos (6UL) /*!< field SPI2_SP (bitOffset 6, bitWidth 1) */
#define SPCTR_APBPPC0_SP_SPI2_SP_Msk (0x00000040UL) /*!< field SPI2_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_I2C0_SP_Pos (7UL) /*!< field I2C0_SP (bitOffset 7, bitWidth 1) */
#define SPCTR_APBPPC0_SP_I2C0_SP_Msk (0x00000080UL) /*!< field I2C0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_I2C1_SP_Pos (8UL) /*!< field I2C1_SP (bitOffset 8, bitWidth 1) */
#define SPCTR_APBPPC0_SP_I2C1_SP_Msk (0x00000100UL) /*!< field I2C1_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_I2S_SP_Pos (9UL) /*!< field I2S_SP (bitOffset 9, bitWidth 1) */
#define SPCTR_APBPPC0_SP_I2S_SP_Msk (0x00000200UL) /*!< field I2S_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_GPIO0_SP_Pos (10UL) /*!< field GPIO0_SP (bitOffset 10, bitWidth 1) */
#define SPCTR_APBPPC0_SP_GPIO0_SP_Msk (0x00000400UL) /*!< field GPIO0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_GPIO1_SP_Pos (11UL) /*!< field GPIO1_SP (bitOffset 11, bitWidth 1) */
#define SPCTR_APBPPC0_SP_GPIO1_SP_Msk (0x00000800UL) /*!< field GPIO1_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_GPIO2_SP_Pos (12UL) /*!< field GPIO2_SP (bitOffset 12, bitWidth 1) */
#define SPCTR_APBPPC0_SP_GPIO2_SP_Msk (0x00001000UL) /*!< field GPIO2_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC0_SP_GPIO3_SP_Pos (13UL) /*!< field GPIO3_SP (bitOffset 13, bitWidth 1) */
#define SPCTR_APBPPC0_SP_GPIO3_SP_Msk (0x00002000UL) /*!< field GPIO3_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC1_SP =================================================== */
#define SPCTR_APBPPC1_SP_CAN_SP_Pos (0UL) /*!< field CAN_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC1_SP_CAN_SP_Msk (0x00000001UL) /*!< field CAN_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_SP_PWM_SP_Pos (1UL) /*!< field PWM_SP (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC1_SP_PWM_SP_Msk (0x00000002UL) /*!< field PWM_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_SP_VTU0_SP_Pos (2UL) /*!< field VTU0_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC1_SP_VTU0_SP_Msk (0x00000004UL) /*!< field VTU0_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC1_SP_VTU1_SP_Pos (3UL) /*!< field VTU1_SP (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC1_SP_VTU1_SP_Msk (0x00000008UL) /*!< field VTU1_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC2_SP =================================================== */
#define SPCTR_APBPPC2_SP_RWC_SP_Pos (2UL) /*!< field RWC_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC2_SP_RWC_SP_Msk (0x00000004UL) /*!< field RWC_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC2_SP_JTM_SP_Pos (3UL) /*!< field JTM_SP (bitOffset 3, bitWidth 1) */
#define SPCTR_APBPPC2_SP_JTM_SP_Msk (0x00000008UL) /*!< field JTM_SP (Bitfield-Mask: 0x00000001) */

/* =================================================== Register APBPPC3_SP =================================================== */
#define SPCTR_APBPPC3_SP_IOCTR_SP_Pos (0UL) /*!< field IOCTR_SP (bitOffset 0, bitWidth 1) */
#define SPCTR_APBPPC3_SP_IOCTR_SP_Msk (0x00000001UL) /*!< field IOCTR_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC3_SP_CLKCTR_SP_Pos (1UL) /*!< field CLKCTR_SP (bitOffset 1, bitWidth 1) */
#define SPCTR_APBPPC3_SP_CLKCTR_SP_Msk (0x00000002UL) /*!< field CLKCTR_SP (Bitfield-Mask: 0x00000001) */
#define SPCTR_APBPPC3_SP_PWRCTR_SP_Pos (2UL) /*!< field PWRCTR_SP (bitOffset 2, bitWidth 1) */
#define SPCTR_APBPPC3_SP_PWRCTR_SP_Msk (0x00000004UL) /*!< field PWRCTR_SP (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register MSC_NS ===================================================== */
#define SPCTR_MSC_NS_DMA0_MSC_NS_Pos (16UL) /*!< field DMA0_MSC_NS (bitOffset 16, bitWidth 1) */
#define SPCTR_MSC_NS_DMA0_MSC_NS_Msk (0x00010000UL) /*!< field DMA0_MSC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSC_NS_DMA1_MSC_NS_Pos (17UL) /*!< field DMA1_MSC_NS (bitOffset 17, bitWidth 1) */
#define SPCTR_MSC_NS_DMA1_MSC_NS_Msk (0x00020000UL) /*!< field DMA1_MSC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSC_NS_SDMMC_SMC_NS_Pos (18UL) /*!< field SDMMC_SMC_NS (bitOffset 18, bitWidth 1) */
#define SPCTR_MSC_NS_SDMMC_SMC_NS_Msk (0x00040000UL) /*!< field SDMMC_SMC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSC_NS_USB_MSC_NS_Pos (19UL) /*!< field USB_MSC_NS (bitOffset 19, bitWidth 1) */
#define SPCTR_MSC_NS_USB_MSC_NS_Msk (0x00080000UL) /*!< field USB_MSC_NS (Bitfield-Mask: 0x00000001) */
#define SPCTR_MSC_NS_GMS_MSC_NS_Pos (20UL) /*!< field GMS_MSC_NS (bitOffset 20, bitWidth 1) */
#define SPCTR_MSC_NS_GMS_MSC_NS_Msk (0x00100000UL) /*!< field GMS_MSC_NS (Bitfield-Mask: 0x00000001) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: MPC ================================================= */
/* =========================================================================================================================== */

/* ====================================================== Register CTRL ====================================================== */
#define MPC_CTRL_SEC_RESP_Pos (4UL) /*!< field SEC_RESP (bitOffset 4, bitWidth 1) */
#define MPC_CTRL_SEC_RESP_Msk (0x00000010UL) /*!< field SEC_RESP (Bitfield-Mask: 0x00000001) */
#define MPC_CTRL_GATE_REQ_Pos (6UL) /*!< field GATE_REQ (bitOffset 6, bitWidth 1) */
#define MPC_CTRL_GATE_REQ_Msk (0x00000040UL) /*!< field GATE_REQ (Bitfield-Mask: 0x00000001) */
#define MPC_CTRL_GATE_ACK_Pos (7UL) /*!< field GATE_ACK (bitOffset 7, bitWidth 1) */
#define MPC_CTRL_GATE_ACK_Msk (0x00000080UL) /*!< field GATE_ACK (Bitfield-Mask: 0x00000001) */
#define MPC_CTRL_AUTOINCR_EN_Pos (8UL) /*!< field AUTOINCR_EN (bitOffset 8, bitWidth 1) */
#define MPC_CTRL_AUTOINCR_EN_Msk (0x00000100UL) /*!< field AUTOINCR_EN (Bitfield-Mask: 0x00000001) */
#define MPC_CTRL_SEC_LOCK_Pos (31UL) /*!< field SEC_LOCK (bitOffset 31, bitWidth 1) */
#define MPC_CTRL_SEC_LOCK_Msk (0x80000000UL) /*!< field SEC_LOCK (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register BLK_MAX ==================================================== */
#define MPC_BLK_MAX_BLK_MAX_Pos (0UL) /*!< field BLK_MAX (bitOffset 0, bitWidth 32) */
#define MPC_BLK_MAX_BLK_MAX_Msk (0xffffffffUL) /*!< field BLK_MAX (Bitfield-Mask: 0xffffffff) */

/* ===================================================== Register BLK_CFG ==================================================== */
#define MPC_BLK_CFG_BLK_SIZE_Pos (0UL) /*!< field BLK_SIZE (bitOffset 0, bitWidth 4) */
#define MPC_BLK_CFG_BLK_SIZE_Msk (0x0000000fUL) /*!< field BLK_SIZE (Bitfield-Mask: 0x0000000f) */
#define MPC_BLK_CFG_INIT_N_DONE_Pos (31UL) /*!< field INIT_N_DONE (bitOffset 31, bitWidth 1) */
#define MPC_BLK_CFG_INIT_N_DONE_Msk (0x80000000UL) /*!< field INIT_N_DONE (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register BLK_IDX ==================================================== */
#define MPC_BLK_IDX_BLK_IDX_Pos (0UL) /*!< field BLK_IDX (bitOffset 0, bitWidth 12) */
#define MPC_BLK_IDX_BLK_IDX_Msk (0x00000fffUL) /*!< field BLK_IDX (Bitfield-Mask: 0x00000fff) */

/* ===================================================== Register BLK_LUT ==================================================== */
#define MPC_BLK_LUT_BLK_LUT_Pos (0UL) /*!< field BLK_LUT (bitOffset 0, bitWidth 32) */
#define MPC_BLK_LUT_BLK_LUT_Msk (0xffffffffUL) /*!< field BLK_LUT (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register INT_STAT ==================================================== */
#define MPC_INT_STAT_INT_STAT_Pos (0UL) /*!< field INT_STAT (bitOffset 0, bitWidth 1) */
#define MPC_INT_STAT_INT_STAT_Msk (0x00000001UL) /*!< field INT_STAT (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register INT_CLEAR =================================================== */
#define MPC_INT_CLEAR_INT_CLEAR_Pos (0UL) /*!< field INT_CLEAR (bitOffset 0, bitWidth 1) */
#define MPC_INT_CLEAR_INT_CLEAR_Msk (0x00000001UL) /*!< field INT_CLEAR (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register INT_EN ===================================================== */
#define MPC_INT_EN_INT_EN_Pos (0UL) /*!< field INT_EN (bitOffset 0, bitWidth 1) */
#define MPC_INT_EN_INT_EN_Msk (0x00000001UL) /*!< field INT_EN (Bitfield-Mask: 0x00000001) */

/* ==================================================== Register INT_INFO1 =================================================== */
#define MPC_INT_INFO1_HADDR_Pos (0UL) /*!< field HADDR (bitOffset 0, bitWidth 32) */
#define MPC_INT_INFO1_HADDR_Msk (0xffffffffUL) /*!< field HADDR (Bitfield-Mask: 0xffffffff) */

/* ==================================================== Register INT_INFO2 =================================================== */
#define MPC_INT_INFO2_HMASTER_Pos (0UL) /*!< field HMASTER (bitOffset 0, bitWidth 16) */
#define MPC_INT_INFO2_HMASTER_Msk (0x0000ffffUL) /*!< field HMASTER (Bitfield-Mask: 0x0000ffff) */
#define MPC_INT_INFO2_HNONSEC_Pos (16UL) /*!< field HNONSEC (bitOffset 16, bitWidth 1) */
#define MPC_INT_INFO2_HNONSEC_Msk (0x00010000UL) /*!< field HNONSEC (Bitfield-Mask: 0x00000001) */
#define MPC_INT_INFO2_CFG_NS_Pos (17UL) /*!< field CFG_NS (bitOffset 17, bitWidth 1) */
#define MPC_INT_INFO2_CFG_NS_Msk (0x00020000UL) /*!< field CFG_NS (Bitfield-Mask: 0x00000001) */

/* ===================================================== Register INT_SET ==================================================== */
#define MPC_INT_SET_INT_SET_Pos (0UL) /*!< field INT_SET (bitOffset 0, bitWidth 1) */
#define MPC_INT_SET_INT_SET_Msk (0x00000001UL) /*!< field INT_SET (Bitfield-Mask: 0x00000001) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: UART ================================================ */
/* =========================================================================================================================== */

/* ======================================================= Register DLL ====================================================== */
#define UART_DLL_DLL_Pos (0UL) /*!< field DLL (bitOffset 0, bitWidth 8) */
#define UART_DLL_DLL_Msk (0x000000ffUL) /*!< field DLL (Bitfield-Mask: 0x000000ff) */
#define UART_DLL_RSVD_DLL_31TO8_Pos (8UL) /*!< field RSVD_DLL_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_DLL_RSVD_DLL_31TO8_Msk (0xffffff00UL) /*!< field RSVD_DLL_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register RBR ====================================================== */
#define UART_RBR_RBR_Pos (0UL) /*!< field RBR (bitOffset 0, bitWidth 9) */
#define UART_RBR_RBR_Msk (0x000001ffUL) /*!< field RBR (Bitfield-Mask: 0x000001ff) */
#define UART_RBR_RSVD_RBR_Pos (9UL) /*!< field RSVD_RBR (bitOffset 9, bitWidth 23) */
#define UART_RBR_RSVD_RBR_Msk (0xfffffe00UL) /*!< field RSVD_RBR (Bitfield-Mask: 0x007fffff) */

/* ======================================================= Register THR ====================================================== */
#define UART_THR_THR_Pos (0UL) /*!< field THR (bitOffset 0, bitWidth 9) */
#define UART_THR_THR_Msk (0x000001ffUL) /*!< field THR (Bitfield-Mask: 0x000001ff) */
#define UART_THR_RSVD_THR_Pos (9UL) /*!< field RSVD_THR (bitOffset 9, bitWidth 23) */
#define UART_THR_RSVD_THR_Msk (0xfffffe00UL) /*!< field RSVD_THR (Bitfield-Mask: 0x007fffff) */

/* ======================================================= Register DLH ====================================================== */
#define UART_DLH_DLH_Pos (0UL) /*!< field DLH (bitOffset 0, bitWidth 8) */
#define UART_DLH_DLH_Msk (0x000000ffUL) /*!< field DLH (Bitfield-Mask: 0x000000ff) */
#define UART_DLH_RSVD_DLH_Pos (8UL) /*!< field RSVD_DLH (bitOffset 8, bitWidth 24) */
#define UART_DLH_RSVD_DLH_Msk (0xffffff00UL) /*!< field RSVD_DLH (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register IER ====================================================== */
#define UART_IER_ERBFI_Pos (0UL) /*!< field ERBFI (bitOffset 0, bitWidth 1) */
#define UART_IER_ERBFI_Msk (0x00000001UL) /*!< field ERBFI (Bitfield-Mask: 0x00000001) */
#define UART_IER_ETBEI_Pos (1UL) /*!< field ETBEI (bitOffset 1, bitWidth 1) */
#define UART_IER_ETBEI_Msk (0x00000002UL) /*!< field ETBEI (Bitfield-Mask: 0x00000001) */
#define UART_IER_ELSI_Pos (2UL) /*!< field ELSI (bitOffset 2, bitWidth 1) */
#define UART_IER_ELSI_Msk (0x00000004UL) /*!< field ELSI (Bitfield-Mask: 0x00000001) */
#define UART_IER_EDSSI_Pos (3UL) /*!< field EDSSI (bitOffset 3, bitWidth 1) */
#define UART_IER_EDSSI_Msk (0x00000008UL) /*!< field EDSSI (Bitfield-Mask: 0x00000001) */
#define UART_IER_ELCOLR_Pos (4UL) /*!< field ELCOLR (bitOffset 4, bitWidth 1) */
#define UART_IER_ELCOLR_Msk (0x00000010UL) /*!< field ELCOLR (Bitfield-Mask: 0x00000001) */
#define UART_IER_RSVD_IER_6TO5_Pos (5UL) /*!< field RSVD_IER_6TO5 (bitOffset 5, bitWidth 2) */
#define UART_IER_RSVD_IER_6TO5_Msk (0x00000060UL) /*!< field RSVD_IER_6TO5 (Bitfield-Mask: 0x00000003) */
#define UART_IER_PTIME_Pos (7UL) /*!< field PTIME (bitOffset 7, bitWidth 1) */
#define UART_IER_PTIME_Msk (0x00000080UL) /*!< field PTIME (Bitfield-Mask: 0x00000001) */
#define UART_IER_RSVD_IER_31TO8_Pos (8UL) /*!< field RSVD_IER_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_IER_RSVD_IER_31TO8_Msk (0xffffff00UL) /*!< field RSVD_IER_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register FCR ====================================================== */
#define UART_FCR_FIFOE_Pos (0UL) /*!< field FIFOE (bitOffset 0, bitWidth 1) */
#define UART_FCR_FIFOE_Msk (0x00000001UL) /*!< field FIFOE (Bitfield-Mask: 0x00000001) */
#define UART_FCR_RFIFOR_Pos (1UL) /*!< field RFIFOR (bitOffset 1, bitWidth 1) */
#define UART_FCR_RFIFOR_Msk (0x00000002UL) /*!< field RFIFOR (Bitfield-Mask: 0x00000001) */
#define UART_FCR_XFIFOR_Pos (2UL) /*!< field XFIFOR (bitOffset 2, bitWidth 1) */
#define UART_FCR_XFIFOR_Msk (0x00000004UL) /*!< field XFIFOR (Bitfield-Mask: 0x00000001) */
#define UART_FCR_DMAM_Pos (3UL) /*!< field DMAM (bitOffset 3, bitWidth 1) */
#define UART_FCR_DMAM_Msk (0x00000008UL) /*!< field DMAM (Bitfield-Mask: 0x00000001) */
#define UART_FCR_TET_Pos (4UL) /*!< field TET (bitOffset 4, bitWidth 2) */
#define UART_FCR_TET_Msk (0x00000030UL) /*!< field TET (Bitfield-Mask: 0x00000003) */
#define UART_FCR_RT_Pos (6UL) /*!< field RT (bitOffset 6, bitWidth 2) */
#define UART_FCR_RT_Msk (0x000000c0UL) /*!< field RT (Bitfield-Mask: 0x00000003) */
#define UART_FCR_RSVD_FCR_31TO8_Pos (8UL) /*!< field RSVD_FCR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_FCR_RSVD_FCR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_FCR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register IIR ====================================================== */
#define UART_IIR_IID_Pos (0UL) /*!< field IID (bitOffset 0, bitWidth 4) */
#define UART_IIR_IID_Msk (0x0000000fUL) /*!< field IID (Bitfield-Mask: 0x0000000f) */
#define UART_IIR_RSVD_IIR_5TO4_Pos (4UL) /*!< field RSVD_IIR_5TO4 (bitOffset 4, bitWidth 2) */
#define UART_IIR_RSVD_IIR_5TO4_Msk (0x00000030UL) /*!< field RSVD_IIR_5TO4 (Bitfield-Mask: 0x00000003) */
#define UART_IIR_FIFOSE_Pos (6UL) /*!< field FIFOSE (bitOffset 6, bitWidth 2) */
#define UART_IIR_FIFOSE_Msk (0x000000c0UL) /*!< field FIFOSE (Bitfield-Mask: 0x00000003) */
#define UART_IIR_RSVD_IIR_31TO8_Pos (8UL) /*!< field RSVD_IIR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_IIR_RSVD_IIR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_IIR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register LCR ====================================================== */
#define UART_LCR_DLS_Pos (0UL) /*!< field DLS (bitOffset 0, bitWidth 2) */
#define UART_LCR_DLS_Msk (0x00000003UL) /*!< field DLS (Bitfield-Mask: 0x00000003) */
#define UART_LCR_STOP_Pos (2UL) /*!< field STOP (bitOffset 2, bitWidth 1) */
#define UART_LCR_STOP_Msk (0x00000004UL) /*!< field STOP (Bitfield-Mask: 0x00000001) */
#define UART_LCR_PEN_Pos (3UL) /*!< field PEN (bitOffset 3, bitWidth 1) */
#define UART_LCR_PEN_Msk (0x00000008UL) /*!< field PEN (Bitfield-Mask: 0x00000001) */
#define UART_LCR_EPS_Pos (4UL) /*!< field EPS (bitOffset 4, bitWidth 1) */
#define UART_LCR_EPS_Msk (0x00000010UL) /*!< field EPS (Bitfield-Mask: 0x00000001) */
#define UART_LCR_SP_Pos (5UL) /*!< field SP (bitOffset 5, bitWidth 1) */
#define UART_LCR_SP_Msk (0x00000020UL) /*!< field SP (Bitfield-Mask: 0x00000001) */
#define UART_LCR_BC_Pos (6UL) /*!< field BC (bitOffset 6, bitWidth 1) */
#define UART_LCR_BC_Msk (0x00000040UL) /*!< field BC (Bitfield-Mask: 0x00000001) */
#define UART_LCR_DLAB_Pos (7UL) /*!< field DLAB (bitOffset 7, bitWidth 1) */
#define UART_LCR_DLAB_Msk (0x00000080UL) /*!< field DLAB (Bitfield-Mask: 0x00000001) */
#define UART_LCR_RSVD_LCR_31TO8_Pos (8UL) /*!< field RSVD_LCR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_LCR_RSVD_LCR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_LCR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register MCR ====================================================== */
#define UART_MCR_DTR_Pos (0UL) /*!< field DTR (bitOffset 0, bitWidth 1) */
#define UART_MCR_DTR_Msk (0x00000001UL) /*!< field DTR (Bitfield-Mask: 0x00000001) */
#define UART_MCR_RTS_Pos (1UL) /*!< field RTS (bitOffset 1, bitWidth 1) */
#define UART_MCR_RTS_Msk (0x00000002UL) /*!< field RTS (Bitfield-Mask: 0x00000001) */
#define UART_MCR_OUT1_Pos (2UL) /*!< field OUT1 (bitOffset 2, bitWidth 1) */
#define UART_MCR_OUT1_Msk (0x00000004UL) /*!< field OUT1 (Bitfield-Mask: 0x00000001) */
#define UART_MCR_OUT2_Pos (3UL) /*!< field OUT2 (bitOffset 3, bitWidth 1) */
#define UART_MCR_OUT2_Msk (0x00000008UL) /*!< field OUT2 (Bitfield-Mask: 0x00000001) */
#define UART_MCR_LOOPBACK_Pos (4UL) /*!< field LOOPBACK (bitOffset 4, bitWidth 1) */
#define UART_MCR_LOOPBACK_Msk (0x00000010UL) /*!< field LOOPBACK (Bitfield-Mask: 0x00000001) */
#define UART_MCR_AFCE_Pos (5UL) /*!< field AFCE (bitOffset 5, bitWidth 1) */
#define UART_MCR_AFCE_Msk (0x00000020UL) /*!< field AFCE (Bitfield-Mask: 0x00000001) */
#define UART_MCR_SIRE_Pos (6UL) /*!< field SIRE (bitOffset 6, bitWidth 1) */
#define UART_MCR_SIRE_Msk (0x00000040UL) /*!< field SIRE (Bitfield-Mask: 0x00000001) */
#define UART_MCR_RSVD_MCR_31TO7_Pos (7UL) /*!< field RSVD_MCR_31TO7 (bitOffset 7, bitWidth 25) */
#define UART_MCR_RSVD_MCR_31TO7_Msk (0xffffff80UL) /*!< field RSVD_MCR_31TO7 (Bitfield-Mask: 0x01ffffff) */

/* ======================================================= Register LSR ====================================================== */
#define UART_LSR_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 1) */
#define UART_LSR_DR_Msk (0x00000001UL) /*!< field DR (Bitfield-Mask: 0x00000001) */
#define UART_LSR_OE_Pos (1UL) /*!< field OE (bitOffset 1, bitWidth 1) */
#define UART_LSR_OE_Msk (0x00000002UL) /*!< field OE (Bitfield-Mask: 0x00000001) */
#define UART_LSR_PE_Pos (2UL) /*!< field PE (bitOffset 2, bitWidth 1) */
#define UART_LSR_PE_Msk (0x00000004UL) /*!< field PE (Bitfield-Mask: 0x00000001) */
#define UART_LSR_FE_Pos (3UL) /*!< field FE (bitOffset 3, bitWidth 1) */
#define UART_LSR_FE_Msk (0x00000008UL) /*!< field FE (Bitfield-Mask: 0x00000001) */
#define UART_LSR_BI_Pos (4UL) /*!< field BI (bitOffset 4, bitWidth 1) */
#define UART_LSR_BI_Msk (0x00000010UL) /*!< field BI (Bitfield-Mask: 0x00000001) */
#define UART_LSR_THRE_Pos (5UL) /*!< field THRE (bitOffset 5, bitWidth 1) */
#define UART_LSR_THRE_Msk (0x00000020UL) /*!< field THRE (Bitfield-Mask: 0x00000001) */
#define UART_LSR_TEMT_Pos (6UL) /*!< field TEMT (bitOffset 6, bitWidth 1) */
#define UART_LSR_TEMT_Msk (0x00000040UL) /*!< field TEMT (Bitfield-Mask: 0x00000001) */
#define UART_LSR_RFE_Pos (7UL) /*!< field RFE (bitOffset 7, bitWidth 1) */
#define UART_LSR_RFE_Msk (0x00000080UL) /*!< field RFE (Bitfield-Mask: 0x00000001) */
#define UART_LSR_ADDR_RCVD_Pos (8UL) /*!< field ADDR_RCVD (bitOffset 8, bitWidth 1) */
#define UART_LSR_ADDR_RCVD_Msk (0x00000100UL) /*!< field ADDR_RCVD (Bitfield-Mask: 0x00000001) */
#define UART_LSR_RSVD_LSR_31TO9_Pos (9UL) /*!< field RSVD_LSR_31TO9 (bitOffset 9, bitWidth 23) */
#define UART_LSR_RSVD_LSR_31TO9_Msk (0xfffffe00UL) /*!< field RSVD_LSR_31TO9 (Bitfield-Mask: 0x007fffff) */

/* ======================================================= Register MSR ====================================================== */
#define UART_MSR_DCTS_Pos (0UL) /*!< field DCTS (bitOffset 0, bitWidth 1) */
#define UART_MSR_DCTS_Msk (0x00000001UL) /*!< field DCTS (Bitfield-Mask: 0x00000001) */
#define UART_MSR_DDSR_Pos (1UL) /*!< field DDSR (bitOffset 1, bitWidth 1) */
#define UART_MSR_DDSR_Msk (0x00000002UL) /*!< field DDSR (Bitfield-Mask: 0x00000001) */
#define UART_MSR_TERI_Pos (2UL) /*!< field TERI (bitOffset 2, bitWidth 1) */
#define UART_MSR_TERI_Msk (0x00000004UL) /*!< field TERI (Bitfield-Mask: 0x00000001) */
#define UART_MSR_DDCD_Pos (3UL) /*!< field DDCD (bitOffset 3, bitWidth 1) */
#define UART_MSR_DDCD_Msk (0x00000008UL) /*!< field DDCD (Bitfield-Mask: 0x00000001) */
#define UART_MSR_CTS_Pos (4UL) /*!< field CTS (bitOffset 4, bitWidth 1) */
#define UART_MSR_CTS_Msk (0x00000010UL) /*!< field CTS (Bitfield-Mask: 0x00000001) */
#define UART_MSR_DSR_Pos (5UL) /*!< field DSR (bitOffset 5, bitWidth 1) */
#define UART_MSR_DSR_Msk (0x00000020UL) /*!< field DSR (Bitfield-Mask: 0x00000001) */
#define UART_MSR_RI_Pos (6UL) /*!< field RI (bitOffset 6, bitWidth 1) */
#define UART_MSR_RI_Msk (0x00000040UL) /*!< field RI (Bitfield-Mask: 0x00000001) */
#define UART_MSR_DCD_Pos (7UL) /*!< field DCD (bitOffset 7, bitWidth 1) */
#define UART_MSR_DCD_Msk (0x00000080UL) /*!< field DCD (Bitfield-Mask: 0x00000001) */
#define UART_MSR_RSVD_MSR_31TO8_Pos (8UL) /*!< field RSVD_MSR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_MSR_RSVD_MSR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_MSR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register SCR ====================================================== */
#define UART_SCR_SCR_Pos (0UL) /*!< field SCR (bitOffset 0, bitWidth 8) */
#define UART_SCR_SCR_Msk (0x000000ffUL) /*!< field SCR (Bitfield-Mask: 0x000000ff) */
#define UART_SCR_RSVD_SCR_31TO8_Pos (8UL) /*!< field RSVD_SCR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_SCR_RSVD_SCR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_SCR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ====================================================== Register SRBR0 ===================================================== */
#define UART_SRBR0_SRBRN_Pos (0UL) /*!< field SRBRN (bitOffset 0, bitWidth 9) */
#define UART_SRBR0_SRBRN_Msk (0x000001ffUL) /*!< field SRBRN (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR0_RSVD_SRBRN_Pos (9UL) /*!< field RSVD_SRBRN (bitOffset 9, bitWidth 23) */
#define UART_SRBR0_RSVD_SRBRN_Msk (0xfffffe00UL) /*!< field RSVD_SRBRN (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR0 ===================================================== */
#define UART_STHR0_STHRN_Pos (0UL) /*!< field STHRN (bitOffset 0, bitWidth 9) */
#define UART_STHR0_STHRN_Msk (0x000001ffUL) /*!< field STHRN (Bitfield-Mask: 0x000001ff) */
#define UART_STHR0_RSVD_STHRN_Pos (9UL) /*!< field RSVD_STHRN (bitOffset 9, bitWidth 23) */
#define UART_STHR0_RSVD_STHRN_Msk (0xfffffe00UL) /*!< field RSVD_STHRN (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR1 ===================================================== */
#define UART_SRBR1_SRBR1_Pos (0UL) /*!< field SRBR1 (bitOffset 0, bitWidth 9) */
#define UART_SRBR1_SRBR1_Msk (0x000001ffUL) /*!< field SRBR1 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR1_RSVD_SRBR1_Pos (9UL) /*!< field RSVD_SRBR1 (bitOffset 9, bitWidth 23) */
#define UART_SRBR1_RSVD_SRBR1_Msk (0xfffffe00UL) /*!< field RSVD_SRBR1 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR1 ===================================================== */
#define UART_STHR1_STHR1_Pos (0UL) /*!< field STHR1 (bitOffset 0, bitWidth 9) */
#define UART_STHR1_STHR1_Msk (0x000001ffUL) /*!< field STHR1 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR1_RSVD_STHR1_Pos (9UL) /*!< field RSVD_STHR1 (bitOffset 9, bitWidth 23) */
#define UART_STHR1_RSVD_STHR1_Msk (0xfffffe00UL) /*!< field RSVD_STHR1 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR2 ===================================================== */
#define UART_SRBR2_SRBR2_Pos (0UL) /*!< field SRBR2 (bitOffset 0, bitWidth 9) */
#define UART_SRBR2_SRBR2_Msk (0x000001ffUL) /*!< field SRBR2 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR2_RSVD_SRBR2_Pos (9UL) /*!< field RSVD_SRBR2 (bitOffset 9, bitWidth 23) */
#define UART_SRBR2_RSVD_SRBR2_Msk (0xfffffe00UL) /*!< field RSVD_SRBR2 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR2 ===================================================== */
#define UART_STHR2_STHR2_Pos (0UL) /*!< field STHR2 (bitOffset 0, bitWidth 9) */
#define UART_STHR2_STHR2_Msk (0x000001ffUL) /*!< field STHR2 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR2_RSVD_STHR2_Pos (9UL) /*!< field RSVD_STHR2 (bitOffset 9, bitWidth 23) */
#define UART_STHR2_RSVD_STHR2_Msk (0xfffffe00UL) /*!< field RSVD_STHR2 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR3 ===================================================== */
#define UART_SRBR3_SRBR3_Pos (0UL) /*!< field SRBR3 (bitOffset 0, bitWidth 9) */
#define UART_SRBR3_SRBR3_Msk (0x000001ffUL) /*!< field SRBR3 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR3_RSVD_SRBR3_Pos (9UL) /*!< field RSVD_SRBR3 (bitOffset 9, bitWidth 23) */
#define UART_SRBR3_RSVD_SRBR3_Msk (0xfffffe00UL) /*!< field RSVD_SRBR3 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR3 ===================================================== */
#define UART_STHR3_STHR3_Pos (0UL) /*!< field STHR3 (bitOffset 0, bitWidth 9) */
#define UART_STHR3_STHR3_Msk (0x000001ffUL) /*!< field STHR3 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR3_RSVD_STHR3_Pos (9UL) /*!< field RSVD_STHR3 (bitOffset 9, bitWidth 23) */
#define UART_STHR3_RSVD_STHR3_Msk (0xfffffe00UL) /*!< field RSVD_STHR3 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR4 ===================================================== */
#define UART_SRBR4_SRBR4_Pos (0UL) /*!< field SRBR4 (bitOffset 0, bitWidth 9) */
#define UART_SRBR4_SRBR4_Msk (0x000001ffUL) /*!< field SRBR4 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR4_RSVD_SRBR4_Pos (9UL) /*!< field RSVD_SRBR4 (bitOffset 9, bitWidth 23) */
#define UART_SRBR4_RSVD_SRBR4_Msk (0xfffffe00UL) /*!< field RSVD_SRBR4 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR4 ===================================================== */
#define UART_STHR4_STHR4_Pos (0UL) /*!< field STHR4 (bitOffset 0, bitWidth 9) */
#define UART_STHR4_STHR4_Msk (0x000001ffUL) /*!< field STHR4 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR4_RSVD_STHR4_Pos (9UL) /*!< field RSVD_STHR4 (bitOffset 9, bitWidth 23) */
#define UART_STHR4_RSVD_STHR4_Msk (0xfffffe00UL) /*!< field RSVD_STHR4 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR5 ===================================================== */
#define UART_SRBR5_SRBR5_Pos (0UL) /*!< field SRBR5 (bitOffset 0, bitWidth 9) */
#define UART_SRBR5_SRBR5_Msk (0x000001ffUL) /*!< field SRBR5 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR5_RSVD_SRBR5_Pos (9UL) /*!< field RSVD_SRBR5 (bitOffset 9, bitWidth 23) */
#define UART_SRBR5_RSVD_SRBR5_Msk (0xfffffe00UL) /*!< field RSVD_SRBR5 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR5 ===================================================== */
#define UART_STHR5_STHR5_Pos (0UL) /*!< field STHR5 (bitOffset 0, bitWidth 9) */
#define UART_STHR5_STHR5_Msk (0x000001ffUL) /*!< field STHR5 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR5_RSVD_STHR5_Pos (9UL) /*!< field RSVD_STHR5 (bitOffset 9, bitWidth 23) */
#define UART_STHR5_RSVD_STHR5_Msk (0xfffffe00UL) /*!< field RSVD_STHR5 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR6 ===================================================== */
#define UART_SRBR6_SRBR6_Pos (0UL) /*!< field SRBR6 (bitOffset 0, bitWidth 9) */
#define UART_SRBR6_SRBR6_Msk (0x000001ffUL) /*!< field SRBR6 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR6_RSVD_SRBR6_Pos (9UL) /*!< field RSVD_SRBR6 (bitOffset 9, bitWidth 23) */
#define UART_SRBR6_RSVD_SRBR6_Msk (0xfffffe00UL) /*!< field RSVD_SRBR6 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR6 ===================================================== */
#define UART_STHR6_STHR6_Pos (0UL) /*!< field STHR6 (bitOffset 0, bitWidth 9) */
#define UART_STHR6_STHR6_Msk (0x000001ffUL) /*!< field STHR6 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR6_RSVD_STHR6_Pos (9UL) /*!< field RSVD_STHR6 (bitOffset 9, bitWidth 23) */
#define UART_STHR6_RSVD_STHR6_Msk (0xfffffe00UL) /*!< field RSVD_STHR6 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR7 ===================================================== */
#define UART_SRBR7_SRBR7_Pos (0UL) /*!< field SRBR7 (bitOffset 0, bitWidth 9) */
#define UART_SRBR7_SRBR7_Msk (0x000001ffUL) /*!< field SRBR7 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR7_RSVD_SRBR7_Pos (9UL) /*!< field RSVD_SRBR7 (bitOffset 9, bitWidth 23) */
#define UART_SRBR7_RSVD_SRBR7_Msk (0xfffffe00UL) /*!< field RSVD_SRBR7 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR7 ===================================================== */
#define UART_STHR7_STHR7_Pos (0UL) /*!< field STHR7 (bitOffset 0, bitWidth 9) */
#define UART_STHR7_STHR7_Msk (0x000001ffUL) /*!< field STHR7 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR7_RSVD_STHR7_Pos (9UL) /*!< field RSVD_STHR7 (bitOffset 9, bitWidth 23) */
#define UART_STHR7_RSVD_STHR7_Msk (0xfffffe00UL) /*!< field RSVD_STHR7 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR8 ===================================================== */
#define UART_SRBR8_SRBR8_Pos (0UL) /*!< field SRBR8 (bitOffset 0, bitWidth 9) */
#define UART_SRBR8_SRBR8_Msk (0x000001ffUL) /*!< field SRBR8 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR8_RSVD_SRBR8_Pos (9UL) /*!< field RSVD_SRBR8 (bitOffset 9, bitWidth 23) */
#define UART_SRBR8_RSVD_SRBR8_Msk (0xfffffe00UL) /*!< field RSVD_SRBR8 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR8 ===================================================== */
#define UART_STHR8_STHR8_Pos (0UL) /*!< field STHR8 (bitOffset 0, bitWidth 9) */
#define UART_STHR8_STHR8_Msk (0x000001ffUL) /*!< field STHR8 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR8_RSVD_STHR8_Pos (9UL) /*!< field RSVD_STHR8 (bitOffset 9, bitWidth 23) */
#define UART_STHR8_RSVD_STHR8_Msk (0xfffffe00UL) /*!< field RSVD_STHR8 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register SRBR9 ===================================================== */
#define UART_SRBR9_SRBR9_Pos (0UL) /*!< field SRBR9 (bitOffset 0, bitWidth 9) */
#define UART_SRBR9_SRBR9_Msk (0x000001ffUL) /*!< field SRBR9 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR9_RSVD_SRBR9_Pos (9UL) /*!< field RSVD_SRBR9 (bitOffset 9, bitWidth 23) */
#define UART_SRBR9_RSVD_SRBR9_Msk (0xfffffe00UL) /*!< field RSVD_SRBR9 (Bitfield-Mask: 0x007fffff) */

/* ====================================================== Register STHR9 ===================================================== */
#define UART_STHR9_STHR9_Pos (0UL) /*!< field STHR9 (bitOffset 0, bitWidth 9) */
#define UART_STHR9_STHR9_Msk (0x000001ffUL) /*!< field STHR9 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR9_RSVD_STHR9_Pos (9UL) /*!< field RSVD_STHR9 (bitOffset 9, bitWidth 23) */
#define UART_STHR9_RSVD_STHR9_Msk (0xfffffe00UL) /*!< field RSVD_STHR9 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR10 ===================================================== */
#define UART_SRBR10_SRBR10_Pos (0UL) /*!< field SRBR10 (bitOffset 0, bitWidth 9) */
#define UART_SRBR10_SRBR10_Msk (0x000001ffUL) /*!< field SRBR10 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR10_RSVD_SRBR10_Pos (9UL) /*!< field RSVD_SRBR10 (bitOffset 9, bitWidth 23) */
#define UART_SRBR10_RSVD_SRBR10_Msk (0xfffffe00UL) /*!< field RSVD_SRBR10 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR10 ===================================================== */
#define UART_STHR10_STHR10_Pos (0UL) /*!< field STHR10 (bitOffset 0, bitWidth 9) */
#define UART_STHR10_STHR10_Msk (0x000001ffUL) /*!< field STHR10 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR10_RSVD_STHR10_Pos (9UL) /*!< field RSVD_STHR10 (bitOffset 9, bitWidth 23) */
#define UART_STHR10_RSVD_STHR10_Msk (0xfffffe00UL) /*!< field RSVD_STHR10 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR11 ===================================================== */
#define UART_SRBR11_SRBR11_Pos (0UL) /*!< field SRBR11 (bitOffset 0, bitWidth 9) */
#define UART_SRBR11_SRBR11_Msk (0x000001ffUL) /*!< field SRBR11 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR11_RSVD_SRBR11_Pos (9UL) /*!< field RSVD_SRBR11 (bitOffset 9, bitWidth 23) */
#define UART_SRBR11_RSVD_SRBR11_Msk (0xfffffe00UL) /*!< field RSVD_SRBR11 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR11 ===================================================== */
#define UART_STHR11_STHR11_Pos (0UL) /*!< field STHR11 (bitOffset 0, bitWidth 9) */
#define UART_STHR11_STHR11_Msk (0x000001ffUL) /*!< field STHR11 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR11_RSVD_STHR11_Pos (9UL) /*!< field RSVD_STHR11 (bitOffset 9, bitWidth 23) */
#define UART_STHR11_RSVD_STHR11_Msk (0xfffffe00UL) /*!< field RSVD_STHR11 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR12 ===================================================== */
#define UART_SRBR12_SRBR12_Pos (0UL) /*!< field SRBR12 (bitOffset 0, bitWidth 9) */
#define UART_SRBR12_SRBR12_Msk (0x000001ffUL) /*!< field SRBR12 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR12_RSVD_SRBR12_Pos (9UL) /*!< field RSVD_SRBR12 (bitOffset 9, bitWidth 23) */
#define UART_SRBR12_RSVD_SRBR12_Msk (0xfffffe00UL) /*!< field RSVD_SRBR12 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR12 ===================================================== */
#define UART_STHR12_STHR12_Pos (0UL) /*!< field STHR12 (bitOffset 0, bitWidth 9) */
#define UART_STHR12_STHR12_Msk (0x000001ffUL) /*!< field STHR12 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR12_RSVD_STHR12_Pos (9UL) /*!< field RSVD_STHR12 (bitOffset 9, bitWidth 23) */
#define UART_STHR12_RSVD_STHR12_Msk (0xfffffe00UL) /*!< field RSVD_STHR12 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR13 ===================================================== */
#define UART_SRBR13_SRBR13_Pos (0UL) /*!< field SRBR13 (bitOffset 0, bitWidth 9) */
#define UART_SRBR13_SRBR13_Msk (0x000001ffUL) /*!< field SRBR13 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR13_RSVD_SRBR13_Pos (9UL) /*!< field RSVD_SRBR13 (bitOffset 9, bitWidth 23) */
#define UART_SRBR13_RSVD_SRBR13_Msk (0xfffffe00UL) /*!< field RSVD_SRBR13 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR13 ===================================================== */
#define UART_STHR13_STHR13_Pos (0UL) /*!< field STHR13 (bitOffset 0, bitWidth 9) */
#define UART_STHR13_STHR13_Msk (0x000001ffUL) /*!< field STHR13 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR13_RSVD_STHR13_Pos (9UL) /*!< field RSVD_STHR13 (bitOffset 9, bitWidth 23) */
#define UART_STHR13_RSVD_STHR13_Msk (0xfffffe00UL) /*!< field RSVD_STHR13 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR14 ===================================================== */
#define UART_SRBR14_SRBR14_Pos (0UL) /*!< field SRBR14 (bitOffset 0, bitWidth 9) */
#define UART_SRBR14_SRBR14_Msk (0x000001ffUL) /*!< field SRBR14 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR14_RSVD_SRBR14_Pos (9UL) /*!< field RSVD_SRBR14 (bitOffset 9, bitWidth 23) */
#define UART_SRBR14_RSVD_SRBR14_Msk (0xfffffe00UL) /*!< field RSVD_SRBR14 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR14 ===================================================== */
#define UART_STHR14_STHR14_Pos (0UL) /*!< field STHR14 (bitOffset 0, bitWidth 9) */
#define UART_STHR14_STHR14_Msk (0x000001ffUL) /*!< field STHR14 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR14_RSVD_STHR14_Pos (9UL) /*!< field RSVD_STHR14 (bitOffset 9, bitWidth 23) */
#define UART_STHR14_RSVD_STHR14_Msk (0xfffffe00UL) /*!< field RSVD_STHR14 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register SRBR15 ===================================================== */
#define UART_SRBR15_SRBR15_Pos (0UL) /*!< field SRBR15 (bitOffset 0, bitWidth 9) */
#define UART_SRBR15_SRBR15_Msk (0x000001ffUL) /*!< field SRBR15 (Bitfield-Mask: 0x000001ff) */
#define UART_SRBR15_RSVD_SRBR15_Pos (9UL) /*!< field RSVD_SRBR15 (bitOffset 9, bitWidth 23) */
#define UART_SRBR15_RSVD_SRBR15_Msk (0xfffffe00UL) /*!< field RSVD_SRBR15 (Bitfield-Mask: 0x007fffff) */

/* ===================================================== Register STHR15 ===================================================== */
#define UART_STHR15_STHR15_Pos (0UL) /*!< field STHR15 (bitOffset 0, bitWidth 9) */
#define UART_STHR15_STHR15_Msk (0x000001ffUL) /*!< field STHR15 (Bitfield-Mask: 0x000001ff) */
#define UART_STHR15_RSVD_STHR15_Pos (9UL) /*!< field RSVD_STHR15 (bitOffset 9, bitWidth 23) */
#define UART_STHR15_RSVD_STHR15_Msk (0xfffffe00UL) /*!< field RSVD_STHR15 (Bitfield-Mask: 0x007fffff) */

/* ======================================================= Register FAR ====================================================== */
#define UART_FAR_FAR_Pos (0UL) /*!< field FAR (bitOffset 0, bitWidth 1) */
#define UART_FAR_FAR_Msk (0x00000001UL) /*!< field FAR (Bitfield-Mask: 0x00000001) */
#define UART_FAR_RSVD_FAR_31TO1_Pos (1UL) /*!< field RSVD_FAR_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_FAR_RSVD_FAR_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_FAR_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register USR ====================================================== */
#define UART_USR_BUSY_Pos (0UL) /*!< field BUSY (bitOffset 0, bitWidth 1) */
#define UART_USR_BUSY_Msk (0x00000001UL) /*!< field BUSY (Bitfield-Mask: 0x00000001) */
#define UART_USR_TFNF_Pos (1UL) /*!< field TFNF (bitOffset 1, bitWidth 1) */
#define UART_USR_TFNF_Msk (0x00000002UL) /*!< field TFNF (Bitfield-Mask: 0x00000001) */
#define UART_USR_TFE_Pos (2UL) /*!< field TFE (bitOffset 2, bitWidth 1) */
#define UART_USR_TFE_Msk (0x00000004UL) /*!< field TFE (Bitfield-Mask: 0x00000001) */
#define UART_USR_RFNE_Pos (3UL) /*!< field RFNE (bitOffset 3, bitWidth 1) */
#define UART_USR_RFNE_Msk (0x00000008UL) /*!< field RFNE (Bitfield-Mask: 0x00000001) */
#define UART_USR_RFF_Pos (4UL) /*!< field RFF (bitOffset 4, bitWidth 1) */
#define UART_USR_RFF_Msk (0x00000010UL) /*!< field RFF (Bitfield-Mask: 0x00000001) */
#define UART_USR_RSVD_USR_31TO5_Pos (5UL) /*!< field RSVD_USR_31TO5 (bitOffset 5, bitWidth 27) */
#define UART_USR_RSVD_USR_31TO5_Msk (0xffffffe0UL) /*!< field RSVD_USR_31TO5 (Bitfield-Mask: 0x07ffffff) */

/* ======================================================= Register TFL ====================================================== */
#define UART_TFL_TFL_Pos (0UL) /*!< field TFL (bitOffset 0, bitWidth 5) */
#define UART_TFL_TFL_Msk (0x0000001fUL) /*!< field TFL (Bitfield-Mask: 0x0000001f) */
#define UART_TFL_RSVD_TFL_31TOADDR_WIDTH_Pos (5UL) /*!< field RSVD_TFL_31TOADDR_WIDTH (bitOffset 5, bitWidth 27) */
#define UART_TFL_RSVD_TFL_31TOADDR_WIDTH_Msk (0xffffffe0UL) /*!< field RSVD_TFL_31TOADDR_WIDTH (Bitfield-Mask: 0x07ffffff) */

/* ======================================================= Register RFL ====================================================== */
#define UART_RFL_RFL_Pos (0UL) /*!< field RFL (bitOffset 0, bitWidth 5) */
#define UART_RFL_RFL_Msk (0x0000001fUL) /*!< field RFL (Bitfield-Mask: 0x0000001f) */
#define UART_RFL_RSVD_RFL_31TOADDR_WIDTH_Pos (5UL) /*!< field RSVD_RFL_31TOADDR_WIDTH (bitOffset 5, bitWidth 27) */
#define UART_RFL_RSVD_RFL_31TOADDR_WIDTH_Msk (0xffffffe0UL) /*!< field RSVD_RFL_31TOADDR_WIDTH (Bitfield-Mask: 0x07ffffff) */

/* ======================================================= Register SRR ====================================================== */
#define UART_SRR_UR_Pos (0UL) /*!< field UR (bitOffset 0, bitWidth 1) */
#define UART_SRR_UR_Msk (0x00000001UL) /*!< field UR (Bitfield-Mask: 0x00000001) */
#define UART_SRR_RFR_Pos (1UL) /*!< field RFR (bitOffset 1, bitWidth 1) */
#define UART_SRR_RFR_Msk (0x00000002UL) /*!< field RFR (Bitfield-Mask: 0x00000001) */
#define UART_SRR_XFR_Pos (2UL) /*!< field XFR (bitOffset 2, bitWidth 1) */
#define UART_SRR_XFR_Msk (0x00000004UL) /*!< field XFR (Bitfield-Mask: 0x00000001) */
#define UART_SRR_RSVD_SRR_31TO3_Pos (3UL) /*!< field RSVD_SRR_31TO3 (bitOffset 3, bitWidth 29) */
#define UART_SRR_RSVD_SRR_31TO3_Msk (0xfffffff8UL) /*!< field RSVD_SRR_31TO3 (Bitfield-Mask: 0x1fffffff) */

/* ====================================================== Register SRTS ====================================================== */
#define UART_SRTS_SRTS_Pos (0UL) /*!< field SRTS (bitOffset 0, bitWidth 1) */
#define UART_SRTS_SRTS_Msk (0x00000001UL) /*!< field SRTS (Bitfield-Mask: 0x00000001) */
#define UART_SRTS_RSVD_SRTS_31TO1_Pos (1UL) /*!< field RSVD_SRTS_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_SRTS_RSVD_SRTS_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_SRTS_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register SBCR ====================================================== */
#define UART_SBCR_SBCB_Pos (0UL) /*!< field SBCB (bitOffset 0, bitWidth 1) */
#define UART_SBCR_SBCB_Msk (0x00000001UL) /*!< field SBCB (Bitfield-Mask: 0x00000001) */
#define UART_SBCR_RSVD_SBCR_31TO1_Pos (1UL) /*!< field RSVD_SBCR_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_SBCR_RSVD_SBCR_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_SBCR_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register SDMAM ===================================================== */
#define UART_SDMAM_SDMAM_Pos (0UL) /*!< field SDMAM (bitOffset 0, bitWidth 1) */
#define UART_SDMAM_SDMAM_Msk (0x00000001UL) /*!< field SDMAM (Bitfield-Mask: 0x00000001) */
#define UART_SDMAM_RSVD_SDMAM_31TO1_Pos (1UL) /*!< field RSVD_SDMAM_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_SDMAM_RSVD_SDMAM_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_SDMAM_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register SFE ====================================================== */
#define UART_SFE_SFE_Pos (0UL) /*!< field SFE (bitOffset 0, bitWidth 1) */
#define UART_SFE_SFE_Msk (0x00000001UL) /*!< field SFE (Bitfield-Mask: 0x00000001) */
#define UART_SFE_RSVD_SFE_31TO1_Pos (1UL) /*!< field RSVD_SFE_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_SFE_RSVD_SFE_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_SFE_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register SRT ====================================================== */
#define UART_SRT_SRT_Pos (0UL) /*!< field SRT (bitOffset 0, bitWidth 2) */
#define UART_SRT_SRT_Msk (0x00000003UL) /*!< field SRT (Bitfield-Mask: 0x00000003) */
#define UART_SRT_RSVD_SRT_31TO2_Pos (2UL) /*!< field RSVD_SRT_31TO2 (bitOffset 2, bitWidth 30) */
#define UART_SRT_RSVD_SRT_31TO2_Msk (0xfffffffcUL) /*!< field RSVD_SRT_31TO2 (Bitfield-Mask: 0x3fffffff) */

/* ====================================================== Register STET ====================================================== */
#define UART_STET_STET_Pos (0UL) /*!< field STET (bitOffset 0, bitWidth 2) */
#define UART_STET_STET_Msk (0x00000003UL) /*!< field STET (Bitfield-Mask: 0x00000003) */
#define UART_STET_RSVD_STET_31TO2_Pos (2UL) /*!< field RSVD_STET_31TO2 (bitOffset 2, bitWidth 30) */
#define UART_STET_RSVD_STET_31TO2_Msk (0xfffffffcUL) /*!< field RSVD_STET_31TO2 (Bitfield-Mask: 0x3fffffff) */

/* ======================================================= Register HTX ====================================================== */
#define UART_HTX_HTX_Pos (0UL) /*!< field HTX (bitOffset 0, bitWidth 1) */
#define UART_HTX_HTX_Msk (0x00000001UL) /*!< field HTX (Bitfield-Mask: 0x00000001) */
#define UART_HTX_RSVD_HTX_31TO1_Pos (1UL) /*!< field RSVD_HTX_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_HTX_RSVD_HTX_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_HTX_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register DMASA ===================================================== */
#define UART_DMASA_DMASA_Pos (0UL) /*!< field DMASA (bitOffset 0, bitWidth 1) */
#define UART_DMASA_DMASA_Msk (0x00000001UL) /*!< field DMASA (Bitfield-Mask: 0x00000001) */
#define UART_DMASA_RSVD_DMASA_31TO1_Pos (1UL) /*!< field RSVD_DMASA_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_DMASA_RSVD_DMASA_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_DMASA_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register TCR ====================================================== */
#define UART_TCR_RS485_EN_Pos (0UL) /*!< field RS485_EN (bitOffset 0, bitWidth 1) */
#define UART_TCR_RS485_EN_Msk (0x00000001UL) /*!< field RS485_EN (Bitfield-Mask: 0x00000001) */
#define UART_TCR_RE_POL_Pos (1UL) /*!< field RE_POL (bitOffset 1, bitWidth 1) */
#define UART_TCR_RE_POL_Msk (0x00000002UL) /*!< field RE_POL (Bitfield-Mask: 0x00000001) */
#define UART_TCR_DE_POL_Pos (2UL) /*!< field DE_POL (bitOffset 2, bitWidth 1) */
#define UART_TCR_DE_POL_Msk (0x00000004UL) /*!< field DE_POL (Bitfield-Mask: 0x00000001) */
#define UART_TCR_XFER_MODE_Pos (3UL) /*!< field XFER_MODE (bitOffset 3, bitWidth 2) */
#define UART_TCR_XFER_MODE_Msk (0x00000018UL) /*!< field XFER_MODE (Bitfield-Mask: 0x00000003) */
#define UART_TCR_RSVD_TCR_31TO5_Pos (5UL) /*!< field RSVD_TCR_31TO5 (bitOffset 5, bitWidth 27) */
#define UART_TCR_RSVD_TCR_31TO5_Msk (0xffffffe0UL) /*!< field RSVD_TCR_31TO5 (Bitfield-Mask: 0x07ffffff) */

/* ====================================================== Register DE_EN ===================================================== */
#define UART_DE_EN_DE_ENABLE_Pos (0UL) /*!< field DE_ENABLE (bitOffset 0, bitWidth 1) */
#define UART_DE_EN_DE_ENABLE_Msk (0x00000001UL) /*!< field DE_ENABLE (Bitfield-Mask: 0x00000001) */
#define UART_DE_EN_RSVD_DE_EN_31TO1_Pos (1UL) /*!< field RSVD_DE_EN_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_DE_EN_RSVD_DE_EN_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_DE_EN_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register RE_EN ===================================================== */
#define UART_RE_EN_RE_ENABLE_Pos (0UL) /*!< field RE_ENABLE (bitOffset 0, bitWidth 1) */
#define UART_RE_EN_RE_ENABLE_Msk (0x00000001UL) /*!< field RE_ENABLE (Bitfield-Mask: 0x00000001) */
#define UART_RE_EN_RSVD_RE_EN_31TO1_Pos (1UL) /*!< field RSVD_RE_EN_31TO1 (bitOffset 1, bitWidth 31) */
#define UART_RE_EN_RSVD_RE_EN_31TO1_Msk (0xfffffffeUL) /*!< field RSVD_RE_EN_31TO1 (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register DET ====================================================== */
#define UART_DET_DE_ASSERTION_TIME_Pos (0UL) /*!< field DE_ASSERTION_TIME (bitOffset 0, bitWidth 8) */
#define UART_DET_DE_ASSERTION_TIME_Msk (0x000000ffUL) /*!< field DE_ASSERTION_TIME (Bitfield-Mask: 0x000000ff) */
#define UART_DET_RSVD_DE_AT_15TO8_Pos (8UL) /*!< field RSVD_DE_AT_15TO8 (bitOffset 8, bitWidth 8) */
#define UART_DET_RSVD_DE_AT_15TO8_Msk (0x0000ff00UL) /*!< field RSVD_DE_AT_15TO8 (Bitfield-Mask: 0x000000ff) */
#define UART_DET_DE_DE_ASSERTION_TIME_Pos (16UL) /*!< field DE_DE_ASSERTION_TIME (bitOffset 16, bitWidth 8) */
#define UART_DET_DE_DE_ASSERTION_TIME_Msk (0x00ff0000UL) /*!< field DE_DE_ASSERTION_TIME (Bitfield-Mask: 0x000000ff) */
#define UART_DET_RSVD_DE_DEAT_31TO24_Pos (24UL) /*!< field RSVD_DE_DEAT_31TO24 (bitOffset 24, bitWidth 8) */
#define UART_DET_RSVD_DE_DEAT_31TO24_Msk (0xff000000UL) /*!< field RSVD_DE_DEAT_31TO24 (Bitfield-Mask: 0x000000ff) */

/* ======================================================= Register TAT ====================================================== */
#define UART_TAT_DE_TO_RE_Pos (0UL) /*!< field DE_TO_RE (bitOffset 0, bitWidth 16) */
#define UART_TAT_DE_TO_RE_Msk (0x0000ffffUL) /*!< field DE_TO_RE (Bitfield-Mask: 0x0000ffff) */
#define UART_TAT_RE_TO_DE_Pos (16UL) /*!< field RE_TO_DE (bitOffset 16, bitWidth 16) */
#define UART_TAT_RE_TO_DE_Msk (0xffff0000UL) /*!< field RE_TO_DE (Bitfield-Mask: 0x0000ffff) */

/* ======================================================= Register DLF ====================================================== */
#define UART_DLF_DLF_Pos (0UL) /*!< field DLF (bitOffset 0, bitWidth 4) */
#define UART_DLF_DLF_Msk (0x0000000fUL) /*!< field DLF (Bitfield-Mask: 0x0000000f) */
#define UART_DLF_RSVD_DLF_Pos (4UL) /*!< field RSVD_DLF (bitOffset 4, bitWidth 28) */
#define UART_DLF_RSVD_DLF_Msk (0xfffffff0UL) /*!< field RSVD_DLF (Bitfield-Mask: 0x0fffffff) */

/* ======================================================= Register RAR ====================================================== */
#define UART_RAR_RAR_Pos (0UL) /*!< field RAR (bitOffset 0, bitWidth 8) */
#define UART_RAR_RAR_Msk (0x000000ffUL) /*!< field RAR (Bitfield-Mask: 0x000000ff) */
#define UART_RAR_RSVD_RAR_31TO8_Pos (8UL) /*!< field RSVD_RAR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_RAR_RSVD_RAR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_RAR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ======================================================= Register TAR ====================================================== */
#define UART_TAR_TAR_Pos (0UL) /*!< field TAR (bitOffset 0, bitWidth 8) */
#define UART_TAR_TAR_Msk (0x000000ffUL) /*!< field TAR (Bitfield-Mask: 0x000000ff) */
#define UART_TAR_RSVD_TAR_31TO8_Pos (8UL) /*!< field RSVD_TAR_31TO8 (bitOffset 8, bitWidth 24) */
#define UART_TAR_RSVD_TAR_31TO8_Msk (0xffffff00UL) /*!< field RSVD_TAR_31TO8 (Bitfield-Mask: 0x00ffffff) */

/* ===================================================== Register LCR_EXT ==================================================== */
#define UART_LCR_EXT_DLS_E_Pos (0UL) /*!< field DLS_E (bitOffset 0, bitWidth 1) */
#define UART_LCR_EXT_DLS_E_Msk (0x00000001UL) /*!< field DLS_E (Bitfield-Mask: 0x00000001) */
#define UART_LCR_EXT_ADDR_MATCH_Pos (1UL) /*!< field ADDR_MATCH (bitOffset 1, bitWidth 1) */
#define UART_LCR_EXT_ADDR_MATCH_Msk (0x00000002UL) /*!< field ADDR_MATCH (Bitfield-Mask: 0x00000001) */
#define UART_LCR_EXT_SEND_ADDR_Pos (2UL) /*!< field SEND_ADDR (bitOffset 2, bitWidth 1) */
#define UART_LCR_EXT_SEND_ADDR_Msk (0x00000004UL) /*!< field SEND_ADDR (Bitfield-Mask: 0x00000001) */
#define UART_LCR_EXT_TRANSMIT_MODE_Pos (3UL) /*!< field TRANSMIT_MODE (bitOffset 3, bitWidth 1) */
#define UART_LCR_EXT_TRANSMIT_MODE_Msk (0x00000008UL) /*!< field TRANSMIT_MODE (Bitfield-Mask: 0x00000001) */
#define UART_LCR_EXT_RSVD_LCR_EXT_Pos (4UL) /*!< field RSVD_LCR_EXT (bitOffset 4, bitWidth 28) */
#define UART_LCR_EXT_RSVD_LCR_EXT_Msk (0xfffffff0UL) /*!< field RSVD_LCR_EXT (Bitfield-Mask: 0x0fffffff) */

/* ======================================================= Register CPR ====================================================== */
#define UART_CPR_APB_DATA_WIDTH_Pos (0UL) /*!< field APB_DATA_WIDTH (bitOffset 0, bitWidth 2) */
#define UART_CPR_APB_DATA_WIDTH_Msk (0x00000003UL) /*!< field APB_DATA_WIDTH (Bitfield-Mask: 0x00000003) */
#define UART_CPR_RSVD_CPR_3TO2_Pos (2UL) /*!< field RSVD_CPR_3TO2 (bitOffset 2, bitWidth 2) */
#define UART_CPR_RSVD_CPR_3TO2_Msk (0x0000000cUL) /*!< field RSVD_CPR_3TO2 (Bitfield-Mask: 0x00000003) */
#define UART_CPR_AFCE_MODE_Pos (4UL) /*!< field AFCE_MODE (bitOffset 4, bitWidth 1) */
#define UART_CPR_AFCE_MODE_Msk (0x00000010UL) /*!< field AFCE_MODE (Bitfield-Mask: 0x00000001) */
#define UART_CPR_THRE_MODE_Pos (5UL) /*!< field THRE_MODE (bitOffset 5, bitWidth 1) */
#define UART_CPR_THRE_MODE_Msk (0x00000020UL) /*!< field THRE_MODE (Bitfield-Mask: 0x00000001) */
#define UART_CPR_SIR_MODE_Pos (6UL) /*!< field SIR_MODE (bitOffset 6, bitWidth 1) */
#define UART_CPR_SIR_MODE_Msk (0x00000040UL) /*!< field SIR_MODE (Bitfield-Mask: 0x00000001) */
#define UART_CPR_SIR_LP_MODE_Pos (7UL) /*!< field SIR_LP_MODE (bitOffset 7, bitWidth 1) */
#define UART_CPR_SIR_LP_MODE_Msk (0x00000080UL) /*!< field SIR_LP_MODE (Bitfield-Mask: 0x00000001) */
#define UART_CPR_ADDITIONAL_FEAT_Pos (8UL) /*!< field ADDITIONAL_FEAT (bitOffset 8, bitWidth 1) */
#define UART_CPR_ADDITIONAL_FEAT_Msk (0x00000100UL) /*!< field ADDITIONAL_FEAT (Bitfield-Mask: 0x00000001) */
#define UART_CPR_FIFO_ACCESS_Pos (9UL) /*!< field FIFO_ACCESS (bitOffset 9, bitWidth 1) */
#define UART_CPR_FIFO_ACCESS_Msk (0x00000200UL) /*!< field FIFO_ACCESS (Bitfield-Mask: 0x00000001) */
#define UART_CPR_FIFO_STAT_Pos (10UL) /*!< field FIFO_STAT (bitOffset 10, bitWidth 1) */
#define UART_CPR_FIFO_STAT_Msk (0x00000400UL) /*!< field FIFO_STAT (Bitfield-Mask: 0x00000001) */
#define UART_CPR_SHADOW_Pos (11UL) /*!< field SHADOW (bitOffset 11, bitWidth 1) */
#define UART_CPR_SHADOW_Msk (0x00000800UL) /*!< field SHADOW (Bitfield-Mask: 0x00000001) */
#define UART_CPR_UART_ADD_ENCODED_PARAMS_Pos (12UL) /*!< field UART_ADD_ENCODED_PARAMS (bitOffset 12, bitWidth 1) */
#define UART_CPR_UART_ADD_ENCODED_PARAMS_Msk (0x00001000UL) /*!< field UART_ADD_ENCODED_PARAMS (Bitfield-Mask: 0x00000001) */
#define UART_CPR_DMA_EXTRA_Pos (13UL) /*!< field DMA_EXTRA (bitOffset 13, bitWidth 1) */
#define UART_CPR_DMA_EXTRA_Msk (0x00002000UL) /*!< field DMA_EXTRA (Bitfield-Mask: 0x00000001) */
#define UART_CPR_RSVD_CPR_15TO14_Pos (14UL) /*!< field RSVD_CPR_15TO14 (bitOffset 14, bitWidth 2) */
#define UART_CPR_RSVD_CPR_15TO14_Msk (0x0000c000UL) /*!< field RSVD_CPR_15TO14 (Bitfield-Mask: 0x00000003) */
#define UART_CPR_FIFO_MODE_Pos (16UL) /*!< field FIFO_MODE (bitOffset 16, bitWidth 8) */
#define UART_CPR_FIFO_MODE_Msk (0x00ff0000UL) /*!< field FIFO_MODE (Bitfield-Mask: 0x000000ff) */
#define UART_CPR_RSVD_CPR_31TO24_Pos (24UL) /*!< field RSVD_CPR_31TO24 (bitOffset 24, bitWidth 8) */
#define UART_CPR_RSVD_CPR_31TO24_Msk (0xff000000UL) /*!< field RSVD_CPR_31TO24 (Bitfield-Mask: 0x000000ff) */

/* ======================================================= Register UCV ====================================================== */
#define UART_UCV_UART_COMPONENT_VERSION_Pos (0UL) /*!< field UART_COMPONENT_VERSION (bitOffset 0, bitWidth 32) */
#define UART_UCV_UART_COMPONENT_VERSION_Msk (0xffffffffUL) /*!< field UART_COMPONENT_VERSION (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register CTR ====================================================== */
#define UART_CTR_PERIPHERAL_ID_Pos (0UL) /*!< field PERIPHERAL_ID (bitOffset 0, bitWidth 32) */
#define UART_CTR_PERIPHERAL_ID_Msk (0xffffffffUL) /*!< field PERIPHERAL_ID (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: SPI ================================================= */
/* =========================================================================================================================== */

/* ===================================================== Register CTRLR0 ===================================================== */
#define SPI_CTRLR0_DFS_Pos (0UL) /*!< field DFS (bitOffset 0, bitWidth 4) */
#define SPI_CTRLR0_DFS_Msk (0x0000000fUL) /*!< field DFS (Bitfield-Mask: 0x0000000f) */
#define SPI_CTRLR0_FRF_Pos (4UL) /*!< field FRF (bitOffset 4, bitWidth 2) */
#define SPI_CTRLR0_FRF_Msk (0x00000030UL) /*!< field FRF (Bitfield-Mask: 0x00000003) */
#define SPI_CTRLR0_SCPH_Pos (6UL) /*!< field SCPH (bitOffset 6, bitWidth 1) */
#define SPI_CTRLR0_SCPH_Msk (0x00000040UL) /*!< field SCPH (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_SCPOL_Pos (7UL) /*!< field SCPOL (bitOffset 7, bitWidth 1) */
#define SPI_CTRLR0_SCPOL_Msk (0x00000080UL) /*!< field SCPOL (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_TMOD_Pos (8UL) /*!< field TMOD (bitOffset 8, bitWidth 2) */
#define SPI_CTRLR0_TMOD_Msk (0x00000300UL) /*!< field TMOD (Bitfield-Mask: 0x00000003) */
#define SPI_CTRLR0_RSVD_SLV_OE_Pos (10UL) /*!< field RSVD_SLV_OE (bitOffset 10, bitWidth 1) */
#define SPI_CTRLR0_RSVD_SLV_OE_Msk (0x00000400UL) /*!< field RSVD_SLV_OE (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_SRL_Pos (11UL) /*!< field SRL (bitOffset 11, bitWidth 1) */
#define SPI_CTRLR0_SRL_Msk (0x00000800UL) /*!< field SRL (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_CFS_Pos (12UL) /*!< field CFS (bitOffset 12, bitWidth 4) */
#define SPI_CTRLR0_CFS_Msk (0x0000f000UL) /*!< field CFS (Bitfield-Mask: 0x0000000f) */
#define SPI_CTRLR0_DFS_32_Pos (16UL) /*!< field DFS_32 (bitOffset 16, bitWidth 5) */
#define SPI_CTRLR0_DFS_32_Msk (0x001f0000UL) /*!< field DFS_32 (Bitfield-Mask: 0x0000001f) */
#define SPI_CTRLR0_SPI_FRF_Pos (21UL) /*!< field SPI_FRF (bitOffset 21, bitWidth 2) */
#define SPI_CTRLR0_SPI_FRF_Msk (0x00600000UL) /*!< field SPI_FRF (Bitfield-Mask: 0x00000003) */
#define SPI_CTRLR0_RSVD_CTRLR0_23_Pos (23UL) /*!< field RSVD_CTRLR0_23 (bitOffset 23, bitWidth 1) */
#define SPI_CTRLR0_RSVD_CTRLR0_23_Msk (0x00800000UL) /*!< field RSVD_CTRLR0_23 (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_SSTE_Pos (24UL) /*!< field SSTE (bitOffset 24, bitWidth 1) */
#define SPI_CTRLR0_SSTE_Msk (0x01000000UL) /*!< field SSTE (Bitfield-Mask: 0x00000001) */
#define SPI_CTRLR0_RSVD_CTRLR0_Pos (25UL) /*!< field RSVD_CTRLR0 (bitOffset 25, bitWidth 7) */
#define SPI_CTRLR0_RSVD_CTRLR0_Msk (0xfe000000UL) /*!< field RSVD_CTRLR0 (Bitfield-Mask: 0x0000007f) */

/* ===================================================== Register CTRLR1 ===================================================== */
#define SPI_CTRLR1_NDF_Pos (0UL) /*!< field NDF (bitOffset 0, bitWidth 16) */
#define SPI_CTRLR1_NDF_Msk (0x0000ffffUL) /*!< field NDF (Bitfield-Mask: 0x0000ffff) */
#define SPI_CTRLR1_RSVD_CTRLR1_Pos (16UL) /*!< field RSVD_CTRLR1 (bitOffset 16, bitWidth 16) */
#define SPI_CTRLR1_RSVD_CTRLR1_Msk (0xffff0000UL) /*!< field RSVD_CTRLR1 (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register SSIENR ===================================================== */
#define SPI_SSIENR_SSI_EN_Pos (0UL) /*!< field SSI_EN (bitOffset 0, bitWidth 1) */
#define SPI_SSIENR_SSI_EN_Msk (0x00000001UL) /*!< field SSI_EN (Bitfield-Mask: 0x00000001) */
#define SPI_SSIENR_RSVD_SSIENR_Pos (1UL) /*!< field RSVD_SSIENR (bitOffset 1, bitWidth 31) */
#define SPI_SSIENR_RSVD_SSIENR_Msk (0xfffffffeUL) /*!< field RSVD_SSIENR (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register MWCR ====================================================== */
#define SPI_MWCR_MWMOD_Pos (0UL) /*!< field MWMOD (bitOffset 0, bitWidth 1) */
#define SPI_MWCR_MWMOD_Msk (0x00000001UL) /*!< field MWMOD (Bitfield-Mask: 0x00000001) */
#define SPI_MWCR_MDD_Pos (1UL) /*!< field MDD (bitOffset 1, bitWidth 1) */
#define SPI_MWCR_MDD_Msk (0x00000002UL) /*!< field MDD (Bitfield-Mask: 0x00000001) */
#define SPI_MWCR_MHS_Pos (2UL) /*!< field MHS (bitOffset 2, bitWidth 1) */
#define SPI_MWCR_MHS_Msk (0x00000004UL) /*!< field MHS (Bitfield-Mask: 0x00000001) */
#define SPI_MWCR_RSVD_MWCR_Pos (3UL) /*!< field RSVD_MWCR (bitOffset 3, bitWidth 29) */
#define SPI_MWCR_RSVD_MWCR_Msk (0xfffffff8UL) /*!< field RSVD_MWCR (Bitfield-Mask: 0x1fffffff) */

/* ======================================================= Register SER ====================================================== */
#define SPI_SER_SER_Pos (0UL) /*!< field SER (bitOffset 0, bitWidth 1) */
#define SPI_SER_SER_Msk (0x00000001UL) /*!< field SER (Bitfield-Mask: 0x00000001) */
#define SPI_SER_RSVD_SER_Pos (1UL) /*!< field RSVD_SER (bitOffset 1, bitWidth 31) */
#define SPI_SER_RSVD_SER_Msk (0xfffffffeUL) /*!< field RSVD_SER (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register BAUDR ===================================================== */
#define SPI_BAUDR_SCKDV_Pos (0UL) /*!< field SCKDV (bitOffset 0, bitWidth 16) */
#define SPI_BAUDR_SCKDV_Msk (0x0000ffffUL) /*!< field SCKDV (Bitfield-Mask: 0x0000ffff) */
#define SPI_BAUDR_RSVD_BAUDR_Pos (16UL) /*!< field RSVD_BAUDR (bitOffset 16, bitWidth 16) */
#define SPI_BAUDR_RSVD_BAUDR_Msk (0xffff0000UL) /*!< field RSVD_BAUDR (Bitfield-Mask: 0x0000ffff) */

/* ===================================================== Register TXFTLR ===================================================== */
#define SPI_TXFTLR_TFT_Pos (0UL) /*!< field TFT (bitOffset 0, bitWidth 3) */
#define SPI_TXFTLR_TFT_Msk (0x00000007UL) /*!< field TFT (Bitfield-Mask: 0x00000007) */
#define SPI_TXFTLR_RSVD_TXFTLR_Pos (3UL) /*!< field RSVD_TXFTLR (bitOffset 3, bitWidth 29) */
#define SPI_TXFTLR_RSVD_TXFTLR_Msk (0xfffffff8UL) /*!< field RSVD_TXFTLR (Bitfield-Mask: 0x1fffffff) */

/* ===================================================== Register RXFTLR ===================================================== */
#define SPI_RXFTLR_RFT_Pos (0UL) /*!< field RFT (bitOffset 0, bitWidth 3) */
#define SPI_RXFTLR_RFT_Msk (0x00000007UL) /*!< field RFT (Bitfield-Mask: 0x00000007) */
#define SPI_RXFTLR_RSVD_RXFTLR_Pos (3UL) /*!< field RSVD_RXFTLR (bitOffset 3, bitWidth 29) */
#define SPI_RXFTLR_RSVD_RXFTLR_Msk (0xfffffff8UL) /*!< field RSVD_RXFTLR (Bitfield-Mask: 0x1fffffff) */

/* ====================================================== Register TXFLR ===================================================== */
#define SPI_TXFLR_TXTFL_Pos (0UL) /*!< field TXTFL (bitOffset 0, bitWidth 4) */
#define SPI_TXFLR_TXTFL_Msk (0x0000000fUL) /*!< field TXTFL (Bitfield-Mask: 0x0000000f) */
#define SPI_TXFLR_RSVD_TXFLR_Pos (4UL) /*!< field RSVD_TXFLR (bitOffset 4, bitWidth 28) */
#define SPI_TXFLR_RSVD_TXFLR_Msk (0xfffffff0UL) /*!< field RSVD_TXFLR (Bitfield-Mask: 0x0fffffff) */

/* ====================================================== Register RXFLR ===================================================== */
#define SPI_RXFLR_RXTFL_Pos (0UL) /*!< field RXTFL (bitOffset 0, bitWidth 4) */
#define SPI_RXFLR_RXTFL_Msk (0x0000000fUL) /*!< field RXTFL (Bitfield-Mask: 0x0000000f) */
#define SPI_RXFLR_RSVD_RXFLR_Pos (4UL) /*!< field RSVD_RXFLR (bitOffset 4, bitWidth 28) */
#define SPI_RXFLR_RSVD_RXFLR_Msk (0xfffffff0UL) /*!< field RSVD_RXFLR (Bitfield-Mask: 0x0fffffff) */

/* ======================================================= Register SR ======================================================= */
#define SPI_SR_BUSY_Pos (0UL) /*!< field BUSY (bitOffset 0, bitWidth 1) */
#define SPI_SR_BUSY_Msk (0x00000001UL) /*!< field BUSY (Bitfield-Mask: 0x00000001) */
#define SPI_SR_TFNF_Pos (1UL) /*!< field TFNF (bitOffset 1, bitWidth 1) */
#define SPI_SR_TFNF_Msk (0x00000002UL) /*!< field TFNF (Bitfield-Mask: 0x00000001) */
#define SPI_SR_TFE_Pos (2UL) /*!< field TFE (bitOffset 2, bitWidth 1) */
#define SPI_SR_TFE_Msk (0x00000004UL) /*!< field TFE (Bitfield-Mask: 0x00000001) */
#define SPI_SR_RFNE_Pos (3UL) /*!< field RFNE (bitOffset 3, bitWidth 1) */
#define SPI_SR_RFNE_Msk (0x00000008UL) /*!< field RFNE (Bitfield-Mask: 0x00000001) */
#define SPI_SR_RFF_Pos (4UL) /*!< field RFF (bitOffset 4, bitWidth 1) */
#define SPI_SR_RFF_Msk (0x00000010UL) /*!< field RFF (Bitfield-Mask: 0x00000001) */
#define SPI_SR_RSVD_TXE_Pos (5UL) /*!< field RSVD_TXE (bitOffset 5, bitWidth 1) */
#define SPI_SR_RSVD_TXE_Msk (0x00000020UL) /*!< field RSVD_TXE (Bitfield-Mask: 0x00000001) */
#define SPI_SR_DCOL_Pos (6UL) /*!< field DCOL (bitOffset 6, bitWidth 1) */
#define SPI_SR_DCOL_Msk (0x00000040UL) /*!< field DCOL (Bitfield-Mask: 0x00000001) */
#define SPI_SR_RSVD_SR_Pos (7UL) /*!< field RSVD_SR (bitOffset 7, bitWidth 25) */
#define SPI_SR_RSVD_SR_Msk (0xffffff80UL) /*!< field RSVD_SR (Bitfield-Mask: 0x01ffffff) */

/* ======================================================= Register IMR ====================================================== */
#define SPI_IMR_TXEIM_Pos (0UL) /*!< field TXEIM (bitOffset 0, bitWidth 1) */
#define SPI_IMR_TXEIM_Msk (0x00000001UL) /*!< field TXEIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_TXOIM_Pos (1UL) /*!< field TXOIM (bitOffset 1, bitWidth 1) */
#define SPI_IMR_TXOIM_Msk (0x00000002UL) /*!< field TXOIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_RXUIM_Pos (2UL) /*!< field RXUIM (bitOffset 2, bitWidth 1) */
#define SPI_IMR_RXUIM_Msk (0x00000004UL) /*!< field RXUIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_RXOIM_Pos (3UL) /*!< field RXOIM (bitOffset 3, bitWidth 1) */
#define SPI_IMR_RXOIM_Msk (0x00000008UL) /*!< field RXOIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_RXFIM_Pos (4UL) /*!< field RXFIM (bitOffset 4, bitWidth 1) */
#define SPI_IMR_RXFIM_Msk (0x00000010UL) /*!< field RXFIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_MSTIM_Pos (5UL) /*!< field MSTIM (bitOffset 5, bitWidth 1) */
#define SPI_IMR_MSTIM_Msk (0x00000020UL) /*!< field MSTIM (Bitfield-Mask: 0x00000001) */
#define SPI_IMR_RSVD_IMR_Pos (6UL) /*!< field RSVD_IMR (bitOffset 6, bitWidth 26) */
#define SPI_IMR_RSVD_IMR_Msk (0xffffffc0UL) /*!< field RSVD_IMR (Bitfield-Mask: 0x03ffffff) */

/* ======================================================= Register ISR ====================================================== */
#define SPI_ISR_TXEIS_Pos (0UL) /*!< field TXEIS (bitOffset 0, bitWidth 1) */
#define SPI_ISR_TXEIS_Msk (0x00000001UL) /*!< field TXEIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_TXOIS_Pos (1UL) /*!< field TXOIS (bitOffset 1, bitWidth 1) */
#define SPI_ISR_TXOIS_Msk (0x00000002UL) /*!< field TXOIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_RXUIS_Pos (2UL) /*!< field RXUIS (bitOffset 2, bitWidth 1) */
#define SPI_ISR_RXUIS_Msk (0x00000004UL) /*!< field RXUIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_RXOIS_Pos (3UL) /*!< field RXOIS (bitOffset 3, bitWidth 1) */
#define SPI_ISR_RXOIS_Msk (0x00000008UL) /*!< field RXOIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_RXFIS_Pos (4UL) /*!< field RXFIS (bitOffset 4, bitWidth 1) */
#define SPI_ISR_RXFIS_Msk (0x00000010UL) /*!< field RXFIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_MSTIS_Pos (5UL) /*!< field MSTIS (bitOffset 5, bitWidth 1) */
#define SPI_ISR_MSTIS_Msk (0x00000020UL) /*!< field MSTIS (Bitfield-Mask: 0x00000001) */
#define SPI_ISR_RSVD_ISR_Pos (6UL) /*!< field RSVD_ISR (bitOffset 6, bitWidth 26) */
#define SPI_ISR_RSVD_ISR_Msk (0xffffffc0UL) /*!< field RSVD_ISR (Bitfield-Mask: 0x03ffffff) */

/* ====================================================== Register RISR ====================================================== */
#define SPI_RISR_TXEIR_Pos (0UL) /*!< field TXEIR (bitOffset 0, bitWidth 1) */
#define SPI_RISR_TXEIR_Msk (0x00000001UL) /*!< field TXEIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_TXOIR_Pos (1UL) /*!< field TXOIR (bitOffset 1, bitWidth 1) */
#define SPI_RISR_TXOIR_Msk (0x00000002UL) /*!< field TXOIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_RXUIR_Pos (2UL) /*!< field RXUIR (bitOffset 2, bitWidth 1) */
#define SPI_RISR_RXUIR_Msk (0x00000004UL) /*!< field RXUIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_RXOIR_Pos (3UL) /*!< field RXOIR (bitOffset 3, bitWidth 1) */
#define SPI_RISR_RXOIR_Msk (0x00000008UL) /*!< field RXOIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_RXFIR_Pos (4UL) /*!< field RXFIR (bitOffset 4, bitWidth 1) */
#define SPI_RISR_RXFIR_Msk (0x00000010UL) /*!< field RXFIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_MSTIR_Pos (5UL) /*!< field MSTIR (bitOffset 5, bitWidth 1) */
#define SPI_RISR_MSTIR_Msk (0x00000020UL) /*!< field MSTIR (Bitfield-Mask: 0x00000001) */
#define SPI_RISR_RSVD_RISR_Pos (6UL) /*!< field RSVD_RISR (bitOffset 6, bitWidth 26) */
#define SPI_RISR_RSVD_RISR_Msk (0xffffffc0UL) /*!< field RSVD_RISR (Bitfield-Mask: 0x03ffffff) */

/* ===================================================== Register TXOICR ===================================================== */
#define SPI_TXOICR_TXOICR_Pos (0UL) /*!< field TXOICR (bitOffset 0, bitWidth 1) */
#define SPI_TXOICR_TXOICR_Msk (0x00000001UL) /*!< field TXOICR (Bitfield-Mask: 0x00000001) */
#define SPI_TXOICR_RSVD_TXOICR_Pos (1UL) /*!< field RSVD_TXOICR (bitOffset 1, bitWidth 31) */
#define SPI_TXOICR_RSVD_TXOICR_Msk (0xfffffffeUL) /*!< field RSVD_TXOICR (Bitfield-Mask: 0x7fffffff) */

/* ===================================================== Register RXOICR ===================================================== */
#define SPI_RXOICR_RXOICR_Pos (0UL) /*!< field RXOICR (bitOffset 0, bitWidth 1) */
#define SPI_RXOICR_RXOICR_Msk (0x00000001UL) /*!< field RXOICR (Bitfield-Mask: 0x00000001) */
#define SPI_RXOICR_RSVD_RXOICR_Pos (1UL) /*!< field RSVD_RXOICR (bitOffset 1, bitWidth 31) */
#define SPI_RXOICR_RSVD_RXOICR_Msk (0xfffffffeUL) /*!< field RSVD_RXOICR (Bitfield-Mask: 0x7fffffff) */

/* ===================================================== Register RXUICR ===================================================== */
#define SPI_RXUICR_RXUICR_Pos (0UL) /*!< field RXUICR (bitOffset 0, bitWidth 1) */
#define SPI_RXUICR_RXUICR_Msk (0x00000001UL) /*!< field RXUICR (Bitfield-Mask: 0x00000001) */
#define SPI_RXUICR_RSVD_RXUICR_Pos (1UL) /*!< field RSVD_RXUICR (bitOffset 1, bitWidth 31) */
#define SPI_RXUICR_RSVD_RXUICR_Msk (0xfffffffeUL) /*!< field RSVD_RXUICR (Bitfield-Mask: 0x7fffffff) */

/* ===================================================== Register MSTICR ===================================================== */
#define SPI_MSTICR_MSTICR_Pos (0UL) /*!< field MSTICR (bitOffset 0, bitWidth 1) */
#define SPI_MSTICR_MSTICR_Msk (0x00000001UL) /*!< field MSTICR (Bitfield-Mask: 0x00000001) */
#define SPI_MSTICR_RSVD_MSTICR_Pos (1UL) /*!< field RSVD_MSTICR (bitOffset 1, bitWidth 31) */
#define SPI_MSTICR_RSVD_MSTICR_Msk (0xfffffffeUL) /*!< field RSVD_MSTICR (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register ICR ====================================================== */
#define SPI_ICR_ICR_Pos (0UL) /*!< field ICR (bitOffset 0, bitWidth 1) */
#define SPI_ICR_ICR_Msk (0x00000001UL) /*!< field ICR (Bitfield-Mask: 0x00000001) */
#define SPI_ICR_RSVD_ICR_Pos (1UL) /*!< field RSVD_ICR (bitOffset 1, bitWidth 31) */
#define SPI_ICR_RSVD_ICR_Msk (0xfffffffeUL) /*!< field RSVD_ICR (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register DMACR ===================================================== */
#define SPI_DMACR_RDMAE_Pos (0UL) /*!< field RDMAE (bitOffset 0, bitWidth 1) */
#define SPI_DMACR_RDMAE_Msk (0x00000001UL) /*!< field RDMAE (Bitfield-Mask: 0x00000001) */
#define SPI_DMACR_TDMAE_Pos (1UL) /*!< field TDMAE (bitOffset 1, bitWidth 1) */
#define SPI_DMACR_TDMAE_Msk (0x00000002UL) /*!< field TDMAE (Bitfield-Mask: 0x00000001) */
#define SPI_DMACR_RSVD_DMACR_Pos (2UL) /*!< field RSVD_DMACR (bitOffset 2, bitWidth 30) */
#define SPI_DMACR_RSVD_DMACR_Msk (0xfffffffcUL) /*!< field RSVD_DMACR (Bitfield-Mask: 0x3fffffff) */

/* ===================================================== Register DMATDLR ==================================================== */
#define SPI_DMATDLR_DMATDL_Pos (0UL) /*!< field DMATDL (bitOffset 0, bitWidth 3) */
#define SPI_DMATDLR_DMATDL_Msk (0x00000007UL) /*!< field DMATDL (Bitfield-Mask: 0x00000007) */
#define SPI_DMATDLR_RSVD_DMATDLR_Pos (3UL) /*!< field RSVD_DMATDLR (bitOffset 3, bitWidth 29) */
#define SPI_DMATDLR_RSVD_DMATDLR_Msk (0xfffffff8UL) /*!< field RSVD_DMATDLR (Bitfield-Mask: 0x1fffffff) */

/* ===================================================== Register DMARDLR ==================================================== */
#define SPI_DMARDLR_DMARDL_Pos (0UL) /*!< field DMARDL (bitOffset 0, bitWidth 3) */
#define SPI_DMARDLR_DMARDL_Msk (0x00000007UL) /*!< field DMARDL (Bitfield-Mask: 0x00000007) */
#define SPI_DMARDLR_RSVD_DMARDLR_Pos (3UL) /*!< field RSVD_DMARDLR (bitOffset 3, bitWidth 29) */
#define SPI_DMARDLR_RSVD_DMARDLR_Msk (0xfffffff8UL) /*!< field RSVD_DMARDLR (Bitfield-Mask: 0x1fffffff) */

/* ======================================================= Register IDR ====================================================== */
#define SPI_IDR_IDCODE_Pos (0UL) /*!< field IDCODE (bitOffset 0, bitWidth 32) */
#define SPI_IDR_IDCODE_Msk (0xffffffffUL) /*!< field IDCODE (Bitfield-Mask: 0xffffffff) */

/* ================================================= Register SSI_VERSION_ID ================================================= */
#define SPI_SSI_VERSION_ID_SSI_COMP_VERSION_Pos (0UL) /*!< field SSI_COMP_VERSION (bitOffset 0, bitWidth 32) */
#define SPI_SSI_VERSION_ID_SSI_COMP_VERSION_Msk (0xffffffffUL) /*!< field SSI_COMP_VERSION (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR0 ====================================================== */
#define SPI_DR0_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR0_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR1 ====================================================== */
#define SPI_DR1_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR1_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR2 ====================================================== */
#define SPI_DR2_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR2_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR3 ====================================================== */
#define SPI_DR3_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR3_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR4 ====================================================== */
#define SPI_DR4_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR4_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR5 ====================================================== */
#define SPI_DR5_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR5_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR6 ====================================================== */
#define SPI_DR6_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR6_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR7 ====================================================== */
#define SPI_DR7_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR7_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR8 ====================================================== */
#define SPI_DR8_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR8_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ======================================================= Register DR9 ====================================================== */
#define SPI_DR9_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR9_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR10 ====================================================== */
#define SPI_DR10_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR10_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR11 ====================================================== */
#define SPI_DR11_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR11_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR12 ====================================================== */
#define SPI_DR12_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR12_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR13 ====================================================== */
#define SPI_DR13_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR13_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR14 ====================================================== */
#define SPI_DR14_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR14_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR15 ====================================================== */
#define SPI_DR15_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR15_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR16 ====================================================== */
#define SPI_DR16_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR16_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR17 ====================================================== */
#define SPI_DR17_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR17_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR18 ====================================================== */
#define SPI_DR18_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR18_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR19 ====================================================== */
#define SPI_DR19_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR19_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR20 ====================================================== */
#define SPI_DR20_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR20_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR21 ====================================================== */
#define SPI_DR21_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR21_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR22 ====================================================== */
#define SPI_DR22_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR22_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR23 ====================================================== */
#define SPI_DR23_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR23_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR24 ====================================================== */
#define SPI_DR24_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR24_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR25 ====================================================== */
#define SPI_DR25_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR25_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR26 ====================================================== */
#define SPI_DR26_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR26_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR27 ====================================================== */
#define SPI_DR27_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR27_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR28 ====================================================== */
#define SPI_DR28_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR28_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR29 ====================================================== */
#define SPI_DR29_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR29_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR30 ====================================================== */
#define SPI_DR30_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR30_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR31 ====================================================== */
#define SPI_DR31_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR31_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR32 ====================================================== */
#define SPI_DR32_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR32_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR33 ====================================================== */
#define SPI_DR33_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR33_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR34 ====================================================== */
#define SPI_DR34_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR34_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register DR35 ====================================================== */
#define SPI_DR35_DR_Pos (0UL) /*!< field DR (bitOffset 0, bitWidth 32) */
#define SPI_DR35_DR_Msk (0xffffffffUL) /*!< field DR (Bitfield-Mask: 0xffffffff) */

/* ================================================== Register RX_SAMPLE_DLY ================================================= */
#define SPI_RX_SAMPLE_DLY_RSD_Pos (0UL) /*!< field RSD (bitOffset 0, bitWidth 8) */
#define SPI_RX_SAMPLE_DLY_RSD_Msk (0x000000ffUL) /*!< field RSD (Bitfield-Mask: 0x000000ff) */
#define SPI_RX_SAMPLE_DLY_RSVD_RX_SAMPLE_DLY_Pos (8UL) /*!< field RSVD_RX_SAMPLE_DLY (bitOffset 8, bitWidth 24) */
#define SPI_RX_SAMPLE_DLY_RSVD_RX_SAMPLE_DLY_Msk (0xffffff00UL) /*!< field RSVD_RX_SAMPLE_DLY (Bitfield-Mask: 0x00ffffff) */

/* ====================================================== Register RSVD ====================================================== */
#define SPI_RSVD_RSVD_Pos (0UL) /*!< field RSVD (bitOffset 0, bitWidth 32) */
#define SPI_RSVD_RSVD_Msk (0xffffffffUL) /*!< field RSVD (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2C ================================================= */
/* =========================================================================================================================== */

/* ===================================================== Register IC_CON ===================================================== */
#define I2C_IC_CON_MASTER_MODE_Pos (0UL) /*!< field MASTER_MODE (bitOffset 0, bitWidth 1) */
#define I2C_IC_CON_MASTER_MODE_Msk (0x00000001UL) /*!< field MASTER_MODE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_SPEED_Pos (1UL) /*!< field SPEED (bitOffset 1, bitWidth 2) */
#define I2C_IC_CON_SPEED_Msk (0x00000006UL) /*!< field SPEED (Bitfield-Mask: 0x00000003) */
#define I2C_IC_CON_IC_10BITADDR_SLAVE_Pos (3UL) /*!< field IC_10BITADDR_SLAVE (bitOffset 3, bitWidth 1) */
#define I2C_IC_CON_IC_10BITADDR_SLAVE_Msk (0x00000008UL) /*!< field IC_10BITADDR_SLAVE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_IC_10BITADDR_MASTER_Pos (4UL) /*!< field IC_10BITADDR_MASTER (bitOffset 4, bitWidth 1) */
#define I2C_IC_CON_IC_10BITADDR_MASTER_Msk (0x00000010UL) /*!< field IC_10BITADDR_MASTER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_IC_RESTART_EN_Pos (5UL) /*!< field IC_RESTART_EN (bitOffset 5, bitWidth 1) */
#define I2C_IC_CON_IC_RESTART_EN_Msk (0x00000020UL) /*!< field IC_RESTART_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_IC_SLAVE_DISABLE_Pos (6UL) /*!< field IC_SLAVE_DISABLE (bitOffset 6, bitWidth 1) */
#define I2C_IC_CON_IC_SLAVE_DISABLE_Msk (0x00000040UL) /*!< field IC_SLAVE_DISABLE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_STOP_DET_IFADDRESSED_Pos (7UL) /*!< field STOP_DET_IFADDRESSED (bitOffset 7, bitWidth 1) */
#define I2C_IC_CON_STOP_DET_IFADDRESSED_Msk (0x00000080UL) /*!< field STOP_DET_IFADDRESSED (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_TX_EMPTY_CTRL_Pos (8UL) /*!< field TX_EMPTY_CTRL (bitOffset 8, bitWidth 1) */
#define I2C_IC_CON_TX_EMPTY_CTRL_Msk (0x00000100UL) /*!< field TX_EMPTY_CTRL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RX_FIFO_FULL_HLD_CTRL_Pos (9UL) /*!< field RX_FIFO_FULL_HLD_CTRL (bitOffset 9, bitWidth 1) */
#define I2C_IC_CON_RX_FIFO_FULL_HLD_CTRL_Msk (0x00000200UL) /*!< field RX_FIFO_FULL_HLD_CTRL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_STOP_DET_IF_MASTER_ACTIVE_Pos (10UL) /*!< field STOP_DET_IF_MASTER_ACTIVE (bitOffset 10, bitWidth 1) */
#define I2C_IC_CON_STOP_DET_IF_MASTER_ACTIVE_Msk (0x00000400UL) /*!< field STOP_DET_IF_MASTER_ACTIVE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_BUS_CLEAR_FEATURE_CTRL_Pos (11UL) /*!< field RSVD_BUS_CLEAR_FEATURE_CTRL (bitOffset 11, bitWidth 1) */
#define I2C_IC_CON_RSVD_BUS_CLEAR_FEATURE_CTRL_Msk (0x00000800UL) /*!< field RSVD_BUS_CLEAR_FEATURE_CTRL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_IC_CON_1_Pos (12UL) /*!< field RSVD_IC_CON_1 (bitOffset 12, bitWidth 4) */
#define I2C_IC_CON_RSVD_IC_CON_1_Msk (0x0000f000UL) /*!< field RSVD_IC_CON_1 (Bitfield-Mask: 0x0000000f) */
#define I2C_IC_CON_RSVD_OPTIONAL_SAR_CTRL_Pos (16UL) /*!< field RSVD_OPTIONAL_SAR_CTRL (bitOffset 16, bitWidth 1) */
#define I2C_IC_CON_RSVD_OPTIONAL_SAR_CTRL_Msk (0x00010000UL) /*!< field RSVD_OPTIONAL_SAR_CTRL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_SMBUS_SLAVE_QUICK_EN_Pos (17UL) /*!< field RSVD_SMBUS_SLAVE_QUICK_EN (bitOffset 17, bitWidth 1) */
#define I2C_IC_CON_RSVD_SMBUS_SLAVE_QUICK_EN_Msk (0x00020000UL) /*!< field RSVD_SMBUS_SLAVE_QUICK_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_SMBUS_ARP_EN_Pos (18UL) /*!< field RSVD_SMBUS_ARP_EN (bitOffset 18, bitWidth 1) */
#define I2C_IC_CON_RSVD_SMBUS_ARP_EN_Msk (0x00040000UL) /*!< field RSVD_SMBUS_ARP_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_SMBUS_PERSISTENT_SLV_ADDR_EN_Pos (19UL) /*!< field RSVD_SMBUS_PERSISTENT_SLV_ADDR_EN (bitOffset 19, bitWidth 1) */
#define I2C_IC_CON_RSVD_SMBUS_PERSISTENT_SLV_ADDR_EN_Msk (0x00080000UL) /*!< field RSVD_SMBUS_PERSISTENT_SLV_ADDR_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CON_RSVD_IC_CON_2_Pos (20UL) /*!< field RSVD_IC_CON_2 (bitOffset 20, bitWidth 12) */
#define I2C_IC_CON_RSVD_IC_CON_2_Msk (0xfff00000UL) /*!< field RSVD_IC_CON_2 (Bitfield-Mask: 0x00000fff) */

/* ===================================================== Register IC_TAR ===================================================== */
#define I2C_IC_TAR_IC_TAR_Pos (0UL) /*!< field IC_TAR (bitOffset 0, bitWidth 10) */
#define I2C_IC_TAR_IC_TAR_Msk (0x000003ffUL) /*!< field IC_TAR (Bitfield-Mask: 0x000003ff) */
#define I2C_IC_TAR_GC_OR_START_Pos (10UL) /*!< field GC_OR_START (bitOffset 10, bitWidth 1) */
#define I2C_IC_TAR_GC_OR_START_Msk (0x00000400UL) /*!< field GC_OR_START (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TAR_SPECIAL_Pos (11UL) /*!< field SPECIAL (bitOffset 11, bitWidth 1) */
#define I2C_IC_TAR_SPECIAL_Msk (0x00000800UL) /*!< field SPECIAL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TAR_RSVD_IC_10BITADDR_MASTER_Pos (12UL) /*!< field RSVD_IC_10BITADDR_MASTER (bitOffset 12, bitWidth 1) */
#define I2C_IC_TAR_RSVD_IC_10BITADDR_MASTER_Msk (0x00001000UL) /*!< field RSVD_IC_10BITADDR_MASTER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TAR_RSVD_DEVICE_ID_Pos (13UL) /*!< field RSVD_DEVICE_ID (bitOffset 13, bitWidth 1) */
#define I2C_IC_TAR_RSVD_DEVICE_ID_Msk (0x00002000UL) /*!< field RSVD_DEVICE_ID (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TAR_RSVD_IC_TAR_1_Pos (14UL) /*!< field RSVD_IC_TAR_1 (bitOffset 14, bitWidth 2) */
#define I2C_IC_TAR_RSVD_IC_TAR_1_Msk (0x0000c000UL) /*!< field RSVD_IC_TAR_1 (Bitfield-Mask: 0x00000003) */
#define I2C_IC_TAR_RSVD_SMBUS_QUICK_CMD_Pos (16UL) /*!< field RSVD_SMBUS_QUICK_CMD (bitOffset 16, bitWidth 1) */
#define I2C_IC_TAR_RSVD_SMBUS_QUICK_CMD_Msk (0x00010000UL) /*!< field RSVD_SMBUS_QUICK_CMD (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TAR_RSVD_IC_TAR_2_Pos (17UL) /*!< field RSVD_IC_TAR_2 (bitOffset 17, bitWidth 15) */
#define I2C_IC_TAR_RSVD_IC_TAR_2_Msk (0xfffe0000UL) /*!< field RSVD_IC_TAR_2 (Bitfield-Mask: 0x00007fff) */

/* ===================================================== Register IC_SAR ===================================================== */
#define I2C_IC_SAR_IC_SAR_Pos (0UL) /*!< field IC_SAR (bitOffset 0, bitWidth 10) */
#define I2C_IC_SAR_IC_SAR_Msk (0x000003ffUL) /*!< field IC_SAR (Bitfield-Mask: 0x000003ff) */
#define I2C_IC_SAR_RSVD_IC_SAR_Pos (10UL) /*!< field RSVD_IC_SAR (bitOffset 10, bitWidth 22) */
#define I2C_IC_SAR_RSVD_IC_SAR_Msk (0xfffffc00UL) /*!< field RSVD_IC_SAR (Bitfield-Mask: 0x003fffff) */

/* =================================================== Register IC_HS_MADDR ================================================== */
#define I2C_IC_HS_MADDR_IC_HS_MAR_Pos (0UL) /*!< field IC_HS_MAR (bitOffset 0, bitWidth 3) */
#define I2C_IC_HS_MADDR_IC_HS_MAR_Msk (0x00000007UL) /*!< field IC_HS_MAR (Bitfield-Mask: 0x00000007) */
#define I2C_IC_HS_MADDR_RSVD_IC_HS_MAR_Pos (3UL) /*!< field RSVD_IC_HS_MAR (bitOffset 3, bitWidth 29) */
#define I2C_IC_HS_MADDR_RSVD_IC_HS_MAR_Msk (0xfffffff8UL) /*!< field RSVD_IC_HS_MAR (Bitfield-Mask: 0x1fffffff) */

/* =================================================== Register IC_DATA_CMD ================================================== */
#define I2C_IC_DATA_CMD_DAT_Pos (0UL) /*!< field DAT (bitOffset 0, bitWidth 8) */
#define I2C_IC_DATA_CMD_DAT_Msk (0x000000ffUL) /*!< field DAT (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_DATA_CMD_CMD_Pos (8UL) /*!< field CMD (bitOffset 8, bitWidth 1) */
#define I2C_IC_DATA_CMD_CMD_Msk (0x00000100UL) /*!< field CMD (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DATA_CMD_RSVD_STOP_Pos (9UL) /*!< field RSVD_STOP (bitOffset 9, bitWidth 1) */
#define I2C_IC_DATA_CMD_RSVD_STOP_Msk (0x00000200UL) /*!< field RSVD_STOP (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DATA_CMD_RSVD_RESTART_Pos (10UL) /*!< field RSVD_RESTART (bitOffset 10, bitWidth 1) */
#define I2C_IC_DATA_CMD_RSVD_RESTART_Msk (0x00000400UL) /*!< field RSVD_RESTART (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DATA_CMD_RSVD_FIRST_DATA_BYTE_Pos (11UL) /*!< field RSVD_FIRST_DATA_BYTE (bitOffset 11, bitWidth 1) */
#define I2C_IC_DATA_CMD_RSVD_FIRST_DATA_BYTE_Msk (0x00000800UL) /*!< field RSVD_FIRST_DATA_BYTE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DATA_CMD_RSVD_IC_DATA_CMD_Pos (12UL) /*!< field RSVD_IC_DATA_CMD (bitOffset 12, bitWidth 20) */
#define I2C_IC_DATA_CMD_RSVD_IC_DATA_CMD_Msk (0xfffff000UL) /*!< field RSVD_IC_DATA_CMD (Bitfield-Mask: 0x000fffff) */

/* ================================================= Register IC_SS_SCL_HCNT ================================================= */
#define I2C_IC_SS_SCL_HCNT_IC_SS_SCL_HCNT_Pos (0UL) /*!< field IC_SS_SCL_HCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_SS_SCL_HCNT_IC_SS_SCL_HCNT_Msk (0x0000ffffUL) /*!< field IC_SS_SCL_HCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_SS_SCL_HCNT_RSVD_IC_SS_SCL_HIGH_COUNT_Pos (16UL) /*!< field RSVD_IC_SS_SCL_HIGH_COUNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_SS_SCL_HCNT_RSVD_IC_SS_SCL_HIGH_COUNT_Msk (0xffff0000UL) /*!< field RSVD_IC_SS_SCL_HIGH_COUNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================= Register IC_SS_SCL_LCNT ================================================= */
#define I2C_IC_SS_SCL_LCNT_IC_SS_SCL_LCNT_Pos (0UL) /*!< field IC_SS_SCL_LCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_SS_SCL_LCNT_IC_SS_SCL_LCNT_Msk (0x0000ffffUL) /*!< field IC_SS_SCL_LCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_SS_SCL_LCNT_RSVD_IC_SS_SCL_LOW_COUNT_Pos (16UL) /*!< field RSVD_IC_SS_SCL_LOW_COUNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_SS_SCL_LCNT_RSVD_IC_SS_SCL_LOW_COUNT_Msk (0xffff0000UL) /*!< field RSVD_IC_SS_SCL_LOW_COUNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================= Register IC_FS_SCL_HCNT ================================================= */
#define I2C_IC_FS_SCL_HCNT_IC_FS_SCL_HCNT_Pos (0UL) /*!< field IC_FS_SCL_HCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_FS_SCL_HCNT_IC_FS_SCL_HCNT_Msk (0x0000ffffUL) /*!< field IC_FS_SCL_HCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_FS_SCL_HCNT_RSVD_IC_FS_SCL_HCNT_Pos (16UL) /*!< field RSVD_IC_FS_SCL_HCNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_FS_SCL_HCNT_RSVD_IC_FS_SCL_HCNT_Msk (0xffff0000UL) /*!< field RSVD_IC_FS_SCL_HCNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================= Register IC_FS_SCL_LCNT ================================================= */
#define I2C_IC_FS_SCL_LCNT_IC_FS_SCL_LCNT_Pos (0UL) /*!< field IC_FS_SCL_LCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_FS_SCL_LCNT_IC_FS_SCL_LCNT_Msk (0x0000ffffUL) /*!< field IC_FS_SCL_LCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_FS_SCL_LCNT_RSVD_IC_FS_SCL_LCNT_Pos (16UL) /*!< field RSVD_IC_FS_SCL_LCNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_FS_SCL_LCNT_RSVD_IC_FS_SCL_LCNT_Msk (0xffff0000UL) /*!< field RSVD_IC_FS_SCL_LCNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================= Register IC_HS_SCL_HCNT ================================================= */
#define I2C_IC_HS_SCL_HCNT_IC_HS_SCL_HCNT_Pos (0UL) /*!< field IC_HS_SCL_HCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_HS_SCL_HCNT_IC_HS_SCL_HCNT_Msk (0x0000ffffUL) /*!< field IC_HS_SCL_HCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_HS_SCL_HCNT_RSVD_IC_HS_SCL_HCNT_Pos (16UL) /*!< field RSVD_IC_HS_SCL_HCNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_HS_SCL_HCNT_RSVD_IC_HS_SCL_HCNT_Msk (0xffff0000UL) /*!< field RSVD_IC_HS_SCL_HCNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================= Register IC_HS_SCL_LCNT ================================================= */
#define I2C_IC_HS_SCL_LCNT_IC_HS_SCL_LCNT_Pos (0UL) /*!< field IC_HS_SCL_LCNT (bitOffset 0, bitWidth 16) */
#define I2C_IC_HS_SCL_LCNT_IC_HS_SCL_LCNT_Msk (0x0000ffffUL) /*!< field IC_HS_SCL_LCNT (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_HS_SCL_LCNT_RSVD_IC_HS_SCL_LOW_CNT_Pos (16UL) /*!< field RSVD_IC_HS_SCL_LOW_CNT (bitOffset 16, bitWidth 16) */
#define I2C_IC_HS_SCL_LCNT_RSVD_IC_HS_SCL_LOW_CNT_Msk (0xffff0000UL) /*!< field RSVD_IC_HS_SCL_LOW_CNT (Bitfield-Mask: 0x0000ffff) */

/* ================================================== Register IC_INTR_STAT ================================================== */
#define I2C_IC_INTR_STAT_R_RX_UNDER_Pos (0UL) /*!< field R_RX_UNDER (bitOffset 0, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RX_UNDER_Msk (0x00000001UL) /*!< field R_RX_UNDER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_RX_OVER_Pos (1UL) /*!< field R_RX_OVER (bitOffset 1, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RX_OVER_Msk (0x00000002UL) /*!< field R_RX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_RX_FULL_Pos (2UL) /*!< field R_RX_FULL (bitOffset 2, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RX_FULL_Msk (0x00000004UL) /*!< field R_RX_FULL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_TX_OVER_Pos (3UL) /*!< field R_TX_OVER (bitOffset 3, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_TX_OVER_Msk (0x00000008UL) /*!< field R_TX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_TX_EMPTY_Pos (4UL) /*!< field R_TX_EMPTY (bitOffset 4, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_TX_EMPTY_Msk (0x00000010UL) /*!< field R_TX_EMPTY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_RD_REQ_Pos (5UL) /*!< field R_RD_REQ (bitOffset 5, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RD_REQ_Msk (0x00000020UL) /*!< field R_RD_REQ (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_TX_ABRT_Pos (6UL) /*!< field R_TX_ABRT (bitOffset 6, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_TX_ABRT_Msk (0x00000040UL) /*!< field R_TX_ABRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_RX_DONE_Pos (7UL) /*!< field R_RX_DONE (bitOffset 7, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RX_DONE_Msk (0x00000080UL) /*!< field R_RX_DONE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_ACTIVITY_Pos (8UL) /*!< field R_ACTIVITY (bitOffset 8, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_ACTIVITY_Msk (0x00000100UL) /*!< field R_ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_STOP_DET_Pos (9UL) /*!< field R_STOP_DET (bitOffset 9, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_STOP_DET_Msk (0x00000200UL) /*!< field R_STOP_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_START_DET_Pos (10UL) /*!< field R_START_DET (bitOffset 10, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_START_DET_Msk (0x00000400UL) /*!< field R_START_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_GEN_CALL_Pos (11UL) /*!< field R_GEN_CALL (bitOffset 11, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_GEN_CALL_Msk (0x00000800UL) /*!< field R_GEN_CALL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_RESTART_DET_Pos (12UL) /*!< field R_RESTART_DET (bitOffset 12, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_RESTART_DET_Msk (0x00001000UL) /*!< field R_RESTART_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_R_MASTER_ON_HOLD_Pos (13UL) /*!< field R_MASTER_ON_HOLD (bitOffset 13, bitWidth 1) */
#define I2C_IC_INTR_STAT_R_MASTER_ON_HOLD_Msk (0x00002000UL) /*!< field R_MASTER_ON_HOLD (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_RSVD_R_SCL_STUCK_AT_LOW_Pos (14UL) /*!< field RSVD_R_SCL_STUCK_AT_LOW (bitOffset 14, bitWidth 1) */
#define I2C_IC_INTR_STAT_RSVD_R_SCL_STUCK_AT_LOW_Msk (0x00004000UL) /*!< field RSVD_R_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_STAT_RSVD_IC_INTR_STAT_Pos (15UL) /*!< field RSVD_IC_INTR_STAT (bitOffset 15, bitWidth 17) */
#define I2C_IC_INTR_STAT_RSVD_IC_INTR_STAT_Msk (0xffff8000UL) /*!< field RSVD_IC_INTR_STAT (Bitfield-Mask: 0x0001ffff) */

/* ================================================== Register IC_INTR_MASK ================================================== */
#define I2C_IC_INTR_MASK_M_RX_UNDER_Pos (0UL) /*!< field M_RX_UNDER (bitOffset 0, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RX_UNDER_Msk (0x00000001UL) /*!< field M_RX_UNDER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_RX_OVER_Pos (1UL) /*!< field M_RX_OVER (bitOffset 1, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RX_OVER_Msk (0x00000002UL) /*!< field M_RX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_RX_FULL_Pos (2UL) /*!< field M_RX_FULL (bitOffset 2, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RX_FULL_Msk (0x00000004UL) /*!< field M_RX_FULL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_TX_OVER_Pos (3UL) /*!< field M_TX_OVER (bitOffset 3, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_TX_OVER_Msk (0x00000008UL) /*!< field M_TX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_TX_EMPTY_Pos (4UL) /*!< field M_TX_EMPTY (bitOffset 4, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_TX_EMPTY_Msk (0x00000010UL) /*!< field M_TX_EMPTY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_RD_REQ_Pos (5UL) /*!< field M_RD_REQ (bitOffset 5, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RD_REQ_Msk (0x00000020UL) /*!< field M_RD_REQ (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_TX_ABRT_Pos (6UL) /*!< field M_TX_ABRT (bitOffset 6, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_TX_ABRT_Msk (0x00000040UL) /*!< field M_TX_ABRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_RX_DONE_Pos (7UL) /*!< field M_RX_DONE (bitOffset 7, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RX_DONE_Msk (0x00000080UL) /*!< field M_RX_DONE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_ACTIVITY_Pos (8UL) /*!< field M_ACTIVITY (bitOffset 8, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_ACTIVITY_Msk (0x00000100UL) /*!< field M_ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_STOP_DET_Pos (9UL) /*!< field M_STOP_DET (bitOffset 9, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_STOP_DET_Msk (0x00000200UL) /*!< field M_STOP_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_START_DET_Pos (10UL) /*!< field M_START_DET (bitOffset 10, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_START_DET_Msk (0x00000400UL) /*!< field M_START_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_GEN_CALL_Pos (11UL) /*!< field M_GEN_CALL (bitOffset 11, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_GEN_CALL_Msk (0x00000800UL) /*!< field M_GEN_CALL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_RESTART_DET_READ_ONLY_Pos (12UL) /*!< field M_RESTART_DET_READ_ONLY (bitOffset 12, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_RESTART_DET_READ_ONLY_Msk (0x00001000UL) /*!< field M_RESTART_DET_READ_ONLY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_Pos (13UL) /*!< field M_MASTER_ON_HOLD_READ_ONLY (bitOffset 13, bitWidth 1) */
#define I2C_IC_INTR_MASK_M_MASTER_ON_HOLD_READ_ONLY_Msk (0x00002000UL) /*!< field M_MASTER_ON_HOLD_READ_ONLY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_RSVD_M_SCL_STUCK_AT_LOW_Pos (14UL) /*!< field RSVD_M_SCL_STUCK_AT_LOW (bitOffset 14, bitWidth 1) */
#define I2C_IC_INTR_MASK_RSVD_M_SCL_STUCK_AT_LOW_Msk (0x00004000UL) /*!< field RSVD_M_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x00000001) */
#define I2C_IC_INTR_MASK_RSVD_IC_INTR_STAT_Pos (15UL) /*!< field RSVD_IC_INTR_STAT (bitOffset 15, bitWidth 17) */
#define I2C_IC_INTR_MASK_RSVD_IC_INTR_STAT_Msk (0xffff8000UL) /*!< field RSVD_IC_INTR_STAT (Bitfield-Mask: 0x0001ffff) */

/* ================================================ Register IC_RAW_INTR_STAT ================================================ */
#define I2C_IC_RAW_INTR_STAT_RX_UNDER_Pos (0UL) /*!< field RX_UNDER (bitOffset 0, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RX_UNDER_Msk (0x00000001UL) /*!< field RX_UNDER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RX_OVER_Pos (1UL) /*!< field RX_OVER (bitOffset 1, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RX_OVER_Msk (0x00000002UL) /*!< field RX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RX_FULL_Pos (2UL) /*!< field RX_FULL (bitOffset 2, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RX_FULL_Msk (0x00000004UL) /*!< field RX_FULL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_TX_OVER_Pos (3UL) /*!< field TX_OVER (bitOffset 3, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_TX_OVER_Msk (0x00000008UL) /*!< field TX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_TX_EMPTY_Pos (4UL) /*!< field TX_EMPTY (bitOffset 4, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_TX_EMPTY_Msk (0x00000010UL) /*!< field TX_EMPTY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RD_REQ_Pos (5UL) /*!< field RD_REQ (bitOffset 5, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RD_REQ_Msk (0x00000020UL) /*!< field RD_REQ (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_TX_ABRT_Pos (6UL) /*!< field TX_ABRT (bitOffset 6, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_TX_ABRT_Msk (0x00000040UL) /*!< field TX_ABRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RX_DONE_Pos (7UL) /*!< field RX_DONE (bitOffset 7, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RX_DONE_Msk (0x00000080UL) /*!< field RX_DONE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_ACTIVITY_Pos (8UL) /*!< field ACTIVITY (bitOffset 8, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_ACTIVITY_Msk (0x00000100UL) /*!< field ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_STOP_DET_Pos (9UL) /*!< field STOP_DET (bitOffset 9, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_STOP_DET_Msk (0x00000200UL) /*!< field STOP_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_START_DET_Pos (10UL) /*!< field START_DET (bitOffset 10, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_START_DET_Msk (0x00000400UL) /*!< field START_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_GEN_CALL_Pos (11UL) /*!< field GEN_CALL (bitOffset 11, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_GEN_CALL_Msk (0x00000800UL) /*!< field GEN_CALL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RESTART_DET_Pos (12UL) /*!< field RESTART_DET (bitOffset 12, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RESTART_DET_Msk (0x00001000UL) /*!< field RESTART_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_MASTER_ON_HOLD_Pos (13UL) /*!< field MASTER_ON_HOLD (bitOffset 13, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_MASTER_ON_HOLD_Msk (0x00002000UL) /*!< field MASTER_ON_HOLD (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RSVD_SCL_STUCK_AT_LOW_Pos (14UL) /*!< field RSVD_SCL_STUCK_AT_LOW (bitOffset 14, bitWidth 1) */
#define I2C_IC_RAW_INTR_STAT_RSVD_SCL_STUCK_AT_LOW_Msk (0x00004000UL) /*!< field RSVD_SCL_STUCK_AT_LOW (Bitfield-Mask: 0x00000001) */
#define I2C_IC_RAW_INTR_STAT_RSVD_IC_RAW_INTR_STAT_Pos (15UL) /*!< field RSVD_IC_RAW_INTR_STAT (bitOffset 15, bitWidth 17) */
#define I2C_IC_RAW_INTR_STAT_RSVD_IC_RAW_INTR_STAT_Msk (0xffff8000UL) /*!< field RSVD_IC_RAW_INTR_STAT (Bitfield-Mask: 0x0001ffff) */

/* ==================================================== Register IC_RX_TL ==================================================== */
#define I2C_IC_RX_TL_RX_TL_Pos (0UL) /*!< field RX_TL (bitOffset 0, bitWidth 8) */
#define I2C_IC_RX_TL_RX_TL_Msk (0x000000ffUL) /*!< field RX_TL (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_RX_TL_RSVD_IC_RX_TL_Pos (8UL) /*!< field RSVD_IC_RX_TL (bitOffset 8, bitWidth 24) */
#define I2C_IC_RX_TL_RSVD_IC_RX_TL_Msk (0xffffff00UL) /*!< field RSVD_IC_RX_TL (Bitfield-Mask: 0x00ffffff) */

/* ==================================================== Register IC_TX_TL ==================================================== */
#define I2C_IC_TX_TL_TX_TL_Pos (0UL) /*!< field TX_TL (bitOffset 0, bitWidth 8) */
#define I2C_IC_TX_TL_TX_TL_Msk (0x000000ffUL) /*!< field TX_TL (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_TX_TL_RSVD_IC_TX_TL_Pos (8UL) /*!< field RSVD_IC_TX_TL (bitOffset 8, bitWidth 24) */
#define I2C_IC_TX_TL_RSVD_IC_TX_TL_Msk (0xffffff00UL) /*!< field RSVD_IC_TX_TL (Bitfield-Mask: 0x00ffffff) */

/* =================================================== Register IC_CLR_INTR ================================================== */
#define I2C_IC_CLR_INTR_CLR_INTR_Pos (0UL) /*!< field CLR_INTR (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_INTR_CLR_INTR_Msk (0x00000001UL) /*!< field CLR_INTR (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_INTR_RSVD_IC_CLR_INTR_Pos (1UL) /*!< field RSVD_IC_CLR_INTR (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_INTR_RSVD_IC_CLR_INTR_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_INTR (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_RX_UNDER ================================================ */
#define I2C_IC_CLR_RX_UNDER_CLR_RX_UNDER_Pos (0UL) /*!< field CLR_RX_UNDER (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_RX_UNDER_CLR_RX_UNDER_Msk (0x00000001UL) /*!< field CLR_RX_UNDER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_RX_UNDER_RSVD_IC_CLR_RX_UNDER_Pos (1UL) /*!< field RSVD_IC_CLR_RX_UNDER (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_RX_UNDER_RSVD_IC_CLR_RX_UNDER_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_RX_UNDER (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_RX_OVER ================================================= */
#define I2C_IC_CLR_RX_OVER_CLR_RX_OVER_Pos (0UL) /*!< field CLR_RX_OVER (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_RX_OVER_CLR_RX_OVER_Msk (0x00000001UL) /*!< field CLR_RX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_RX_OVER_RSVD_IC_CLR_RX_OVER_Pos (1UL) /*!< field RSVD_IC_CLR_RX_OVER (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_RX_OVER_RSVD_IC_CLR_RX_OVER_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_RX_OVER (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_TX_OVER ================================================= */
#define I2C_IC_CLR_TX_OVER_CLR_TX_OVER_Pos (0UL) /*!< field CLR_TX_OVER (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_TX_OVER_CLR_TX_OVER_Msk (0x00000001UL) /*!< field CLR_TX_OVER (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_TX_OVER_RSVD_IC_CLR_TX_OVER_Pos (1UL) /*!< field RSVD_IC_CLR_TX_OVER (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_TX_OVER_RSVD_IC_CLR_TX_OVER_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_TX_OVER (Bitfield-Mask: 0x7fffffff) */

/* ================================================== Register IC_CLR_RD_REQ ================================================= */
#define I2C_IC_CLR_RD_REQ_CLR_RD_REQ_Pos (0UL) /*!< field CLR_RD_REQ (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_RD_REQ_CLR_RD_REQ_Msk (0x00000001UL) /*!< field CLR_RD_REQ (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_RD_REQ_RSVD_IC_CLR_RD_REQ_Pos (1UL) /*!< field RSVD_IC_CLR_RD_REQ (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_RD_REQ_RSVD_IC_CLR_RD_REQ_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_RD_REQ (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_TX_ABRT ================================================= */
#define I2C_IC_CLR_TX_ABRT_CLR_TX_ABRT_Pos (0UL) /*!< field CLR_TX_ABRT (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_TX_ABRT_CLR_TX_ABRT_Msk (0x00000001UL) /*!< field CLR_TX_ABRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_TX_ABRT_RSVD_IC_CLR_TX_ABRT_Pos (1UL) /*!< field RSVD_IC_CLR_TX_ABRT (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_TX_ABRT_RSVD_IC_CLR_TX_ABRT_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_TX_ABRT (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_RX_DONE ================================================= */
#define I2C_IC_CLR_RX_DONE_CLR_RX_DONE_Pos (0UL) /*!< field CLR_RX_DONE (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_RX_DONE_CLR_RX_DONE_Msk (0x00000001UL) /*!< field CLR_RX_DONE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_RX_DONE_RSVD_IC_CLR_RX_DONE_Pos (1UL) /*!< field RSVD_IC_CLR_RX_DONE (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_RX_DONE_RSVD_IC_CLR_RX_DONE_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_RX_DONE (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_ACTIVITY ================================================ */
#define I2C_IC_CLR_ACTIVITY_CLR_ACTIVITY_Pos (0UL) /*!< field CLR_ACTIVITY (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_ACTIVITY_CLR_ACTIVITY_Msk (0x00000001UL) /*!< field CLR_ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_ACTIVITY_RSVD_IC_CLR_ACTIVITY_Pos (1UL) /*!< field RSVD_IC_CLR_ACTIVITY (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_ACTIVITY_RSVD_IC_CLR_ACTIVITY_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_ACTIVITY (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_STOP_DET ================================================ */
#define I2C_IC_CLR_STOP_DET_CLR_STOP_DET_Pos (0UL) /*!< field CLR_STOP_DET (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_STOP_DET_CLR_STOP_DET_Msk (0x00000001UL) /*!< field CLR_STOP_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_STOP_DET_RSVD_IC_CLR_STOP_DET_Pos (1UL) /*!< field RSVD_IC_CLR_STOP_DET (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_STOP_DET_RSVD_IC_CLR_STOP_DET_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_STOP_DET (Bitfield-Mask: 0x7fffffff) */

/* ================================================ Register IC_CLR_START_DET ================================================ */
#define I2C_IC_CLR_START_DET_CLR_START_DET_Pos (0UL) /*!< field CLR_START_DET (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_START_DET_CLR_START_DET_Msk (0x00000001UL) /*!< field CLR_START_DET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_START_DET_RSVD_IC_CLR_START_DET_Pos (1UL) /*!< field RSVD_IC_CLR_START_DET (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_START_DET_RSVD_IC_CLR_START_DET_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_START_DET (Bitfield-Mask: 0x7fffffff) */

/* ================================================= Register IC_CLR_GEN_CALL ================================================ */
#define I2C_IC_CLR_GEN_CALL_CLR_GEN_CALL_Pos (0UL) /*!< field CLR_GEN_CALL (bitOffset 0, bitWidth 1) */
#define I2C_IC_CLR_GEN_CALL_CLR_GEN_CALL_Msk (0x00000001UL) /*!< field CLR_GEN_CALL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_CLR_GEN_CALL_RSVD_IC_CLR_GEN_CALL_Pos (1UL) /*!< field RSVD_IC_CLR_GEN_CALL (bitOffset 1, bitWidth 31) */
#define I2C_IC_CLR_GEN_CALL_RSVD_IC_CLR_GEN_CALL_Msk (0xfffffffeUL) /*!< field RSVD_IC_CLR_GEN_CALL (Bitfield-Mask: 0x7fffffff) */

/* ==================================================== Register IC_ENABLE =================================================== */
#define I2C_IC_ENABLE_ENABLE_Pos (0UL) /*!< field ENABLE (bitOffset 0, bitWidth 1) */
#define I2C_IC_ENABLE_ENABLE_Msk (0x00000001UL) /*!< field ENABLE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_ABORT_Pos (1UL) /*!< field ABORT (bitOffset 1, bitWidth 1) */
#define I2C_IC_ENABLE_ABORT_Msk (0x00000002UL) /*!< field ABORT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_TX_CMD_BLOCK_Pos (2UL) /*!< field TX_CMD_BLOCK (bitOffset 2, bitWidth 1) */
#define I2C_IC_ENABLE_TX_CMD_BLOCK_Msk (0x00000004UL) /*!< field TX_CMD_BLOCK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_RSVD_SDA_STUCK_RECOVERY_ENABLE_Pos (3UL) /*!< field RSVD_SDA_STUCK_RECOVERY_ENABLE (bitOffset 3, bitWidth 1) */
#define I2C_IC_ENABLE_RSVD_SDA_STUCK_RECOVERY_ENABLE_Msk (0x00000008UL) /*!< field RSVD_SDA_STUCK_RECOVERY_ENABLE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_RSVD_IC_ENABLE_1_Pos (4UL) /*!< field RSVD_IC_ENABLE_1 (bitOffset 4, bitWidth 12) */
#define I2C_IC_ENABLE_RSVD_IC_ENABLE_1_Msk (0x0000fff0UL) /*!< field RSVD_IC_ENABLE_1 (Bitfield-Mask: 0x00000fff) */
#define I2C_IC_ENABLE_RSVD_SMBUS_CLK_RESET_Pos (16UL) /*!< field RSVD_SMBUS_CLK_RESET (bitOffset 16, bitWidth 1) */
#define I2C_IC_ENABLE_RSVD_SMBUS_CLK_RESET_Msk (0x00010000UL) /*!< field RSVD_SMBUS_CLK_RESET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_RSVD_SMBUS_SUSPEND_EN_Pos (17UL) /*!< field RSVD_SMBUS_SUSPEND_EN (bitOffset 17, bitWidth 1) */
#define I2C_IC_ENABLE_RSVD_SMBUS_SUSPEND_EN_Msk (0x00020000UL) /*!< field RSVD_SMBUS_SUSPEND_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_RSVD_SMBUS_ALERT_EN_Pos (18UL) /*!< field RSVD_SMBUS_ALERT_EN (bitOffset 18, bitWidth 1) */
#define I2C_IC_ENABLE_RSVD_SMBUS_ALERT_EN_Msk (0x00040000UL) /*!< field RSVD_SMBUS_ALERT_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_RSVD_IC_ENABLE_2_Pos (19UL) /*!< field RSVD_IC_ENABLE_2 (bitOffset 19, bitWidth 13) */
#define I2C_IC_ENABLE_RSVD_IC_ENABLE_2_Msk (0xfff80000UL) /*!< field RSVD_IC_ENABLE_2 (Bitfield-Mask: 0x00001fff) */

/* ==================================================== Register IC_STATUS =================================================== */
#define I2C_IC_STATUS_ACTIVITY_Pos (0UL) /*!< field ACTIVITY (bitOffset 0, bitWidth 1) */
#define I2C_IC_STATUS_ACTIVITY_Msk (0x00000001UL) /*!< field ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_TFNF_Pos (1UL) /*!< field TFNF (bitOffset 1, bitWidth 1) */
#define I2C_IC_STATUS_TFNF_Msk (0x00000002UL) /*!< field TFNF (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_TFE_Pos (2UL) /*!< field TFE (bitOffset 2, bitWidth 1) */
#define I2C_IC_STATUS_TFE_Msk (0x00000004UL) /*!< field TFE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RFNE_Pos (3UL) /*!< field RFNE (bitOffset 3, bitWidth 1) */
#define I2C_IC_STATUS_RFNE_Msk (0x00000008UL) /*!< field RFNE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RFF_Pos (4UL) /*!< field RFF (bitOffset 4, bitWidth 1) */
#define I2C_IC_STATUS_RFF_Msk (0x00000010UL) /*!< field RFF (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_MST_ACTIVITY_Pos (5UL) /*!< field MST_ACTIVITY (bitOffset 5, bitWidth 1) */
#define I2C_IC_STATUS_MST_ACTIVITY_Msk (0x00000020UL) /*!< field MST_ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_SLV_ACTIVITY_Pos (6UL) /*!< field SLV_ACTIVITY (bitOffset 6, bitWidth 1) */
#define I2C_IC_STATUS_SLV_ACTIVITY_Msk (0x00000040UL) /*!< field SLV_ACTIVITY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_MST_HOLD_TX_FIFO_EMPTY_Pos (7UL) /*!< field RSVD_MST_HOLD_TX_FIFO_EMPTY (bitOffset 7, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_MST_HOLD_TX_FIFO_EMPTY_Msk (0x00000080UL) /*!< field RSVD_MST_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_MST_HOLD_RX_FIFO_FULL_Pos (8UL) /*!< field RSVD_MST_HOLD_RX_FIFO_FULL (bitOffset 8, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_MST_HOLD_RX_FIFO_FULL_Msk (0x00000100UL) /*!< field RSVD_MST_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SLV_HOLD_TX_FIFO_EMPTY_Pos (9UL) /*!< field RSVD_SLV_HOLD_TX_FIFO_EMPTY (bitOffset 9, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SLV_HOLD_TX_FIFO_EMPTY_Msk (0x00000200UL) /*!< field RSVD_SLV_HOLD_TX_FIFO_EMPTY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SLV_HOLD_RX_FIFO_FULL_Pos (10UL) /*!< field RSVD_SLV_HOLD_RX_FIFO_FULL (bitOffset 10, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SLV_HOLD_RX_FIFO_FULL_Msk (0x00000400UL) /*!< field RSVD_SLV_HOLD_RX_FIFO_FULL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SDA_STUCK_NOT_RECOVERED_Pos (11UL) /*!< field RSVD_SDA_STUCK_NOT_RECOVERED (bitOffset 11, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SDA_STUCK_NOT_RECOVERED_Msk (0x00000800UL) /*!< field RSVD_SDA_STUCK_NOT_RECOVERED (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_IC_STATUS_1_Pos (12UL) /*!< field RSVD_IC_STATUS_1 (bitOffset 12, bitWidth 4) */
#define I2C_IC_STATUS_RSVD_IC_STATUS_1_Msk (0x0000f000UL) /*!< field RSVD_IC_STATUS_1 (Bitfield-Mask: 0x0000000f) */
#define I2C_IC_STATUS_RSVD_SMBUS_QUICK_CMD_BIT_Pos (16UL) /*!< field RSVD_SMBUS_QUICK_CMD_BIT (bitOffset 16, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SMBUS_QUICK_CMD_BIT_Msk (0x00010000UL) /*!< field RSVD_SMBUS_QUICK_CMD_BIT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SMBUS_SLAVE_ADDR_VALID_Pos (17UL) /*!< field RSVD_SMBUS_SLAVE_ADDR_VALID (bitOffset 17, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SMBUS_SLAVE_ADDR_VALID_Msk (0x00020000UL) /*!< field RSVD_SMBUS_SLAVE_ADDR_VALID (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SMBUS_SLAVE_ADDR_RESOLVED_Pos (18UL) /*!< field RSVD_SMBUS_SLAVE_ADDR_RESOLVED (bitOffset 18, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SMBUS_SLAVE_ADDR_RESOLVED_Msk (0x00040000UL) /*!< field RSVD_SMBUS_SLAVE_ADDR_RESOLVED (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SMBUS_SUSPEND_STATUS_Pos (19UL) /*!< field RSVD_SMBUS_SUSPEND_STATUS (bitOffset 19, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SMBUS_SUSPEND_STATUS_Msk (0x00080000UL) /*!< field RSVD_SMBUS_SUSPEND_STATUS (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_SMBUS_ALERT_STATUS_Pos (20UL) /*!< field RSVD_SMBUS_ALERT_STATUS (bitOffset 20, bitWidth 1) */
#define I2C_IC_STATUS_RSVD_SMBUS_ALERT_STATUS_Msk (0x00100000UL) /*!< field RSVD_SMBUS_ALERT_STATUS (Bitfield-Mask: 0x00000001) */
#define I2C_IC_STATUS_RSVD_IC_STATUS_2_Pos (21UL) /*!< field RSVD_IC_STATUS_2 (bitOffset 21, bitWidth 11) */
#define I2C_IC_STATUS_RSVD_IC_STATUS_2_Msk (0xffe00000UL) /*!< field RSVD_IC_STATUS_2 (Bitfield-Mask: 0x000007ff) */

/* ==================================================== Register IC_TXFLR ==================================================== */
#define I2C_IC_TXFLR_TXFLR_Pos (0UL) /*!< field TXFLR (bitOffset 0, bitWidth 4) */
#define I2C_IC_TXFLR_TXFLR_Msk (0x0000000fUL) /*!< field TXFLR (Bitfield-Mask: 0x0000000f) */
#define I2C_IC_TXFLR_RSVD_TXFLR_Pos (4UL) /*!< field RSVD_TXFLR (bitOffset 4, bitWidth 28) */
#define I2C_IC_TXFLR_RSVD_TXFLR_Msk (0xfffffff0UL) /*!< field RSVD_TXFLR (Bitfield-Mask: 0x0fffffff) */

/* ==================================================== Register IC_RXFLR ==================================================== */
#define I2C_IC_RXFLR_RXFLR_Pos (0UL) /*!< field RXFLR (bitOffset 0, bitWidth 4) */
#define I2C_IC_RXFLR_RXFLR_Msk (0x0000000fUL) /*!< field RXFLR (Bitfield-Mask: 0x0000000f) */
#define I2C_IC_RXFLR_RSVD_RXFLR_Pos (4UL) /*!< field RSVD_RXFLR (bitOffset 4, bitWidth 28) */
#define I2C_IC_RXFLR_RSVD_RXFLR_Msk (0xfffffff0UL) /*!< field RSVD_RXFLR (Bitfield-Mask: 0x0fffffff) */

/* =================================================== Register IC_SDA_HOLD ================================================== */
#define I2C_IC_SDA_HOLD_IC_SDA_TX_HOLD_Pos (0UL) /*!< field IC_SDA_TX_HOLD (bitOffset 0, bitWidth 16) */
#define I2C_IC_SDA_HOLD_IC_SDA_TX_HOLD_Msk (0x0000ffffUL) /*!< field IC_SDA_TX_HOLD (Bitfield-Mask: 0x0000ffff) */
#define I2C_IC_SDA_HOLD_IC_SDA_RX_HOLD_Pos (16UL) /*!< field IC_SDA_RX_HOLD (bitOffset 16, bitWidth 8) */
#define I2C_IC_SDA_HOLD_IC_SDA_RX_HOLD_Msk (0x00ff0000UL) /*!< field IC_SDA_RX_HOLD (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_SDA_HOLD_RSVD_IC_SDA_HOLD_Pos (24UL) /*!< field RSVD_IC_SDA_HOLD (bitOffset 24, bitWidth 8) */
#define I2C_IC_SDA_HOLD_RSVD_IC_SDA_HOLD_Msk (0xff000000UL) /*!< field RSVD_IC_SDA_HOLD (Bitfield-Mask: 0x000000ff) */

/* ================================================ Register IC_TX_ABRT_SOURCE =============================================== */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_Pos (0UL) /*!< field ABRT_7B_ADDR_NOACK (bitOffset 0, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_7B_ADDR_NOACK_Msk (0x00000001UL) /*!< field ABRT_7B_ADDR_NOACK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_Pos (1UL) /*!< field ABRT_10ADDR1_NOACK (bitOffset 1, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10ADDR1_NOACK_Msk (0x00000002UL) /*!< field ABRT_10ADDR1_NOACK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_Pos (2UL) /*!< field ABRT_10ADDR2_NOACK (bitOffset 2, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10ADDR2_NOACK_Msk (0x00000004UL) /*!< field ABRT_10ADDR2_NOACK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_Pos (3UL) /*!< field ABRT_TXDATA_NOACK (bitOffset 3, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_TXDATA_NOACK_Msk (0x00000008UL) /*!< field ABRT_TXDATA_NOACK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_Pos (4UL) /*!< field ABRT_GCALL_NOACK (bitOffset 4, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_GCALL_NOACK_Msk (0x00000010UL) /*!< field ABRT_GCALL_NOACK (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_Pos (5UL) /*!< field ABRT_GCALL_READ (bitOffset 5, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_GCALL_READ_Msk (0x00000020UL) /*!< field ABRT_GCALL_READ (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_Pos (6UL) /*!< field ABRT_HS_ACKDET (bitOffset 6, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_HS_ACKDET_Msk (0x00000040UL) /*!< field ABRT_HS_ACKDET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_Pos (7UL) /*!< field ABRT_SBYTE_ACKDET (bitOffset 7, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SBYTE_ACKDET_Msk (0x00000080UL) /*!< field ABRT_SBYTE_ACKDET (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_Pos (8UL) /*!< field ABRT_HS_NORSTRT (bitOffset 8, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_HS_NORSTRT_Msk (0x00000100UL) /*!< field ABRT_HS_NORSTRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_Pos (9UL) /*!< field ABRT_SBYTE_NORSTRT (bitOffset 9, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SBYTE_NORSTRT_Msk (0x00000200UL) /*!< field ABRT_SBYTE_NORSTRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_Pos (10UL) /*!< field ABRT_10B_RD_NORSTRT (bitOffset 10, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_10B_RD_NORSTRT_Msk (0x00000400UL) /*!< field ABRT_10B_RD_NORSTRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_Pos (11UL) /*!< field ABRT_MASTER_DIS (bitOffset 11, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_MASTER_DIS_Msk (0x00000800UL) /*!< field ABRT_MASTER_DIS (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ARB_LOST_Pos (12UL) /*!< field ARB_LOST (bitOffset 12, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ARB_LOST_Msk (0x00001000UL) /*!< field ARB_LOST (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_Pos (13UL) /*!< field ABRT_SLVFLUSH_TXFIFO (bitOffset 13, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLVFLUSH_TXFIFO_Msk (0x00002000UL) /*!< field ABRT_SLVFLUSH_TXFIFO (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_Pos (14UL) /*!< field ABRT_SLV_ARBLOST (bitOffset 14, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLV_ARBLOST_Msk (0x00004000UL) /*!< field ABRT_SLV_ARBLOST (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_Pos (15UL) /*!< field ABRT_SLVRD_INTX (bitOffset 15, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_SLVRD_INTX_Msk (0x00008000UL) /*!< field ABRT_SLVRD_INTX (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_Pos (16UL) /*!< field ABRT_USER_ABRT (bitOffset 16, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_ABRT_USER_ABRT_Msk (0x00010000UL) /*!< field ABRT_USER_ABRT (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_ABRT_SDA_STUCK_AT_LOW_Pos (17UL) /*!< field RSVD_ABRT_SDA_STUCK_AT_LOW (bitOffset 17, bitWidth 1) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_ABRT_SDA_STUCK_AT_LOW_Msk (0x00020000UL) /*!< field RSVD_ABRT_SDA_STUCK_AT_LOW (Bitfield-Mask: 0x00000001) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_ABRT_DEVICE_WRITE_Pos (18UL) /*!< field RSVD_ABRT_DEVICE_WRITE (bitOffset 18, bitWidth 3) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_ABRT_DEVICE_WRITE_Msk (0x001c0000UL) /*!< field RSVD_ABRT_DEVICE_WRITE (Bitfield-Mask: 0x00000007) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_IC_TX_ABRT_SOURCE_Pos (21UL) /*!< field RSVD_IC_TX_ABRT_SOURCE (bitOffset 21, bitWidth 2) */
#define I2C_IC_TX_ABRT_SOURCE_RSVD_IC_TX_ABRT_SOURCE_Msk (0x00600000UL) /*!< field RSVD_IC_TX_ABRT_SOURCE (Bitfield-Mask: 0x00000003) */
#define I2C_IC_TX_ABRT_SOURCE_TX_FLUSH_CNT_Pos (23UL) /*!< field TX_FLUSH_CNT (bitOffset 23, bitWidth 9) */
#define I2C_IC_TX_ABRT_SOURCE_TX_FLUSH_CNT_Msk (0xff800000UL) /*!< field TX_FLUSH_CNT (Bitfield-Mask: 0x000001ff) */

/* ==================================================== Register IC_DMA_CR =================================================== */
#define I2C_IC_DMA_CR_RDMAE_Pos (0UL) /*!< field RDMAE (bitOffset 0, bitWidth 1) */
#define I2C_IC_DMA_CR_RDMAE_Msk (0x00000001UL) /*!< field RDMAE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DMA_CR_TDMAE_Pos (1UL) /*!< field TDMAE (bitOffset 1, bitWidth 1) */
#define I2C_IC_DMA_CR_TDMAE_Msk (0x00000002UL) /*!< field TDMAE (Bitfield-Mask: 0x00000001) */
#define I2C_IC_DMA_CR_RSVD_IC_DMA_CR_2_31_Pos (2UL) /*!< field RSVD_IC_DMA_CR_2_31 (bitOffset 2, bitWidth 30) */
#define I2C_IC_DMA_CR_RSVD_IC_DMA_CR_2_31_Msk (0xfffffffcUL) /*!< field RSVD_IC_DMA_CR_2_31 (Bitfield-Mask: 0x3fffffff) */

/* =================================================== Register IC_DMA_TDLR ================================================== */
#define I2C_IC_DMA_TDLR_DMATDL_Pos (0UL) /*!< field DMATDL (bitOffset 0, bitWidth 3) */
#define I2C_IC_DMA_TDLR_DMATDL_Msk (0x00000007UL) /*!< field DMATDL (Bitfield-Mask: 0x00000007) */
#define I2C_IC_DMA_TDLR_RSVD_DMA_TDLR_Pos (3UL) /*!< field RSVD_DMA_TDLR (bitOffset 3, bitWidth 29) */
#define I2C_IC_DMA_TDLR_RSVD_DMA_TDLR_Msk (0xfffffff8UL) /*!< field RSVD_DMA_TDLR (Bitfield-Mask: 0x1fffffff) */

/* =================================================== Register IC_DMA_RDLR ================================================== */
#define I2C_IC_DMA_RDLR_DMARDL_Pos (0UL) /*!< field DMARDL (bitOffset 0, bitWidth 3) */
#define I2C_IC_DMA_RDLR_DMARDL_Msk (0x00000007UL) /*!< field DMARDL (Bitfield-Mask: 0x00000007) */
#define I2C_IC_DMA_RDLR_RSVD_DMA_RDLR_Pos (3UL) /*!< field RSVD_DMA_RDLR (bitOffset 3, bitWidth 29) */
#define I2C_IC_DMA_RDLR_RSVD_DMA_RDLR_Msk (0xfffffff8UL) /*!< field RSVD_DMA_RDLR (Bitfield-Mask: 0x1fffffff) */

/* ================================================== Register IC_SDA_SETUP ================================================== */
#define I2C_IC_SDA_SETUP_SDA_SETUP_Pos (0UL) /*!< field SDA_SETUP (bitOffset 0, bitWidth 8) */
#define I2C_IC_SDA_SETUP_SDA_SETUP_Msk (0x000000ffUL) /*!< field SDA_SETUP (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_SDA_SETUP_RSVD_IC_SDA_SETUP_Pos (8UL) /*!< field RSVD_IC_SDA_SETUP (bitOffset 8, bitWidth 24) */
#define I2C_IC_SDA_SETUP_RSVD_IC_SDA_SETUP_Msk (0xffffff00UL) /*!< field RSVD_IC_SDA_SETUP (Bitfield-Mask: 0x00ffffff) */

/* =============================================== Register IC_ACK_GENERAL_CALL ============================================== */
#define I2C_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_Pos (0UL) /*!< field ACK_GEN_CALL (bitOffset 0, bitWidth 1) */
#define I2C_IC_ACK_GENERAL_CALL_ACK_GEN_CALL_Msk (0x00000001UL) /*!< field ACK_GEN_CALL (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ACK_GENERAL_CALL_RSVD_IC_ACK_GEN_1_31_Pos (1UL) /*!< field RSVD_IC_ACK_GEN_1_31 (bitOffset 1, bitWidth 31) */
#define I2C_IC_ACK_GENERAL_CALL_RSVD_IC_ACK_GEN_1_31_Msk (0xfffffffeUL) /*!< field RSVD_IC_ACK_GEN_1_31 (Bitfield-Mask: 0x7fffffff) */

/* ================================================ Register IC_ENABLE_STATUS ================================================ */
#define I2C_IC_ENABLE_STATUS_IC_EN_Pos (0UL) /*!< field IC_EN (bitOffset 0, bitWidth 1) */
#define I2C_IC_ENABLE_STATUS_IC_EN_Msk (0x00000001UL) /*!< field IC_EN (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_Pos (1UL) /*!< field SLV_DISABLED_WHILE_BUSY (bitOffset 1, bitWidth 1) */
#define I2C_IC_ENABLE_STATUS_SLV_DISABLED_WHILE_BUSY_Msk (0x00000002UL) /*!< field SLV_DISABLED_WHILE_BUSY (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_Pos (2UL) /*!< field SLV_RX_DATA_LOST (bitOffset 2, bitWidth 1) */
#define I2C_IC_ENABLE_STATUS_SLV_RX_DATA_LOST_Msk (0x00000004UL) /*!< field SLV_RX_DATA_LOST (Bitfield-Mask: 0x00000001) */
#define I2C_IC_ENABLE_STATUS_RSVD_IC_ENABLE_STATUS_Pos (3UL) /*!< field RSVD_IC_ENABLE_STATUS (bitOffset 3, bitWidth 29) */
#define I2C_IC_ENABLE_STATUS_RSVD_IC_ENABLE_STATUS_Msk (0xfffffff8UL) /*!< field RSVD_IC_ENABLE_STATUS (Bitfield-Mask: 0x1fffffff) */

/* ================================================== Register IC_FS_SPKLEN ================================================== */
#define I2C_IC_FS_SPKLEN_IC_FS_SPKLEN_Pos (0UL) /*!< field IC_FS_SPKLEN (bitOffset 0, bitWidth 8) */
#define I2C_IC_FS_SPKLEN_IC_FS_SPKLEN_Msk (0x000000ffUL) /*!< field IC_FS_SPKLEN (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_FS_SPKLEN_RSVD_IC_FS_SPKLEN_Pos (8UL) /*!< field RSVD_IC_FS_SPKLEN (bitOffset 8, bitWidth 24) */
#define I2C_IC_FS_SPKLEN_RSVD_IC_FS_SPKLEN_Msk (0xffffff00UL) /*!< field RSVD_IC_FS_SPKLEN (Bitfield-Mask: 0x00ffffff) */

/* ================================================== Register IC_HS_SPKLEN ================================================== */
#define I2C_IC_HS_SPKLEN_IC_HS_SPKLEN_Pos (0UL) /*!< field IC_HS_SPKLEN (bitOffset 0, bitWidth 8) */
#define I2C_IC_HS_SPKLEN_IC_HS_SPKLEN_Msk (0x000000ffUL) /*!< field IC_HS_SPKLEN (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_HS_SPKLEN_RSVD_IC_HS_SPKLEN_Pos (8UL) /*!< field RSVD_IC_HS_SPKLEN (bitOffset 8, bitWidth 24) */
#define I2C_IC_HS_SPKLEN_RSVD_IC_HS_SPKLEN_Msk (0xffffff00UL) /*!< field RSVD_IC_HS_SPKLEN (Bitfield-Mask: 0x00ffffff) */

/* ================================================= Register IC_COMP_PARAM_1 ================================================ */
#define I2C_IC_COMP_PARAM_1_APB_DATA_WIDTH_Pos (0UL) /*!< field APB_DATA_WIDTH (bitOffset 0, bitWidth 2) */
#define I2C_IC_COMP_PARAM_1_APB_DATA_WIDTH_Msk (0x00000003UL) /*!< field APB_DATA_WIDTH (Bitfield-Mask: 0x00000003) */
#define I2C_IC_COMP_PARAM_1_MAX_SPEED_MODE_Pos (2UL) /*!< field MAX_SPEED_MODE (bitOffset 2, bitWidth 2) */
#define I2C_IC_COMP_PARAM_1_MAX_SPEED_MODE_Msk (0x0000000cUL) /*!< field MAX_SPEED_MODE (Bitfield-Mask: 0x00000003) */
#define I2C_IC_COMP_PARAM_1_HC_COUNT_VALUES_Pos (4UL) /*!< field HC_COUNT_VALUES (bitOffset 4, bitWidth 1) */
#define I2C_IC_COMP_PARAM_1_HC_COUNT_VALUES_Msk (0x00000010UL) /*!< field HC_COUNT_VALUES (Bitfield-Mask: 0x00000001) */
#define I2C_IC_COMP_PARAM_1_INTR_IO_Pos (5UL) /*!< field INTR_IO (bitOffset 5, bitWidth 1) */
#define I2C_IC_COMP_PARAM_1_INTR_IO_Msk (0x00000020UL) /*!< field INTR_IO (Bitfield-Mask: 0x00000001) */
#define I2C_IC_COMP_PARAM_1_HAS_DMA_Pos (6UL) /*!< field HAS_DMA (bitOffset 6, bitWidth 1) */
#define I2C_IC_COMP_PARAM_1_HAS_DMA_Msk (0x00000040UL) /*!< field HAS_DMA (Bitfield-Mask: 0x00000001) */
#define I2C_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS_Pos (7UL) /*!< field ADD_ENCODED_PARAMS (bitOffset 7, bitWidth 1) */
#define I2C_IC_COMP_PARAM_1_ADD_ENCODED_PARAMS_Msk (0x00000080UL) /*!< field ADD_ENCODED_PARAMS (Bitfield-Mask: 0x00000001) */
#define I2C_IC_COMP_PARAM_1_RX_BUFFER_DEPTH_Pos (8UL) /*!< field RX_BUFFER_DEPTH (bitOffset 8, bitWidth 8) */
#define I2C_IC_COMP_PARAM_1_RX_BUFFER_DEPTH_Msk (0x0000ff00UL) /*!< field RX_BUFFER_DEPTH (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_COMP_PARAM_1_TX_BUFFER_DEPTH_Pos (16UL) /*!< field TX_BUFFER_DEPTH (bitOffset 16, bitWidth 8) */
#define I2C_IC_COMP_PARAM_1_TX_BUFFER_DEPTH_Msk (0x00ff0000UL) /*!< field TX_BUFFER_DEPTH (Bitfield-Mask: 0x000000ff) */
#define I2C_IC_COMP_PARAM_1_RSVD_IC_COMP_PARAM_1_Pos (24UL) /*!< field RSVD_IC_COMP_PARAM_1 (bitOffset 24, bitWidth 8) */
#define I2C_IC_COMP_PARAM_1_RSVD_IC_COMP_PARAM_1_Msk (0xff000000UL) /*!< field RSVD_IC_COMP_PARAM_1 (Bitfield-Mask: 0x000000ff) */

/* ================================================= Register IC_COMP_VERSION ================================================ */
#define I2C_IC_COMP_VERSION_IC_COMP_VERSION_Pos (0UL) /*!< field IC_COMP_VERSION (bitOffset 0, bitWidth 32) */
#define I2C_IC_COMP_VERSION_IC_COMP_VERSION_Msk (0xffffffffUL) /*!< field IC_COMP_VERSION (Bitfield-Mask: 0xffffffff) */

/* ================================================== Register IC_COMP_TYPE ================================================== */
#define I2C_IC_COMP_TYPE_IC_COMP_TYPE_Pos (0UL) /*!< field IC_COMP_TYPE (bitOffset 0, bitWidth 32) */
#define I2C_IC_COMP_TYPE_IC_COMP_TYPE_Msk (0xffffffffUL) /*!< field IC_COMP_TYPE (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: I2S ================================================= */
/* =========================================================================================================================== */

/* ======================================================= Register IER ====================================================== */
#define I2S_IER_IEN_Pos (0UL) /*!< field IEN (bitOffset 0, bitWidth 1) */
#define I2S_IER_IEN_Msk (0x00000001UL) /*!< field IEN (Bitfield-Mask: 0x00000001) */
#define I2S_IER_RSVD_IER_Pos (1UL) /*!< field RSVD_IER (bitOffset 1, bitWidth 31) */
#define I2S_IER_RSVD_IER_Msk (0xfffffffeUL) /*!< field RSVD_IER (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register ITER ====================================================== */
#define I2S_ITER_TXEN_Pos (0UL) /*!< field TXEN (bitOffset 0, bitWidth 1) */
#define I2S_ITER_TXEN_Msk (0x00000001UL) /*!< field TXEN (Bitfield-Mask: 0x00000001) */
#define I2S_ITER_RSVD_ITER_Pos (1UL) /*!< field RSVD_ITER (bitOffset 1, bitWidth 31) */
#define I2S_ITER_RSVD_ITER_Msk (0xfffffffeUL) /*!< field RSVD_ITER (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register CER ====================================================== */
#define I2S_CER_CLKEN_Pos (0UL) /*!< field CLKEN (bitOffset 0, bitWidth 1) */
#define I2S_CER_CLKEN_Msk (0x00000001UL) /*!< field CLKEN (Bitfield-Mask: 0x00000001) */
#define I2S_CER_RSVD_CER_Pos (1UL) /*!< field RSVD_CER (bitOffset 1, bitWidth 31) */
#define I2S_CER_RSVD_CER_Msk (0xfffffffeUL) /*!< field RSVD_CER (Bitfield-Mask: 0x7fffffff) */

/* ======================================================= Register CCR ====================================================== */
#define I2S_CCR_SCLKG_Pos (0UL) /*!< field SCLKG (bitOffset 0, bitWidth 3) */
#define I2S_CCR_SCLKG_Msk (0x00000007UL) /*!< field SCLKG (Bitfield-Mask: 0x00000007) */
#define I2S_CCR_WSS_Pos (3UL) /*!< field WSS (bitOffset 3, bitWidth 2) */
#define I2S_CCR_WSS_Msk (0x00000018UL) /*!< field WSS (Bitfield-Mask: 0x00000003) */
#define I2S_CCR_RSVD_CCR_Pos (5UL) /*!< field RSVD_CCR (bitOffset 5, bitWidth 27) */
#define I2S_CCR_RSVD_CCR_Msk (0xffffffe0UL) /*!< field RSVD_CCR (Bitfield-Mask: 0x07ffffff) */

/* ====================================================== Register TXFFR ===================================================== */
#define I2S_TXFFR_TXFFR_Pos (0UL) /*!< field TXFFR (bitOffset 0, bitWidth 1) */
#define I2S_TXFFR_TXFFR_Msk (0x00000001UL) /*!< field TXFFR (Bitfield-Mask: 0x00000001) */
#define I2S_TXFFR_RSVD_TXFFR_Pos (1UL) /*!< field RSVD_TXFFR (bitOffset 1, bitWidth 31) */
#define I2S_TXFFR_RSVD_TXFFR_Msk (0xfffffffeUL) /*!< field RSVD_TXFFR (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register LTHR0 ===================================================== */
#define I2S_LTHR0_LTHR0_Pos (0UL) /*!< field LTHR0 (bitOffset 0, bitWidth 32) */
#define I2S_LTHR0_LTHR0_Msk (0xffffffffUL) /*!< field LTHR0 (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register RTHR0 ===================================================== */
#define I2S_RTHR0_RTHR0_Pos (0UL) /*!< field RTHR0 (bitOffset 0, bitWidth 32) */
#define I2S_RTHR0_RTHR0_Msk (0xffffffffUL) /*!< field RTHR0 (Bitfield-Mask: 0xffffffff) */

/* ====================================================== Register TER0 ====================================================== */
#define I2S_TER0_TXCHENX_Pos (0UL) /*!< field TXCHENX (bitOffset 0, bitWidth 1) */
#define I2S_TER0_TXCHENX_Msk (0x00000001UL) /*!< field TXCHENX (Bitfield-Mask: 0x00000001) */
#define I2S_TER0_RSVD_TERX_Pos (1UL) /*!< field RSVD_TERX (bitOffset 1, bitWidth 31) */
#define I2S_TER0_RSVD_TERX_Msk (0xfffffffeUL) /*!< field RSVD_TERX (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register TCR0 ====================================================== */
#define I2S_TCR0_WLEN_Pos (0UL) /*!< field WLEN (bitOffset 0, bitWidth 3) */
#define I2S_TCR0_WLEN_Msk (0x00000007UL) /*!< field WLEN (Bitfield-Mask: 0x00000007) */
#define I2S_TCR0_RSVD_TCRX_Pos (3UL) /*!< field RSVD_TCRX (bitOffset 3, bitWidth 29) */
#define I2S_TCR0_RSVD_TCRX_Msk (0xfffffff8UL) /*!< field RSVD_TCRX (Bitfield-Mask: 0x1fffffff) */

/* ====================================================== Register ISR0 ====================================================== */
#define I2S_ISR0_RSVD_RXDA_Pos (0UL) /*!< field RSVD_RXDA (bitOffset 0, bitWidth 1) */
#define I2S_ISR0_RSVD_RXDA_Msk (0x00000001UL) /*!< field RSVD_RXDA (Bitfield-Mask: 0x00000001) */
#define I2S_ISR0_RSVD_RXFO_Pos (1UL) /*!< field RSVD_RXFO (bitOffset 1, bitWidth 1) */
#define I2S_ISR0_RSVD_RXFO_Msk (0x00000002UL) /*!< field RSVD_RXFO (Bitfield-Mask: 0x00000001) */
#define I2S_ISR0_RSVD3_2_Pos (2UL) /*!< field RSVD3_2 (bitOffset 2, bitWidth 2) */
#define I2S_ISR0_RSVD3_2_Msk (0x0000000cUL) /*!< field RSVD3_2 (Bitfield-Mask: 0x00000003) */
#define I2S_ISR0_TXFE_Pos (4UL) /*!< field TXFE (bitOffset 4, bitWidth 1) */
#define I2S_ISR0_TXFE_Msk (0x00000010UL) /*!< field TXFE (Bitfield-Mask: 0x00000001) */
#define I2S_ISR0_TXFO_Pos (5UL) /*!< field TXFO (bitOffset 5, bitWidth 1) */
#define I2S_ISR0_TXFO_Msk (0x00000020UL) /*!< field TXFO (Bitfield-Mask: 0x00000001) */
#define I2S_ISR0_RSVD31_6_Pos (6UL) /*!< field RSVD31_6 (bitOffset 6, bitWidth 26) */
#define I2S_ISR0_RSVD31_6_Msk (0xffffffc0UL) /*!< field RSVD31_6 (Bitfield-Mask: 0x03ffffff) */

/* ====================================================== Register IMR0 ====================================================== */
#define I2S_IMR0_RXDAM_Pos (0UL) /*!< field RXDAM (bitOffset 0, bitWidth 1) */
#define I2S_IMR0_RXDAM_Msk (0x00000001UL) /*!< field RXDAM (Bitfield-Mask: 0x00000001) */
#define I2S_IMR0_RXFOM_Pos (1UL) /*!< field RXFOM (bitOffset 1, bitWidth 1) */
#define I2S_IMR0_RXFOM_Msk (0x00000002UL) /*!< field RXFOM (Bitfield-Mask: 0x00000001) */
#define I2S_IMR0_RSVD_IMR0_2_3_Pos (2UL) /*!< field RSVD_IMR0_2_3 (bitOffset 2, bitWidth 2) */
#define I2S_IMR0_RSVD_IMR0_2_3_Msk (0x0000000cUL) /*!< field RSVD_IMR0_2_3 (Bitfield-Mask: 0x00000003) */
#define I2S_IMR0_TXFEM_Pos (4UL) /*!< field TXFEM (bitOffset 4, bitWidth 1) */
#define I2S_IMR0_TXFEM_Msk (0x00000010UL) /*!< field TXFEM (Bitfield-Mask: 0x00000001) */
#define I2S_IMR0_TXFOM_Pos (5UL) /*!< field TXFOM (bitOffset 5, bitWidth 1) */
#define I2S_IMR0_TXFOM_Msk (0x00000020UL) /*!< field TXFOM (Bitfield-Mask: 0x00000001) */
#define I2S_IMR0_RSVD_IMR0_6_31_Pos (6UL) /*!< field RSVD_IMR0_6_31 (bitOffset 6, bitWidth 26) */
#define I2S_IMR0_RSVD_IMR0_6_31_Msk (0xffffffc0UL) /*!< field RSVD_IMR0_6_31 (Bitfield-Mask: 0x03ffffff) */

/* ====================================================== Register TOR0 ====================================================== */
#define I2S_TOR0_TXCHO_Pos (0UL) /*!< field TXCHO (bitOffset 0, bitWidth 1) */
#define I2S_TOR0_TXCHO_Msk (0x00000001UL) /*!< field TXCHO (Bitfield-Mask: 0x00000001) */
#define I2S_TOR0_RSVD_TORX_Pos (1UL) /*!< field RSVD_TORX (bitOffset 1, bitWidth 31) */
#define I2S_TOR0_RSVD_TORX_Msk (0xfffffffeUL) /*!< field RSVD_TORX (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register TFCR0 ===================================================== */
#define I2S_TFCR0_TXCHET_Pos (0UL) /*!< field TXCHET (bitOffset 0, bitWidth 4) */
#define I2S_TFCR0_TXCHET_Msk (0x0000000fUL) /*!< field TXCHET (Bitfield-Mask: 0x0000000f) */
#define I2S_TFCR0_RSVD_TFCRX_Pos (4UL) /*!< field RSVD_TFCRX (bitOffset 4, bitWidth 28) */
#define I2S_TFCR0_RSVD_TFCRX_Msk (0xfffffff0UL) /*!< field RSVD_TFCRX (Bitfield-Mask: 0x0fffffff) */

/* ====================================================== Register TFF0 ====================================================== */
#define I2S_TFF0_TXCHFR_Pos (0UL) /*!< field TXCHFR (bitOffset 0, bitWidth 1) */
#define I2S_TFF0_TXCHFR_Msk (0x00000001UL) /*!< field TXCHFR (Bitfield-Mask: 0x00000001) */
#define I2S_TFF0_RSVD_TFFX_Pos (1UL) /*!< field RSVD_TFFX (bitOffset 1, bitWidth 31) */
#define I2S_TFF0_RSVD_TFFX_Msk (0xfffffffeUL) /*!< field RSVD_TFFX (Bitfield-Mask: 0x7fffffff) */

/* ====================================================== Register TXDMA ===================================================== */
#define I2S_TXDMA_TXDMA_Pos (0UL) /*!< field TXDMA (bitOffset 0, bitWidth 32) */
#define I2S_TXDMA_TXDMA_Msk (0xffffffffUL) /*!< field TXDMA (Bitfield-Mask: 0xffffffff) */

/* ================================================ Register I2S_COMP_PARAM_2 ================================================ */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_0_Pos (0UL) /*!< field I2S_RX_WORDSIZE_0 (bitOffset 0, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_0_Msk (0x00000007UL) /*!< field I2S_RX_WORDSIZE_0 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_1_Pos (3UL) /*!< field I2S_RX_WORDSIZE_1 (bitOffset 3, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_1_Msk (0x00000038UL) /*!< field I2S_RX_WORDSIZE_1 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_2_RSVD_I2S_COMP_PARAM_2_6_Pos (6UL) /*!< field RSVD_I2S_COMP_PARAM_2_6 (bitOffset 6, bitWidth 1) */
#define I2S_I2S_COMP_PARAM_2_RSVD_I2S_COMP_PARAM_2_6_Msk (0x00000040UL) /*!< field RSVD_I2S_COMP_PARAM_2_6 (Bitfield-Mask: 0x00000001) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_2_Pos (7UL) /*!< field I2S_RX_WORDSIZE_2 (bitOffset 7, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_2_Msk (0x00000380UL) /*!< field I2S_RX_WORDSIZE_2 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_3_Pos (10UL) /*!< field I2S_RX_WORDSIZE_3 (bitOffset 10, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_2_I2S_RX_WORDSIZE_3_Msk (0x00001c00UL) /*!< field I2S_RX_WORDSIZE_3 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_2_RSVD_31_13_Pos (13UL) /*!< field RSVD_31_13 (bitOffset 13, bitWidth 19) */
#define I2S_I2S_COMP_PARAM_2_RSVD_31_13_Msk (0xffffe000UL) /*!< field RSVD_31_13 (Bitfield-Mask: 0x0007ffff) */

/* ================================================ Register I2S_COMP_PARAM_1 ================================================ */
#define I2S_I2S_COMP_PARAM_1_APB_DATA_WIDTH_Pos (0UL) /*!< field APB_DATA_WIDTH (bitOffset 0, bitWidth 2) */
#define I2S_I2S_COMP_PARAM_1_APB_DATA_WIDTH_Msk (0x00000003UL) /*!< field APB_DATA_WIDTH (Bitfield-Mask: 0x00000003) */
#define I2S_I2S_COMP_PARAM_1_I2S_FIFO_DEPTH_GLOBAL_Pos (2UL) /*!< field I2S_FIFO_DEPTH_GLOBAL (bitOffset 2, bitWidth 2) */
#define I2S_I2S_COMP_PARAM_1_I2S_FIFO_DEPTH_GLOBAL_Msk (0x0000000cUL) /*!< field I2S_FIFO_DEPTH_GLOBAL (Bitfield-Mask: 0x00000003) */
#define I2S_I2S_COMP_PARAM_1_I2S_MODE_EN_Pos (4UL) /*!< field I2S_MODE_EN (bitOffset 4, bitWidth 1) */
#define I2S_I2S_COMP_PARAM_1_I2S_MODE_EN_Msk (0x00000010UL) /*!< field I2S_MODE_EN (Bitfield-Mask: 0x00000001) */
#define I2S_I2S_COMP_PARAM_1_I2S_TRANSMITTER_BLOCK_Pos (5UL) /*!< field I2S_TRANSMITTER_BLOCK (bitOffset 5, bitWidth 1) */
#define I2S_I2S_COMP_PARAM_1_I2S_TRANSMITTER_BLOCK_Msk (0x00000020UL) /*!< field I2S_TRANSMITTER_BLOCK (Bitfield-Mask: 0x00000001) */
#define I2S_I2S_COMP_PARAM_1_I2S_RECEIVER_BLOCK_Pos (6UL) /*!< field I2S_RECEIVER_BLOCK (bitOffset 6, bitWidth 1) */
#define I2S_I2S_COMP_PARAM_1_I2S_RECEIVER_BLOCK_Msk (0x00000040UL) /*!< field I2S_RECEIVER_BLOCK (Bitfield-Mask: 0x00000001) */
#define I2S_I2S_COMP_PARAM_1_I2S_RX_CHANNELS_Pos (7UL) /*!< field I2S_RX_CHANNELS (bitOffset 7, bitWidth 2) */
#define I2S_I2S_COMP_PARAM_1_I2S_RX_CHANNELS_Msk (0x00000180UL) /*!< field I2S_RX_CHANNELS (Bitfield-Mask: 0x00000003) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_CHANNELS_Pos (9UL) /*!< field I2S_TX_CHANNELS (bitOffset 9, bitWidth 2) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_CHANNELS_Msk (0x00000600UL) /*!< field I2S_TX_CHANNELS (Bitfield-Mask: 0x00000003) */
#define I2S_I2S_COMP_PARAM_1_RSVD_PARAM_1_11_15_Pos (11UL) /*!< field RSVD_PARAM_1_11_15 (bitOffset 11, bitWidth 5) */
#define I2S_I2S_COMP_PARAM_1_RSVD_PARAM_1_11_15_Msk (0x0000f800UL) /*!< field RSVD_PARAM_1_11_15 (Bitfield-Mask: 0x0000001f) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_0_Pos (16UL) /*!< field I2S_TX_WORDSIZE_0 (bitOffset 16, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_0_Msk (0x00070000UL) /*!< field I2S_TX_WORDSIZE_0 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_1_Pos (19UL) /*!< field I2S_TX_WORDSIZE_1 (bitOffset 19, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_1_Msk (0x00380000UL) /*!< field I2S_TX_WORDSIZE_1 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_2_Pos (22UL) /*!< field I2S_TX_WORDSIZE_2 (bitOffset 22, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_2_Msk (0x01c00000UL) /*!< field I2S_TX_WORDSIZE_2 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_3_Pos (25UL) /*!< field I2S_TX_WORDSIZE_3 (bitOffset 25, bitWidth 3) */
#define I2S_I2S_COMP_PARAM_1_I2S_TX_WORDSIZE_3_Msk (0x0e000000UL) /*!< field I2S_TX_WORDSIZE_3 (Bitfield-Mask: 0x00000007) */
#define I2S_I2S_COMP_PARAM_1_RSVD_PARAM_1_28_31_Pos (28UL) /*!< field RSVD_PARAM_1_28_31 (bitOffset 28, bitWidth 4) */
#define I2S_I2S_COMP_PARAM_1_RSVD_PARAM_1_28_31_Msk (0xf0000000UL) /*!< field RSVD_PARAM_1_28_31 (Bitfield-Mask: 0x0000000f) */

/* ================================================ Register I2S_COMP_VERSION ================================================ */
#define I2S_I2S_COMP_VERSION_I2S_COMP_VERSION_Pos (0UL) /*!< field I2S_COMP_VERSION (bitOffset 0, bitWidth 32) */
#define I2S_I2S_COMP_VERSION_I2S_COMP_VERSION_Msk (0xffffffffUL) /*!< field I2S_COMP_VERSION (Bitfield-Mask: 0xffffffff) */

/* ================================================== Register I2S_COMP_TYPE ================================================= */
#define I2S_I2S_COMP_TYPE_I2S_COMP_TYPE_Pos (0UL) /*!< field I2S_COMP_TYPE (bitOffset 0, bitWidth 32) */
#define I2S_I2S_COMP_TYPE_I2S_COMP_TYPE_Msk (0xffffffffUL) /*!< field I2S_COMP_TYPE (Bitfield-Mask: 0xffffffff) */



/* =========================================================================================================================== */
/* ================================================= Type of peripheral: GPIO ================================================ */
/* =========================================================================================================================== */

/* ===================================================== Register DATA_IN ==================================================== */
#define GPIO_DATA_IN_DATA_Pos (0UL) /*!< field DATA (bitOffset 0, bitWidth 16) */
#define GPIO_DATA_IN_DATA_Msk (0x0000ffffUL) /*!< field DATA (Bitfield-Mask: 0x0000ffff) */

/* ==================================================== Register DATA_OUT ==================================================== */
#define GPIO_DATA_OUT_DATA_Pos (0UL) /*!< field DATA (bitOffset 0, bitWidth 16) */
#define GPIO_DATA_OUT_DATA_Msk (0x0000ffffUL) /*!< field DATA (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register OUT_EN_SET =================================================== */
#define GPIO_OUT_EN_SET_OUT_EN_SET_Pos (0UL) /*!< field OUT_EN_SET (bitOffset 0, bitWidth 16) */
#define GPIO_OUT_EN_SET_OUT_EN_SET_Msk (0x0000ffffUL) /*!< field OUT_EN_SET (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register OUT_EN_CLR =================================================== */
#define GPIO_OUT_EN_CLR_OUT_EN_CLR_Pos (0UL) /*!< field OUT_EN_CLR (bitOffset 0, bitWidth 16) */
#define GPIO_OUT_EN_CLR_OUT_EN_CLR_Msk (0x0000ffffUL) /*!< field OUT_EN_CLR (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INT_EN_SET =================================================== */
#define GPIO_INT_EN_SET_INT_EN_SET_Pos (0UL) /*!< field INT_EN_SET (bitOffset 0, bitWidth 16) */
#define GPIO_INT_EN_SET_INT_EN_SET_Msk (0x0000ffffUL) /*!< field INT_EN_SET (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INT_EN_CLR =================================================== */
#define GPIO_INT_EN_CLR_INT_EN_CLR_Pos (0UL) /*!< field INT_EN_CLR (bitOffset 0, bitWidth 16) */
#define GPIO_INT_EN_CLR_INT_EN_CLR_Msk (0x0000ffffUL) /*!< field INT_EN_CLR (Bitfield-Mask: 0x0000ffff) */

/* ================================================== Register INT_TYPE_SET ================================================== */
#define GPIO_INT_TYPE_SET_INT_TYPE_SET_Pos (0UL) /*!< field INT_TYPE_SET (bitOffset 0, bitWidth 16) */
#define GPIO_INT_TYPE_SET_INT_TYPE_SET_Msk (0x0000ffffUL) /*!< field INT_TYPE_SET (Bitfield-Mask: 0x0000ffff) */

/* ================================================== Register INT_TYPE_CLR ================================================== */
#define GPIO_INT_TYPE_CLR_INT_TYPE_CLR_Pos (0UL) /*!< field INT_TYPE_CLR (bitOffset 0, bitWidth 16) */
#define GPIO_INT_TYPE_CLR_INT_TYPE_CLR_Msk (0x0000ffffUL) /*!< field INT_TYPE_CLR (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INT_POL_SET ================================================== */
#define GPIO_INT_POL_SET_INT_POL_SET_Pos (0UL) /*!< field INT_POL_SET (bitOffset 0, bitWidth 16) */
#define GPIO_INT_POL_SET_INT_POL_SET_Msk (0x0000ffffUL) /*!< field INT_POL_SET (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INT_POL_CLR ================================================== */
#define GPIO_INT_POL_CLR_INT_POL_CLR_Pos (0UL) /*!< field INT_POL_CLR (bitOffset 0, bitWidth 16) */
#define GPIO_INT_POL_CLR_INT_POL_CLR_Msk (0x0000ffffUL) /*!< field INT_POL_CLR (Bitfield-Mask: 0x0000ffff) */

/* =================================================== Register INT_STATUS =================================================== */
#define GPIO_INT_STATUS_STATUS_CLEAR_Pos (0UL) /*!< field STATUS_CLEAR (bitOffset 0, bitWidth 16) */
#define GPIO_INT_STATUS_STATUS_CLEAR_Msk (0x0000ffffUL) /*!< field STATUS_CLEAR (Bitfield-Mask: 0x0000ffff) */

/* ================================================== Register SEC_INT_STAT ================================================== */
#define GPIO_SEC_INT_STAT_SEC_INT_STAT_Pos (0UL) /*!< field SEC_INT_STAT (bitOffset 0, bitWidth 1) */
#define GPIO_SEC_INT_STAT_SEC_INT_STAT_Msk (0x00000001UL) /*!< field SEC_INT_STAT (Bitfield-Mask: 0x00000001) */

/* =================================================== Register SEC_INT_CLR ================================================== */
#define GPIO_SEC_INT_CLR_SEC_INT_CLR_Pos (0UL) /*!< field SEC_INT_CLR (bitOffset 0, bitWidth 1) */
#define GPIO_SEC_INT_CLR_SEC_INT_CLR_Msk (0x00000001UL) /*!< field SEC_INT_CLR (Bitfield-Mask: 0x00000001) */

/* ================================================== Register SEC_INT_MASK ================================================== */
#define GPIO_SEC_INT_MASK_SEC_ACC_MASK_Pos (0UL) /*!< field SEC_ACC_MASK (bitOffset 0, bitWidth 1) */
#define GPIO_SEC_INT_MASK_SEC_ACC_MASK_Msk (0x00000001UL) /*!< field SEC_ACC_MASK (Bitfield-Mask: 0x00000001) */
#define GPIO_SEC_INT_MASK_PORT_NONSEC_MASK_Pos (1UL) /*!< field PORT_NONSEC_MASK (bitOffset 1, bitWidth 1) */
#define GPIO_SEC_INT_MASK_PORT_NONSEC_MASK_Msk (0x00000002UL) /*!< field PORT_NONSEC_MASK (Bitfield-Mask: 0x00000001) */

/* ================================================== Register SEC_INT_INFO1 ================================================= */
#define GPIO_SEC_INT_INFO1_ADDR_Pos (0UL) /*!< field ADDR (bitOffset 0, bitWidth 12) */
#define GPIO_SEC_INT_INFO1_ADDR_Msk (0x00000fffUL) /*!< field ADDR (Bitfield-Mask: 0x00000fff) */
#define GPIO_SEC_INT_INFO1_BYTE_STROBE_Pos (12UL) /*!< field BYTE_STROBE (bitOffset 12, bitWidth 4) */
#define GPIO_SEC_INT_INFO1_BYTE_STROBE_Msk (0x0000f000UL) /*!< field BYTE_STROBE (Bitfield-Mask: 0x0000000f) */
#define GPIO_SEC_INT_INFO1_NONSEC_Pos (16UL) /*!< field NONSEC (bitOffset 16, bitWidth 1) */
#define GPIO_SEC_INT_INFO1_NONSEC_Msk (0x00010000UL) /*!< field NONSEC (Bitfield-Mask: 0x00000001) */
#define GPIO_SEC_INT_INFO1_RW_Pos (17UL) /*!< field RW (bitOffset 17, bitWidth 1) */
#define GPIO_SEC_INT_INFO1_RW_Msk (0x00020000UL) /*!< field RW (Bitfield-Mask: 0x00000001) */

/* ================================================== Register SEC_INT_INFO2 ================================================= */
#define GPIO_SEC_INT_INFO2_WDATA_Pos (0UL) /*!< field WDATA (bitOffset 0, bitWidth 32) */
#define GPIO_SEC_INT_INFO2_WDATA_Msk (0xffffffffUL) /*!< field WDATA (Bitfield-Mask: 0xffffffff) */

/* =================================================== Register SEC_INT_SET ================================================== */
#define GPIO_SEC_INT_SET_SET_Pos (0UL) /*!< field SET (bitOffset 0, bitWidth 1) */
#define GPIO_SEC_INT_SET_SET_Msk (0x00000001UL) /*!< field SET (Bitfield-Mask: 0x00000001) */

/* ================================================ Register PORT_NONSEC_MASK ================================================ */
#define GPIO_PORT_NONSEC_MASK_NONSEC_MASK_Pos (0UL) /*!< field NONSEC_MASK (bitOffset 0, bitWidth 16) */
#define GPIO_PORT_NONSEC_MASK_NONSEC_MASK_Msk (0x0000ffffUL) /*!< field NONSEC_MASK (Bitfield-Mask: 0x0000ffff) */

/* =============================== Register MASK_LOW_BYTE0 (element 0 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE0_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE0_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE1 (element 1 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE1_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE1_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE2 (element 2 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE2_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE2_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE3 (element 3 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE3_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE3_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE4 (element 4 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE4_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE4_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE5 (element 5 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE5_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE5_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE6 (element 6 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE6_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE6_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE7 (element 7 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE7_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE7_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE8 (element 8 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE8_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE8_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* =============================== Register MASK_LOW_BYTE9 (element 9 from DIM MASK_LOW_BYTE%s) ============================== */
#define GPIO_MASK_LOW_BYTE9_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE9_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE10 (element 10 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE10_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE10_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE11 (element 11 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE11_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE11_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE12 (element 12 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE12_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE12_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE13 (element 13 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE13_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE13_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE14 (element 14 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE14_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE14_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE15 (element 15 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE15_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE15_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE16 (element 16 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE16_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE16_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE17 (element 17 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE17_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE17_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE18 (element 18 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE18_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE18_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE19 (element 19 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE19_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE19_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE20 (element 20 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE20_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE20_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE21 (element 21 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE21_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE21_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE22 (element 22 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE22_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE22_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE23 (element 23 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE23_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE23_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE24 (element 24 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE24_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE24_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE25 (element 25 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE25_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE25_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE26 (element 26 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE26_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE26_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE27 (element 27 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE27_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE27_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE28 (element 28 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE28_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE28_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE29 (element 29 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE29_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE29_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE30 (element 30 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE30_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE30_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE31 (element 31 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE31_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE31_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE32 (element 32 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE32_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE32_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE33 (element 33 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE33_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE33_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE34 (element 34 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE34_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE34_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE35 (element 35 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE35_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE35_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE36 (element 36 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE36_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE36_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE37 (element 37 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE37_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE37_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE38 (element 38 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE38_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE38_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE39 (element 39 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE39_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE39_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE40 (element 40 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE40_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE40_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE41 (element 41 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE41_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE41_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE42 (element 42 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE42_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE42_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE43 (element 43 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE43_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE43_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE44 (element 44 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE44_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE44_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE45 (element 45 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE45_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE45_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE46 (element 46 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE46_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE46_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE47 (element 47 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE47_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE47_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE48 (element 48 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE48_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE48_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE49 (element 49 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE49_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE49_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE50 (element 50 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE50_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE50_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE51 (element 51 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE51_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE51_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE52 (element 52 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE52_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE52_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE53 (element 53 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE53_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE53_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE54 (element 54 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE54_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE54_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE55 (element 55 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE55_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE55_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE56 (element 56 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE56_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE56_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE57 (element 57 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE57_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE57_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE58 (element 58 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE58_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE58_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE59 (element 59 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE59_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE59_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE60 (element 60 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE60_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE60_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE61 (element 61 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE61_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE61_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE62 (element 62 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE62_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE62_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_LOW_BYTE63 (element 63 from DIM MASK_LOW_BYTE%s) ============================= */
#define GPIO_MASK_LOW_BYTE63_LOWER_ENABLE_MASK_Pos (0UL) /*!< field LOWER_ENABLE_MASK (bitOffset 0, bitWidth 8) */
#define GPIO_MASK_LOW_BYTE63_LOWER_ENABLE_MASK_Msk (0x000000ffUL) /*!< field LOWER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE0 (element 0 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE0_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE0_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE1 (element 1 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE1_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE1_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE2 (element 2 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE2_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE2_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE3 (element 3 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE3_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE3_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE4 (element 4 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE4_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE4_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE5 (element 5 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE5_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE5_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE6 (element 6 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE6_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE6_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE7 (element 7 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE7_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE7_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE8 (element 8 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE8_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE8_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================== Register MASK_HIGH_BYTE9 (element 9 from DIM MASK_HIGH_BYTE%s) ============================= */
#define GPIO_MASK_HIGH_BYTE9_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE9_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE10 (element 10 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE10_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE10_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE11 (element 11 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE11_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE11_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE12 (element 12 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE12_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE12_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE13 (element 13 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE13_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE13_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE14 (element 14 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE14_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE14_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE15 (element 15 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE15_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE15_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE16 (element 16 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE16_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE16_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE17 (element 17 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE17_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE17_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE18 (element 18 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE18_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE18_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE19 (element 19 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE19_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE19_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE20 (element 20 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE20_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE20_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE21 (element 21 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE21_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE21_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE22 (element 22 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE22_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE22_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE23 (element 23 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE23_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE23_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE24 (element 24 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE24_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE24_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE25 (element 25 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE25_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE25_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE26 (element 26 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE26_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE26_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE27 (element 27 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE27_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE27_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE28 (element 28 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MASK_HIGH_BYTE28_HIGHER_ENABLE_MASK_Pos (8UL) /*!< field HIGHER_ENABLE_MASK (bitOffset 8, bitWidth 8) */
#define GPIO_MASK_HIGH_BYTE28_HIGHER_ENABLE_MASK_Msk (0x0000ff00UL) /*!< field HIGHER_ENABLE_MASK (Bitfield-Mask: 0x000000ff) */

/* ============================= Register MASK_HIGH_BYTE29 (element 29 from DIM MASK_HIGH_BYTE%s) ============================ */
#define GPIO_MA