/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

#define BOARD_INITPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x0200U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B0_09 (coord F14), JTAG_TDI/J21[5]/ENET_RST/J22[5] */
/* Routed pin properties */
#define BOARD_INITPINS_USER_LED_PERIPHERAL                                 GPIO1   /*!< Peripheral name */
#define BOARD_INITPINS_USER_LED_SIGNAL                                   gpio_io   /*!< Signal name */
#define BOARD_INITPINS_USER_LED_CHANNEL                                       9U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_USER_LED_GPIO                                       GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_USER_LED_GPIO_PIN                                      9U   /*!< GPIO pin number */
#define BOARD_INITPINS_USER_LED_GPIO_PIN_MASK                         (1U << 9U)   /*!< GPIO pin mask */
#define BOARD_INITPINS_USER_LED_PORT                                       GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITPINS_USER_LED_PIN                                           9U   /*!< PORT pin number */
#define BOARD_INITPINS_USER_LED_PIN_MASK                              (1U << 9U)   /*!< PORT pin mask */

/* WAKEUP (coord L6), SD_PWREN */
/* Routed pin properties */
#define BOARD_INITPINS_USER_BUTTON_PERIPHERAL                              GPIO5   /*!< Peripheral name */
#define BOARD_INITPINS_USER_BUTTON_SIGNAL                                gpio_io   /*!< Signal name */
#define BOARD_INITPINS_USER_BUTTON_CHANNEL                                    0U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITPINS_USER_BUTTON_GPIO                                    GPIO5   /*!< GPIO peripheral base pointer */
#define BOARD_INITPINS_USER_BUTTON_GPIO_PIN                                   0U   /*!< GPIO pin number */
#define BOARD_INITPINS_USER_BUTTON_GPIO_PIN_MASK                      (1U << 0U)   /*!< GPIO pin mask */
#define BOARD_INITPINS_USER_BUTTON_PORT                                    GPIO5   /*!< PORT peripheral base pointer */
#define BOARD_INITPINS_USER_BUTTON_PIN                                        0U   /*!< PORT pin number */
#define BOARD_INITPINS_USER_BUTTON_PIN_MASK                           (1U << 0U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_AD_B0_12 (coord K14), UART1_TXD */
/* Routed pin properties */
#define BOARD_INITDEBUG_UARTPINS_UART1_TXD_PERIPHERAL                    LPUART1   /*!< Peripheral name */
#define BOARD_INITDEBUG_UARTPINS_UART1_TXD_SIGNAL                             TX   /*!< Signal name */

/* GPIO_AD_B0_13 (coord L14), UART1_RXD */
/* Routed pin properties */
#define BOARD_INITDEBUG_UARTPINS_UART1_RXD_PERIPHERAL                    LPUART1   /*!< Peripheral name */
#define BOARD_INITDEBUG_UARTPINS_UART1_RXD_SIGNAL                             RX   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitDEBUG_UARTPins(void);

/* GPIO_EMC_09 (coord C2), SEMC_A0 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A0_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A0_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A0_CHANNEL                                   0U   /*!< Signal channel */

/* GPIO_EMC_10 (coord G1), SEMC_A1 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A1_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A1_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A1_CHANNEL                                   1U   /*!< Signal channel */

/* GPIO_EMC_11 (coord G3), SEMC_A2 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A2_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A2_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A2_CHANNEL                                   2U   /*!< Signal channel */

/* GPIO_EMC_12 (coord H1), SEMC_A3 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A3_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A3_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A3_CHANNEL                                   3U   /*!< Signal channel */

/* GPIO_EMC_13 (coord A6), SEMC_A4 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A4_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A4_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A4_CHANNEL                                   4U   /*!< Signal channel */

/* GPIO_EMC_14 (coord B6), SEMC_A5 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A5_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A5_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A5_CHANNEL                                   5U   /*!< Signal channel */

/* GPIO_EMC_15 (coord B1), SEMC_A6 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A6_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A6_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A6_CHANNEL                                   6U   /*!< Signal channel */

/* GPIO_EMC_16 (coord A5), SEMC_A7 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A7_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A7_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A7_CHANNEL                                   7U   /*!< Signal channel */

/* GPIO_EMC_17 (coord A4), SEMC_A8 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A8_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A8_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A8_CHANNEL                                   8U   /*!< Signal channel */

/* GPIO_EMC_18 (coord B2), SEMC_A9 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A9_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A9_SIGNAL                                  ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A9_CHANNEL                                   9U   /*!< Signal channel */

/* GPIO_EMC_23 (coord G2), SEMC_A10 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A10_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A10_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A10_CHANNEL                                 10U   /*!< Signal channel */

/* GPIO_EMC_19 (coord B4), SEMC_A11 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A11_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A11_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A11_CHANNEL                                 11U   /*!< Signal channel */

/* GPIO_EMC_20 (coord A3), SEMC_A12 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_A12_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_A12_SIGNAL                                 ADDR   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_A12_CHANNEL                                 12U   /*!< Signal channel */

/* GPIO_EMC_21 (coord C1), SEMC_BA0 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_BA0_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_BA0_SIGNAL                                   BA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_BA0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_EMC_22 (coord F1), SEMC_BA1 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_BA1_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_BA1_SIGNAL                                   BA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_BA1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_EMC_24 (coord D3), SEMC_CAS */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CAS_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CAS_SIGNAL                             semc_cas   /*!< Signal name */

/* GPIO_EMC_27 (coord A2), SEMC_CKE */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CKE_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CKE_SIGNAL                             semc_cke   /*!< Signal name */

/* GPIO_EMC_26 (coord B3), SEMC_CLK */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CLK_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CLK_SIGNAL                             semc_clk   /*!< Signal name */

/* GPIO_EMC_00 (coord E3), SEMC_D0 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D0_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D0_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D0_CHANNEL                                   0U   /*!< Signal channel */

/* GPIO_EMC_01 (coord F3), SEMC_D1 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D1_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D1_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D1_CHANNEL                                   1U   /*!< Signal channel */

/* GPIO_EMC_02 (coord F4), SEMC_D2 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D2_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D2_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D2_CHANNEL                                   2U   /*!< Signal channel */

/* GPIO_EMC_03 (coord G4), SEMC_D3 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D3_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D3_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D3_CHANNEL                                   3U   /*!< Signal channel */

/* GPIO_EMC_04 (coord F2), SEMC_D4 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D4_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D4_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D4_CHANNEL                                   4U   /*!< Signal channel */

/* GPIO_EMC_05 (coord G5), SEMC_D5 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D5_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D5_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D5_CHANNEL                                   5U   /*!< Signal channel */

/* GPIO_EMC_06 (coord H5), SEMC_D6 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D6_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D6_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D6_CHANNEL                                   6U   /*!< Signal channel */

/* GPIO_EMC_07 (coord H4), SEMC_D7 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D7_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D7_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D7_CHANNEL                                   7U   /*!< Signal channel */

/* GPIO_EMC_30 (coord C6), SEMC_D8 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D8_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D8_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D8_CHANNEL                                   8U   /*!< Signal channel */

/* GPIO_EMC_31 (coord C5), SEMC_D9 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D9_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D9_SIGNAL                                  DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D9_CHANNEL                                   9U   /*!< Signal channel */

/* GPIO_EMC_32 (coord D5), SEMC_D10 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D10_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D10_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D10_CHANNEL                                 10U   /*!< Signal channel */

/* GPIO_EMC_33 (coord C4), SEMC_D11 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D11_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D11_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D11_CHANNEL                                 11U   /*!< Signal channel */

/* GPIO_EMC_34 (coord D4), SEMC_D12 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D12_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D12_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D12_CHANNEL                                 12U   /*!< Signal channel */

/* GPIO_EMC_35 (coord E5), SEMC_D13 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D13_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D13_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D13_CHANNEL                                 13U   /*!< Signal channel */

/* GPIO_EMC_36 (coord C3), SEMC_D14 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D14_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D14_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D14_CHANNEL                                 14U   /*!< Signal channel */

/* GPIO_EMC_37 (coord E4), SEMC_D15 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_D15_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_D15_SIGNAL                                 DATA   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_D15_CHANNEL                                 15U   /*!< Signal channel */

/* GPIO_EMC_08 (coord H3), SEMC_DM0 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_DM0_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_DM0_SIGNAL                                   DM   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_DM0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_EMC_38 (coord D6), SEMC_DM1 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_DM1_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_DM1_SIGNAL                                   DM   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_DM1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_EMC_25 (coord D2), SEMC_RAS */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_RAS_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_RAS_SIGNAL                             semc_ras   /*!< Signal name */

/* GPIO_EMC_28 (coord D1), SEMC_WE */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_WE_PERIPHERAL                              SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_WE_SIGNAL                               semc_we   /*!< Signal name */

/* GPIO_EMC_29 (coord E1), SEMC_CS0 */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_CS0_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_CS0_SIGNAL                                   CS   /*!< Signal name */
#define BOARD_INITSDRAMPINS_SEMC_CS0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_EMC_39 (coord B7), SEMC_DQS */
/* Routed pin properties */
#define BOARD_INITSDRAMPINS_SEMC_DQS_PERIPHERAL                             SEMC   /*!< Peripheral name */
#define BOARD_INITSDRAMPINS_SEMC_DQS_SIGNAL                             semc_dqs   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitSDRAMPins(void);

#define BOARD_INITCSIPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x10U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */

/* GPIO_AD_B1_08 (coord H13), AUD_INT/CSI_D9//J35[13]/J22[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D9_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D9_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D9_CHANNEL                                      9U   /*!< Signal channel */

/* GPIO_AD_B1_09 (coord M13), SAI1_MCLK/CSI_D8/J35[11] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D8_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D8_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D8_CHANNEL                                      8U   /*!< Signal channel */

/* GPIO_AD_B1_10 (coord L13), SAI1_RX_SYNC/CSI_D7/J35[9]/J23[1] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D7_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D7_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D7_CHANNEL                                      7U   /*!< Signal channel */

/* GPIO_AD_B1_11 (coord J13), SAI1_RX_BCLK/CSI_D6/J35[7]/J23[2] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D6_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D6_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D6_CHANNEL                                      6U   /*!< Signal channel */

/* GPIO_AD_B1_12 (coord H12), SAI1_RXD/CSI_D5/J35[5]/U13[16] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D5_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D5_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D5_CHANNEL                                      5U   /*!< Signal channel */

/* GPIO_AD_B1_13 (coord H11), SAI1_TXD/CSI_D4/J35[3]/U13[14] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D4_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D4_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D4_CHANNEL                                      4U   /*!< Signal channel */

/* GPIO_AD_B1_15 (coord J14), SAI1_TX_SYNC/CSI_D2/J35[6]/U13[13] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D2_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D2_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D2_CHANNEL                                      2U   /*!< Signal channel */

/* GPIO_AD_B1_14 (coord G12), SAI1_TX_BCLK/CSI_D3/J35[4]/U13[12] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_D3_PERIPHERAL                                  CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_D3_SIGNAL                                 csi_data   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_D3_CHANNEL                                      3U   /*!< Signal channel */

/* GPIO_AD_B1_04 (coord L12), CSI_PIXCLK/J35[8]/J23[3] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_PIXCLK_PERIPHERAL                              CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_PIXCLK_SIGNAL                           csi_pixclk   /*!< Signal name */

/* GPIO_AD_B1_05 (coord K12), CSI_MCLK/J35[12]/J23[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_MCLK_PERIPHERAL                                CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_MCLK_SIGNAL                               csi_mclk   /*!< Signal name */

/* GPIO_AD_B1_06 (coord J12), CSI_VSYNC/J35[18]/J22[2]/UART_TX */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_VSYNC_PERIPHERAL                               CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_VSYNC_SIGNAL                             csi_vsync   /*!< Signal name */

/* GPIO_AD_B1_07 (coord K10), CSI_HSYNC/J35[16]/J22[1]/UART_RX */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_HSYNC_PERIPHERAL                               CSI   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_HSYNC_SIGNAL                             csi_hsync   /*!< Signal name */

/* GPIO_AD_B1_00 (coord J11), I2C1_SCL/CSI_I2C_SCL/J35[20]/J23[6]/U13[17]/U32[4] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_I2C_SCL_PERIPHERAL                          LPI2C1   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_I2C_SCL_SIGNAL                                 SCL   /*!< Signal name */

/* GPIO_AD_B1_01 (coord K11), I2C1_SDA/CSI_I2C_SDA/J35[22]/J23[5]/U13[18]/U32[6] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_I2C_SDA_PERIPHERAL                          LPI2C1   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_I2C_SDA_SIGNAL                                 SDA   /*!< Signal name */

/* GPIO_AD_B0_04 (coord F11), CSI_PWDN/J35[17]/BOOT_MODE[0] */
/* Routed pin properties */
#define BOARD_INITCSIPINS_CSI_PWDN_PERIPHERAL                              GPIO1   /*!< Peripheral name */
#define BOARD_INITCSIPINS_CSI_PWDN_SIGNAL                                gpio_io   /*!< Signal name */
#define BOARD_INITCSIPINS_CSI_PWDN_CHANNEL                                    4U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO                                    GPIO1   /*!< GPIO peripheral base pointer */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO_PIN                                   4U   /*!< GPIO pin number */
#define BOARD_INITCSIPINS_CSI_PWDN_GPIO_PIN_MASK                      (1U << 4U)   /*!< GPIO pin mask */
#define BOARD_INITCSIPINS_CSI_PWDN_PORT                                    GPIO1   /*!< PORT peripheral base pointer */
#define BOARD_INITCSIPINS_CSI_PWDN_PIN                                        4U   /*!< PORT pin number */
#define BOARD_INITCSIPINS_CSI_PWDN_PIN_MASK                           (1U << 4U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCSIPins(void);

#define BOARD_INITLCDPINS_IOMUXC_GPR_GPR26_GPIO_MUX1_GPIO_SEL_MASK 0x04U /*!< GPIO1 and GPIO6 share same IO MUX function, GPIO_MUX1 selects one GPIO function: affected bits mask */
#define BOARD_INITLCDPINS_IOMUXC_GPR_GPR27_GPIO_MUX2_GPIO_SEL_MASK 0x80000000U /*!< GPIO2 and GPIO7 share same IO MUX function, GPIO_MUX2 selects one GPIO function: affected bits mask */

/* GPIO_B0_04 (coord C8), LCDIF_D0/BT_CFG[0] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D0_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D0_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D0_CHANNEL                                    0U   /*!< Signal channel */

/* GPIO_B0_05 (coord B8), LCDIF_D1/BT_CFG[1] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D1_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D1_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D1_CHANNEL                                    1U   /*!< Signal channel */

/* GPIO_B0_06 (coord A8), LCDIF_D2/BT_CFG[2] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D2_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D2_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D2_CHANNEL                                    2U   /*!< Signal channel */

/* GPIO_B0_00 (coord D7), LCDIF_CLK */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_CLK_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_CLK_SIGNAL                             lcdif_clk   /*!< Signal name */

/* GPIO_B0_07 (coord A9), LCDIF_D3/BT_CFG[3] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D3_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D3_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D3_CHANNEL                                    3U   /*!< Signal channel */

/* GPIO_B0_08 (coord B9), LCDIF_D4/BT_CFG[4] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D4_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D4_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D4_CHANNEL                                    4U   /*!< Signal channel */

/* GPIO_B0_09 (coord C9), LCDIF_D5/BT_CFG[5] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D5_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D5_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D5_CHANNEL                                    5U   /*!< Signal channel */

/* GPIO_B0_10 (coord D9), LCDIF_D6/BT_CFG[6] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D6_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D6_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D6_CHANNEL                                    6U   /*!< Signal channel */

/* GPIO_B0_11 (coord A10), LCDIF_D7/BT_CFG[7] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D7_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D7_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D7_CHANNEL                                    7U   /*!< Signal channel */

/* GPIO_B0_12 (coord C10), LCDIF_D8/BT_CFG[8] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D8_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D8_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D8_CHANNEL                                    8U   /*!< Signal channel */

/* GPIO_B0_13 (coord D10), LCDIF_D9/BT_CFG[9] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D9_PERIPHERAL                              LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D9_SIGNAL                             lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D9_CHANNEL                                    9U   /*!< Signal channel */

/* GPIO_B0_14 (coord E10), LCDIF_D10/BT_CFG[10] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D10_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D10_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D10_CHANNEL                                  10U   /*!< Signal channel */

/* GPIO_B0_15 (coord E11), LCDIF_D11/BT_CFG[11] */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D11_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D11_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D11_CHANNEL                                  11U   /*!< Signal channel */

/* GPIO_B1_00 (coord A11), LCDIF_D12 */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D12_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D12_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D12_CHANNEL                                  12U   /*!< Signal channel */

/* GPIO_B1_01 (coord B11), LCDIF_D13 */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D13_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D13_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D13_CHANNEL                                  13U   /*!< Signal channel */

/* GPIO_B1_02 (coord C11), LCDIF_D14 */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D14_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D14_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D14_CHANNEL                                  14U   /*!< Signal channel */

/* GPIO_B1_03 (coord D11), LCDIF_D15 */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_D15_PERIPHERAL                             LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_D15_SIGNAL                            lcdif_data   /*!< Signal name */
#define BOARD_INITLCDPINS_LCDIF_D15_CHANNEL                                  15U   /*!< Signal channel */

/* GPIO_B0_01 (coord E7), LCDIF_ENABLE */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_ENABLE_PERIPHERAL                          LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_ENABLE_SIGNAL                       lcdif_enable   /*!< Signal name */

/* GPIO_B0_02 (coord E8), LCDIF_HSYNC */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_HSYNC_PERIPHERAL                           LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_HSYNC_SIGNAL                         lcdif_hsync   /*!< Signal name */

/* GPIO_B0_03 (coord D8), LCDIF_VSYNC */
/* Routed pin properties */
#define BOARD_INITLCDPINS_LCDIF_VSYNC_PERIPHERAL                           LCDIF   /*!< Peripheral name */
#define BOARD_INITLCDPINS_LCDIF_VSYNC_SIGNAL                         lcdif_vsync   /*!< Signal name */

/* GPIO_B1_15 (coord B14), USB_HOST_PWR/BACKLIGHT_CTL */
/* Routed pin properties */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PERIPHERAL                         GPIO2   /*!< Peripheral name */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_SIGNAL                           gpio_io   /*!< Signal name */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_CHANNEL                              31U   /*!< Signal channel */

/* Symbols to be used with GPIO driver */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO                               GPIO2   /*!< GPIO peripheral base pointer */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO_PIN                             31U   /*!< GPIO pin number */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_GPIO_PIN_MASK                (1U << 31U)   /*!< GPIO pin mask */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PORT                               GPIO2   /*!< PORT peripheral base pointer */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PIN                                  31U   /*!< PORT pin number */
#define BOARD_INITLCDPINS_BACKLIGHT_CTL_PIN_MASK                     (1U << 31U)   /*!< PORT pin mask */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLCDPins(void);

/* GPIO_AD_B0_14 (coord H14), CAN2_TX/U12[1] */
/* Routed pin properties */
#define BOARD_INITCANPINS_CAN2_TX_PERIPHERAL                                CAN2   /*!< Peripheral name */
#define BOARD_INITCANPINS_CAN2_TX_SIGNAL                                      TX   /*!< Signal name */

/* GPIO_AD_B0_15 (coord L10), CAN2_RX/U12[4] */
/* Routed pin properties */
#define BOARD_INITCANPINS_CAN2_RX_PERIPHERAL                                CAN2   /*!< Peripheral name */
#define BOARD_INITCANPINS_CAN2_RX_SIGNAL                                      RX   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitCANPins(void);

/* GPIO_EMC_40 (coord A7), ENET_MDC */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_MDC_PERIPHERAL                              ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_MDC_SIGNAL                              enet_mdc   /*!< Signal name */

/* GPIO_EMC_41 (coord C7), ENET_MDIO */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_MDIO_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_MDIO_SIGNAL                            enet_mdio   /*!< Signal name */

/* GPIO_B1_10 (coord B13), ENET_TX_CLK */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_TX_CLK_PERIPHERAL                           ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_TX_CLK_SIGNAL                       enet_ref_clk   /*!< Signal name */

/* GPIO_B1_04 (coord E12), ENET_RXD0 */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_RXD0_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_RXD0_SIGNAL                         enet_rx_data   /*!< Signal name */
#define BOARD_INITENETPINS_ENET_RXD0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_B1_05 (coord D12), ENET_RXD1 */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_RXD1_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_RXD1_SIGNAL                         enet_rx_data   /*!< Signal name */
#define BOARD_INITENETPINS_ENET_RXD1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_B1_06 (coord C12), ENET_CRS_DV */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_CRS_DV_PERIPHERAL                           ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_CRS_DV_SIGNAL                         enet_rx_en   /*!< Signal name */

/* GPIO_B1_11 (coord C13), ENET_RXER */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_RXER_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_RXER_SIGNAL                           enet_rx_er   /*!< Signal name */

/* GPIO_B1_07 (coord B12), ENET_TXD0 */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_TXD0_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_TXD0_SIGNAL                         enet_tx_data   /*!< Signal name */
#define BOARD_INITENETPINS_ENET_TXD0_CHANNEL                                  0U   /*!< Signal channel */

/* GPIO_B1_08 (coord A12), ENET_TXD1 */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_TXD1_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_TXD1_SIGNAL                         enet_tx_data   /*!< Signal name */
#define BOARD_INITENETPINS_ENET_TXD1_CHANNEL                                  1U   /*!< Signal channel */

/* GPIO_B1_09 (coord A13), ENET_TXEN */
/* Routed pin properties */
#define BOARD_INITENETPINS_ENET_TXEN_PERIPHERAL                             ENET   /*!< Peripheral name */
#define BOARD_INITENETPINS_ENET_TXEN_SIGNAL                           enet_tx_en   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitENETPins(void);

/* GPIO_SD_B0_05 (coord J2), SD1_D3 */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D3_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D3_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D3_CHANNEL                                    3U   /*!< Signal channel */

/* GPIO_SD_B0_04 (coord H2), SD1_D2 */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D2_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D2_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D2_CHANNEL                                    2U   /*!< Signal channel */

/* GPIO_SD_B0_03 (coord K1), SD1_D1/J24[5]/SPI_MISO */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D1_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D1_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D1_CHANNEL                                    1U   /*!< Signal channel */

/* GPIO_SD_B0_02 (coord J1), SD1_D0/J24[4]/SPI_MOSI/PWM */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_D0_PERIPHERAL                             USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_D0_SIGNAL                             usdhc_data   /*!< Signal name */
#define BOARD_INITUSDHCPINS_SD1_D0_CHANNEL                                    0U   /*!< Signal channel */

/* GPIO_SD_B0_00 (coord J4), SD1_CMD/J24[6] */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_CMD_PERIPHERAL                            USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_CMD_SIGNAL                             usdhc_cmd   /*!< Signal name */

/* GPIO_SD_B0_01 (coord J3), SD1_CLK/J24[3] */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD1_CLK_PERIPHERAL                            USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD1_CLK_SIGNAL                             usdhc_clk   /*!< Signal name */

/* GPIO_B1_14 (coord C14), SD0_VSELECT */
/* Routed pin properties */
#define BOARD_INITUSDHCPINS_SD0_VSELECT_PERIPHERAL                        USDHC1   /*!< Peripheral name */
#define BOARD_INITUSDHCPINS_SD0_VSELECT_SIGNAL                     usdhc_vselect   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitUSDHCPins(void);

/* GPIO_SD_B1_08 (coord P3), FlexSPI_D0_A */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_D0_A_PERIPHERAL                       FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_D0_A_SIGNAL                   FLEXSPI_A_DATA0   /*!< Signal name */

/* GPIO_SD_B1_09 (coord N4), FlexSPI_D1_A */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_D1_A_PERIPHERAL                       FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_D1_A_SIGNAL                   FLEXSPI_A_DATA1   /*!< Signal name */

/* GPIO_SD_B1_10 (coord P4), FlexSPI_D2_A */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_D2_A_PERIPHERAL                       FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_D2_A_SIGNAL                   FLEXSPI_A_DATA2   /*!< Signal name */

/* GPIO_SD_B1_11 (coord P5), FlexSPI_D3_A */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_D3_A_PERIPHERAL                       FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_D3_A_SIGNAL                   FLEXSPI_A_DATA3   /*!< Signal name */

/* GPIO_SD_B1_07 (coord L4), FlexSPI_CLK */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_CLK_PERIPHERAL                        FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_CLK_SIGNAL                     FLEXSPI_A_SCLK   /*!< Signal name */

/* GPIO_SD_B1_06 (coord L3), FlexSPI_SS0 */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_SS0_PERIPHERAL                        FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_SS0_SIGNAL                    FLEXSPI_A_SS0_B   /*!< Signal name */

/* GPIO_SD_B1_05 (coord N3), FlexSPI_DQS */
/* Routed pin properties */
#define BOARD_INITQSPIPINS_FlexSPI_DQS_PERIPHERAL                        FLEXSPI   /*!< Peripheral name */
#define BOARD_INITQSPIPINS_FlexSPI_DQS_SIGNAL                      FLEXSPI_A_DQS   /*!< Signal name */

/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitQSPIPins(void);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
