include_guard()

if (NOT BOARD)
  message(FATAL_ERROR "BOARD not specified")
endif ()

# toolchain set up
set(CMAKE_SYSTEM_PROCESSOR cortex-m33 CACHE INTERNAL "System Processor")
set(CMAKE_TOOLCHAIN_FILE ${TOP}/examples/build_system/cmake/toolchain/arm_${TOOLCHAIN}.cmake)

set(FAMILY_MCUS ELIOT1 CACHE INTERNAL "")


#------------------------------------
# BOARD_TARGET
#------------------------------------
# only need to be built ONCE for all examples
set (ELIOT1_HAL ${TOP}/hw/mcu/elvees/eliot1-hal)
add_compile_definitions(-DBOARD_NO_UART_STD=1)
add_subdirectory(${ELIOT1_HAL}/boards/${BOARD}_cfg/armgcc/bsp_core0 eliot1_bsp_core0)

#------------------------------------
# Functions
#------------------------------------
function(family_configure_example TARGET RTOS)
  family_configure_common(${TARGET} ${RTOS})

  #---------- Port Specific ----------
  # These files are built for each example since it depends on example's tusb_config.h
  target_sources(${TARGET} PUBLIC
    # BSP
    ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/family.c
    ${CMAKE_CURRENT_FUNCTION_LIST_DIR}/../board.c
    )

  # Add TinyUSB target and port source
  family_add_tinyusb(${TARGET} OPT_MCU_ELIOT1 ${RTOS})
  target_sources(${TARGET}-tinyusb PUBLIC
    ${TOP}/src/portable/synopsys/dwc2/dcd_dwc2.c
    )
  target_link_libraries(${TARGET}-tinyusb PUBLIC bsp_core0)

  # Link dependencies
  target_link_libraries(${TARGET} PUBLIC ${TARGET}-tinyusb)
  target_include_directories(${TARGET}-tinyusb PUBLIC
    ${ELIOT1_HAL}/CMSIS/Include/
    ${ELIOT1_HAL}/devices/eliot1/
    ${ELIOT1_HAL}/devices/eliot1/drivers/
    ${ELIOT1_HAL}/boards/${BOARD}_cfg/)

  target_compile_options(${TARGET} PRIVATE -Wno-error=redundant-decls)

  target_include_directories(${TARGET} PRIVATE
    ${TOP}/hw/)

  target_link_options(${TARGET} PRIVATE
    "LINKER:--script=${ELIOT1_HAL}/devices/eliot1/gcc/eliot1_cm33_core0_flash_secure.ld"
    # nanolib
    --specs=nosys.specs
    # --specs=nano.specs
  )
endfunction()
