/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"
#include "core_test.h"

#define GLOBAL_VAR_DEFAULT    0xAABB     /*!< Стартовое значение глобальной переменной */
#define GLOBAL_VAR_WRITE_VAL  0xFEFEFEFE /*!< Записываемое значение глобальной переменной */
#define GLOBAL_VAR_XOR_PAT    0xFFFFFFFF /*!< Шаблон операции xor значения глобальной переменной */
#define GLOBAL_VAR_XOR_RESULT 0x01010101 /*!< Результат операции xor глобальной переменной */
#define BSS_ARRAYSIZE         16         /*!< Размер массива в секции .bss */
#define BSS_ARRAT_WRITE_SUM   0x5555     /*!< Значение суммы элементов массива в секции .bss после записи */
#define CONST_VAL_ADDR_MASK   0xF0000000 /*!< Маска старшего адреса константы */

volatile uint32_t global_var = GLOBAL_VAR_DEFAULT; /*!< Глобальная переменная в секции .data */
volatile uint32_t bss_array[BSS_ARRAYSIZE] = {0};  /*!< Глобальный массив в секции .bss */
static const uint32_t const_var = 0x12345678;      /*!< Константа в секции .rodata */

__RAMFUNC void RAMFuncExample()
{
    printf("CORE_%ld: This is RAMFunc print. My address 0x%08lx\r\n",
        CPU_IDENTITY->CPUID, (uint32_t)&RAMFuncExample);
}
void SysTick_Handler()
{
    /* Выключаем SysTick */
    SysTick->CTRL = 0;

    printf("CORE_%ld: Hello from SysTick\r\n", CPU_IDENTITY->CPUID);
    global_var = 1;
    __DSB();
}
int32_t CoreSectionTest()
{
    int32_t sum = 0;
    int32_t errors = 0;
    uint64_t t1, t2;

    for (int32_t i = 0; i < BSS_ARRAYSIZE; i++) {
        sum |= bss_array[i];
    }
    printf("CORE_%ld: GLOBAL var 0x%02lx, BSS var 0x%lx, CONST var [0x%08lx : 0x%08lx]\r\n",
        CPU_IDENTITY->CPUID, global_var, sum, (uint32_t)&const_var, const_var);
    if (global_var != GLOBAL_VAR_DEFAULT) {
        printf("CORE_%ld: ERROR : GLOBAL var\r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    if (sum != 0) {
        printf("CORE_%ld: ERROR : BSS var\r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    if ((uint32_t)&const_var & CONST_VAL_ADDR_MASK) {
        printf("CORE_%ld: ERROR : CONST val\r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    global_var = GLOBAL_VAR_WRITE_VAL;
    for (size_t i = 0; i < BSS_ARRAYSIZE; i += 2) {
        bss_array[i] = (1 << i);
    }
    sum = 0;
    for (size_t i = 0; i < BSS_ARRAYSIZE; i++) {
        sum |= bss_array[i];
    }
    if ((global_var ^ GLOBAL_VAR_XOR_PAT) != GLOBAL_VAR_XOR_RESULT) {
        printf("CORE_%ld: ERROR : Writing GLOBAL var\r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    if (sum != BSS_ARRAT_WRITE_SUM) {
        printf("CORE_%ld: ERROR : Writing BSS var \r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    if (errors == 0) {
        printf("CORE_%ld: All sections are OK \r\n", CPU_IDENTITY->CPUID);
    }
    RAMFuncExample();
    printf("CORE_%ld: Init NVIC \r\n", CPU_IDENTITY->CPUID);
    global_var = 0;
    NVIC_ClearPendingIRQ(SysTick_IRQn);
    NVIC_EnableIRQ(SysTick_IRQn);
    __enable_irq();
    if (SysTick_Config(SystemCoreClock / 1000)) {
        printf("CORE_%ld: ERROR : Init SysTick \r\n", CPU_IDENTITY->CPUID);
        errors++;
    }
    while (global_var == 0)
        ;
    t1 = BOARD_GetTime();
    printf("CORE_%ld: Test BOARD API\r\n    BOARD_GetTime() = %lld\r\n    BOARD_Udelay(1000000)\r\n",
            CPU_IDENTITY->CPUID, t1);
    BOARD_Udelay(1000000);
    t2 = BOARD_GetTime();
    printf("    BOARD_GetTime() = %lld\r\n", t2);

    if (t1 == 0 || t2 == 0) {
        printf("    ERROR : Board timer was not initialized!\r\n");
    } else {
        t1 /= 1000000;
        t2 /= 1000000;
        if (t1 == t2 || t2 > (t1 + 1)) {
            printf("    ERROR : BOARD_Udelay() function is not correct!\r\n");
        } else {
            printf("    BOARD API is OK!\r\n");
        }
    }
    return errors;
}
