# Обзор

Демонстрация работы startup файлов, ld-скриптов сборки, запуска Core1 и
регистрации прерываний через NVIC.

## Описание примера

Программа работает через загрузчик, который должен находиться в системном разделе flash памяти по адресу 0x10200000.
Core0 проверяет правильность размещения переменных разных типов по областям памяти, затем запускает Core1.
Core1 аналогично проверяет размещение переменных и посылает MHU прерывание ядру Core0.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- плата ELIOT1M_MO;
- персональный компьютер.

## Подготовка к работе

1. Подключить все.
2. Открыть последовательный терминал (пример Putty, Minicom) со следующими настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустить OpenOCD командой:

```bash
<path_to_openocd> -c 'set USE_NRST 1' -c 'tcl_port disabled' -c 'telnet_port disabled' -f board/eliot1m_mo.cfg
```

## Работа с программой

- Выполнить команду `bash build.sh` для сборки примера.
- Выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки рограммы на плату.
- Запустить программу на исполнение с помощью gdb команды `continue`.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
CORE_0: Started (50 MHz)
CORE_0: GLOBAL var 0xaabb, BSS var 0x0, CONST var [0x0000ac28 : 0x12345678]
CORE_0: All sections are OK
CORE_0: This is RAMFunc print. My address 0x200009c1
CORE_0: Init NVIC
CORE_0: Hello from SysTick
CORE_0: Test BOARD API
    BOARD_GetTime() = 39522
    BOARD_Udelay(1000000)
    BOARD_GetTime() = 1046468
    BOARD API is OK!
CORE_0: Start Core1 (CPUWAIT 0x00000002)
CORE_1: Started (150 MHz)
CORE_1: GLOBAL var 0xaabb, BSS var 0x0, CONST var [0x0008aa14 : 0x12345678]
CORE_1: All sections are OK
CORE_1: This is RAMFunc print. My address 0x200409c1
CORE_1: Init NVIC
CORE_1: Hello from SysTick
CORE_1: Test BOARD API
    BOARD_GetTime() = 1075679
    BOARD_Udelay(1000000)
    BOARD_GetTime() = 2082794
    BOARD API is OK!
CORE_1: Send MHU0 0x1 to CPU0
CORE_0: Recieved MHU0 0x1 from CPU1
CORE_0: Message from Core1: Hello from CPU1
```
