/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"

#define TEST_LENGTH_SAMPLES 64

uint32_t t1, t2;

float test_input_a_f32[TEST_LENGTH_SAMPLES] = {
    -0.808920, 1.357369, 1.180861, -0.504544, 1.762637, -0.703285,
    1.696966, 0.620571, -0.151093, -0.100235, -0.872382, -0.403579,
    -0.860749, -0.382648, -1.052338, 0.128113, -0.646269, 1.093377,
    -2.209198, 0.471706, 0.408901, 1.266242, 0.598252, 1.176827,
    -0.203421, 0.213596, -0.851964, -0.466958, 0.021841, -0.698938,
    -0.604107, 0.461778, -0.318219, 0.942520, 0.577585, 0.417619,
    0.614665, 0.563679, -1.295073, -0.764437, 0.952194, -0.859222,
    -0.618554, -2.268542, -1.210592, 1.655853, -2.627219, -0.994249,
    -1.374704, 0.343799, 0.025619, 1.227481, -0.708031, 0.069355,
    -1.845228, -1.570886, 1.010668, -1.802084, 1.630088, 1.286090,
    -0.161050, -0.940794, 0.367961, 0.291907
};
float test_input_b_f32[TEST_LENGTH_SAMPLES] = {
    0.933724, 0.046881, 1.316470, 0.438345, 0.332682, 2.094885,
    0.512081, 0.035546, 0.050894, -2.320371, 0.168711, -1.830493,
    -0.444834, -1.003242, -0.531494, -1.365600, -0.155420, -0.757692,
    -0.431880, -0.380021, 0.096243, -0.695835, 0.558850, -1.648962,
    0.020369, -0.363630, 0.887146, 0.845503, -0.252864, -0.330397,
    1.269131, -1.109295, -1.027876, 0.135940, 0.116721, -0.293399,
    -1.349799, 0.166078, -0.802201, 0.369367, -0.964568, -2.266011,
    0.465178, 0.651222, -0.325426, 0.320245, -0.784178, -0.579456,
    0.093374, 0.604778, -0.048225, 0.376297, -0.394412, 0.578182,
    -1.218141, -1.387326, 0.692462, -0.631297, 0.153137, -0.638952,
    0.635474, -0.970468, 1.334057, -0.111370
};
float test_output_f32[TEST_LENGTH_SAMPLES];

int main()
{
    BOARD_InitAll();

    printf("CORE_%ld: Started\r\n", CPU_IDENTITY->CPUID);

    t1 = BOARD_GetTime();
    for (int32_t n = 0; n < TEST_LENGTH_SAMPLES / 2; n++) {
        test_output_f32[(2 * n) + 0] = test_input_a_f32[(2 * n) + 0]
                * test_input_b_f32[(2 * n) + 0]
                - test_input_a_f32[(2 * n) + 1]
                * test_input_b_f32[(2 * n) + 1];
        test_output_f32[(2 * n) + 1] = test_input_a_f32[(2 * n) + 0]
                * test_input_b_f32[(2 * n) + 1]
                + test_input_a_f32[(2 * n) + 1]
                * test_input_b_f32[(2 * n) + 0];
    }
    t2 = BOARD_GetTime();

    for (int32_t n = 0; n < TEST_LENGTH_SAMPLES / 2; n++) {
        printf("(%f)+", test_output_f32[(2 * n) + 0]);
        printf("(%f)i\r\n", test_output_f32[(2 * n) + 1]);
    }

    printf("Test was executed in %.3lfms\r\n", ((t2 - t1) / 1000.0));
    SYSCTR_Secure->CPUWAIT = 0;
    asm volatile("bkpt");
    return 0;
}
