# Обзор

Проверка заполнения кольцевого буфера на отправку в Tx UART и его переполнение.

## Описание примера

Выполняется пять передач в UART, третья передача не должна полностью выполниться.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- плата ELIOT1m\_MO;
- персональный компьютер;
- переходник USB-UART.

## Работа с программой

- подключиться к UART;
- вызвать скрипт **build.sh**;
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки;
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Настройки платы

| Pin Name | Board Location |
| ------ | ------ |
| UART0\_TXD | GPIO\_PA0 / D1 |
| UART0\_RXD | GPIO\_PA1 / D0 |
| UART0\_GND | GND |

## Подготовка к работе

1. Подключите все.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими.
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    First string
    Second string longer.......
    Third str
    Fourth string longer.....
    Fifth string

    Test : Ok

    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

Третья строка передалась частично.
