/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"
#include "hal_spi.h"

#define EXAMPLE_SPI_MASTER SPI0_Secure
#define EXAMPLE_SPI_MASTER_CLK_FREQ 5000000
#define US_IN_SECOND 1000000
#define FRAME_WIDTH_BIT 8
#define NUMBER_TO_FRAME_WIDTH(x) (spi_frame_width_t)((x) - 1)
#define BYTES_IN_KB 1024
#define TEST_BUFFER_SIZE (256 + 4)
#define DUMMY_DATA 0xff
#define FLASH_ID_SIZE 12


spi_config_t user_cfg = {0};
uint8_t err = 0;
uint8_t transfer_data[1] = {0x90};
uint8_t flash_ID[FLASH_ID_SIZE] = {0};
uint8_t status_bit[2];
uint8_t busy_bit[3] = {0x05, DUMMY_DATA, DUMMY_DATA};
uint8_t read_buf[TEST_BUFFER_SIZE] = {0};
uint8_t read_inst[TEST_BUFFER_SIZE] = {0};
uint8_t sector_erase[4] = {0x20, 0x00, 0x00, 0x00};
uint8_t write_enable[1] = {0x06};
uint8_t write_disable[1] = {0x04};
uint8_t page_program[TEST_BUFFER_SIZE] = {0};
spi_transfer_t xfer = {0};
enum spi_status  status;

void fillTestPage(uint8_t *page)
{
    uint32_t idx = 0;
    page[idx++] = 0x02;
    page[idx++] = 0x00;
    page[idx++] = 0x00;
    page[idx++] = 0x01;

    for ( ; idx < TEST_BUFFER_SIZE; idx++) {
        page[idx] = idx - 0x4;
    }
}

int main()
{
    enum spi_status spi_st;

    /* Инициализация платы. */
    BOARD_InitAll();

    /* Установка выводов в функцию SPI. */
    GPIO_PinMode_Function(GPIO_SPI0_SCK,  GPIO_ALT_FUNC_SPI0_SPI1);
    GPIO_PinMode_Function(GPIO_SPI0_MOSI, GPIO_ALT_FUNC_SPI0_SPI1);
    GPIO_PinMode_Function(GPIO_SPI0_MISO, GPIO_ALT_FUNC_SPI0_SPI1);
    GPIO_PinMode_Function(GPIO_SPI0_SS,   GPIO_ALT_FUNC_SPI0_SPI1);

    GPIO_PinSet_MaxCurrent(GPIO_SPI0_SCK, GPIO_MAX_CURRENT_12mA);
    GPIO_PinSet_MaxCurrent(GPIO_SPI0_MOSI, GPIO_MAX_CURRENT_12mA);
    GPIO_PinSet_MaxCurrent(GPIO_SPI0_MISO, GPIO_MAX_CURRENT_12mA);
    GPIO_PinSet_MaxCurrent(GPIO_SPI0_SS, GPIO_MAX_CURRENT_12mA);

    GPIO_PinSet_PUPD(GPIO_SPI0_SCK, GPIO_PULL_NONE);
    GPIO_PinSet_PUPD(GPIO_SPI0_MOSI, GPIO_PULL_NONE);
    GPIO_PinSet_PUPD(GPIO_SPI0_MISO, GPIO_PULL_NONE);
    GPIO_PinSet_PUPD(GPIO_SPI0_SS,  GPIO_PULL_NONE);

    /* Инициализация SPI. */
    printf("SPI init on %ldMHz\r\n", EXAMPLE_SPI_MASTER_CLK_FREQ / 1000000UL);
    SPI_MasterGetDefaultConfig(&user_cfg);
    user_cfg.data_width_bits = NUMBER_TO_FRAME_WIDTH(FRAME_WIDTH_BIT);
    user_cfg.master.baud_rate_bps = EXAMPLE_SPI_MASTER_CLK_FREQ;
    if ((spi_st = SPI_MasterInit(EXAMPLE_SPI_MASTER, &user_cfg,
            CLKCTR_GetSysClk(CLOCK_BASE))) != SPI_Status_Ok) {
        printf("SPI initialization error: %d\r\n", spi_st);
        return 1;
    }
    printf("SPI is initialized\r\n");

    do {
        xfer.tx_data = transfer_data;
        xfer.rx_data = flash_ID;
        xfer.data_size = FLASH_ID_SIZE;
        status = SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        if (status == SPI_Status_Ok) {
            printf("Reading Flash ID...\r\n");
        } else {
            printf("Reading Flash ID could not start, error %u.\r\n", status);
            break;
        }
        printf("Reading Flash ID is finished\r\n");
    } while (0);

    printf("Flash ID is ");
    for (int i = 5; i < FLASH_ID_SIZE; i++)
        printf("%x", flash_ID[i]);
    printf("\r\n");

    fillTestPage(page_program);

    do {
        /* Write enable */
        xfer.tx_data = write_enable;
        xfer.rx_data = NULL;
        xfer.data_size = 1;
        SPI_MasterTransferBlocking(SPI0_Secure, &xfer);

        /* Sector erase */
        xfer.tx_data = sector_erase;
        xfer.rx_data = NULL;
        xfer.data_size = 4;
        SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        printf("Erasing sector...\r\n");

        /* Read status register */
        do {
            xfer.tx_data = busy_bit;
            xfer.rx_data = status_bit;
            xfer.data_size = 2;
            SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        } while (status_bit[1] & (1 << 0));
        printf("Sector erased\r\n");

        /* Write enable */
        xfer.tx_data = write_enable;
        xfer.rx_data = NULL;
        xfer.data_size = 1;
        SPI_MasterTransferBlocking(SPI0_Secure, &xfer);

        /* Page program */
        xfer.tx_data = page_program;
        xfer.rx_data = NULL;
        xfer.data_size = TEST_BUFFER_SIZE;
        status = SPI_MasterTransferBlocking(SPI0_Secure, &xfer);

        /* Read status register */
        do {
            xfer.tx_data = busy_bit;
            xfer.rx_data = status_bit;
            xfer.data_size = 2;
            SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        } while (status_bit[1] & (1 << 0));

        /* Write disable */
        xfer.tx_data = write_disable;
        xfer.rx_data = NULL;
        xfer.data_size = 1;
        status = SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        if (status == SPI_Status_Ok) {
            printf("Writing into Flash...\r\n");
        } else {
            printf("Writing into Flash could not start, error %u.\r\n", status);
            break;
        }
        printf("Writing is finished\r\n");
    } while (0);

    read_inst[0] = 0x03;
    read_inst[1] = 0x00;
    read_inst[2] = 0x00;
    read_inst[3] = 0x01;

    do {
        printf("Reading from Flash...\r\n");
        xfer.tx_data = read_inst;
        xfer.rx_data = read_buf;
        xfer.data_size = TEST_BUFFER_SIZE;
        status = SPI_MasterTransferBlocking(SPI0_Secure, &xfer);
        if (status != SPI_Status_Ok) {
            printf("Reading from Flash could not start, error %u.\r\n", status);
            break;
        }
        printf("Reading is finished\r\n");
    } while (0);

    for (uint32_t i = 4; i < DIM(page_program) && err < 4; i++) {
        if (page_program[i] != read_buf[i]) {
            err++;
            printf("The %ld is wrong! Data should be %x, not %x\n\r",
                i, page_program[i], read_buf[i]);
        }
    }

    if (err == 0) {
        printf("Success, data is matched!\n\r");
    }
    printf("\n\r");

    asm volatile("bkpt");
    return 0;
}
