# Обзор

Пример тестирует работу SPI с NOR-flash, запись и чтение в дуплексном режиме.

## Описание примера

Пример определения ID номера, записи и чтения NOR-Flash памяти через
SPI в дуплексном режиме master.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- SPI NOR-flash;
- плата ELIOT1m\_MO;
- персональный компьютер;
- анализатор сигналов.

## Работа с программой

- подключиться к UART;
- вызвать скрипт **build.sh**;
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Настройки платы

Подсоединить соответствующие пины платы и флешки (MISO, MOSI, SCK, CS):

| Pin Name | Board Location |
| ------ | ------ |
| GND         | GND     |
| D10/SPISS   | XS4 - 4 |
| D11/SPIMOSI | XS4 - 3 |
| D12/SPIMISO | XS4 - 2 |
| D13/SPISCK  | XS4 - 1 |


## Подготовка к работе

1. Подключите все.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    SPI init on 5MHz                                                               
    SPI is initialized                                                             
    Reading Flash ID...                                                           
    Reading Flash ID is finished                                                   
    Flash ID is 17ef17ef17ef17                                                     
    Erasing sector...                                                             
    Sector erased                                                                 
    Writing into Flash...                                                         
    Writing is finished                                                           
    Reading from Flash...                                                         
    Reading is finished                                                           
    Success, data is matched!  
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
