# Обзор

Пример демонстирует работу RWC таймера с прерываниями.

## Описание примера

В примере производится настройка платы, консоли вывода, таймера реального
времени совместно с прерыванием от будильника (alarm). Начальное время
устанавливается на 12.07.2022 12:5:5. Время будильника устанавливается на
12.07.2022 12:5:25 В консоль вывода попадает информация о текущем времени. После
срабатывания будильника тест завершается на точке останова.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

Для запуска теста необходимо:

- кабель Type-C USB;
- плата ELIoT1m\_MO;
- персональный компьютер.

## Работа с программой

Последовательность действий необходимых для настройки:

1. Подключиться к UART и отладчику.
2. Вызвать скрипт **build.sh**.
3. Выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
   программы на плату.
4. Запустить программу на исполнение с помощью gdb команды `continue`.

## Подготовка к работе

Процесс запуска на плате:

1. Подключите плату.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустите программу.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
RWC example start
<Часть вывода опущена>
Timer example end
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
