# Обзор
Пример погружения процессора в сон и пробуждения по таймеру реального времени.

## Описание примера
В примере выполняется чтение конфигурации блока POWER по умолчанию, установка RWC, после чего процессор ждет 3 секунды и погружается в сон на 3 секунды.
После срабатывания RWC происходит пробуждение процессора и вывод в UART даты и времени.
Далее осуществляется повтор указанных действий в цикле: засыпание (на 3 секунды) — пробуждение (вывод в UART даты и времени 3 секунды).

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера
- Type-C USB кабель;
- плата ELIoT1m\_MO;
- персональный компьютер.

## Работа с программой

### Сборка
- добавить путь до **arm toolchain** в переменную **PATH**;
- выполнить скрипт **build.sh**.

### Подготовка к работе
1. Подключить плату.
2. Открыть последовательный терминал (пример Putty, Minicom) со следующими настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

### Процесс запуска на плате

- запустить программу с помощью gdb-отладчика <br>
`arm-none-eabi-gdb-py -x eliot1.gdbinit`;
- запустить программу на исполнение с помощью gdb команды `continue`;
- после выхода выхода из спящего режима валиден только вывод в UART. Для возобновления сессии отладки можно переподключить OpenOCD и gdb **без** **reset**;
- каждое пробуждение отладочный светодиод на плате будет менять свое состояние.

### Вывод в uart
```
ELIOT01M-MO Standby example start
SysClk = 50000000 Hz
Set datetime successfully on 1 attempt
Date: 12.07.2024        Time: 12:05:05
Switching to standby mode after
 3
 2
 1
Date: 12.07.2024        Time: 12:05:08
Switching to standby mode...
Board CFG: FCLK : 150MHz, SysCLK : 50MHz, VCore 1.10v (DC-DC vlv2), T = 29.50�°C
RWC_ALARM Interrupt: woke up!
Date: 12.07.2024        Time: 12:05:11
Switching to standby mode after
 3
 2
 1
Date: 12.07.2024        Time: 12:05:14
Switching to standby mode... 
```

\* *- название устройства, для которого собран пример*
