#!/usr/bin/env bash

set -o pipefail
set -e

root_dir=`dirname $0`
cd $root_dir
root_dir=$(pwd)

hal_dir="$root_dir/../../../../../../.."

build_dir="$root_dir/../build"
script_dir="$root_dir/../armgcc"
toolchain_file="$hal_dir/tools/cmake_toolchain_files/armgcc.cmake"

bsp_dir="$hal_dir/boards/eliot1m_mo_cfg/armgcc/bsp_core0"

bash $bsp_dir/build.sh

rm -rf "${build_dir}"
mkdir -p "${build_dir}"
cd "${build_dir}"

cmake -G "Unix Makefiles" \
    -DCMAKE_TOOLCHAIN_FILE="${toolchain_file}" \
    "${script_dir}"
make