# Обзор

Пример adc\_polling показывает, как получать значения напряжения на 6-ти
каналах.

Микросхема АЦП ad7124 в режиме непрерывного преобразования и непрерываного
чтения измеряет разность потенциалов между GND и входами A0, A1, A2, A3, A4, A5
на максимальной скорости. Оцифровка производится от канала A0 к A5.

На максимальной скорости (19200Гц) удалось оцифровать 6 каналов за
(1.540 +- 0.001)мс.

На входы возможна подача напряжения не более 5V.

## Toolchain поддерживается

- Embedded GCC ARM 10.3.1.

## Работа с программой

- добавить путь до **arm toolchain** в переменную **PATH**;
- подключиться к UART;
- исполнить скрипт **build.sh**;
- для загрузки программы на плату выполнить команду:
  `arm-none-eabi-gdb -x eliot1.gdbinit`;
- запустить программу на исполнение с помощью gdb команды: `continue`.

## Требования к оборудованию

- кабель Type-C USB;
- плата ELIoT1m\_MO со встроенной микросхемой АЦП AD7124;
- персональный компьютер.

## Настройки платы

Никаких специальных настроек не требуется.

## Подготовка к работе
1. Подключите плату.
2. Откройте последовательный терминал со следующими настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Загрузите программу на целевую плату.
4. Либо нажмите кнопку сброса на плате, либо запустите отладчик в своей среде
   IDE, чтобы запустить демонстрацию.

## Запуск демонстрации

Подключите лабораторный блок питания к выводам A0-A5 и установите напряжения не выше 5V.
При успешном запуске вывод в терминале:

```bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

voltage = 2.0591720413V raw_data = 11843324
voltage = 1.2850143057V raw_data = 10544503
voltage = 0.7807512022V raw_data = 9698490
voltage = 0.4425538114V raw_data = 9131089
voltage = 0.1982730863V raw_data = 8721254
voltage = -0.0002157688V raw_data = 8388245
1.540ms

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```

Убедитесь, что считанные значения совпадают со значениями лабораторного блока питания.
