#!/usr/bin/env bash

set -o pipefail
set -e

QSPICLK_VALUE=$1
BUILD_TYPE=$2

if [ -z $QSPICLK_VALUE ]; then
    QSPICLK_VALUE=48000000
    BUILD_TYPE=Debug
else
    if [ -z $BUILD_TYPE ]; then
        BUILD_TYPE=Debug
    fi
fi

build_dir="./build"
script_dir=".."
toolchain_dir="../../../../../tools/cmake_toolchain_files"

rm -rf "${build_dir}"
mkdir -p "${build_dir}"
cd "${build_dir}"

cmake -G "Unix Makefiles" \
    -DCMAKE_TOOLCHAIN_FILE="${toolchain_dir}/armgcc.cmake" \
    -DCMAKE_BUILD_TYPE=$BUILD_TYPE \
    -DQSPICLK_VALUE=$QSPICLK_VALUE \
    "${script_dir}"
make
