/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @defgroup hal_common Общие определения для библиотеки HAL
 *
 * @brief Общие определения, используемые библиотекой HAL
 */

/*!
 * @addtogroup hal_common
 * @{
 */

/*
 * @file hal_common.h
 *
 * @brief Интерфейс общих определений, используемых библиотекой HAL
 */

#ifndef HAL_COMMON_H
#define HAL_COMMON_H

#include <inttypes.h>
#include <assert.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "hal_device.h"

#if defined(__ICCARM__) || (defined(__CC_ARM) || defined(__ARMCC_VERSION)) || defined(__GNUC__)
/* #if __GNUC__ < 10 || (__GNUC__ == 10 && __GNUC_MINOR__ < 3)
    #error "Unsupported GCC version. Download ARM GCC toolchain v10.3.0 or newer."
#endif */
#include <stddef.h>
#ifndef  __cplusplus
    #pragma GCC diagnostic ignored "-Wstrict-prototypes"
#endif
#endif

#include "hal_device.h"

/* #undef  UNUSED */
#define UNUSED(x) ((void)(x)); /*!< TODO */

/*!
 * @brief Составление номера версии для драйверов
 */
#define MAKE_VERSION(major, minor, bugfix) \
    (((major) << 16) | ((minor) << 8) | (bugfix))

/*!
 * @brief Версия драйвера common
 */
#define HAL_COMMON_DRIVER_VERSION (MAKE_VERSION(0, 1, 0))

/*!
 * @brief Тип, используемый для всех возвращаемых значений статуса и ошибок
 */
typedef int32_t status_t;

/*!
 * @brief Преобразование формата представления данных Big-endian <->
 *        Little-endian
 *
 * @note Размер числа может быть от 1 до 32 битов.
 *
 * @param val      Преобразуемое число
 * @param num_bits Размер числа в битах
 */
void LBBLEndian(uint32_t *val, uint8_t num_bits);

/*!
 * @brief Приведение 32-битного Big-endian числа к Little-endian представлению
 *
 * @param x 32-битное число с Big-endian порядком байтов
 *
 * @return 32-битное число с Little-endian порядком байтов
 */
#if !defined(BE_TO_LE32)
#define BE_TO_LE32(x) \
    ((((unsigned)(x) >> 24) & 0xFF) \
        | (((unsigned)(x) << 24 ) & 0xFF000000) \
        | (((unsigned)(x) >> 8) & 0xFF00)       \
        | (((unsigned)(x) << 8 ) & 0xFF0000))
#endif

/*!
 * @brief Приведение 24-битного Big-endian числа к Little-endian представлению
 *
 * @param x 24-битное число с Big-endian порядком байтов
 *
 * @return 24-битное число с Little-endian порядком байтов
 */
#if !defined(BE_TO_LE24)
#define BE_TO_LE24(x) \
    ((((unsigned)(x) >> 16) & 0xFF) \
        | ((unsigned)(x) & 0xFF00)             \
        | (((unsigned)(x) << 16 ) & 0xFF0000))
#endif

/*!
 * @brief Приведение 16-битного Big-endian числа к Little-endian представлению
 *
 * @param x 16-битное число с Big-endian порядком байтов
 *
 * @return 16-битное число с Little-endian порядком байтов
 */
#if !defined(BE_TO_LE16)
#define BE_TO_LE16(x) \
    ((((unsigned)(x) >> 8) & 0xFF) \
        | (((unsigned)(x) << 8 ) & 0xFF00))
#endif

/*!
 * @brief Выбор минимального значения из двух вариантов
 *
 * @param a Первое значение
 * @param b Второе значение
 *
 * @return Минимальное значение
 */
#if !defined(MIN)
#define MIN(a, b) (((a) < (b)) ? (a) : (b))
#endif

/*!
 * @brief Выбор максимального значения из двух вариантов
 *
 * @param a Первое значение
 * @param b Второе значение
 *
 * @return Максимальное значение
 */
#if !defined(MAX)
#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#endif

/*!
 * @brief Вычисление количества элементов в массиве
 *
 * @param x Массив
 *
 * @return Количество элементов в массиве
 */
#if !defined(DIM)
#define DIM(x) (sizeof(x) / sizeof((x)[0]))
#endif

#if !defined(UINT16_MAX)
#define UINT16_MAX ((uint16_t) -1) /*!< Максимальное значение 16-битного беззнакового целого числа */
#endif

#if !defined(UINT32_MAX)
#define UINT32_MAX ((uint32_t) -1) /*!< Максимальное значение 32-битного беззнакового целого числа */
#endif

/*!
 * @name Макрос подавления предупреждения switch-fallthrough
 *
 * При использовании ARM GCC с включенными флагами -Wextra и
 * -Wimplicit-fallthrough=n для switch-case блока с разделами case, не
 * оканчивающихся оператором break, будет выдаваться предупреждение. Для
 * подавления данного предупреждения, необходимо использовать предлагаемый
 * макрос в конце каждого case, который не "закрыт" оператором break.
 *
 * @{
 */

#if defined(__GNUC__) && !defined(__ARMCC_VERSION)
#define SUPPRESS_FALL_THROUGH_WARNING() __attribute__ ((fallthrough)) /*!< Подавление предупреждения switch-fallthrough */
#else
#define SUPPRESS_FALL_THROUGH_WARNING()                               /*!< Подавление предупреждения switch-fallthrough */
#endif

/*!
 * @}
 */

/*!
 * @brief Вычисление длины битового поля
 *
 * @param top    Старший бит поля
 * @param bottom Младший бит поля
 *
 * @return Длина битового поля
 */
#undef  FIELD_BIT
#define FIELD_BIT(top, bottom) ((top) - (bottom) + 1)

#endif /* HAL_COMMON_H */

/*!
 * @}
 */
