/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @addtogroup bsp_eliot1m_mo_cfg
 * @{
 */

/*!
 * @file eliot1m_mo_gpio.h
 *
 * @brief Карта выводов GPIO для платформы ELIOT1m MO
 */

#ifndef ELIOT1M_MO_GPIO_H
#define ELIOT1M_MO_GPIO_H

/*!
 * @name Карта выводов GPIO и альтернативных функций выводов устройств
 * @{
 */
#define GPIO_PORT_COUNT                    4  /*!< Количество портов GPIO */
#define GPIO_PORTA                         0U /*!< Номер порта A */
#define GPIO_PORTB                         1U /*!< Номер порта B */
#define GPIO_PORTC                         2U /*!< Номер порта C */
#define GPIO_PORTD                         3U /*!< Номер порта D */
#define GPIO_PORTPIN(port,pin)             \
    ((((port) & 0xF) << 4) | ((pin) & 0xF)) /*!< Создать соответствие порт-вывод */
#define GPIO_PORTPIN_GET_PIN_NUM(portpin)  ((portpin) & 0xF) /*!< Получить номер вывода из соответствия порт-вывод */
#define GPIO_PORTPIN_GET_MASK(portpin)     \
    (1 << GPIO_PORTPIN_GET_PIN_NUM(portpin)) /*!< Получить маску вывода из соответствия порт-вывод */
#define GPIO_PORTPIN_GET_PORT_NUM(portpin) (((portpin) >> 4) & 0xF) /*!< Получить номер порта из соответствия порт-вывод */

/*!
 * @brief Карта выводов GPIO
 */
typedef enum {
    GPIO_PA0          = GPIO_PORTPIN(GPIO_PORTA, 0),
    GPIO_PA1          = GPIO_PORTPIN(GPIO_PORTA, 1),
    GPIO_PA2          = GPIO_PORTPIN(GPIO_PORTA, 2),
    GPIO_PA3          = GPIO_PORTPIN(GPIO_PORTA, 3),
    GPIO_PA4          = GPIO_PORTPIN(GPIO_PORTA, 4),
    GPIO_PA5          = GPIO_PORTPIN(GPIO_PORTA, 5),
    GPIO_PA6          = GPIO_PORTPIN(GPIO_PORTA, 6),
    GPIO_PA7          = GPIO_PORTPIN(GPIO_PORTA, 7),
    GPIO_PA8          = GPIO_PORTPIN(GPIO_PORTA, 8),
    GPIO_PA9          = GPIO_PORTPIN(GPIO_PORTA, 9),
    GPIO_PA10         = GPIO_PORTPIN(GPIO_PORTA, 10),
    GPIO_PA11         = GPIO_PORTPIN(GPIO_PORTA, 11),
    GPIO_PA12         = GPIO_PORTPIN(GPIO_PORTA, 12),
    GPIO_PA13         = GPIO_PORTPIN(GPIO_PORTA, 13),
    GPIO_PA14         = GPIO_PORTPIN(GPIO_PORTA, 14),
    GPIO_PA15         = GPIO_PORTPIN(GPIO_PORTA, 15),
    GPIO_PB0          = GPIO_PORTPIN(GPIO_PORTB, 0),
    GPIO_PB1          = GPIO_PORTPIN(GPIO_PORTB, 1),
    GPIO_PB2          = GPIO_PORTPIN(GPIO_PORTB, 2),
    GPIO_PB3          = GPIO_PORTPIN(GPIO_PORTB, 3),
    GPIO_PB4          = GPIO_PORTPIN(GPIO_PORTB, 4),
    GPIO_PB5          = GPIO_PORTPIN(GPIO_PORTB, 5),
    GPIO_PB6          = GPIO_PORTPIN(GPIO_PORTB, 6),
    GPIO_PB7          = GPIO_PORTPIN(GPIO_PORTB, 7),
    GPIO_PB8          = GPIO_PORTPIN(GPIO_PORTB, 8),
    GPIO_PB9          = GPIO_PORTPIN(GPIO_PORTB, 9),
    GPIO_PB10         = GPIO_PORTPIN(GPIO_PORTB, 10),
    GPIO_PB11         = GPIO_PORTPIN(GPIO_PORTB, 11),
    GPIO_PB12         = GPIO_PORTPIN(GPIO_PORTB, 12),
    GPIO_PB13         = GPIO_PORTPIN(GPIO_PORTB, 13),
    GPIO_PB14         = GPIO_PORTPIN(GPIO_PORTB, 14),
    GPIO_PB15         = GPIO_PORTPIN(GPIO_PORTB, 15),
    GPIO_PC0          = GPIO_PORTPIN(GPIO_PORTC, 0),
    GPIO_PC1          = GPIO_PORTPIN(GPIO_PORTC, 1),
    GPIO_PC2          = GPIO_PORTPIN(GPIO_PORTC, 2),
    GPIO_PC3          = GPIO_PORTPIN(GPIO_PORTC, 3),
    GPIO_PC4          = GPIO_PORTPIN(GPIO_PORTC, 4),
    GPIO_PC5          = GPIO_PORTPIN(GPIO_PORTC, 5),
    GPIO_PC6          = GPIO_PORTPIN(GPIO_PORTC, 6),
    GPIO_PC7          = GPIO_PORTPIN(GPIO_PORTC, 7),
    GPIO_PC8          = GPIO_PORTPIN(GPIO_PORTC, 8),
    GPIO_PC9          = GPIO_PORTPIN(GPIO_PORTC, 9),
    GPIO_PC10         = GPIO_PORTPIN(GPIO_PORTC, 10),
    GPIO_PC11         = GPIO_PORTPIN(GPIO_PORTC, 11),
    GPIO_PC12         = GPIO_PORTPIN(GPIO_PORTC, 12),
    GPIO_PC13         = GPIO_PORTPIN(GPIO_PORTC, 13),
    GPIO_PC14         = GPIO_PORTPIN(GPIO_PORTC, 14),
    GPIO_PC15         = GPIO_PORTPIN(GPIO_PORTC, 15),
    GPIO_PD0          = GPIO_PORTPIN(GPIO_PORTD, 0),
    GPIO_PD1          = GPIO_PORTPIN(GPIO_PORTD, 1),
    GPIO_PD2          = GPIO_PORTPIN(GPIO_PORTD, 2),
    GPIO_PD3          = GPIO_PORTPIN(GPIO_PORTD, 3),
    GPIO_PD4          = GPIO_PORTPIN(GPIO_PORTD, 4),
    GPIO_PD5          = GPIO_PORTPIN(GPIO_PORTD, 5),
    GPIO_PD6          = GPIO_PORTPIN(GPIO_PORTD, 6),
    GPIO_PD7          = GPIO_PORTPIN(GPIO_PORTD, 7),
    GPIO_PD8          = GPIO_PORTPIN(GPIO_PORTD, 8),
    GPIO_PD9          = GPIO_PORTPIN(GPIO_PORTD, 9),
    GPIO_PD10         = GPIO_PORTPIN(GPIO_PORTD, 10),
    GPIO_PD11         = GPIO_PORTPIN(GPIO_PORTD, 11),
    GPIO_PD12         = GPIO_PORTPIN(GPIO_PORTD, 12),
    GPIO_PD13         = GPIO_PORTPIN(GPIO_PORTD, 13),
    GPIO_PD14         = GPIO_PORTPIN(GPIO_PORTD, 14),
    GPIO_PD15         = GPIO_PORTPIN(GPIO_PORTD, 15),

    /* AF0 SYSTEM */
    GPIO_PMU_DTB      = GPIO_PA9,
    GPIO_JTDO         = GPIO_PA10,
    GPIO_JTDI         = GPIO_PA11,
    GPIO_JNTRST       = GPIO_PA12,
    GPIO_JTCK         = GPIO_PA13,
    GPIO_SWCLK        = GPIO_PA13,
    GPIO_JTMS         = GPIO_PA14,
    GPIO_SWDIO        = GPIO_PA14,
    GPIO_MCO          = GPIO_PA15,

    GPIO_TRACE_CK     = GPIO_PB2,
    GPIO_TRACE_D3     = GPIO_PB7,
    GPIO_TRACE_D2     = GPIO_PB8,
    GPIO_TRACE_D1     = GPIO_PB9,
    GPIO_TRACE_D0     = GPIO_PB10,

    GPIO_FBIST_TCK    = GPIO_PD6,
    GPIO_FBIST_TMS    = GPIO_PD9,
    GPIO_FBIST_TDI    = GPIO_PD10,
    GPIO_FBIST_TDO    = GPIO_PD11,

    /* AF1 PWM, VTU0, VTU1*/
    GPIO_PWM_OUTA0    = GPIO_PB3,
    GPIO_PWM_OUTB0    = GPIO_PB4,
    GPIO_PWM_OUTA1    = GPIO_PA2,
    GPIO_PWM_OUTB1    = GPIO_PA3,
    GPIO_PWM_OUTA2    = GPIO_PA4,
    GPIO_PWM_OUTB2    = GPIO_PA5,
    GPIO_PWM_OUTA3    = GPIO_PB9,
    GPIO_PWM_OUTB3    = GPIO_PB10,

    /* ************ I2C 0 ************ */
    GPIO_I2C0_SDA       = GPIO_PD2,
    GPIO_I2C0_SCL       = GPIO_PD3,

     /* GPIO_I2C0_SDA       = GPIO_PD2, */
     /* GPIO_I2C0_SCL       = GPIO_PD3, */

     /* ************ I2C 1 ************ */
    GPIO_I2C1_SDA       = GPIO_PB9,
    GPIO_I2C1_SCL       = GPIO_PB10,

     /* GPIO_I2C1_SDA       = GPIO_PD4, */
     /* GPIO_I2C1_SCL       = GPIO_PD5, */
    /* AF3 SPI0, SPI1 */
    GPIO_SPI0_SCK     = GPIO_PA2,
    GPIO_SPI0_MOSI    = GPIO_PA3,
    GPIO_SPI0_MISO    = GPIO_PA4,
    GPIO_SPI0_SS      = GPIO_PA5,
    /* GPIO_SPI1_SCK     = GPIO_PA9, */

    GPIO_SPI1_SCK     = GPIO_PB2,
    /* GPIO_SPI1_SS      = GPIO_PB3, */
    GPIO_SPI1_SS      = GPIO_PB7,
    /* GPIO_SPI1_SS      = GPIO_PC2, */
    /* GPIO_SPI1_SS      = GPIO_PB4, */
    /* GPIO_SPI1_SS      = GPIO_PB5, */
    /* GPIO_SPI1_SS      = GPIO_PB6, */
    /* GPIO_SPI1_MOSI    = GPIO_PB7, */
    /* GPIO_SPI1_SS      = GPIO_PB8, */
    /* GPIO_SPI1_SS      = GPIO_PB9, */
    /* GPIO_SPI1_SS      = GPIO_PB10, */
    /* GPIO_SPI1_SCK     = GPIO_PB11, */

    /* GPIO_SPI0_MOSI    = GPIO_PC0, */
    /* GPIO_SPI0_MISO    = GPIO_PC1, */
    /* GPIO_SPI0_SCK     = GPIO_PC2, */
    /* GPIO_SPI0_SS1     = GPIO_PC3, */
    GPIO_SPI1_MOSI    = GPIO_PC4,
    GPIO_SPI1_MISO    = GPIO_PC5,
    /* GPIO_SPI1_SS      = GPIO_PC14, */
    /* GPIO_SPI1_SS      = GPIO_PC15, */

    /* GPIO_SPI1_SS      = GPIO_PD0, */
    /* GPIO_SPI1_SS      = GPIO_PD1, */
    /* GPIO_SPI1_MOSI    = GPIO_PD4, */
    /* GPIO_SPI1_MISO    = GPIO_PD5, */
    /* GPIO_SPI1_SS      = GPIO_PD12, */
    /* GPIO_SPI1_SS      = GPIO_PD13, */
    /* GPIO_SPI1_SS      = GPIO_PD14, */
    /* GPIO_SPI1_SS      = GPIO_PD15, */

    /* AF4 UART0, UART1, UART2, UART3 */
    /* GPIO_UART0_TXD    = GPIO_PA0, */
    /* GPIO_UART0_RXD    = GPIO_PA1, */
    GPIO_UART0_CK     = GPIO_PA15,

    GPIO_UART0_TXD    = GPIO_PA0,
    GPIO_UART0_RXD    = GPIO_PA1,
    GPIO_UART3_RXD    = GPIO_PB2,
    GPIO_UART0_CTS    = GPIO_PB7,
    GPIO_UART0_RE     = GPIO_PB7,
    GPIO_UART0_RTS    = GPIO_PB8,
    GPIO_UART0_DE     = GPIO_PB8,
    GPIO_UART1_TXD    = GPIO_PD0,
    GPIO_UART1_RXD    = GPIO_PD1,

    GPIO_UART2_TXD    = GPIO_PC9,
    GPIO_UART2_RXD    = GPIO_PC10,
    /* GPIO_UART0_CK     = GPIO_PC6, */
    /* GPIO_UART0_CTS    = GPIO_PC7, */
    /* GPIO_UART0_RE     = GPIO_PC7, */
    /* GPIO_UART0_RTS    = GPIO_PC8, */
    /* GPIO_UART0_DE     = GPIO_PC8, */
    /* GPIO_UART2_TXD    = GPIO_PC9, */
    /* GPIO_UART2_RXD    = GPIO_PC10, */
    GPIO_UART3_TXD    = GPIO_PC15,

    /* GPIO_UART1_TXD    = GPIO_PD0, */
    /* GPIO_UART1_RXD    = GPIO_PD1, */
    /* GPIO_UART3_TXD    = GPIO_PD4, */
    /* GPIO_UART3_RXD    = GPIO_PD5, */
    /* GPIO_UART1_TXD    = GPIO_PD12, */
    /* GPIO_UART1_RXD    = GPIO_PD13, */
    /* GPIO_UART3_TXD    = GPIO_PD14, */
    /* GPIO_UART3_RXD    = GPIO_PD15, */

    /*  AF5 CAN, GNSS, USB */
    GPIO_GNSS_SIG1_I0 = GPIO_PA0,
    GPIO_GNSS_SIG1_I1 = GPIO_PA1,
    GPIO_GNSS_SIG1_Q0 = GPIO_PA2,
    GPIO_GNSS_SIG1_Q1 = GPIO_PA3,
    GPIO_GNSS_SIG2_I0 = GPIO_PA4,
    GPIO_GNSS_SIG2_I1 = GPIO_PA5,
    GPIO_GNSS_SIG2_Q0 = GPIO_PA6,
    GPIO_GNSS_SIG2_Q1 = GPIO_PA7,
    GPIO_GNSS_MCLK    = GPIO_PA8,
    GPIO_GNSS_OPPS    = GPIO_PA9,

    GPIO_ULPI_D0      = GPIO_PB3,
    GPIO_ULPI_D1      = GPIO_PB4,
    GPIO_ULPI_D2      = GPIO_PB5,
    GPIO_ULPI_D3      = GPIO_PB6,
    GPIO_CAN_TXD      = GPIO_PB7,
    GPIO_CAN_RXD      = GPIO_PB8,
    /* GPIO_CAN_TXD      = GPIO_PB9, */
    /* GPIO_CAN_RXD      = GPIO_PB10, */
    /* GPIO_GNSS_OPPS    = GPIO_PB11, */
    GPIO_ULPI_D4      = GPIO_PB12,
    GPIO_ULPI_D5      = GPIO_PB13,
    GPIO_ULPI_D6      = GPIO_PB14,
    GPIO_ULPI_D7      = GPIO_PB15,

    GPIO_ULPI_NXT     = GPIO_PC0,
    GPIO_ULPI_CK      = GPIO_PC1,
    GPIO_ULPI_DIR     = GPIO_PC2,
    GPIO_ULPI_STP     = GPIO_PC3,
    /* GPIO_CAN_TXD      = GPIO_PC4, */
    /* GPIO_CAN_RXD      = GPIO_PC5, */
    /* GPIO_GNSS_OPPS    = GPIO_PC15, */

    /* GPIO_CAN_TXD      = GPIO_PD4, */
    /* GPIO_CAN_RXD      = GPIO_PD5, */
    /* GPIO_CAN_TXD      = GPIO_PD12, */
    /* GPIO_CAN_RXD      = GPIO_PD13, */
    /* GPIO_CAN_TXD      = GPIO_PD14, */
    /* GPIO_CAN_RXD      = GPIO_PD15, */

    /* AF6 QSPI, SPI2 */
    GPIO_SPI2_SCK     = GPIO_PA4,
    GPIO_SPI2_MOSI    = GPIO_PA5,
    GPIO_SPI2_MISO    = GPIO_PA6,
    GPIO_SPI2_SS      = GPIO_PA7,

    /* GPIO_SPI2_SCK     = GPIO_PB2, */
    /* GPIO_SPI2_MOSI    = GPIO_PB9, */
    /* GPIO_SPI2_MISO    = GPIO_PB10, */
    /* GPIO_SPI2_SCK     = GPIO_PB12, */
    /* GPIO_SPI2_MOSI    = GPIO_PB13, */
    /* GPIO_SPI2_MISO    = GPIO_PB14, */
    /* GPIO_SPI2_SS      = GPIO_PB15, */

    /* GPIO_SPI2_SCK     = GPIO_PC0, */
    /* GPIO_SPI2_MOSI    = GPIO_PC1, */
    /* GPIO_SPI2_MISO    = GPIO_PC2, */
    /* GPIO_SPI2_SS      = GPIO_PC3, */
    /* GPIO_SPI2_SS      = GPIO_PC15, */

    GPIO_QSPI_SCK     = GPIO_PD4,
    GPIO_QSPI_SS      = GPIO_PD5,
    GPIO_QSPI_IO0     = GPIO_PD12,
    GPIO_QSPI_IO1     = GPIO_PD13,
    GPIO_QSPI_IO2     = GPIO_PD14,
    GPIO_QSPI_IO3     = GPIO_PD15,

    /* AF7 SDMMC, SMC */
    GPIO_SMC_DA5      = GPIO_PA9,
    GPIO_SMC_DA6      = GPIO_PA10,
    GPIO_SMC_DA7      = GPIO_PA11,
    GPIO_SMC_DA8      = GPIO_PA12,
    GPIO_SMC_DA9      = GPIO_PA13,
    GPIO_SMC_DA10     = GPIO_PA14,

    GPIO_SMC_CRE      = GPIO_PB1,
    GPIO_SMC_A16      = GPIO_PB3,
    GPIO_SMC_A17      = GPIO_PB4,
    GPIO_SMC_A18      = GPIO_PB5,
    GPIO_SMC_A19      = GPIO_PB6,
    GPIO_SMC_A20      = GPIO_PB7,
    GPIO_SMC_A21      = GPIO_PB8,
    GPIO_SMC_A22      = GPIO_PB9,
    GPIO_SMC_A23      = GPIO_PB10,
    GPIO_SMC_DA0      = GPIO_PB11,
    GPIO_SMC_DA1      = GPIO_PB12,
    GPIO_SMC_DA2      = GPIO_PB13,
    GPIO_SMC_DA3      = GPIO_PB14,
    GPIO_SMC_DA4      = GPIO_PB15,

    GPIO_SMC_DA11     = GPIO_PC6,
    GPIO_SMC_DA12     = GPIO_PC7,
    GPIO_SMC_DA13     = GPIO_PC8,
    GPIO_SMC_DA14     = GPIO_PC9,
    GPIO_SMC_DA15     = GPIO_PC10,
    GPIO_SMC_NWE      = GPIO_PC11,
    GPIO_SMC_CLK      = GPIO_PC12,
    GPIO_SMC_NOE      = GPIO_PC13,
    GPIO_SMC_NCS0     = GPIO_PC14,
    GPIO_SMC_NCS1     = GPIO_PC15,

    GPIO_SDMMC_CD     = GPIO_PD4,
    GPIO_SDMMC_WP     = GPIO_PD5,
    GPIO_SDMMC_CK     = GPIO_PD6,
    GPIO_SDMMC_CMD    = GPIO_PD7,
    GPIO_SDMMC_D0     = GPIO_PD8,
    GPIO_SDMMC_D1     = GPIO_PD9,
    GPIO_SDMMC_D2     = GPIO_PD10,
    GPIO_SDMMC_D3     = GPIO_PD11,
    GPIO_SDMMC_D4     = GPIO_PD12,
    GPIO_SDMMC_D5     = GPIO_PD13,
    GPIO_SDMMC_D6     = GPIO_PD14,
    GPIO_SDMMC_D7     = GPIO_PD15,
} gpio_pin_name_t;
/*!
 * @}
 */

#endif /* ELIOT1M_MO_GPIO_H */

/*!
 * @}
 */
