/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




/*!
 * @defgroup bsp Библиотека BSP
 *
 * @brief Пакет поддержки платформы (Board Support Package, BSP)
 *
 * Собирается в виде static библиотеки, которую необходимо включать в каждый
 * пример или программу baremetal.
 */

/*!
 * @defgroup bsp_eliot1m_mo_cfg Пакет поддержки для ELIOT1m MO
 *
 * @ingroup bsp
 *
 * @brief Пакет поддержки для ELIOT1m MO
 */

/*!
 * @addtogroup bsp_eliot1m_mo_cfg
 * @{
 */

/*!
 * @file eliot1_board.h
 *
 * @brief Интерфейс пакета поддержки платформы ELIOT1m MO
 */

#ifndef ELIOT1_BOARD_H
#define ELIOT1_BOARD_H

#include "eliot1_config.h"

#define BOARD_NAME          "ELIOT01M-MO"  /*!< Название платы */

#define BOARD_CHIP_REV      1             /*!< Ревизия процессора */
#ifndef BOARD_XTI_FREQ
#define BOARD_XTI_FREQ      BOARD_XTI_24MHZ /*!< Частота внешнего генератора/резонатора */
#endif
#ifndef BOARD_PWR_CONFIG
#define BOARD_PWR_CONFIG    2U            /*!< Конфигурация по умолчанию 1,1в */
#endif
#ifndef BOARD_FCLK_FREQ
#define BOARD_FCLK_FREQ     BOARD_Config_GetFCLKFreq()    /*!< Частота Core1 и источник частоты для SYSCLK */
#endif
#ifndef BOARD_SYSCLK_FREQ
#define BOARD_SYSCLK_FREQ   BOARD_Config_GetSysCLKFreq()  /*!< Частота Core0 и периферии */
#endif
#ifndef BOARD_GNSS_FREQ
#define BOARD_GNSS_FREQ     BOARD_Config_GetGNSSCLKFreq() /*!< Частота модуля GNSS */
#endif
#ifndef BOARD_QSPI_FREQ
#define BOARD_QSPI_FREQ     BOARD_Config_GetQSPICLKFreq() /*!< Частота модуля QSPI */
#endif
#ifndef BOARD_HFI_FREQUENCY
#define BOARD_HFI_FREQUENCY 14700000U     /*!< Частота внутреннего генератора высокой частоты HFI */
/*!
* @brief Включение точной регулировки частоты PLL от источника HFI.
*
* @note Параметры должны предварительно быть посчитаны для выбранных частот BOARD_HFI_FREQUENCY и BOARD_MAINCLK_FREQ
*/
#ifndef BOARD_HFI_MAINCLK_FREQ
#define BOARD_HFI_MAINCLK_FREQ  300000000U /*!< Основная частота после генератора PLL в режиме тактирования HFI */
#endif
#define BOARD_HFI_PLL_SEL       0         /*!< Множитель PLL для частоты HFI */
#define BOARD_HFI_PLL_MAN_EN    1         /*!< Включение ручного режима установки множителя PLL */
#define BOARD_HFI_PLL_MAN_NR    5         /*!< Предделитель опорной частоты HFI */
#define BOARD_HFI_PLL_MAN_NF    102       /*!< Множитель опорной частоты HFI */
#define BOARD_HFI_PLL_MAN_OD    1         /*!< Предделитель частоты PLL */
#endif
#ifndef BOARD_XTI32_FREQ
#define BOARD_XTI32_FREQ    32768U        /*!< Частота внешнего генератора низкой частоты */
#endif
#ifndef BOARD_LFI_FREQUENCY
#define BOARD_LFI_FREQUENCY 32768U        /*!< Частота внутреннего генератора низкой частоты LFI */
#endif

/* Вывод печати функции 'printf'. */
#ifndef BOARD_CONSOLE_SEMIHOSTING
#ifndef BOARD_CONSOLE_UART
#define BOARD_CONSOLE_UART  UART1         /*!< UART для печати на плате */
#endif
#else
#undef BOARD_CONSOLE_UART
#endif

#define CLOCK_BASE CLKCTR                /*!< Базовый адрес для блока тактирования */

#ifndef BOARD_TIMER
#define BOARD_TIMER TIM0                 /*!< Счетчик отсчета времени */
#endif

/* Карта выводов GPIO для подключаемых устройств. */
#include "eliot1m_mo_gpio.h"

/* Отладочные светодиоды. */
#define BOARD_DEBUG_LED0_PIN GPIO_PA0    /*!< Отладочный светодиод LED0 */
#define BOARD_DEBUG_LED1_PIN GPIO_PA1    /*!< Отладочный светодиод LED1 */

/* Пользовательские кнопки. */
#define BOARD_BUTTON4_PIN GPIO_PC10    /*!< Пользовательская кнопка SB4 */

/* Общие заголовочные файлы. */
#include "hal_common.h"
#include "hal_clkctr.h"
#include "hal_gpio.h"
#include "hal_ioim.h"
#include "hal_uart.h"
#include "hal_timer.h"
#include "hal_power.h"
#include "hal_flash.h"

/*!
 * @brief Полная инициализация всей платы
 *
 * Вызов функций:
 *  - BOARD_InitCLKCTR()
 *  - BOARD_EnableICache()
 *  - BOARD_InitTimer()
 *  - BOARD_InitConsole()
 */
void BOARD_InitAll();

/*!
 * @brief Настройка частот CPU и периферии
 */
void BOARD_InitCLKCTR();

/*!
 * @brief Включение кэша команд в памяти Flash
 */
void BOARD_EnableICache();

/*!
 * @brief Инициализация отладочной печати
 */
void BOARD_InitConsole();

/*!
 * @brief Включение XIP
 */
void BOARD_EnableXIP();

#ifdef BOARD_TIMER

/*!
 * @brief Инициализация таймера отсчета времени
 */
void BOARD_InitTimer();

/*!
 * @brief Ожидание времени в микросекундах
 *
 * @param us Количество микросекунд
 */
void BOARD_Udelay(uint32_t us);

/*!
 * @brief Получение общего времени таймера в микросекундах
 *
 * @return Количество микросекунд
 */
uint64_t BOARD_GetTime();

#endif /* BOARD_TIMER */

#endif /* ELIOT1_BOARD_H */

/*!
 * @}
 */
