import hid

VID = 0xcafe
PID = 0x4004
# test data
data_to_send = 'test'

try:
    # Open device with VID and PID
    device = hid.device()
    device.open(VID, PID)

    # Convert string to list of int
    list_int = [ord(char) for char in data_to_send]
    # Send data to HID device
    device.write(list_int)

    # Read data
    response = device.read(len(list_int), 1000)
    # You should take echo back data
    if response == list_int:
        print('Test string has been got back')
    else:
        print('Wrong data')
finally:
    device.close()
