# Обзор

Пример считает расстояния между трехмерными векторами.

## Описание примера

Пример рассчитывает Евклидово, Манхэттенское расстояния
и расстояние Чебышева для трехмерных векторов.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

- Type-C USB кабель;
- плата ELIOT1M_MO;
- персональный компьютер.

## Подготовка к работе

1. Подключить все.
2. Открыть последовательный терминал (пример Putty, Minicom) со следующими настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустить OpenOCD командой:

```bash
<path_to_openocd> -c 'set USE_NRST 1' -c 'tcl_port disabled' -c 'telnet_port disabled' -f board/eliot1m_mo.cfg
```

## Работа с программой

- Выполнить команду `bash build.sh` для сборки примера.
- Выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки программы на плату.
- Запустить программу на исполнение с помощью gdb команды `continue`.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Board CFG: FCLK : 150MHz, SysCLK : 50MHz, VCore 1.10v (DC-DC vlv2), T = X°C
    CORE_0: Started
    Euclidean distance between 2 vectors is N
    Manhattan distance between 2 vectors is M
    Chebyshev distance between 2 vectors is K
    Test was executed in A ms # время выполнения теста
    CORE_1: Started
    Euclidean distance between 2 vectors is N
    Manhattan distance between 2 vectors is M
    Chebyshev distance between 2 vectors is K
    Test was executed in B ms # время выполнения теста
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
