/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"
#include <math.h>

#define PI 3.1415926535
#define P_MALE 0.5
#define P_FEMALE 0.5

struct parameters {
    float height;
    float weight;
    float footsize;
} male_m, female_m, male_v, female_v, sample;

uint32_t t1, t2;
float post_num_m, post_num_f, evidence;

int main()
{
    struct parameters male_m = {5.855f, 176.25f, 11.25f};
    struct parameters female_m = {5.4175f, 132.5f, 7.5f};
    struct parameters male_v = {0.035033f, 122.92f, 0.91667f};
    struct parameters female_v = {0.097225f, 558.33f, 1.6667f};
    struct parameters sample = {6.0f, 130.0f, 8.0f};
    float ph_m, pw_m, pf_m, ph_f, pw_f, pf_f;

    BOARD_InitAll();
    printf("CORE_%ld: Started\r\n", CPU_IDENTITY->CPUID);
    t1 = BOARD_GetTime();

    ph_m = (1 / sqrt(2 * PI * male_v.height)) * exp((-1 * pow((sample.height - male_m.height), 2)) / (2 * male_v.height));
    pw_m = (1 / sqrt(2 * PI * male_v.weight)) * exp((-1 * pow((sample.weight - male_m.weight), 2)) / (2 * male_v.weight));
    pf_m = (1 / sqrt(2 * PI * male_v.footsize)) * exp((-1 * pow((sample.footsize - male_m.footsize), 2)) / (2 * male_v.footsize));
    ph_f = (1 / sqrt(2 * PI * female_v.height)) * exp((-1 * pow((sample.height - female_m.height), 2)) / (2 * female_v.height));
    pw_f = (1 / sqrt(2 * PI * female_v.weight)) * exp((-1 * pow((sample.weight - female_m.weight), 2)) / (2 * female_v.weight));
    pf_f = (1 / sqrt(2 * PI * female_v.footsize)) * exp((-1 * pow((sample.footsize - female_m.footsize), 2)) / (2 * female_v.footsize));

    evidence = P_MALE * ph_m * pw_m * pf_m + P_FEMALE * ph_f * pw_f * pf_f;
    post_num_m = (P_MALE * ph_m * pw_m * pf_m) / evidence;
    post_num_f = (P_FEMALE * ph_f * pw_f * pf_f) / evidence;
    t2 = BOARD_GetTime();

    if (post_num_m > post_num_f)
        printf("The sample is male\r\n");
    else if (post_num_m < post_num_f)
        printf("The sample is female\r\n");
    else
        printf("The sample is undefined\r\n");

    printf("Test was executed in %.3lfms\r\n", ((t2 - t1) / 1000.0));
    SYSCTR_Secure->CPUWAIT = 0;
    asm volatile("bkpt");
    return 0;
}
