/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"

#define RX_RING_BUFFER_SIZE   40U
#define TX_RING_BUFFER_SIZE   40U

uint8_t rx_ring_buffer[RX_RING_BUFFER_SIZE] = {0}; /* Кольцевой буфер Rx */
uint8_t tx_ring_buffer[TX_RING_BUFFER_SIZE] = {0}; /* Кольцевой буфер Tx */

const char str1[] = "First string\r\n"; /* Первая строка размером 15 */
const char str2[] = "Second string longer.......\r\n"; /* Вторая строка размером 30 */
const char str3[] = "Third string\r\n"; /* Третья строка размером 15 */
const char str4[] = "\r\nFourth string longer.....\r\n"; /* Четвертая строка размером 30 */
const char str5[] = "Fifth string\r\n"; /* Пятая строка размером 15 */

/*!
 * @brief UART user callback
 */
void USART_UserCallback(UART_Type *base, struct uart_handle *handle,
        enum uart_status status, void *userData)
{
    UNUSED(base);
    UNUSED(handle);
    UNUSED(userData);
    UNUSED(status);
}

int main()
{
    size_t tx_len;
    enum uart_status status;
    struct uart_handle uart_handle;
    struct uart_transfer send_xfer;

    BOARD_InitAll();

    BOARD_Udelay(1000000);

    do {
        if ((status = UART_TransferCreateHandle(BOARD_CONSOLE_UART,
                &uart_handle, USART_UserCallback, NULL)) != UART_Status_Ok) {
            printf("Error : UART_TransferCreateHandle() : %d\r\n", status);
            break;
        }
        if ((status = UART_TransferStartRingBuffer(BOARD_CONSOLE_UART,
                &uart_handle, rx_ring_buffer, RX_RING_BUFFER_SIZE)) != UART_Status_Ok) {
            printf("Error : UART_TransferStartRingBuffer() : %d\r\n", status);
            break;
        }
        if ((status = UART_TransferStartTxRingBuffer(BOARD_CONSOLE_UART,
                &uart_handle, tx_ring_buffer, TX_RING_BUFFER_SIZE)) != UART_Status_Ok) {
            printf("Error : UART_TransferStartTxRingBuffer() : %d\r\n", status);
            break;
        }

        /* Неблокирующая операция отправки данных. */
        send_xfer.tx_data = (const uint8_t*) str1;
        send_xfer.data_size = sizeof (str1);
        if ((status = UART_TransferSendNonBlocking(BOARD_CONSOLE_UART,
                &uart_handle, &send_xfer)) != UART_Status_Ok) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str1 : UART_TransferSendNonBlocking() : %d\r\n", status);
            break;
        }

        /* Прямая запись в кольцевой буфер отправки. */
        tx_len = sizeof (str2);
        if ((status = UART_WriteTxRing(BOARD_CONSOLE_UART, &uart_handle,
                (const uint8_t*) str2, &tx_len)) != UART_Status_Ok) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str2 : UART_WriteTxRing() : %d\r\n", status);
            break;
        }
		
        /* Строка должна полностью поместиться в кольцевой буфер. */
        if (tx_len != 0) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str2 : tx_len %d != 0\r\n", tx_len);
            break;
        }

        /* Третья запись в кольцевой буфер отправки. */
        tx_len = sizeof (str3);
        if ((status = UART_WriteTxRing(BOARD_CONSOLE_UART, &uart_handle,
                (const uint8_t*) str3, &tx_len)) != UART_Status_Ok) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str3 : UART_WriteTxRing() : %d\r\n", status);
            break;
        }
        /* Строка не должна полностью поместиться в кольцевой буфер. */
        if (tx_len == 0) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str3 : tx_len == 0\r\n");
            break;
        }

        /* Ожидание опустошения кольцевого буфера. */
        while (UART_TransferGetTxRingBufferLength(&uart_handle))
            ;

        /* Четвертая запись в кольцевой буфер отправки. */
        tx_len = sizeof (str4);
        if ((status = UART_WriteTxRing(BOARD_CONSOLE_UART, &uart_handle,
                (const uint8_t*) str4, &tx_len)) != UART_Status_Ok) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str4 : UART_WriteTxRing() : %d\r\n", status);
            break;
        }
        /* Строка должна полностью поместиться в кольцевой буфер. */
        if (tx_len != 0) {
            /* Отключение кольцевого буфера. */
            UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);
            printf("Error : str4 : tx_len %d != 0\r\n", tx_len);
            break;
        }

        /* Ожидание опустошения кольцевого буфера. */
        while (UART_TransferGetTxRingBufferLength(&uart_handle))
            ;
        /* Отключение кольцевого буфера. */
        UART_TransferStopTxRingBuffer(BOARD_CONSOLE_UART, &uart_handle);

        /* Запись в кольцевой буфер отправки не должна выполняться. */
        tx_len = sizeof (str4);
        if ((status = UART_WriteTxRing(BOARD_CONSOLE_UART, &uart_handle,
                (const uint8_t*) str4, &tx_len)) != UART_Status_TxRingBufferNull) {
            printf("Error : str4 : UART_WriteTxRing() : %d\r\n", status);
            break;
        }
        /* Проверка отправки в обычном режиме. */
        send_xfer.tx_data = (const uint8_t*) str5;
        send_xfer.data_size = sizeof (str5);
        if ((status = UART_TransferSendNonBlocking(BOARD_CONSOLE_UART,
                &uart_handle, &send_xfer)) != UART_Status_Ok) {
            printf("Error : str5 : UART_TransferSendNonBlocking() : %d\r\n", status);
            break;
        }
        printf("\r\nTest : Ok\r\n");
        goto exit_test;
    } while (0);

    printf("\r\nTest : Failed\r\n");

    exit_test:
        BOARD_Udelay(1000000);

        asm volatile("bkpt");

        return 0;
}
