/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"

struct rwc_config config;

unsigned int flag = 1;
/* Стартовое время */
rtc_datetime_t start_time = {
    .year = 2022,
    .month = 7,
    .day = 12,
    .hour = 12,
    .minute = 5,
    .second = 5,
};

/* Время будильника */
rtc_datetime_t alarm_time = {
    .year = 2022,
    .month = 7,
    .day = 12,
    .hour = 12,
    .minute = 5,
    .second = 25,
};

/* Текущее времени */
rtc_datetime_t current_time;

/* Форматированный вывод даты */
void DisplayDatatime(rtc_datetime_t time)
{
    printf("Data: %d.%d.%d\tTime: %d:%d:%d\r\n",
        time.day,
        time.month,
        time.year,
        time.hour,
        time.minute,
        time.second);
}

/* Общий обработчик прерывания */
void InterruptHandler(RWC_Type *base)
{
    printf("InterruptHandler\r\n");
    flag = 0;
    RWC_EnableAlarmTimerInterruptFromDPD(base, 0);
    RWC_InterruptClear(base);
    NVIC_ClearPendingIRQ(RWC_ALARM_IRQn);
    NVIC_DisableIRQ(RWC_ALARM_IRQn);
}

/* Обработчик прерывания */
void RWC_ALARM_Handler(void)
{
    InterruptHandler(RWC_Secure);
    __DSB();
}

/* Сравнение значений времени */
uint32_t CompareTime(rtc_datetime_t t1, rtc_datetime_t t2)
{
    if (t1.year != t2.year)
        return 0;
    if (t1.month != t2.month)
        return 0;
    if (t1.day != t2.day)
        return 0;
    if (t1.hour != t2.hour)
        return 0;
    if (t1.minute != t2.minute)
        return 0;
    if (t1.second != t2.second)
        return 0;
    return 1;
}

int main()
{
    union rwc_union_reg ticks0, ticks1; /* Для хранения времени */
    int i; /* Количество записей */

    /* Инициализация BSP части */
    BOARD_InitAll();

    /* Код программы */

    /* Сброс и запрет прерываний */
    NVIC_ClearPendingIRQ(RWC_ALARM_IRQn);
    NVIC_DisableIRQ(RWC_ALARM_IRQn);
    RWC_EnableAlarmTimerInterruptFromDPD(RWC_Secure, 0);
    RWC_InterruptClear(RWC_Secure);

    /* Вывод информации о старте примера */
    printf("RWC example start\r\n");
    printf("SysClk = %ld\r\n", CLKCTR_GetSysClk(CLOCK_BASE));

    /* Получение конфигурации по умолчанию и инициализация таймера */
    RWC_GetDefaultConfig(&config);
    RWC_Init(RWC_Secure, config);

    /* Запись стартового времени */
    i = 0;
    while (1) {
        if (RWC_Status_Ok != RWC_SetDatetime(RWC_Secure, &start_time)) {
            printf("RWC_SetDatetime error\r\n");
            while (1);
        }
        if (RWC_Status_Ok != RWC_GetDatetime(RWC_Secure, &current_time)) {
            printf("RWC_GetDatetime error\r\n");
            while (1);
        }
        i++;
        if (CompareTime(start_time, current_time))
            break;
    }
    printf("Set Time Good %d\r\n", i);

    /* Запись времени будильника */
    if (RWC_Status_Ok != RWC_SetAlarm(RWC_Secure, &alarm_time)) {
        printf("RWC_SetAlarm error\r\n");
        while (1);
    }

    /* Настройка прерываний */
    RWC_EnableAlarmTimerInterruptFromDPD(RWC_Secure, 1);
    NVIC_ClearPendingIRQ(RWC_ALARM_IRQn);
    NVIC_EnableIRQ(RWC_ALARM_IRQn);

    /* Первоначальное получение времени разными способами */
    RWC_GetSecondsTimerCount(RWC_Secure, &ticks0.reg_value);
    printf("T: %lu\r\n", ticks0.reg_value);
    RWC_GetDatetime(RWC_Secure, &current_time);
    DisplayDatatime(current_time);
    /* Переодический вывод даты времени */
    while (flag) {
        /* Получение времени разными способами */
        RWC_GetSecondsTimerCount(RWC_Secure, &ticks1.reg_value);
        /* Проверка обновления времени - выводится только
           время отличное от предыдущего
        */
        if (ticks1.reg_value != ticks0.reg_value) {
            ticks0.reg_value = ticks1.reg_value;
            printf("T: %lu\r\n", ticks1.reg_value);
            RWC_GetDatetime(RWC_Secure, &current_time);
            DisplayDatatime(current_time);
        }
    }

    /* Вывод информации о завершении примера */
    printf("Timer example end\r\n");

    asm volatile("bkpt");
    return 0;
}
