# Обзор

Пример jtm-blocking демонстрирует работу блокирующих функций чтения параметров JTM.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

### Перечень аппаратного обеспечения для запуска теста

- кабель Type-C USB;
- плата ELIoT1m\_MO;
- персональный компьютер.

## Работа с программой

- добавить путь до **arm toolchain** в переменную **PATH**;
- вызвать скрипт **build.sh**;
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Подготовка к работе

### Процесс запуска на плате

1. Подключите плату.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими
   настройками:
   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.
3. Запустите программу с помощью gdb-отладчика.

## Вывод программы после запуска

При успешном запуске на терминале будет вывод:

```bash

JTM blocking reading example
============================

Temperature:   35.000 [OK]
V CASN:        1.285 [OK]
V CORE (VDDC): 0.918 [OK]

```
