/**
 * Copyright (c) 2021-2025, RnD Center «ELVEES», JSC
 * All rights reserved.
 * Contacts: https://elvees.ru, support@elvees.com
 *
 * Project:		SDK
 *
 * SPDX-License-Identifier: BSD-3-Clause
 *
 *
 * Разрешается повторное распространение и использование как в виде исходного кода, так и в объектном коде, 
 * с изменениями или без, при соблюдении следующих условий:
 * 
 * 1. При повторном распространении исходного кода должно оставаться указанное выше уведомление об авторском праве, 
 * этот список условий и последующий отказ от гарантий.
 * 2. При повторном распространении двоичного кода должна сохраняться указанная выше информация об авторском праве, 
 * этот список условий и последующий отказ от гарантий в документации и/или в других материалах, поставляемых при 
 * распространении.
 * 3. Ни название организации, ни имена её сотрудников не могут быть использованы в качестве поддержки или 
 * продвижения продуктов, основанных на этом ПО без предварительного письменного разрешения.
 * ЭТА ПРОГРАММА ПРЕДОСТАВЛЕНА ВЛАДЕЛЬЦАМИ АВТОРСКИХ ПРАВ И/ИЛИ ДРУГИМИ СТОРОНАМИ «КАК ОНА ЕСТЬ» 
 * БЕЗ КАКОГО-ЛИБО ВИДА ГАРАНТИЙ, ВЫРАЖЕННЫХ ЯВНО ИЛИ ПОДРАЗУМЕВАЕМЫХ, ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ИМИ, 
 * ПОДРАЗУМЕВАЕМЫЕ ГАРАНТИИ КОММЕРЧЕСКОЙ ЦЕННОСТИ И ПРИГОДНОСТИ ДЛЯ КОНКРЕТНОЙ ЦЕЛИ. НИ В КОЕМ СЛУЧАЕ 
 * НИ ОДИН ВЛАДЕЛЕЦ АВТОРСКИХ ПРАВ И НИ ОДНО ДРУГОЕ ЛИЦО, КОТОРОЕ МОЖЕТ ИЗМЕНЯТЬ И/ИЛИ ПОВТОРНО 
 * РАСПРОСТРАНЯТЬ ПРОГРАММУ, КАК БЫЛО СКАЗАНО ВЫШЕ, НЕ НЕСЁТ ОТВЕТСТВЕННОСТИ, ВКЛЮЧАЯ ЛЮБЫЕ ОБЩИЕ, 
 * СЛУЧАЙНЫЕ, СПЕЦИАЛЬНЫЕ ИЛИ ПОСЛЕДОВАВШИЕ УБЫТКИ, ВСЛЕДСТВИЕ ИСПОЛЬЗОВАНИЯ ИЛИ НЕВОЗМОЖНОСТИ ИСПОЛЬЗОВАНИЯ ПРОГРАММЫ 
 * (ВКЛЮЧАЯ, НО НЕ ОГРАНИЧИВАЯСЬ ПОТЕРЕЙ ДАННЫХ, ИЛИ ДАННЫМИ, СТАВШИМИ НЕПРАВИЛЬНЫМИ, ИЛИ ПОТЕРЯМИ, 
 * ПРИНЕСЕННЫМИ ИЗ-ЗА ВАС ИЛИ ТРЕТЬИХ ЛИЦ, ИЛИ ОТКАЗОМ ПРОГРАММЫ РАБОТАТЬ СОВМЕСТНО С ДРУГИМИ ПРОГРАММАМИ), 
 * ДАЖЕ ЕСЛИ ТАКОЙ ВЛАДЕЛЕЦ ИЛИ ДРУГОЕ ЛИЦО БЫЛИ ИЗВЕЩЕНЫ О ВОЗМОЖНОСТИ ТАКИХ УБЫТКОВ.
 *
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided 
 * that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions 
 * and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions 
 * and the following disclaimer in the documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse 
 * or promote products derived from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, 
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */




#include "eliot1_board.h"
#include "hal_i2c.h"
#include "i2c_flash_mem.h"

/* Flash I2C slave address */
#define SLAVE_ADDR   (0x54)
/* SCL line frequency */
#define I2C_BAUDRATE (100000U)
/* Test data */
#define DATA_BYTE    (10U)
/* Test address */
#define START_ADDR   (0x0U)

/* TX and RX buffer size */
#define BUFF_SIZE    (64U)

volatile i2c_status_t status;

uint8_t tx_data[BUFF_SIZE];
uint8_t rx_data[BUFF_SIZE];

int main()
{
    i2c_master_config_t master_cfg;

    I2C_Type *base = I2C0;

    uint8_t rx_buff;

    BOARD_InitAll();

    /* Установка выводов в функцию I2C. */
    GPIO_PinMode_Function(GPIO_I2C0_SCL, GPIO_ALT_FUNC_I2C_I2S);
    GPIO_PinMode_Function(GPIO_I2C0_SDA, GPIO_ALT_FUNC_I2C_I2S);

    /* Настройка подтяжек линий I2C. */
    GPIO_PinSet_PUPD(GPIO_I2C0_SCL, GPIO_PULL_UP);
    GPIO_PinSet_PUPD(GPIO_I2C0_SDA, GPIO_PULL_UP);

    printf("\x1b[2J\x1b[1;1H");
    printf("I2C EEPROM mem test started!\r\n\n");

    i2c_status_t status;

    I2C_MasterGetDefaultConfig(&master_cfg);
    master_cfg.baudrate_bps = I2C_BAUDRATE;

    status = I2C_MasterInit(base, &master_cfg, BOARD_SYSCLK_FREQ);

    if (status != I2C_Status_Ok) {
        printf("Failed to init I2C\r\n");
        return 1;
    }

    status = I2C_MasterAddrSet(base, SLAVE_ADDR, I2C_Address7Bit);

    if (status != I2C_Status_Ok) {
        printf("Failed to set slave address!\r\n\n");
        return 1;
    }

    printf("I2C Slave 0x%x write: Addr: 0x%x, Data: 0x%x\r\n",
        SLAVE_ADDR, START_ADDR, DATA_BYTE);
    status = I2C_FlashMemWriteByte(base, 0x0U, DATA_BYTE);

    BOARD_Udelay(50000);

    if (status != I2C_Status_Ok) {
        printf("Failed write!\r\n\n");
        asm volatile("bkpt");
        return 1;
    }

    printf("I2C Slave 0x%x read: Addr: 0x%x\r\n",
        SLAVE_ADDR, START_ADDR);
    status = I2C_FlashMemReadByte(base, START_ADDR, &rx_buff);

    if (status != I2C_Status_Ok) {
        printf("Failed read!\r\n\n");
        return 1;
    }

    if (rx_buff == DATA_BYTE) {
        printf("Writing and reading the byte successfully!\r\n\n");
    }

    for (uint32_t i = 0; i < BUFF_SIZE; i++) {
        tx_data[i] = i;
    }
    memset(rx_data, 0, sizeof(rx_data));

    printf("I2C Slave 0x%x write %d bytes: Addr: 0x%x\r\n",
        SLAVE_ADDR, sizeof(tx_data), START_ADDR);
    status = I2C_FlashMemWrite(base, START_ADDR, tx_data, sizeof(tx_data));

    if (status != I2C_Status_Ok) {
        printf("Write failed!\r\n\n");
        return 1;
    }

    BOARD_Udelay(50000);

    printf("I2C Slave 0x%x read %d bytes: Addr: 0x%x\r\n",
        SLAVE_ADDR, sizeof(rx_data), START_ADDR);
    status = I2C_FlashMemRead(base, START_ADDR, rx_data, sizeof(rx_data));

    if (status != I2C_Status_Ok) {
        printf("Read failed!\r\n\n");
        return 1;
    }

    for (uint32_t i = 0; i < BUFF_SIZE; i++) {
        if (tx_data[i] != rx_data[i]) {
            printf("Test failed!\r\n\n");
            return 1;
        }
    }

    printf("Writing and reading the page successfully!\r\n\n");
    printf("Test finished!\r\n\n");

    asm volatile("bkpt");
    return 0;
}
