# Обзор

Пример записи и чтения EEPROM через I2C.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

### Аппаратное обеспечение для запуска примера

- Type-C USB кабель;
- плата ELIOT1m\_MO;
- внешняя память I2C EEPROM microE объемом 256КБ;
- персональный компьютер.

## Работа с программой

- добавить путь до arm toolchain в переменную PATH;
- вызвать скрипт build.sh из каталога armgcc;
- выполнить команду 'arm-none-eabi-gdb-py -x eliot1.gdbinit' для загрузки
  программы на плату;
- запустить программу на исполнение с помощью gdb команды continue.

## Подготовка к работе

К выводам I2C (PD2, PD3) платы ELIOT1m_MO подключить внешний модуль I2C EEPROM.

## Процесс запуска на плате

1. Подключить плату.
2. Открыть последовательный терминал (пример Putty, Minicom) со следующими
   настройками:

   - скорость 115200 бод;
   - 8 бит данных;
   - нет паритета;
   - один стоповый бит;
   - нет контроля потока.

3. Запустить программу с помощью gdb-отладчика.

## Вывод программы после запуска

При успешном запуске будет отображаться на терминале:

```bash
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
I2C EEPROM mem test started!

I2C Slave 0x54 write: Addr: 0x0, Data: 0xa
I2C Slave 0x54 read: Addr: 0x0
Writing and reading the byte successfully!

I2C Slave 0x54 write 64 bytes: Addr: 0x0
I2C Slave 0x54 read 64 bytes: Addr: 0x0
Writing and reading the page successfully!

Test finished!
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
