# Обзор

Программа демонстрирует работу DMA в режиме одноблочной передачи типа
Память-Память.

## Описание программы

Пример настраивает DMA на одноблочную передачу, чтобы передать данные из одного
массива в другой. Ожидание проходит в бесконечном цикле до тех пор, пока DMA не
закончит транзакцию блока и не выдаст прерывание об окончании передачи.

## Необходимый Toolchain

- Embedded GCC ARM 10.3.1.

## Требования к аппаратному обеспечению для запуска примера

Перечень аппаратного обеспечения для запуска теста представлен ниже:

- Type-C USB кабель;
- плата ELIOT1m\_MO;
- персональный компьютер;
- переходник USB-UART.

## Работа с программой

- добавить путь до **arm toolchain** в переменную **PATH**;
- вызвать скрипт **build.sh**;
- выполнить команду `arm-none-eabi-gdb-py -x eliot1.gdbinit` для загрузки
  программы на плату;
- запустить программу на исполнение с помощью gdb команды `continue`.

## Настройки платы

Настройки пинов:

| Pin Name | Board Location |
| ------ | ------ |
| UART0_TXD | GPIO_PA0 / D1 |
| UART0_RXD | GPIO_PA1 / D0 |
| UART0_GND | GND |

## Подготовка к работе

Процесс запуска на плате.

1. Подключите плату.
2. Откройте последовательный терминал (пример Putty, Minicom) со следующими настройками:
    - скорость 115200 бод;
    - 8 бит данных;
    - нет паритета;
    - один стоповый бит;
    - нет контроля потока.
3. Запустите программу с помощью gdb-отладчика.

## Вывод программы после запуска

При успешном запуске на терминале сразу отразится вывод:

```bash
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
Test started...

DMA transfer was successful
Time of DMA transfer: 213 us
DMA speed: 76.901408 MB/s
Time of CPU transfer: 202 us
CPU speed: 81.089109 MB/s

Test finished
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
```
