ENTRY(___start)
OUTPUT_ARCH("elcore32")

MEMORY
{
    PRAM                  : ORIGIN = 0x2f00000, LENGTH = 64K   /* PRAM  */
    XYRAM                 : ORIGIN = 0x2e00000, LENGTH = 512K  /* XYRAM */
    LIBRARY_DDR           : ORIGIN = 0x20000000, LENGTH = 128K   /* DDR */
    DDR                   : ORIGIN = 0x40000000, LENGTH = 64K   /* DDR   */
}

SECTIONS {
   .text.libraries :
   {
     *libc.a:*(.text*)
     *libm.a:*(.text*)
     *libcrt.a:*(.text*)
   }  > LIBRARY_DDR

   .text :
   {
   *.*(.text)
	. = ALIGN (32 / 8);
   } > PRAM

   .eh_frame :
   {
      ___eh_frame_start = . ;
      *.*(.eh_frame);
      . = ALIGN (32 / 8);
      ___eh_frame_end = . ;
   } > XYRAM

   .data :
   {
   *.*(.data)
  /* Constructor and destructor tables are in ROM.  */
     ___CTOR_LIST__ = .;
     KEEP (*(.ctors .ctors.*))
     ___CTOR_END__ = .;
     ___DTOR_LIST__ = .;
     KEEP (*(.dtors dtors.*))
     ___DTOR_END__ = .;
    *.*(.rodata .rodata.*);
    *.*(.data.rel .data.rel.*);
    . = ALIGN (32 / 8);
   } > XYRAM

    .bss :
  {
    ___bss_start = . ;
    *(.sbss)
    *(.bss .bss.*);
    . = ALIGN (32 / 8);
      ___bss_end = . ;
  } > XYRAM

  .heap :
  {
    . += 10;
    /* to avoid perf leap in malloc */
    PROVIDE(_end = ALIGN(0x10000));
    __end = . ;

    PROVIDE(___stack = ORIGIN(DDR) + LENGTH(DDR) - 16);
  } > DDR
}
