#version 450

layout (set = 0, binding = 1) uniform texture2D textureColor;
layout (set = 0, binding = 2) uniform sampler samplers[3];

layout (location = 0) in vec2 inUV;
layout (location = 1) in float inLodBias;
layout (location = 2) in vec3 inNormal;
layout (location = 3) in vec3 inViewVec;
layout (location = 4) in vec3 inLightVec;

layout (binding = 0) uniform UBO 
{
	mat4 projection;
	mat4 view;
	mat4 model;
	vec4 viewPos;
	float lodBias;
	int samplerIndex;
} ubo;

layout (location = 0) out vec4 outFragColor;

void main() 
{
	vec4 color = texture(sampler2D(textureColor, samplers[ubo.samplerIndex]), inUV, inLodBias);

	vec3 N = normalize(inNormal);
	vec3 L = normalize(inLightVec);
	vec3 V = normalize(inViewVec);
	vec3 R = reflect(L, N);
	vec3 diffuse = max(dot(N, L), 0.65) * vec3(1.0);
	float specular = pow(max(dot(R, V), 0.0), 16.0) * color.a;
	outFragColor = vec4(diffuse * color.rgb + specular, 1.0);	
}