#!/bin/bash
#
# Copyright 2021 RnD Center "ELVEES", JSC
#
# This script restarts PLL3 in Media subsystem.
# UCG3 channel 5 uses for pixel clock purposes. But for correct working this
# clock must be same phase as real PIXCLK signal from UCG2 channel 2.
# If phases are very different and video does not work properly then we need to
# restart PLL3 to randomize clock phase.

OLD_PLL=$(devmem 0x1320030)
OLD_BP=$(devmem 0x1320200)

# All channels to bypass
devmem 0x1320200 32 0x1ff

# Disable PLL
devmem 0x1320030 32 0
sleep 0.1

# Restart PLL
devmem 0x1320030 32 $OLD_PLL
sleep 0.1

# Restore bypass settings
devmem 0x1320200 32 $OLD_BP
