#ifdef __ASSEMBLER__

/*
 * MIPS32 Coprocessor 0 register numbers
 */
#define C0_INDEX	$0
#define C0_INX		$0
#define C0_RANDOM	$1
#define C0_RAND		$1
#define C0_ENTRYLO0	$2
#define C0_TLBLO0	$2
#define C0_ENTRYLO1	$3
#define C0_TLBLO1	$3
#define C0_GLOBAL	$3,1
#define C0_CONTEXT	$4
#define C0_CTXT		$4
#define C0_CONTEXTCONF	$4,1
#define C0_USERLOCAL	$4,2
#define C0_XCONTEXTCONF	$4,3
#define C0_DEBUGCTXTID	$4,4
#define C0_PAGEMASK	$5
#define C0_PAGEGRAIN	$5,1
#define C0_SEGCTL0	$5,2
#define C0_SEGCTL1	$5,3
#define C0_SEGCTL2	$5,4
#define C0_PWBASE	$5,5
#define C0_PWFIELD	$5,6
#define C0_PWSIZE	$5,7
#define C0_WIRED	$6
#define C0_PWCTL	$6,6
#define C0_HWRENA	$7
#define C0_BADVADDR 	$8
#define C0_VADDR 	$8
#define C0_BADINSTR 	$8,1
#define C0_BADPINSTR 	$8,2
#define C0_COUNT 	$9
#define C0_ENTRYHI	$10
#define C0_TLBHI	$10
#define C0_COMPARE	$11
#define C0_STATUS	$12
#define C0_SR		$12
#define C0_INTCTL	$12,1
#define C0_SRSCTL	$12,2
#define C0_SRSMAP	$12,3
#define C0_CAUSE	$13
#define C0_CR		$13
#define C0_NESTEDEXC	$13,5
#define C0_EPC 		$14
#define C0_NEPC		$14,2
#define C0_PRID		$15
#define C0_EBASE	$15,1
#define C0_CDMMBASE	$15,2
#define C0_CMGCRBASE	$15,3
#define C0_BEVVA	$15,4
#define C0_CONFIG	$16
#define C0_CONFIG0	$16,0
#define C0_CONFIG1	$16,1
#define C0_CONFIG2	$16,2
#define C0_CONFIG3	$16,3
#define C0_CONFIG4	$16,4
#define C0_CONFIG5	$16,5
#define C0_LLADDR	$17
#define C0_MAAR		$17,1
#define C0_MAARI	$17,2
#define C0_WATCHLO	$18
#define C0_WATCHHI	$19
#define C0_XCONTEXT	$20
#define C0_DEBUG	$23
#define C0_TRACECONTROL	  $23,1
#define C0_TRACECONTROL2  $23,2
#define C0_USERTRACEDATA1 $23,3
#define C0_TRACEIBPC      $23,4
#define C0_TRACEDBPC      $23,5
#define C0_DEBUG2	  $23,6
#define C0_DEPC		  $24
#define C0_TRACECONTROL3  $24,2
#define C0_USERTRACEDATA2 $24,3
#define C0_PERFCNT	$25
#define C0_ERRCTL	$26
#define C0_CACHEERR	$27
#define C0_TAGLO	$28
#define C0_ITAGLO	$28
#define C0_DTAGLO	$28,2
#define C0_TAGLO2	$28,4
#define C0_DATALO	$28,1
#define C0_IDATALO	$28,1
#define C0_DDATALO	$28,3
#define C0_DATALO2	$28,5
#define C0_TAGHI	$29
#define C0_ITAGHI	$29
#define C0_DTAGHI	$29,2
#define C0_DATAHI	$29,1
#define C0_IDATAHI	$29,1
#define C0_DDATAHI	$29,3
#define C0_ERRPC	$30
#define C0_DESAVE	$31
#define C0_KSCRATCH1	$31,2
#define C0_KSCRATCH2	$31,3
#define C0_KSCRATCH3	$31,4
#define C0_KSCRATCH4	$31,5
#define C0_KSCRATCH5	$31,6
#define C0_KSCRATCH6	$31,7

#else

/*
 * MIPS32 Coprocessor 0 register encodings for C use.
 * These encodings are implementation specific.
 */
#define C0_INDEX		0
#define C0_INX			0
#define C0_RANDOM		1
#define C0_RAND			1
#define C0_ENTRYLO0		2
#define C0_TLBLO0		2
#define C0_ENTRYLO1		3
#define C0_TLBLO1		3
#define C0_GLOBAL		0x103
#define C0_CONTEXT		4
#define C0_CTXT			4
#define C0_CONTEXTCONF		0x104
#define C0_USERLOCAL		0x204
#define C0_XCONTEXTCONF		0x304
#define C0_DEBUGCTXTID		0x404
#define C0_PAGEMASK		5
#define C0_PAGEGRAIN		0x105
#define C0_SEGCTL0		0x205
#define C0_SEGCTL1		0x305
#define C0_SEGCTL2		0x405
#define C0_PWBASE		0x505
#define C0_PWFIELD		0x605
#define C0_PWSIZE		0x705
#define C0_WIRED		6
#define C0_PWCTL		0x606
#define C0_HWRENA		7
#define C0_BADVADDR		8
#define C0_VADDR		8
#define C0_BADINSTR		0x108
#define C0_BADINSTRP		0x208
#define C0_COUNT		9
#define C0_ENTRYHI		10
#define C0_TLBHI		10
#define C0_COMPARE		11
#define C0_STATUS		12
#define C0_SR			12
#define C0_INTCTL		0x10C
#define C0_SRSCTL		0x20C
#define C0_SRSMAP		0x30C
#define C0_CAUSE		13
#define C0_CR			13
#define C0_NESTEDEXC		0x50D
#define C0_EPC 			14
#define C0_NEPC			0x20E
#define C0_PRID			15
#define C0_EBASE		0x10F
#define C0_CDMMBASE		0x20F
#define C0_CMGCRBASE		0x30F
#define C0_BEVVA		0x40F
#define C0_CONFIG		16
#define C0_CONFIG0		16
#define C0_CONFIG1		0x110
#define C0_CONFIG2		0x210
#define C0_CONFIG3		0x310
#define C0_CONFIG4		0x410
#define C0_CONFIG5		0x510
#define C0_LLADDR		17
#define C0_MAAR			0x111
#define C0_MAARI		0x111
#define C0_WATCHLO		18
#define C0_WATCHHI		19
#define C0_XCONTEXT		20
#define C0_DEBUG		23
#define C0_TRACECONTROL		0x117
#define C0_TRACECONTROL2	0x217
#define C0_USERTRACEDATA1	0x317
#define C0_TRACEIBPC		0x417
#define C0_TRACEDBPC		0x517
#define C0_DEBUG2		0x617
#define C0_DEPC	  		24
#define C0_TRACECONTROL3	0x218
#define C0_USERTRACEDATA2	0x318
#define C0_PERFCNT		25
#define C0_ERRCTL		26
#define C0_CACHEERR		27
#define C0_TAGLO		28
#define C0_ITAGLO		28
#define C0_DTAGLO		0x21C
#define C0_TAGLO2		0x41C
#define C0_DATALO		0x11C
#define C0_IDATALO		0x11C
#define C0_DDATALO		0x31C
#define C0_DATALO2		0x51C
#define C0_TAGHI		29
#define C0_ITAGHI		29
#define C0_DTAGHI		0x21D
#define C0_DATAHI		0x11D
#define C0_IDATAHI		0x11D
#define C0_DDATAHI		0x31D
#define C0_ERRPC		30
#define C0_DESAVE		31
#define C0_KSCRATCH1		0x21F
#define C0_KSCRATCH2		0x31F
#define C0_KSCRATCH3		0x41F
#define C0_KSCRATCH4		0x51F
#define C0_KSCRATCH5		0x61F
#define C0_KSCRATCH6		0x71F

/*
 * Define macros for accessing the MIPS32 coprocessor 0 registers.
 * These macros take an encoded (register, select) combination,
 * so they can use the textual names above.
 */

#define mips32_get_c0(selreg) \
__extension__ ({ \
  register unsigned long __r; \
  __asm__ __volatile ("mfc0 %0,$%1,%2" \
		      : "=d" (__r) \
		      : "JK" (selreg & 0x1F), "JK" (selreg >> 8)); \
  __r; \
})

#define mips32_set_c0(selreg, val) \
do { \
    __asm__ __volatile (".set push \n"\
			".set noreorder\n"\
			"mtc0 %z0,$%1,%2\n"\
			"ehb\n" \
			".set pop" \
			: \
			: "dJ" ((uint32_t)(val)), "JK" (selreg & 0x1F),\
			  "JK" (selreg >> 8) \
			: "memory"); \
} while (0)

#define mips_ehb()		\
  ({__asm__ volatile ("\t ehb \n");})

#define mips_tlbwi()	\
  ({__asm__ volatile ("\t tlbwi \n");})

#endif
