# Программа **otpcreatorext** #

## Описание программы ##

Программа **otpcreatorext** предназначена для генерации образов **otp** памяти с возможностью записать в них хеши отозванных сертификатов.  
Образы генерируются на основе конфигурационных файлов.

## Параметры командной строки: ##
* `-h / --help` - вывести информацию о параметрах командной строки.
* `-i <path_to_file>` - путь ко входному конфигурационному файлу.
* `-o <path_to_file>` - путь к выходному файлу-образу **otp** памяти.

## Параметры конфигурационного файла: ##
* `force_sign=<1/0>` - при выставленной `1` загруаемые образы и ключ шифрования обязательно должны быть подписаны.
* `force_encrypt=<1/0>` - при выставленной `1` загруаемые образы обязательно должны быть зашифрованны.
* `disable_log=<1/0>` - при выставленной `1` запрещается вывод информации в UART0.
* `enable_watchdog=<1/0>` - при выставленной `1` включается watchdog.
* `device_unique_key=<0x...>` - число (128 бит), используемое для генерации ключа шифрования в бутроме.
* `device_serial_number=<0x...>` - число (32 бита), используемое для генерации ключа шифрования в бутроме.
* `path_to_root_cert=<path_to_file>` - путь к корневому сертификату.
* `path_to_revoked_cert=<path_to_file>` - путь к отозванному сертификату (максимум 8 сертификатов).

## Пример вызова: ##
```
./otpcreatorext -i otp.cfg -o otp.bin
```

## Особенности: ##
- В путях к файлам нельзя использовать символ пробел.
- Файлы сертификатов должны быть в **.der** формате.
- Пути к файлам в конфигурационном файле должны задаваться относительно рабочей директории программы **otpcreatorext**.
- Строки в конфигурационном файле, начинающиеся со знака `#`, являются комментариями.

## Пример файла конфигурации: ##
```
force_sign=1
force_encrypt=1
disable_log=0
enable_watchdog=0
device_unique_key=0x112233445566aabbccddff9988776622
device_serial_number=0x11223344
path_to_root_cert=./cert_chain/chain3/cert_ROOT.der
path_to_revoked_cert=./cert_chain/chain3/cert_A.der
path_to_revoked_cert=./cert_chain/chain3/cert_B.der
```
