# Программа **mksbimage** #

## Описание программы ##

Программа **mksbimage** предназначена для генерации загружаемых образов **SBIMG**.

## Параметры командной строки: ##
 * `-i / --input-config <path_to_config_file>` - путь к входному файлу конфигурации
 * `-o / --output-sbimage <path_to_out_file>` - путь к выходному файлу-образу
 * `-h / --help` - вывести информацию о параметрах командной строки
 * `-w` - отключить предупреждения о невыровненных размерах загружаемых программ

Параметры генерации образа указываются в **конфигурационном файле**.

## Параметры конфигурационного файла: ##
* `path_to_bin=<path>` - путь к **загружаемой программе**
* `path_to_bin_part=<path> <load_addr> <entry_addr/no_exec> <bin_part_id>` - ***path*** - путь к части загружаемой программы; ***load_addr*** - адрес загрузки программы; ***entry_addr/no_exec*** - адрес точки входа в программу или флаг `no_exec`, если не нужно исполнять программу; ***bin_part_id*** - id части загружаемой программы (можно не указывать, если не нужно их подписывать)
<!-- -->
* `load_address=<0x...>` - адрес загрузки программы
* `entry_address=<0x...>` - адрес точки входа в программу
<!-- -->
*Для того, чтобы **загружаемая программа** была **зашифрована**, нужно задать следующие параметры:*
* `encryption_key=<0x...>` - ключ (128 бит) для шифрования **загружаемой программы**
* `number_of_key=<N>` - номер (берутся младшие 16 бит от 32 битного числа) ключа для шифрования `encryption_key`
* `device_unique_key=<0x...>` - **DUK** (128 бит) из соответствующего **otp** образа для шифрования `encryption_key`
* `device_serial_number=<0x...>` - **DSN** (32 бита) из соответствующего **otp** образа для шифрования `encryption_key`
<!-- -->
*Для того, чтобы **загружаемая программа** была **подписана**, нужно задать следующие параметры:*
* `path_to_root_cert=<path>` - путь к корневому сертификату
* `root_cert_id=<N>` - номер корневого сертификата
* `path_to_cert=<path> <self_id> <signed_id>` - ***path*** - путь к не корневому сертификату; ***self_id*** - id этого сертификата; ***signed_id*** - id сертификата, которым подписан этот сертификат
* `payload_cert_id=<N>` - номер сертификата, которым подписана **загружаемая программа**
* `path_to_payload_key=<path>` - путь к приватному ключу для подписи **загружаемой программы**
* `key_cert_id=<N>` - номер сертификата, которым подписан ключ шифрования
* `path_to_encryption_key=<path>` - путь к приватному ключу для подписи ключа шифрования
* `sign_bin_part=<path> <cert_id> <bin_part_id>` - ***path*** - путь к приватному ключу для подписи части загружаемой программы; ***cert_id*** - id сертификата, который соответствует приватному ключу; ***bin_part_id*** - id части загружаемой программы, которую необходимо подписать
<!-- -->
* `check_payload_hash=<1/0>` - вычисление **SHA256** хеша **загружаемой программы** при отсутствии подписи (`0` — выключено, `1` - включено)
* `check_encrypted_payload_integrity=<1/0>` - если флаг установлен в `1`, то вычисление **SHA256** хеша, или вычисление подписи будет проводиться для зашифрованной **загружаемой программы**; если флаг установлен в `0`, то вычисление **SHA256** хеша, или вычисление подписи будет проводиться для **не** зашифрованной **загружаемой программы**
* `skip_header_hash=<1/0>` - пропуск вычисления **SHA256** хеша в режиме работы бутрома `bs_en=0` (`0` — не пропускать, `1` - пропускать).
<!-- -->

## Особенности: ##
- В путях к файлам нельзя использовать символ пробел
- Файлы сертификатов и приватных ключей должны быть в **.der** формате
- Пути к файлам в конфигурационном файле должны задаваться относительно рабочей директории программы **mksbimage**
- Строки в конфигурационном файле, начинающиеся со знака `#`, являются комментариями
- Части загружаемой программы будут загружаться в той последовательности, в какой они встретились в конфигурационном файле. ***path_to_bin*** - всегда будет последним.
- Все номера (**id**) не должны быть равны нулю (**0**)

## Пример файла конфигурации: ##
```
# [CRAM]
path_to_bin=./cram.bin
path_to_bin_part=./cram.bin 0xb0000000 0xb0000000 3
path_to_bin_part=./cram.bin 0xb0000000 no_exec 5

# [ADDR]
load_address=0xb0000000
entry_address=0xb0000000

# [ENCRYPTION]
encryption_key=0x000102030405060708090a0b0c0d0e0f
number_of_key=2
device_unique_key=0x000102030405060708090a0b0c0d0e0f
device_serial_number=0x00010203

# [SIGNATURE]
path_to_root_cert=./rootCA.der
root_cert_id=1
path_to_cert=./cert1.der 5 1
path_to_cert=./cert2.der 7 5
payload_cert_id=7
path_to_payload_key=./cert2key.der
key_cert_id=5
path_to_encryption_key=./cert1key.der
sign_bin_part=cert1_key.der 5 3
sign_bin_part=cert1_key.der 5 5

# [CHECKSUM]
check_payload_hash=1
check_encrypted_payload_integrity=0
skip_header_hash=0
```
