#!/home/zuulbot/src/gerrit.elvees.com/mcom03/buildroot/buildroot/output/host/bin/python2.7

import sys
import os
import getopt
from distutils import sysconfig

valid_opts = ['prefix', 'exec-prefix', 'includes', 'libs', 'cflags',
              'ldflags', 'help']

def exit_with_usage(code=1):
    print >>sys.stderr, "Usage: %s [%s]" % (sys.argv[0],
                                            '|'.join('--'+opt for opt in valid_opts))
    sys.exit(code)

try:
    opts, args = getopt.getopt(sys.argv[1:], '', valid_opts)
except getopt.error:
    exit_with_usage()

if not opts:
    exit_with_usage()

pyver = sysconfig.get_config_var('VERSION')
getvar = sysconfig.get_config_var

opt_flags = [flag for (flag, val) in opts]

if '--help' in opt_flags:
    exit_with_usage(code=0)

for opt in opt_flags:
    if opt == '--prefix':
        print sysconfig.PREFIX

    elif opt == '--exec-prefix':
        print sysconfig.EXEC_PREFIX

    elif opt in ('--includes', '--cflags'):
        flags = ['-I' + sysconfig.get_python_inc(),
                 '-I' + sysconfig.get_python_inc(plat_specific=True)]
        if opt == '--cflags':
            flags.extend(getvar('CFLAGS').split())
        print ' '.join(flags)

    elif opt in ('--libs', '--ldflags'):
        libs = ['-lpython' + pyver]
        libs += getvar('LIBS').split()
        libs += getvar('SYSLIBS').split()
        # add the prefix/lib/pythonX.Y/config dir, but only if there is no
        # shared library in prefix/lib/.
        if opt == '--ldflags':
            if not getvar('Py_ENABLE_SHARED'):
                libs.insert(0, '-L' + getvar('LIBPL'))
            if not getvar('PYTHONFRAMEWORK'):
                libs.extend(getvar('LINKFORSHARED').split())
        print ' '.join(libs)

